
/*! stargate-webui - v1.1.0 - 2014-02-18 01-02-43 */

var swc = {
    "base": {},
    "views": {},
    "models": {},
    "constructors": {},
    "settings": {
        "application": {},
        "rest": {}
    }
};

swc.Utils = {

    /**
     * Format IPv6 address to short form:
     *
     * @description
     *
     *  one or more leading zeroes from any groups of hexadecimal digits MUST be removed;
     *  consecutive sections of zeroes MUST be replaced with a double colon ( :: ).
     *
     * @param address {String}
     *
     * @returns {String}
     */
    formatIPv6Address: function (address) {
        return address ? address.replace(/\b0+/g, "").replace(/:{2,}/g, "::") : '';
    },

    /**
     * @function: getBytesWithUnit()
     * @purpose: Converts bytes to the most simplified unit.
     * @param: (number) bytes, the amount of bytes
     * @returns: (string)
     */
    getBytesWithUnit: function (bytes) {
        if( isNaN( bytes ) ){ return; }
        var units = [ ' bytes', ' KB', ' MB', ' GB', ' TB', ' PB', ' EB', ' ZB', ' YB' ];
        var amountOf2s = Math.floor( Math.log( +bytes )/Math.log(2) );
        if( amountOf2s < 1 ){
            amountOf2s = 0;
        }
        var i = Math.floor( amountOf2s / 10 );
        bytes = +bytes / Math.pow( 2, 10*i );

        // Rounds to 3 decimals places.
        if( bytes.toString().length > bytes.toFixed(2).toString().length ){
            bytes = bytes.toFixed(2);
        }

        return bytes + units[i];
    },

    getIEVersion: function () {
        // Returns the version of Internet Explorer or 0
        // (indicating the use of another browser).
    
        var rv = 0; // Return value assumes failure.
        if (navigator.appName === 'Microsoft Internet Explorer')
        {
            var ua = navigator.userAgent;
            var re  =  /MSIE (\d+(?:\.\d+)?)/;
            if (re.exec(ua) !== null){
                rv = parseFloat( RegExp.$1 );
            }
        }
    
        return rv;
    },


    /**
     * Check if childArr contains all values from parentArr
     * @param parentArr array
     * @param childArr array
     */
    containsArray: function (parentArr, childArr) {
        var contains = true;
        _.each(parentArr, function(value){
            if(!_.contains(childArr, value)){
                contains = false;
            }
        });
    
        return contains;
    },

    /**
     * Convert values Value => Element Key map to values
     *
     * @param map {Object}
     * @param data {Object} page elements
     *
     * @returns {*}
     */
    getDataToValidate: function(map, data) {
        var values = {};

        _.each(data, function(elementMap, key) {
            _.each(map, function(value, id) {
                if (!_.isUndefined(value.elementName)) {
                    if (elementMap.parameterName === value.elementName) {
                        if (!_.isUndefined(value.elementClass)) {
                            if (_.indexOf(elementMap.parameterClasses, value.elementClass) !== -1) {
                                values[id] = elementMap.parameterValue;
                            }
                        } else {
                            values[id] = elementMap.parameterValue;
                        }
                    }
                }
            });
        });

        return values;
    },

    /**
     * is used because doublequotes break NP response format in some calls (PF, IPv6).
     */
    generateId: function () {
        return _.uniqueId((new Date().getTime()) + "_");
    }
};

// We have to disable cache completely
$.ajaxSetup({
    cache: false
});

$(document).ready(function() {

    $.getJSON("/static/settings/application.json", {}, function(response){
            swc.settings.application = new Backbone.Model();
            swc.settings.application.set(response);
        
            // This setting should be the same as currently used domain,
            // that is why fixing it here to not dig through all application where we do redirect,
            // i.e. Reboot / Restore Config / Upgrade, etc
            swc.settings.application.set("url", window.location.origin);

            // Clone application dispatcher from Backbone events:
            swc.constructors.dispatcher = _.clone(Backbone.Events);
    
            // Init main application model
            swc.models.Application = new swc.constructors.ApplicationModel();

            // Execute IE fixes
            if (swc.Utils.getIEVersion() === 8) {
                $.get('/application/ie8.css', function(data) {
                    var css = data,
                        head = document.getElementsByTagName('head')[0],
                        style = document.createElement('style');

                    style.type = 'text/css';

                    if (style.styleSheet) {
                        style.styleSheet.cssText = css;
                    } else {
                        style.appendChild(document.createTextNode(css));
                    }

                    head.appendChild(style);
                });

                $.get('/application/ie8.fix.js');
            }

            if (swc.Utils.getIEVersion() >= 1 && swc.Utils.getIEVersion() <= 7) {
                alert('Your Internet Explorer browser is too old. Please, upgrade it to 8th version or newer.');
            }
        });
});
;var SWCElements = {

    /**
     * Custom swc checkboxes
     */
    checkbox:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-checkbox',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        /**
         * Init all custom checkboxes on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.prevent-click, .disabled)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-checkbox:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a checkbox:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className),
                state = checkBox.data('value');

            if (state) {
                checkBox.removeClass(this.activeClassName);
            } else {
                checkBox.addClass(this.activeClassName);
            }

            checkBox.data('value', !state);
            checkBox.trigger('swc-checkbox:change', !state);
        },

        /**
         * Trigger application changes on a checkbox:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            if (value) {
                checkBox.addClass(this.activeClassName);
            } else {
                checkBox.removeClass(this.activeClassName);
            }

            checkBox.data('value', value);
        }
    },

    /**
     * Custom swc checkbox with one additional position
     */
    checkboxExtended:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-extended',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        partlyClassName: 'partly',

        /**
         * Init all custom checkboxes on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.prevent-click)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-extended:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a checkbox:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className),
                state = checkBox.data('value'),
                result = state,
                extend = checkBox.hasClass('partly');

            checkBox.removeClass(this.activeClassName);

            if (state || extend) {
                result = false;
            } else {
                checkBox.addClass(this.activeClassName);
                result = true;
            }


            checkBox.data('value', result);
            checkBox.trigger('swc-checkbox:change', result);
        },

        /**
         * Trigger application changes on a checkbox:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var checkBox = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            checkBox.removeClass(this.activeClassName).removeClass(this.partlyClassName);

            if (value === "partly") {
                checkBox.addClass(this.partlyClassName);
            } else if(value) {
                checkBox.addClass(this.activeClassName);
            }

            checkBox.data('value', value);
        }
    },

    /**
     * Custom ON-OFF switcher
     */
    switcher:  {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-switcher',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'checked',

        /**
         * Current element width:
         *
         * @param activeClassName {String}
         *
         */
        switcherWidth: 40,

        /**
         * Init all custom switchers on the page:
         */
        initAll: function() {
            var self = this, preventClick = false;

            $('body')
                .on('click', '.' + this.className + ' .switcher-container', function(e) {
                    if(!preventClick){
                        self.triggerChange($(e.target));
                    }
                })
                .on('swc-switcher:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                })
                .on('mousedown', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    element.data('switch', true);
                    element.data('mouseOffset', e.pageX);
                    element.data('isChecked', element.closest('.'+self.className).hasClass(self.activeClassName));
                })
                .on('mouseup', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        element.data('switch', false);
                        stopModify(element.closest('.switcher-container').find('.container'));
                    }
                })
                .on('mouseleave', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        element.data('switch', false);
                        stopModify(element.closest('.switcher-container').find('.container'));
                    }
                })
                .on('mousemove', '.' + this.className + ' .btn', function(e) {
                    var element = $(this);
                    if(element.data('switch')){
                        preventClick = true;
                        var alpha = +element.data('mouseOffset') - e.pageX;
                        var containerPosition = +element.closest('.switcher-container').find('.container').css('right').replace('px','');
                        if(containerPosition+alpha>=0 && containerPosition+alpha<=40){
                            element.closest('.switcher-container').find('.container').css({
                                'right': '+='+alpha+'px'
                            });
                            element.closest('.switcher-container').find('.btn').css({
                                'right': '+='+alpha+'px'
                            });
                            element.data('mouseOffset', e.pageX);
                        }
                    }
                });
            var stopModify = function(element){
                /**
                 * prevents 'click' event execution
                 */
                setTimeout(function(){preventClick = false;}, 10);
                var containerPosition = +element.css('right').replace('px',''),
                    switcher = element.closest('.'+self.className),
                    newState = true;

                if(containerPosition>19){
                    newState = false;
                }
                self.customChange(element, newState);
                var stateWasChanged = (newState !== element.closest('.'+self.className).find('.btn').data('isChecked'));
                if(stateWasChanged){
                    switcher.trigger('swc-switcher:change', newState);
                }
            };
        },

        /**
         * Trigger user changes on a switcher:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var switcher = element.hasClass(this.className) ? element : element.closest("." + this.className),
                state = switcher.data('value');

            if (!state) {
                switcher.addClass(this.activeClassName);
                switcher.find('.container').animate({'right': '0px'}, 100);
                switcher.find('.btn').animate({'right': '0px'}, 100);
            } else {
                switcher.removeClass(this.activeClassName);
                switcher.find('.container').animate({'right': '38px'}, 100);
                switcher.find('.btn').animate({'right': '40px'}, 100);
            }

            switcher.data('value', !state);
            switcher.trigger('swc-switcher:change', !state);
        },

        /**
         * Trigger application changes on a switcher:
         *
         * @param element {Object}
         *
         */
        customChange: function(element, value) {
            var switcher = element.hasClass(this.className) ? element : element.closest("." + this.className);

            if (value) {
                switcher.addClass(this.activeClassName);
                switcher.find('.container').animate({'right': '0px'}, 100);
                switcher.find('.btn').animate({'right': '0px'}, 100);
            } else {
                switcher.removeClass(this.activeClassName);
                switcher.find('.container').animate({'right': '38px'}, 100);
                switcher.find('.btn').animate({'right': '40px'}, 100);
            }

            switcher.data('value', value);

        }
    },

    /**
     * Custom swc radio buttons
     */
    radioButton: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-radio-buttons',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'active',

        /**
         * Init all custom radio buttons on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.disabled) .mode:not(.disabled)', function(e) {
                    self.triggerChange($(e.target));
                })
                .on('swc-radio-buttons:swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger user changes on a radio button:
         *
         * @param element {Object}
         * @param fireEvent {Boolean}
         *
         */
        triggerChange: function(element) {
            var mode = element.hasClass('.mode') ? element : element.closest('.mode'),
                radioGroup = mode.closest('.' + this.className);

            // Do nothing if clicking on active radio button
            if (mode.hasClass('active')) {
                return;
            }

            // Remove active class from previous mode
            radioGroup.find('.mode').removeClass('active');

            // Set active class to current button
            mode.addClass('active');

            // Set radioGroup group value
            radioGroup.data('value', mode.data('value'));
            radioGroup.trigger('swc-radio-buttons:change', mode.data('value'));
        },

        /**
         * Trigger application changes on a radio button:
         *
         * @param button {Object}
         *
         */
        customChange: function(element, value) {
            var radioGroup = element.hasClass(this.className) ? element : element.closest('.' + this.className);

            // Remove active class from previous mode
            radioGroup.find('.mode').removeClass('active');

            // Set active class to current button
            radioGroup.find('.mode[data-value="' + value + '"]').addClass('active');

            radioGroup.data('value', value);
        }

    },

    /**
     * Custom swc drop downs
     */
    dropDown: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'swc-dropdown',

        /**
         * Current element overlay class name:
         *
         * @param classNameOverlay {String}
         *
         */
        classNameOverlay: 'swc-dropdown-overlay',

        /**
         * Set element type to be handled correctly
         */
        type: 'absolute-position',

        /**
         * Current element tag name:
         *
         * @param tagName {String}
         *
         */
        tagName: 'div',

        /**
         * Current element hidden tag name:
         *
         * @param hiddenField {String}
         *
         */
        hiddenField: 'input',

        /**
         * Current element active class name:
         *
         * @param activeClassName {String}
         *
         */
        activeClassName: 'selected',

        /**
         * Init all custom elements on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ':not(.disabled)', function(e) {
                    SWCElements.global.closeAll(self.className);
                    self.open($(e.target));
                    e.stopPropagation();
                })
                .on('click', '.' + this.classNameOverlay + ' .option.selected', function(e) {
                    self.close($(e.target));
                    e.stopPropagation();
                })
                .on('click', '.' + this.classNameOverlay + ' .option:not(.selected)', function(e) {
                    self.change($(e.target));
                    e.stopPropagation();
                })
                .on(this.className + ':swc-change', '.' + this.className, function(e, value) {
                    self.customChange($(e.target), value);
                });
        },

        /**
         * Trigger drop down open:
         *
         * @param element {Object}
         *
         */
        open: function(element) {
            var dropDown = element.hasClass(this.className) ? element : element.closest("." + this.className),
                className = dropDown.data('class'),
                hideDefault = dropDown.data('hide-default'),
                options = dropDown.data('options'),
                selected = dropDown.data('selected'),
                selectedDefault = selected,
                position = dropDown.offset(),
                width = dropDown.innerWidth(),
                value = dropDown.data('value'),
                // This additional width needed to handle scrollbar which appears when option list is not empty
                additionalWidth = getObjectLength(options) > 5 ? 20 : 0,
                template = $.template("swc-dropdown", swc.Templates.get("swc-dropdown").get('content')),
                optionList = [], // support for option list as array
                selectedOption;

            // Remove existing dropdowns
            if ($('.' + this.classNameOverlay).size()) {
                this.closeAll();
            }

            // Hide native dropdown:
            dropDown.css('visibility', 'hidden');
            
            if (!selected) {
                selectedDefault = dropDown.find('.selected-option').text();
            }
            
            // Correct behaviour: options should be an array of objects,
            // so for backward compatibility we add this processor here
            if (_.isArray(options)) {
                optionList = options;
                selectedOption = _.findWhere(optionList, {value: selected + ""});
            } else {
                if (selected) {
                    selectedOption = {
                        value: selected,
                        name: options[selected].name,
                        additionalLabel: options[selected].additionalLabel
                    };
                }
            }
            
            // Append element to body
            $('body').append(
                $.tmpl(template, {
                        className: className,
                        options: options,
                        optionList: optionList.length > 0 ? optionList : null,
                        hideDefault: hideDefault,
                        selectedDefault: selectedDefault,
                        selectedOption: selectedOption
                    }
                )
            );
            
            // Set element position and width
            $('.' + this.classNameOverlay).css({
                'top': position.top + 'px',
                'left': position.left + 'px',
                'width': width + additionalWidth
            });

            $('body').trigger('swc-dropdown:opened', [{'$dropDown': $('.' + this.classNameOverlay)}]);
        },

        /**
         * Trigger dropdown change event:
         *
         * @param element
         *
         */
        change: function(element) {
            var dropDownOverlay = element.hasClass(this.classNameOverlay) ?
                    element :
                    element.closest('.' + this.classNameOverlay),
                className = dropDownOverlay.data('class'),
                dropDown = $('.swc-dropdown[data-class="' + className + '"]'),
                option = $(element).hasClass('option') ? $(element) : $(element).closest('.option'),
                value = option.data('value');
            
            this.renderSelectedOption(element, dropDown);

            // Trigger change event:
            dropDown.trigger('swc-dropdown:change', value);

            this.close(element);
        },

        /**
         * Trigger dropdown application change:
         *
         * @param element
         * @param value
         */
        customChange: function(element, key) {
            var dropDown = element.hasClass(this.className) ? element : element.closest("." + this.className);

            // Update data and Insert new value to visible part of dropdown
            this.renderSelectedOption(element, dropDown, key);
        },

        /**
         * Update data and Insert new value to visible part of dropdown
         * 
         * @param element {DOMElement} on which event was triggered
         * @param dropDown {swcElements.Dropdown} element
         * @param selectedValue {String} - optional, only used when triggered by custom change.
         */
        renderSelectedOption: function (element, dropDown, selectedValue) {
            var optionTemplate = $.template("swc-select-option", swc.Templates.get("swc-select-option").get('content')),
                options = dropDown.data('options'),
                option = $(element).hasClass('option') ? $(element) : $(element).closest('.option'),
                selectedOption;

            // Update data and Insert new value to visible part of dropdown
            if (options) {
                if (_.isArray(options)) {
                    // NOTE: `findWhere` can't compare String and Number correctly,
                    // but sometimes {selectedOption.value} is a digit, thus we appending an empty string to it
                    selectedOption = _.findWhere(options,
                        { value: (!_.isUndefined(selectedValue) ? selectedValue : option.data('value')) + "" }
                    );
                } else {
                    if (selectedValue && options[selectedValue]) {
                        selectedOption = {
                            "value": options[selectedValue].value,
                            "name": options[selectedValue].name,
                            "additionalLabel": options[selectedValue].additionalLabel
                        }
                    } else if(options[option.data('key')]) {
                        selectedOption = {
                            "value": options[option.data('key')].value,
                            "name": options[option.data('key')].name,
                            "additionalLabel": options[option.data('key')].additionalLabel
                        }
                    }
                }

                // Update dropdown element (a kind of "selectbox") with selected data/value
                if (selectedOption) {
                    var previousValue = dropDown.data('value');

                    if (!_.isUndefined(previousValue)) {
                        dropDown.data('previous-value', previousValue);
                    } else {
                        dropDown.data('previous-value', selectedOption.value);
                    }

                    dropDown.data('selected', selectedOption.value);
                    dropDown.data('value', selectedOption.value);

                    dropDown.find('.selected-option').html(
                        $.tmpl(optionTemplate, { selectedOption: selectedOption })
                    );
                }
            }
        },

        /**
         * Trigger dropdown overlay to be closed
         *
         * @param element
         */
        close: function(element) {
            var dropDownOverlay = element.hasClass(this.classNameOverlay) ?
                    element :
                    element.closest('.' + this.classNameOverlay),
                className = dropDownOverlay.data('class'),
                dropDown = $('.swc-dropdown[data-class="' + className + '"]');

            // Remove dropdown overlay:
            if (dropDownOverlay.size()) {
                dropDownOverlay.remove();
            }

            // Show dropdown if exists:
            if (dropDown.size()) {
                dropDown.css('visibility', 'visible');
            }
        },

        /**
         * Close all dropdowns on the page:
         */
        closeAll: function() {
            var self = this;

            $.each($('.' + this.classNameOverlay), function(key, element) {
                self.close($(element));
            });
        }
    },

    expandableList: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'expandable-list',

        /**
         * Current element item class name:
         *
         * @param itemClassName {String}
         *
         */
        itemClassName: 'expandable-list-item',

        /**
         * Current element item hidden class name:
         *
         * @param itemHiddenClassName {String}
         *
         */
        itemHiddenClassName: 'list-item-hidden',

        /**
         * Current element tag name:
         *
         * @param tagName {String}
         *
         */
        tagName: 'div',

        /**
         * Init all custom elements on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className + ' .show-hidden', function(e) {
                    self.setSelected($(e.target));
                })
                .on('click', '.' + this.className + ' .do-edit:not(.disabled)', function(e) {
                    self.setStateEdit($(e.target), {user: true, undo: false});
                })
                .on('click', '.' + this.className + ' .do-edit.active-edit', function(e) {
                    self.setStateEdit($(e.target), {user: true, undo: true});
                })
                .on('click', '.' + this.className + ' .do-delete:not(.disabled)', function(e) {
                    self.setStateDelete($(e.target));
                })
                .on('click', '.' + this.className + ' .do-custom-edit:not(.disabled)', function(e){
                    self.setStateCustomEdit($(e.target));
                })
                .on('expandable:swc-open', '.' + this.className, function(e, value) {
                    self.setSelected($('.' + self.itemClassName+"[data-key='"+value+"'] .show-hidden:visible"), true);
                })
                .on('expandable:swc-close', '.' + this.className, function(e, value) {
                    self.setSelected($('.' + self.itemClassName+"[data-key='"+value+"'] .show-hidden:visible"), false);
                })
                .on('expandable:swc-edit', '.' + this.className, function(e, value) {
                    self.setStateEdit($('.' + self.itemClassName+"[data-key='"+value+"'] .do-edit:visible"), {user: false, undo: false});
                })
                .on('expandable:swc-no-edit', '.' + this.className, function(e, value) {
                    self.setStateEdit($('.' + self.itemClassName+"[data-key='"+value+"'] .do-edit:visible"), {user: false, undo: true});
                })
                .on('expandable:swc-delete', '.' + this.className, function(e, value) {
                    self.setStateDelete($('.' + self.itemClassName+"[data-key='"+value+"'] .do-delete:visible"));
                });

        },

        setSelected: function(button, toOpen) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName),
                state = button.closest(".show-hidden").hasClass('expanded') ? "expanded" : "closed";

            fullList.find('.' + this.itemClassName).removeClass("expanded");
            fullList.find('.' + this.itemClassName).find('.device').removeClass("selected");
            if (state === "closed" || toOpen) {
                itemList.addClass("expanded");
                itemList.find('.device').addClass("selected");
                fullList.trigger('expandable:open', itemList.attr('data-key'));
            } else {
                fullList.trigger('expandable:close', itemList.attr('data-key'));
            }
        },

        setStateEdit: function(button, options) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName),
                state = itemList.hasClass('mode-editing') ? true : false;
            if(!state && !options.undo){
                itemList.addClass('mode-editing');
                if(options.user){
                    fullList.trigger('expandable:edit', itemList.attr('data-key'));
                }
            } else if(options.undo){
                itemList.removeClass('mode-editing');
                fullList.trigger('expandable:no-edit', itemList.attr('data-key'));
            }
        },

        setStateCustomEdit: function(button){
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName);
            fullList.trigger('expandable:custom-edit', itemList.attr('data-key'));
        },

        setStateDelete: function(button) {
            var fullList = button.closest('.' + this.className),
                itemList = button.closest('.' + this.itemClassName);
            fullList.trigger('expandable:delete', itemList.attr('data-key'));
        }
    },

    /**
     * Popover elements
     */
    popovers: {

        /**
         * Set element type to be handled correctly
         */
        type: 'absolute-position',

        /**
         * Elements popover active toggle class:
         */
        className: 'has-popover',

        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.' + this.className, function(e) {
                    var element = $(e.target).hasClass(self.className) ? $(e.target) : $(e.target).closest('.' + self.className);

                    if(!element.hasClass('no-click')){
                        if (element.hasClass('selected')) {
                            self.closeAll();
                        } else {
                            self.open($(e.target));
                        }

                        e.stopPropagation();
                    }
                })
                .on('popover:toggle', '.' + this.className, function(e) {
                    var element = $(e.target);

                    if (element.hasClass('selected')) {
                        self.closeAll();
                    } else {
                        self.open(element);
                    }

                    e.stopPropagation();

                })
                .on('popover:close', function(e) {
                    self.closeAll();
                    e.stopPropagation();
                });
        },

        /**
         * Open popover on selected element:
         */
        open: function(e) {
            var self = this,
                holder = e.hasClass(this.className) ? e : e.closest('.' + this.className),
                popover,
                popoverElement,
                template,
                popoverClassName = holder.data('popover-class-name'),
                options = {
                    template: holder.data('popover-template-id'),
                    templateData: holder.data('popover-template-data') ? holder.data('popover-template-data') : {},
                    placement: holder.data('popover-placement'),
                    holderClassName: holder.data('popover-holder')
                };

            if (!holder.data('popover-element')) {
                popoverElement = holder;
            } else {
                var searchClass = holder.data('popover-element');

                popoverElement = holder.find(holder.data('popover-element'));

                if (!e.hasClass(searchClass.replace('.', ''))) {
                    self.closeAll();
                    return;
                }
            }

            // Select template
            if (!swc.Templates.get(options.template)) {
                self.closeAll();
                return;
            }

            // Add values to template data:
            options.templateData.localeStrings = swc.models.Locale.getLocaleStrings();
            options.templateData.localeString = getTranslationStringsjQuery;
            options.templateData.formatDate = swc.models.Locale.formatDate;

            if (typeof(options.templateData) === 'string') {
                options.templateData = JSON.parse(options.templateData);
            }

            // Close all other elements:
            SWCElements.global.closeAll(self.className);

            // Prepare popover on element
            popoverElement.popover({
                html: true,
                content: $.tmpl(swc.Templates.get(options.template).get('content'), options.templateData),
                placement: options.placement,
                container: holder.data('popover-container') ? holder.data('popover-container') : "body"
            });

            // Display popover:
            popoverElement.popover('show');

            // Set holder elements selected
            holder.addClass('selected');
            popoverElement.addClass('selected');


            // Add data options to active popover:
            popover = $('body').find('.popover');

            popover.addClass(popoverClassName);

            // Set popover data
            popover.data('holderClassName', options.holderClassName);
        },

        /**
         * Close all popovers on the page:
         */
        closeAll: function() {
            $.each($('.has-popover.selected'), function(key, value) {
                var holder = $(value),
                    popoverElement;

                // Select base popover element:
                if (!holder.data('popover-element')) {
                    popoverElement = holder;
                } else {
                    popoverElement = holder.find(holder.data('popover-element'));
                }

                // Remove popover:
                holder.removeClass('selected');
                popoverElement.removeClass('selected');

                // Remove popover:
                popoverElement.popover("destroy");
            });
            $('body > .popover').remove();
        }
    },

    /**
     * Global body handler:
     */
    global: {

        // Close all absolute elements on body click
        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.popover', function(e) {
                    e.stopPropagation();
                })
                .on('click', function(e) {
                    self.closeAll();
                });
        },

        /**
         * Close all elements:
         * @param activeElement
         */
        closeAll: function(activeElement) {
            $.each(SWCElements, function(key, value) {
                if (value.type && value.type === 'absolute-position') {
                    if ($.isFunction(value.closeAll)) {
                        value.closeAll();
                    }
                }
            });
        }
    },

    charactersFilter: {

        initAll: function() {
            var self = this;

            $('body')
                .on('keydown', '.characters-filter', function(e) {
                    self.checkCharacter(e);
                });
        },

        checkCharacter: function(e) {
            var character = getCharacterByKey(e.shiftKey, e.keyCode),
                regexp = $(e.target).data('characters-regexp'),
                // the following array contains codes of "C", "X", "V", "Z" keys
                // to have opportunity to check appropriate Ctrl+Key combinations
                serviceCtrlKeys = [67, 88, 86, 90],
                // the following array contains code of "Ins" key
                // to have opportunity to check appropriate Shift+Key combination
                serviceShiftKeys = [45];

            // Filter dots:
            if (e.keyCode === 190 || e.keyCode === 110) {
                character = ".";
            }

            // Enable Ctrl combinations
            if (e.ctrlKey && $.inArray(e.keyCode, serviceCtrlKeys) !== -1) {
                return;
            }

            // Enable Shift combinations
            if (e.shiftKey && $.inArray(e.keyCode, serviceShiftKeys) !== -1) {
                return;
            }

            // Enable global key codes:
            if (character && !character.length || !regexp) {
                return;
            } else {
                var regTemp = new RegExp(regexp, "ig");

                if (!regTemp.test(character)) {
                    e.preventDefault();
                }
            }
        }
    },

    /**
     * Modal windows functionality
     */
    modalWindow: {

        initAll: function() {
            var self = this;

            $('body')
                .on('click', '.modalWindow', function(e) {
                    e.stopPropagation();
                });
        },

        /**
         * Display modal windows
         *
         * @param options {Object}
         *
         * @description:
         *
         *  templateID: {String} - id of template to be shown in a modal window
         *  templateData: {Object} - data to be passed to template
         *
         *  className: {String} - will be added to the modal window
         *
         *  onApply: <function> which will be called when apply button is pressed
         *  onCancel: <function> which will be called when cancel button is pressed
         *  onShow: <function> which will be called when dialog window is shown
         *  onHide: <function> which will be called when dialog window is closed
         */
        show: function(options) {
            var modalShadow = $('<div class="modalWindowShadow"></div>'),
                modalWindow,
                modalWindowData = {
                    'width': 0,
                    'height': 0
                },
                modalWindowTemplate = $.template("modalWindow", swc.Templates.get('application:modal-window').get('content')),
                modalWindowTemplateContent = $("<span>undefined template</span>"),
                modalLocaleStrings = !_.isUndefined(options.localeStrings) ? options.localeStrings : swc.models.Locale.getLocaleStrings();

            // Hide previously opened window, when new window request (fixing windows duplicate):
            if ($('body').find('.modalWindow').size()) {
                SWCElements.modalWindow.hide();
            }

            // We need to add specific translations for the template:
            modalLocaleStrings = _.extend(modalLocaleStrings, swc.models.Locale.getLocaleStrings(options.templateID.replaceAll(":", "/")));

            // Define template for modal window content:
            if (options.templateID) {
                modalWindowTemplateContent = $.template("modalWindowContent", swc.Templates.get(options.templateID).get('content'));
            }

            // Append modal window shadow and modal window to application:
            $('body').append(modalShadow);
            $('body').append($.tmpl(modalWindowTemplate, {}));

            // Handle clicks on modal window shadow:
            modalShadow.on('click', function(e) {
                e.stopPropagation();
            });

            // Define modal window reference:
            modalWindow = $('.modalWindow');

            // Append modal window content
            modalWindow.html(
                $.tmpl(modalWindowTemplateContent, {
                        data: options.templateData ? options.templateData : {},
                        deviceIndex: function (item, map) {
                            var indexToIncriment = 0,
                                index = 0;

                            $.each(map, function(key, device) {
                                if (key === item) {
                                    index = indexToIncriment;
                                }

                                indexToIncriment++;
                            });

                            return index;
                        },
                        localeStrings: modalLocaleStrings,
                        localeString: getTranslationStringsjQuery,
                        formatDate: swc.models.Locale.formatDate
                    }
                )
            );

            // Add addition class name to modal window:
            if (options.className) {
                modalWindow.addClass(options.className);
            }

            // Set correct positioning of modal window:
            modalWindow.css({
                marginTop: -(modalWindow.outerHeight() / 2 + 75) + 'px',
                marginLeft: -(modalWindow.outerWidth() / 2) + 'px'
            });

            // Display the modal window itself
            modalWindow.show();

            // Trigger options onShow function
            if (options.onShow && $.isFunction(options.onShow)) {
                options.onShow();
            }

            // Cancel changes handler:
            modalWindow.find('.cancel-changes').on('mousedown', function(e) {
                var button = $(e.target).hasClass('button') ? $(e.target) : $(e.target).closest('.button');

                if (button.hasClass('disabled')) {
                    return;
                }

                if (options.onCancel && $.isFunction(options.onCancel)) {
                    options.onCancel();
                }

                e.stopPropagation();

                SWCElements.modalWindow.hide();
            });

            // Apply changes handler:
            modalWindow.find('.apply-changes').on('mousedown', function(e) {
                var button = $(e.target).hasClass('button') ? $(e.target) : $(e.target).closest('.button');

                if (button.hasClass('disabled')) {
                    return;
                }

                if (options.onApply && $.isFunction(options.onApply)) {
                    options.onApply();
                }

                e.stopPropagation();
            });
        },

        /**
         * Hide modal window
         */
        hide: function() {
            var modalShadow = $('.modalWindowShadow'),
                modalWindow = $('.modalWindow');

            // Hide modal window shadow
            modalShadow.remove();

            // Remove modal window content:
            if (modalWindow.size()) {
                modalWindow.remove();
            }
        }
    },

    progressRuler: {

        /**
         * Current element class name:
         *
         * @param className {String}
         *
         */
        className: 'ruler-container',

        /**
         * Init all custom rulers on the page:
         */
        initAll: function() {
            var self = this;

            $('body')
                .on('swc-ruler:start', '.' + this.className, function(e, params) {
                    e.stopPropagation();
                    self.customChange($(e.target), params);
                });
        },

        /**
         * Animates progress bar during `time` passed as an option
         *
         * @param DOMElement
         * @param options {Object} Example: {length: length, time:time }
         *                                 where length - width alpha in percents
         *                                 time - time of changing in milliseconds
         */
        customChange: function(element, options) {
            var progressBar = element.find('.fill');

            if (!options.time) {
                element.trigger('swc-ruler:finish');
            } else {
                progressBar.animate(
                    { width: '+=' + (options.length || element.width()) },
                    options.time,
                    'linear',
                    function() {
                        element.trigger('swc-ruler:finish');
                    }
                );
            }
        }


    }
};

$(document).ready(function() {
    _.each(SWCElements, function(value, key) {
        if (_.isFunction(SWCElements[key].initAll)) {
            SWCElements[key].initAll();
        }
    });
});
;String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
};

String.prototype.deCapitalize = function() {
    return this.charAt(0).toLowerCase() + this.slice(1);
};

String.prototype.replaceAll = function(search, replace){
    return this.split(search).join(replace);
};

/**
 * FIX for IE browser
 * @link http://tosbourn.com/2013/08/javascript/a-fix-for-window-location-origin-in-internet-explorer/
 */
if (!window.location.origin) {
    window.location.origin = window.location.protocol + "//" + window.location.hostname +
        (window.location.port ? ':' + window.location.port: '');
}

/**
 * Returns array with defined length - useful for 'for' loops in jquery-tmpl
 * example:
 *
 * {{each returnArray(5)}}
 * {{/each}}
 *
 * @param length
 * @returns {Array}
 */
function returnArray(length){
    if (length <= 0) {
        return [];
    }
    return new Array(length);
}

/**
 * Calculates day number (assuming 0 is Monday) and seconds from start of a day 
 * using seconds since start of a week.
 * Result would be an object of view: {seconds: 3000, hops: 2},
 * where hops = day of week (0 - Monday, 1 - Tuesday...)
 * @example: 
 *   <pre>604800(end of sunday) -> 86400(end of a day)</pre>
 *   
 * @param seconds in a week
 * 
 * @returns Object 
 */
function getDaySeconds(seconds_since_monday){
    var secondsInDay = 86400;
    return {
        seconds: seconds_since_monday % secondsInDay || secondsInDay,
        hops: Math.ceil(seconds_since_monday / secondsInDay) - 1
    };
}


function getTranslationStrings(id, isLoadingWindow) {
    var localeStrings;

    if (isLoadingWindow) {
        localeStrings = swc.models.Locale.getLocaleStrings('application');
    } else {
        localeStrings = swc.models.Locale.getLocaleStrings();
    }

    if (localeStrings && localeStrings[id]) {
        return localeStrings[id];
    } else {
        return id;
    }
}

/**
 * Method for translation strings in html template.
 *
 * @description
 *
 *  {{html localeString("Some string to be translated")}} = Some string to be translated
 *  {{html localeString("Some %placeholder% to be translated", { 'placeholder': 'value' } )}} = Some value to be translated
 *
 * @param id {String}
 * @param params {Object | Map}
 *
 * @returns {String}
 */
function getTranslationStringsjQuery(id, params) {
    var string = id;

    if (this.data.localeStrings && this.data.localeStrings[id]) {
        string = this.data.localeStrings[id];
    }

    if (params && getObjectLength(params)) {
        $.each(params, function(key, value) {
            string = string.replaceAll('%' + key + '%', value);
        });
    }

    return string;
}

/**
 * Get parameter Name / Value based on element type and value:
 * @param element {Object}
 */
function getParameter(element) {
    var parameterName = '',
        parameterValue = '';

    if (element.hasClass('swc-input')) {
        parameterName = element.attr('name');
        parameterValue = element.val();
    }

    else if (element.hasClass('swc-checkbox')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-extended')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-dropdown')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    else if (element.hasClass('swc-radio-buttons')) {
        parameterName = element.data('name');
        parameterValue = element.data('value');
    }

    return {
        'parameterName': parameterName,
        'parameterValue': parameterValue,
        'parameterClasses': $(element).attr('class') ? $(element).attr('class').split(/\s+/) : [],
        'parameterData': $(element).data()
    };
}

function getObjectLength(map) {
    var length = 0;

    if (map) {
        $.each(map, function(key, value) {
            length++;
        });
    }

    return length;
}

/**
 * Get application locale either stored in localStorage or retrieved from user's web-browser
 * 
 * @param supportedLocales list of locales currently supported by application
 * 
 * @return {String}
 */
function getApplicationLocale(supportedLocales) {
    var locale,
        browserLocale = navigator.language ? navigator.language.split('-')[0] : navigator.userLanguage.split('-')[0];
    
    var storedLocal = localStorage.getItem("locale");
    if (storedLocal && storedLocal !== "undefined") {
        locale = storedLocal;
    } else {
        if (_.findWhere(supportedLocales, {key: browserLocale.toLowerCase()})) {
            locale = browserLocale.toLowerCase();
        }
    }
    
    return locale;
}

/**
 * Password validator
 * @param password
 * @return boolean
 */
function validatePassword(password){
    var testRegEx = /^(?=.*?[a-zA-Z])(?=.*?[-._\d])[-.\w]{8,16}$/;
    
    return testRegEx.test(password);
}

function getBuildInfo() {
    var info = swc.settings.application.get('build');

    $.each(info, function(key, value) {
        console.log(key + ' - ' + value);
    });
}

function getCharacterByKey(isShiftKey, characterCode) {
    var keysToExclude = [
            8, 9, 13, 16, 17, 18, 20, 27, 37, 39, 46, 91,  92
        ],
        keysCodesMap = {
            32: " ", 48: ")", 49: "!", 50:  "@", 51:  "#", 52:  "$",
            53:  "%", 54:  "^", 55:  "&", 56:  "*", 57:  "(", 59:  ":",
            96: "0", 97: "1", 98: "2", 99: "3", 100: "4", 101: "5", 102: "6",
            103: "7", 104: "8", 105: "9", 107:  "+", 109:  "_", 188:  "<",
            190:  ">", 191:  "?", 192:  "~", 219:  "{", 220:  "|", 221:  "}",
            222:  "\""
        },
        character = "";
    if ($.inArray(characterCode, keysToExclude) !== -1) {
        return character;
    }

    if (typeof isShiftKey !== "boolean" || typeof characterCode !== "number") {
        return character;
    }

    if (isShiftKey) {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode);
        } else {
            character = keysCodesMap[characterCode];
        }
    } else {
        if (characterCode >= 65 && characterCode <= 90) {
            character = String.fromCharCode(characterCode).toLowerCase();
        }
        else if (characterCode >= 96 && characterCode <= 105) {
            character = keysCodesMap[characterCode];
        } else {
            character = String.fromCharCode(characterCode);
        }
    }

    return character;
}

/**
 * Get device ID stored in cookies.
 * 
 * @returns {string}
 */
function getDeviceID() {
    var cookiesArray = document.cookie.split(';'),
        id;

    /**
     * NOTE:
     * Server side sends session cookie in weird format.
     * Actually, session-cookie-name consists of deviceId + sessid suffix separated with / (slash)
     * Thus, we loop through all cookies and check if cookie name has "/sessid" in it,
     * if so, we use such cookie to retrieve device Id and save it under separate cookie
     */
    _.each(cookiesArray, function(cookie) {
        var cookieName = cookie.split('=')[0];
        if (cookieName.split('/')[1] === 'sessid') {
            id = $.trim(cookieName.split('/')[0]);
        }
    });
    
    // haven't found device Id in returned cookies?
    // Try use previously saved deviceId.
    // This could be a situation after Reset when we got to the login page) but already know device's Id.
    if (!id) {
        id = $.cookie('swc/deviceID');
    }

    return id;
}

/**
 * Few SAH callbacks use prototype.js-related event dispatcher on document object. This function will convert it to jquery-related
 * @param event
 * @param options
 */
document.fire = function(event, options){
    $(document).trigger(event, options);
};

/**
 * mobile device detector
 */
function detectMobileBrowser(){
    return (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent));
}

;swc.constructors.LocaleModel = Backbone.Model.extend({

    /**
     * Current application locale
     *
     * @param locale {String}
     *
     */
    locale: "",

    /**
     * Default application locale defined in settings
     * 
     * @var defaultLocale {String}
     */
    defaultLocale: "",

    /**
     * List of available locales:
     *
     * @param available {Array}
     *
     */
    available: [],

    initialize: function() {
        this.defaultLocale = swc.settings.application.get('locales')['default'];
        this.available = swc.settings.application.get('locales').available;
    },

    /**
     * Get localised strings for selected component:
     *
     * @param component {String}
     *
     */
    getLocaleStrings: function(componentTrigger) {
        var component = Backbone.history.fragment ? Backbone.history.fragment : 'application';

        if (componentTrigger) {
            component = componentTrigger;
        }

        var componentsArray = component.split('/'),
            strings = swc.locales;

        return this.getLocaleStringsRecursively(strings[componentsArray[0]], {});
    },

    getLocaleStringsRecursively: function(strings, result) {
        var self = this;

        if (!getObjectLength(strings)) {
            return result;
        }

        $.each(strings, function(id, string) {
            if (typeof string !== "object") {
                result[id] = string;
            } else {
                self.getLocaleStringsRecursively(string, result);
            }
        });

        return result;
    },

    /**
     * Insert locale strings to the collection when application is loaded
     *
     * @param strings {Object}
     *
     */
    setLocaleStrings: function(strings) {
        swc.locales = strings;
    },

    /**
     * Get saved UI language in a deferred way
     * 
     * @return Promise
     */
    getLocale: function(){
        var deferred = new $.Deferred();
        
        // Request language from the server
        // Save current UI language on NP side
        var restClient = new swc.constructors.Rest();
        restClient.sendRequest({
            url: '/sysbus/UserInterface:getLanguage',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            data: {
                parameters: {}
            },

            success: function(response) {
                if(response.status && response.status !== false){
                    deferred.resolve(response);
                }
                else {
                    deferred.reject();
                }
            },
            
            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Set application locale file:
     *
     * @param locale {String}
     *
     */
    setLocale: function(locale) {
        var self = this,
            deferred = new $.Deferred();

        // Update cookie locale
        localStorage.setItem("locale", locale);
        // save into self property
        self.locale = locale;

        /**
         * Load localization strings
         * 
         * @return Deferred
         */
        function loadLocalizationData() {
            var deferred = new $.Deferred();
            
            $.ajax({
                url: 'static/translations/' + locale + '.json',
                type: 'get',
                dataType:'json'
            }).done(function(response) {
                self.setLocaleStrings(response);
                deferred.resolve();
            }).fail(function(){
                deferred.reject();
            });
            
            return deferred.promise();
        }

        /**
         * Save selected UI language on NP side
         * 
         * @return Promise
         */
        function saveLanguageOnServer(){
            var deferred = new $.Deferred();
            // Save current UI language on NP side
            var restClient = new swc.constructors.Rest();
            restClient.sendRequest({
                url: '/sysbus/UserInterface:setLanguage',
                method: 'POST',
                contentType: 'application/x-sah-ws-4-call+json',
                data: {
                    "parameters": {
                        "currentLanguage": locale
                    }
                },

                success: function(response) {
                    deferred.resolve();
                },
                
                error: function(){
                    deferred.reject();
                }
            });
            
            return deferred.promise();
        }
        
        $.when(loadLocalizationData(), saveLanguageOnServer())
            .done(function() { deferred.resolve(); })
            .fail(function() { deferred.reject(); });

        return deferred.promise();
    },

    /**
     * Get locale options for dropdown:
     */
    getLocaleOptions: function() {
        var self = this,
            options = [];

        $.each(self.available, function(key, locale) {
            options.push({
                name: locale.text,
                value: locale.key
            });
        });
        
        return options;
    },
    
    getStaticPagesLinks: function(){
        var locales = swc.settings.application.get('locales').available;
        var locale = _.findWhere(locales, {key: this.locale});
        return locale.staticPages;
    },

    formatDate: function (date, format) {
        var d = new Date(date).getTime();
        if (_.isNaN(d)) {
            return date;
        }
        moment.lang(swc.models.Locale.locale);
        return moment(d).format(format || "D MMM YYYY, HH:mm");
    }
});
;swc.constructors.Template = Backbone.Model;
swc.constructors.SimpleModel = Backbone.Model;

/**
 * Base backbone model for extending in application
 *
 * @type {*}
 *
 */
swc.base.Model = Backbone.Model.extend({

    /**
     * Rest interface component:
     *
     * @param {component} String
     *
     */
    component: '',

    /**
     * Rest interface action:
     *
     * @param {component} String
     *
     */
    action: '',

    /**
     * Rest interface component to save data
     *
     * @param {componentSave} String
     */
    componentSave: '',

    /**
     * Rest interface action to save data
     *
     * @param {actionSave} String
     */
    actionSave: '',

    /**
     * JSON data witch will be sent via AJAX when model.sync() will be proceed
     */
    json: {},

    /**
     * JSON data witch will be sent via AJAX when model.save() will be proceed
     */
    saveJSON: {},

    /**
     * Request method
     */
    method: 'POST',

    /**
     * Request method for save action
     */
    methodSave: 'POST',

    /**
     * Model sync method which can be redefined while extending if necessary
     */
    sync: function(method, model, options) {
        var deferred = new $.Deferred(),
            headers,
            self = this;

        if (this.headers) {
            headers = this.headers;
        } else {
            headers = {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            };
        }

        swc.models.Rest.sendRequest({
            component: self.component,
            action: self.action,
            data: self.json,

            method: self.method,
            contentType: 'application/x-sah-ws-4-call+json',

            headers: headers,

            success: function(response) {
                if (response.status) {
                    if (typeof response.status === "string") {
                        self.set("data", $.parseJSON(response.status));
                    } else {
                        self.set("data", response.status);
                    }
                } else {
                    if (typeof response === "string") {
                        self.set("data", $.parseJSON(response));
                    } else {
                        self.set("data", response);
                    }
                }

                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     *
     */
    save: function() {
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            component: self.componentSave,
            action: self.actionSave,
            data: self.saveJSON,
            method: self.methodSave,

            success: function(response) {
                return deferred.resolve();
            },

            error: function() {
                return deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Method for updating current model on the server
     */
    pageSave: function() {}
});

/**
 *
 * Backbone model for Templates
 *
 * @type {*}
 *
 */
swc.constructors.Templates = Backbone.Collection.extend({

    initialize: function() {},

    /**
     * Load application template files
     *
     * @param callback
     *
     */
    loadTemplates: function(callback) {
        var self = this,
            deferred = new $.Deferred();

        $.get('/application/tpl.min.html').success(function(response) {
            $.each($(response), function(templateKey, template) {
                if(template.nodeName.toLowerCase() === 'script') {
                    var localTemplate = new swc.constructors.Template();

                    localTemplate.set('content', template);
                    localTemplate.set('id', $(template).attr('id'));

                    self.add(localTemplate);
                }
            });

            if ($.isFunction(callback)) {
                callback();
            }
        });

        return deferred.promise();
    },

    /**
     * Load separate template file
     * @param url {String}
     * @returns {*}
     */
    loadTemplate: function(url) {

    }

});
;swc.constructors.Rest = Backbone.Model.extend({

    /**
     * List of rules for formatting query strings
     * @type {Object}
     */
    rules: {
        stringType: function(json) {
            return JSON.stringify(json);
        },
        jsonType: function(json) {
            return json;
        }
    },

    /**
     * Initialise REST model
     */
    initialize: function() {},

    /**
     * Send REST request based on incoming options
     * @param options {Object}
     * @return {Object}
     */
    sendRequest: function(options) {
        var contentType = options.contentType ? options.contentType : 'application/x-sah-ws-4-call+json',
            requestType = options.method ? options.method : 'POST',
            // undefined -> true
            // true -> true
            // false -> false
            processData = options.processData === false ? options.processData : true,
            requestHeaders = options.headers ? options.headers : {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            },
            requestData = options.data ? options.data : {},
            formatRule = options.formatRule ? options.formatRule : "stringType",
            timeout = options.timeout ? options.timeout : 29000,
            self = this;

        // Check if request is in background:
        if (!_.isUndefined(options.fromListener) && options.fromListener === true) {
            requestHeaders = $.extend(requestHeaders, {
                'X-Sah-Request-Type': 'idle',
                'idle': true
            });
        }

        if ((requestType.toLowerCase() === 'post' && !options.data)) {
            return {
                'status': 'error',
                'message': 'Wrong POST data provided'
            };
        }

        if (processData && this.rules[formatRule]) {
            requestData = this.rules[formatRule].call(this, options.data);
        } else {
            requestData = options.data;
        }

        if (!processData && !options.contentType) {
            contentType = false;
        }

        $.ajax({
            type: requestType,
            url: options.url,
            contentType: contentType,
            processData: processData,
            headers: requestHeaders,
            data: requestData,
            timeout: timeout,
            cache: false,

            beforeSend: function() {},

            complete: function() {},

            success: function(response) {
                var isPermissionDenied = false;
                if(response.errors && response.errors.length > 0){
                    _.each(response.errors, function(error){
                        if (error["description"] === "Permission denied") {
                            isPermissionDenied = true;
                        }
                    });
                }

                if (!response || isPermissionDenied) {
                    swc.models.Login.processLogout({ action: 'session-logout' });
                }

                if (options.success && $.isFunction(options.success)) {
                    options.success(response);
                }

                self.trigger("success:" + options.component + '-' + options.action);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                if (options.error && $.isFunction(options.error)) {
                    options.error(xhr, ajaxOptions, thrownError);
                }

                if (xhr.responseText && xhr.responseText.indexOf("Permission denied") !== -1) {
                    swc.models.Login.processLogout({ action: 'session-logout' });
                }
            },

            statusCode: {
                403: function() {
                    if (options.statusCode && options.statusCode['403'] && $.isFunction(options.statusCode['403'])) {
                        options.statusCode['403']();
                    }
                },

                404: function() {
                    if (options.statusCode && options.statusCode['404'] && $.isFunction(options.statusCode['404'])) {
                        options.statusCode['404']();
                    }
                },

                500: function() {
                    if (options.statusCode && options.statusCode['500'] && $.isFunction(options.statusCode['500'])) {
                        options.statusCode['500']();
                    }
                },

                502: function() {
                    if (options.statusCode && options.statusCode['502'] && $.isFunction(options.statusCode['502'])) {
                        options.statusCode['502']();
                    }
                }
            }
        });
    }

});
;swc.constructors.Router = Backbone.Router.extend({

    /**
     * This stores history to allow navigate back
     */
    history: [],

    /**
     * Start history tracking:
     */
    initialize: function() {
        this.on('route', this.storeHistory);
        Backbone.history.start();
    },
    
    /**
     * Define router settings:
     */
    routes: {
        '': 'login',
        'login': 'login',
        'remote-login': 'remoteLogin',
        '*': 'loadModule'
    },

    login: function() {
        this._doLogin();
    },


    remoteLogin: function() {
        // We add global css class here to the body - "disabled-for-superadmin"
        // Needed to hide all controls which should not be visible for superuser
        $("body").addClass("disabled-for-superadmin");
        this._doLogin(true);
    },

    /**
     * General login method which has some specific logic if login done remotely through WAN port
     * @param isRemote {boolean} Optional. Just pass TRUE in case if this is remote login 
     * @private
     */
    _doLogin: function(isRemote) {
        var userIsLoggedIn = swc.models.Login.checkUserLogin(),
            route = 'login';
        
        if (isRemote) {
            // Set this value to let login view know about remote login
            localStorage.setItem('remoteLogin', true);
            route = 'remote-login';
        }

        if (userIsLoggedIn && !localStorage.getItem("changePassIncomplete")) {
            this.navigate('overview', {trigger: true});
        } else {
            this.navigatePage(route);
        }
    },

    /**
     * General controller - loads module
     * @see this.navigatePage method
     * @param path
     */
    loadModule: function(path) {
        var userIsLoggedIn = swc.models.Login.checkUserLogin();
        if (!userIsLoggedIn) {
            swc.models.Login.processLogout();
        } else {
            // don't allow user to see application if "set new password" procedure was not finished
            if (localStorage.getItem("changePassIncomplete")) {
                this.navigate("login", {trigger: true});
            } else {
                this.navigate(path, {trigger: true});
            }
        }
    },

    /**
     * Save current fragment into history
     */
    storeHistory: function() {
        swc.constructors.dispatcher.trigger('route:change');
        this.history.push(Backbone.history.fragment);
    },

    /**
     * Changes url to the previous one
     */
    navigateBack: function() {
        if (this.history.length > 1) {
            Backbone.history.navigate(this.history[this.history.length - 2], {trigger: true});
        } else {
            this.navigate(Backbone.history.fragment, {trigger: true});
        }
    },

    saveChangesDialog: function(confirmLeave) {
        var self = this;
        
        SWCElements.modalWindow.show({
            templateID: 'application:modal:changes-confirm',
            templateData: {
                formatDate: swc.models.Locale.formatDate
            },
            localeStrings: swc.models.Locale.getLocaleStrings('application'), // TODO :: no time to identify. Refactor this
            className: 'confirm-changes',
            
            onCancel: function() {
                // resolving deferred will allow us navigate to requested page
                confirmLeave.resolve();
            },
            
            onApply: function() {
                self.navigateBack();
                SWCElements.modalWindow.hide();
            }
        });
    },

    navigatePage: function(path) {
        var pathComponents = path ? path.split('/') : Backbone.history.fragment.split('/'),
            area = $('#current-page'),
            constructor, view, page, subPage, tab;
        
        // Check if application is already rendered:
        if (!area.size()) {
            swc.views.Application.showPageLoading('Initializing application');
        }

        if (pathComponents.length) {
            page = pathComponents[0];
        }

        if (pathComponents.length > 1) {
            subPage = pathComponents[1];
        }

        if (pathComponents.length > 2) {
            tab = pathComponents[2];
        }
        
        // Generate constructor and view name:
        if (page && subPage) {
            constructor = page.capitalize().replaceAll('-', '') + subPage.capitalize().replaceAll('-', '') + 'View';
        } else {
            constructor = page.capitalize().replaceAll('-', '') + 'View';
        }
        
        // Select correct name for view constructor:
        view = constructor.deCapitalize();

        // Check if constructor exists:
        if (!swc.views[view]) {
            swc.views[view] = new swc.constructors[constructor]();
        }

        // Define if current page has tabs:
        if (tab) {
            swc.views[view].hasTabs = true;
        } else {
            swc.views[view].hasTabs = false;
        }

        this.bindChangeRouteEvent(swc.views[view]);

        // Render current view:
        swc.views[view].render();
    },

    /**
     * Bind event "route:change"
     *
     * @description:
     *
     * This method binds event "route:change" which is fired in the this.storeHistory method
     * and invoke this.beforeRouteChangeHook.
     * The event unbinds after invoking of the hook
     */
    bindChangeRouteEvent: function(view) {
        swc.constructors.dispatcher.on('route:change', function() {
            if (_.isFunction(view.beforeRouteChangeHook)) {
                view.beforeRouteChangeHook();
            }
            swc.constructors.dispatcher.off('route:change');
        });
    },

    /**
     * This customized method will check if there are any changes made on page and Apply button is enabled.
     * Will show "confirm leave" dialog window if have unsaved pages. 
     * 
     * @override
     * @param fragment
     * @param options - standard Backbone navigation options + additional parameter {skipUnsavedChanges: true/false}, 
     *                  which defines weather to skip check for unsaved changes 
     * @returns {defer.promise|*|Promise.promise}
     */
    navigate: function(fragment, options) {
        var currentView = swc.views.currentView,
            self = this,
            confirmLeave = new $.Deferred();
        
        // Only go ahead if user confirmed their decision
        confirmLeave.promise().then(function(){
            // do the actual navigation
            Backbone.Router.prototype.navigate(fragment, options);
            self.navigatePage(fragment);
        });

        // Check for not saved changes on page
        // temporally canceled checker on some pages
        if (currentView && currentView.hasChanged() && !_.isUndefined(options) && (!options.skipUnsavedChanges)) {
            this.saveChangesDialog(confirmLeave);
            return confirmLeave.promise();
        } else {
            confirmLeave.resolve();
        }
    }
});
;swc.base.PageView = Backbone.View.extend({

    /**
     * Selected view tag name
     *
     * @param tagName {String}
     *
     */
    tagName: 'div',

    /**
     * Selected view class name
     *
     * @param className {String}
     *
     */
    className: '',

    /**
     * List of allowed modes for current page:
     *
     * @param allowedMods {Array}
     *
     */
    allowedMods: ["standard", "expert"],

    /**
     * List of models which have to be preloaded before page is rendered
     *
     * @param models {Object} :: object :: callback function
     *
     */
    models: [],

    /**
     * List of methods for each validateable component to be called:
     * @param validation {Object || Map}
     *
     * @description can be used in two ways - passing arguments as <string> : <string>, or
     *              passing arguments as <string> : <array>
     *
     * @example
     *              validation: {
     *                  'input[name="somename"]': 'IPModel.validateIPAddress'
     *                  'input[name="othername"]': [
     *                                                 'IPModel.validateDHCP',
     *                                                 'IPModel.validateDMZ'
     *                                             ]
     *              }
     */
    validation: [],

    /**
     * Template data storage which will be passed to the template when models are loaded:
     */
    templateData: {},

    /**
     * Default interval for listeners - 10 seconds
     */
    listenerInterval: 10,

    /**
     * Flag which enable / disable pages:
     */
    listenerEnabled: false,

    /**
     * List of pages where listeners will work for current view
     */
    listenerPages: [],

    /**
     * List of default events for each page - will be extended by each view
     * @param events {Object}
     */
    events: {
        // special event to be called from the code:
        'validate .validatable': 'pageValidation',

        // When user makes a change on the field and leaves focus from it:
        'change input.validatable': 'pageValidation',

        // When user makes a change on checkbox:
        'swc-checkbox:change .swc-checkbox.validatable': 'pageValidation',

        // When user makes a change on checkbox extended:
        'swc-checkbox-extened:change .swc-checkbox.validatable': 'pageValidation',

        // When user makes a change on dropdown:
        'swc-dropdown:change .swc-dropdown.validatable': 'pageValidation',

        // When user makes a change on radiobutton:
        'swc-radio-buttons:change .swc-radio-buttons.validatable': 'pageValidation',

        // When user makes a change in the field but focus is still in
        'keyup input.swc-input': 'setButtonsState',

        // Button cancel changes click handler
        'click .button.cancel-changes:not(.disabled)': 'cancelChanges',

        // Button save changes click handler
        'mousedown .button.save-changes:not(.disabled)': 'saveChanges'
    },

    /**
     * Flag to identify if page content is disabled by loading backdrop
     * @param isPageEnabled {Boolean}
     */
    isPageEnabled: true,

    /**
     * Flag to identify if page tabs are disabled by loading backdrop
     * @param isTabsEnabled {Boolean}
     */
    isTabsEnabled: true,

    /**
     * Initialise view
     */
    initialize: function() {
        var pagesArray = Backbone.history.fragment.split("/");

        // Define page template and locale ID:
        if (pagesArray.length === 1) {
            if (!pagesArray[0].length) {
                this.pageTemplateID = 'overview';
            } else {
                this.pageTemplateID = pagesArray[0];
            }
        } else {
            this.pageTemplateID = pagesArray[0] + ':' + pagesArray[1];
        }

        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    /**
     * Check if current view has unsaved changes on it, e.g. has "dirty model".
     * So far it check if there us enabled "Save" button.
     * 
     * @return {boolean}
     */
    hasChanged: function() {
        return this.$el.find(".client-buttons a[class*='apply']:not(.disabled), " +
            ".client-buttons a[class*='save']:not(.disabled)").size() > 0;
    },

    /**
     * Load all models which are included to current page
     *
     * @param callback {Function}
     *
     */
    loadModels: function(fromListener) {
        var deferred = new $.Deferred(),
            toDo = [],
            modelsToLoad = !_.isUndefined(this.models) ? _.values(this.models) : [];

        if (this.hasTabs) {
            modelsToLoad = _.union(modelsToLoad, !_.isUndefined(this.tabView.models) ? _.values(this.tabView.models) : []);
        }

        if (_.isEmpty(modelsToLoad)) {
            return deferred.resolve();
        } else {
            _.each(modelsToLoad, function(model, key) {
                if (!swc.models[model]) {
                    swc.models[model] = new swc.constructors[model]();
                }

                if (swc.models[model].isNewArchitecture) {
                    toDo.push(
                        swc.models[model].sync('read', { isListener: fromListener === true ? true : false })
                    );
                } else {
                    toDo.push(
                        swc.models[model].sync(fromListener === true ? true : false)
                    );
                }
            });

            $.when.apply(this, toDo)
                .done(function() {
                    deferred.resolve();
                })
                .fail(function() {
                    // TODO :: navigate user to coresponding sticky page
                    deferred.resolve();
                });
        }

        return deferred.promise();
    },

    /**
     * To be overriden if necessary.
     * this method is called after the models are synced
     * @returns a promise object.
     * If the promise is resolved then the render method continues executing.
     * If the promise is rejected then the render method stops executing.
     * Useful when preconditions may require redirecting to another page.
     */
    preRender: function () {
        // default behavior is - to render on
        return (new $.Deferred()).resolve();
    },

    /**
     * Render Selected Page
     */
    render: function(action) {
        var self = this,
            promise;

        // Check if render was called from child view:
        if (self.parentView) {
            self.parentView.render();
            return;
        }

        // Check if current application mode allows user to visit current page
        self.checkPermissions();

        // Show loading window:
        self.showPageLoading('Loading page data..');

        // Check if current page has tab and init it:
        if (self.hasTabs) {
            self.initTabView();
        }

        // Reset values to its defaults
        this.isPageEnabled = true;
        this.isTabsEnabled = true;

        // Load page models:
        $.when(self.loadModels(false))
            .done(function() {

                // Check for preconditions (if any)
                // (actually, it should be called in initialize method, but in our case we have
                // models loading in render!!! method, so we have to make a way...)
                // If there are tabs then we have to call tabView method instead:
                if (self.hasTabs) {
                    promise = self.tabView.preRender();
                } else {
                    promise = self.preRender();
                }

                $.when(promise)
                    .done(function() {

                        // Set template data:
                        self.setTemplateData();

                        // Check if page has tabs:
                        if (self.hasTabs) {
                            // Set template data to tab view:
                            self.tabView.setTemplateData();

                            // Get parent templates content:
                            self.getTemplateContent();

                            // Get child template content:
                            self.tabView.getTemplateContent();

                            // Render parent template
                            self.templateContent.find('.tabs-content').html(self.tabView.templateContent);

                            // Display page basing on content:
                            self.displayPage();

                            // Render complete method trigger:
                            self.renderComplete();
                            self.tabView.renderComplete();
                            self.tabView.startListener();
                            self.tabView.trigger('render:finished');
                        } else {
                            self.getTemplateContent();
                            self.displayPage();
                            self.renderComplete();
                        }
                        self.trigger('render:finished');
                        self.startListener();
                    });
            });
        return this;
    },

    /**
     * This method will be overriden in each view. In this method can be set <templateData> variable
     */
    setTemplateData: function() {},

    /**
     * Get page template content:
     * @returns {*}
     */
    getTemplateContent: function() {
        var self = this;

        this.templateContent = this.$el.html($.tmpl(self.template, {
            data: self.templateData,
            localeStrings: swc.models.Locale.getLocaleStrings(),
            localeString: getTranslationStringsjQuery,
            staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
            formatDate: swc.models.Locale.formatDate
        }));
    },

    /**
     * Insert ready template to application content:
     */
    displayPage: function() {
        var self = this,
            area = $('#current-page');

        // Check if application is already rendered:
        if (!area.size()) {
            swc.views.Application.renderApplicationArea();
        }

        // Render template content to application area:
        swc.views.Application.contentArea.html(
            self.templateContent
        );

        // Set menu link state:
        swc.views.Application.setMenuActiveLink();

        // Delegate events:
        this.delegateEvents();

        // Delegate events on tab view:
        if (this.hasTabs) {
            this.tabView.delegateEvents();
        }

        // Hide loading window dialog:
        this.stopPageLoading();
    },

    /**
     * Method which will be called when main part of a page will be
     * rendered and all necessary data will be loaded
     *
     * @description Here you can place any observers on existing elements, fill in drop downs, add devices etc.
     */
    renderComplete: function() {},

    /**
     * Render Page Selected Tab:
     *
     * @description Tab constructor id is building in following way:
     *
     * (currentPageName.capitalise() + currentSubPageName.capitalise() + currentTabName.capitalise()).replace(/-/g,'') + 'View'
     *
     * For example for storage/settings/cloud-backup it will be "StorageSettingsCloudbackupView"
     *
     */
    initTabView: function(action) {
        var pagesArray = Backbone.history.fragment.split("/"),
            TabConstructorName = _.map(pagesArray, function(n) {
                return n.capitalize();
            }).concat("View").join("").replace(/-/g,''),
            TabViewName = TabConstructorName.deCapitalize();

        if (!swc.views[TabViewName]) {
            swc.views[TabViewName] = new swc.constructors[TabConstructorName]();
            swc.views[TabViewName].parentView = this;
        }

        this.tabView = swc.views[TabViewName];
        // Check if current application mode allows user to visit current page
        this.tabView.checkPermissions();
    },

    /**
     * Show page Saving / Loading dialog
     *
     * @description: when each view method render() will be called - the loading dialog will appear
     *               this method is extended by each view in application, so it can be called from any
     *               place of the application by invoking this.showPageLoading(argumet : string);
     *
     * @param action {String}
     */
    showPageLoading: function(message) {
        var self = this,
            template = $.template('loading', swc.Templates.get('application:loading-window').get('content')),
            dialog = $('.loading-window'),
            id = Math.random();

        // Close all popover
        SWCElements.popovers.closeAll();

        // Do nothing if loading window exists
        if (dialog.size()) {
            return;
        }

        // Append loading window to body:
        $('#components').append(
            $.tmpl(template, {
                id: id,
                message: getTranslationStrings(message, true),
                localeStrings: swc.models.Locale.getLocaleStrings('application'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            })
        );

        setTimeout(function() {
            var loadingWindow = $('.loading-window[data-id="' + id + '"]');

            if (loadingWindow.size()) {
                self.showPageLoadingFail();
            }
        }, 30000);
    },

    /**
     * IF Loading of page data failed - show user a modal window:
     */
    showPageLoadingFail: function() {
        this.stopPageLoading();

        SWCElements.modalWindow.show({
            templateID: 'application:loading-window-fail',
            templateData: {},
            className: 'loading-window-fail',

            onApply: function() {
                window.location.reload();
            }
        });
    },

    /**
     * Removes Loading / Saving dialog
     */
    stopPageLoading: function() {
        var dialog = $('#components .loading-window');

        if (dialog.size()) {
            dialog.remove();
        }
    },

    /**
     * Disable / Enable tabs on current page
     * 
     * @param isEnabled {Boolean}
     * @param options {Object} -> { className: <string>, isTabOverlay: <boolean>, ... }
     * 
     * @return void
     */
    setTabsState: function(isEnabled, options) {
        var self = this,
            pageTabs = this.$el.find('li.tab');

        if (!_.isEmpty(pageTabs)) {
            if ((this.isTabsEnabled === true && isEnabled === false) || (this.isTabsEnabled === false && isEnabled === true)) {
                _.each(pageTabs, function(tabElement, key) {
                    var $tab = $(tabElement),
                        $tabLink = $tab.find('a');

                    if (isEnabled === false) {
                        self.createDisabledOverlay($tabLink, _.extend({
                            className: $tab.hasClass('active') ? '' : 'transparent',
                            isTabOverlay: true
                        }, options));
                    } else {
                        self.removeDisabledOverlay(_.extend({
                            removeTabsOverlay: true
                        }, options));
                    }

                    $tab.toggleClass("disabled", isEnabled === false);
                });
            }

            this.isTabsEnabled = isEnabled;
        }
    },

    /**
     * Covers current page's content with an semi-transparent overlay element.
     * Thus Disables/Enables the page.
     * 
     * @param isEnabled {Boolean} Defines either page should be enabled or disabled
     * @param options {Object} Possible options:
     *                         - isPageOverlay {boolean}:     Whether or not hide page under semi-transparent overlay
     *                         - disabledBlockClass {String}: Name of CSS class with used to mark a block which will be
     *                                                        covered with overlay, instead of covering the whole page.
     *                                                        
     * @retun void
     */
    setPageState: function(isEnabled, options) {
        var self = this,
            $blockToDisable = $('.tabs-content').size() ? $('.tabs-content') : $('.base-content'),
            $disabledOverlay = $('#current-page').find('.showDisabledBackDrop.page-overlay');
        
        // Sometimes we should not add overlay to the whole page, but rather to some region on the page
        // thus we can mark such region with a special css class name passed in 'disabledBlockClass' option
        if (options && !_.isUndefined(options['disabledBlockClass'])) {
            $blockToDisable = $('#current-page').find("." + options['disabledBlockClass']);
        }

        if (isEnabled === false) {
            if (this.isPageEnabled || !$disabledOverlay.size()) {
                self.createDisabledOverlay($blockToDisable, _.extend({
                    isPageOverlay: true
                }, options));
            }
        } else {
            self.removeDisabledOverlay(_.extend({
                removePageOverlay: true
            }, options));
        }

        this.isPageEnabled = isEnabled;
    },

    /**
     * Creates an overlay element with size based on size of element to be faded with the overlay.
     * 
     * @param options {Object} Possible values:
     *                         - className {String} Name of additional css class to be added to the overlay element's.
     *                                              Could be useful if one need to cusomize the presentation of overlay.
     *                         - isTabOverlay {boolean}  Whether overlay should be placed over tab.
     *                                                   Special 'tab-overlay' css class will be added if True.
     *                         - isPageOverlay {boolean} Whether overlay should should be placed over tab.
     *                                                   Special 'page-overlay' css class will be added if True.
     * 
     * @protected Only for internal use!
     * 
     * @return void
     */
    createDisabledOverlay: function($element, options) {
        var overlay = $('<div class="showDisabledBackDrop no-highlighting"></div>');

        // Set position styles
        overlay.css({
            'top': $element.offset().top + 'px',
            'left': $element.offset().left + 'px',
            'width': $element.innerWidth(),
            'height': $element.innerHeight(),
            'display': 'block'
        });

        // Set custom properties:
        if (!_.isEmpty(options)) {
            if (!_.isEmpty(options.className)) {
                overlay.addClass(options.className);
            }

            if (options.isTabOverlay) {
                overlay.addClass("tab-overlay");
            }

            if (options.isPageOverlay) {
                overlay.addClass("page-overlay");
            }
        }

        overlay.appendTo($('#current-page'));
    },

    /**
     * Remove all disabled overlays from the page (based on arguments)
     * @param options
     */
    removeDisabledOverlay: function(options) {
        var overlays = $('#current-page').find('.showDisabledBackDrop');

        _.each(overlays, function(overlay, key) {
            var $overlay = $(overlay);

            if (!_.isUndefined(options)) {
                if (options.removeTabsOverlay === true) {
                    if ($overlay.hasClass("tab-overlay")) {
                        $overlay.remove();
                    }
                }

                if (options.removePageOverlay === true) {
                    if (!_.isUndefined(options['disabledBlockClass']) &&
                        $overlay.hasClass(options['disabledBlockClass'])) {
                        $overlay.remove();
                    } else if ($overlay.hasClass("page-overlay")) {
                        $overlay.remove();
                    }
                }
            } else {
                $overlay.remove();
            }
        });
    },

    /**
     * Display corresponding message, when the page is disabled
     * @param options {Object} -> { className: <string>, ... }
     */
    showDisabledMessage: function(options) {
        var element,
            $disabledMessage = $('<div class="showDisabledBackDropMessage no-highlighting"></div>'),
            $disabledMessageContainer = $('.tabs-content').size() ? $('.tabs-content') : $('.base-content'),
            disabledMessagePosition = {};

        // Check if options container is passed:
        if (!_.isUndefined(options) && !_.isUndefined(options.container)) {
            element = this.$el.find(options.container);
        }

        // Check if element exists on the content container:
        if (_.isUndefined(element) || !element.size()) {
            return;
        }

        // Hide previosly shown message:
        this.hideDisabledMessage(options);

        // Copy html from message in container to disabled message:
        $disabledMessage.html(element.html());

        // Append element to message container:
        $disabledMessage.appendTo($('#current-page'));

        // Set correct styles to the disabled message:
        $disabledMessage.css({
            top: $disabledMessageContainer.offset().top + ($disabledMessageContainer.outerHeight() / 2),
            left: $disabledMessageContainer.offset().left + ($disabledMessageContainer.outerWidth() / 2),
            marginTop: -($disabledMessage.outerHeight() / 2 + 50) + 'px',
            marginLeft: -($disabledMessage.outerWidth() / 2) + 'px'
        });

        // Check if additional options passed:
        if (!_.isUndefined(options.className)) {
            $disabledMessage.addClass(options.className);
        }

        // Display message after everything is set:
        $disabledMessage.show();
    },

    /**
     * Hide corresponding message, when the page is disabled
     * @param options {Object}
     */
    hideDisabledMessage: function(options) {
        $('#current-page').find('.showDisabledBackDropMessage').remove();
    },

    /**
     * Save changes button handler:
     */
    saveChanges: function() {
        var self = this,
            validation = this.pageValidation(null, true);

        // Check if page validation errors exists on the page:
        $.when(validation)
            .fail(function () {
                // validation is not passed - do nothing
            })
            .done(function () {
                // Check if necessary methods existing:
                if ($.isFunction(self.save)) {
                    // Show page loading status:
                    self.showPageLoading("Saving page data..");

                    // Wait till page saving is completed
                    $.when(self.save())
                        .done(function(message) {
                            self.setRenderFinishedHook("success", message);
                        })
                        .fail(function(message) {
                            self.setRenderFinishedHook("error", message);
                        })
                        .always(function () {
                            // Define what view has to be re-rendered:
                            if (self.parentView) {
                                self.parentView.render();
                            } else {
                                self.render();
                            }
                        });
                }
            });
    },

    setRenderFinishedHook: function (type, message) {
        var self = this;

        this.on('render:finished', function() {
            if (self.tabView) {
                self.tabView.showSaveSuccess(type, message);
            } else {
                self.showSaveSuccess(type, message);
            }
            self.off('render:finished');
        });
    },

    /**
     * Cancel changes button handler:
     */
    cancelChanges: function(e) {
        this.$('.validation-message').hide();
        this.$('.save-validation-errors').hide();
        this.$('.validation-error').removeClass('validation-error');

        if (_.isFunction(this.onCancel)) {
            this.onCancel.apply(this, arguments);
        }
        if (this.parentView) {
            if (_.isFunction(this.parentView.onCancel)) {
                this.parentView.onCancel.apply(this, arguments);
            }
            this.parentView.render();
        } else {
            this.render();
        }
        // This prevents passing Event if "Cancel" pressed in Child (TabView).
        // Otherwise, if "onCancel" defined in Parent View, it will be called twice
        if (!_.isUndefined(e)) {
            e.stopPropagation();
        }
    },

    /**
     * Show successfull page save result:
     */
    showSaveSuccess: function(type, message) {
        var container;

        container = this.$('.buttons-container-message .save-' + (type || 'success'));
        container.show();

        if (!_.isUndefined(message)) {
            container.find('.error-message').hide();
            container.find('.error-message.' + message + '-message').show();
        }
    },

    /**
     * Set buttons state on the page:
     * @param e {Object}
     * @param toDisable {Boolean}
     */
    setButtonsState: function(e, toDisable) {
        var container = this.$el.find('.buttons-container-message'),
            buttonSave = container.find('.button.save-changes'),
            buttonCancel = container.find('.button.cancel-changes'),
            allValuesDefault = this.pageCheckDefaultValues();

        // Prevent method from the double call. TabView has the same method and some times it make collisions
        if (this.hasTabs) {
            return;
        }

        if (container.size()) {
            if (toDisable || allValuesDefault) {
                buttonSave.addClass('disabled');
                buttonCancel.addClass('disabled');
            } else {
                buttonSave.removeClass('disabled');
                buttonCancel.removeClass('disabled');
            }
        }
    },

    /**
     * Get all elements on the page, which can be changed by user:
     *
     * @return Array
     */
    getElements: function() {
        var possibleElements = [
                '.swc-input', '.swc-checkbox', '.swc-extended', '.swc-radio-buttons', '.swc-dropdown'
            ];

        return this.$el.find(possibleElements.join(':not(.skip-validation),') + ':not(.skip-validation)');
    },

    /**
     * Check if after changes on the page all values are set as they were
     * before the page has loaded
     *
     * @returns {boolean}
     */
    pageCheckDefaultValues: function() {
        var isDefault = true;

        $.each(this.getElements(), function(key, element) {
            var dataParameters = getParameter($(element)),
                dataDefaultValue = $(element).data('default-value');

            if (_.isBoolean(dataDefaultValue)) {
                dataDefaultValue = dataDefaultValue.toString();
            }

            if (!_.isUndefined(dataDefaultValue)) {
                if (!_.isUndefined(dataParameters.parameterValue) && dataParameters.parameterValue.toString() !== dataDefaultValue.toString()) {
                    isDefault = false;
                }
            } else {
                if (!_.isUndefined(dataParameters.parameterValue)) {
                    isDefault = false;
                }
            }
        });

        return isDefault;
    },

    /**
     * Check if current page can be viewed in selected mode
     */
    checkPermissions: function(notFromView) {
        var currentMode = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            fixedRoute;

        if (localStorage.userMode) {
            currentMode = localStorage.userMode;
        }

        if (!notFromView) {
            swc.views.currentView = this;
        }

        if ($.inArray(currentMode, swc.views.currentView.allowedMods) === -1) {
            if (!$('ul.page-tabs').size()) {
                fixedRoute = 'overview';
            } else {
                fixedRoute = ($(swc.views.currentView.el).closest('ul.page-tabs')
                    .find('li:first a').attr('href').replace('#',''));
            }
            
            swc.router.navigate(fixedRoute, { trigger: false, skipUnsavedChanges: true });
        }
    },
    
    /**
     * Page validation called when Apply button pressed, or editable field left focus
     * Implements FIFO buffer for validation requests that they may start and finish 
     * in chronological order.
     * Normall call: stacks the parameters in buffer and then starts the processing
     * (if it is not started yet) of the first item from buffer.
     * Recursive call: processing next item from buffer. Is called each time when 
     * a validation process is finished and the buffer is not empty.
     * @params e,validateAll - the parameters for validation call.
     * @param processNext usually undefined. Is set to true in recursive call only.
     * @return Deferred object
     */
    pageValidation: function(e, validateAll, processNext) {
        var self = this,
            deferred = new $.Deferred(),
            current;

        if (this.hasTabs) {
            return deferred.resolve();
        }

        if (_.isUndefined(swc.validation)) {
            swc.validation = {};
        }

        if (_.isUndefined(swc.validation.buffer)) {
            swc.validation.buffer = [];
        }

        if (_.isUndefined(swc.validation.isInProgress)) {
            swc.validation.isInProgress = false;
        }

        if (_.isUndefined(processNext)) {
            swc.validation.buffer.push({e: e, validateAll: validateAll, deferred: deferred});
        }

        if (!swc.validation.isInProgress && !_.isEmpty(swc.validation.buffer)) {
            swc.validation.isInProgress = true;
            current = swc.validation.buffer.shift();
            $.when(self.pageValidationCore(current.e, current.validateAll))
                .done(function (result) {
                    current.deferred.resolve(result);
                })
                .fail(function (result) {
                    current.deferred.reject(result);
                })
                .always(function () {
                    swc.validation.isInProgress = false;
                    if (!_.isEmpty(swc.validation.buffer)) {
                        self.pageValidation(null, null, true);
                    }
                });
        }

        return deferred.promise();
    },

    pageValidationCore: function(e, validateAll) {
        var self = this,
            deferred = new $.Deferred(),
            promises = [],
            elementsValues = [],
            validationArray = this.tabView ? this.tabView.validation : this.validation,
            elementsToValidate = this.$el.find('.validatable:not(.skip-validation)'),
            messageValidation = this.$el.find('.buttons-container-message .save-validation-errors'),
            messageSuccess = this.$el.find('.buttons-container-message .save-success'),
            messageError = this.$el.find('.buttons-container-message .save-error'),
            allValuesDefault = this.pageCheckDefaultValues();

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            elementsValues.push(getParameter($(element)));
        });

        // Set buttons state to disabled if all values are default
        this.setButtonsState(null, !!allValuesDefault);

        // If single element validation happens
        if (e) {
            var validatableElement = $(e).hasClass('validatable') ? $(e) : $(e.target);
            elementsToValidate = validatableElement.is('.validatable:not(.skip-validation)') ? [validatableElement] : [];
        }
        
        // Validate all elements from array and show errors:
        $.each(elementsToValidate, function(key, element) {
            var validationElement = $(element),
                promise,
                parameters = getParameter(validationElement),
                validationElements = $('.validatable[name="' + parameters.parameterName + '"], .validatable[data-name="' + parameters.parameterName + '"]'),
                validationMessage = self.$el.find('.validation-message[data-parameter-name="' + parameters.parameterName + '"]'),
                validationToDo,
                validationStatus;

            // Call single validation method:
            if (validationArray[parameters.parameterName]) {
                validationToDo = validationArray[parameters.parameterName].split(':');
                
                var aModel = swc.models[validationToDo[0]];
                // It could happen that model is not initiated yet, try find object in swc.constructors next 
                if (_.isUndefined(aModel)) {
                    aModel = new swc.constructors[validationToDo[0]]();
                    if (_.isUndefined(aModel)) {
                        throw "Called validation from undefined Model - " + validationToDo[0];
                    }
                }
                validationStatus = aModel.validation[validationToDo[1]](elementsValues);

                // Check if validation is failed or success:
                // (validator can return true, false or Deferred object)
                if (_.isFunction(validationStatus.then)) { // probably a promise
                    promise = validationStatus;
                } else if (validationStatus.status === true) {
                    promise = (new $.Deferred()).resolve(validationStatus);
                } else {
                    promise = (new $.Deferred()).reject(validationStatus);
                }
            } else {
                promise = (new $.Deferred()).resolve();
            }

            promises.push(promise);

            $.when(promise)
                .done(function () {
                    // Go through all validatable group
                    $.each(validationElements, function(key, element) {
                        var currentElement = $(element);
                        self.changeValidationMessageState(currentElement, false);
                    });

                    // Display message
                    if (validationMessage.size()) {
                        validationMessage.find('.error-message').hide();
                        validationMessage.hide();
                    }
                })
                .fail(function (validationStatus) {
                    var wasShown;
                    // Go through all validateable group
                    $.each(validationElements, function(key, element) {
                        var currentElement = $(element);
                        if (currentElement.data('validation-was-shown')) {
                            wasShown = true;
                        } else {
                            currentElement.data('validation-was-shown', true);
                        }

                        self.changeValidationMessageState(currentElement, true);
                    });
    
                    // Display message
                    if (validationMessage.size()) {
                        var globalMessageContainer = validationMessage.find('.error-message[data-error="global"]');
                        validationMessage.show();
                        validationMessage.find('.error-message').hide();

                        if (wasShown || !globalMessageContainer.size()) {
                            validationMessage
                                .find('.error-message[data-error="' + validationStatus.messages[0] + '"]').show();
                        } else {
                            globalMessageContainer.show();
                        }
                    }
                });
        });

        // Hide messages about successfull and error saves
        messageSuccess.hide();
        messageError.hide();

        // Hide "Fix errors on the page" message
        $.when.apply(null, promises)
            .done(function () {
                messageValidation.hide();
                deferred.resolve();
            })
            .fail(function () {
                if (validateAll) {
                    messageValidation.show();
                } else {
                    messageValidation.hide();
                }
                deferred.reject();
            });

        return deferred.promise();
    },

    changeValidationMessageState: function (element, on) {
        if (on) {
            element.addClass('validation-error');
            element.data('validation-error', true);
            element.trigger('validation-fail');
        } else {
            element.removeClass('validation-error');
            element.data('validation-error', false);
            element.trigger('validation-success');
        }
    },

    /**
     * Remove all existing validation messages on the page:
     */
    clearValidationMessages: function(input){
        var inputName,
            validationMessages;

        // If an input is passes then we have to clear
        // the validation messages for the input only:
        if (input) {
            inputName = $(input).data('name');
            validationMessages = $('.validation-message[data-parameter-name="' + inputName + '"]');
            validationMessages.hide();
            validationMessages.find('.error-message').hide();
            $(input).filter('.validation-error').removeClass('validation-error');
            return;
        }

        $('.validation-message').hide();
        $('.save-validation-errors').hide();
        $('.validation-message .error-message').hide();
        $('.validation-error').removeClass('validation-error');
    },

    /**
     * Init listener for current view:
     */
    startListener: function() {
        var pagesMatch = false,
            pagesRoutes = swc.settings.application.get('navigation'),
            self = this,
            page = Backbone.history.fragment;

        // Check if listener available on current page
        if (!this.listenerPages.length) {
            pagesMatch = true;
        } else {
            $.each(this.listenerPages, function(key, value) {
                if (pagesRoutes[value] === page) {
                    pagesMatch = true;
                }
            });
        }

        // Check if everything is correct:
        if (pagesMatch && this.listenerEnabled) {
            if (!this.listenerWorking) {

                // Set flag to listener to be in process:
                this.listenerWorking = true;

                this.listenerIntervalMethod = setInterval(function() {
                    var pagesMatch = false,
                        pagesRoutes = swc.settings.application.get('navigation'),
                        page = Backbone.history.fragment;

                    // Check if listener available on current page
                    if (!self.listenerPages.length) {
                        pagesMatch = true;
                    } else {
                        $.each(self.listenerPages, function(key, value) {
                            if (pagesRoutes[value] === page) {
                                pagesMatch = true;
                            }
                        });
                    }

                    // Check if no restrictions
                    if (pagesMatch) {
                        $.when(self.loadModels(true)).done(function() {
                            if (_.isFunction(self.onListenerComplete)) {
                                self.onListenerComplete();
                            }
                        });
                    } else {
                        self.stopListener();
                    }
                }, self.listenerInterval * 1000);
            }
        } else {
            this.stopListener();
        }
    },

    /**
     * Stop current view listener working:
     */
    stopListener: function() {
        // Set listening flag to false:
        this.listenerWorking = false;

        // Remove current interval variable:
        clearInterval(this.listenerIntervalMethod);
    },

    customizeDevice: function(options) {
        var pages,
            devicesNames = swc.models.Locale.getLocaleStrings('overview/modal-windows/customize-device'),
            pageActive = 1,
            pageItems = 6, // Number of devices on one row
            // the list of supported devices which has device's type as a key
            allDeviceTypes = swc.settings.application.get('supported' + options.type.capitalize() + 'Devices'),
            // the array of device's types which can be associated with device only automatically
            nonCustomizableDevices = ['unrecognized', 'multisensor', 'switch'],
            supportedDeviceTypes = [],
            sahDeviceTypes;
        
        if (options.type !== 'dect'){
            // Check if this is unsupported device and overwrite current device's type with default value
            if (!allDeviceTypes[options.device.type]) {
                options.device.type = allDeviceTypes['unrecognized'].deviceTypeDefault;
            }

            // Pass translation for each device
            $.each(allDeviceTypes, function(supportedKey, supportedDevice) {
                var deviceText = devicesNames[supportedDevice.deviceTypeLocalized];

                // Set device type to be localised
                if (!_.isUndefined(deviceText) && !_.isEmpty(deviceText)) {
                    supportedDevice.deviceTypeText = deviceText;
                } else {
                    supportedDevice.deviceTypeText = supportedDevice.deviceTypeLocalized;
                }

                if ($.inArray(supportedKey, nonCustomizableDevices) === -1) {
                    supportedDeviceTypes[supportedKey] = supportedDevice;
                }
            });

            // In order to implement simple pagination, let's pass additional array consisting of keys of supported devices.
            // SAH returns some device type as several words separated with space
            sahDeviceTypes = _.keys(supportedDeviceTypes);
            
            pages = Math.ceil(getObjectLength(sahDeviceTypes) / pageItems);
        
        }

        /**
         * Validates device name, also triggers validation failed handlers,
         * like show error message
         * 
         * NOTE: "During the HPQC review meeting Simon Maurer approved to "allow basically everything" here"
         * 
         * @param modal {PopoverWindow} Instance of current modal popover window
         * @param name {String} Name of device to be validated
         * 
         * @return {boolean} true if name is valid
         */
        var validateDeviceName = function (modal, name) {

            var validationMessage = modal.find('.validation-message'),
                validationError = false;

            // allowed basically anything, from 1 to 32 characters length
            if (!/^.{1,32}$/.test(name)) {
                validationError = true;
            }

            if (validationError) {
                validationMessage.show();
                validationMessage.find('.error-message[data-error="global"]').show();
            } else {
                validationMessage.hide();
                validationMessage.find('.error-message[data-error="global"]').hide();
            }

            modal.find('input[name="device-name"]').toggleClass('validation-error', validationError);

            return !validationError;
        };

        SWCElements.modalWindow.show({
            templateID: options.template || 'overview:modal-windows:customize-device',
            templateData: {
                device: options.device,
                pages: pages,
                pagesArray: new Array(pages),
                pageItems: pageItems,
                pageActive: pageActive,
                supported: supportedDeviceTypes,
                sahDeviceTypes: sahDeviceTypes
            },
            className: 'customize-device',

            onShow: function() {
                var modal = $('.modalWindow'),
                    rows = modal.find('.devices-list-scroll'),
                    devices = modal.find('.device'),
                    switchPage = function(page) {
                        var pages = modal.find('.switch-page');

                        // Set active class to current page:
                        pages.removeClass('active');
                        modal.find('[data-page="' + page + '"]').addClass('active');

                        // Set active class to current row:
                        rows.removeClass('active');
                        modal.find('[data-page="' + page + '"]').addClass('active');
                    };

                // Display necessary row:
                rows.removeClass('active');
                modal.find('[data-page="' + pageActive + '"]').addClass('active');

                // Handle click on devices:
                modal.on('click', '.device', function(e) {
                    var hasChanges = false,
                        element = $('input[name="device-name"]'),
                        newType = $(this).data('type'),
                        newName = modal.find('input[name="device-name"]').val();

                    devices.removeClass('selected');
                    $(this).addClass('selected');

                    if (newType !== element.data('type') || newName !== element.data('name')) {
                        hasChanges = true;
                    }

                    modal.find('.button.apply-changes').toggleClass('disabled', !hasChanges);
                });

                modal.on('click', '.navigation.left:not(.disabled)', function(e) {
                    var currentPageElement = modal.find('.page.active'),
                        currentPageNumber = currentPageElement.data('page') || 1,
                        nextPageNumber = currentPageNumber - 1,
                        nextPageElement = modal.find('.page[data-page="' + nextPageNumber + '"]');

                    if (nextPageElement.size()) {
                        switchPage(nextPageNumber);
                    } else {
                        switchPage(currentPageNumber);
                    }
                });

                modal.on('click', '.navigation.right:not(.disabled)', function(e) {
                    var currentPageElement = modal.find('.page.active'),
                        currentPageNumber = currentPageElement.data('page'),
                        nextPageNumber = currentPageNumber +  1,
                        nextPageElement = modal.find('.page[data-page="' + nextPageNumber + '"]');

                    if (nextPageElement.size()) {
                        switchPage(nextPageNumber);
                    } else {
                        switchPage(currentPageNumber);
                    }
                });

                modal.on('click', '.switch-page', function(e) {
                    var pageElement = $(e.target).closest('.switch-page'),
                        pageNumber = pageElement.data('page');

                    switchPage(pageNumber);
                });

                modal.on('keyup', 'input[name="device-name"]', function(e) {
                    var hasChanges = false,
                        element = $(e.target),
                        newType = modal.find('.device').filter('.selected').data('type'),
                        newName = modal.find('input[name="device-name"]').val();

                    if (newType !== element.data('type') || newName !== element.data('name')) {
                        hasChanges = true;
                    }

                    modal.find('.button.apply-changes').toggleClass('disabled', !hasChanges);
                });

                modal.on('change', 'input[name="device-name"]', function(e) {
                    var deviceName = $.trim($(this).val());
                    validateDeviceName(modal, deviceName);
                });
            },

            onCancel: function() {
                if (options.onCancel && $.isFunction(options.onCancel)) {
                    options.onCancel();
                }
            },

            onApply: function() {
                var modal = $('.modalWindow'),
                    $input = modal.find('input[name="device-name"]'),
                    deviceType = modal.find('.device').filter('.selected').data('type'),
                    deviceName = $.trim($input.val()),
                    deviceMac = $input.data('mac');

                if (options.onApply && $.isFunction(options.onApply) && validateDeviceName(modal, deviceName)) {
                    if (options.type==='dect') {
                        options.onApply({
                            line: $input.data('line'),
                            name: deviceName
                        });
                    } else {
                        options.onApply({
                            deviceMac: deviceMac,
                            deviceType: deviceType,
                            deviceName: deviceName
                        });
                    }

                    SWCElements.modalWindow.hide();
                }
            }
        });
    },

    /**
     * Generate Expandable element
     * @param options {Object}
     */
    generateExpandableList: function(options) {
        var template = $.template("expandable-list", swc.Templates.get("components:expandable-list").get('content')),
            objectToTemplate = {
                titleBlocks: {},
                itemsBlocks: {}
            };

        // Generate Title Block
        $.each(options.titleBlocks, function(key, block) {
            if (block.templateID && block.templateValues) {
                var html,
                    plainHTML = '';

                // Upgrade basic passed values:
                block.templateValues.localeStrings = options.locales;
                block.templateValues.localeString = getTranslationStringsjQuery;
                block.templateValues.formatDate = swc.models.Locale.formatDate;

                html = $.tmpl(
                    $.template("component-" + key, swc.Templates.get(block.templateID).get('content')), block.templateValues
                );

                $.each(html, function(key, value) {
                    if (value.outerHTML) {
                        plainHTML = plainHTML + value.outerHTML;
                    }
                });

                objectToTemplate.titleBlocks[key] = plainHTML;
            }

            if (block.translationString) {
                if (options.locales[block.translationString]) {
                    objectToTemplate.titleBlocks[key] = options.locales[block.translationString];
                } else {
                    objectToTemplate.titleBlocks[key] = "<span class='missed-string'>" + block.translationString + "</span>";
                }
            }

            if (block.plaintext) {
                objectToTemplate.titleBlocks[key] =  block.plaintext;
            }
        });

        // Generate Items blocks
        $.each(options.itemsBlocks, function(listItemID, listItem) {
            objectToTemplate.itemsBlocks[listItemID] = {
                blocks: {},

                isEditAble: listItem.isEditAble ? true : false,
                isDeleteAble: listItem.isDeleteAble ? true : false
            };

            $.each(listItem.blocks, function(key, block) {
                if (block.templateID && block.templateValues) {
                    var html,
                        plainHTML = '';

                    // Upgrade basic passed values:
                    block.templateValues.localeStrings = options.locales;
                    block.templateValues.localeString = getTranslationStringsjQuery;
                    block.templateValues.formatDate = swc.models.Locale.formatDate;

                    html = $.tmpl(
                        $.template("component-" + key, swc.Templates.get(block.templateID).get('content')), block.templateValues
                    );

                    $.each(html, function(key, value) {
                        if (value.outerHTML) {
                            plainHTML = plainHTML + value.outerHTML;
                        }
                    });

                    objectToTemplate.itemsBlocks[listItemID].blocks[key] = plainHTML;
                }

                if (block.translationString) {
                    if (options.locales[block.translationString]) {
                        objectToTemplate.itemsBlocks[listItemID].blocks[key] = options.locales[block.translationString];
                    } else {
                        objectToTemplate.itemsBlocks[listItemID].blocks[key] = "<span class='missed-string'>" + block.translationString + "</span>";
                    }
                }

                if (block.plaintext) {
                    objectToTemplate.itemsBlocks[listItemID].blocks[key] =  block.plaintext;
                }
            });

            if (listItem.hiddenPart.templateID && listItem.hiddenPart.templateValues) {
                var html,
                    plainHTML = '';

                // Upgrade basic passed values:
                listItem.hiddenPart.templateValues.localeStrings = options.locales;
                listItem.hiddenPart.templateValues.localeString = getTranslationStringsjQuery;
                listItem.hiddenPart.templateValues.formatDate = swc.models.Locale.formatDate;

                html = $.tmpl(
                    $.template("component-" + listItemID, swc.Templates.get(listItem.hiddenPart.templateID).get('content')), listItem.hiddenPart.templateValues
                );

                $.each(html, function(key, value) {
                    if (value.outerHTML) {
                        plainHTML = plainHTML + value.outerHTML;
                    }
                });

                objectToTemplate.itemsBlocks[listItemID].hiddenPart = plainHTML;
            }
        });

        var domElement = $.tmpl(template, {
            titleBlocks: objectToTemplate.titleBlocks,
            items: objectToTemplate.itemsBlocks,
            localeStrings: options.locales,
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        });

        if(options.openedTab){
            domElement.find('.expandable-list-item[data-key='+options.openedTab+']').addClass('expanded');
        }

        return domElement;
    }
});

/**
 * Base BackBone view for displaying tabs in pages
 *
 * @type {*}
 *
 */
swc.base.TabView = swc.base.PageView.extend({

    /**
     * Initialise view
     */
    initialize: function() {
        var pagesArray = Backbone.history.fragment.split("/");

        // Define tab template and locale ID:
        this.pageTemplateID = pagesArray[0] + ':' + pagesArray[1] + ':' + pagesArray[2];

        // Prepare template for current tab:
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    }
});

/**
 *
 * Backbone view for Scheduler line
 *
 * @type {*}
 *
 */
swc.constructors.SchedulerLiner = swc.base.PageView.extend({
    className: 'ranges-block',

    events: {
        'mousedown .diap_container':'new_diapazon',
        'mousedown .left_part': 'modify_start',
        'mousedown .right_part': 'modify_start',
        'mousedown .half': 'modify_start',
        'mousemove': 'modify',
        'mouseleave': 'modify_stop',
        'mouseup': 'modify_stop',
        'click .diapazon': 'prevent_creating',
        'touchstart': 'mobilePreventScroll',
        'touchstart .mobile-block': 'mobileNewDiap',
        'touchmove .mobile-block': 'mobileModify',
        'touchleave .mobile-block': 'mobileModifyStop',
        'touchend .mobile-block': 'mobileModifyStop',
        'touchcancel .mobile-block': 'mobileModifyStop'
    },

    prevent_creating: function(e){
        e.stopPropagation();
    },

    mobilePreventScroll: function(e){
        e.preventDefault();
    },

    mobileNewDiap: function(e){
        e.pageX = e.originalEvent.pageX;
        $(e.target).hide();
        var targetElement = document.elementFromPoint(e.originalEvent.targetTouches[0].clientX, e.originalEvent.targetTouches[0].clientY);
        $(e.target).show();
        if($(targetElement).hasClass('diap_container')){
            e.target = targetElement;
            this.new_diapazon(e);
        } else if($(targetElement).hasClass('left_part') || $(targetElement).hasClass('right_part')){
            e.target = targetElement;
            this.modify_start(e);
        }
    },

    mobileModify: function(e){
        e.pageX = e.originalEvent.pageX;
        this.modify(e);
    },

    mobileModifyStop: function(e){
        this.modify_stop(e);
    },

    /**
     * creates new range
     * @param e
     */
    new_diapazon: function(e){
        var self = this, target,
            element = $(e.target);

        if (!this.isDisabled && !element.closest('.diapazon')[0]) {
            var schedulerIndex = $('.schedulers').index(element.closest('.schedulers')),
                linerIndex = element.closest('.schedulers').find('.liner').index(element.closest('.liner'));

            e.stopPropagation();
            e.preventDefault();

            if(typeof e.offsetX === "undefined") {
                var targetOffset = element.offset();
                e.offsetX = e.pageX - targetOffset.left;
            }

            this.modifyProcess = true;
            this.markForDelete = false;

            var startCoord = this.stepWidth*(Math.floor(e.offsetX/this.stepWidth));

            if (e.offsetX>=this.scaleWidth-this.stepWidth) {
                startCoord = this.scaleWidth-this.stepWidth;
            }

            var endCoord = startCoord + this.stepWidth;
            var conflictsDiapazon = false;

            var currentDay = 'monday';
            _.each(element.closest('.liner').attr('class').split(' '), function(key){
                if(key.indexOf('day') > -1){
                    currentDay = key;
                }
            });
            this.currentDiapazon = this.diapazones[currentDay];

            _.each(this.currentDiapazon, function(diapazon){
                if(startCoord === diapazon.end || (startCoord >= diapazon.begin-self.stepWidth && startCoord <= diapazon.begin)){
                    conflictsDiapazon = true;
                }
            });

            if(!conflictsDiapazon){

                this.currentDiapazon.push({
                    begin: startCoord,
                    end: endCoord
                });
                swc.constructors.dispatcher.trigger('scheduler:change');
                this.options.model.trigger('change:pixelSchedule', this.options.model);
                this.render();

                $('.schedulers').eq(schedulerIndex).find('.liner').eq(linerIndex).find('.diapazon').each(function(index, el){
                    if($(el).css('left') === startCoord+'px'){
                        target = $(el).find('.half')[0];
                    }
                });

                if(target){
                    self.modify_start({target: target, preventDefault: e.preventDefault, stopPropagation: e.stopPropagation});
                }
            } else {
                this.modifyProcess = false;
            }
        }
    },

    /**
     * Starts the modify of some range - calls when mousedown on left or right part of range
     * @param e
     */
    modify_start: function(e){
        e.preventDefault();
        e.stopPropagation();
        var self = this;

        if(!this.isDisabled){
            this.modifyProcess = true;
            this.mouseStart = e.target.offsetLeft + e.target.parentNode.offsetLeft;


            var element = $(e.target);

            // info for modified element searching - needed for popover
            this.elementInfo = {};
            this.elementInfo.operatedLineIndex = $('.schedulers .liner').index(element.closest('.liner'));

            var currentDay = 'monday';
            _.each($(e.target).closest('.liner').attr('class').split(' '), function(key){
                if(key.indexOf('day') > -1){
                    currentDay = key;
                }
            });
            this.currentDiapazon = this.diapazones[currentDay];

            this.operatedDiapazon = {};
            $.each(this.currentDiapazon, function(index, diapazon){
                if(diapazon.begin <= self.mouseStart && diapazon.end + self.stepWidth > self.mouseStart){
                    self.operatedDiapazon = diapazon;
                    self.currentDiapazon.splice(index, 1);
                    self.currentDiapazon.push(self.operatedDiapazon);
                    return false;
                }
            });
            var maxRightAlpha = this.scaleWidth;
            var maxLeftAlpha = this.scaleWidth;
            this.nearestDiapazonStart = 0;
            this.nearestDiapazonFinish = 0;

            $.each(this.currentDiapazon, function(index, diapazon){
                if(diapazon.begin !== self.operatedDiapazon.begin){

                    if(diapazon.begin > self.operatedDiapazon.end){
                        if((diapazon.begin - self.operatedDiapazon.end)<maxRightAlpha){
                            maxRightAlpha = (diapazon.begin - self.operatedDiapazon.end)-self.stepWidth;
                        }
                    }
                    if(diapazon.end < self.operatedDiapazon.begin){
                        if((self.operatedDiapazon.begin - diapazon.end)<maxLeftAlpha){
                            maxLeftAlpha = (self.operatedDiapazon.begin - diapazon.end)-self.stepWidth;
                        }
                    }
                }
            });


            if(maxRightAlpha >= this.scaleWidth){
                maxRightAlpha = this.scaleWidth - this.operatedDiapazon.end;
            }
            if(maxLeftAlpha >= this.scaleWidth){
                maxLeftAlpha = this.operatedDiapazon.begin;
            }

            this.nearestDiapazonStart = this.operatedDiapazon.end + maxRightAlpha;
            this.nearestDiapazonFinish = this.operatedDiapazon.begin - maxLeftAlpha;

            $('body').trigger('popover:close');

            if(element.hasClass('left_part')){
                this.partModified = 'left';
            } else if(element.hasClass('right_part')) {
                this.partModified = 'right';
            } else {
                this.partModified = 'both';
            }

            if(element.hasClass('left_part') || element.hasClass('right_part')){
                element.trigger('popover:toggle');
            }

            this.allowModify = true;
        }
    },

    /**
     * Proceed with modify - calls on mousemove with mousedown
     * @param e
     */
    modify: function(e){
        e.preventDefault();
        e.stopPropagation();

        if(this.modifyProcess && this.allowModify && !this.isDisabled){
            var self = this, element;
            this.allowModify = false;

            setTimeout(function(){
                self.allowModify = true;
            }, 20);


            var currentCoord = e.pageX - $(this.el).find('.diap_container').eq(0).offset().left;
            var coordsAlpha = this.stepWidth*(Math.round((currentCoord - this.mouseStart)/this.stepWidth));

            if(coordsAlpha!==0){
                var diapazonBackup = _.clone(this.operatedDiapazon);
                this.currentDiapazon.pop();

                if(this.partModified === 'right'){
                    this.operatedDiapazon.end += coordsAlpha;
                } else if(this.partModified === 'left') {
                    this.operatedDiapazon.begin += coordsAlpha;
                } else {
                    if(coordsAlpha > 0){
                        this.partModified = 'right';
                        this.operatedDiapazon.end += this.stepWidth;
                    } else {
                        this.partModified = 'left';
                        this.operatedDiapazon.begin -= this.stepWidth;
                    }
                }


                if(this.operatedDiapazon.end < this.operatedDiapazon.begin + this.stepWidth){
                    if(this.partModified === 'right'){
                        this.mouseStart = diapazonBackup.end;
                    } else {
                        this.mouseStart = diapazonBackup.begin;
                    }
                    this.currentDiapazon.push(diapazonBackup);
                    this.markForDelete = true;
                    if(this.partModified === 'right'){
                        this.operatedDiapazon.end = this.operatedDiapazon.begin + this.stepWidth;
                    } else {
                        this.operatedDiapazon.begin = this.operatedDiapazon.end - this.stepWidth;
                    }

                } else if(this.operatedDiapazon.begin < this.nearestDiapazonFinish){
                    this.operatedDiapazon.begin = this.nearestDiapazonFinish;
                    this.currentDiapazon.push(this.operatedDiapazon);
                } else if(this.operatedDiapazon.end > this.nearestDiapazonStart){
                    this.operatedDiapazon.end = this.nearestDiapazonStart;
                    this.currentDiapazon.push(this.operatedDiapazon);
                } else {
                    this.mouseStart += coordsAlpha;
                    this.currentDiapazon.push(this.operatedDiapazon);
                    this.markForDelete = false;

                    $('body').trigger('popover:close');
                    this.render();

                    /**
                     * Search for modified element
                     */
                    $('.schedulers .liner').eq(this.elementInfo.operatedLineIndex).find('.diapazon').each(function(index, el){
                        if($(el).css('left') === self.operatedDiapazon.begin+'px'){
                            element = $(el).find('.'+self.partModified+'_part');
                        }
                    });

                    if((this.operatedDiapazon.end - this.operatedDiapazon.begin) > 9){
                        element.trigger('popover:toggle');
                    }
                }
            }
        }
    },

    /**
     * Stops the modifications and triggers 'change' event on model
     * calls when mouseup or mouseleave the view container
     * @param e
     */
    modify_stop: function(e){
        $('body').trigger('popover:close');

        if(this.modifyProcess){
            this.modifyProcess = false;
            if(this.markForDelete){
                this.currentDiapazon.pop();
            }
            swc.constructors.dispatcher.trigger('scheduler:change');
            this.options.model.trigger('change:pixelSchedule', this.options.model);
            this.render();
        }
    },

    initialize: function(){
        /**
         * when true, scheduler is grey and could not be modified
         * @type {*|Boolean}
         */
        this.isDisabled = this.options.isDisabled || false;
        /**
         * width of scheduler line - usually is 432
         * @type {number}
         */
        this.scaleWidth = this.options.scaleWidth || 432;
        /**
         * width of one part on liner, usually is 432/48 = 9, 48 - number of 30-minutes pieces in one day
         * @type {number}
         */
        this.stepWidth = this.scaleWidth/48;
        /**
         * object with ranges
         * @type {*}
         */
        this.diapazones = this.options.diapazones;
        /**
         * What will be scheduled?
         * @type: string
         */
        this.schedulerType = this.options.schedulerType;

        /**
         *  block for mobile manipulations
         */
        if(detectMobileBrowser()){
            var mobileBlock = $('<div/>', {'class': 'mobile-block'}).css({'width':'100%', 'height':'100%'});
            this.$el.append(mobileBlock);
        }

        this.render();
    },

    render: function(){
        var self = this;
        var element = $(this.el);

        var template = $.tmpl(swc.Templates.get('core:scheduler:table').get('content'),{
            'isDisabled': this.isDisabled,
            'stepWidth': this.stepWidth,
            'scaleWidth' : this.scaleWidth,
            'schedulers' : this.diapazones,
            'type': this.schedulerType,
            'localeStrings': swc.models.Locale.getLocaleStrings('core'),
            'localeString': getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        })[0];

        element.find('.' + $(template).attr('class')).remove();
        element.append(template);
        return this;
    }
});


/**
 * A view based on models collection 
 */
swc.base.listView = Backbone.View.extend({
    // model: colection

    itemView: '',

    initialize: function (options) {
        var self = this;
        this.options = options;
        Backbone.View.prototype.initialize.call(this, options);
        this.itemView = options.itemView;
        this.model.on('change', function () { self.render();});
    },

    renderComplete: function () {
        // to be overriden
        if (_.isFunction(this.options.renderComplete)) {
            return this.options.renderComplete.apply(this, arguments);
        }
    },

    preRender: function () {
        if (_.isFunction(this.options.preRender)) {
            return this.options.preRender.apply(this, arguments);
        }
        return (new $.Deferred()).resolve();
    },

    render: function (){
        var self = this,
            promise;

        if (self.hasTabs) {
            promise = self.tabView.preRender();
        } else {
            promise = self.preRender();
        }

        $.when(promise)
            .done(function() {
                // render each collection item:
                self.$el.empty();

                _.each(self.model.models, function (model, idx) {
                    var view = new swc.constructors[self.itemView]({model: model});
                    self.$el.append(view.render().el);
                });

                self.renderComplete();
            });

        return this;
    }
});
;swc.BaseCollection = Backbone.Collection.extend({

    /**
     * @override on default {'Backbone.Collection.defaults'} property
     *
     * Default values for collection
     *
     * @param defaults {Array of Objects}
     */
    defaults: [],

    /**
     * @override on default {'Backbone.Collection.url'} property
     *
     * URL for collection to be synced / fetched. Can be either string or object formated to default backbone SYNC actions
     *
     * @description
     *
     * url: '/books/' || url: {
     *      'read': '/books/get',
     *      'create': '/books/set',
     *      'update': '/books/edit',
     *      'delete': '/books/delete'
     * }
     *
     * @param url {String || Object}
     */
    url: '',

    /**
     * @override on default {'Backbone.Collection.model'} property
     *
     * Model id assigned to the collection. Each collection model will be created using this constructor
     *
     * @description
     *
     *      When {'.initialize()'} method will be called, collection will check if current model id is a valid
     *      constructor and exists in swc.models.* scope. If everything is OK -> this constructor will be used
     *      for any model assigned to this collection.
     *
     * @param model {String || Function -> Constructor}
     */
    model: '',

    /**
     * Temporary value for application, to know that this collection have to be handled by other way
     *
     * FIXME :: remove this when all models and collection will be moved to the new architecture
     *
     * @description
     *
     * This will be removed when all collections will be moved to new architecture
     *
     * @param isNewArchitecture {Boolean}
     */
    isNewArchitecture: true,

    /**
     * The flag if collection will be synced even if it has been changed
     * @param isForceSync {Boolean}
     */
    isForceSync: false,

    /**
     * Parameters for sending '{READ}' request to the server
     *
     * @param ajaxParameters {Object}
     */
    ajaxParameters: {
        'parameters': {}
    },

    /**
     * Parameter for sending '{ANY}' type of request to the server, default ajax options for the collection:
     *
     * @param ajaxSettings {Object}
     */
    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: 'application/x-sah-ws-4-call+json'
    },

    /**
     * @override on default {'Backbone.Collection.initialize()'} method
     *
     * @description
     *
     *      Initialize method sets models which are passed to the constructor. If this models are empty,
     *      collection will be filled in with {'this.defaults'}. If {'this.defaults'} will be empty, collection
     *      during initialization will also be empty.
     *
     *      Also in this method collection decides what model constructor will be used for it's models.
     *
     *      if {'this.model'} is passed as a function, consistancy of Backbone.Collection.model will be saved. If
     *                        Function is not a constructor, error will be thrown.
     *
     *      if {'this.model'} is passed as a string, initialize method will go through models constructors scope and look
     *                        for constructor with the same id. If constructor will be found, it will be assigned as a
     *                        collection constructor, else error will be thrown
     *
     *      if {'this.model'} is passed as it is, (is not overrided by extending collection) swc.BaseModel will be set as
     *                        collection models constructor
     *
     */
    initialize: function(models, options) {

        // Define what will be set as collection models:
        models = !_.isEmpty(models) ? models : this.defaults;

        // Saving posibility of native Backbone.Collection.model property to be a constructor itself
        if (!_.isUndefined(this.model) && !_.isEmpty(this.model)) {
            if (_.isString(this.model)) {

                // TODO :: when swc.constructors will be separated to swc.constructors.models -> change this

                if (!_.isFunction(swc.constructors[this.model])) {
                    throw new Error("swc.constructors." + this.model + " is undefined or not a constructor");
                } else {
                    this.model = swc.constructors[this.model];
                }
            } else {
                if (!_.isFunction(this.model)) {
                    throw new Error(this.model + " is undefined or not a constructor");
                }
            }
        } else {
            this.model = swc.BaseModel;
        }

        this.reset(models, _.extend({ silent: true }, options));
    },

    /**
     * @override on default {'Backbone.Collection.sync()'} method
     *
     * Syncs collection with a server
     *
     * @param method {String} -> one of backbone supported methods (Read, Update, Create, Delete)
     * @param options {Object} (optional)
     */
    sync: function(method, options) {
        var self = this,
            url = this.url,
            deferred = new $.Deferred();

        // Define action which has to be processed:
        if (_.isObject(this.url) && !_.isEmpty(this.url[method])) {
            url = this.url[method];
        }

        // Reset collection on read method if no changes were done and sync request is not from listener:
        if (!this.canChangeCollection()) {
            return deferred.resolve(); // No need to sync collection if it was changed by user
        } else {
            this.reset([], _.extend({ silent: true }, options));
        }

        // Send request to the server and fill the model with data
        $.when(self.sendRequest(method, url, options))
            .done(function(response) {

                if (self.canChangeCollection()) {
                    self.set(self.parse(response));
                    self.trigger('change');
                }

                deferred.resolve();
            })
            .fail(function(xhr, ajaxOptions, thrownError) {

                if (self.canChangeCollection()) {
                    self.set(self.defaults);
                }

                deferred.reject(xhr, ajaxOptions, thrownError);
            });

        return deferred.promise();
    },

    canChangeCollection: function(method, options) {
        if (method === "read" && !this.isForceSync) {
            if (!_.isUndefined(options) && options.isListener === true && this.hasChanged()) {
                return false;
            }
        }

        return true;
    },
    /**
     * Send ajax request to the server when collection sync is processed:
     *
     * @param method {String}
     * @param url {String}
     * @param options {Object}
     *
     * @returns {*}
     */
    sendRequest: function(method, url, options) {
        var self = this,
            deferred = new $.Deferred(),
            data = method === "read" ? self.ajaxParameters : self.toJSON(options),
            requestType = this.ajaxSettings.requestType,
            timeout = !_.isUndefined(options) && !_.isUndefined(options.timeout) ? options.timeout : 20000,
            headers = {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            };

        // Check if something is missing from mandatory arguments:
        if (_.isEmpty(url) || _.isEmpty(method)) {
            return deferred.resolve();
        }

        // Check if current request is making in background:
        if (!_.isUndefined(options) && !_.isUndefined(options.isListener)) {
            headers.idle = true;
            headers['X-Sah-Request-Type'] = 'idle';
        }

        // Check if it's needed different request types for get / set requests
        if (_.isObject(this.ajaxSettings.requestType) && !_.isEmpty(this.ajaxSettings.requestType[method])) {
            requestType = this.ajaxSettings.requestType[method];
        }

        // Send request to the server:
        $.ajax({
            url: url,
            type: requestType,
            dataType: self.ajaxSettings.requestDataType,
            contentType: self.ajaxSettings.contentType,
            headers: headers,
            timeout: timeout,

            cache: false,

            data: $.isPlainObject(data) ? JSON.stringify(data) : data,

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                deferred.resolve(response);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                swc.models.Login.checkAccessToDevice(xhr);
                deferred.reject(xhr, ajaxOptions, thrownError);
            },

            statusCode: {

                403: function() {
                    // TODO :: crete handling of this errors:
                },

                404: function() {
                    if (_.isFunction(this.on404)) {
                        this.on404();
                    }
                },

                500: function() {
                    // TODO :: crete handling of this errors:
                },

                502: function() {
                    if (_.isFunction(this.on502)) {
                        this.on502();
                    }
                }

            }
        });

        return deferred.promise();
    },

    /**
     * @override on default {'Backbone.Collection.parse()'} method
     *
     * This method is called whenever a collection's data is returned by the server, in fetch, and save. The function is
     * passed the raw response object, and should return the attributes hash to be set on the collection
     *
     * @param response {Object}
     * @param options {Object} (optional)
     *
     * @returns {Object}
     */
    parse: function(response, options) {
        var json = response;

        if (_.isFunction(this.apiToJSON)) {
            json = this.apiToJSON(json);
        }

        return json;
    },

    /**
     * @override on default {'Backbone.Collection.toJSON()'} method
     *
     * Transform collection to valid JSON. Goes through each model and call's it {'toJSON()'} method
     *
     * @param options {Object}
     *
     *      options = { showDeleted: true } -> includes deleted models to list of models
     *      options = {} -> includes only not deleted models
     *
     * @returns {Array of Objects}
     */
    toJSON: function(options) {
        var json = [];

        _.each(this.models, function(model, key) {
            if (_.isUndefined(model.get('isDeletedByCollection'))) {
                json.push(Backbone.Model.prototype.toJSON.apply(model));
            } else {
                if (!_.isUndefined(options) && options.showDeleted === true) {
                    json.push(Backbone.Model.prototype.toJSON.apply(model));
                }
            }
        });

        return json;
    },

    /**
     * @override on default {'Backbone.Collection.remove()'} method
     *
     * We need to know what models were removed from the collections, to sync them with server
     *
     * @param models {Array of Objects || Objects}
     * @param options {Object}
     *
     * @description
     *
     *      options = { permanent: true } will use native Backbone.Collection.remove();
     *
     *      When options are not passed, there works an override on default Backbone.Collection.Remove() method
     *      which set Model custom parameter {'isDeletedByCollection'} to true, which let's collection know that
     *      this model was deleted from the collection.
     *
     *      This case will be needed to get list of deleted models, when collection will be saving. Because NP doesn't
     *      support Full REST api, so it will be needed to go through all {isDeletedByCollection} models and sync them
     *      with server
     */
    remove: function(models, options) {
        var modelsDiff = [];

        if (!_.isUndefined(options)) {
            if (!_.isUndefined(options.permanent) && options.permanent === true) {
                Backbone.Collection.prototype.remove.apply(this, arguments);
            }
        } else {

            if (!_.isUndefined(models) && !_.isEmpty(models)) {
                modelsDiff = !_.isArray(models) ? [ models ] : models;
            }

            _.each(modelsDiff, function(model, key) {
                model.set('isDeletedByCollection', true);
            });
        }
    },

    /**
     * Creating similar to Backbone.Model.hasChanged() method, which will say if collection has changed:
     *
     * @description:
     *
     *      Goes through each model in the collections and call it's method {'.hasChanged()'}
     *      If one the models will return {'true'} that will mean that collection has changed
     *
     * // TODO :: improvement allow pass list of model as arguments.
     *
     * @returns {Boolean}
     */
    hasChanged: function() {
        var hasChanged = false;

        _.each(this.models, function(model) {
            if (model.hasChanged()) {
                hasChanged = true;
            }
        });
        
        return hasChanged;
    },

    /**
     * Get list of changed models. Including edited / deleted models:
     *
     * @param options {Object}
     *
     * @description
     *
     *      options = { onlyEdited: true } will return only changed models (excluding deleted);
     *      options = { onlyDeleted: true } will return only deleted models (excluding changed);
     *      options = {} || undefined will return all changed and deleted models
     *
     * @returns {Array of Objects}
     */
    changedModels: function(options) {
        var models = [];

        _.each(this.models, function(model, key) {

            // Selection for only edited or deleted models:
            if (!_.isUndefined(options) && !_.isEmpty(options)) {

                // Selection for only changed models:
                if (!_.isUndefined(options.onlyEdited) && options.onlyEdited === true) {
                    if (model.hasChanged() && _.isUndefined(model.get('isDeletedByCollection'))) {
                        models.push(model);
                    }
                }

                // Selection for only deleted models:
                if (!_.isUndefined(options.onlyDeleted) && options.onlyDeleted === true) {
                    if (!_.isUndefined(model.get('isDeletedByCollection')) &&
                        model.get('isDeletedByCollection') === true) {
                        models.push(model);
                    }
                }
            } else {
                if (model.hasChanged()) {
                    models.push(model);
                }
            }
        });

        return models;
    }

});

;swc.BaseCompositeModel = Backbone.Model.extend({

    models: {},

    /**
     * Mapper converts field name into value (get mode)
     * or into the list of models and their fields to set (set mode) 
     * map: {
     *      'fieldName': 'modelName.fieldName',
     *      'complexField': function (data, options) {
     *              if (data) { //setter
     *                  return {
     *                      model: { field: value, ... }, ...
     *                  }
     *              }
     *              else { //getter
     *                  ...
     *                  return value;
     *              }
     *          }
     *      ...
     * }
     *
     * or:
     *
     * map: function (data, isReverse) { ... } // still TODO
     */
    map: {},

    modelsPool: {},

    /**
     * Define initialize method:
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    initialize: function (attributes, options) {
        var self = this;
        this.modelsPool = {};

        $.each(this.models, function(key, value) {
            var attr = {}; // TODO - compose from attributes and mapper
            self.modelsPool[key] = new /*TODO*/ swc.constructors[key](attr, options);
        });
    },

    get: function (name) {
        if (!this.map[name]) {
            return null;
        }

        if (_.isFunction(this.map[name])) {
            return this.map[name]();
        }
        else {
            var parts = this.map[name].split('.'),
                modelName = parts[0],
                modelField = parts[1];
            return this.modelPool[modelName].get(modelField);
        }
    },

    set: function (name, value, options) {
        var self = this,
            data;
        if (_.isObject(name)) {
            data = name;
        }
        else {
            (data = {})[name] = value;
        }

        // Run validation.
        if (!this._validate(data, options)) {
            return false;
        }

        var newData = {};
        $.each(data, function (key, val) {
            if (_.isFunction(this.map[key])) {
                _.extend(newData, this.map[key](val, options));
            }
            else {
                var parts = this.map[name].split('.'),
                    modelName = parts[0],
                    modelField = parts[1];
                if (!newData[modelName]) {
                    newData[modelName] = {};
                }
                newData[modelName][modelField] = val;
            }
        });
        $.each(newData, function (modelName, vals) {
            self.modelPool[modelName].set(vals, options);
        });
        return this;
    },

    /**
     * 
     * TODO: add mapper
     */
    syncAll: function (method, options) {
        var self = this,
            deferred = new $.Deferred(),
            promises = [];

        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        }

        $.each(this.models, function(key, value) {
            promises.push(self.syncSubModel(method, key, options));
        });

        $.when.apply(null, promises)
            .done(function() {
                return deferred.resolve();
            })
            .fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    },

    syncSubModel: function (method, modelName, options) {
        var deferred, originalPromise;

        originalPromise = this.modelsPool[modelName].sync(method, options);

        if (this.models[modelName].required === true) {
            return originalPromise;
        }

        // If the model is not required then we resolve the deffered object always
        deferred = new $.Deferred();

        originalPromise.always(function () {
            deferred.resolve();
        });

        return deferred.promise();
    },

    sync: function(method, options) {
        var self = this,
            deferred = new $.Deferred();

        if (!method) {
            method = 'read';
        }

        options = _.extend({}, options);

        // Check if current page has any models:
        if (_.keys(this.models).length === 0) {
            return deferred.resolve();
        } else {
            var methodName = 'syncAs' + method.charAt(0).toUpperCase() + method.slice(1);

            if (_.isFunction(this[methodName])) {
                deferred = new $.Deferred();
                $.when(this[methodName](options))
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
            else {
                return this.syncAll('read', options);
            }

            return deferred.promise();
        }
    },

    /**
     * Default save method.
     * Can be overriden for custom behavior.
     *
     */
    syncAsSave: function (options) {
        return this.syncAll(undefined, options);
    },

    /**
     * Validation of model parameters on '{set}' method
     *
     * @param attributes {Object}
     * @param options {Object}
     */
    _validate: function(attributes, options) {
        // TODO
        if (!this.validate()) {
            return false;
        }

        for(var i in this.modelsPool) {
            var attrs = {}; // TODO form attributes and mapper

            if (!this.modelsPool[i]._validate(_.extend({}, attrs), _.extend({}, options))) {
                return false;
            }
        }

        return true;
    },

    validate: function(attributes, options) {
        // overrideable
        return true;
    },

    /**
     * Reset model to it previous values (IF some error happened)
     */
    resetToPreviousState: function() {
        $.each(this.modelsPool, function(key, model) {
            model.resetToPreviousState();
        });
    }
});
;swc.BaseModel = Backbone.Model.extend({

    /**
     * @override on default {'Backbone.model.defaults'} property
     *
     * Default values for a model
     *
     * @param defaults {Object}
     */
    defaults: {},

    /**
     * @override on default {'Backbone.model.url'} property
     *
     * URL for model to be synced / fetched. Can be either string or object formated to default backbone SYNC actions
     *
     * @descirption
     *
     *      url: '/books/' || url: {
     *          'read': '/books/get',
     *          'create': '/books/set',
     *          'update': '/books/edit',
     *          'delete': '/books/delete'
     *      }
     *
     *      Either you can add any method you want to URL object and it will work, if you will call sync() with correct
     *      method. You can extend default behaviour by your custom methods
     *
     *      Example:
     *
     *      ulr: {
     *          'read':     '/get/books',
     *          'replace':  '/set/books/id'
     *      }
     *
     *      Then you call sync('replace'), and it will use correct ulr (/set/books/id)
     *
     * @param url {String || Object}
     */
    url: '',

    /**
     * List of the attributes which will be first time to the model, to check if it will be changed
     *
     * @param originalAttributes {Object}
     *
     * @note Please do not use this Object for your purposes. This is an urgent variable for model.
     */
    originalAttributes: {},

    /**
     * Temporary value for application, to know that this models have to be handled by other way
     *
     * FIXME :: remove this when all models and collection will be moved to the new architecture
     *
     * @description
     *
     *      This will be removed when all models will be moved to new architecture
     *
     * @param isNewArchitecture {Boolean}
     */
    isNewArchitecture: true,

    /**
     * The flag if model will be synced even if it has been changed
     * @param isForceSync {Boolean}
     */
    isForceSync: false,

    /**
     * Parameters for sending '{READ}' request to the server
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param ajaxParameters {Object}
     */
    ajaxParameters: {
        'parameters': {}
    },

    /**
     * Parameter for sending '{ANY}' type of request to the server, default ajax options for the model:
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param ajaxSettings {Object}
     */
    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: 'application/x-sah-ws-4-call+json'
    },

    /**
     * @override on default {'Backbone.model.initialize()'} method
     *
     * @description
     *
     *      Was overrided because need to set {'this.originalAttributes'}. Why this is needed you can see in following
     *      methods:
     *
     * @memberOf hasChanged()
     * @memberOf changedAttributes()
     */
    initialize: function(attributes, options) {

        attributes = !_.isEmpty(attributes) ? attributes : this.defaults;

        if (_.isEmpty(this.originalAttributes)) {
            this.originalAttributes = attributes;
        }

        this.set(attributes, options);
    },

    /**
     * @override on default {'Backbone.model.sync()'} method
     *
     * Default {'Backbone.sync()'} doesn't support Application requirements.
     *
     * @description
     *
     *      This method was overrided becuase of specific Server (NP) API. It was impossible to use native {'.sync()'}
     *      method with current server API.
     *
     * @param method {String}
     * @param options {Object}
     */
    sync: function(method, options) {
        var self = this,
            url = this.url,
            deferred = new $.Deferred();

        // Define action which has to be processed:
        if (_.isObject(this.url) && !_.isEmpty(this.url[method])) {
            url = this.url[method];
        }

        // This check helps to avoid unnecessary AJAX calls when model is changed:
        if (!this.canChangeModel(method, options)) {
            return deferred.resolve(); // No need to sync model if it was changed by user
        }

        // Send request to the server and fill the model with data
        $.when(self.sendRequest(method, url, options))
            .done(function(response) {

                // This check is added to avoid problems when the model has been changed
                // between AJAX start and AJAX resolve.
                if (self.canChangeModel(method, options)) {
                    self.set(self.parse(response)); // No need to set if the model is changed
                }

                deferred.resolve(response);
            })
            .fail(function(xhr, ajaxOptions, thrownError) {

                if (self.canChangeModel(method, options)) {
                    self.set(self.parse(self.defaults));
                }

                deferred.reject(xhr, ajaxOptions, thrownError);
            });

        return deferred.promise();
    },

    canChangeModel: function(method, options) {
        if (method === "read" && !this.isForceSync) {
            if (!_.isUndefined(options) && options.isListener === true && this.hasChanged()) {
                return false;
            }
        }

        return true;
    },

    /**
     * Send ajax request to the server when model sync is processed:
     *
     * FIXME :: move to separate object which will handle AJAX requests of model:
     *
     * @param method {String}
     * @param url {String}
     * @param options {Object}
     *
     * @returns {*}
     */
    sendRequest: function(method, url, options) {
        var self = this,
            deferred = new $.Deferred(),
            data = method === "read" ? self.ajaxParameters : self.toJSON(options),
            requestType = this.ajaxSettings.requestType,
            headers = {
                'X-Context': $.cookie(getDeviceID() + '/context'),
                'Authorization': 'X-Sah ' + $.cookie(getDeviceID() + '/context')
            };

        // Check if something is missing from mandatory arguments:
        if (_.isEmpty(url) || _.isEmpty(method)) {
            return deferred.resolve();
        }

        // Check if current request is making in background:
        if (!_.isUndefined(options) && options.isListener === true) {
            headers.idle = true;
            headers['X-Sah-Request-Type'] = 'idle';
        }

        // Check if it's needed different request types for get / set requests
        if (_.isObject(this.ajaxSettings.requestType) && !_.isEmpty(this.ajaxSettings.requestType[method])) {
            requestType = this.ajaxSettings.requestType[method];
        }

        // Send request to the server:
        $.ajax({
            url: url,
            type: requestType,
            dataType: self.ajaxSettings.requestDataType,
            contentType: self.ajaxSettings.contentType,
            headers: headers,
            cache: false,
            
            data: $.isPlainObject(data) ? JSON.stringify(data) : data,

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                deferred.resolve(response);
            },

            error: function(xhr, ajaxOptions, thrownError) {
                swc.models.Login.checkAccessToDevice(xhr);
                deferred.reject(xhr, ajaxOptions, thrownError);
            },

            statusCode: {
                403: function() {
                    // TODO :: crete handling of this errors:
                },

                404: function() {
                    if (_.isFunction(this.on404)) {
                        this.on404();
                    }
                },

                500: function() {
                    // TODO :: crete handling of this errors:
                },

                502: function() {
                    if (_.isFunction(this.on502)) {
                        this.on502();
                    }
                }
            }
        });

        return deferred.promise();
    },

    /**
     * @override on default {'Backbone.model.parse()'} method
     *
     * This method is called whenever a model's data is returned by the server, in fetch, and save. The function is
     * passed the raw response object, and should return the attributes hash to be set on the model
     *
     * @param response {Object}
     * @param options {Object}
     *
     * @returns {Object}
     */
    parse: function(response, options) {
        var json = response;

        // Convert json to suitable format if method for this exists
        if (_.isFunction(this.apiToJSON)) {
            json = this.apiToJSON(json);
        }

        // Save original json in order to check for model changes
        this.originalAttributes = json;

        return json;
    },

    /**
     * @override on default {'Backbone.model.toJSON()'} method
     *
     * Transform JSON form model to valid server JSON, to be saved
     *
     * @param json {Object}
     *
     * @returns {Object}
     */
    toJSON: function() {
        return Backbone.Model.prototype.toJSON.call(this);
    },

    /**
     * @override on default {'Backbone.model.hasChanged()'} method
     *
     * Default method doesn't fit current application requirements
     *
     * @description
     *
     *      var model = new Backbone.model({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.hasChanged() -> true
     *
     *      Current implementation does not allow us to see if model was really changed, so here is the override
     *
     *      var model = new swc.BaseModel({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.hasChanged() -> false
     *
     * @param attributes {String || Array of Strings} (saving native Backbone.hasChanged(attrs) interface)
     *
     * @returns {Boolean}
     */
    hasChanged: function(attributes) {
        var changedAttributes = this.changedAttributes(),
            hasChanged = !_.isEmpty(changedAttributes);

        if (!_.isUndefined(attributes) && !_.isEmpty(attributes)) {
            hasChanged = false;

            attributes = !_.isArray(attributes) ? [ attributes ] : attributes;

            _.each(attributes, function(key) {
                if (!_.isUndefined(changedAttributes[key])) {
                    hasChanged = true;
                }
            });
        }
        
        return hasChanged;
    },

    /**
     * @override on default {'Backbone.model.changedAttributes()'} method
     *
     * Default method doesn't fit current application requirements
     *
     * @description
     *
     *      var model = new Backbone.model({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.changedAttributes('a') -> true
     *
     *      Current implementation does not allow us to see if model was really changed, so here is the override
     *
     *      var model = new swc.BaseModel({ a: 10 });
     *
     *          model.set('a', 15);
     *          model.set('a', 10);
     *
     *          model.changedAttributes('a') || model.changedAttributes(['a'])  -> false
     *
     * @param attributes {String || Array of Strings} (saving native Backbone.changedAttributes(attrs) interface)
     *
     * @returns {Array of Objects}
     */
    changedAttributes: function(attributes) {
        var self = this,
            attrs = {},
            attrsDiff = _.keys(this.attributes);

        if (!_.isUndefined(attributes) && !_.isEmpty(attributes)) {
            attrsDiff = !_.isArray(attributes) ? [ attributes ] : attributes;
        }

        _.each(attrsDiff, function(attribute, key) {
            var mapsEqual = _.isEqual(
                _.pick(self.attributes, attribute),
                _.pick(self.originalAttributes, attribute)
            );

            if (!mapsEqual) {
                attrs[attribute] = self.get(attribute);
            }
        });

        return attrs;
    }
});
;swc.constructors.StickyPageModel = Backbone.Model.extend({

    sync: function() {
        return new $.Deferred().resolve();
    },

    getConnectivityStatus: function() {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DeviceManager/Connectivity:getStatus',
            data: { parameters: {} },
            
            success: function(response) {
                deferred.resolve(response);
            },
            
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

});
;swc.constructors.StickyPageView = swc.base.PageView.extend({

    models: [
        'StickyPageModel'
    ],

    events: {
        'swc-dropdown:change .locale-selector': 'setLocale',
        'click .open-desired-website': 'checkConnection',
        'click .reboot-gateway': 'rebootGateway',
        'click .reboot-process': 'clickProcess'
    },

    /**
     * This mapping only needed to find out which page to show to user.
     * We have several steps.
     */
    templateForErrorMap: {
        'Error_02': 'no-connection',
        'Error_03': 'no-connection',
        'Error_04': 'no-connection-final',
        'Error_07': 'no-connection-final-support',
        'Error_11': 'parental-control'
    },

    defaultError: 'Error_02',

    initialize: function() {
        this.template = $.template('sticky', swc.Templates.get('sticky:application').get('content'));
        this.render();
    },

    checkConnection: function(e){
        var self = this,
            $el = $(e.currentTarget),
            url = $el.attr('href');

        e.preventDefault();
        
        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                } else {
                    self.showRebootPage(url);
                }
            })
            .fail(function(){
                self.showRebootPage(url);
            });
        
        return false;
    },

    showRebootPage: function(url){
        location.href = location.pathname + "?errorcode=Error_04&url=" + encodeURIComponent(url);
    },

    clickProcess: function(e){
        e.preventDefault();
        return false;
    },

    rebootGateway: function(e){
        this.$('.reboot-process').show();
        this.$('.reboot-gateway').hide();
        
        // Start Device polling
        this.pollGateway();
        
        e.preventDefault();
        
        return false;
    },

    pollGateway: function(){
        var self = this,
            query = this.parseQuery(),
            url = '#';
        
        if (query) {
            url = decodeURIComponent(query.url);
        }
        
        swc.models.StickyPageModel.getConnectivityStatus()
            .done(function(response){
                if (response.status && response.status.data && response.status.data.status === true){
                    location.href = url;
                } else {
                    self.showFinalPage(url);
                }
            })
            .fail(function(){
                setTimeout(function() {
                    self.pollGateway();
                }, 1000);
            });
        
        return false;
    },

    showFinalPage: function(url){
        location.href = location.pathname + "?errorcode=Error_07&url=" + encodeURIComponent(url);
    },

    setNotification: function() {
        var queryParams = this.parseQuery(),
            strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                url: decodeURIComponent(queryParams.url || '/')
            },
            // Compile template for specific error code
            tmpl = $.template('error-dialog', swc.Templates.get('sticky:error:' +
                queryParams.templateId).get('content'));

        this.$('.sticky-message-container').html($.tmpl(tmpl, data));
    },

    /**
     * @override for BaseView::displayPage() because we have different layout for sticky pages then regular application 
     */
    displayPage: function() {
        var strings = swc.models.Locale.getLocaleStrings('sticky'),
            data = {
                localeStrings: strings,
                localeString: getTranslationStringsjQuery,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                formatDate: swc.models.Locale.formatDate
            };

        this.$el = $.tmpl(this.template, data);

        $('div#application').html(this.$el);
    },

    renderComplete: function() {
        this.$('.locale-selector')
            .data('options', swc.models.Locale.getLocaleOptions())
            .trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        this.setNotification();
        this.delegateEvents();
    },

    setLocale: function(e, value){
        var self = this;

        $.when(swc.models.Locale.setLocale(value)).done(function() {
            self.remove();
            self.render();
        });
    },

    /**
     * Parses query string and extract parameter <-> value pairs.
     * Also defines which template will be shown to user based on returned "errorcode" value.
     * 
     * @private This is just a helper method
     * 
     * @returns {{}}
     */
    parseQuery: function() {
        var query = location.search.replace('?', ''),
            res = {};

        $.each(query.split('&'), function(i, pair){
            var temp = pair.split('=');
            res[temp[0]] = temp[1];
        });

        if (!res.errorcode || !this.templateForErrorMap[res.errorcode]) {
            res.errorcode = this.defaultError;
        }
        res.templateId = this.templateForErrorMap[res.errorcode];

        return res;
    }

});
;swc.constructors.DHCPLeases = Backbone.Collection.extend({

    sync: function(fromListener){
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:getStaticLeases',
            fromListener: fromListener,

            data: {
                "parameters":{ }
            },

            success: function(response) {
                self.build(response);
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    build: function(response){
        var self = this;

        this.reset();

        if (!response || !response['status']) {
            return;
        }

        _.each(response['status'], function(data, id){
            var model = new Backbone.Model();
            if (data.MACAddress) {
                data.MACAddress = data.MACAddress.toUpperCase();
            }
            model.set({'id': data.MACAddress});
            model.set(data);
            self.add(model);
        });
    },

    getActiveLeases: function(){
        var data = [],
            res = {};

        data = _.map(this.toJSON(), function(model){
            var mac = model.MACAddress,
                device = swc.models.NetworkDevices.where({mac: mac});

            if (device.length) {
                model['device'] = device[0].toJSON();
            } else {
                model['device'] = {};
            }

            return model;
        });

        _.each(data, function(item){
            res[item.MACAddress] = item;
        });

        return res;
    },

    saveDHCPLeasesEdit: function(data){
        var self = this,
            ipaddr, macaddr, device, edited, deleted = false,
            deferred = new $.Deferred(),
            editedId;

        $.each(data, function(key, value) {
            if (value.parameterName === "DHCPLeaseIPAddress") {
                ipaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseEditedMacAddress") {
                macaddr = value.parameterValue;
            }
            editedId = value.parameterData.editedLease;
        });

        $.when(this.deleteDHCPLease(editedId)).done(function() {
            if (data.deleted) {
                deferred.resolve();
            } else {
                $.when(self.saveDHCPLeaseRequest(ipaddr, macaddr)).done(function() {
                    deferred.resolve();
                });
            }
        });

        return deferred.promise();
    },

    saveDHCPLeases: function(data){
        var self = this,
            pool = [],
            deferred = new $.Deferred();

        $.each(data, function(key, value) {
            pool.push(self.saveDHCPLease(value));
        });

        $.when(pool).done(function () {
            deferred.resolve();
        }).fail(function () {
            deferred.reject();
        });

        return deferred.promise();
    },

    saveDHCPLease: function(data){
        var self = this,
            ipaddr, macaddr, device, edited = false;

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "DHCPLeaseIPAddress") {
                ipaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseMacAddress") {
                macaddr = value.parameterValue;
            }
            if (value.parameterName === "DHCPLeaseEditedMacAddress") {
                edited = true;
            }
        });

        if (edited) {
            return this.saveDHCPLeasesEdit(data);
        }

        return this.saveDHCPLeaseRequest(ipaddr, macaddr);
    },

    saveDHCPLeaseRequest: function(ip, mac){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:addStaticLease',
            data: {
                parameters: {
                    IPAddress: ip,
                    MACAddress: mac
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    deleteDHCPLease: function(mac){
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            url: '/sysbus/DHCPv4/Server/Pool/default:deleteStaticLease',
            data: {
                parameters: {
                    MACAddress: mac
                }
            },

            success: function(response) {
                self.remove(mac);
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    validation: {
        validateNewDevice: function(data){
            var device, isEdited = false, ipAddress,
                validationStatus = {
                    'status': true,
                    'messages': []
                };

            // Get neccessary params from array of page data:
            $.each(data, function(key, value) {
                if (value.parameterName === "DHCPLeaseNewDevice" || value.parameterName === "DHCPLeaseNewDevice") {
                    device = value.parameterValue;
                }

                if (value.parameterName === "DHCPLeaseEditFlag" && value.parameterValue) {
                    isEdited = true;
                }

                if (value.parameterName === "DHCPLeaseIPAddress") {
                    ipAddress = value.parameterValue;
                }
            });

            if (!isEdited && (_.isEmpty(device)) && (ipAddress && ipAddress !== "")){
                validationStatus.status = false;
                validationStatus.messages.push("global");
            }

            return validationStatus;
        },

        validateIP: function(data){
            var netValidation = swc.models.Network.validation,
                validationStatus = {
                    'status': true,
                    'messages': []
                };

            var Address = netValidation.getIPField(data, 'Address'),
                Netmask = netValidation.getIPField(data, 'Netmask'),
                DHCPMin = netValidation.getIPField(data, 'DHCPRange', 'range-from'),
                DHCPMax = netValidation.getIPField(data, 'DHCPRange', 'range-to'),
                LeaseIPAddress = netValidation.getIPField(data, 'DHCPLeaseIPAddress'),
                LeaseIPAddressStr = netValidation.decimalToIpString(LeaseIPAddress),
                DHCPLease = (_.findWhere(data, {parameterName: 'DHCPLeaseMacAddress'}) || _.findWhere(data, {parameterName: 'DHCPLeaseEditedMacAddress'})),
                DHCPLeaseMacAddress = DHCPLease ? DHCPLease.parameterValue : false;

            // NOTE: copy-pasted from network.js file
            var Subnet = (Address & Netmask) >>> 0;
            var Broadcast = (Address | ~Netmask) >>> 0;
            
            if (Address === false || Netmask === false || DHCPMin === false || DHCPMax === false) {
                return validationStatus;
            }

            var editedModelId = _.findWhere(data, { parameterName: "DHCPLeaseEditFlag" });
            
            if (editedModelId && editedModelId.parameterValue) {
                editedModelId = editedModelId.parameterValue;
            } else {
                editedModelId = false;
            }

            // Check if format is valid
            if (LeaseIPAddress === false) {
                validationStatus.status = false;
                validationStatus.messages.push('Invalid IPv4 Address Format Custom');
                return validationStatus;
            }

            // Check if address is within right subnet
            if (!netValidation.isAddressWithinSubnet(LeaseIPAddress, Address, Netmask)) {
                validationStatus.status = false;
                validationStatus.messages.push('IPv4 Address is outside of allowed host addresses range');
                return validationStatus;
            }

            // NOTE: copy-pasted from network.js file [BEGIN]
            if (LeaseIPAddress === Broadcast) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match broadcast");
                return validationStatus;
            }

            if (LeaseIPAddress === Subnet) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match subnet");
                return validationStatus;
            }
            // [END]

            // if (DHCPMin <= LeaseIPAddress && LeaseIPAddress <= DHCPMax) {
            //     validationStatus.status = false;
            //     validationStatus.messages.push('IPv4 Address Within DHCP Range');
            //     return validationStatus;
            // }
            
            // Validate that address is unique
            if (LeaseIPAddress === Address) {
                validationStatus.status = false;
                validationStatus.messages.push('IPv4 Address Already in use');
                return validationStatus;
            }

            swc.models.NetworkDevices.each(function(model){
                var modelAddress = model.get('address'),
                    modelMac = model.get('mac');
                
                if (modelAddress.IPv4 === LeaseIPAddressStr && DHCPLeaseMacAddress && modelMac !== DHCPLeaseMacAddress) {
                    validationStatus.status = false;
                    validationStatus.messages.push('IPv4 Address Already in use');
                }
            });

            swc.models.DHCPLeases.each(function(model){
                if ((model.get("IPAddress") === LeaseIPAddressStr) && (model.get("id") !== editedModelId)) {
                    validationStatus.status = false;
                    validationStatus.messages.push('IPv4 Address Already in use');
                }
            });
            
            return validationStatus;
        }
    }

});
;swc.constructors.DynDNSProviderCollection = swc.BaseCollection.extend({
    
    url: {
        read: '/sysbus/DynDNS:getHosts'
    },
    
    model: 'DynDNSProvider',
    
    defaults: {
        'id': '',
        'service': '',
        'hostname': '',
        'username': '',
        'password': '',
        'last_update': null,
        'status': null,
        'enable': false
    },
    
    // Parses host list
    apiToJSON: function (response) {
        var result = [];
        
        _.each(response.status, function(providerData) {
            // Manually create ID. From NP point of view it is a "hostname"
            providerData['id'] = providerData['hostname'];
            result.push(providerData);
        });
        
        return result;
    }
    
});
;swc.constructors.DynDNSService = Backbone.Model.extend({
    defaults: {
        id: '',
        name: ''
    }
});

swc.constructors.DynDNSServiceCollection = swc.BaseCollection.extend({
    
    url: {
        'read': '/sysbus/DynDNS:getServices'
    },
    
    model: 'DynDNSService',
    
    apiToJSON: function (response) {
        var result = [];
        
        _.each(response.status, function (providerId) {
            result.push({
                id: providerId,
                name: providerId
            });
        });
        
        return result;
    },

    /**
     * Prepare options for the Service provider dropdown list
     * @returns {Array}
     */
    formatProvidersOptions: function() {
        var options = [];

        this.each(function(provider) {
            options.push({
                name:  provider.get('name').capitalize(),
                value: provider.get('name')
            });
        });
        
        return options;
    }
    
});
;swc.constructors.FirewallRules = Backbone.Collection.extend({

    /**
     * List of predefined rules:
     * @param predefined {Array}
     */
    predefined: [
        { "name": "Internet Key Exchange", "port": [ "500" ], "protocol": "17" },
        { "name": "Kerberos", "port": [ "88" ], "protocol": "6,17" },
        { "name": "SUN RPC",  "port": [ "111" ], "protocol": "6" },
        { "name": "Microsoft RPC", "port": [ "135" ], "protocol": "6" },
        { "name": "NETBIOS-SSN", "port": [ "139" ], "protocol": "6" },
        { "name": "Microsoft-DS", "port": [ "445" ], "protocol": "6" },
        { "name": "Remote Login", "port": [ "513" ], "protocol": "6" },
        { "name": "Remote Shell", "port": [ "514" ], "protocol": "6" },
        { "name": "AFP", "port": [ "548" ], "protocol": "6" },
        { "name": "Internet Printing protocol", "port": [ "631" ], "protocol": "6" },
        { "name": "SSDP (Port 9000)", "port": [ "1900" ], "protocol": "17" },
        { "name": "SSDP (Port 2869)", "port": [ "2869" ], "protocol": "6" },
        { "name": "UPnP Discovery", "port": [ "3702" ], "protocol": "17" },
        { "name": "Multicast DNS", "port": [ "5353" ], "protocol": "17" },
        { "name": "LLMNR", "port": [ "5355" ], "protocol": "17" },
        { "name": "SSH", "port": [ "22" ], "protocol": "6" },
        { "name": "Telnet", "port": [ "23" ], "protocol": "6" },
        { "name": "Http", "port": [ "80" ], "protocol": "6" },
        { "name": "Remote Desktop protocol", "port": [ "3389" ], "protocol": "6" },
        { "name": "VNC", "port": [ "5900" ], "protocol": "6" }
    ],

    /**
     * List of validation methods:
     */
    validation: {

        RuleName: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: 'service-mode' },
                    policy: { elementName: 'policy' },
                    name: { elementName: 'RuleName' },
                    id: { elementName: 'RuleKey' }
                }, data),
                predefinedRules = swc.models.FirewallRules.predefined,
                validationStatus = true,
                validationMessages = [],
                searchModel;


            // Skip validation for predefined mode
            if (validationData.mode !== "predefined") {

                if (!$.trim(validationData.name)) {
                    validationMessages.push('must not be empty');
                }

                if (validationData.name.length < 1 || validationData.name.length > 40) {
                    validationMessages.push('must be from 1 to 40 characters');
                }

                // Ascii is defined as the characters in the range of 000-177 (octal),
                // therefore non-printing characters \000-\037
                if (/[\000-\037]/.test(validationData.name)) {
                    validationMessages.push('allowed characters ASCII non-printable');
                }

                // Search for same rules only within one chain target (inbound / outbound)
                if (validationData.policy.split('_')[1] === 'inbound') {
                    searchModel = swc.models.FirewallRules.
                        findWhere({ name: validationData.name, chain: 'Custom_V6In' });
                } else {
                    searchModel = swc.models.FirewallRules.
                        findWhere({ name: validationData.name, chain: 'Custom_V6Out' });
                }

                // Check for custom rules:
                if (!_.isUndefined(searchModel)) {

                    // Skip check if model is editing
                    if (searchModel.get('id') !== validationData.id) {
                        validationMessages.push('already existed rule names are not allowed');
                    }
                }
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        PredefinedRuleName: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: 'service-mode' },
                    name: { elementName: 'PredefinedRuleName' },
                    policy: { elementName: 'policy' }
                }, data),
                predefinedRules = swc.models.FirewallRules.predefined,
                validationStatus = true,
                validationMessages = [],
                searchModel;

            // Skip validation for predefined mode
            if (validationData.mode !== "custom") {

                // Search for same rules only within one chain target (inbound / outbound)
                if (validationData.policy.split('_')[1] === 'inbound') {
                    searchModel = swc.models.FirewallRules.
                        findWhere({name: validationData.name, chain: 'Custom_V6In'});
                } else {
                    searchModel = swc.models.FirewallRules.
                        findWhere({name: validationData.name, chain: 'Custom_V6Out'});
                }

                // Check if rule matched:
                if (!_.isUndefined(searchModel)) {
                    validationMessages.push('already existed rule names are not allowed');
                }
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        RulePort: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: "ports-mode" },
                    from: { elementName: "RulePort", elementClass: "from" },
                    to: { elementName: "RulePort", elementClass: "to" },
                    id: { elementName: 'RuleKey' },
                    policy: { elementName: 'policy' }
                }, data),
                validationMessages = [],
                searchModels = [],
                portsRange = [];

            if (!$.trim(validationData.from)) {
                validationMessages.push('must not be empty');
            }

            if (/\D/.test(validationData.from)) {
                validationMessages.push('allowed characters 0-9');
            }

            // Convert to integer values:
            validationData.from = +validationData.from;
            validationData.to = +validationData.to;

            if (validationData.from < 1 || validationData.from > 65535) {
                validationMessages.push('allowed range 1 to 65535');
            }

            if (validationData.mode === "range") {

                if (!$.trim(validationData.to)) {
                    validationMessages.push('must not be empty');
                }

                if (/\D/.test(validationData.to)) {
                    validationMessages.push('allowed characters 0-9');
                }

                if (validationData.to < 1 || validationData.to > 65535) {
                    validationMessages.push('allowed range 1 to 65535');
                }

                if (validationData.to <= validationData.from) {
                    validationMessages.push('range option first value MUST be less then second value');
                }

                portsRange = [ validationData.from, validationData.to ];
            } else {
                portsRange = [ validationData.from ];
            }

            // Check for TR-069 blocked ports
            if (!swc.models.FirewallRules.validation.helpers.portsNotInRange(portsRange, [ 1024, 1048 ])) {
                validationMessages.push('ports 1024-1048 are not allowed because this ports reserved for system use');
            }

            // Search for same rules only within one chain target (inbound / outbound)
            if (validationData.policy.split('_')[1] === 'inbound') {
                searchModels = swc.models.FirewallRules.where({ chain: 'Custom_V6In' });
            } else {
                searchModels = swc.models.FirewallRules.where({ chain: 'Custom_V6Out' });
            }

            // Check ports crossing conflict for custom rules:
            _.each(searchModels, function(rule, key) {
                var rulePorts = rule.get('port'),
                    rulePortsNotCrossing = swc.models.FirewallRules.validation.helpers.
                        portsNotInRange(portsRange, rulePorts);

                if (!rulePortsNotCrossing && (rule.get('id') !== validationData.id)) {
                    validationMessages.push('already used ports are not allowed');
                }
            });

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        helpers: {
            /**
             * Check for ports not conflicting
             *
             * @param ports [1-2]
             * @param range [1-2]
             *
             * @returns {boolean}
             */
            portsNotInRange: function(ports, range) {
                // Case 1 [] && []
                if (ports.length === 1 && range.length === 1) {
                    if (parseInt(ports[0], 10) !== parseInt(range[0], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 2 [][] && []
                if (ports.length === 2 && range.length === 1) {
                    if (parseInt(range[0], 10) < parseInt(ports[0], 10) ||
                        parseInt(range[0], 10) > parseInt(ports[1], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 3 [] && [][]
                if (ports.length === 1 && range.length === 2) {
                    if (parseInt(ports[0], 10) < parseInt(range[0], 10) ||
                        parseInt(ports[0], 10) > parseInt(range[1], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 4 [][] && [][]
                if (ports.length === 2 && range.length === 2) {
                    if (
                        (parseInt(ports[0], 10) < parseInt(range[0], 10) &&
                            parseInt(ports[1], 10) < parseInt(range[0], 10)) ||
                            (parseInt(range[0], 10) < parseInt(ports[0], 10) &&
                                parseInt(range[1], 10) < parseInt(ports[0], 10))
                        ) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    },

    /**
     * All rules sorted by port value ASC.
     *
     * @param rule1 {Object -> Backbone.Model}
     * @param rule2 {Object -> Backbone.Model}
     *
     * @returns {number}
     */
    comparator: function(rule1, rule2) {
        return parseInt(rule1.get("port"), 10) - parseInt(rule2.get("port"), 10);
    },

    /**
     * Get all rules from the server and compare them to the collection
     * @param fromListener {Boolean}
     * @returns {*}
     */
    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(this.fetchInbound(fromListener), this.fetchOutbound(fromListener))
            .done(function(inbound, outbound) {
                self.parseRules(inbound.status, outbound.status);

                deferred.resolve();
            });

        return deferred.promise();
    },

    /**
     * Request inbound rules:
     * @param fromListener {Boolean}
     * @returns {*}
     */
    fetchInbound: function(fromListener) {
        return this.requestRules({ parameters: { chain: "Custom_V6In" }}, fromListener);
    },

    /**
     * Request outbound rules:
     * @param fromListener {Boolean}
     * @returns {*}
     */
    fetchOutbound: function(fromListener) {
        return this.requestRules({ parameters: { chain: "Custom_V6Out" }}, fromListener);
    },

    /**
     * Send request to the server to get list of rules
     * @param params {Object}
     * @param fromListener {Boolean}
     * @returns {*}
     */
    requestRules: function(params, fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:getCustomRule',
            data: params,
            fromListener: fromListener,

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Create normalized JSON basing on server response
     * @param inbound {Array of Objects}
     * @param outbound {Array of Objects}
     */
    parseRules: function(inbound, outbound) {
        var parsedRules = [];

        // Parse inbound rules:
        _.each(inbound, function(rule, key) {
            parsedRules.push({
                id: key,
                status: rule.Enable,
                name: rule.Description,
                port: rule.DestinationPort.split('-'),
                policy: rule.Target + '_inbound',
                protocol: rule.Protocol,
                chain: 'Custom_V6In'
            });
        });

        // Parse outbound rules:
        _.each(outbound, function(rule, key) {
            parsedRules.push({
                id: key,
                status: rule.Enable,
                name: rule.Description,
                port: rule.DestinationPort.split('-'),
                policy: rule.Target + '_outbound',
                protocol: rule.Protocol,
                chain: 'Custom_V6Out'
            });
        });

        // Update collection data:
        this._reset();
        this.set(parsedRules);
    },

    /**
     * Save changed rules (edit / delete) to the server
     * @param rulesToChangeState {Array of objects}
     * @param rulesToDelete {Array}
     * @returns {*}
     */
    updateRulesList: function(rulesToChangeState, rulesToDelete) {
        var self = this,
            deferred = new $.Deferred(),
            deferredActions = [];

        // Prepare list of actions for changed rules:
        _.each(rulesToChangeState, function(rule, key) {
            var ruleModel = self.findWhere({ id: key }),
                ruleModelNew = {};

            if (!_.isUndefined(ruleModel)) {
                deferredActions.push(
                    self.changeRule(ruleModel.toJSON(), _.extend(ruleModel.toJSON(), { status: rule.value }))
                );
            }

        });

        // Prepare list of actions for deleted rules:
        _.each(rulesToDelete, function(rule, key) {
            var ruleModel = self.findWhere({ id: rule });

            if (!_.isUndefined(ruleModel)) {
                deferredActions.push(self.removeRule(ruleModel.toJSON()));
            }
        });

        $.when.apply(null, deferredActions)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    /**
     * Send request to create rule on the server:
     * @param ruleData {Object}
     * @returns {*}
     */
    createRule: function(ruleData) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:setCustomRule',
            data: {
                parameters: {
                    id: swc.Utils.generateId(),
                    description: ruleData.name,
                    enable: ruleData.status,
                    protocol: ruleData.protocol,
                    ipversion: 6,
                    destinationPort: ruleData.port.join('-'),
                    persistent: true,
                    action: ruleData.policy.split('_')[0],
                    chain: ruleData.chain
                }
            },

            success: function(response) {
                swc.models.Rest.sendRequest({
                    url: '/sysbus/Firewall:commit',
                    data: {
                        parameters: {}
                    },

                    success: function(response) {
                        deferred.resolve();
                    }
                });
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Change rule on the server (1. delete, 2. create new)
     * @param previousRule {Object}
     * @param newRule {Object}
     * @returns {*}
     */
    changeRule: function(previousRule, newRule) {
        var self = this,
            deferred = new $.Deferred();

        $.when(this.removeRule(previousRule)).done(function() {
            $.when(self.createRule(newRule)).done(function() {
                deferred.resolve();
            });
        });

        return deferred.promise();
    },

    /**
     * Delete rule from the server:
     * @param ruleData {Object}
     * @returns {*}
     */
    removeRule: function(ruleData) {
        var deferred = new $.Deferred(),
            self = this;

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:deleteCustomRule',
            data: {
                parameters: {
                    id: ruleData.id,
                    chain: ruleData.chain
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

});
;swc.constructors.Network = Backbone.Collection.extend({

    validation: {

        /** Provides valid interface for view.pageValidation */
        validateIPAddress: function(data) {
            var Address = this.getIPField(data, 'Address'),
                Netmask = this.getIPField(data, 'Netmask'),
                DHCPMin = this.getIPField(data, 'DHCPRange', 'range-from'),
                DHCPMax = this.getIPField(data, 'DHCPRange', 'range-to');
            
            return this.validateIPAddressDecimal(Address, Netmask, DHCPMin, DHCPMax);
        },

        validateNetmask: function(data) {
            var Address = this.getIPField(data, 'Address'),
                Netmask = this.getIPField(data, 'Netmask'),
                DHCPMin = this.getIPField(data, 'DHCPRange', 'range-from'),
                DHCPMax = this.getIPField(data, 'DHCPRange', 'range-to');
            
            return this.validateNetmaskDecimal(Address, Netmask, DHCPMin, DHCPMax);
        },

        validateDHCPSettings: function(data) {
            var Address = this.getIPField(data, 'Address'),
                Netmask = this.getIPField(data, 'Netmask'),
                DHCPMin = this.getIPField(data, 'DHCPRange', 'range-from'),
                DHCPMax = this.getIPField(data, 'DHCPRange', 'range-to');
            
            return this.validateDHCPSettingsDecimal(Address, Netmask, DHCPMin, DHCPMax);
        },

        validateDMZ: function(data) {
            var dmzAddress = _.findWhere(data, {parameterName: 'DMZIPAddress'}),
                validationStatus = {
                    status: true,
                    messages: []
                };

            if (dmzAddress === false) {
                return validationStatus;
            }

            if (($.inArray('disabled', dmzAddress.parameterClasses) ===-1) && !dmzAddress.parameterValue) {
                validationStatus.status = false;
                validationStatus.messages.push("global");
            }
            
            return validationStatus;
        },

        // Validates decimal values of IP Address and other fields
        validateIPAddressDecimal: function(Address, Netmask, DHCPMin, DHCPMax) {
            var validationStatus = {
                status: true,
                messages: []
            };
            
            if (Address === false) {
                validationStatus.status = false;
                validationStatus.messages.push("Invalid IPv4 Address Format");
                return validationStatus;
            }

            if (!(Address > 3232235520 && Address < 3232301055)/* 192.168.0.0 - 192.168.255.255*/ &&
                !(Address > 167772160 && Address < 184549375)/* 10.0.0.0 - 10.255.255.255 */ &&
                !(Address > 2886729728 && Address < 2887778303)/* 172.16.0.0 - 172.32.255.255 */) {
                validationStatus.status = false;
                validationStatus.messages.push("Non-private subnet");
                //'You have choosen an invalid network. Only private Networks according RFC 1918 are allowed'
                return validationStatus;
            }

            //We need Netmask to proceed validation
            if (Netmask === false) {
                return validationStatus;
            }
            
            var netmaskValidation = this.validateNetmaskSubnetDecimal(Address, Netmask);
            if (netmaskValidation.status === false) {
                return netmaskValidation;
            }

            //We need DHCP to validate further
            if (DHCPMin === false || DHCPMax === false) {
                return validationStatus;
            }
            var validDHCPSubnet = this.validateDHCPSubnetDecimal(DHCPMin, DHCPMax, Address, Netmask);
            if (validDHCPSubnet.status === false) {
                return validDHCPSubnet;
            }

            return validationStatus;
        },

        // Validate decimal value of Netmask and other fields if provided
        validateNetmaskDecimal: function(Address, Netmask, DHCPMin, DHCPMax) {
            var validationStatus = {
                status: true,
                messages: []
            };
            
            if (Netmask === false) {
                validationStatus.status = false;
                validationStatus.messages.push("Invalid Netmask format");
                return validationStatus;
            }

            var netmaskString = Netmask.toString(2);
            if (netmaskString.match(/01/) || !netmaskString.match(/[0]{2,}$/ig)) { //Has raising sequence 01 or less than 2 zeroes at end
                validationStatus.status = false;
                validationStatus.messages.push("Invalid Netmask format");
                return validationStatus;
            }

            var netmaskValidation = this.validateNetmaskSubnetDecimal(Address, Netmask);
            if (netmaskValidation.status === false) {
                return netmaskValidation;
            }

            //We need DHCP to validate further
            if (DHCPMin === false || DHCPMax === false) {
                return validationStatus;
            }
            var validDHCPSubnet = this.validateDHCPSubnetDecimal(DHCPMin, DHCPMax, Address, Netmask);
            if (validDHCPSubnet.status === false) {
                return validDHCPSubnet;
            }

            return validationStatus;
        },

        // Validates that DHCP settings fit subnet and are correct
        validateDHCPSettingsDecimal: function(Address, Netmask, DHCPMin, DHCPMax) {
            var validationStatus = {
                status: true,
                messages: []
            };

            if (DHCPMin === false || DHCPMax === false) {
                validationStatus.status = false;
                validationStatus.messages.push('Invalid IPv4 Address Format');
                return validationStatus;
            }

            // We can proceed only if Address and Netmask are specified
            if (Address === false || Netmask === false) {
                return validationStatus;
            }

            var validDHCPSubnet = this.validateDHCPSubnetDecimal(DHCPMin, DHCPMax, Address, Netmask);
            if (validDHCPSubnet.status === false) {
                return validDHCPSubnet;
            }

            // Check if DHCP Settings range is correct
            if (DHCPMax - DHCPMin < 1) {
                validationStatus.status = false;
                validationStatus.messages.push("Incorrect DHCP range");
            }

            return validationStatus;
        },

        // Check if netmask and address combination is ok for private subnet
        // return bool validation status with message
        validateNetmaskSubnetDecimal: function(Address, Netmask) {
            var validationStatus = {
                    status: true,
                    messages: []
                },
                validNets  = ['0xC0A80000', /*r192*/   '0xAC100000', /*r172*/ '0x0A000000' /*r10*/ ],
                validMasks = ['0xFFFF0000', /*mask16*/ '0xFFF00000', /*mask20*/ '0xFF000000' /*mask24*/],
                usedNetGuestWifi = this.ipStringToDecimal('10.128.0.0'),
                usedNetAPNP = this.ipStringToDecimal('10.129.0.0'),
                usedNetNetmask = this.ipStringToDecimal('255.255.0.0');

            var Subnet = (Address & Netmask) >>> 0;
            var Broadcast = (Address | ~Netmask) >>> 0;

            validNets = _.map(validNets, function(val) { return parseInt(val, 16); });
            validMasks = _.map(validMasks, function(val) { return parseInt(val, 16); });

            var netValid = false;
            
            $.each(validNets, function(i, net) {
                if ((Address & validMasks[i]) >>> 0 === validNets[i]) {
                    netValid = true;
                    
                    // The subnet mask can also be more specific than the default one
                    if ((Netmask & validMasks[i]) >>> 0  !== validMasks[i]) {
                        validationStatus.status = false;
                        validationStatus.messages.push("The subnetmask does not fit to the ip range");
                    }
                }
            });

            if (!netValid) {
                validationStatus.status = false;
                validationStatus.messages.push("Non-private subnet");
            }

            if (Address === Broadcast) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match broadcast");
                return validationStatus;
            }

            if (Address === Subnet) {
                validationStatus.status = false;
                validationStatus.messages.push("Not match subnet");
                return validationStatus;
            }

            // Validate that network doesn't match guest wifi or AP-NP network
            var maxNetmask = (Netmask & usedNetNetmask) >>> 0;
            
            if ((Address & maxNetmask) >>> 0 === usedNetGuestWifi) {
                validationStatus.status = false;
                validationStatus.messages.push("Subnet 10.128.0.0/16 is used for guest wlan");
                return validationStatus;
            }

            if ((Address & maxNetmask) >>> 0 === usedNetAPNP) {
                validationStatus.status = false;
                validationStatus.messages.push("Subnet 10.129.0.0/16 is used for internal purposes");
                return validationStatus;
            }

            return validationStatus;
        },


        // We need to check if DHCP subnet is ok, if one of [Address, Netmask, DHCP] have changed
        validateDHCPSubnetDecimal: function(DHCPMin, DHCPMax, Address, Netmask) {
            var validationStatus = {
                status: true,
                messages: []
            };

            var Subnet = (Address & Netmask) >>> 0;
            var Broadcast = (Address | ~Netmask) >>> 0;

            // Check if DHCP Subnet match to IP Subnet
            if ( (DHCPMin & Netmask) >>> 0 !== Subnet || (DHCPMax & Netmask) >>> 0 !== Subnet ) {
                validationStatus.status = false;
                validationStatus.messages.push("DHCP Subnet doesnt match");
                return validationStatus;
            }

            // Validate if IP Address matches part is out of range:
            if (DHCPMax >= Address && Address >= DHCPMin) {
                validationStatus.status = false;
                validationStatus.messages.push("IPv4 Address Within DHCP Range");

                return validationStatus;
            }

            // Check if DHCP Settings range is correct
            if (DHCPMax === Broadcast || DHCPMin === Subnet) {
                validationStatus.status = false;
                validationStatus.messages.push("Incorrect DHCP range");

                return validationStatus;
            }

            return validationStatus;
        },

        // data is [{parameterName: key, parameterValue: value, parameterClasses: []}] array
        // returns false if text inserted into field is not a valid IP address
        // returns decimal value of IP address if everything is ok
        getIPField: function(data, key, className) {
            var val = _.where(data, {parameterName: key});

            if (className) {
                val = _.filter(val, function(element) {
                    return $.inArray(className, element.parameterClasses) !== -1;
                });
            }

            if (val.length > 0) {
                if ($.inArray('disabled', val[0].parameterClasses) !== -1) {
                    return false;
                }

                var ipString = val[0].parameterValue;
                return this.ipStringToDecimal(ipString);
            }
            
            return false;
        },

        /** Replaces subnet address part:
        *
        *   1) It splits previousAddress into Network (192.168.1.) and Host(.25) parts using Netmask.
        *   2) Replaces Network part with one from Address (10.0.0.). Address Host part is gained using Netmask.
        *   3) Result is constructed from Address network part, and previousAddress Host part
        *
        *   This is used to auto-replace some Static IP / DHCP Range to new subnet, as result of Address/Netmask field change.
        *
        *   Example:  self.replaceSubnet(192.168.1.25, 10.0.0.1, 255.255.255.0)
        *   Result: 10.0.0.25
        */
        replaceSubnet: function(previousAddressStr, AddressStr, NetmaskStr) {
            var Address = this.ipStringToDecimal(AddressStr),
                Netmask = this.ipStringToDecimal(NetmaskStr),
                previousAddress = this.ipStringToDecimal(previousAddressStr);

            if (Address && Netmask && previousAddress) {
                previousAddress = ((previousAddress & ~Netmask) + (Address & Netmask)) >>>0;
                return this.decimalToIpString(previousAddress);
            } else {
                return false;
            }
        },

        // Converts 192.168.1.1 to decimal representation
        ipStringToDecimal: function(ipString) {
            if (!_.isString(ipString) || !ipString.match(/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/)) { //Not valid format
                return false;
            }
            
            var ip = ipString.split("."),
                ipNumber = 0,
                invalid = false;
            
            $.each(ip, function(i, v) {
                var octet = parseInt(v, 10);

                if (octet > 255 || octet < 0) { // Check if octet number is not exceeding valid value 
                    invalid = true;
                }
                ipNumber += octet * Math.pow(2, 8*(3-i));
            });

            if (invalid) {
                return false;
            }

            return ipNumber;
        },

        // Converts decimal to string (192.168.1.1) representation
        decimalToIpString: function(ipDecimal) {
            var result = "",
                octet = 0,
                left = 0,
                pow = Math.pow(2,8);

            left = ipDecimal;

            for (var i=0; i<4; i++) {
                octet = left % pow;
                left = Math.floor(left / pow);
                result = "." + octet.toString(10) + result;
            }

            return result.substr(1);
        },

        // Checks if address is withing required subnet
        isAddressWithinSubnet: function(CheckIP, Address, Netmask) {
            if (Address===false || Netmask===false) {
                return false;
            }
            return (Address & Netmask >>> 0) === (CheckIP & Netmask >>> 0);
        },

        /** Calculates allowed host range string for subnet
        *   @param  int   123451231      Ip address in decimal form that is contained in subnet
        *   @param  int   3423525325     Ip netmask in decimal form to identify subnet
        *   @return string               Range string '192.168.1.1 - 192.168.1.126' if Address/Netmask are valid, bool false if not
        */
        getAllowedHostRange: function(Address, Netmask) {
            var MinAddr, MaxAddr;

            if (Address!==false && Netmask!==false) {
                MinAddr = ((Address & Netmask) >>> 0) + 1;
                MaxAddr = ((Address & Netmask >>> 0) - 1 + ~Netmask) >>> 0;

                return this.decimalToIpString(MinAddr) + " - " +this.decimalToIpString(MaxAddr);
            }
            
            return false;
        }
    },

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        this.reset();

        $.when(this.getIPSettings(fromListener), this.getNetworkStatus(fromListener), this.loadDMZSettings(fromListener)).done(function() {
            self.trigger('change');
            deferred.resolve();
        });

        return deferred.promise();
    },

    getIPSettings: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:getLANIP',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel();

                if (response.data) {
                    var data = response.data;

                    // Set model id
                    model.set('id', 'ip-settings');

                    // Set model data
                    model.set('LocalIPAddress', data.Address);
                    model.set('Netmask', data.Netmask);
                    model.set('DHCPStatus', data.DHCPEnable);
                    model.set('DHCPStart', data.DHCPMinAddress);
                    model.set('DHCPFinish', data.DHCPMaxAddress);

                    // Add model to current collection
                    self.add(model);

                    deferred.resolve();
                } else {
                    deferred.resolve();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getNetworkStatus: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:getWANStatus',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel(),
                    moreInfo = [];

                if (response.data) {
                    var data = response.data;

                    // Set model id
                    model.set('id', 'status');

                    // Set model data
                    model.set('ConnectionType', data.LinkType);
                    model.set('ConnectionState', data.ConnectionState);
                    model.set('ConnectionStatus', data.LinkState !== "down" && data.IPAddress.length !== 0);
                    model.set('MacAddress', data.MACAddress);
                    model.set('DeviceName', 'Internet Box');
                    model.set('Protocol', data.Protocol);
                    model.set('LastConnection', 'none');
                    model.set('RemoteIPAddress', data.IPAddress);
                    model.set('DNSServers', data.DNSServers ? data.DNSServers.split(',') : []);
                    model.set('IPv6Address', data.IPv6Address);
                    model.set('StorageIPAddress', 'unknown');

                    // Add model to current collection
                    self.add(model);

                    moreInfo.push(self.getStorageIP(model, fromListener));
                    if (!model.get('ConnectionStatus')) {
                        moreInfo.push(self.getLastConnection(model, fromListener));
                    }
                    $.when.apply(null, moreInfo).then(function () {
                        deferred.resolve();
                    });

                } else {
                    deferred.resolve();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getLastConnection: function (model, fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/data:getMIBs',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                if (response.status) {
                    var data = response.status,
                        last;
                    if (model.get('ConnectionType') === 'ethernet' ) {
                        last = data.eth;
                    }
                    else {
                        last = data.dsl;
                    }
                    last = _.values(last);
                    if (last.length > 0 && last[0].LastChange) {
                        last = (new Date()).getTime() - last[0].LastChange * 1000;
                        model.set('LastConnection', last);

                    }
                }
                deferred.resolve();
            },

            error: function() {
                deferred.resolve();
            }
        });
        return deferred.promise();
    },

    getStorageIP: function (model, fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController/LAN',
            method: "GET",
            fromListener: fromListener,

            success: function(response) {
                if (response.parameters) {
                    var data = response.parameters;
                    _.each(data, function (val) {
                        if (val.name === 'IP') {
                            model.set('StorageIPAddress', val.value);
                        }
                    });
                }
                deferred.resolve();
            },

            error: function() {
                deferred.resolve();
            }
        });
        return deferred.promise();
    },

    saveIPSettings: function(data) {
        var self = this,
            address, netmask, dhcpStatus, dhcpMin, dhcpMax,
            refreshUrl = swc.settings.application.get('url') + '#network/settings/ip-settings',
            addressOld = this.get('ip-settings').get('LocalIPAddress'),
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "Address") {
                address = value.parameterValue;
            }

            if (value.parameterName === "Netmask") {
                netmask = value.parameterValue;
            }

            if (value.parameterName === "DHCPEnable") {
                dhcpStatus = value.parameterValue;
            }

            if (value.parameterName === "DHCPRange") {
                if ($.inArray('range-from', value.parameterClasses) !== -1) {
                    dhcpMin = value.parameterValue;
                } else {
                    dhcpMax = value.parameterValue;
                }
            }
        });

        if (!dhcpMin) { //NP requires DHCPMin and DHCPMax even if DHCPStatus=false
            dhcpMin = self.get('ip-settings').get('DHCPStart');
        }

        if (!dhcpMax) {
            dhcpMax = self.get('ip-settings').get('DHCPFinish');
        }

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:setLANIP',
            timeout: 2000,
            data: {
                parameters: {
                    Address: address,
                    Netmask: netmask,
                    DHCPEnable: dhcpStatus,
                    DHCPMinAddress: dhcpMin,
                    DHCPMaxAddress: dhcpMax
                }
            },

            success: function(response) {
                if (response.errors && response.errors.length > 0) {
                    deferred.reject(response.errors[0].description);
                } else {
                    // in case of success the return "{status: null}"
                    deferred.resolve();
                }
            },

            error: function(xhr, ajaxOptions, thrownError) {
                if (ajaxOptions === "timeout") {
                    if (addressOld !== address) {
                        document.location.href = refreshUrl;
                    } else {
                        deferred.reject();
                    }
                } else {
                    deferred.reject();
                }
            }
        });

        return deferred.promise();
    },

    loadDMZSettings: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:getDMZ',
            fromListener: fromListener,
            data: {
                parameters: {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel(),
                    data = {};

                model.set('id', 'dmz');

                // Check if DMS is empty
                if (!response.status.webui) {
                    model.set('deviceIP', '');
                } else {
                    model.set('deviceIP',
                        response.status.webui.DestinationIPAddress // Bullshit
                    );
                }

                self.add(model);

                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveDMZSettings: function(data) {
        var self = this,
            deferred = new $.Deferred(),
            enabled = false,
            assotiatedDeviceMAC,
            assotiatedDeviceIP = '';

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "DMZEnable") {
                enabled = value.parameterValue;
            }

            if (value.parameterName === "DMZIPAddress") {
                assotiatedDeviceMAC = value.parameterValue;
            }
        });

        // Check for critical situation:
        if (enabled && !assotiatedDeviceMAC) {
            return deferred.resolve();
        }

        // Get device ip address:
        assotiatedDeviceIP = swc.models.NetworkDevices.getDeviceIP(assotiatedDeviceMAC);

        if (!enabled) {
            $.when(this.disableDMZ()).done(function (){
                deferred.resolve();
            });
        } else {
            $.when(this.enableDMZ(assotiatedDeviceIP)).done(function (){
                deferred.resolve();
            });
        }

        return deferred.promise();
    },

    enableDMZ: function(deviceIP) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:setDMZ',
            data: {
                parameters: {
                    destinationIPAddress: deviceIP,
                    enable: true,
                    id: "webui",
                    sourceInterface: "data"
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    disableDMZ: function() {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:deleteDMZ',
            data: {
                parameters: {
                    id: "webui"
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getParameter: function(parameter, storage) {
        var search = this.where({ id: storage });

        if (search.length) {
            return search[0].get(parameter);
        } else {
            return false;
        }
    }

});
;swc.constructors.NetworkDevices = Backbone.Collection.extend({

    /**
     * Sort ASC by IPv4 address.
     * Disconnected devices should be displayed last
     */
    comparator: function(device1, device2) {
        // If no IP address - show device as last
         if (device1.get('address').IPv4 && !device2.get('address').IPv4) {
            return -1;
        }

        // All devices with IP address provided should be sorted ASC
        if (device1.get('address') && device2.get('address')) {
            if (!_.isEmpty(device1.get('address').IPv4) && !_.isEmpty(device2.get('address').IPv4)) {
                var device1_ipComponents = device1.get('address').IPv4.split("."),
                    device2_ipComponents = device2.get('address').IPv4.split(".");
                return _.reduce(device1_ipComponents, function (memo, nextVal) {
                    return memo * 255 + parseInt(nextVal, 10);
                }) < _.reduce(device2_ipComponents, function (memo, nextVal) {
                    return memo * 255 + parseInt(nextVal, 10);
                }) ? -1 : 1;
            } else {
                return 1;
            }
        }

        return 0;
    },

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        if (!swc.models['Wireless']) {
            swc.models['Wireless'] = new swc.constructors['Wireless']();
        }

        swc.models.Rest.sendRequest({
            url: '/sysbus/Hosts:getDevices',
            method: 'POST',
            contentType: 'application/x-sah-event-1-call+json',
            fromListener: fromListener,
            data: {
                "parameters":{}
            },
            success: function(response) {
                $.when(swc.models.Wireless.sync(true)).done(function() {
                    var disabledDevices = [
                        'internetbox-nas'
                    ];

                    // Remove old list of devices and fill collection with relevant devices list:
                    if (response.result && response.result.status) {
                        self.reset();

                        $.each(response.result.status, function(key, device) {
                            if ($.inArray(device.hostName, disabledDevices) === -1) {
                                self.add(self.createDevice(device));
                            }
                        });
                    }

                    // Trigger event to notify - devices update finished
                    self.trigger('devices-loaded', true);

                    deferred.resolve();
                });
            }
        });

        return deferred.promise();
    },

    /**
     * Set type of device from data param and check if this type
     * should be mapped according to map "devicesMapping" in the
     * application.json file
     *
     * This map was added according the following tickets:
     *      - SA-2134
     *      - SA-2514
     *
     * @param data {Object} Response from request "/sysbus/Hosts:getDevices"
     * @returns {String}
     */
    getDeviceType: function(data) {
        var devicesMapping = swc.settings.application.get('devicesMapping'),
            type = '';

        if (!data) {
            return type;
        }

        type = data.deviceType.toLowerCase();

        if (devicesMapping[type]) {
            type = devicesMapping[type];
        }

        return type;
    },

    /**
     * Get icon of device by deviceType param from hashes
     * "supportedWiredDevices" and "supportedWirelessDevices"
     * in the application.json file
     *
     * @param interfaceType {String} wired | wireless
     * @param deviceType {String} Type of device as is from the field "deviceType" in the response
     */
    getDeviceIcon: function(interfaceType, deviceType) {
        var supportedWired = swc.settings.application.get('supportedWiredDevices'),
            supportedWireless = swc.settings.application.get('supportedWirelessDevices'),
            icon = '';

        if (interfaceType === 'wired') {
            if (!supportedWired[deviceType]) {
                icon = supportedWired["unrecognized"].deviceIcon;
            } else {
                icon = supportedWired[deviceType].deviceIcon;
            }
        }

        if (interfaceType === 'wireless') {
            if (!supportedWireless[deviceType]) {
                icon = supportedWireless["unrecognized"].deviceIcon;
            } else {
                icon = supportedWireless[deviceType].deviceIcon;
            }
        }

        return icon;
    },

    /**
     * Get interface of access point based on the
     * field "layer2Interface" in the response
     * of the request "/sysbus/Hosts:getDevices"
     *
     * @param wifiApLayer {String}
     */
    getInterfaceAP: function(wifiApLayer) {
        var map = { 'wl0': '2.4GHz', 'wl1': '5GHz', 'wl0.1': 'Guest-2.4GHz', 'wl1.1': 'Guest-5GHz' };

        return !_.isUndefined(map[wifiApLayer]) ? map[wifiApLayer] : '';
    },

    /**
     * Parse data in the response of the request "/sysbus/Hosts:getDevices"
     * and set appropriate fields to new device model
     *
     * @param data {Object} Response data
     * @return {Backbone.Model} Device model
     */
    createDevice: function(data) {
        var model = new swc.constructors.SimpleModel(),
            status = false,
            statusClass='disconnected',
            addressIPv4 = '', addressIPv6 = [],
            addressObjIPv4 = {}, addressObjIPv6 = [],
            interfaceType = '', interfaceSSID = '',
            wifiOperatingChannelBandwidth = getTranslationStrings('Auto'),
            wifiOperatingStandards = '',
            gatewayPort = '', icon = '',
            type, wifiApLayer, interfaceAP;

        // Check if device is valid
        if (!data) {
            return model;
        }

        type = this.getDeviceType(data);
        wifiApLayer = data.layer2Interface;

        // Define interface type
        if (data.interfaceType === "Ethernet") {
            interfaceType = "wired";
            icon = this.getDeviceIcon('wired', type);
        } else {
            interfaceType = "wireless";
            icon = this.getDeviceIcon('wireless', type);
            interfaceAP = this.getInterfaceAP(wifiApLayer);
            interfaceSSID = swc.models.Wireless.getParameter("name", interfaceAP);
            wifiOperatingChannelBandwidth = swc.models.Wireless.getParameter("OperatingChannelBandwidth", interfaceAP);
            wifiOperatingStandards = swc.models.Wireless.getParameter("OperatingStandards", interfaceAP);
        }
        
        // Define IP Address:
        $.each(data.addresses, function(key, ipAddrItem){
            if ( ipAddrItem.family === 'IPv4') {
                addressIPv4 = ipAddrItem.ipAddress;
                addressObjIPv4 = ipAddrItem;
            } else {
                addressIPv6.push(ipAddrItem.ipAddress);
                addressObjIPv6.push(ipAddrItem);
            }
        });

        // Define device status:
        if ((addressIPv4.length || addressIPv6.length) && data.active) {
            status = true;
        }

        if (status) {
            statusClass = 'connected';
        }

        if (data.interfaceType === "Ethernet" && /eth\d*/.test(wifiApLayer)){
            gatewayPort = parseInt(wifiApLayer.replace('eth',''), 10) + 1;
        }

        // Base data:
        model.set('mac', data.physAddress);
        model.set('name', data.hostName);
        model.set('dnsName', data.dnsName);
        model.set('type', type);
        model.set('icon', icon);
        model.set('status', status);
        model.set('statusClass', statusClass);

        // IP Address:
        model.set('address', {
            'IPv4': addressIPv4,
            'IPv6': addressIPv6
        });
        model.set('addressObjects', {
            'IPv4': addressObjIPv4,
            'IPv6': addressObjIPv6
        });

        // Interface type:
        model.set('interfaceType', interfaceType);
        model.set('interfaceSSID', interfaceSSID);
        model.set('interfaceAP', interfaceAP);
        model.set('gatewayPort', gatewayPort);
        
        // Some information about WiFi connection
        model.set('wifiOperatingChannelBandwidth', wifiOperatingChannelBandwidth);
        model.set('wifiOperatingStandards', wifiOperatingStandards);

        // Last connection and change:
        model.set('lastChange', data.lastChange);
        model.set('lastConnection', data.lastConnection);

        return model;
    },

    getDevice: function(MacAddress) {
        var search = this.where({ mac: MacAddress });

        if (search.length) {
            return search[0].attributes;
        } else {
            return false;
        }
    },

    getDeviceIP: function(MacAddress) {
        var device = this.getDevice(MacAddress),
            ip = '';

        if (!device) {
            return ip;
        }

        if (device.address['IPv4']) {
            ip = device.address['IPv4'];
        } else {
            if (device.address['IPv6'].length) {
                ip = device.address['IPv6'][0];
            }
        }

        return ip;
    },

    getDeviceMac: function(IPAddress) {
        var devicesAll = this.getConnectedDevices(),
            devices = devicesAll['wired'].concat(devicesAll['wireless']),
            mac = '';

        $.each(devices, function(key, device) {
            if (device.address['IPv4'] === IPAddress) {
                mac = device.mac;
            } else {
                if (device.address['IPv6'].length) {
                    $.each(device.address['IPv6'], function(ipKey, ipValue) {
                        if (ipValue === IPAddress) {
                            mac = device.mac;
                        }
                    });
                }
            }
        });

        return mac;
    },

    getDeviceByIP: function(IPAddress) {
        var device;

        _.each(this.models, function(model, key) {
            if (!_.isEmpty(model.get('address')['IPv4']) && model.get('address')['IPv4'] === IPAddress) {
                device = model;
            } else {
                if (!_.isEmpty(model.get('address')['IPv6'])) {
                    _.each(model.get('address')['IPv6'], function(IPv6, key) {
                        if (IPv6 === IPAddress) {
                            device = model;
                        }
                    });
                }
            }
        });

        return device;
    },

    getDevicesList: function() {
        var devices = [],
            connected = [],
            disconnected = [];

        // Sort devices to connected and disconnected
        $.each(this.models, function(key, model) {
            var device = model.attributes;

            if (!device.status) {
                if (disconnected.length < 10) {
                    disconnected.push(device);
                }
            } else {
                connected.push(device);
            }
        });

        return devices.concat(connected).concat(disconnected);
    },

    getConnectedDevices: function() {
        var devices = {
            'wired': [],
            'wireless': []
        };

        // Sort devices to connected and disconnected
        $.each(this.models, function(key, model) {
            var device = model.attributes;

            if (device.status) {
                devices[device.interfaceType].push(device);
            }
        });

        return devices;
    },

    getDisconnectedDevices: function() {
        var devices = {
            'wired': [],
            'wireless': []
        };

        // Sort devices to connected and disconnected
        $.each(this.models, function(key, model) {
            var device = model.attributes;

            if (device.status) {
                devices[device.interfaceType].push(device);
            }
        });

        return devices;
    },

    countWiredConnectedDevices: function() {
        return this.where({ status: true, interfaceType: 'wired' }).length;
    },

    removeDevice: function(mac) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Hosts:delHost',
            method: 'POST',
            contentType: 'application/x-sah-event-1-call+json',
            data: {
                "parameters":{
                    "physAddress": mac
                }
            },
            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    customizeDevice: function(data) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Hosts:setDevice',
            data: {
                "parameters":{
                    "device": {
                        "physAddress": data.deviceMac,
                        "hostName": data.deviceName,
                        "deviceType": data.deviceType
                    }
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getDeviceDropdownOptions: function(params) {
        var devices = swc.models.NetworkDevices.filter(function(model) {
                    if (!params || !params.filter) {
                        return true;
                    } else if (params.filter === 'status') {
                        return !!model.get('status');
                    } else if (params.filter === 'DHCPLeases') {
                        return !swc.models.DHCPLeases.get(model.get("mac"));
                    }
                }),
            options = _.map(devices, function(model) {
                var ipAddress = model.get('status') ? model.get('address').IPv4 : "";

                if (ipAddress && ipAddress.length > 15) { // Truncate IPv6 last 3 groups
                    ipAddress = ipAddress.match(/.*((?::[a-z0-9]*){3})/)[1];
                }

                var option = {
                    "name": model.get("name"),
                    "value": model.get("mac"),
                    "additionalLabel": ipAddress
                };

                return option;
            });

        return options;
    }
});
;swc.constructors.PortForwarding = swc.BaseCollection.extend({

    model: 'PortForwardingRule',

    url: {
        read: "/sysbus/Firewall:getPortForwarding"
    },

    comparator: function(item) {
        return parseInt(item.get('ports').entry, 10);
    },

    // TODO :: when normal validation mechanism will be done -> refactor this
    validation: {

        deviceIP: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    deviceIP: { elementName: 'deviceIP' }
                }, data),
                validationMessages = [];

            if (validationData.deviceIP === "0.0.0.0") {
                validationMessages.push('device must be selected');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        serviceName: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: 'service-mode' },
                    name: { elementName: 'serviceName' },
                    id: { elementName: 'serviceID' }
                }, data),
                validationMessages = [];

            // Skip validation for predefined mode
            if (validationData.mode !== "predefined") {
                var searchModel = swc.models.PortForwarding.findWhere({ name: validationData.name });

                if (!$.trim(validationData.name)) {
                    validationMessages.push('must not be empty');
                }

                if (validationData.name.length < 1 || validationData.name.length > 40) {
                    validationMessages.push('must be from 1 to 40 characters');
                }

                // Ascii is defined as the characters in the range of 000-177 (octal),
                // therefore non-printing characters \000-\037
                if (/[\000-\037]/.test(validationData.name)) {
                    validationMessages.push('allowed characters ASCI non-printable');
                }

                if (!_.isUndefined(searchModel)) {
                    // Skip check if model is editing
                    if (searchModel.get('id') !== validationData.id) {
                        validationMessages.push('already existed rule names are not allowed');
                    }
                }
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        predefinedServiceName: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: 'service-mode' },
                    name: { elementName: 'predefinedServiceName' }
                }, data),
                validationMessages = [];

            // Skip validation for predefined mode
            if (validationData.mode !== "custom") {
                var searchModel = swc.models.PortForwarding.findWhere({ name: validationData.name });

                if (!_.isUndefined(searchModel)) {
                    validationMessages.push('already existed rule names are not allowed');
                }
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        entryPort: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: "entry-ports-mode" },
                    from: { elementName: "entryPort", elementClass: "from" },
                    to: { elementName: "entryPort", elementClass: "to" },
                    id: { elementName: 'serviceID' }
                }, data),
                validationMessages = [],
                portsRange = [];

            // Convert to integer values:
            validationData.from = +validationData.from;
            validationData.to = +validationData.to;
            
            if (validationData.from < 1 || validationData.from > 65535) {
                validationMessages.push('allowed range 1 to 65535');
            }

            if (/\D+/.test(validationData.from)) {
                validationMessages.push('allowed characters 0-9');
            }

            // Skip validation for predefined mode
            if (validationData.mode === "range") {

                if (!$.trim(validationData.to)) {
                    validationMessages.push('must not be empty');
                }

                if (/\D+/.test(validationData.to)) {
                    validationMessages.push('allowed characters 0-9');
                }

                if (validationData.to < 1 || validationData.to > 65535) {
                    validationMessages.push('allowed range 1 to 65535');
                }

                if (validationData.to <= validationData.from) {
                    validationMessages.push('range option first value MUST be less then second value');
                }

                portsRange = [ validationData.from, validationData.to ];
            } else {
                portsRange = [ validationData.from ];
            }

            // Check for TR-069 blocked ports
            if (!swc.models.PortForwarding.validation.helpers.portsNotInRange(portsRange, [1024, 1048])) {
                validationMessages.push('ports 1024-1048 are not allowed because this ports reserved for system use');
            }

            // Check ports crossing conflict:
            _.each(swc.models.PortForwarding.models, function(model, key) {
                if (!swc.models.PortForwarding.validation.helpers.
                    portsNotInRange(portsRange, model.get('ports').entry)) {

                    // Skip check when editing model
                    if (model.get('id') !== validationData.id) {
                        validationMessages.push('already used ports are not allowed');
                    }
                }
            });

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        destinationPort: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    mode: { elementName: "destination-ports-mode" },
                    from: { elementName: "destinationPort", elementClass: "from" },
                    to: { elementName: "destinationPort", elementClass: "to" },
                    deviceIP: { elementName: 'deviceIP' },
                    id: { elementName: 'serviceID' }
                }, data),
                validationMessages = [],
                portsRange = [];

            // Convert to integer values:
            validationData.from = +validationData.from;
            validationData.to = +validationData.to;

            if (/\D+/.test(validationData.from)) {
                validationMessages.push('allowed characters 0-9');
            }

            if (validationData.from < 1 || validationData.from > 65535) {
                validationMessages.push('allowed range 1 to 65535');
            }

            if (validationData.mode === "range") {
                portsRange = [ validationData.from, validationData.to ];
            } else {
                portsRange = [ validationData.from ];
            }

            // Check for TR-069 blocked ports
            if (!swc.models.PortForwarding.validation.helpers.portsNotInRange(portsRange, [1024, 1048])) {
                validationMessages.push('ports 1024-1048 are not allowed because this ports reserved for system use');
            }

            // Check ports crossing conflict for current device:
            _.each(swc.models.PortForwarding.where({ 'deviceIP': validationData.deviceIP}), function(model, key) {
                if (!swc.models.PortForwarding.validation.helpers.
                    portsNotInRange(portsRange, model.get('ports').destination)) {

                    // Skip check when editing model
                    if (model.get('id') !== validationData.id) {
                        validationMessages.push('already used ports for same device are not allowed');
                    }
                }
            });

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        helpers: {

            /**
             * Check if ports are not crossing between each other
             *
             * @description
             *
             *  [1, 5] and [3, 6] are conflicting, because they are in same range
             *
             *  [1, 5] and [6, 7] are not conflicting
             *
             * @param ports {Array} length (1 || 2) Port to validate for
             * @param range {Array} length (1 || 2) Ports to validate against
             *
             * @returns {boolean}
             */
            portsNotInRange: function(ports, range){
                // Case 1 [] && []
                if (ports.length === 1 && range.length === 1) {
                    if (parseInt(ports[0], 10) !== parseInt(range[0], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 2 [][] && []
                if (ports.length === 2 && range.length === 1) {
                    if (parseInt(range[0], 10) < parseInt(ports[0], 10) ||
                        parseInt(range[0], 10) > parseInt(ports[1], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 3 [] && [][]
                if (ports.length === 1 && range.length === 2) {
                    if (parseInt(ports[0], 10) < parseInt(range[0], 10) ||
                        parseInt(ports[0], 10) > parseInt(range[1], 10)) {
                        return true;
                    } else {
                        return false;
                    }
                }

                // Case 4 [][] && [][]
                if (ports.length === 2 && range.length === 2) {
                    if (
                        (parseInt(ports[0], 10) < parseInt(range[0], 10) &&
                            parseInt(ports[1], 10) < parseInt(range[0], 10)) ||
                            (parseInt(range[0], 10) < parseInt(ports[0], 10) &&
                                parseInt(range[1], 10) < parseInt(ports[0], 10))
                        ) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        }
    },

    /**
     * List of predefined service which is used to allow user easily add rules using this templates
     *
     * @param predefinedServices {Map}
     */
    predefinedServices: {
        "FTP":    { port: "21",   protocol: "6"  },
        "SSH":    { port: "22",   protocol: "6"  },
        "Telnet": { port: "23",   protocol: "6"  },
        "SMTP":   { port: "25",   protocol: "6"  },
        "TFTP":   { port: "69",   protocol: "17" },
        "HTTP":   { port: "80",   protocol: "6"  },
        "HTTPS":  { port: "443",  protocol: "6"  },
        "POP3":   { port: "110",  protocol: "6"  },
        "SNMP":   { port: "161",  protocol: "17" },
        "PPTP":   { port: "1723", protocol: "6"  }
    },

    apiToJSON: function(response) {
        var rules = response.status,
            rulesSourcesSkip = [ "cwmp" ], // Disabled rules sources (acs.. etc.)
            rulesParsed = [];
        
        _.each(rules, function(rule, key) {
            if (_.indexOf(rulesSourcesSkip, rule.Origin) === -1) {
                rulesParsed.push({
                    id: rule.Id,
                    isUPnP: key.indexOf('upnp') !== -1,
                    status: rule.Enable,
                    name: rule.Description,
                    deviceIP: rule.DestinationIPAddress,
                    protocol: rule.Protocol,
                    origin: rule.Origin,
                    sourceInterface: rule.SourceInterface,
                    ports: {
                        entry: rule.ExternalPort.split('-'),
                        destination: rule.InternalPort.split('-')
                    }
                });
            }
        });
        
        return rulesParsed;
    }

});
;swc.constructors.CentralStorage = Backbone.Collection.extend({

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Delete deprecated models from collection
        this.reset();

        // Load new models to the collection
        $.when(self.getGlobalStatus(fromListener))
            .done(function() {
                $.when(self.getMediaServerStatus(fromListener), self.getUSBDevices(fromListener))
                    .done(function() {
                        self.trigger('central-storage-update');
                        deferred.resolve();
                    });
            });

        return deferred.promise();
    },

    getGlobalStatus: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController/PowerManagement:getMode',
            fromListener: fromListener,
            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel();

                // Create new model:
                model.set('id', 'status');

                // Check if data exists:
                if (!response.data) {
                    model.set('status', false);
                } else {
                    model.set('status', response.data.mode === "ON");
                }

                // Add new model to the collection:
                self.add(model);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setGlobalStatus: function(state) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController/PowerManagement:setMode',
            data: {
                "parameters": {
                    "mode": state ? "ON" : "OFF"
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getMediaServerStatus: function(fromListener) {
        var model = this.where({ id: 'status' })[0],
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            fromListener: fromListener,

            data: {
                "service": "com.swisscom.stargate/ws/dlna.com.swisscom.stargate.dlna",
                "method": "getMediaStreamingState",
                "parameters":{}
            },

            success: function(response) {
                var data;

                // Check if AP has successfully started
                if (response.status.indexOf('status') === -1) {
                    data = false;
                } else {
                    data = JSON.parse(response.status).data;
                }

                // Update status model with media streaming server value:
                model.set('mediaServerStatus', data["mediaStreamingEnabled"]);

                deferred.resolve();
            },

            error: function(response) {
                // Update status model with media streaming server value:
                model.set('mediaServerStatus', false);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Get device icon by its type
     *
     * @param deviceType {String} usb-disk | sd-card
     * @param supported {Boolean} If this device is supported by InternetBox
     * @return {String}
     */
    getIcon: function(deviceType, supported) {
        var icon;

        // if the storage device is not SD-card(mouse, keyboard etc)
        // then it's considered as usb-disk
        if (deviceType === 'sd-card') {
            icon = 'sd-card';
        } else {
            icon = 'usb-disk';
        }

        if (supported !== true) {
            icon += '-undefined';
        }

        return icon;
    },

    /**
     * Set cloud backup state
     *
     * @param responseSyncState
     * @returns {String}
     */
    getSyncState: function(responseSyncState) {
        var map = {
            'IN_PROGRESS': 'progress',
            'UPLOAD_IN_PROGRESS': 'progress',
            'DELETE_IN_PROGRESS': 'progress',
            'COMPLETE': 'complete',
            'ERROR': 'error'
        };

        if (_.isUndefined(map[responseSyncState])) {
            return 'not_sync';
        }

        return map[responseSyncState];
    },

    /**
     * Comparator for collection with USB devices
     * Sorts devices by 'label'
     *
     * @param {Backbone Model}
     * @returns {string}
     */
    comparatorUSBDevices: function(device) {
        return device.get('label').toUpperCase();
    },

    /**
     * Get list of USB devices
     *
     * @param fromListener {Boolean}
     * @returns {Promise}
     */
    getUSBDevices: function(fromListener) {
        var self = this,
            deferred = new $.Deferred(),
            usbModel = new swc.constructors.SimpleModel(),
            usbDevices = new Backbone.Collection();

        // set method of sorting for device list
        usbDevices.comparator = this.comparatorUSBDevices;

        // Set model id:
        usbModel.set('id', 'usb-devices');
        usbModel.set('device-loaded', 'in-progress');

        swc.models.Rest.sendRequest({
            url: '/ws',
            fromListener: fromListener,

            data: {
                "service": "com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
                "method": "list",
                "parameters": {}
            },

            success: function(response) {
                var devicesData;

                // Check if AP has successfully started
                if (response.status.indexOf('status') === -1) {
                    devicesData = { data: [] };
                } else {
                    devicesData = JSON.parse(response.status);
                }

                if (devicesData.data.length) {
                    $.each(devicesData.data, function(key, device) {
                        var model = new swc.constructors.SimpleModel();

                        model.set({
                            id: device.id,
                            capacity: swc.Utils.getBytesWithUnit(device.capacity * 1024),
                            freeSpace: swc.Utils.getBytesWithUnit(device.freeSpace * 1024),
                            fsType: device.fsType,
                            isSync: device.isSync || false,
                            label: device.label,
                            syncErrorCode: device.syncErrorCode,
                            syncState: self.getSyncState(device.syncState),
                            type: self.getIcon(device.type, device.supported)
                        });

                        // Add current device to usb devices collection:
                        usbDevices.add(model);
                    });
                }

                // Add new devices collection to data storage:
                usbModel.set("devices", usbDevices.toJSON());
                usbModel.set('device-loaded', 'completed');

                // Add new usb model to the collection:
                self.add(usbModel);

                deferred.resolve();
            },

            error: function(xhr, status, error) {

                // Add new devices collection to data storage:
                usbModel.set("devices", []);
                usbModel.set('device-loaded', 'none');

                // Add new devices collection to data storage:
                self.add(usbModel);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    // FIXME: Create corresponding method in Storage model and call it here
    removeUSBDevice: function(id) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service": "com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
                "method": "unmount",
                "parameters": {
                    "id": id
                }
            },

            success: function(response) {
                deferred.resolve();
            },
            
            error: function (xhr, status, error) {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Get necessary parameter from one of the storage models:
     * @param parameter {String}
     * @param component {String}
     */
    getParameter: function(parameter, component) {
        var search = this.where({ id: component });

        if (search.length) {
            return search[0].get(parameter);
        } else {
            return '';
        }
    },

    /**
    * Returns true if the Central Storage is ON, false otherwise
    */
    isEnabled: function () {
        var centralStorageInfo = this.get('status');

        return centralStorageInfo ? centralStorageInfo.get('status') : false;
    },

    /**
     * Returns the list of all supported usb devices and sd-cards
     * in dropdown-ready format.
     */
    getDeviceDropdownOptions: function () {
        var usbDevices = this.get('usb-devices'),
            devices = _.isEmpty(usbDevices) ? [] : usbDevices.get('devices'),
            supportedUsbDevices = _.keys(swc.settings.application.get('supportedUsbDevices')),
            options = [];

        // Get all usb disks to the options list
        _.each(devices, function(device, key) {

            // Don't show "undefined-storage" - unsupported device type
            if ($.inArray(device.type.toLowerCase(), supportedUsbDevices) !== -1) {
                options.push({
                    name: device.label,
                    value: device.id
                });
            }
        });

        if (_.isEmpty(options)) {
            options = [
                {
                    name: getTranslationStrings("No Connected Devices"),
                    value: "no-devices-connected",
                    isDefault: true
                }
            ];
        } else {
            options = _.sortBy(options, function (option) {
                return option.name.toLowerCase();
            });

            options.unshift({
                name: getTranslationStrings("Choose a device"),
                value: "choose-device",
                isDefault: true
            });
        }

        return options;
    },

    /**
     * Helper that returns oldValue if there is  an options element with value===oldValue
     * and returns the id of the first element otherwise.
     * Is used to process getDeviceDropdownOptions method results.
     *
     * @param options {Object}
     * @param dropdownDataValue {String} - value saved in dropdown `data` attribute
     */
    getDefaultDeviceOption: function (options, dropdownDataValue) {
        var defaultOptions = [ "no-devices-connected", "choose-device" ],
            defaultDevice = defaultOptions[0];

        // Set device to previously selected, or show "choose a device" option
        if (options.length >= 2) {
            if (!_.isEmpty(dropdownDataValue) && _.indexOf(dropdownDataValue, defaultOptions) === -1) {
                _.each(options, function (obj, key) {
                    if (obj.value === dropdownDataValue) {
                        defaultDevice = obj.value;
                    }
                });
            } else {
                defaultDevice = defaultOptions[1];
            }
        }

        return defaultDevice;
    }
});
;swc.constructors.Schedulers = Backbone.Collection.extend({

    emptySchedulers: [],

    defaultScheduler: {
        schedule:  {
            "monday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "tuesday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "wednesday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "thursday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "friday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "saturday":[
                {
                    "begin":108,
                    "end":414
                }
            ],
            "sunday":[
                {
                    "begin":108,
                    "end":414
                }
            ]
        }
    },

    comparator: function(model) {
        var priority = 3;

        if (model.get('status')) {
            priority -= 1;
        }

        if (model.get('active')) {
            priority -= 2;
        }

        return priority;
    },

    sync: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        $.when(self.getAPSchedule(fromListener), self.getWiFiSchedule(fromListener))
            .done(function() {
                deferred.resolve();
            });

        return deferred.promise();
    },

    /**
     * invert weekly scheduler - in our web UI we need 'enabled' ranges, but REST needs 'disabled' ranges
     * @param schedule
     */
    invertSchedule: function (schedule) {
        var sortedSchedule = _.sortBy(schedule, function(obj) {
            return obj.begin;
        });

        var startPoint = 0, hops = 0, invertedSchedule = [];
        _.each(sortedSchedule, function(obj) {
            var begin = 0, end = 0;
            begin = startPoint;
            end = obj.begin;

            startPoint = obj.end;
            hops++;
            if ((end-begin)>60) {
                invertedSchedule.push({begin: begin, end: end});
            }
            if (hops === sortedSchedule.length) {
                begin = startPoint;
                end = 604800;
                if ((end-begin)>60) {
                    invertedSchedule.push({begin: begin, end: end});
                }
            }
        });

        if (schedule.length === 0) {
            invertedSchedule = [{'begin': 0, 'end': 604800 }];
        }

        return invertedSchedule;
    },

    /**
     * separate scheduler range to 7 parts by days
     * @param schedule
     */
    separateSchedule: function (schedule, scaleWidth) {

        var sortedSchedule = _.sortBy(schedule, function(obj) {
            return obj.begin;
        });

        var convertVar = 86400/scaleWidth;

        var hops = 0, separatedSchedule = {
            "monday":[],
            "tuesday":[],
            "wednesday":[],
            "thursday":[],
            "friday":[],
            "saturday":[],
            "sunday":[]
        };

        var getDayFromHop = function(hop) {
            var day = 'monday';

            switch (hop) {
            case 0:
                day = "monday";
                break;
            case 1:
                day = "tuesday";
                break;
            case 2:
                day = "wednesday";
                break;
            case 3:
                day = "thursday";
                break;
            case 4:
                day = "friday";
                break;
            case 5:
                day = "saturday";
                break;
            case 6:
                day = "sunday";
                break;
            }

            return day;
        };

        $.each(separatedSchedule,function(currentDay, dayArray) {
            _.each(sortedSchedule, function(obj) {
                var begin, end;
                var secondsInDayBegin = getDaySeconds(obj.begin),
                    secondsInDayEnd = getDaySeconds(obj.end);

                if (getDayFromHop(secondsInDayBegin.hops) === currentDay) {
                    begin = secondsInDayBegin.seconds;
                    if (getDayFromHop(secondsInDayEnd.hops) !== currentDay) {
                        end = 86400;
                    }
                }
                if (getDayFromHop(secondsInDayEnd.hops) === currentDay) {
                    end = secondsInDayEnd.seconds;
                    if (getDayFromHop(secondsInDayBegin.hops) !== currentDay) {
                        begin = 0;
                    }
                }
                if (secondsInDayBegin.hops < hops && secondsInDayEnd.hops > hops) {
                    begin = 0;
                    end = 86400;
                }
                begin = Math.round(begin/convertVar);
                end = Math.round(end/convertVar);

                if (end && end > begin && Math.abs(begin-end) >= (scaleWidth/48)) {
                    dayArray.push({begin: begin, end: end});
                }


            });
            hops++;
        });

        return separatedSchedule;
    },

    /**
     * Split schedule from object into array for sending to server
     * @param schedule
     */
    splitSchedule: function (schedule, scaleWidth) {
        var splittedSchedule = [],
            hops = 0,
            convertVar = 86400/scaleWidth;

        $.each(schedule, function(day, array) {
            _.each(array, function(obj) {
                var range = {},
                    begin = obj.begin * convertVar,
                    end = obj.end * convertVar;

                range.begin = hops * 86400 + begin;
                range.end = hops * 86400 + end;

                if (range.end) {
                    splittedSchedule.push(range);
                }
            });
            hops++;
        });

        splittedSchedule.sort(function(obj1, obj2) {
            return obj1.begin - obj2.begin;
        });

        _.each(splittedSchedule, function(obj, index) {
            if (splittedSchedule[index + 1]) {
                if (obj.end === splittedSchedule[index+1].begin) {
                    var range = {
                        begin: obj.begin,
                        end: splittedSchedule[index+1].end
                    };
                    splittedSchedule[index]=range;
                    splittedSchedule.splice(index+1,1);
                }
            }
        });

        splittedSchedule = this.invertSchedule(splittedSchedule);

        _.each(splittedSchedule, function(obj, index) {
            obj.state = "Disable";
        });

        return splittedSchedule;
    },

    /**
     * Set parameters of chosen range to default settings
     * @param id
     */
    makeDefault: function(id) {
        var model = this.get(id);

        if (model) {
            model.set({
                'pixelSchedule': JSON.parse(JSON.stringify(this.defaultScheduler.schedule)),
                'enable': true
            }, {silent:true} );
            model.set({'schedule': this.splitSchedule(model.get('pixelSchedule'), 432)}, {silent:true});
        }
    },
    /**
     * Add scheduler model
     * @param data - Object, should contain schedule(array), enable(boolean)
     * @param type - string, type of scheduler. Can be 'wifi' or 'ap'
     */
    addScheduleModel: function(data, type) {
        var self = this,
            model = this.get(type);

        if (!model) {
            model = new Backbone.Model();
            self.add(model);

            model.on('change:schedule', function() {
                var invertedRanges = self.invertSchedule(model.get('schedule'));
                model.set({'pixelSchedule': self.separateSchedule(invertedRanges, 432)}, {silent:true});
            });

            model.on('change:pixelSchedule', function() {
                model.set({'schedule': self.splitSchedule(model.get('pixelSchedule'), 432)}, {silent:true} );
                if (model.id === 'ap' || model.id === 'wifi') {
                    if (!self.invertSchedule(model.get('schedule'))[0]) {
                        self.emptySchedulers.push(model.id);
                    } else {
                        self.emptySchedulers = _.without(self.emptySchedulers, model.id);
                    }
                }
            });
        }

        model.set('override', "");
        model.set('enable', data.enable);
        model.set('active', data.active);
        model.set('id', type);

        //We send data.schedule = false when scheduler is fresh, so we will use default scheduler
        if (data.schedule === false) {
            model.set('pixelSchedule', JSON.parse(JSON.stringify(this.defaultScheduler.schedule)));
        } else {
            /**
             * array with scheduler data got from server
             * it has the format of seconds from 0 (0.00 of monday)
             * to 604800 (23.59 of sunday)
             */
            model.set('schedule', data.schedule);
        }

    },

    getDevicesSchedulers: function() {
        var self = this,
            deferred = new $.Deferred();

        var fillArray = function() {
            var array = [];

            swc.models.NetworkDevices.each(function(model) {
                if (model.get('mac')) {
                    var id = model.get('mac');
                    array.push(self.getDeviceScheduler(id, model.get('status')));
                }
            });

            $.when.apply(this, array).done(function() {
                deferred.resolve();
            });
        };

        var checkDevices = function() {
            if (!swc.models.NetworkDevices || !swc.models.NetworkDevices.find(function(model) {
                return model.get('mac');
            })) {
                setTimeout(function() { checkDevices(); }, 200);
            } else {
                fillArray();
            }
        };

        checkDevices();

        return deferred.promise();
    },

    getDeviceScheduler: function(id, isActive) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Scheduler:getSchedule',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                "parameters": {
                    "type": "ToD",
                    "ID": id
                }
            },

            success: function(resp) {

                var dataForModel,
                    data,
                    response = resp.result;

                if (response.status) {
                    data = response.data.scheduleInfo;
                    dataForModel = {
                        override: "",
                        schedule: data.schedule || [],
                        enable: data.enable,
                        active: isActive,
                        "ID": id
                    };
                } else {
                    /**
                     * response.status=false responses when device is new and fresh.
                     * so for the first time we send empty data to turn scheduler on
                     */
                    dataForModel = {
                        override: "",
                        enable: false,
                        schedule: false,
                        active: isActive,
                        "ID": id
                    };
                }

                if (self.get(id)) {
                    self.remove(self.get(id));
                }

                self.addScheduleModel(dataForModel, id);
                deferred.resolve();
            },

            error:function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setDevicesSchedulers: function() {
        var self = this,
            deferred = new $.Deferred(),
            array = [];

        this.each(function(model) {
            if (model.id !== 'ap' && model.id !== 'wifi') {
                array.push(self.addSchedule(model.id));
            }
        });

        $.when.apply(this, array)
            .done(function(){
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    getWiFiSchedule: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Scheduler:getCompleteSchedules',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            fromListener: fromListener,

            data: {
                "parameters": {
                    "type": "WLAN"
                }
            },

            success: function(response) {
                var schedulerStatus = response.status,
                    schedulerObj = {},
                    dataForModel = {};

                if (schedulerStatus && response.data.scheduleInfo[0]) {
                    // In old APs we dont have universal "WiFiSchedule" and will use wl0
                    schedulerObj = _.where(response.data.scheduleInfo, {"ID":"wl0"})[0];

                    dataForModel = {
                        override: "",
                        enable: schedulerObj.enable,
                        schedule: schedulerObj.schedule
                    };

                } else {
                    /**
                     * response.status=false responses when device is new and fresh.
                     * so for the first time we send empty data to turn scheduler on
                     */
                    dataForModel = {
                        override: "Enabled",
                        enable: false,
                        schedule: false
                    };
                }

                self.addScheduleModel(dataForModel, "wifi");
                deferred.resolve();
            },

            error:function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getAPSchedule: function(fromListener) {
        var self = this,
            deferred = new $.Deferred(),
            request = {
                "parameters":{
                    type: "AP"
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Scheduler:getCompleteSchedules',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            fromListener: fromListener,

            data: request,

            success: function(resp) {
                var response = resp.result,
                    dataForModel,
                    data;

                if (response.status && response.data.scheduleInfo[0]) {
                    data = _.where(response.data.scheduleInfo, {"ID":"APSchedule"})[0];
                    dataForModel = {
                        override: "",
                        schedule: data.schedule || [],
                        enable: data.enable
                    };
                } else {
                    /**
                     * response.status=false responses when device is new and fresh.
                     * so for the first time we save empty data to turn scheduler on
                     */
                    dataForModel = {
                        override: "Enabled",
                        enable: false,
                        schedule: false
                    };
                }

                self.addScheduleModel(dataForModel, 'ap');
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    addSchedule: function(type) {
        var self = this,
            deferred = new $.Deferred(),
            model = self.get(type),
            schedule = model.get('schedule'),
            requestDataType,
            requestDataId;

        if (type === "wifi") {
            requestDataType = "WLAN";
            requestDataId = "wl0";
        } else if (type === "ap") {
            requestDataType = "AP";
            requestDataId = "APSchedule";

        } else {
            requestDataType = "ToD";
            requestDataId = type;
        }

        // Send default scheduler if our scheduler is empty
        if ((type === "wifi" || type === "ap") && (schedule[0] && schedule[0].begin === 0 && schedule[0].end === 604800)) {
            self.emptySchedulers = _.without(self.emptySchedulers, type);
            self.makeDefault(type);
            model.set('enable', false);
            schedule = model.get('schedule');
        }

        swc.models.Rest.sendRequest({
            url: '/sysbus/Scheduler:addSchedule',

            data: {
                "parameters": {
                    "type": requestDataType,
                    "info": {
                        "ID": requestDataId,
                        "enable": model.get('enable'),
                        "base": "Weekly",
                        "def": "Enable",
                        "override": "",
                        "schedule": schedule
                    }
                }
            },

            success: function(response) {
                // TODO: put this error handler in the common place
                // in this case response can be successful and
                // contain error message. That is why it should be
                //  checked on it here
                if (_.isUndefined(response.errors)) {
                    deferred.resolve(response);
                } else {
                    deferred.reject(response);
                }
            },

            error: function(xhr) {
                deferred.reject(xhr);
            }
        });

        return deferred.promise();
    }

});
;// cloud services list
swc.constructors.CloudAccountCollection = swc.BaseCollection.extend({

    model: 'CloudAccount',

    url: {
        read: "/ws"
    },

    ajaxSettings: {
        requestDataType: 'json',
        contentType: 'application/x-sah-ws-4-call+json',
        requestType: {
            read: 'post'
        }
    },

    ajaxParameters:  JSON.stringify({
        method: 'getCloudSyncInfo',
        service: 'com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup',
        parameters: {}
    }),

    validation: {

        usbUID: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    usbUID: { elementName: 'usbUID' }
                }, data),
                validationMessages = [];

            if (validationData.usbUID === "no-devices-connected") {
                validationMessages.push('no connected devices');
            }
            
            if (validationData.usbUID === "choose-device") {
                validationMessages.push('no device selected');
            }
            
            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        folderName: function(data) {
            var validationData = swc.Utils.getDataToValidate({
                    usbUID: { elementName: 'usbUID' },
                    folderName: { elementName: 'folderName' }
                }, data),
                validationMessages = [],
                deferred;
            
            // Don't show error about folder name if device was not selected yet
            if (validationData.usbUID === "choose-device") {
                return {
                    status: true,
                    messages: validationMessages
                };
            }

            validationData.folderName = $.trim(validationData.folderName);

            if (!validationData.folderName.length) {
                validationMessages.push('can not be empty');

                return {
                    status: false,
                    messages: validationMessages
                };
            }

            deferred = new $.Deferred();

            $.when(swc.models.CloudServices.validateFolder(validationData.usbUID, validationData.folderName))
                .done(function (status) {
                    deferred.resolve();
                })
                .fail(function (status) {
                    if (!_.isUndefined(status)) {
                        switch (status.failure) {
                            case "SYNC_FOLDER_ALREADY_EXISTS":
                                validationMessages.push('already exists');
                                break;

                            case "SYNC_FOLDER_INVALID":
                            case "BAD_REQUEST":
                            case "INTERNAL_ERROR":
                                validationMessages.push('unable to create folder');
                                break;

                            default:
                                validationMessages.push('unable to create folder');
                                break;
                        }
                    } else {
                        validationMessages.push('unable to create folder');
                    }

                    deferred.reject({
                            status: false,
                            messages: validationMessages
                        });
                });

            return deferred.promise();
        }
    },

    /**
     * Get login url to cloud service from <default> cloud service
     * @param cloudServiceID {String}
     * @returns {*}
     */
    getLoginURL: function(cloudServiceID) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',

            data: {
                service: "com.swisscom.stargate/ws/cloud/auth.com.swisscom.stargate.cloud.authorization",
                method: "getServiceAuthUrl",
                parameters: {
                    data: JSON.stringify({
                            serviceId: cloudServiceID,
                            domain: location.host
                        })
                }
            },

            success: function(response) {
                var parsedResponse = JSON.parse(response.status),
                    url;
                if (parsedResponse.data && parsedResponse.data.authUrl) {
                    url = parsedResponse.data.authUrl;
                    deferred.resolve(url);
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Create folder on NAS devices, while connecting to cloud account
     * @param partitionUID {String} - Usb device id
     * @param folderName {String} - user defined folder
     */
    createFolder: function(partitionUID, folderName) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',

            // There is some specific in AP backend for this call
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "syncFSResources",
                parameters: {
                    resources: [
                        JSON.stringify({
                            deviceId: partitionUID,
                            content: [
                                JSON.stringify({
                                    path: folderName,
                                    action: 'CREATE'
                                })
                            ]
                        })
                    ]
                }
            },

            success: function(response) {
                var responseParsed = JSON.parse(response.status),
                    status = responseParsed.status,
                    error = responseParsed.error || "";

                switch (status) {
                    case 409:
                        error = "already exists";
                        break;

                    case 422:
                        error = "invalid name";
                        break;
                }

                if (_.isEmpty(error)) {
                    deferred.resolve();
                } else {
                    deferred.reject({ message: error });
                }
            }
        });

        return deferred.promise();

    },
    
    /**
     * Movee folder on NAS devices, while connecting to cloud account
     * @param partitionUID {String} - Usb device id
     * @param folderName {String} - user defined folder
     */
    moveFolder: function(model, partitionUID, folderName) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',

            // There is some specific in AP backend for this call
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "moveSyncFolder",
                parameters: {
                    data: JSON.stringify({
                        oldFolder: {
                            partitionUUID: model.get('deviceId'),
                            folderName: model.get('folderName')
                        },
                        newFolder: {
                            partitionUUID: partitionUID,
                            folderName: folderName
                        }
                    })
                }
            },

            success: function(response) {
                var responseParsed = JSON.parse(response.status),
                    status = responseParsed.status,
                    error = responseParsed.error || "";

                switch (status) {
                    case 409:
                        error = "already exists";
                        break;

                    case 422:
                        error = "invalid name";
                        break;
                }

                if (_.isEmpty(error)) {
                    deferred.resolve();
                } else {
                    deferred.reject({ message: error });
                }
            }
        });

        return deferred.promise();

    },
    
    // toJSON: function () {
    //     return {
    //         method: 'getCloudSyncInfo',
    //         service: 'com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup'
    //     };
    // },

    apiToJSON: function(response) {
        var respStatus = {},
            respData = {},
            accounts = [],
            result = [];

        try {
            // try JSON.parse
            respStatus = JSON.parse(response.status);
            if (respStatus && respStatus.data) {
                accounts = respStatus.data.syncServices; // TODO: old API is used temporarily
            }
        } catch (e) {
        }

        _.each(accounts, function(cloudAccount, key) {
            var deviceId = '',
                deviceLabel = '[Unknown Device]';

            if (cloudAccount.authStatusCode !== 503) {
                if (cloudAccount.partitionUUID) {
                    deviceLabel = cloudAccount.partitionLabel;
                    deviceId = cloudAccount.partitionUUID;
                }

                result.push({
                    id: cloudAccount.id,
                    cloudServiceName: getTranslationStrings(cloudAccount.id === 'dropbox' ? 'Dropbox' : 'Google drive'),
                    deviceLabel: deviceLabel,
                    deviceId: deviceId,
                    accountName: cloudAccount.accountName,
                    status: cloudAccount.syncState ? cloudAccount.syncState : 'DISABLED',
                    error: cloudAccount.error || '',
                    inaccessibleFiles: cloudAccount.inaccessibleFiles,
                    // they return space in megabytes, but we operate with Kilobytes, thus have to multiply by 1024
                    totalSpace: cloudAccount.totalSpace * 1024,
                    usedSpace: cloudAccount.usedSpace * 1024,
                    lastSyncDate: cloudAccount.lastSyncDate,
                    folderName: cloudAccount.localFolderPath
                });
            }
        });

        return result;
    },

    /**
     * Handle oauth callback.
     * This method called when AP requested OAuthCallback handler after first phase of cloud login procedure
     * 
     * @param oauthCallbackParams {Object|Map} list of parameters send to WebUI by AP during first step of sign-in phase
     */
    handleOauthCallback: function (oauthCallbackParams) {
        var deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            
            timeout: 60000,

            data: {
                service: "com.swisscom.stargate/ws/cloud/auth.com.swisscom.stargate.cloud.authorization",
                method: "handleAuthCallback",
                parameters: { authParams: oauthCallbackParams }
            },

            success: function (response) {
                var parsedResponse = JSON.parse(response.status);
                if (parsedResponse.status !== 200) {
                    deferred.reject();
                } else {
                    deferred.resolve(parsedResponse);
                }
            },
            
            error: function(xhr, status, error) {
                deferred.reject();
            }
        });
        
        return deferred.promise();
    }
});
;swc.constructors.RemoteNASAccounts = swc.BaseCollection.extend({

    model: 'RemoteNASAccount',

    url: {
        read: '/ws'
    },

    ajaxParameters: JSON.stringify({
        service: 'com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas',
        method: 'GetPairing',
        parameters: {}
    }),

    /**
     * @example Success Response:
     *
     * { "status": "SUCCESS", "accounts": [{ "name": "n1", "email": "e1" }, { "name": "n2", "email": "e2" }] }
     *
     * @example Fail Response:
     *
     * {"status":"ERROR"}
     */
    apiToJSON: function(response) {
        var accountsParsed = [],
            responseParsed = {};

        this.error = false;

        try {
            responseParsed = JSON.parse(response.status);

            if (!_.isEmpty(responseParsed) && responseParsed.status === "SUCCESS") {
                var rnasAccounts = responseParsed.accounts;

                _.each(rnasAccounts, function(account) {
                    accountsParsed.push({
                        id: account.email,
                        name: account.name,
                        email: account.email
                    });
                });
            }

            if (responseParsed.status !== "SUCCESS") {
                this.error = true;
            }
        } catch (e) {}

        return accountsParsed;
    },

    isError: function () {
        return this.error === true;
    }

});
;swc.constructors.StorageDevices = Backbone.Collection.extend({

    initialize: function() {
        this.temporaryDevices = [];
        this.isRefreshable = true;
    },

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Reset collection before sync process:
        this.reset();

        $.when(self.getDevices(fromListener))
            .done(function (response) {
                deferred.resolve();
            })
            .fail(function () {
                deferred.reject();
            });

        return deferred.promise();
    },

    /**
     * Comparator for collection with USB devices
     * Sorts devices by 'label'
     *
     * @param {Backbone Model}
     * @returns {string}
     */
    comparator: function(device) {
        return device.get('label').toUpperCase();
    },

    /**
     * Get connected storage devices and internal storage data
     *
     * Devices response:
     * [
     *    {
     *       id : "4C532000021016111590", // Static ID of storage device: uniquely identifies the device.
     *       type: "USB"                  // Either "SD" or "USB"
     *       label: "Transcend 32Gb",     // User-friendly name of the device
     *       fsType: "NTFS",              // Detected file system type e.g. NTFS, FAT32, etc.
     *       capacity: 4194304,           // Capacity in KiB
     *       freeSpace: 2046122,          // Free space in KiB
     *       isSync : true,               // Is synchronized - either true or false.
     *       syncState : "COMPLETE",      // One of: "COMPLETE", "ERROR", "IN_PROGRESS", null
     *       syncError : 7                // Error ID, that can be translated to the meaningful message (either number, or null).
     *    },
     *    ...
     * ]
     *
     * @localParam storage - List of devices with the following attributes
     *
     *  {
     *      device-loaded : 'completed'
     *      devices : Array of devices params
     *  }
     *
     * @localParam fileManager - List of files for each device
     * @returns {deferred.then()}
     */
    getDevices: function(fromListener) {
        var self = this,
            deferred = new $.Deferred(),
            storage = new swc.constructors.CentralStorage(),
            fileManager = null; // this list is populated after device is loaded

        $.when(storage.getUSBDevices(fromListener))
            .done(function() {
                var deviceList = storage.models[0].get('devices'),
                    devicesCount = deviceList.length, // Number of devices
                    devicesFilled = 0;                // number of devices with successful files request

                // If no devices in storage collection, it's not possible to retrieve files for them
                if (deviceList.length === 0) {
                    return deferred.resolve();
                }

                _.each(deviceList, function(deviceParams) {
                    var device = new Backbone.Model();
                    var deviceSyncState;

                    // Set device params
                    device.set(deviceParams);

                    // request for files for every separate device.
                    fileManager = new swc.constructors.FileManager([], { deviceID: device.get('id') });

                    $.when(fileManager.sync('read', {isListener: fromListener}))
                        .done(function() {
                            // Add files params
                            device.set('files', fileManager);

                            // Check if all files on the device are synced:
                            // If device have not any content, we take it's sync status from syncState
                            // progress - sync is turned off
                            // complete - sync is turned on
                            if (fileManager.length === 0) {
                                device.set('isSync', device.get('syncState') === 'complete');
                            } else {
                                device.set('isSync', !fileManager.findWhere({ isSync: false }));
                            }

                            self.temporaryDevices.push(device);

                            devicesFilled++;

                            if (devicesFilled === devicesCount) {
                                if (self.isRefreshable) {
                                    self.reset(self.temporaryDevices);
                                }

                                self.temporaryDevices = [];
                                deferred.resolve();
                            }
                        });
                });
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    /**
     * Sends changed sync statuses of files and devices to server
     *
     * @returns deferred
     */
    setSyncStatus: function() {
        var sendArray = [],
            deferred = new $.Deferred();

        /**
         * make the right json structure for sending - all arrays should contain stringified objects
         */
        this.each(function(model){
            var deviceObj = {},
                supportedUsbDevices = _.keys(swc.settings.application.get('supportedUsbDevices'));

            deviceObj.deviceId = model.get('id');
            deviceObj.sync = model.get('isSync');

            // Fill the files
            deviceObj.content = [];
            model.get('files').each(function(model){
                var fileObj = {};
                fileObj.path = '/'+model.get('name');
                fileObj.sync = model.get('isSync');
                fileObj.virtual = model.get('virtual');
                deviceObj.content.push(JSON.stringify(fileObj));
            });

            if ($.inArray(model.get('type').toLowerCase(), supportedUsbDevices) !== -1) {
                sendArray.push(JSON.stringify(deviceObj));
            }
        });

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service":"com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                "method":"syncFSResources",
                "parameters":{
                    "resources": sendArray
                }
            },
            
            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    unmountDevice: function(deviceId) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service":"com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
                "method":"unmount",
                "parameters":{
                    "id": deviceId
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    renameDevice: function(deviceId) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service":"com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
                "method":"rename",
                "parameters":{
                    "id": deviceId,
                    "label": this.get(deviceId).get('label')
                }
            },

            success: function(response) {
                deferred.resolve();
            },
            
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    renameDevices: function() {
        var deferred = new $.Deferred(),
            self = this,
            requestsArray= [];
        
        self.each(function(model){
            requestsArray.push(self.renameDevice(model.id));
        });
        
        $.when.apply(this, requestsArray).done(function(){
            deferred.resolve();
        });

        return deferred.promise();
    }

});
;swc.constructors.DeviceMeasurements = Backbone.Collection.extend({

    getRequest: function(params, fromListener) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/data:getMIBs',
            data: {
                "parameters": params
            },
            fromListener: fromListener,

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    sync: function(fromListener) {
        var deferred = new $.Deferred(),
            self = this;

        $.when(this.getRequest({mibs: "dsl"}, fromListener), this.getRequest({mibs: "sfp"}, fromListener))
            .done(function(dsl, sfp){
                self.build(dsl, sfp);
                deferred.resolve();
            });

        return deferred.promise();
    },

    build: function(dsl, sfp) {
        var dslObj,
            sfpObj,
            self = this;

        if (dsl && dsl['status'] && dsl['status']['dsl']){
            _.each(dsl['status']['dsl'], function(obj, key){
                if (_.isEmpty(obj)) {
                    return;
                }
                dslObj = obj;
                dslObj.__key__ = key;
                dslObj.id = "dsl";
                self.add(dslObj);
            });
        }

        if (sfp && sfp['status'] && sfp['status']['sfp']){
            _.each(sfp['status']['sfp'], function(obj, key){
                if (_.isEmpty(obj)) {
                    return;
                }

                sfpObj = obj;
                sfpObj.__key__ = key;
                sfpObj.id = "sfp";
                self.add(sfpObj);
            });
        }
    },

    getParams: function() {
        var dsl = this.get("dsl"),
            sfp = this.get("sfp");

        if (dsl){
            return {dsl: dsl.toJSON()};
        } else if (sfp){
            return {sfp: sfp.toJSON()};
        }

        return {};
    }
});
;swc.constructors.Phonebook = swc.BaseCollection.extend({

    model: 'PhonebookContact',

    url: {
        read: "/sysbus/Phonebook:getAllContacts"
    },

    /**
     * Name of request parameter ID which is stored in the localStorage
     */
    requestParamNameID: 'telephony:phonebook:edit-contactID',

    validation: {
        checkAllowableName: function(data, validateKey) {
            var validationMessages = [],
                map = {},
                validationData;

            map[validateKey] = { elementName: validateKey };
            validationData = swc.Utils.getDataToValidate(map, data);

            // Ascii is defined as the characters in the range of 000-177 (octal), therefore non-printing characters \000-\037
            if (/[\000-\037]+/.test(validationData[validateKey])) {
                validationMessages.push('allowed characters ASCI non-printable');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        checkEmpty: function(data, validateKey) {
            var validationMessages = [],
                map = {},
                validationData;

            map[validateKey] = { elementName: validateKey };
            validationData = swc.Utils.getDataToValidate(map, data);

            if (_.isEmpty(validationData[validateKey])) {
                validationMessages.push('must not be empty');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        checkAllowableNumber: function(data, validateKey) {
            var validationMessages = [],
                map = {},
                validationData;

            map[validateKey] = { elementName: validateKey };
            validationData = swc.Utils.getDataToValidate(map, data);

            if (!/^[\d\b#*]*$/.test(validationData[validateKey])) {
                validationMessages.push('phone number contain not allowed characters');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        firstName:  function(data) { return this.checkAllowableName(data, 'firstName'); },
        lastName:   function(data) { return this.checkAllowableName(data, 'lastName'); },
        homeNumber: function(data) { return this.checkAllowableNumber(data, 'homeNumber'); },
        cellNumber: function(data) { return this.checkAllowableNumber(data, 'cellNumber'); },
        workNumber: function(data) { return this.checkAllowableNumber(data, 'workNumber'); }
    },

    comparator: function(model) {
        return $.trim(model.get('formattedName')).toLowerCase();
    },

    /**
     * Get phonebook
     * @returns json
     * {
     *  "status":[
     *      {
     *          "key":"5",
     *          "lastRevision":"1970-01-01T01:54:48Z",
     *          "uniqueID":"urn:uuid:153a6f06-bd93-4b2b-97e9-9b2da9d27745",
     *          "name":"N:Gogo;Pogo;",
     *          "formattedName":"Gogo Pogo",
     *          "birthDay":"0001-01-01T00:00:00Z",
     *          "title":"",
     *          "organisation":"",
     *          "url":"",
     *          "ringtone":"",
     *          "tags":"",
     *          "addresses":[],
     *          "labels":[],
     *          "telephoneNumbers":[
     *              {
     *                  "key":"1",
     *                  "name":"67890",
     *                  "type":"WORK",
     *                  "preferred":false
     *              },{
     *                  "key":"2",
     *                  "name":"12345",
     *                  "type":"CELL",
     *                  "preferred":false
     *              },{
     *                  "key":"3",
     *                  "name":"12345",
     *                  "type":"HOME",
     *                  "preferred":false
     *              }
     *          ],
     *          "emails":[],
     *          "photos":[]
     *      }
     *  ]
     *}
     */
    apiToJSON: function(response) {
        var telephoneNumbers = [],
            names,
            parsed = [];

        _.each(response.status, function(contact) {
            // sort telephone numbers
            telephoneNumbers = [
                _.where(contact.telephoneNumbers, {'type': 'HOME'})[0],
                _.where(contact.telephoneNumbers, {'type': 'CELL'})[0],
                _.where(contact.telephoneNumbers, {'type': 'WORK'})[0]
            ];
            names = contact.name.substr(2).split(';');

            telephoneNumbers = _.compact(telephoneNumbers);

            parsed.push({
                'formattedName': contact.formattedName,
                'name': contact.name,
                'firstName': names[1] || '',
                'lastName': names[0] || '',
                'telephoneNumbers': telephoneNumbers,
                'id': contact.uniqueID,
                'modified': false,
                'deleted': false
            });
        });

        return parsed;
    },

    deleteAllContacts: function() {
        var deletedContacts = this.where({deleted: true}),
            self = this,
            deferred = new $.Deferred(),
            modificationArray = [];

        /**
         * TODO: create deletion in general way via changedModels({ onlyDeleted: true  })
         * and model.sync('delete') methods (see save() method in the
         * swc.constructors.StorageSettingsDatasharingView as example)
         */
        _.each(deletedContacts, function(model){
            modificationArray.push(model.destroy());
        });

        $.when.apply(this, modificationArray)
            .done(function() {
                deferred.resolve();
            }).
            fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});;swc.constructors.Wireless = Backbone.Collection.extend({

    validation: {

        ssid: function(data) {
            var ssid,
                validationStatus = true,
                validationMessages = [];

            // Get neccessary params from array of page data:
            $.each(data, function(key, value) {
                if (value.parameterName === "ssid") {
                    ssid = value.parameterValue;
                }
            });

            if (!ssid.length) {
                validationStatus = false;
                validationMessages.push('name must not be empty');
            }

            if (ssid.length < 3 || ssid.length > 32) {
                validationStatus = false;
                validationMessages.push('name must be from 3 to 32 symbols');
            }

            if (!/^(?=.*\S)[-\w\s]+$/.test(ssid)) {
                validationStatus = false;
                validationMessages.push('name must not contain spaces');
            }

            return {
                status: validationStatus,
                messages: validationMessages
            };
        },

        password: function(data) {
            var password = '',
                encryption = '',
                userIsSuperAdmin = swc.models.Login.checkUserSuperAdmin(),
                validationStatus = true,
                validationMessages = [];

            $.each(data, function(key, value) {
                if (value.parameterName === "password") {
                    password = value.parameterValue;
                }

                if (value.parameterName === "encryption") {
                    encryption = value.parameterValue;
                }
            });

            // Skip check for superadmin and if encryption is none
            if (encryption === "None" || userIsSuperAdmin) {
                return {
                    status: validationStatus,
                    messages: validationMessages
                };
            }

            if ( !/^([A-Za-z0-9]|\-|\s|\_)*$/.test(password) ) {
                validationStatus = false;
                validationMessages.push('password contain not allowed characters');
            }

            if ( !/^(\w|\W){8,64}$/.test(password) ) {
                validationStatus = false;
                validationMessages.push('Password WPA length error');
            }

            return {
                status: validationStatus,
                messages: validationMessages
            };
        }

    },

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Delete deprecated models from collection
        this.reset();

        // Load new models to the collection
        $.when(
                self.getSystemTime(fromListener),
                self.getGlobalStatus(fromListener),
                self.getGuestStatus(fromListener),
                self.getGuestActivationTimer(fromListener),
                self.loadSettings(fromListener),
                self.loadSettingsGuest(fromListener)
            ).done(function() {
                self.trigger('change');
                deferred.resolve();
            });

        return deferred.promise();
    },

    getSystemTime: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel(),
                    time,
                    mode;

                model.set('accessPoint', 'systemTime');
                model.set('time', response.data.time.split('GMT')[0]); // DATE is coming from server with TimeZone.

                self.add(model);

                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getGlobalStatus: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Wifi:get',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel(),
                    status,
                    mode;

                model.set('accessPoint', 'status');

                // Define responce existence
                if (!response.data) {
                    return deferred.resolve();
                }

                // Define configurationg mode existence
                mode = response.data.ConfigurationMode;

                // Global status - wifi is on:
                if (response.data.Enable && response.data.Status) {
                    status = "on";
                }

                // Global status - wifi is off:
                if (!response.data.Enable && !response.data.Status) {
                    status = "off";
                }

                // Global status - wifi is off by scheduler:
                if (response.data.Enable && !response.data.Status) {
                    status = "off-sheduler";
                }

                // Global status - wifi is on till reboot of device:
                if (!response.data.Enable && response.data.Status) {
                    status = "on";
                }

                model.set('status', status);
                model.set('configurationMode', mode);

                self.add(model);

                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getGuestStatus: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Guest:get',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel(),
                    status = false;

                if (response.data) {
                    status = response.data.Enable;
                }

                model.set('accessPoint', 'guestStatus');
                model.set('status', status);

                self.add(model);

                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getGuestActivationTimer: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/WlanTimer:getActivationTimer',
            fromListener: fromListener,

            data: {
                "parameters": {
                    "InterfaceName": "guest"
                }
            },

            success: function(response) {
                var model = new swc.constructors.SimpleModel();

                model.set('accessPoint', 'guestTimer');
                model.set('timeout', response.status);

                // Add model to the collection
                self.add(model);

                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    loadSettings: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/lan:getMIBs',
            fromListener: fromListener,

            data: {
                "parameters": {
                    "mibs": "wlanradio || wlanvap || penable",
                    "flag": "",
                    "traverse": "down"
                }
            },

            success: function(response) {
                if (response.status) {
                    if (response.status.wlanradio && response.status.wlanvap && response.status.penable) {

                        // Create models from response
                        self.createModels(response);

                        deferred.resolve();
                    } else {
                        deferred.reject();
                    }
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    loadSettingsGuest: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/guest:getMIBs',
            fromListener: fromListener,

            data: {
                "parameters": {
                    "mibs": "wlanradio || wlanvap || penable",
                    "flag": "",
                    "traverse": "down"
                }
            },

            success: function(response) {
                if (response.status) {
                    if (response.status.wlanradio && response.status.wlanvap && response.status.penable) {

                        // Create models from response
                        self.createModels(response, true);

                        deferred.resolve();
                    } else {
                        deferred.reject();
                    }
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setGlobalStatus: function(status) {
        var deferred = new $.Deferred(),
            configurationMode = swc.models.Wireless.getParameter("configurationMode", "status");

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Wifi:set',
            data: {
                "parameters": {
                    "Enable": status,
                    "ConfigurationMode": configurationMode,
                    "Status": status
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setGuestStatus: function(status) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Guest:set',
            data: {
                "parameters": {
                    "Enable": status
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setGlobalConfigurationMode: function(configurationMode) {
        var deferred = new $.Deferred(),
            status = swc.models.Wireless.getParameter("status", "status");

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Wifi:set',
            data: {
                "parameters": {
                    "Enable": status === 'on',
                    "ConfigurationMode": configurationMode,
                    "Status": status === 'on'
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setGuestActivationTimer: function(timeout) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/WlanTimer:setActivationTimer',
            data: {
                "parameters": {
                    "Timeout": timeout,
                    "InterfaceName": "guest"
                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setVAPStatus: function(accessPoint, data) {
        var deferred = new $.Deferred(),
            status = '',
            wlDriver = this.getParameter("driver", accessPoint),
            saveData = {
                "parameters": {
                    "mibs": {
                        "wlanradio":{}
                    }
                }
            };

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "status") {
                status = value.parameterValue;
            }
        });

        // SSID Availability selection
        saveData.parameters.mibs.wlanradio[wlDriver] = {
            "PersistentEnable": status
        };

        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/lan:setWLANConfig',
            data: saveData,

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    startWPSPairing: function(timeout) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Wifi:startPairing',
            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },
    
    stopWPSPairing: function(timeout) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/Wifi:stopPairing',
            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveSettings: function(accessPoint, data) {
        var ssid = '', password = '', encryption = '',
            visibility = '', channel = '',
            operating = this.getParameter('operating', accessPoint),
            wlID = this.getParameter("accessPointID", accessPoint),
            wlDriver = this.getParameter("driver", accessPoint),
            saveData = {
                "parameters": {
                    "mibs": {
                        "wlanvap": {},
                        "wlanradio": {},
                        "penable": {}
                    }
                }
            },
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "ssid") {
                ssid = value.parameterValue;
            }

            if (value.parameterName === "password") {
                password = value.parameterValue;
            }

            if (value.parameterName === "encryption") {
                encryption = value.parameterValue;
            }

            if (value.parameterName === "channel") {
                channel = value.parameterValue;
            }

            if (value.parameterName === "visibility") {
                visibility = value.parameterValue;
            }
        });

        // Main data selection
        saveData.parameters.mibs.wlanvap[wlID] = {
            "SSID": ssid,
            "SSIDAdvertisementEnabled": visibility === "visible" ? true : false,
            "Security": {
                "KeyPassPhrase": password,
                "WEPKey": this.getParameter("wepkey", accessPoint),
                "ModeEnabled": encryption
            }
        };

        // Hack for SAH not saving password if security set to No Password
        if (encryption === "None") {
            saveData.parameters.mibs.wlanvap[wlID].Security.WEPKey = this.getParameter('wepkey', accessPoint);
            saveData.parameters.mibs.wlanvap[wlID].Security.KeyPassPhrase = this.getParameter('password', accessPoint);
        }

        // Channel and Operating mode selections options
        if (channel === "auto") {
            saveData.parameters.mibs.wlanradio[wlDriver] = {
                "AutoChannelEnable": true,
                "OperatingStandards": operating
            };
        } else {
            saveData.parameters.mibs.wlanradio[wlDriver] = {
                "Channel": channel,
                "AutoChannelEnable": false,
                "OperatingStandards": operating
            };
        }

        // Send saving request:
        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/' + wlID + ':setWLANConfig',
            data: saveData,

            success: function(response) {
                if (response.status === null) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveSettingsCombined: function(accessPoint, data) {
        var ssid = '', password = '', encryption = '', visibility = '',
            wlID = this.getParameter("accessPointID", accessPoint),
            saveData = {
                "parameters": {
                    "mibs": {
                        "wlanvap": {}
                    }
                }
            },
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "ssid") {
                ssid = value.parameterValue;
            }

            if (value.parameterName === "password") {
                password = value.parameterValue;
            }

            if (value.parameterName === "encryption") {
                encryption = value.parameterValue;
            }

            if (value.parameterName === "visibility") {
                visibility = value.parameterValue;
            }
        });

        // Main data selection
        saveData.parameters.mibs.wlanvap[wlID] = {
            "SSID": ssid,
            "SSIDAdvertisementEnabled": visibility === "visible" ? true : false,
            "Security": {
                "KeyPassPhrase": password,
                "WEPKey": this.getParameter("wepkey", accessPoint),
                "ModeEnabled": encryption
            }
        };

        // Hack for SAH not saving password if security set to No Password
        if (encryption === "None") {
            saveData.parameters.mibs.wlanvap[wlID].Security.WEPKey = this.getParameter('wepkey', accessPoint);
            saveData.parameters.mibs.wlanvap[wlID].Security.KeyPassPhrase = this.getParameter('password', accessPoint);
        }

        // Send saving request:
        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/' + wlID + ':setWLANConfig',
            data: saveData,

            success: function(response) {
                if (response.status === null) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    switchToCombinedMode: function(accessPoint) {
        var ssid = this.getParameter('name', '5GHz'),
            password = this.getParameter('password', '5GHz'),
            encryption = this.getParameter('encryption', '5GHz'),
            visibility = this.getParameter('visibility', '5GHz'),
            wlID = this.getParameter("accessPointID", accessPoint),
            saveData = {
                "parameters": {
                    "mibs": {
                        "wlanvap": {}
                    }
                }
            },
            deferred = new $.Deferred();

        // Main data selection
        saveData.parameters.mibs.wlanvap[wlID] = {
            "SSID": ssid,
            "SSIDAdvertisementEnabled": visibility,
            "Security": {
                "KeyPassPhrase": password,
                "WEPKey": this.getParameter("wepkey", accessPoint),
                "ModeEnabled": encryption
            }
        };

        // Send saving request:
        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/' + wlID + ':setWLANConfig',
            data: saveData,

            success: function(response) {
                if (response.status === null) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveSettingsGuest: function(accessPoint, data) {
        var ssid = '',
            password = '',
            encryption = '',
            wlID = this.getParameter("accessPointID", "Guest-" + accessPoint),
            saveData = {
                "parameters": {
                    "mibs": {
                        "wlanvap": {}
                    }
                }
            },
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "ssid") {
                ssid = value.parameterValue;
            }

            if (value.parameterName === "password") {
                password = value.parameterValue;
            }

            if (value.parameterName === "encryption") {
                encryption = value.parameterValue;
            }
        });

        // Prepare data to be saved:
        saveData.parameters.mibs.wlanvap[wlID] = {
            "SSID": ssid,
            "Security": {
                "KeyPassPhrase": password,
                "WEPKey": this.getParameter("wepkey", "Guest-" + accessPoint),
                "ModeEnabled": encryption
            }
        };

        // Hack for SAH not saving password if security set to No Password
        if (encryption === "None") {
            saveData.parameters.mibs.wlanvap[wlID].Security.WEPKey = this.getParameter('wepkey', "Guest-" + accessPoint);
            saveData.parameters.mibs.wlanvap[wlID].Security.KeyPassPhrase = this.getParameter('password', "Guest-" + accessPoint);
        }

        // Send saving request:
        swc.models.Rest.sendRequest({
            url: '/sysbus/NeMo/Intf/' + wlID + ':setWLANConfig',
            data: saveData,

            success: function(response) {
                if (response.status === null) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    createModels: function(response, isGuest) {

        var self = this,
            accessPoints = response.status.wlanradio,
            accessPointData = response.status.wlanvap,
            accessPEnableData = response.status.penable;


        // Create models:
        $.each(accessPoints, function(accessPoint, data) {

            var model = new swc.constructors.SimpleModel(),
                accessPointName = data.OperatingFrequencyBand,
                accessPointID,
                baseData;

            // Check if guest Access Point
            if (isGuest) {
                baseData = accessPointName === '2.4GHz' ? accessPointData.wlguest2 : accessPointData.wlguest5;
                accessPointID =  accessPointName === '2.4GHz' ? 'wlguest2' : 'wlguest5';
                accessPointName = 'Guest-' + data.OperatingFrequencyBand;
            } else {
                baseData = accessPointName === '2.4GHz' ? accessPointData.wl0 : accessPointData.wl1;
                accessPointID =  accessPointName === '2.4GHz' ? 'wl0' : 'wl1';
            }

            // Set main options
            model.set('id', accessPointName);
            model.set('accessPoint', accessPointName);
            model.set('driver', accessPoint);
            model.set('accessPointID', accessPointID);

            // Main data:
            model.set('name', baseData.SSID);
            // FIX SA-1319: Incorrect data used to get Activation status of radio access points 
            model.set('status', accessPEnableData[accessPoint].PersistentEnable);
            model.set('visibility', baseData.SSIDAdvertisementEnabled);

            // Security data:
            model.set('password', baseData.Security.KeyPassPhrase);
            model.set('wepkey', baseData.Security.WEPKey);
            model.set('encryption', baseData.Security.ModeEnabled);
            model.set('encryptionsSupported', baseData.Security.ModesSupported.split(','));
            
            // Set driver data:
            model.set('channel', data.Channel);
            model.set('channelAutoEnable', data.AutoChannelEnable);
            model.set('channelsSupported', data.PossibleChannels.split(','));
            model.set('operating', data.OperatingStandards);
            model.set('operatingsSupported', data.SupportedStandards.split(','));
            model.set('OperatingStandards', data.OperatingStandards);
            model.set('OperatingChannelBandwidth', data.OperatingChannelBandwidth);

            // Add model to the collection;
            self.add(model);
        });
    },

    getParameter: function(parameter, accessPoint) {
        var search = this.where({ accessPoint: accessPoint });

        if (search.length) {
            return search[0].get(parameter);
        } else {
            return '';
        }
    },

    isAccessPointsEquals: function(interfaceOne, interfaceTwo, keys) {
        var self = this,
            isEquals = true;

        if (keys.length) {
            $.each(keys, function(key, value) {
                if (self.getParameter(value, interfaceOne) !== self.getParameter(value, interfaceTwo)) {
                    isEquals = false;
                }
            });
        }

        return isEquals;
    },

    formatModeOptions: function() {
        return {
            "combined": {
                name: getTranslationStrings("Combined"),
                value: "combined"
            },
            "separate": {
                name: getTranslationStrings("Separate"),
                value: "separate"
            }
        };
    },

    formatEncryptionOptions: function(accessPoint) {
        var options = [],
            enabled = {
                "WPA2-Personal": getTranslationStrings("WPA2"),
                "WPA-WPA2-Personal": getTranslationStrings("WPA/WPA2"),
                "None": getTranslationStrings("No encryption")
            };

        $.each(enabled, function(encryption, value) {
            options.push({
                name:  value,
                value: encryption
            });
        });

        return options;
    },

    formatOperatingOptions: function(accessPoint) {
        var accessPointOptions = this.getParameter('operatingsSupported', accessPoint),
            options = {},
            enabled = {
                "n": getTranslationStrings("802.11 n"),
                "ac": getTranslationStrings("802.11 ac"),
                "an": getTranslationStrings("Auto (802.11 a/n/ac)"),
                "bgn": getTranslationStrings("Auto (802.11 b/g/n)")
            };

        // Walk throuh all supported and enabled options
        $.each(accessPointOptions, function(key, value) {
            if (enabled[value]) {
                options[value] = {
                    name:  enabled[value],
                    value: value
                };
            }
        });

        return options;
    },

    formatChannelsOptions: function(accessPoint) {
        var search = this.where({ accessPoint: accessPoint }),
            channelsSupported,
            model,
            options = {
                "auto": {
                    name:  getTranslationStrings("Auto channel"),
                    value: "auto"
                }
            };

        if (search.length) {
            model = search[0];
            channelsSupported = model.get("channelsSupported");

            if (channelsSupported.length) {
                $.each(channelsSupported, function(key, channel) {
                    options[channel] = {
                        name:  channel,
                        value: channel
                    };
                });
            } else {
                return options;
            }
        } else {
            return options;
        }

        return options;
    },

    formatDeactivationOptions: function(accessPoint) {
        return [
            { name: getTranslationStrings("No auto disabling"), value: "0", isDefault: true },
            { name: getTranslationStrings("6 hours"), value: "21600" },
            { name: getTranslationStrings("12 hours"), value: "43200" },
            { name: getTranslationStrings("24 hours"), value: "86400" }
        ];
    }
});
;swc.constructors.ApplicationModel = Backbone.Model.extend({

    /**
     * Init application model
     */
    initialize: function() {
        var self = this;
        // Load templates and necessary scripts:
        swc.Templates = swc.Templates ? swc.Templates : new swc.constructors.Templates();
        swc.Templates.loadTemplates(function() {
            swc.models.Locale = new swc.constructors.LocaleModel();

            var storedLocal = localStorage.getItem("locale");
            // When it is the very first run or cache and local storage are cleared
            if (!storedLocal) {
                self.initLocaleFallback();
            }
            // otherwise - get locale preference from the serverside
            else {
                $.when(swc.models.Locale.getLocale())
                    .done(function(response){
                        $.when(swc.models.Locale.setLocale(response.status))
                            .always(function() {
                                self.initComponents();
                            });
                    })
                    .fail(function(){
                        self.initLocaleFallback();
                    });
            }
        });
    },

    sync: function(fromListener) {
        var deferred = $.Deferred();

        $.when(this.getAPGlobalState(fromListener), swc.models.PasswordRecovery.sync("read", { isListener: fromListener }))
            .always(function() {
                deferred.resolve();
            });

        return deferred.promise();
    },

    /**
     * Fallback mechanism to get locale from local storage or default settings
     * and save it on server side
     *
     * @return void
     */
    initLocaleFallback: function() {
        var self = this;
        var appLocale = getApplicationLocale(swc.models.Locale.available);
        if (appLocale === "undefined") {
            appLocale = swc.models.Locale.defaultLocale;
        }
        // save locale preference on server side
        $.when(swc.models.Locale.setLocale(appLocale)).always(function() {
            self.initComponents();
        });
    },

    /**
     * Init core models and views
     *
     * @return void
     */
    initComponents: function() {
        var self = this;

        // we have to have PasswordRecovery model in order to show link on login page
        swc.models.PasswordRecovery = new swc.constructors.PasswordRecovery();
        
        // Init basic views:
        swc.views.Application = new swc.constructors.ApplicationView();
        swc.views.Login = new swc.constructors.LoginView();

        // Init basic models:
        swc.models.Login = new swc.constructors.LoginModel();
        swc.models.Rest = new swc.constructors.Rest();

        // Need to get all login information because of incorrect implementation of login model
        $.when(this.sync())
            .done(function() {
                self.coreRun();
            })
            .fail(function() {
                self.coreRun();
            });
    },

    /**
     * Gets an example of time from server and keeps it in swc.settings
     * Is used for formatting dates in server's timezone.
     */
    initServerTimeZone: function() {
        var self = this,
            onRequestComplete = function(response) {
                if (response && response.data && response.data.time) {
                    swc.settings.serverTimeZone = moment.parseZone(response.data.time).zone();
                } else {
                    setTimeout(function() {
                        self.initServerTimeZone();
                    }, 1000);
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 1000,
            data: {
                "parameters": {}
            },
            success: onRequestComplete,
            error: onRequestComplete
        });
    },

    /**
     * Start application:
     */
    coreRun: function() {
        var userLogin = swc.models.Login.checkUserLogin();

        if (userLogin) {
            this.initServerTimeZone();
            //swc.models.Login.loginStatusListener();
        }

        // Pre render application area if user is logged in:
        if (window.isOnStickyPage){
            Backbone.history.start(); // no router, so need to do this
            swc.views.StickyPageView = new swc.constructors.StickyPageView();
        } else {
            // Init Application Router:
            swc.router = swc.router ? swc.router : new swc.constructors.Router();
        }
    },

    // get global AP state
    getAPGlobalState: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        // Just in case ;-) Actually we call swc.settings throughout all application
        self.set('domainName', swc.settings.application.get('url'));

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController:get',
            fromListener: fromListener,
            data: {
                parameters: {}
            },

            success: function(response) {
                if (response.status !== null) {
                    self.set(response.status);
                    self.set(response.status);
                } else {
                    self.set({
                        GlobalEnable: false,
                        DNSName: swc.settings.application.get('apUrl')
                    });
                }
                deferred.resolve();
            },

            error: function() {
                self.set({
                    GlobalEnable: false,
                    DNSName: swc.settings.application.get('apUrl')
                });
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.EventManager = swc.BaseModel.extend({
    
    url: "/ws",

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-event-1-call+json"
    },

    defaults: {
        "channelid": 0, // mark that subscription channel should be created
        "events": []
    },
    
    /**
     * Creates an Event-Manager channel to listen for subscribed events
     * 
     * @returns Promise
     */
    openChannel: function() {
        var deferred = new $.Deferred();
        
        $.when(this.sync("create", {silent: true}))
            .done(function () {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });
        
        return deferred.promise();
    }
});

/**
* This is just a helper Object to be passed into EventManagerListener
*/
swc.constructors.StargateEvent = swc.BaseModel.extend();

swc.constructors.EventManagerListener = swc.BaseCollection.extend({
    
    url: "/ws",
    
    model: 'StargateEvent',

    ajaxSettings: {
        requestType: 'POST',
        requestDataType: 'json',
        contentType: "application/x-sah-event-1-call+json"
    },

    defaults: {
        "channelid": 0, // mark that subscription channel should be crerated
        "events": []
    },
    
    apiToJSON: function (response) {
        /**
         * Example response would be:
         * {"channelid":12,"events":[{"data":{"handler":"Screen","object":{"reason":"PasswordRecovery","attributes":{"response":"Allowed"}}}}]}
         */
        var result = [];
        
        if (!_.isEmpty(response.events)) {
            _.each(response.events, function (elem) {
                result.push({
                    "handler": elem.data.handler,
                    "reason": elem.data.object.reason,
                    "attributes": elem.data.object.attributes
                });
            });
        }
        
        return result;
    },

    setAjaxParameters: function (ajaxParameters) {
        this.ajaxParameters = ajaxParameters;
    },
    
    /**
     * Listen to subscribed events using currently opened channel
     */
    listenChannel: function() {
        var deferred = new $.Deferred();

        $.when(this.sync("read", {silent: false}))
            .done(function () {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});
;swc.constructors.PasswordRecovery = swc.BaseModel.extend({
    
    url: {
        "read": "/sysbus/PasswordRecovery:getStatus",
        "update": "/sysbus/PasswordRecovery:setEnable"
    },
    
    defaults: {
        'recoveryEnable': false,
        'recoveryStatus': null
    },

    apiToJSON: function (response) {
        if (!response || !response.status) {
            return {
                recoveryEnable: false,
                recoveryStatus: false
            };
        }
        return {
            recoveryEnable: response.status[0],
            recoveryStatus: response.status[1]
        };
    },
    
    toJSON: function () {
        return {
            parameters: {
                Enable: this.get('recoveryEnable')
            }
        };
    },
    
    startProcess: function () {
        var deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:start',
            data: {
                parameters: {}
            },
            
            success: function () {
                deferred.resolve();
            },
            
            error: function () {
                deferred.reject();
            }
        });
            
        return deferred.promise();
    },
    
    stopProcess: function () {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:stop',
            data: {
                parameters: {}
            },

            success: function () {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Short method to check if Recovery Process is currently running
     * 
     * @returns {boolean}
     */
    isRecoveryRunning: function(){
        return this.get("recoveryStatus") === "Processing";
    },

    setNewPassword: function(password) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:setPassword',
            data: {
                parameters: {
                    password: password
                }
            },

            success: function(response) {
                deferred.resolve(response.status);
            }
        });

        return deferred.promise();
    }
    
});
;swc.constructors.FileManager = swc.BaseCollection.extend({

    url: {
        read: '/ws'
    },

    ajaxParameters: {
        service: "com.swisscom.stargate/ws/nas/filemanager.com.swisscom.stargate.nas.filemanager",
        method: "listFiles",
        parameters: {
            id: 0,
            path: "/"
        }
    },

    initialize: function() {
        var args = Array.prototype.slice.call(arguments),
            errorMessage = 'For retrieving list of files the device ID should be set';

        if (args.length === 0 || _.isUndefined(args[1])) {
            throw new Error(errorMessage);
        }

        if (_.isUndefined(args[1].deviceID)) {
            throw new Error(errorMessage);
        }

        this.ajaxParameters.parameters.id = args[1].deviceID;
        swc.BaseCollection.prototype.initialize.apply(this, arguments);
    },

    /**
     * Comparator sorts elements, so folders will go first
     *
     * @return {String}
     */
    comparator: function(model) {
        var ftype = model.get('type');

        ftype = ftype.toLowerCase();
        ftype = ftype.split('');
        ftype = _.map(ftype, function(letter) {
            return String.fromCharCode(-(letter.charCodeAt(0)));
        });

        return ftype;
    },

    apiToJSON: function(response) {
        var self = this,
            parsedResponse = {},
            parsedData = [];

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.status === 200) {
                _.each(parsedResponse.data, function(file) {
                    parsedData.push({
                        isSync: file.syncEnabled,
                        id: file.name,
                        name: file.name,
                        size: file.size * 1024,
                        syncState: self.getSyncState(file.syncState),
                        type: file.type,
                        virtual: file.virtual
                    });
                });
            }
        } catch (e) {}

        return parsedData;
    },

    /**
     * Set cloud backup state
     *
     * @param responseSyncState
     * @returns {*}
     */
    getSyncState: function(responseSyncState) {
        var map = {
            'IN_PROGRESS': 'progress',
            'UPLOAD_IN_PROGRESS': 'progress',
            'DELETE_IN_PROGRESS': 'progress',
            'COMPLETE': 'complete',
            'ERROR': 'error'
        };

        if (_.isUndefined(map[responseSyncState])) {
            return 'not_sync';
        }

        return map[responseSyncState];
    }

});;swc.constructors.InternetBackupStick = swc.BaseModel.extend({

    url: "/sysbus/NeMo/Intf/wwan:getMIBs",

    apiToJSON: function(json) {
        var data = (json && json.status && json.status.wwan) ? json.status.wwan.wwan : {};

        return {
            isConnected: data.ConnectionStatus === "Connected",
            status: data.ConnectionStatus,
            provider: data.APN,
            technology: data.Technology,
            signalLevel: data.SignalStrength
        };
    }

});;swc.constructors.LoginModel = Backbone.Model.extend({

    adminName: "admin",

    /**
     * Shows current login state
     */
    isLoggedIn: false,

    /**
     * Check if user is logged in:
     *
     * @description user login is stored in two cookies {contextID} and {.../sessid}
     *
     * @return {Boolean}
     *
     */
    checkUserLogin: function() {
        var deviceID = getDeviceID();

        if (!deviceID || !$.cookie(deviceID + '/sessid')) {
            return false;
        } else {
            return true;
        }
    },

    /**
     * Check if the user is logged in via checking response message
     *
     * @description:
     *
     * if the response from device contains text "Permission denied" then
     * user is not logged in and the logout process should be started
     *
     * @param xhr {xmlHttpRequest} Response from device
     */
    checkAccessToDevice: function(xhr) {
        var errorText = 'Permission denied';

        if (_.isUndefined(xhr)) {
            swc.models.Login.processLogout({ action: 'session-logout' });
            return;
        }

        if (!_.isUndefined(xhr.responseText) && _.isString(xhr.responseText) && xhr.responseText.indexOf(errorText) !== -1) {
            swc.models.Login.processLogout({ action: 'session-logout' });
            return;
        }

        if (!_.isUndefined(xhr.errors) && !_.isEmpty(xhr.errors) && !_.isEmpty(_.where(xhr.errors, { description: errorText }))) {
            swc.models.Login.processLogout({ action: 'session-logout' });
        }
    },

    /**
     * Check if user is super admin
     * @returns {boolean}
     */
    checkUserSuperAdmin: function() {
        var isSuperAdmin = false;

        if (!_.isNull(localStorage.getItem('userSuperAdmin')) && localStorage.getItem('userSuperAdmin')) {
            isSuperAdmin = true;
        }

        return isSuperAdmin;
    },

    /**
     * Change password. It is needed in System and Login
     * @param password
     * @returns {*}
     */

    changePassword: function(password){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/UserManagement:changePassword',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                parameters: {
                    name: self.adminName,
                    password: password
                }
            },

            success: function(response) {
                deferred.resolve(response.result.status);
            }
        });

        return deferred.promise();

    },

    /**
     * Remove application cookies
     */
    removeCookies: function(){
        var deviceID = getDeviceID();

        // Expire all SAH cookies
        $.cookie(deviceID + '/context', '', { expires: -1 });
        $.cookie(deviceID + '/sessid', '', { expires: -1 });

        // Expire all SWC cookies
        $.cookie('swc/deviceID', '', { expires: -1 });
    },

    /**
     * Sign-out user and release context on NP side
     * @param options {Object|null} Possible values:
     *                              - action : defines how signing out was performed - by session timeout or manually
     *                              - redirectUrl : if we have to redirect user to some url after have signed them out
     * @returns {*|Promise.promise}
     */
    processLogout: function(options) {
        var self = this;

        // preventing multiple logout processing
        if (this.isLoggedIn) {
            // Only do local sign-out post-processing if successfully signed-off on NP side
            // Release current context on NP side
            $.when(swc.models.Rest.sendRequest({
                    url: '/ws',
                    method: 'POST',
                    headers: {
                        "Authorization": "X-Sah-Logout " + $.cookie(getDeviceID() + '/context'),
                        'X-Context': $.cookie(getDeviceID() + '/context')
                    },
                    data: {
                        service: "sah.Device.Information",
                        method: "releaseContext",
                        parameters: {
                            applicationName: "webui"
                        }
                    }
                }))
                .always(function () {
                    self.isLoggedIn = false;
                    self.setLogoutState(options);
                });
        } else {
            this.setLogoutState(options);
        }
    },

    /**
     * Set application state after logout
     *
     * @description:
     *
     * This method perform following actions:
     * 1.Sets application env variables to appropriate state(action-logout, session-logout,
     *   reset-logout) in the localStorage
     * 2.Removes session cookies
     * 3.Triggers events: beforeLogout, afterLogout
     * 4.Redirects on the login/remoteLogin page
     *
     * @localParam router {swc.constructors.Router | Backbone.history} When user is not logged in
     *             and tries to navigate on the some inside page, e.g. http://localhost:3000/#storage/settings,
     *             the swc.constructors.Router is not exist and it's not possible to use its method
     *             navigate(). In this case should be used the method navigate() of the Backbone.history object
     *
     * @param options {Object} addition logout options
     * Param <options> can accept two keys:
     *   - action - defines the source which has initialized logout action.
     *              Can accept the following values:
     *              * user-logout - action initiated by user themself by clicking on "Logout" button
     *              * session-logout - session expired on server
     *              * reset-logout - when i-Box redirected after 'Upgrade'/'Restore Config'/'FactoryReset' operations
     *
     *   - redirectUrl - if after logout user should be redirected to some page
     *
     * @return void
     */
    setLogoutState: function(options) {
        var self = this,
            currentPage = Backbone.history.fragment,
            userIsSuperAdmin = this.checkUserSuperAdmin(),
            router = _.isUndefined(swc.router) ? Backbone.history : swc.router,
            doRouterTrigger = _.isUndefined(swc.router) ? true : false;

        // Local logout procedure starts here
        self.removeCookies();

        // WARNING!!!
        // DO NOT REMOVE THIS BLOCK OF CODE!
        // Sometimes we just must redirect user's browser to some url in order to refresh index.html page
        if (options && options.redirectUrl) {
            localStorage.setItem('previous-page', 'overview');
            // Set flag back that this user was logged in remotely
            var loginPageUrl = "/";
            if (userIsSuperAdmin) {
                localStorage.setItem('remoteLogin', true);
                loginPageUrl = loginPageUrl + "#remote-login";
            }
            document.location.href = options.redirectUrl + loginPageUrl;
            return;
        }

        // Let listeners know that we are about to sign out
        self.trigger('beforeLogout');

        // Hide all modals and popovers
        SWCElements.modalWindow.hide();
        SWCElements.popovers.closeAll();

        // We have to navigate user to correct page after logout / session logout / not logged in access
        if (options && options.action) {
            switch (options.action) {
                case 'user-logout':
                    localStorage.setItem('action-logout', 'true');
                    break;
                case 'session-logout':
                    localStorage.setItem('session-logout', 'true');
                    break;
                case 'reset-logout':
                    localStorage.setItem("reset-logout", 'true');
                    break;
            }

            localStorage.setItem('previous-page', 'overview');
        } else {
            if (!localStorage.getItem('previous-page') || localStorage.getItem('previous-page') === "overview") {
                localStorage.setItem('previous-page', Backbone.history.fragment);
            }
        }

        // Set flag back that this user was logged in remotely
        if (userIsSuperAdmin) {
            localStorage.setItem('remoteLogin', true);
        }

        // Update current application page:
        if (currentPage !== 'login' && currentPage !== 'remote-login') {
            if (!_.isNull(localStorage.getItem('remoteLogin'))) {
                if (currentPage === 'remote-login') {
                    swc.views.Login.renderComplete();
                } else {
                    router.navigate('remote-login', { trigger: doRouterTrigger, skipUnsavedChanges: true });
                }
            } else {
                if (currentPage === 'login') {
                    swc.views.Login.renderComplete();
                } else {
                    router.navigate('login', { trigger: doRouterTrigger, skipUnsavedChanges: true });
                }
            }
        } else {
            swc.views.Login.renderComplete();
        }

        self.trigger('afterLogout');
    },
    

    /**
     * Process user login:
     *
     * @param login {String}
     * @param password {String}
     *
     */
    processLogin: function(login, password) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',

            headers: {
                Authorization: 'X-Sah-Login'
            },

            data: {
                service: "sah.Device.Information",
                method: "createContext",
                parameters: {
                    applicationName: "webui",
                    username: login,
                    password: password
                }
            },

            success: function(response) {
                if (response.status === 0) {

                    self.isLoggedIn = true;

                    var deviceID = getDeviceID();

                    // Set Device ID Cookie
                    // In order to define not deleted cookies from previous logins by old device ID
                    $.cookie('swc/deviceID', deviceID);

                    // Set Context Cookie
                    $.cookie(deviceID + '/context', response.data.contextID);

                    //self.loginStatusListener();

                    // Let application know if user is super admin
                    if (login === "superadmin") {
                        localStorage.setItem('userSuperAdmin', true);
                    } else {
                        localStorage.removeItem('userSuperAdmin');
                    }

                    deferred.resolve({status: true, response: response});
                } else {
                    deferred.resolve({status: false, response: response});
                }
            },

            error: function(xhr, ajaxOptions, thrownError) {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Listener for user login status:
     */
    loginStatusListener: function() {
        var self = this,
            interval = 10,  // seconds
            onRequestComplete = function() {
                var userLogin = self.checkUserLogin();

                if (!userLogin) {
                    self.processLogout({ action: 'session-logout' });
                } else {
                    setTimeout(function() {
                        self.loginStatusListener();
                    }, interval * 1000);
                }
            };

        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 2000,
            data: {
                "parameters": {}
            },
            success: onRequestComplete,
            error: onRequestComplete
        });
    },

    /**
     * Get device recovery status - true or false
     * @returns {*}
     */
    getRecoveryStatus: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/PasswordRecovery:getStatus',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                parameters: {}
            },

            /**
             * NOTE:
             * NP returns response as such: {result: {status: [1, "Enable"]}},
             * where first element of array is true|false indicating either feature is enabled at all.
             * Second element indicates what is the current status of recovery:
             * "Enable" - we can start a new process; "Processing" - means there is a process in-progress.
             */
            success: function(response) {
                if (!_.isUndefined(response.result) && !_.isUndefined(response.result.status)) {
                    self.set('recoveryEnable', response.result.status[0]);
                    self.set('recoveryStatus', response.result.status[1]);
                } else {
                    self.set('recoveryEnable', false);
                    self.set('recoveryStatus', null);
                }
                deferred.resolve();
            },

            error: function(response) {
                self.set('recoveryEnable', false);
                self.set('recoveryStatus', null);
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Set device recovery status
     * 
     * @param {Boolean} isEnable
     * 
     * @returns {*}
     */
    setRecoveryStatus: function(isEnable){
        var self = this,
            deferred = new $.Deferred();

        swc.models.PasswordRecovery.set("recoveryEnable", isEnable);
        $.when(swc.models.PasswordRecovery.sync("update"))
            .done(function () {
                deferred.resolve();
            })
            .fail(function () {
                deferred.reject();
            });
        
        return deferred.promise();
    }
    
});
;swc.constructors.DynDNS = swc.BaseModel.extend({
    
    url: {
        'read': '/sysbus/DynDNS:getGlobalEnable',
        'update': '/sysbus/DynDNS:setGlobalEnable'
    },
    
    toJSON: function() {
        return {
            parameters: {
                'enable': this.get('enable')
            }
        };
    },
    
    apiToJSON: function (response) {
        return {'enable': response.status};
    }
    
});
;swc.constructors.DynDNSProvider = swc.BaseModel.extend({

    url: {
        'create': '/sysbus/DynDNS:addHost',
        'update': '',
        'delete': '/sysbus/DynDNS:delHost'
    },
    
    toJSON: function () {
        return {
            parameters: this.attributes
        };
    },

    validation: {
        service: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    service: { elementName: 'Service' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['service'])) {
                validationMessages.push("should not be empty");
            }
            
            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        hostname: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    hostname: { elementName: 'hostname' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['hostname'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        username: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    username: { elementName: 'username' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['username'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },
        
        password: function (data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    "password": { elementName: 'password' },
                    globalStatus: { elementName: 'DynDNSEnable' }
                }, data);

            if (validationData.globalStatus === false) {
                return {
                    status: true,
                    messages: []
                };
            }

            if (!$.trim(validationData['password'])) {
                validationMessages.push("should not be empty");
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        }
    }
    
});
;swc.constructors.FirewallPolicy = swc.base.Model.extend({

    actionGet: "/sysbus/Firewall:getChainPolicy",
    actionSet: "/sysbus/Firewall:setChainPolicy",

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(
                this.makeRequest({chain: "Custom_V6In"}, this.actionGet, fromListener),
                this.makeRequest({chain: "Custom_V6Out"}, this.actionGet, fromListener)
            ).done(function(inbound, outbound){
                self.build(inbound, outbound);
                deferred.resolve();
            });

        return deferred.promise();
    },

    makeRequest: function(parameters, endpoint, fromListener){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: endpoint,
            fromListener: fromListener,
            data: {
                "parameters": parameters
            },

            success: function(response) {
                deferred.resolve(response);
            }
        });

        return deferred.promise();
    },

    build: function(inbound, outbound) {
        if (!inbound['status'] || !outbound['status'] || inbound['status'] === "None" || outbound['status'] === "None") {
            this.set({
                inbound: 'Accept',
                outbound: 'Accept'
            });
        } else {
            this.set({
                inbound: inbound['status'],
                outbound: outbound['status']
            });
        }
    },

    getValue: function(){
        var inbound = this.get('inbound'),
            outbound = this.get('outbound');

        if (!inbound || !outbound) {
            return;
        }

        return inbound + '_In-' + outbound + '_Out';
    },

    setValue: function(data) {
        var deferred = new $.Deferred(),
            self = this,
            actions,
            policy,
            toDo = [];

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "policy") {
                policy = value.parameterValue;
            }
        });

        // Parse actions to two
        actions = this.parseValue(policy);

        // Get list of request to be executed
        _.each(actions, function(action) {
            toDo.push(self.makeRequest(action, self.actionSet));
        });

        $.when.apply(null, toDo).done(function() {
            deferred.resolve();
        });

        return deferred.promise();
    },

    parseValue: function(value){
        var targets = value.split('-'),
            targetHash = {};

        _.each(targets, function(val, key){
            targetHash[val.split('_')[1]] = val.split('_')[0];
        });

        return [{chain: "Custom_V6In", policy: targetHash["In"]},
            {chain: "Custom_V6Out", policy: targetHash["Out"]}];

    },

    formatPolicyOptions: function() {
        var options = {},
            enabled = {
                "Accept_In-Accept_Out": getTranslationStrings("Allow inbound and outbound"),
                "Drop_In-Drop_Out": getTranslationStrings("Block inbound and outbound"),
                "Accept_In-Drop_Out": getTranslationStrings("Allow inbound/Block outbound"),
                "Drop_In-Accept_Out": getTranslationStrings("Block inbound/Allow outbound")
            };

        // Walk throuh all supported and enabled options
        $.each(enabled, function(key, value) {
            options[key] = {
                name:  value,
                value: key
            };
        });

        return options;
    }
});
;swc.constructors.FirewallStatus = swc.base.Model.extend({

    json: {parameters:{}},

    saveJSON: {parameters:{}},

    possibleStatus: {
        "off": "Low",
        "balanced": "Medium",
        "strict": "High",
        "custom": "Custom"
    },


    getFirewallState: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NetMaster/IPv6/IPv6rd:get',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getSecurityLevel: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:getFirewallIPv6Level',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    /*
     * Redefined sync method, because sync in base model fall down if there is param 'status' in response
     * */
    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(this.getSecurityLevel(fromListener), this.getFirewallState(fromListener))
            .done(function(level, state) {
                self.set({
                    status: level.status,
                    state: state.status
                });
                deferred.resolve();
            });

        return deferred.promise();
    },

    saveSettedLevel: function(data) {
        var self = this,
            deferred = new $.Deferred(),
            newStatus, newLevel;

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "security-level") {
                newStatus = value.parameterValue;
            }
        });

        swc.models.Rest.sendRequest({
            url: '/sysbus/Firewall:setFirewallIPv6Level',
            data: {
                "parameters": {
                    level: self.possibleStatus[newStatus]
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    saveFirewallState: function(data) {
        var self = this,
            newState,
            deferred = new $.Deferred();

        // Get neccessary params from array of page data:
        $.each(data, function(key, value) {
            if (value.parameterName === "IPv6Enable") {
                newState = value.parameterValue;
            }
        });

        swc.models.Rest.sendRequest({
            url: '/sysbus/NetMaster/IPv6/IPv6rd:set',
            data: {
                "parameters": {
                    "Enable": newState
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

});
;swc.constructors.PortForwardingRule = swc.BaseModel.extend({

    url: {
        // keys quoted uniformly, but the reason is 'delete'
        // because IE thinks it's a key word
        'create': '/sysbus/Firewall:setPortForwarding',
        'update': '/sysbus/Firewall:setPortForwarding',
        'delete': '/sysbus/Firewall:deletePortForwarding',
        'commit': '/sysbus/Firewall:commit'
    },

    apiToJSON: function(response) {
        return response;
    },

    toJSON: function() {
        var json = {
            parameters: {
                id: this.get('id'),
                description: this.get('name'),
                persistent: true,
                origin: 'webui',
                sourceInterface: 'data', // Scope of PF rules
                sourcePrefix: '',        // Has to be empty for PF, used for IPv6
                enable: this.get('status'),
                protocol: this.get('protocol'),
                destinationIPAddress: this.get('deviceIP'),
                internalPort: this.get('ports').destination[0],
                externalPort: this.get('ports').entry[0]
            }
        };

        if (this.get('ports').destination.length === 2) {
            json.parameters.internalPort = this.get('ports').destination.join('-');
        }

        if (this.get('ports').entry.length === 2) {
            json.parameters.externalPort = this.get('ports').entry.join('-');
        }

        // IF rule is UPnP it must be empty
        if (this.get('isUPnP')) {
            json.parameters.origin = 'upnp';
            json.parameters.sourceInterface = '';
            json.parameters.sourcePrefix = '';
        }

        return JSON.stringify(json);
    }

});
;swc.constructors.UPnP = swc.BaseModel.extend({

    url: {
        read: "/sysbus/UPnP-IGD:get",
        update: "/sysbus/UPnP-IGD:set"
    },
    
    apiToJSON: function(json) {
        var data = json.status;

        return {
            status: data ? data.Enable : false
        };
    },

    toJSON: function() {
        return JSON.stringify({
            "parameters": {
                "Enable": this.get('status')
            }
        });
    }
});
;swc.constructors.ApplicationPart = Backbone.Model.extend({



    sync: function(fromListener){
        var self = this, deferred = new $.Deferred();
        $.when(self.getServiceState(fromListener)).done(function(){
            deferred.resolve();
        });
        return deferred.promise();
    },

    setServiceState: function(){

        var self = this, deferred = new $.Deferred();

        var request = {
            "parameters":{
                "mode": self.get('serviceState')?"ON":"OFF"
            }
        };


        swc.models.Rest.sendRequest({
            url: '/sysbus/APController/PowerManagement:setMode',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            data: request,

            success: function(response) {
                deferred.resolve();
            }
        });
        return deferred.promise();

    },

    getServiceState: function(fromListener){

        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/APController/PowerManagement:getMode',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            fromListener: fromListener,

            data: { "parameters":{} },

            success: function(response) {
                if(response.data && response.data.mode){
                    self.set('serviceState', response.data.mode === "ON" ? true : false);
                }
                deferred.resolve();
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.AfpServices = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/nas/fileservices.com.swisscom.stargate.nas.fileservices',
        method: 'list',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);
            
            if (parsedResponse.success) {
                result.status = _.findWhere(parsedResponse.fileServices, { service: 'AFP' }).enabled;
            }
        } catch (e) {}

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/nas/fileservices.com.swisscom.stargate.nas.fileservices",
            method: "setState",
            parameters: {
                data: JSON.stringify({
                    service: 'AFP',
                    enabled: this.get('status')
                })
            }
        });
    }

});
;swc.constructors.apServiceLoadingState = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/core/info.com.swisscom.stargate.app',
        method: 'getApplicationStatus',
        parameters: JSON.stringify({})
    }),

    isForceSync: true,

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                isLoading: true
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);
            result = parsedResponse;

            if (!_.isUndefined(parsedResponse.status) && parsedResponse.status === "STARTED") {
                result.isLoading = false;
            }
        } catch (e) {}

        return result;
    },

    /**
     * Helper method to check if AP is completely started
     * 
     * @returns {boolean}
     */
    isApStarted: function () {
        return this.get("status") === "STARTED";
    }

});
;swc.constructors.apServiceState = swc.BaseModel.extend({

    url: {
        read: '/sysbus/APController/PowerManagement:getMode',
        update: '/sysbus/APController/PowerManagement:setMode'
    },

    isForceSync: true,

    apiToJSON: function(response) {
        var result = {
                status: false
            };

        if (!_.isUndefined(response.data) && !_.isUndefined(response.data.mode)) {
            result.status = response.data.mode === 'ON';
        }

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            parameters: {
                mode: this.get('status') === true ? 'ON': 'OFF'
            }
        });
    },

    /**
     * Helper method to check if AP is enabled
     * 
     * @returns {Boolean}
     */
    isEnabled: function () {
        return this.get('status');
    }

});
;// cloud services item
swc.constructors.CloudAccount = swc.BaseModel.extend({

    fields: {
        id: '',
        cloudServiceName: '',
        deviceLabel: '',
        deviceId: '',
        accountName: '',
        status: '',
        error: '',
        totalSpace: '',
        usedSpace: '',
        lastSyncDate: '',
        folderName: ''
    },

    getExtendedJSON: function () {
        var info = this.toJSON(),
            status = this.get('status'),
            usedSpace = this.get('usedSpace'),
            totalSpace = this.get('totalSpace'),
            lastSyncDate = this.get('lastSyncDate'),
            // get server's timezone for date formatting:
            timezone = swc.settings.serverTimeZone || '';

        moment.lang(swc.models.Locale.locale);

        info.isActivated = status !== 'DISABLED';
        info.lastSync = lastSyncDate ? moment(lastSyncDate).zone(timezone).format("D MMM YYYY, HH:mm") : "";
        info.lastLogin = moment(new Date()).zone(timezone).format("D MMM YYYY, HH:mm");
        info.usedSpace = swc.Utils.getBytesWithUnit(usedSpace);
        info.freeSpace = (totalSpace < usedSpace) ? 0 : swc.Utils.getBytesWithUnit(totalSpace - usedSpace);
        info.totalSpace = swc.Utils.getBytesWithUnit(totalSpace);
        info.freePercents = (totalSpace < usedSpace) ? 0 : Math.floor(parseFloat(totalSpace - usedSpace) /
                parseFloat(totalSpace ? totalSpace : 1) * 100);

        return info;
    },

    // TODO: migrate to new API when ready
    setBackupState: function(state) {
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "setFolderSyncState",
                parameters: {
                    resources: JSON.stringify({
                        partitionUUID: this.get('deviceId'),
                        folderName: this.get('folderName'),
                        isEnabled: state
                    })
                }
            },

            success: function(response) {
                self.set('status', state ? 'IN_PROGRESS' : 'DISABLED');
                deferred.resolve();
            },

            error: function(response) {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    // TODO: include model.id or  something when backend is done
    logout: function (keepData) {

        var self = this,
            deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "syncFSResources",
                parameters: {
                    resources: [
                        JSON.stringify({
                            deviceId: this.get('deviceId'),
                            content: [
                                JSON.stringify({
                                    path: this.get('folderName'),
                                    action: keepData ? 'REMOVE' : 'REMOVE_AND_DELETE_LOCAL_DATA'
                                })
                            ]
                        })
                    ]
                }
            },

            success: function(response) {
                // Sometimes error may happen when one try remove folder. See ticket [SA-2780].
                if (response && response.status) {
                    var result = JSON.parse(response.status);
                    
                    // some iternal server error happen, show error message
                    if (result.status === 500) {
                        return deferred.reject(result); // stop further execution
                    }
                }
                swc.models.CloudAccountCollection.sync('read');
                deferred.resolve();
            },

            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    forceSyncDevice: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service": "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                "method": "forceFailedTasksForPartition",
                "parameters": {
                    "partitionUUID": this.get("deviceId")
                }
            },

            success: function(response) {
                // Timeout is used because the board responds immediately
                // but actually needs some time to change the sync state.
                // sad but true :(
                setTimeout(function(){
                    deferred.resolve();
                }, 3000);
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.CloudServices = Backbone.Model.extend({

    sync: function(fromListener){
        var self = this, deferred = new $.Deferred();
        $.when(self.getServices(fromListener)).done(function() {
            deferred.resolve();
        });

        return deferred.promise();
    },

    /**
     * activates/deactivates cloud backup feature
     *
     * @param state - boolean
     */
    setBackupState: function(state){
        var deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "setCloudSyncState",
                parameters: {
                    isEnabled: state
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * gets list of cloud services and state of backup feature
     * model.get('services') returns collection of backup services
     * @returns {*}
     *
     {"status": "200"
      "data": {"syncActivated":"true",
               "syncServices": [
                  {"id":"dropbox",
                   "displayName": "Drop Box",
                   "authStatusCode": "200",
                   "default":"true",
                   "totalSpace" : "200000", //in KB
                   "usedSpace" : "1500", //in KB
                   "lastSyncDate" : "10.12.2012, 15:45"
                  },
                  {"id":"googledrive",
                   "displayName": "Google Drive",
                   "authStatusCode": "503",
                   "default": "false",
                   "totalSpace" : "", //in KB
                   "usedSpace" : "", //in KB
                   "lastSyncDate" : ""
                   }
               ]
      }
     }
     * status codes:
     * 200 - authorized
     * 403 - invalid login/password - connection error
     * 503 - deauthorized
     */
    getServices: function(fromListener) {
        var self = this,
            deferred = new $.Deferred(),
            defaultData = {data: {
                syncActivated: false,
                syncServices: [
                    {
                        "id": "dropbox",
                        "displayName": "Drop Box",
                        "authStatusCode": "503",
                        "default": "true",
                        "totalSpace": "200000000",
                        "usedSpace": "1500000",
                        "usedPercents": 1,
                        "lastSyncDate": "10.12.2012, 15:45"
                    }
                ]
            }};

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "getCloudSyncInfo",
                parameters: {}
            },
            fromListener: fromListener,

            success: function(response) {
                var services =  new Backbone.Collection(),
                    resp;

                try {
                    resp = JSON.parse(response.status);
                } catch (e) {
                    resp = defaultData;
                }

                self.set('services', services);

                if (!_.isUndefined(resp.data)) {
                    self.set('active', resp.data.syncActivated);

                    _.each(resp.data.syncServices, function(obj, index) {
                        var serviceModel = new Backbone.Model(obj);

                        serviceModel.set({
                            usedSpace: obj.usedSpace * 1024,
                            totalSpace : obj.totalSpace * 1024,
                            usedPercents: Math.floor(parseFloat(obj.usedSpace) / parseFloat(obj.totalSpace ? obj.totalSpace : 1) * 100)
                        });

                        self.get('services').add(serviceModel);
                    });
                } else {
                    self.set('active', false);
                }

                deferred.resolve();
            },

            error: function(e) {
                var services =  new Backbone.Collection(),
                    resp = defaultData;

                self.set('services', services);

                self.set('active', resp.data.syncActivated);

                _.each(resp.data.syncServices, function(obj, index) {
                    var serviceModel = new Backbone.Model(obj);
                    self.get('services').add(serviceModel);
                });

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    /**
     * Get ID of service in the list which was synced most recently. Although at this moment there is only one service.
     * If collection of services is empty use ID of default service - "dropbox"
     *
     * @return {String} ID of default service, e.g. 'dropbox', 'googledrive'
     */
    getServiceID: function() {
        var serviceID = 'dropbox';
        
        // Sort services by LastSyncDate parameter Descending
        var sortedServices = _.extend({},
            new Backbone.Collection({comparator: function (service1, service2) {
                // lsd = Last Sync Date :)
                // "10.12.2012, 15:45" <-> "DD.MM.YYYY, H:m"
                var dateFormat = "DD.MM.YYYY, H:m";
                
                var lsd1 = +moment(service1.get("lastSyncDate"), dateFormat).valueOf(),
                    lsd2 = +moment(service2.get("lastSyncDate"), dateFormat).valueOf();
                
                return lsd2 - lsd1; // we have to have recently synced at the top, thus such sequence of operands 
            }}),
            this.get('services')
        );
        
        sortedServices.each(function(model) {
            serviceID = model.get('id');
        });
        
        return serviceID;
    },

    /**
     * Authorizes backup service that have 'default' value as true.
     * Sends user to authorization page
     */
    authorize: function() {
        var self = this;
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/auth.com.swisscom.stargate.cloud.authorization",
                method: "getServiceAuthUrl",
                parameters: {
                    data: JSON.stringify({
                        serviceId: self.getServiceID(),
                        domain: window.location.hostname
                    })
                }
            },

            success: function (response) {
                response = JSON.parse(response.status);
                if (response.status !== 200) {
                    var alertBox = $('<div/>', {
                        'class': 'modal cloud-error'
                    });
                    alertBox.html(response.error);
                    alertBox.modal('show');
                    alertBox.on('hidden', function() {
                        alertBox.remove();
                    });
                } else {
                    document.location.href = response.data.authUrl;
                }
            }
        });
    },

    /**
     * Check oauth credentials on access to cloud service
     */
    checkCredentials: function(){
        var self = this;
        
        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/auth.com.swisscom.stargate.cloud.authorization",
                method: "validateDefaultServiceCredentials",
                parameters: {}
            },
            
            success: function(response) {
                response = JSON.parse(response.status);
                if (response.status === 200) {
                    window.location.reload();
                } else {
                    self.authorize();
                }
            }
        });
    },
    
    validateFolder: function (partitionUUID, folderName) {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                service: "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                method: "validateSyncFolder",
                parameters: {
                    data: JSON.stringify({
                        partitionUUID: partitionUUID,
                        folderName: folderName
                    })
                }
            },

            success: function(response) {
                var status;

                // Check if AP has successfully started
                if (response && response.status) {
                    try {
                        status = JSON.parse(response.status);
                        if (status && status.success === true) {
                            deferred.resolve(status);
                            return;
                        }
                    } catch (e) {
                        // nothing to do
                    }
                }
                deferred.reject(status);
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    }
});
;swc.constructors.СloudServicesStatus = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup',
        method: 'cloudSyncEnabled',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @example { "status": "{\"data\":{\"isEnabled\":true},\"status\":200}" }
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                isEnabled: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.status === 200 && !_.isUndefined(parsedResponse.data)) {
                result.isEnabled = !_.isUndefined(parsedResponse.data.isEnabled) ? parsedResponse.data.isEnabled : false;
            }
        } catch (e) {}

        return result;
    }

});
;swc.constructors.MediaServices = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/dlna.com.swisscom.stargate.dlna',
        method: 'getMediaStreamingState',
        parameters: {}
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.status === 200) {
                result.status = parsedResponse.data.mediaStreamingEnabled;
            }
        } catch (e) {}

        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/dlna.com.swisscom.stargate.dlna",
            method: "setMediaStreamingState",
            parameters: {
                isEnabled: this.get('status')
            }
        });
    }

});
;swc.constructors.RemoteNASAccess = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas',
        method: 'GetEnabled',
        parameters: {}
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     * 
     * @example
     * <code>
     *     // in case of error:
     *     response = {"status": "{\"status\":\"ERROR\"}"} 
     *     // or in case of success:
     *     {"status": true }
     * </code>
     * 
     * @param response {Object}
     * 
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                "status": false
            },
            responseParsed;
        
        if (response) {
            // In case of Error we will receive json-encoded string
            if (_.isString(response.status)) {
                try {
                    responseParsed = JSON.parse(response.status);
                    if (_.isObject(responseParsed)) {
                        result = responseParsed;
                    }
                } catch (e) {
                    // do nothing
                }
            } else {
                result = response;
            }
            
        } else {
            // otherwise, just set error
            result['status'] = "ERROR";
        }
        
        return result;
    },

    toJSON: function() {
        return JSON.stringify({
            service: "com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas",
            method: "SetEnabled",
            parameters: {
                enable: this.get('status')
            }
        });
    },
    
    isEnabled: function() {
        return this.get('status') === true;
    }
});
;swc.constructors.RemoteNASAccount = swc.BaseModel.extend({

    url: {
        'delete': '/ws'
    },

    toJSON: function() {
        return JSON.stringify({
            service: 'com.vestiacom.rnas/com/vestiacom/rnas.com.vestiacom.rnas',
            method: 'CancelPairing',
            parameters: {
                'E-mail address': this.get('email')
            }
        });
    }

});
;swc.constructors.UsbStatus = swc.BaseModel.extend({

    url: '/ws',

    ajaxParameters: JSON.stringify({
        service: 'com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices',
        method: 'getUsbMode',
        parameters: JSON.stringify({})
    }),

    /**
     * Using try {} catch {}, because if AP is disabled, it will return not valid json
     *
     * @description
     *
     *  AP returns following response: { "status": { "data": { "mode" : 3 || 2 }, "status": 200 }}, where mode is current
     *  USB mode. Can be 2 or 3.
     *
     * @param response {Object}
     * @returns {Object}
     */
    apiToJSON: function(response) {
        var result = {
                status: false
            },
            parsedResponse;

        try {
            parsedResponse = JSON.parse(response.status);

            if (parsedResponse.data.mode) {
                result.status = parsedResponse.data.mode === 3;
            }
        } catch (e) {}

        return result;
    },

    /**
     * @description:
     *
     *  To enable usb 3.0 or 2.0, it's needed to send 3 or 2 as current mode parameter:
     *
     * @returns {*}
     */
    toJSON: function() {
        return JSON.stringify({
            service: "com.swisscom.stargate/ws/nas/devices.com.swisscom.stargate.nas.devices",
            method: "setUsbMode",
            parameters: {
                mode: this.get('status') === true ? 3 : 2
            }
        });
    }

});
;swc.constructors.Screen = Backbone.Model.extend({

    sync: function(fromListener) {
        var self = this,
            deferred = new $.Deferred();

        $.when(
                self.getParameters(fromListener)
            ).done(function(){
                deferred.resolve();
            });

        return deferred.promise();
    },


    getLanguage: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getLanguage',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('lang', response.status || 'EN');

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getBrightTime: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getBrightTime',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('brightTime', response.status || 60);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getShowPassword: function(fromListener) {
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:getShowWifiPassword',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('showPass', response.status || false);

                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setLanguage: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setLanguage',
            data: {
                "parameters":{
                    "language" : self.get('lang')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setBrightTime: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setBrightTime',
            data: {
                "parameters":{
                    "time" : self.get('brightTime')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    setShowPassword: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/Screen:setShowWifiPassword',
            data: {
                "parameters":{
                    "enable" : self.get('showPass')
                }
            },

            success: function(response) {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    getParameters: function(fromListener){
        var self = this, deferred = new $.Deferred();

        $.when(self.getBrightTime(fromListener), self.getLanguage(fromListener), self.getShowPassword(fromListener)).done(function(){
            deferred.resolve();
        });

        return deferred.promise();
    },

    setParameters: function(){
        var self = this, deferred = new $.Deferred();

        $.when(self.setBrightTime(), self.setLanguage(), self.setShowPassword()).done(function(){
            deferred.resolve();
        });

        return deferred.promise();
    }
});

;swc.constructors.System = Backbone.Model.extend({

    adminName: "admin",

    groups: [
        "http",
        "admin"
    ],

    minExpectedRebootTime: 160000, // 2 minutes 40 seconds
    maxExpectedRebootTime: 240000, // 4 minutes

    sync: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        // As there are no request in the $.when() function which checks
        // session state the checkSessionState() method should wrap them
        self.checkSessionState(function() {
            $.when(self.identifyGateway(fromListener), self.getFirmware(fromListener))
                .done(function () {
                    deferred.resolve();
                });
        });

        return deferred.promise();
    },

    /**
     * Calculates quantity of days, hours and minutes from provided seconds
     * This method used to display smth. like "up" time, or "connected for" time
     *
     * @param seconds
     *
     * @returns {Object} {d - days, h - hours, m - minutes}
     */
    makeUpTime: function(seconds){
        var timeObj = {},
            leftForHours = seconds % 86400,
            leftForMinutes = leftForHours % 3600;

        timeObj.d = Math.floor(seconds / 86400);
        timeObj.h = Math.floor(leftForHours / 3600);
        timeObj.m = Math.floor(leftForMinutes / 60);

        return timeObj;
    },

    identifyGateway: function(fromListener){
        var self = this,
            deferred = new $.Deferred();
        
        swc.models.Rest.sendRequest({
            url: '/sysbus/DeviceInfo:get',
            data: {
                parameters: {}
            },
            fromListener: fromListener,

            success: function(response) {
                var data = response['status'];

                if (!data) {
                    return;
                }

                self.set({
                    'manufacturer': data.Manufacturer,
                    'NPVersion': data.SoftwareVersion,
                    'externalIP': data.ExternalIPAddress,
                    'upTime': self.makeUpTime(data.UpTime),
                    'serialNumber': data.SerialNumber,
                    'model': data.ModelName
                });
                
                deferred.resolve();
            },

            error: function() {
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    rebootGateway: function(timeout){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:reboot',
            data: {"parameters":{}},
            success: function(response) {
                deferred.resolve();
                setTimeout(function(){
                    if (swc.models.apServiceState.isEnabled()) {
                        self.whenApUp(self.doLogout);
                    } else {
                        self.whenDeviceUp(self.doLogout);
                    }
                }, timeout || self.minExpectedRebootTime);
            },
            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    resetGateway: function(timeout){
        var self = this,
            deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC:reset',
            method: 'POST',
            formatRule: 'jsonType',
            contentType: 'application/x-sah-ws-4-call+json',
            data: {"parameters":{}},

            success: function(response) {
                if(!response.status){
                    deferred.reject();
                } else {
                    deferred.resolve();
                    setTimeout(function () {
                        if (swc.models.apServiceState.isEnabled()) {
                            self.whenApUp(self.doReset);
                        } else {
                            self.whenDeviceUp(self.doReset);
                        }
                    }, timeout || self.minExpectedRebootTime);
                }
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    whenDeviceUp: function (callback) {
        var self = this;

        if (self.rebootCheckInterval) {
            return;
        }
        this.checkInProcess = false;

        this.doCheckDeviceUp(callback);
        this.rebootCheckInterval = setInterval(function () {
            self.doCheckDeviceUp(callback);
        }, 5000);
    },

    doCheckDeviceUp: function (callback) {
        var self = this;

        if (this.checkInProcess) {
            return;
        }
        this.checkInProcess = true;

        $.ajax({
            url: '/sysbus/DeviceInfo:get',
            type: 'post',
            data: {"parameters":{}},
            timeout: 5000,

            success: function (response) {
                var data = response['status'];
                if (data && data.DeviceStatus === 'Up') {
                    clearInterval(self.rebootCheckInterval);
                    self.rebootCheckInterval = null;
                    self.trigger('device:up');
                    callback();
                }
            },

            complete: function () {
                self.checkInProcess = false;
            }
        });
    },

    whenApUp: function (callback) {
        var self = this;

        if (self.rebootCheckInterval) {
            return;
        }
        this.checkInProcess = false;

        this.doCheckApUp(callback);
        this.rebootCheckInterval = setInterval(function () {
            self.doCheckApUp(callback);
        }, 5000);
    },

    /**
     * Polls NP and check if AP is "Up" and running.
     * Calls callback if AP is "Up"
     *
     * @param callback
     */
    doCheckApUp: function (callback) {
        var self = this;

        if (this.checkInProcess) {
            return;
        }

        this.checkInProcess = true;

        $.when(swc.models.apServiceLoadingState.fetch())
            .done(function(){
                if (swc.models.apServiceLoadingState.isApStarted()) {
                    clearInterval(self.rebootCheckInterval);
                    self.rebootCheckInterval = null;
                    self.trigger('ap:up'); // maybe we will need it? Copied from whenDeviceUp(), not sure if needed.
                    callback();
                }
            })
            .fail(function() {
                // TODO: What?
            })
            .always(function(){
                self.checkInProcess = false;
            });
    },

    doLogout: function() {
        swc.models.Login.processLogout({ 'redirectUrl': swc.settings.application.get("url"), action: 'reset-logout' });
    },

    doReset: function() {
        // clean local storage with saved language
        localStorage.removeItem('locale');
        swc.models.Login.processLogout({ 'redirectUrl': swc.settings.application.get("url"), action: 'reset-logout' });
    },

    upgradeGateway: function(formdata){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/webuiUpgrade',
            timeout: 360000,
            contentType: false,
            processData: false,
            data: formdata,
            headers: {
                "X-Context": $.cookie(getDeviceID() + '/context')
            },

            success: function(response) {
                var resp = $(response).text();
                if(resp.indexOf('200') >= 0){
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },

            error: function(){
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    getLogs: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',
            data: {
                "service":"com.swisscom.stargate/ws/system.com.swisscom.stargate.system",
                "method":"getLogsURL",
                "parameters": {}
            },

            success: function(response) {
                deferred.resolve();
                var data = JSON.parse(response.status);
                document.location.href = data.data.url;
            }
        });

        return deferred.promise();
    },

    getFirmware: function(fromListener){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            fromListener: fromListener,
            data: {
                "service":"com.swisscom.stargate/ws/system.com.swisscom.stargate.system",
                "method":"getFirmwareVersion",
                "parameters": {}
            },

            success: function(response) {
                if(response.status[0] === "{"){
                    var data = JSON.parse(response.status);
                    self.set('APVersion', data.data.firmwareVersion);
                } else {
                    self.set('APVersion', false);
                }

                deferred.resolve();
            },

            error: function(response) {
                self.set('APVersion', false);
                deferred.resolve();
            }
        });

        return deferred.promise();
    },

    checkPassword: function(password){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/UserManagement:authenticate',
            method: 'POST',
            contentType: 'application/x-sah-ws-1-call+json',
            data: {
                "parameters": {
                    "name": self.adminName,
                    "password": password,
                    "groups": self.groups
                }
            },

            success: function(response) {
                deferred.resolve(response.result.status);
            }
        });

        return deferred.promise();

    },

    configBackup: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/backup?nocache',
            method: 'GET',

            success: function() {
                deferred.resolve();
            }
        });

        return deferred.promise();

    },

    configBackupACS: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/NMC/NetworkConfig:launchNetworkBackup',

            data: {
                "parameters": {}
            },

            success: function() {
                deferred.resolve();
            },

            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Updates the session cookies from the server.
     * Is used to check if the session is still valid at the server side.
     * Calls callback function in case of success.
     * Initiates client logout in case of fail.
     *
     * @param callback
     *
     * @returns void
     */
    checkSessionState: function(callback) {
        swc.models.Rest.sendRequest({
            url: '/sysbus/Time:getTime',
            fromListener: true,
            timeout: 1000,

            data: {
                "parameters": {}
            },

            success: function(response) {
                swc.models.Login.checkAccessToDevice(response);
                if (swc.models.Login.checkUserLogin() && _.isFunction(callback)) {
                    callback();
                }
            },

            error: function(xhr) {
                swc.models.Login.checkAccessToDevice(xhr);
            }
        });
    }
});

;swc.constructors.PhonebookContact = swc.BaseModel.extend({

    url: {
        // keys quoted uniformly, but the reason is 'delete'
        // because IE thinks it's a key word
        'create': '/sysbus/Phonebook:addContactAndGenUUID',
        'update': '/sysbus/Phonebook:modifyContactByUniqueID',
        'delete': '/sysbus/Phonebook:removeContactByUniqueID'
    },

    phoneSet: ['HOME', 'CELL', 'WORK'],

    defaults: function() {
        var telephoneNumbers = [];

        _.each(this.phoneSet, function(phoneType) {
            telephoneNumbers.push({
                "type": phoneType,
                "preferred": false,
                "name": ''
            });
        });

        return {
            "firstName": '',
            "lastName": '',
            "formattedName": '',
            "telephoneNumbers": telephoneNumbers
        };
    },

    toJSON: function() {
        var json;

        var rawNumbers = this.get("telephoneNumbers"),
            telephoneNumbers = [
                _.where(rawNumbers, {'type': 'HOME'})[0],
                _.where(rawNumbers, {'type': 'CELL'})[0],
                _.where(rawNumbers, {'type': 'WORK'})[0]
            ];

        telephoneNumbers = _.compact(telephoneNumbers);

        _.each(telephoneNumbers, function(number){
            delete number.key;
        });

        json = {
            parameters: {
                uniqueID: this.get('id'),
                contact: {
                    name: this.getSerializedName(),
                    formattedName: this.getFormattedName(),
                    key: this.get('key'),
                    telephoneNumbers: telephoneNumbers
                }
            }
        };

        return JSON.stringify(json);
    },

    /**
     * formattedName - name that you see on phonebook.
     *
     * @example
     *      "formattedName": "Teste Mr",
     */
    getFormattedName: function() {
        return this.get('lastName') + ' ' + this.get('firstName');
    },

    /**
     * name - contact name in special format "N:"+ last name + ";" + first name.
     *
     * @example
     *      "name": "N:Mr;Teste;",
     */
    getSerializedName: function() {
        return 'N:' + this.get('lastName') + ';' + this.get('firstName');
    }

});
;swc.constructors.Telephony = Backbone.Model.extend({

    dectInternalNumbers: [ 203, 204, 205, 206, 207, 208, 209 ],

    sync: function(fromListener){
        var self = this,
            deferred = new $.Deferred();

        $.when(
                self.getPin(fromListener),
                self.getPhones(fromListener),
                self.getDectStatus(fromListener),
                self.getDectEco(fromListener)
            ).done(function(){
                self.trigger('change');
                deferred.resolve();
            });

        return deferred.promise();
    },

    initialize: function(){
        var self = this,
            PhonesCollectionConstructor = Backbone.Collection.extend({
                comparator: function(model){
                    return model.id;
                }
            }),
            phonesCollection = new PhonesCollectionConstructor(),
            groupsCollection = new Backbone.Collection();

        this.set('groups', groupsCollection);
        this.set('phones', phonesCollection);
        this.get('phones').on('change:externalNumber', function(model, values, options){
            if(!options || (options && !options.notProceed)){
                var newNumber = model.get('externalNumber');
                var numberFound = false;
                self.get('voip').each(function(voipModel){
                    if(voipModel.get('directoryNumber') === newNumber){
                        numberFound = true;
                        model.set({'outgoingTrunkLine': voipModel.id}, {notProceed: true});
                    }
                });
                if(!numberFound){
                    model.set({'externalNumber': self.get('voip').get(model.get('outgoingTrunkLine')).get('directoryNumber')}, {notProceed: true});
                }
            }

        });

        this.get('phones').on('change:outgoingTrunkLine', function(model, values, options){
            if(!options || (options && !options.notProceed)){
                model.set({'externalNumber': self.get('voip').get(model.get('outgoingTrunkLine')).get('directoryNumber')}, {notProceed: true});
            }
        });

        this.get('phones').on('change:incomingLines', function(model, values, options){
            var activeLines = self.get('voip').where({'enable': 'Enabled'});

            _.each(activeLines, function(line){
                var lineGroup = self.get('groups').get(line.get('groupId')),
                    devices = lineGroup.get('ep_names'),
                    deviceOptions = _.where(values, {'line': line.id})[0],
                    changed = false;

                if(deviceOptions.value){
                    if(!_.contains(devices, model.id)){
                        devices.push(model.id);
                        changed = true;
                    }
                } else {
                    if(_.contains(devices, model.id)){
                        devices = _.without(devices, model.id);
                        changed = true;
                    }
                }

                if(changed){
                    lineGroup.set({'ep_names': devices, 'changed': true});
                }
            });
        });
    },

    validation: {

        dectPin: function(data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'dectPin' : { elementName: 'pin', elementClass: 'pin-original' }
                }, data);

            if ($.trim(validationData['dectPin']).length < 4) {
                validationMessages.push('must contain 4 symbols');
            }

            if (!/^[\d]*$/.test(validationData['dectPin'])) {
                validationMessages.push('must contain 4 digits from 0 to 9');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        dectName: function(data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'dectName' : { elementName: 'dect-name-editable' }
                }, data);

            if (_.isEmpty($.trim(validationData['dectName']))) {
                validationMessages.push('must not be empty');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        },

        internalNumber: function(data) {
            var validationMessages = [],
                validationData = swc.Utils.getDataToValidate({
                    'internalNumber' : { elementName: 'internal-number-editable' }
                }, data);

            if (_.isUndefined(swc.models.Telephony)) {
                return {
                    status: _.isEmpty(validationMessages),
                    messages: validationMessages
                };
            }

            var phones = swc.models.Telephony.get('phones'),
            // get integer array of used phone numbers
                usedInternalNumbers = _.map(phones.pluck('directoryNumber'), function(v) { return +v; }),
            // get integer array of similar phone numbers
                similarValues = _.filter(usedInternalNumbers, function(v) { return v === validationData['internalNumber']; });

            // if the length of similar phone numbers > 1 then error should be shown
            if (similarValues.length > 1) {
                validationMessages.push('number already is used');
            }

            return {
                status: _.isEmpty(validationMessages),
                messages: validationMessages
            };
        }
    },

    /**
     * Get voip status
     * @returns json
     * {
     *  "status":[
     *      {
     *          "name":"SIP-Trunk",
     *          "signalingProtocol":"SIP",
     *          "enable":"Disabled",
     *          "trunk_lines":[
     *              {
     *                  "name":"LINE1",
     *                  "groupId":"Group1",
     *                  "enable":"Disabled",
     *                  "status":"Disabled",
     *                  "statusInfo":"",
     *                  "directoryNumber":"",
     *                  "uri":"",
     *                  "authUserName":"",
     *                  "authPassword":"",
     *                  "event_subscribe_lines":[
     *                      {
     *                          "eventSubscribeEvent":"message-summary",
     *                          "eventSubscribeAuthUserName":"",
     *                          "eventSubscribeAuthPassword":""
     *                      }
     *                  ]
     *              },
     *              {
     *                  "name":"LINE2",
     *                  "groupId":"Group2",
     *                  "enable":"Disabled",
     *                  "status":"Disabled",
     *                  "statusInfo":"",
     *                  "directoryNumber":"",
     *                  "uri":"",
     *                  "authUserName":"",
     *                  "authPassword":"",
     *                  "event_subscribe_lines":[
     *                      {
     *                          "eventSubscribeEvent":"message-summary",
     *                          "eventSubscribeAuthUserName":"",
     *                          "eventSubscribeAuthPassword":""
     *                      }
     *                  ]
     *              }
     *          ],
     *          "sip":{
     *              "proxyServer":"imst.swisscom.ch",
     *              "proxyServerPort":5060,
     *              "registrarServer":"imst.swisscom.ch",
     *              "registrarServerPort":5060,
     *              "outboundProxyServer":"",
     *              "outboundProxyServerPort":5060,
     *              "userAgentDomain":"imst.swisscom.ch",
     *              "userAgentPort":5060,
     *              "subscriptionInfo":[
     *                  {
     *                      "event":"message-summary",
     *                      "notifyServer":"",
     *                      "notifyServerPort":5060
     *                  }
     *              ]
     *          },
     *          "h323":{}
     *      },
     *      {
     *          "name":"H323-Trunk",
     *          "signalingProtocol":"H.323",
     *          "enable":"Disabled",
     *          "trunk_lines":[
     *              {
     *                  "name":"LINE3",
     *                  "groupId":"Group3",
     *                  "enable":"Disabled",
     *                  "status":"Disabled",
     *                  "statusInfo":"",
     *                  "directoryNumber":"1011",
     *                  "uri":"",
     *                  "authUserName":"",
     *                  "authPassword":"",
     *                  "event_subscribe_lines":[]
     *              }
     *          ],
     *          "sip":{},
     *          "h323":{
     *              "gatekeeper":"172.16.1.1",
     *              "gatekeeperPort":1719
     *          }
     *      }
     *  ]}
     */
    getVoipStatus: function(fromListener){
        var self = this, deferred = new $.Deferred();
        swc.models.Rest.sendRequest({
            url: '/sysbus/VoiceService/VoiceApplication:listTrunks',
            fromListener: fromListener,
            data: {
                "parameters": {}
            },

            success: function(response) {
                var swisscomSip = _.where(response.status, {signalingProtocol: "SIP"})[0],
                    Lines = Backbone.Collection,
                    lines = new Lines(),
                    voipActivated;

                // NOTE: we do not take global SIP status - swisscomSip.enable. We take it from the lines status

                if (swisscomSip) {
                    _.each(swisscomSip.trunk_lines, function(line){
                        var sipLine = new Backbone.Model();
                        sipLine.set({
                            id: line.name,
                            directoryNumber: line.directoryNumber,
                            enable: line.enable,
                            groupId: line.groupId,
                            name: line.name,
                            status: line.status,
                            statusInfo: line.statusInfo,
                            uri: line.uri
                        });

                        if(sipLine.get('enable') === 'Enabled'){
                            lines.add(sipLine);
                        }
                    });
                }

                // Check if lines collection is not empty
                voipActivated = (lines.length > 0);

                // voipStatus means that at least one line is activated
                self.set({
                    'voip': lines,
                    "voipStatus": voipActivated
                });

                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Get groups.
     * Used for incoming numbers - Calls to related lines(LINE1 is related to Group1) will redirect to devices listed in "ep_names" array
     * @returns {*}
     *
     * @example
     * {"status":[
     *      {
     *          "group_id":"Group1",           – Group name, related to line name. Group1 = LINE1 etc...
     *          "ep_names":["FXS1","FXS2"]     – List of devices in group
     *      },{
     *          "group_id":"Group2",
     *          "ep_names":["FXS2"]
     *      }
     * ]}
     */
    getGroups: function(fromListener){
        var self = this, deferred = new $.Deferred();
        swc.models.Rest.sendRequest({
            url: '/sysbus/VoiceService/VoiceApplication:listGroups',
            fromListener: fromListener,
            data: {
                "parameters": {}
            },

            success: function(response) {
                var groupCol = [];
                _.each(response.status, function(group){
                    var model = {
                        id: group.group_id,
                        ep_names: group.ep_names,
                        changed: false
                    };
                    groupCol.push(model);
                });
                self.get('groups').reset(groupCol);
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setGroups: function(){
        var self = this, deferred = new $.Deferred(), groupArray = [];

        self.get('groups').each(function(model){
            if(model.get('changed')){
                var obj = {
                    "group_id": model.id,
                    "ep_names": model.get('ep_names')
                };
                groupArray.push(obj);
            }
        });

        swc.models.Rest.sendRequest({
            url: '/sysbus/VoiceService/VoiceApplication:setGroups',
            data: {
                "parameters": {
                    "groups": groupArray

                }
            },

            success: function(response) {
                deferred.resolve();
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Get voip lines
     * @returns json
     * {
     *      "status":[
     *          {
     *              "line":"FXS1",
     *              "name":"FXS1",
     *              "enable":"Enabled",
     *              "directoryNumber":"201",
     *              "endpointType":"FXS",
     *              "outgoingTrunkLine":"LINE1"
     *          },
     *          {
     *              "line":"HS0106EA54BB",
     *              "name":"HS0106EA54BB",
     *              "enable":"Enabled",
     *              "directoryNumber":"204",
     *              "endpointType":"DECT GAP",
     *              "outgoingTrunkLine":"LINE1"
     *          },
     *          {
     *              "line":"HS024270E3C1",
     *              "name":"HS024270E3C1",
     *              "enable":"Enabled",
     *              "directoryNumber":"205",
     *              "endpointType":"DECT CAT-iq 1.0",
     *              "outgoingTrunkLine":"LINE1"
     *          },
     *          {
     *              "line":"Account311",
     *              "name":"Account311",
     *              "enable":"Disabled",
     *              "directoryNumber":"311",
     *              "endpointType":"SIP",
     *              "outgoingTrunkLine":"LINE1"
     *          }
     *      ]
     *  }
     */
    getPhones: function(fromListener){
        var self = this, deferred = new $.Deferred();

        function getLines(){
            var deferred = new $.Deferred(),
                activeLines = self.get('voip');

            swc.models.Rest.sendRequest({
                url: '/sysbus/VoiceService/VoiceApplication:listHandsets',
                fromListener: fromListener,
                data: {
                    "parameters": {}
                },

                success: function(response) {
                    var lines = [];

                    _.each(response.status, function(obj){
                        if(obj.endpointType.indexOf('DECT')>=0 || obj.endpointType === "FXS"){
                            var line = new Backbone.Model(), deviceId = obj.line, incomingLines = [], deviceType = 'dect';

                            activeLines.each(function(line){
                                var key = line.id, value = false;
                                var lineGroup = self.get('groups').get(line.get('groupId'));
                                if(lineGroup){
                                    if(_.contains(lineGroup.get('ep_names'), deviceId)){
                                        value = true;
                                    }
                                    incomingLines.push({'line': key, 'number': line.get('directoryNumber'), 'value': value});
                                } else {
                                    /*
                                     If groupId in lines and groupId in groups are not the same, the gateway setup is wrong. So we will show this modal window
                                     */
                                    if(!$.cookie('noGroups')){
                                        $.cookie('noGroups', true);
                                        new swc.constructors.NoGroupsModal();
                                    }
                                }

                            });

                            if(obj.endpointType === "FXS"){
                                deviceType = 'wired';
                            }

                            line.set({
                                id: deviceId,
                                line: deviceId,
                                deviceType: deviceType,
                                name: obj.name,
                                enable: (obj.enable === "Enabled"),
                                directoryNumber: obj.directoryNumber,
                                externalNumber: self.get('voip').get(obj.outgoingTrunkLine) ? self.get('voip').get(obj.outgoingTrunkLine).get('directoryNumber') : "",
                                incomingLines: incomingLines,
                                type: 'DECT',
                                outgoingTrunkLine: obj.outgoingTrunkLine,
                                is_changed: false
                            });



                            lines.push(line);
                        }
                    });

                    self.get('phones').reset(lines);
                    deferred.resolve();
                },
                error: function() {
                    deferred.reject();
                }
            });

            return deferred.promise();
        }

        $.when(self.getVoipStatus(fromListener), self.getGroups(fromListener)).done(function(){
            $.when(getLines(fromListener)).done(function(){
                deferred.resolve();
            });
        });

        return deferred.promise();
    },

    ringPhone: function(phone){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/VoiceService/VoiceApplication:ring',
            method: 'POST',
            contentType: 'application/x-sah-ws-4-call+json',

            data: {
                "parameters": {
                    "PhoneToUse":phone,
                    "Duration":10000,
                    "Ringtone":""
                }
            },

            success: function(response) {
                // TODO: put this error handler in the common place
                // in this case response can be successful and
                // contain error message. That is why it should be
                //  checked on it here
                if (_.isUndefined(response.errors)) {
                    setTimeout(function() { deferred.resolve(); }, 1000);
                } else {
                    deferred.reject();
                }
            },

            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    startPairing: function(){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:startPairing',

            data: {
                "parameters": {
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    stopPairing: function() {
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:stopPairing',

            data: {
                "parameters": {
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    unpairDect: function(id){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/VoiceService/VoiceApplication:deleteHandset',
            data: {
                "parameters": {
                    "line": id
                }
            },

            success: function(response) {
                deferred.resolve(response);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    /**
     * Get PIN for device pairing
     * @returns json
     * {"status":"0000"}
     */

    getPin: function(fromListener){
        var self = this, deferred = new $.Deferred();
        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:getPIN',
            fromListener: fromListener,

            data: {
                "parameters": {
                }
            },

            success: function(response) {
                self.set('dectPIN', response.status);
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setPin: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:setPIN',
            data: {
                "parameters": {
                    "pin": self.get('dectPIN')
                }
            },

            success: function(response) {
                setTimeout(function(){
                    deferred.resolve();
                }, 1000);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    phoneEdit: function(){

        var self = this, deferred = new $.Deferred(),
            changedModels = this.get('phones').filter(function(model){
                return model.get('is_changed');
            });

        var editsArray = [];

        if(changedModels.length === 0){
            deferred.resolve();
        }

        _.each(changedModels, function(model) {
            var editRequest = function() {
                var deferred = new $.Deferred(),
                    extNumber = "" + model.get('externalNumber'),
                    incomingLines = model.get('incomingLines'),
                    lines = _.where(incomingLines, {number: extNumber}),
                    outgoingTrunkLine = !_.isEmpty(lines) ? lines[0].line : model.get('outgoingTrunkLine');

                swc.models.Rest.sendRequest({
                    url: '/sysbus/VoiceService/VoiceApplication:setHandset',
                    data: {
                        "parameters": {
                            "line": {
                                "line": model.get('line'),
                                "directoryNumber": model.get('directoryNumber'),
                                "outgoingTrunkLine": outgoingTrunkLine,
                                "name": model.get('name')
                            }
                        }
                    },

                    success: function(response) {
                        deferred.resolve();
                    },
                    error: function() {
                        deferred.reject();
                    }
                });

                return deferred.promise();
            };

            editsArray.push(editRequest());
        });

        $.when.apply(this, editsArray).done(function(){
            $.when(self.setGroups()).done(function(){
                setTimeout(function(){ deferred.resolve(); }, 2000);
            });
        });

        return deferred.promise();
    },

    dectReset: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:reset',
            data: {
                "parameters": {
                }
            },

            success: function(response) {
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    dectRemoveDects: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:removeAllHandsets',
            data: {
                "parameters": {
                }
            },

            success: function(response) {
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setDectStatus: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:setBaseState',
            data: {
                "parameters": {
                    "state": self.get('dectStatus')
                }
            },

            success: function(response) {
                // Give DECT a little time to turn on
                setTimeout(function(){
                    deferred.resolve();
                }, self.get('dectStatus')?2000:1);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getDectStatus: function(fromListener){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:getBaseState',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('dectStatus', response.status);
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();
    },

    setDectEco: function(){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:setNEMoState',
            data: {
                "parameters": {
                    "state": self.get('dectEco')
                }
            },

            success: function(response) {
                setTimeout(function(){
                    deferred.resolve();
                }, 1500);
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getDectEco: function(fromListener){
        var self = this, deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/sysbus/DECT:getNEMoState',
            fromListener: fromListener,

            data: {
                "parameters": {}
            },

            success: function(response) {
                self.set('dectEco', response.status);
                deferred.resolve();
            },
            error: function() {
                deferred.reject();
            }
        });

        return deferred.promise();

    },

    getPhonesList: function() {
        var dectPhonesArray = [],
            wiredPhonesArray = [],
            self = this;

        this.get('phones').each(function(model, index) {
            var obj = {
                key: index+1,
                id: model.id,
                isDisabled: !model.get('enable'),
                name: model.get('name'),
                internalNumber: model.get('directoryNumber'),
                externalNumber: model.get('externalNumber'),
                incomingLines: model.get('incomingLines')
            };

            if (model.get('deviceType') === "dect") {
                dectPhonesArray.push(obj);
            } else {
                wiredPhonesArray.push(obj);
            }

            dectPhonesArray.sort(function (a, b) {
                if (b.internalNumber < a.internalNumber) {
                    return 1;
                }

                return -1;
            });
        });

        return {
            dect: dectPhonesArray,
            cord: wiredPhonesArray
        };
    }
});

;swc.constructors.ApplicationView = swc.base.PageView.extend({

    /**
     * Current view class name:
     */
    className: 'application',

    hasChanges: false,

    /**
     * Events listener setup
     */
    events: {
        'click .logout': 'logout',

        'swc-dropdown:change .locale-selector': 'setLocale',

        'swc-radio-buttons:change #user-mode-switcher': 'switchUserMode'
    },

    /**
     * Initialise function has to be overrided from the base page view because of routing address missmatch
     */
    initialize: function() {
        this.template = $.template('loading', swc.Templates.get(this.className).get('content'));
    },

    /**
     * Render function has to be overrided from the base page view because of it's specific
     */
    render: function() {},

    /**
     * Render main application area:
     */
    renderApplicationArea: function() {
        var self = this,
            userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            userSuperAdmin = swc.models.Login.checkUserSuperAdmin(),
            localesOptions = swc.models.Locale.getLocaleOptions();

        // Set content to application page:
        $('#application').html($(this.el).html(
            $.tmpl(self.template, {
                jenkins: swc.settings.application.get('jenkins') || {},
                localeStrings: swc.models.Locale.getLocaleStrings('application'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks(),
                GlobalEnable: swc.models.Application.get('GlobalEnable')
            }))
        );

        // Set locale selector values:
        $('.locale-selector').data('options', localesOptions);
        $('.locale-selector').trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        // Define content area
        this.contentArea = $("#current-page");

        // Check if user mode was selected in cookies
        if (localStorage.userMode) {
            userModeType = localStorage.userMode;

            if (localStorage.userMode === 'expert') {
                swc.settings.application.set('expertMode', true);
            } else {
                swc.settings.application.set('expertMode', false);
            }
        }

        // Set expert / standart mode to body:
        if (userModeType === 'standard') {
            $('body').removeClass('expert-mode-only').addClass('standard-mode');
        } else {
            $('body').addClass('expert-mode-only').removeClass('standard-mode');
        }

        // Add supper admin class to body to handle some features with CSS styles:
        $('body').toggleClass('superAdmin', userSuperAdmin);

        // Trigger mode switcher change
        $('#user-mode-switcher').trigger('swc-radio-buttons:swc-change', userModeType);

        this.delegateEvents();
    },

    /**
     * Update application mode basing on cookie values:
     */
    setApplicationMode: function() {
        var userModeType = swc.settings.application.get('expertMode') ? 'expert' : 'standard',
            body = $('body');

        // Define user mode type
        if (userModeType === "expert") {
            body.addClass('expert-mode-only').removeClass('standard-mode');
        } else {
            body.removeClass('expert-mode-only').addClass('standard-mode');
        }
    },

    /**
     * Update menu links when navigating to the page:
     */
    setMenuActiveLink: function() {
        var page = Backbone.history.fragment.split('/'),
            baseLink = $(this.el).find('li.menu-' + page[0]),
            tabGroup, tabLink, tabLinkBefore, tabLinkAfter,
            hasSubMenu = baseLink.find('ul').size(),
            subMenuLink;

        // Set active state of link:
        baseLink.addClass('active').siblings().removeClass('active');
        baseLink.siblings().find('ul').hide();

        // Show submenu links if they are existing
        if (hasSubMenu) {
            baseLink.find('ul').show();
        }

        // Check if routing lvl more then 1:
        if (page.length > 1) {
            subMenuLink = baseLink.find('li.page-' + page[1]);

            // Set active state of submenu links
            subMenuLink.siblings().find('a').removeClass('active');
            subMenuLink.find('a').addClass('active');
        }

        // Check if routing lvl more then 2:
        if (page.length > 2) {
            tabGroup = $(this.el).find('.page-tabs');

            if (tabGroup.size()) {
                tabLink = tabGroup.find('li.tab-' + page[2]);
                tabLinkBefore = tabLink.prev();
                tabLinkAfter = tabLink.next();

                // Set tab state active
                tabLink.addClass('active no-bg').siblings().removeClass('active no-bg');

                if (tabLinkBefore.size()) {
                    tabLinkBefore.addClass('no-bg before');
                }

                if (tabLinkAfter.size()) {
                    tabLinkAfter.addClass('after');
                }
            }
        }
    },

    /**
     * User experience mode switcher
     *
     * @param e {Object}
     *
     */
    switchUserMode: function(e, value) {
        if (value === 'standard') {
            swc.settings.application.set('expertMode', false);

            $('body').removeClass('expert-mode-only').addClass('standard-mode');
        } else {
            swc.settings.application.set('expertMode', true);

            $('body').addClass('expert-mode-only').removeClass('standard-mode');
        }

        localStorage.userMode = value;

        this.checkPermissions(true);
    },

    /**
     * Update application locale based on dropdown value
     */
    setLocale: function(e, value) {
        var self = this;

        $.when(swc.models.Locale.setLocale(value)).done(function() {
            // Clear application content:
            $('#application').html('');

            // Show loading window:
            self.showPageLoading('Loading locale strings');

            // Re-render application
            swc.router.navigate(Backbone.history.fragment);
        });
    },

    /**
     * Logout from application
     */
    logout: function() {
        swc.models.Login.processLogout({ action: 'user-logout' });
    }
});
;swc.constructors.StorageDevicesView =  swc.base.PageView.extend({

    className: 'storage-devices-list',

    listenerInterval: 5,

    listenerEnabled: true,

    listenerPages: [ 'storage-devices' ],

    models: [ 'apServiceState', 'apServiceLoadingState', 'StorageDevices', 'Schedulers', 'System' ],

    /**
     * Defines which item is expanded at the current moment
     */
    openedItem: null,

    events: {
        'swc-switcher:change .set-ap-state': 'setApState',
        'click .remove-storage': 'unmountDevice',
        'expandable:open .expandable-list': 'onExpandableOpen',
        'expandable:close .expandable-list': 'onExpandableClose'
    },

    setTemplateData: function() {
        var self = this,
            storageDevicesArray = [],
            apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = !_.isUndefined(apScheduler) ? apScheduler.get('enabled') : false;

        swc.models.StorageDevices.each(function(model, index) {
            var deviceObj = {
                id: model.id,
                label: model.get('label'),
                type: model.get('type'),
                capacity: model.get('capacity'),
                freeSpace: model.get('freeSpace')
            };

            storageDevicesArray.push(deviceObj);
        });

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            schedulerState: apSchedulerState,
            devices: storageDevicesArray
        };
    },

    renderComplete: function() {
        this.updatePageUI();
        this.openExpandableItem();
    },

    onListenerComplete: function() {
        this.setTemplateData();
        this.getTemplateContent();
//        this.displayPage();

        this.updatePageUI();
        this.openExpandableItem();
//        this.stopPageLoading();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);

            // Start listener if page is disabled or loading:
            this.listenerEnabled = true;
            this.startListener();
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this;

        this.stopListener();
        this.listenerEnabled = true;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        $.when(swc.models.apServiceState.sync('update')).done(function() {
            self.startListener();
        });
    },

    unmountDevice: function(e) {
        var self = this,
            element = $(e.target),
            deviceId = element.closest('.expandable-list-item').data('key'),
            deviceName = swc.models.StorageDevices.get(deviceId).get('label');

        // as unmount request themselves doesn't check session state
        // the checkSessionState() method should wrap it
        swc.models.System.checkSessionState(function() {
            SWCElements.modalWindow.show({
                className: 'unmount-device',
                templateID: 'storage:settings:modal-windows:unmount-device-process',
                templateData: {
                    localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate,
                    deviceName: deviceName
                },
                onShow: function(){
                    $.when(swc.models.StorageDevices.unmountDevice(deviceId)).done(function(){
                        self.unmountConfirm(deviceName);
                    });
                }
            });
        });
    },

    unmountConfirm: function(deviceName) {
        var self = this;
        
        SWCElements.modalWindow.hide();
        SWCElements.modalWindow.show({
            templateID: 'storage:settings:modal-windows:unmount-device-complete',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                deviceName: deviceName
            },
            className: 'unmount-device',
            onApply: function(){
                SWCElements.modalWindow.hide();
                self.resetExpandableItem();
                self.render();
            }
        });
    },

    resetExpandableItem: function() {
        this.openedItem = null;
    },

    openExpandableItem: function() {
        if (_.isNull(this.openedItem) && swc.models.StorageDevices.length) {
            this.openedItem = swc.models.StorageDevices.at(0).get('id');
        }

        if (!_.isNull(this.openedItem)) {
            this.$el.find('.expandable-list').trigger('expandable:swc-open', this.openedItem);
        }
    },

    onExpandableOpen: function(e, value) {
        this.openedItem = value;
    },

    onExpandableClose: function(e, value) {
        if (this.openedItem === value) {
            this.resetExpandableItem();
        }
    }
});
;swc.constructors.StorageSchedulerView = swc.base.PageView.extend({

    className: 'storage-scheduler',

    listenerInterval: 5,

    listenerEnabled: true,

    listenerPages: [ 'storage-schedulers' ],

    models: ['apServiceState', 'apServiceLoadingState', 'Schedulers', 'ApplicationPart'],

    events: {
        'swc-switcher:change .set-ap-state': 'setApState',
        'swc-checkbox:change .enable-scheduler':'enableScheduler'
    },

    changedScheduler: false,

    setTemplateData: function() {
        var apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = apScheduler ? apScheduler.get('enable') : false;

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            schedulerState: apSchedulerState
        };
    },

    renderComplete: function() {
        var self = this,
            scheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = scheduler ? scheduler.get('enable') : false,
            schedulerRanges = swc.models.Schedulers.defaultScheduler.schedule;
        
        // In case if AP is Off
        if (!_.isUndefined(scheduler)) {
            schedulerRanges = scheduler.get('pixelSchedule');
        }

        this.$('.enable-scheduler').trigger('swc-checkbox:swc-change', apSchedulerState);
        
        swc.constructors.dispatcher.once('scheduler:change', function(e) {
            self.changedScheduler = true;
            self.setButtonsState();
        });

        self.schedulerDiapazon = new swc.constructors.SchedulerLiner({
            isDisabled: !apSchedulerState,
            scaleWidth: 432,
            diapazones: schedulerRanges,
            model: scheduler,
            schedulerType: 'storage'
        });

        this.$('.scheduler-container').html(self.schedulerDiapazon.el);

        this.updatePageUI();
    },

    onListenerComplete: function() {
        this.stopPageLoading();
        this.updatePageUI();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        swc.models.apServiceState.sync('update');
    },

    emptyModal: function() {
        var self = this,
            deferred = new $.Deferred();

        SWCElements.modalWindow.show({
            templateID: 'power:ap:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings('power'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                SWCElements.modalWindow.hide();
                deferred.reject();
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading('Saving page data..');
                swc.models.ApplicationPart.set('serviceState', false);
                $.when(
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.ApplicationPart.setServiceState()
                    ).done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
        });

        return deferred.promise();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred();

        if (_.indexOf(swc.models.Schedulers.emptySchedulers, "ap") >= 0) {
            this.stopPageLoading();
            return self.emptyModal();
        } else {
            $.when(swc.models.Schedulers.addSchedule('ap'))
                .done(function() {
                    self.changedScheduler = false;
                    deferred.resolve();
                })
                .fail(function() {
                    deferred.reject();
                });
        }

        return deferred.promise();
    },
    
    pageCheckDefaultValues: function () {
        var isNotChanged = !this.changedScheduler &&
            swc.base.PageView.prototype.pageCheckDefaultValues.apply(this, arguments);
        
        if (isNotChanged) {
            this.startListener();
        } else {
            this.stopListener();
        }
        
        return isNotChanged;
    },
    
    hasChanged: function () {
        return !this.pageCheckDefaultValues();
    },

    enableScheduler: function(e, value) {
        swc.models.Schedulers.get('ap').set('enable', !!value);
        this.renderComplete();
    }

});
;swc.constructors.StorageSettingsCloudbackupView  = swc.base.TabView.extend({

    className: 'cloud-backup',

    listenerEnabled: true,

    listenerPages: [ 'cloud-backup' ],

    models: [
        'СloudServicesStatus',
        'CloudServices',
        'CentralStorage',
        'Network'
    ],

    validation: {
        usbUID: 'CloudAccountCollection:usbUID',
        folderName: 'CloudAccountCollection:folderName'
    },

    events: {
        "swc-radio-buttons:change .select-cloud-service": "onChangeCloudService",
        "swc-dropdown:change .device-selection": "onChangeDevice"
    },

    setTemplateData: function() {
        // TODO :: change <cloudService> and <cloudServicesList> calls to the collection:
        this.templateData = {
            centralStorageState: swc.models.CentralStorage.isEnabled(),
            cloudService: sessionStorage.getItem('cloudService') || "dropbox", // Default service - 'Dropbox'
            cloudServicesList: [
                { id: "dropbox", name: "Dropbox" },
                { id: "googledrive", name: "Google Drive" }
            ]
        };
    },

    preRender: function () {
        var deferred = new $.Deferred(),
            self = this,
            oauthCallbackParams,
            oauthCallbackParamsString = sessionStorage.getItem("oauthCallbackParams"),
            syncFolderDataString = sessionStorage.getItem('syncFolderData');

        sessionStorage.removeItem("oauthCallbackParams");
        sessionStorage.removeItem("syncFolderData");

        if (syncFolderDataString) {
            try {
                this.syncFolderData = JSON.parse(syncFolderDataString);
            } catch (e) {
                return;
            }
        }

        this.errorMessages = [];
        this.folderValidationMessages = [];

        if (!swc.models.CloudAccountCollection) {
            swc.models.CloudAccountCollection = new swc.constructors.CloudAccountCollection();
        }

        if (oauthCallbackParamsString) {
            // authentication is in progress (redirected from oauthHandler):
            this.stopPageLoading();
            this.showPageLoading("Processing login to Cloud Service");

            try {
                oauthCallbackParams = JSON.parse(oauthCallbackParamsString);
                if (!_.isUndefined(oauthCallbackParams.error) && oauthCallbackParams.error === "access_denied") {
                    throw 'access denied';
                }
                if (oauthCallbackParams.not_approved) {
                    throw 'not approved';
                }

                $.when(swc.models.CloudAccountCollection.handleOauthCallback(oauthCallbackParams))
                    .done(function(response){
                        var folderPromise = self.syncFolderData ? self.folderNameValidation(self.syncFolderData) : true;
                        // Create folder used saved data from sessionStorage 
                        $.when(folderPromise)
                            .done(function() {
                                self.syncFolderData = null; // remove folder data before navigate
                                self.navigateToList(); // switch to another view
                                deferred.reject(); // stop rendering this view
                            })
                            .fail(function(validationMessages){
                                // proceed rendering with validation messages:
                                self.folderValidationMessages = validationMessages;
                                deferred.resolve();
                            });
                    })
                    .fail(function(){
                        // proceed rendering with validation messages:
                        self.errorMessages.push('could-not-connect');
                        deferred.resolve();
                    });
            } catch(e) {
                // oauth failed
                // proceed rendering with validation messages 
                // (currently the same error for all cases):
                this.errorMessages.push('could-not-connect');
                deferred.resolve();
            }
        } else {
            // authentication is not in progress:

            if (!swc.models.CentralStorage.isEnabled()) {
                // proceed rendering:
                deferred.resolve();
            } else {
                $.when(swc.models.CloudAccountCollection.sync('read'))
                    .done(function () {
                        if (swc.models.CloudAccountCollection.models.length > 0) {
                            self.navigateToList(); // switch to another view
                            deferred.reject(); // stop rendering this view
                        } else {
                            // proceed rendering:
                            deferred.resolve();
                        }
                    }).fail(function () {
                        // can't load collection but we don't really need it to render the page, so
                        // proceed rendering:
                        deferred.resolve();
                    });
            }
        }

        return deferred.promise();
    },

    onListenerComplete: function() {
        var apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading');

        // Check if AP turned off or DBUS crashed
        if (apServiceLoadingState === true) {
            swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
        } else {
            if (!swc.models.СloudServicesStatus.get('isEnabled')) {
                this.onCloudServicesDisable();
            }
        }
    },

    /**
     * Listen to cloud services `disable` event
     *
     * @description:
     *
     * <СloudServicesStatus> model is listening to TR-069 parameter, which has a flag if cloud services are enabled to
     * the user. This parameter can be set to false during user work with cloud services. This method will prevent all
     * user actions and show modal window with redirection to other page
     */
    onCloudServicesDisable: function() {
        this.stopListener();

        SWCElements.modalWindow.show({
            templateID: 'storage:settings:modal-windows:disable-cloud-services',
            templateData: {},
            className: 'disable-cloud-services',

            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
            }
        });
    },

    navigateToList: function () {
        swc.router.navigate('storage/settings/cloud-backup/list', { trigger: false, skipUnsavedChanges: true});
    },

    setDefaults: function () {
        // Set default value for service
        this.$(".swc-radio-buttons.select-cloud-service").data("default-value", this.templateData.cloudService);

        if (this.syncFolderData) {
            // for storage
            this.$(".swc-dropdown.device-selection").data("default-value", this.syncFolderData.partitionUID);
            // for folder name
            this.$("input[name=folderName]").data("default-value", this.syncFolderData.folderName);
        } else {
            this.$(".swc-dropdown.device-selection").data("default-value", "null");
        }
    },

    /**
     * Set predefined values after page has been rendered:
     */
    renderComplete: function() {
        var self = this;

        // Check if Central Storage is Enabled, else -> disable page
        if (!swc.models.CentralStorage.isEnabled()) {
            return;
        }

        if (!swc.models.СloudServicesStatus.get('isEnabled')) {
            this.onCloudServicesDisable();
        }

        // Call default methods to (re)set values on the page:
        this.setDefaults();
        this.onChangeCloudService(null, this.templateData.cloudService, true);
        this.setDevicesDropdownValues(true);

        // Populate folder data
        if (this.syncFolderData) {
            this.$el.find(".device-selection").trigger("swc-dropdown:swc-change", this.syncFolderData.partitionUID);
            this.syncFolderData = null;
        }

        if (this.showSaveError) {
            this.showSaveError = false;
            this.errorMessages.push('can-not-receive-url');
        }

        if (!_.isEmpty(this.folderValidationMessages)) {
            this.setFolderNameValidationErrors(this.folderValidationMessages);
            this.folderValidationMessages = [];
        }

        if (!_.isEmpty(this.errorMessages)) {
            this.showSaveSuccess('error', this.errorMessages);
        }

        if (!this.devicesDropdownInterval) {
            this.devicesDropdownInterval = setInterval(function () {
                if (self.$el.parents('body').length > 0) {
                    $.when(swc.models.CentralStorage.sync('read', {silent: true}))
                        .done(function () {
                            self.setDevicesDropdownValues();
                        });
                } else {
                    // if the current view is not in the DOM
                    // we don't need the interval anymore:
                    clearInterval(self.devicesDropdownInterval);
                }
            }, 10000);
        }

        this.stopPageLoading();
    },

    /**
     * Change cloud service by user / application. Update correct model in cloud services collection:
     * @param e {Object} Event
     * @param cloudServiceID {String}
     */
    onChangeCloudService: function(e, cloudServiceID) {
        var serviceData = _.findWhere(this.templateData.cloudServicesList, { id: cloudServiceID }),
            serviceName = serviceData ? serviceData.name : '',
            input = this.$("input[name=folderName]"),
            isCalledFromRenderComplete = _.isNull(e);

        // TODO :: change service in collection

        if (this.syncFolderData && this.syncFolderData.folderName) {
            input.val(this.syncFolderData.folderName);
        } else if (input.data('default-value') === input.val() || isCalledFromRenderComplete) {
            input.val(serviceName);
        }

        input.data('default-value', serviceName);

        if (!isCalledFromRenderComplete) {
            input.trigger('validate');
        }
    },

    onChangeDevice: function (e) {
        var input = this.$("input[name=folderName]");

        if (e) {
            input.trigger('validate');
        }
    },

    /**
     * Update usb devices dropdown with list of usb devices
     * @param isSkipValidation {Boolean} skip / not skip validation for folder name
     */
    setDevicesDropdownValues: function(isSkipValidation) {
        var dropdown = this.$el.find('.swc-dropdown.device-selection'),
            oldValue = dropdown.data('value'),
            input = this.$("input[name=folderName]"),
            options = swc.models.CentralStorage.getDeviceDropdownOptions(),
            defaultDevice = swc.models.CentralStorage.getDefaultDeviceOption(options, oldValue),
            defaultDeviceValue = dropdown.data('default-value');

        // Set default value to the dropdown if not set:
        dropdown.data('default-value', defaultDevice);

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.data('hide-default', true);
        dropdown.trigger('swc-dropdown:swc-change', defaultDevice);

        // Validate dropdown to show message to the user
        if (defaultDevice === "no-devices-connected") {
            this.pageValidation(dropdown, false);
        } else {
            this.clearValidationMessages(dropdown);

            // Validate folder name only when user did some changes on the page:
            if (!isSkipValidation && !this.pageCheckDefaultValues()) {
                input.trigger('validate');
            }
        }
    },

    folderNameValidation: function(syncFolderData) {
        var self = this,
            deferred = new $.Deferred();

        // Try to create a folder before login to CS
        $.when(swc.models.CloudAccountCollection.createFolder(syncFolderData.partitionUID, syncFolderData.folderName))
            .done(function() {
                deferred.resolve();
            })
            .fail(function(error) {
                var validationMessages = [];

                switch (error.message) {
                    case 'invalid name':
                        validationMessages.push("unable to create folder");
                    break;

                    case 'already exists':
                        validationMessages.push("already exists");
                    break;

                    default:
                        validationMessages.push("unable to create folder");
                }

                deferred.reject(validationMessages);
            });

        return deferred.promise();
    },

    /**
     * Show validation errors of folder name in UI, after validation was not completed on AP:
     * @param messsages
     */
    setFolderNameValidationErrors: function(messsages) {
        var folderNameInput = this.$el.find('input[name="folderName"]'),
            folderNameValidationContainer = this.$el.find('.validation-message[data-parameter-name="folderName"]');

        folderNameValidationContainer.find('.error-message').hide();

        if (!_.isEmpty(messsages)) {
            // Add validation error to the field:
            folderNameInput.addClass('validation-error');
            folderNameInput.data('validation-error', true);

            // Show validation error in UI:
            folderNameValidationContainer.show();
            folderNameValidationContainer.find('.error-message[data-error="' + messsages[0] + '"]').show();
        } else {
            folderNameInput.removeClass('validation-error');
            folderNameInput.data('validation-error', false);
            folderNameValidationContainer.hide();
        }
    },

    /**
     * Save method will be called when user will press "Log In" button;
     * @override
     */
    save: function() {
        var self = this,
            cloudService = this.$el.find(".select-cloud-service").data('value'),
            syncFolderData = {
                partitionUID: this.$el.find(".device-selection").data('value'),
                folderName: this.$el.find("input[name='folderName']").val()
            },
            deferred = new $.Deferred(),
            validationContainer = this.$('.validation-message[data-parameter-name="global"]');
        
        // Show user login message (not "saving changes")
        this.stopPageLoading();
        this.showPageLoading("Processing login to Cloud Service");

        validationContainer.hide();
        validationContainer.find('.error-message').hide();

        $.when(swc.models.Network.sync())
            .done(function() {
                // Check if device connected to the internet TODO :: remove after implementation on AP side
                if (!swc.models.Network.getParameter('ConnectionStatus', 'status')) {
                    self.stopPageLoading();
                    self.showSaveError = true;
                    
                    return deferred.reject("can-not-receive-url");
                }
                $.when(swc.models.CloudServices.validateFolder(syncFolderData.partitionUID, syncFolderData.folderName))
                    .done(function() {
                        // Steps required to login:
                        // 1. getAuthURL()
                        // 2. handleOAtuhCallback()
                        // 3. syncFSResources() == create a folder
                        $.when(swc.models.CloudAccountCollection.getLoginURL(cloudService))
                            .done(function(url) {
                                // save folder name into local storage (or SessionStorage)
                                sessionStorage.setItem('syncFolderData', JSON.stringify(syncFolderData));
                                sessionStorage.setItem('cloudService', cloudService);
                                document.location.href = url;
                            })
                            .fail(function() {
                                self.showSaveError = true;
                                self.stopPageLoading();
                                deferred.reject();
                            });
                    })
                    .fail(function() {
                        self.stopPageLoading();
                        deferred.reject();
                    });
            });

        return deferred.promise();
    }
});
;swc.constructors.cloudAccountItem = Backbone.View.extend({

    pageTemplateID: 'storage:cloud:account-item',

    events: {
        'swc-checkbox:change .activate-cloud': 'toggleActivate',
        'click .do-custom-edit': 'edit',
        'click .do-disconnect': 'disconnect',
        'click .login-cloud': 'login',
        'click .sync-cloud': 'sync',
        'click .show-unsynced-files': 'showUnsyncedFiles'
    },

    render: function () {
        this.$el.empty();
        this.setTemplateData();
        this.$el.append($.tmpl(swc.Templates.get(this.pageTemplateID).get('content'), {
            data: this.templateData,
            localeStrings: swc.models.Locale.getLocaleStrings('storage'),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            GlobalEnable: swc.models.Application.get('GlobalEnable')
        }));

        return this;
    },

    showUnsyncedFiles: function() {
        var self = this,
            obj = this.model.getExtendedJSON(),
            data = _.extend(obj, {
                syncAction: false,
                loginAction: false
            });

        if (_.isEmpty(data.inaccessibleFiles)) {
            return;
        }

        data.inaccessibleFiles = _.map(data.inaccessibleFiles, function(file) {
            var list = file.split('/');

            list.splice(-1, 1, '<strong>' + list.slice(-1) + '</strong>');

            return list.join('/');
        });

        SWCElements.modalWindow.show({
            templateID: 'storage:cloud-backup:unsynced-files:modal-window',
            templateData: {
                syncDetails: data
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
            }
        });
    },

    setTemplateData: function(){
        var self = this,
            obj = this.model.getExtendedJSON(),
            data;

        data = _.extend(obj, {
                syncAction: false,
                loginAction: false
            });

        switch (data.status) {

            case "IN_PROGRESS":
                data.tooltip = "Sync in progress";
                break;

            case "DISABLED":
                data.tooltip = "Sync stopped";
                break;

            case "COMPLETE":
                if (_.isEmpty(data.inaccessibleFiles)) {
                    data.tooltip = "Synced";
                } else {
                    data.status = 'INCOMPLETE';
                    data.tooltip = "Some files could not be synced";
                }
                break;

            case "ERROR":

                switch (data.error) {

                    case "NOT_ENOUGH_LOCAL_SPACE":
                        data.tooltip = "There is not enough space on your Central Storage to sync data. " +
                            "Please free some space.";
                        data.status = "WARNING";
                        break;

                    case "NOT_ENOUGH_REMOTE_SPACE":
                        data.tooltip = "There is not enough space on your Cloud Account %cloudService% " +
                            "(%accountName%) to sync data.";
                        data.status = "WARNING";
                        break;

                    case "INVALID_CREDENTIALS":
                        data.tooltip = "Could not connect to %cloudService%. Last login attempt on %lastLogin% has " +
                            "failed. Please try to login again later.";
                        data.loginAction = true;
                        break;

                    case "COMMUNICATION_ERROR":
                        data.tooltip = "There are troubles syncing some content. Try again by " +
                            "clicking \"Sync\" button or wait for 1 min for next sync attempt.";
                        data.status = "WARNING";
                        data.syncAction = true;
                        break;

                    default:
                        data.tooltip = "Unknown";
                }

                break;
            case "STORAGE_DISCONNECTED":
                data.tooltip = "Unable to connect to Cloud Account folder. Please check" +
                                " if your Central Storage device is connected to Internet-Box";
                data.deviceDisconnected = true;
                data.status = "ERROR";
                break;
            default:
                data.tooltip = "Unknown";
                break;
        }
        data.status = data.status.toLowerCase();

        this.templateData = data;
    },

    toggleActivate: function (e) {
        var value = $(e.currentTarget).data('value') ? 'COMPLETE' : 'DISABLED';
        this.model.set({status: value}, {silent: true});
    },

    edit: function (e) {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'storage:cloud:cloud-accounts:edit-modal',
            templateData: {
                cloudServiceName: self.model.get('cloudServiceName'),
                accountName: self.model.get('accountName'),
                location: self.model.get('deviceName'),
                folderName: self.model.get('folderName')
            },
            className: 'cloud-edit-modal',

            onCancel: function() {
                SWCElements.modalWindow.hide();
                // Hide dropdown overlay if user presses "Cancel" when DropDown list is opened
                SWCElements.dropDown.closeAll();
                // Stop populating deviceDropDownValues
                swc.models.CentralStorage.off("central-storage-update");
            },

            onApply: function() {
                var deviceId = $('.modalWindow .device-selection').data('value'),
                    folderName = $('.modalWindow input[name=folderName]').val();
                $.when(self.folderNameValidation(deviceId, folderName))
                    .done(function () {
                        SWCElements.modalWindow.hide();
                        // Hide dropdown overlay if user presses "Apply" when DropDown list is opened
                        SWCElements.dropDown.closeAll();
                        swc.models.CloudAccountCollection.sync('read');
                        // Stop populating deviceDropDownValues
                        swc.models.CentralStorage.off("central-storage-update");
                    });
            },

            onShow: function () {
                // Set existing values to elements
                $('.modalWindow .device-selection').data("value", self.model.get('deviceId'));
                $('.modalWindow input[name=folderName]').val(self.model.get('folderName'));
                self.setDevicesDropdownValues();
                swc.models.CentralStorage.on("central-storage-update", self.setDevicesDropdownValues);
            }
        });
    },

    /**
     * Update usb devices dropdown with list of usb devices
     */
    setDevicesDropdownValues: function() {
        var dropdown = $('.modalWindow .swc-dropdown.device-selection'),
            validationMessages = $('.modalWindow .validation-message[data-parameter-name="usbUID"]'),
            validationMessage = validationMessages.find('.error-message[data-error="no connected devices"]'),
            oldValue = dropdown.data('value'),
            options = swc.models.CentralStorage.getDeviceDropdownOptions(),
            defaultDevice = swc.models.CentralStorage.getDefaultDeviceOption(options, oldValue);
        
        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.data('hide-default', true);
        dropdown.trigger('swc-dropdown:swc-change', defaultDevice);
        
        // Validate dropdown to show message to the user
        if (defaultDevice === "no-devices-connected") {
            validationMessages.show();
            validationMessage.show();
            dropdown.addClass('validation-error');
        } else {
            validationMessages.hide();
            validationMessage.hide();
            dropdown.removeClass('validation-error');
        }
    },

    folderNameValidation: function(partitionUID, folderName) {
        var self = this,
            deferred = new $.Deferred();

        if (partitionUID === this.model.get('deviceId') && folderName === this.model.get('folderName')) {
            var validationMessages = [];
            validationMessages.push("already exists");
            this.setFolderNameValidationErrors(validationMessages);
            return deferred.reject();
        }

        // Try to create a folder
        $.when(swc.models.CloudServices.validateFolder(partitionUID, folderName))
            .done(function () {
                $.when(swc.models.CloudAccountCollection.moveFolder(self.model, partitionUID, folderName))
                    .done(function() {
                        var folderNameValidationContainer = $('.modalWindow .validation-message[data-parameter-name="folderName"]');

                        folderNameValidationContainer.find('.error-message').hide();
                        deferred.resolve();
                    })
                    .fail(function(error) {
                        var validationMessages = [];

                        switch (error.message) {
                            case 'invalid name':
                                validationMessages.push("unable to create folder");
                            break;

                            case 'already exists':
                                validationMessages.push("already exists");
                            break;

                            default:
                                validationMessages.push("unable to create folder");
                        }

                        self.setFolderNameValidationErrors(validationMessages);
                        deferred.reject();
                    });
            })
            .fail(function (status) {
                var validationMessages = [];
                switch (status.failure) {
                    case 'SYNC_FOLDER_ALREADY_EXISTS':
                        validationMessages.push("already exists");
                    break;

                    default:
                        validationMessages.push("unable to create folder");
                }
                self.setFolderNameValidationErrors(validationMessages);
                deferred.reject();
            });

        return deferred.promise();
    },

    setFolderNameValidationErrors: function(messsages) {
        var folderNameInput = $('.modalWindow input[name="folderName"]'),
            folderNameValidationContainer = $('.modalWindow .validation-message[data-parameter-name="folderName"]');

        // Add validation error to the field:
        folderNameInput.addClass('validation-error');
        folderNameInput.data('validation-error', true);

        // Show validation error in UI:
        folderNameValidationContainer.show();
        folderNameValidationContainer.find('.error-message').hide();
        folderNameValidationContainer.find('.error-message[data-error="' + messsages[0] + '"]').show();
    },

    disconnect: function (e) {
        var self = this;
        swc.views.Application.showPageLoading('Loading page data..');
        $.when(swc.models.CentralStorage.sync('read'))
            .done(function () {
                var devices = swc.models.CentralStorage.get('usb-devices').get('devices'),
                    device = _.find(devices, function (obj){
                        return obj.id === self.model.get('deviceId');
                    });
                if (device) {
                    self.disconnectModal();
                } else {
                    self.doDisconnect(true);
                }
            }).always(function () {
                swc.views.Application.stopPageLoading();
            });
    },

    disconnectModal: function () {
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'storage:cloud:cloud-accounts:disconnect-modal',
            templateData: {
                cloudServiceName: getTranslationStrings(self.model.get('cloudServiceName'), true),
                accountName: self.model.get('accountName')
            },
            className: 'cloud-disconnect-modal',

            onCancel: function() {
                SWCElements.modalWindow.hide();
            },

            onApply: function() {
                var keepData = getParameter($('.cloud-disconnect-modal .keep-data-selection'));
                self.doDisconnect(keepData.parameterValue === 'keep');
            }
        });
    },

    doDisconnect: function (keepData) {
        var self = this,
            validationMessageContainer = $(".modalWindow .save-validation-errors");
        
        $.when(this.model.logout(keepData))
            .done(function () {
                self.$el.remove();
                validationMessageContainer.hide();
                SWCElements.modalWindow.hide();
                
                // Remove cloud service id on logout process
                sessionStorage.removeItem("cloudService");
                
                // If no accounts left - redirect user to Cloud Login page
                if (swc.models.CloudAccountCollection.models.length === 0) {
                    swc.router.navigate('storage/settings/cloud-backup', { trigger: false, skipUnsavedChanges: true});
                    return;
                }
            })
            .fail(function (result) {
                validationMessageContainer.show();
                validationMessageContainer.find("div[data-error='can not remove folder']").show();
            });
    },

    login: function (e) {
        swc.models.CloudServices.checkCredentials();
    },

    forceSyncDevice: function(deviceId){
        var deferred = new $.Deferred();

        swc.models.Rest.sendRequest({
            url: '/ws',
            data: {
                "service": "com.swisscom.stargate/ws/cloud/backup.com.swisscom.stargate.cloud.backup",
                "method": "forceFailedTasksForPartition",
                "parameters": {
                    "partitionUUID": deviceId
                }
            },

            success: function(response) {
                // Timeout is used because the board responds immediately
                // but actually needs some time to change the sync state.
                // sad but true :(
                setTimeout(function(){
                    deferred.resolve();
                }, 3000);
            }
        });

        return deferred.promise();
    },

    /**
     * Starts sync for the service
     * @deprecated
     * @param e
     */
    sync: function (e) {
        var self = this;

        self.showPageLoading('Saving page data..');
        $.when(this.forceSyncDevice(this.model.get('deviceId')))
            .done(function(){
                swc.models.CloudAccountCollection.sync('read')
                    .done(function(){
                        self.stopPageLoading();
                    });
            });
    }
});
;swc.constructors.StorageSettingsCloudbackupListView = swc.base.TabView.extend({
    
    className: 'cloud-accounts',

    pageTemplateID: 'storage:settings:cloud-accounts',
    
    listenerEnabled: true,
    
    listenerPages: ['cloud-backup-list'],

    events: {
        'swc-checkbox:change .activate-cloud': 'memorizeCheckboxesState',
        'click .save-changes': 'save'
    },

    message: "",

    models: [ 'apServiceState', 'apServiceLoadingState',  'СloudServicesStatus', 'CloudServices', 'CentralStorage' ],

    checkboxes: {},

    // Dirty crutch.
    // Should be fixed in base classes to support pageTemplateID property
    // without need of initialize method overriding
    initialize: function() {
        this.template = $.template("pageContent", swc.Templates.get(this.pageTemplateID).get('content'));
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    preRender: function () {
        var self = this,
            deferred = new $.Deferred();

        if (!swc.models.CloudAccountCollection) {
            swc.models.CloudAccountCollection = new swc.constructors.CloudAccountCollection();
        }

        if (!swc.models.CentralStorage.isEnabled()) {
            deferred.resolve();
        } else {
            $.when(swc.models.CloudAccountCollection.sync('read'))
                .done(function () {
                    if (_.indexOf(self.models, 'CloudAccountCollection') === -1) {
                        // we need it to refresh automatically but can not add it to models from the 
                        // beginning because it is unnecessary when the Central Storage is down
                        self.models.push('CloudAccountCollection');
                    }

                    if (swc.models.CloudAccountCollection.models.length > 0) {
                        var deferredForceSyncActions = [];
                        // force sync for every account
                        // FIXME: Only sync those devices which has some trouble status
                        swc.models.CloudAccountCollection.each(function (accountModel) {
                            deferredForceSyncActions.push(accountModel.forceSyncDevice());
                        });
                        $.when.apply(this, deferredForceSyncActions)
                            // never mind, just resolve and see what we get when background listener runs sync
                            .always(function () {
                                // now re-read the whole collection
                                swc.models.CloudAccountCollection.sync('read')
                                    .always(function(){
                                        deferred.resolve();
                                    });
                            });
                    } else {
                        self.switchToCloudLoginView();
                        deferred.reject();
                    }
                })
                .fail(function () {
                    deferred.resolve();
                });
        }

        return deferred.promise();
    },

    renderComplete: function(){
        var self = this;

        var listView = new swc.base.listView({
            model: swc.models.CloudAccountCollection,
            itemView: 'cloudAccountItem',

            renderComplete: function () {
                self.restoreCheckboxes();
            }
        });

        if (!swc.models.СloudServicesStatus.get('isEnabled')) {
            this.onCloudServicesDisable();
        }

        this.$el.find('.account-list-container').replaceWith(listView.render().el);

        if (sessionStorage['clouds-saved'] === 'ok') {
            this.$('.buttons-container-message .save-success').show();
            sessionStorage.removeItem('clouds-saved');

            setTimeout(function () {
                self.$('.buttons-container-message .save-success').hide();
            }, 3000);
        }

        if (!swc.models.CentralStorage.isEnabled()) {
            this.setPageState(false);
        }
    },

    onListenerComplete: function() {
        var apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading');

        // Check if AP turned off or DBUS crashed
        if (apServiceLoadingState === true) {
            swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
        } else {
            if (!swc.models.СloudServicesStatus.get('isEnabled')) {
                this.onCloudServicesDisable();
            }
        }
    },

    /**
     * Listen to cloud services `disable` event
     *
     * @description:
     *
     * <СloudServicesStatus> model is listening to TR-069 parameter, which has a flag if cloud services are enabled to
     * the user. This parameter can be set to false during user work with cloud services. This method will prevent all
     * user actions and show modal window with redirection to other page
     */
    onCloudServicesDisable: function() {
        this.stopListener();

        SWCElements.modalWindow.show({
            templateID: 'storage:settings:modal-windows:disable-cloud-services',
            templateData: {},
            className: 'disable-cloud-services',

            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.router.navigate('storage/settings/data-sharing', { trigger: false, skipUnsavedChanges: true });
            }
        });
    },

    switchToCloudLoginView: function () {
        swc.router.navigate('storage/settings/cloud-backup', { trigger: false, skipUnsavedChanges: true});
    },

    memorizeCheckboxesState: function () {
        var self = this;
        this.checkboxes = {};

        if (!this.pageCheckDefaultValues()) {
            this.$('.swc-checkbox.activate-cloud').each(function () {
                var this$ = $(this),
                    id = this$.closest('.expandable-list-item').data('key');
                if (this$.data('value') !== this$.data('default-value')) {
                    self.checkboxes[id] = this$.data('value');
                }
            });
        }
    },

    // restoring checkboxes states that have been memorized in memorizeCheckboxesState()
    restoreCheckboxes: function () {
        var self = this;

        this.$('.expandable-list-item').each(function () {
            var this$ = $(this),
                id = this$.data('key'),
                checkbox = this$.find('.swc-checkbox.activate-cloud');
            if (_.has(self.checkboxes, id)) {
                checkbox.trigger('swc-checkbox:swc-change', self.checkboxes[id]);
            }
        });
    },

    save: function () {
        var self =  this,
            promises = [];

        _.each(swc.models.CloudAccountCollection.models, function (model, index) {
            // we use the memorized checkboxes states to avoid sync problem:
            if (_.has(self.checkboxes, model.id)) {
                promises.push(model.setBackupState(self.checkboxes[model.id]));
            }
        });

        $.when(promises)
            .done(function () {
                sessionStorage['clouds-saved'] = 'ok';
                swc.models.CloudAccountCollection.sync('read');
                self.checkboxes = {};
            });
    },
    
    onCancel: function () {
        this.checkboxes = {};
    }
});
;swc.constructors.StorageSettingsDatasharingView = swc.base.TabView.extend({

    className: 'data-sharing',

    models: [ 'MediaServices', 'AfpServices', /*'UsbStatus',*/ 'RemoteNASAccess', 'RemoteNASAccounts' ],

    events: {
        'swc-checkbox:change .swc-checkbox.set-media-server-status': 'onMediaServiceStatusChange',
        'swc-checkbox:change .swc-checkbox.set-afp-status': 'onAFPStatusChange',
        'swc-checkbox:change .swc-checkbox.set-usb-3-status': 'onUsbStatusChange',
        'swc-checkbox:change .swc-checkbox.set-remote-access-status': 'onRemoteAccessStatusChange',

        'click .icons.process-delete': 'removeNASAccount'
    },

    /**
     * Serialize models and collections and pass values to the template
     */
    setTemplateData: function() {
        this.templateData = {
            mediaServerStatus: swc.models.MediaServices.get('status'),
            afpStatus: swc.models.AfpServices.get('status'),
            usbStatus: false,//swc.models.UsbStatus.get('status'),
            rnasError: swc.models.RemoteNASAccounts.isError(),
            remoteNasStatus: swc.models.RemoteNASAccess.isEnabled(),
            remoteNasAccounts: swc.models.RemoteNASAccounts.toJSON()
        };
    },

    /**
     * Update media service status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onMediaServiceStatusChange: function(e, value) {
        swc.models.MediaServices.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Update afp status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onAFPStatusChange: function(e, value) {
        swc.models.AfpServices.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Handle USB 3.0 Checkbox value change, show confirmation wizard / change model
     *
     * @description:
     *
     *  When user switches on `usb 3.0 standard` - he must be shown confirmation window with alert message. If user click
     *  `apply`, nothing happens, if user clicks `cancel` -> checkbox must be set to false
     *
     * @param e {Object} -> Event
     * @param value {Boolean}
     */
    onUsbStatusChange: function(e, value) {
        var self = this;

        if (value === true) {
            SWCElements.modalWindow.show({
                templateID: 'storage:settings:modal-windows:enable-usb-3',
                templateData: {},
                className: 'enable-usb-3',

                onCancel: function() {
                    self.$('.swc-checkbox.set-usb-3-status').trigger('swc-checkbox:swc-change', false);
                },

                onApply: function() {
                    self.setUsbModelStatus(value);
                    SWCElements.modalWindow.hide();
                }
            });
        } else {
            this.setUsbModelStatus(value);
        }
    },

    /**
     * Update direct USB 3.0 Model status, and set buttons state:
     * @param value {Boolean}
     */
    setUsbModelStatus: function(value) {
        //swc.models.UsbStatus.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Update remote access status in the model, after user clicked on linked checkbox
     * @param e {Object}
     * @param value {Boolean}
     */
    onRemoteAccessStatusChange: function(e, value) {
        swc.models.RemoteNASAccess.set('status', value);

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * Remove account from the collection of Remote Access Accounts
     * @param e {Object}
     */
    removeNASAccount: function(e) {
        var button = $(e.target).closest('.process-delete'),
            accountEmail = button.data('account'),
            accountItem = this.$el.find('.expandable-list-item[data-key="' + accountEmail + '"]'),
            accountModel = swc.models.RemoteNASAccounts.findWhere({ email: accountEmail });

        // Update model in the collection:
        swc.models.RemoteNASAccounts.remove(accountModel);

        // Remove item from the list
        accountItem.remove();

        // Update buttons state to see, that changes were done on the page:
        this.setButtonsState();
    },

    /**
     * FIXME :: when all view will be moved to new architecture remove this
     * @note page implemented using 2.0 core components
     * @override
     */
    pageCheckDefaultValues: function() {
        // NOTE: We only check other models if AP is ON and completely ready
        var isModelsChanged = function() {
            return swc.models.apServiceState.get('status') &&
                !swc.models.MediaServices.hasChanged() &&
                !swc.models.RemoteNASAccess.hasChanged() &&
                !swc.models.RemoteNASAccounts.hasChanged() &&
                !swc.models.AfpServices.hasChanged() /*&&
             !swc.models.UsbStatus.hasChanged()*/;
        };
        
        this.parentView.pageCheckDefaultValues = isModelsChanged;
        
        return isModelsChanged();
    },
    
    hasChanged: function() {
        return swc.models.apServiceState.get('status') && !this.pageCheckDefaultValues();
    },

    save: function() {
        var deferred = new $.Deferred(),
            toDo = [
                swc.models.MediaServices.sync('update'),
                swc.models.AfpServices.sync('update'),
                //swc.models.UsbStatus.sync('update'),
                swc.models.RemoteNASAccess.sync('update')
            ],
            deletedAccounts = swc.models.RemoteNASAccounts.changedModels({ onlyDeleted: true  });

        _.each(deletedAccounts, function(model, key) {
            toDo.push(
                model.sync('delete')
            );
        });

        $.when.apply(this, toDo)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});
;swc.constructors.StorageSettingsView = swc.base.PageView.extend({

    className: 'storage-settings',

    sharingState: true,

    events: {
        'swc-switcher:change .set-ap-state': 'setApState'
    },

    listenerInterval: 5,

    listenerPages: [ 'data-sharing' ],

    models: [ 'apServiceState', 'apServiceLoadingState', 'СloudServicesStatus', 'Schedulers' ],

    setTemplateData: function() {
        var apScheduler = swc.models.Schedulers.get('ap'),
            apSchedulerState = !_.isUndefined(apScheduler) ? apScheduler.get('enabled') : false;

        this.templateData = {
            apServiceState: swc.models.apServiceState.get('status'),
            cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled'),
            schedulerState: apSchedulerState
        };
    },

    /**
     * Check if application part is starting or disabled and disable / enable page
     *
     * <apState> can be :: `on`, `off`, `loading`
     */
    renderComplete: function() {
        this.updatePageUI();
    },

    onListenerComplete: function() {
        this.stopPageLoading();
        this.updatePageUI();
    },

    updatePageUI: function() {
        var self = this,
            pageState = true,
            apState = swc.models.apServiceState.get('status'),
            apServiceLoadingState = swc.models.apServiceLoadingState.get('isLoading'),
            apStateSwitcher = this.$el.find('.set-ap-state');

        // Check if AP is loading or OFF now, and disable tabs and page content
        if (apState !== true || apServiceLoadingState === true) {
            pageState = false;
        }

        // If AP has started -> fully reload page: (because of child view is not updating)
        if (pageState === true && this.isPageEnabled === false) {
            this.stopListener();
            this.render();
        } else {
            // Disable / Enable page and tabs based on page status:
            this.setPageState(pageState);
            this.setTabsState(pageState);

            // Check if AP is OFF now and show disabled message:
            if (apState === false) {
                this.showDisabledMessage({
                    container: '.apStateOffMessage',
                    className: 'above'
                });
            }

            // Check if AP is loading now and show loading message:
            if (apServiceLoadingState === true && apState === true) {
                this.showDisabledMessage({
                    container: '.apStateLoadingMessage',
                    className: 'above'
                });
            }

            // Set correct switcher position:
            apStateSwitcher.trigger('swc-switcher:swc-change', apState);

            // Start listener if page is disabled or loading:
            this.listenerEnabled = true;
            this.startListener();
        }
    },

    /**
     * Update application part status:
     * @param e {Object}
     * @param value {String}
     */
    setApState: function(e, value) {
        var self = this,
            pageRoutes = swc.settings.application.get('navigation'),
            page = Backbone.history.fragment;

        this.stopListener();
        this.listenerEnabled = true;

        this.showPageLoading("Updating Central Storage state");

        // Update parameter in the model:
        swc.models.apServiceState.set('status', value);

        // Start listener again when data saved:
        $.when(swc.models.apServiceState.sync('update')).done(function() {
            if (pageRoutes['data-sharing'] === page) {
                self.startListener();
            } else {
                swc.router.navigate(pageRoutes['data-sharing'], { skipUnsavedChanges: true });
            }
        });
    }
});
;swc.constructors.DevelopersView = swc.base.PageView.extend({

    className: 'developers',

    setTemplateData: function() {
        this.templateData = {
            webui: swc.settings.application.get('build') || {},
            jenkins: swc.settings.application.get('jenkins') || {}
        };
    }
});;swc.constructors.LoginView = swc.base.PageView.extend({
    
    models: ['PasswordRecovery'],

    /**
     * Current view class name:
     */
    className: 'login',

    /**
     * List of event handlers for current view
     */
    events: {
        'click a[name="login-button"]:not(.disabled)': 'processLogin',
        'click a[name="restore-button"]': 'displayRestoreForm',

        'keyup input': 'updateFormState',

        // To update form state even if 'backspace' button holding
        'keydown input': 'updateFormState',

        // Submit login form with enter button
        'keydown .sign-in-form input': 'processLogin',

        'swc-checkbox:change .display-password': 'displayPassword',
        'swc-dropdown:change .locale-selector': 'setLocale',

        'keyup input[name*=login-password]': 'copyPassword',
        'keyup input[name*=new-password-]': 'copyPassword',

        'click a[name="back"]:not(.disabled)': 'backToLogin',

        'click .save-password-button:not(.disabled)': 'applyPassword',
        'swc-checkbox:change .display-new-password': 'showPassword',
        'swc-checkbox:change .enable-recovery': 'enableRecovery',
        'keypress input[name*=new-password-]': 'activateButtons',
        'change input[name*=new-password-]': 'activateButtons',
        'change input[name=new-password-1]': 'validatePassword'
    },

    /**
     * Initialize function has to be overrided from the base page view because of routing address mismatch
     */
    initialize: function() {
        this.template = swc.Templates.get(this.className).get('content');
    },

    /**
     * Render function has to be overrided from the base page view because of it's specific
     */
    render: function() {
        var self = this;

        setTimeout(function() {
            self.renderComplete();
        }, 0);
    },
    
    renderComplete: function(trigger) {
        var self = this,
            localesOptions = swc.models.Locale.getLocaleOptions(),
            currentPage = Backbone.history.fragment,
            isRemoteLogin = currentPage === 'remote-login' || !_.isNull(localStorage.getItem('remoteLogin')),
            loginArea = $('div.login');

        // No need to re-render this page if already on login page
        if (loginArea.size() && _.isUndefined(trigger)) {
            // remove application env variables
            this.clearLogoutState();
            return;
        }
        
        $('#application').html(this.$el.html(
            $.tmpl(self.template, {
                localeStrings: swc.models.Locale.getLocaleStrings('login'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                recoveryEnable: swc.models.PasswordRecovery.get('recoveryEnable'),
                staticPagesLinks: swc.models.Locale.getStaticPagesLinks()
            })
        ));

        // Add supper admin class to body to handle some features with CSS styles:
        $('body').toggleClass('superAdmin', isRemoteLogin);

        // Set locale selector values:
        $('.locale-selector').data('options', localesOptions);
        $('.locale-selector').trigger('swc-dropdown:swc-change', swc.models.Locale.locale);

        // Check if current login for remote admin:
        if (isRemoteLogin) {
            this.$el.find('input[name="login-name"]').val('superadmin');
        } else {
            this.$el.find('input[name="login-name"]').val('admin');
        }

        // Remove local storage items:
        localStorage.removeItem('remoteLogin');
        localStorage.removeItem('userSuperAdmin');

        // Focus to password input
        $('input[name="login-password"]').val('').focus();
        $('input[name="login-password-copy"]').val('');

        swc.views.currentView = this;

        // Update form/login button state
        self.updateFormState();

        // Remember all events on current view
        self.delegateEvents();
        
        // Here we should display one of three steps located on #login page:
        // either "Sign-in" form, or "Password Recovery Hint" page or "Change password" form
        // if process is started already, but not finished.
        if (swc.models.PasswordRecovery.isRecoveryRunning()) {
            this.$('.sign-in-form').hide(); // Don't show login form if Recovery Process is running
            this.displayRestoreForm();
        } else {
            //-----------------------------------------
            // THIS BLOCK DISPLAYS REGULAR LOGIN FORM
            //-----------------------------------------
            $('input, textarea').placeholder();
            
            // remove application env variables
            this.clearLogoutState();

            // Remove loading window:
            self.stopPageLoading();
        }
    },

    /**
     * Clear application state after logout
     *
     * @description:
     *
     * Remove application env variables(action-logout, session-logout,
     * reset-logout) from the localStorage
     */
    clearLogoutState: function() {
        if (_.isNull(localStorage.getItem('reset-logout'))) {
            if (!_.isNull(localStorage.getItem('action-logout'))) {
                this.displayWarningMessage('logout');
                localStorage.removeItem('action-logout');
                localStorage.removeItem('session-logout');
            }

            if (!_.isNull(localStorage.getItem('session-logout'))) {
                this.displayWarningMessage('session-expired');
                localStorage.removeItem('action-logout');
                localStorage.removeItem('session-logout');
            }
        } else {
            // Clean-up flag that logout done via reset
            localStorage.removeItem('reset-logout');
            /*
             Usually we are logged out by call to LoginModel.processLogout()
             even if it is reset/upgrade/etc. process;
             thus clean-up the flag been set in order to not show "Successfully logged out" when <F5> button pressed
             */
            localStorage.removeItem('action-logout');
            localStorage.removeItem('session-logout');
        }
    },
   

    /**
     * prevent unsaved changes warning message
     * @returns {boolean}
     */
    pageCheckDefaultValues: function(){
        return true;
    },

    /**
     * Display restore form
     */
    displayRestoreForm: function() {
        var formRestore = $('.restore-form'),
            formSignIn = $('.sign-in-form'),
            deferred = new $.Deferred(),
            self = this;
        
        // If process is running - allow set new password
        if (swc.models.PasswordRecovery.isRecoveryRunning() && sessionStorage.getItem("changePassIncomplete")) {
            this.showChangePasswordForm();
            // Remove loading window:
            this.stopPageLoading();
            return;
        }

        /**
         * Start recovery process - after executing the confirmation code will appear on LCD display
         * @returns {*}
         */
        swc.models.EventManager = new swc.constructors.EventManager({
            events: [{"handler": "Screen"}]
        });

        this.showPageLoading("Starting Password Recovery Process...");
        
        // First, have to open channel to listen to password-recovery
        $.when(swc.models.EventManager.openChannel())
            .done(function() {
                // Create instance of EM listener
                swc.models.EventManagerListener = new swc.constructors.EventManagerListener();
                swc.models.EventManagerListener.setAjaxParameters(JSON.stringify({
                    "channelid": swc.models.EventManager.get("channelid"),
                    "events": [{"handler": "Screen"}]
                }));
                
                // Subscribe to listen if smth.changed
                swc.models.EventManagerListener.on("change", function (event, data, context) {
                    var ScreenEvent = swc.models.EventManagerListener.pop();
                    if (ScreenEvent) {
                        // stop listening on collection changes
                        swc.models.EventManagerListener.off("change");

                        // stop background event listener
                        clearInterval(self.eventsListenerInterval);
                        self.eventsListenerInterval = null;
                        
                        // User pressed "BACK" on device, we do the same - 
                        if (ScreenEvent.get('attributes').response === "Denied") {
                            // simulate click on back button
                            self.$('a[name="back"]:not(.disabled)').click();
                        } else if (ScreenEvent.get('attributes').response === "Allowed") {
                            sessionStorage.setItem("changePassIncomplete", true);
                            self.showChangePasswordForm();
                        }
                    }
                });

                $.when(swc.models.PasswordRecovery.startProcess())
                    .done(function() {
                        // Although listenChannel is a deferred, we don't need to resolve it
                        swc.models.EventManagerListener.listenChannel();
                        
                        // Check current recovery status
                        $.when(swc.models.PasswordRecovery.sync("read")).done(function(){
                            swc.views.Application.stopPageLoading();

                            // Start polling for events
                            if (!self.eventsListenerInterval) {
                                self.eventsListenerInterval = setInterval(function () {
                                    // although listenChannel is a deferred, we don't need to resolve it 
                                    swc.models.EventManagerListener.listenChannel();
                                    $.when(swc.models.PasswordRecovery.sync("read"))
                                        .done(function () {
                                            if (!swc.models.PasswordRecovery.isRecoveryRunning()) {
                                                // simulate click on back button
                                                self.$('a[name="back"]:not(.disabled)').click();
                                            }
                                        })
                                        .fail(function() {
                                            // TODO: do nothing or what?
                                        })
                                    ;
                                }, 15000);
                            }
                        });
                    });
                
                // Show page with hint about Password Recovery process
                self.showPassRecoveryHint();
                self.stopPageLoading();
                deferred.resolve();
            });
        
        return deferred.promise();
    },

    /**
     * Display Sign In form
     */
    displaySignInForm: function() {
        var formRestore = $('.restore-form'),
            formSignIn = $('.sign-in-form');

        formRestore.hide();
        formRestore.find('.info-messages .message').hide();
        formRestore.find('input').val('');

        formSignIn.show();
    },

    /**
     * Display password input as text type
     *
     * @param e {Object}
     *
     */
    displayPassword: function(e, value) {
        var inputPasswordVisible = $(this.el).find('input[name="login-password"]'),
            inputPasswordHidden = $(this.el).find('input[name="login-password-copy"]');

        inputPasswordHidden
            .val(inputPasswordVisible.val())
            .show();

        inputPasswordVisible.hide();

        inputPasswordVisible.attr('name', 'login-password-copy');
        inputPasswordHidden.attr('name', 'login-password');
    },

    copyPassword: function(e) {
        var element = $(e.target), visibleField, hiddenField;
        if(element.filter('[class*=login-password]')[0]){
            visibleField = $('input[name=login-password]');
            hiddenField = $('input[name=login-password-copy]');
        } else if(element.filter('[name*=new-password-1]')[0]){
            visibleField = $('input[name=new-password-1]');
            hiddenField = $('input[name=new-password-1-copy]');
        } else {
            visibleField = $('input[name=new-password-2]');
            hiddenField = $('input[name=new-password-2-copy]');
        }

        hiddenField.val(visibleField.val());

    },

    /**
     * Start login process
     *
     * @param e {String}
     *
     */
    processLogin: function(e) {
        var inputPasswordField = $(this.el).find('input[name="login-password"]'),
            inputLoginField = $(this.el).find('input[name="login-name"]'),
            self = this;

        if (e.type !== "keydown") {
            e.preventDefault();
        }

        if (e.which === 13 || e.type !== 'keydown') {
            if (!this.isValidationError()) {
                $.when(swc.models.Login.processLogin(inputLoginField.val(), inputPasswordField.val()))
                    .done(function(response) {
                        if (response.status) {
                            swc.router.navigate(self._determineNextPage(), { trigger: true });
                        } else {
                            self.displayWarningMessage('login');
                        }
                    })
                    .fail(function() {
                        self.displayWarningMessage('login');
                    });
            } else {
                this.displayWarningMessage('both-fields-required');
            }
        }
    },

    /**
     * Change login form (login button) state, according to inputs value
     *
     * @param e {String}
     *
     */
    updateFormState: function(e){
        var target = e ? $(e.target) : null,
            loginButton = this.$('a[name="login-button"]');

        if (target) {
            // Hiding validation if form is edited:
            if (target.val() !== target.data('old-val')) {
                $('.info-messages .message').hide();
                target.removeClass("validation-error");
            }

            target.data('old-val', target.val());
        }

        if(this.isValidationError()) {
            loginButton.addClass('disabled');
        } else {
            loginButton.removeClass('disabled');
        }
    },

    /**
     * Helper method to do all at once:
     * 1. SHOW "Change Password' form
     * 2. HIDE all other forms
     */
    showChangePasswordForm: function(){
        this.$('.restore-form').hide();
        this.$('.sign-in-form').hide();
        this.$('.change-pass-form').show();
    },

    /**
     * Helper method to do all at once:
     * 1. SHOW "Enter Activation Code" form
     * 2. HIDE all other forms
     */
    showPassRecoveryHint: function(){
        this.$('.restore-form').show();
        this.$('.sign-in-form').hide();
        this.$('.change-pass-form').hide();
    },

    /**
     * Validate login form:
     *
     * @return {Boolean}
     *
     */
    isValidationError: function() {
        var error = false,
            checkbox = this.$el.find('.swc-checkbox.display-password input'),
            inputPasswordOriginal = this.$el.find('input[name="login-password"]'),
            inputPasswordCopy = this.$el.find('input[name="login-password-copy"]'),
            inputLoginField = this.$el.find('input[name="login-name"]');

        // Copy password to original input if checkbox "Show Password" is active
        if (checkbox.prop('checked')) {
            inputPasswordOriginal.val(inputPasswordCopy.val());
        }

        if (!inputLoginField.val().length) {
            error = true;
        }

        if (!inputPasswordOriginal.val().length) {
            error = true;
        }

        return error;
    },

    /**
     * Display warning message to user:
     */
    displayWarningMessage: function(message) {
        var dialog = $('.info-messages').find('.' + message);

        dialog.show();

        // setTimeout(function() {
        //     dialog.fadeOut(function() {
        //         dialog.hide();
        //     });
        // }, 2500);

        if (message === "login"){
            $("input[name='login-password']").addClass("validation-error");
        }
    },

    // Called when user pressed "OK" on device and we go to next page
    afterOkPressed: function () {
        sessionStorage.setItem("changePassIncomplete", true);
        this.showChangePasswordForm();
    },

    /**
     * Handler for "Back" button
     * @callback
     */
    backToLogin: function () {
        var self = this;
        
        $.when(swc.models.PasswordRecovery.stopProcess())
            .done(function () {
                // We have to check current state of Password Recovery.
                // Should be "Enable", not "Processing" when "Back" is pressed.
                $.when(swc.models.PasswordRecovery.sync("read"))
                    .done(function () {
                        // stop listener
                        if (self.eventsListenerInterval) {
                            clearInterval(self.eventsListenerInterval);
                            self.eventsListenerInterval = null;
                        }

                        self.displaySignInForm();
                    });
            });
    },

    enableRecovery: function(e, value){
        swc.models.PasswordRecovery.set('recoveryEnable', value);
        this.$el.find('.save-password-button').removeClass('disabled');
    },

    /**
     * make the recovery field uppercase if you type smth in it.
     * we cannot do this in css file, because placeholder has lowercase symbols.
     * keydown + timeout works faster then keyup
     * @param e
     */
    makeUpperCase: function(e){
        var element = $(e.target);
        setTimeout(function(){
            element.css('text-transform', element.val() ? 'uppercase' : 'none');
        }, 1);
    },
    
    /**
     * Shows new password on "change password  page
     */
    showPassword: function(){
        var self = this,
            visibleField1 = this.$el.find('input[name=new-password-1]'),
            invisibleField1 = this.$el.find('input[name=new-password-1-copy]'),
            visibleField2 = this.$el.find('input[name=new-password-2]'),
            invisibleField2 = this.$el.find('input[name=new-password-2-copy]');

        invisibleField1.val(visibleField1.val());
        invisibleField2.val(visibleField2.val());

        visibleField1.attr('name', 'new-password-1-copy')
            .hide();

        invisibleField1.attr('name', 'new-password-1')
            .show();

        visibleField2.attr('name', 'new-password-2-copy')
            .hide();

        invisibleField2.attr('name', 'new-password-2')
            .show();

        self.delegateEvents();

    },

    /**
     * New password validation
     * @returns {boolean}
     */
    validatePassword: function(){
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            validationMessages = [];

        this.$('.validation-message').hide();
        this.$('input').removeClass('error valid');

        // Check initial password
        if (newPass1Val) {
            if (!window.validatePassword(newPass1Val)) {
                validationMessages.push('invalid password');
            }
        } else if (!newPass1Val) {
            validationMessages.push('invalid password');
        }
        
        if (validationMessages.length > 0) {
            newPass1.addClass('error').siblings('input').addClass('error');
            this.$('.pass1.validation-message, .pass1 .validation-message, .pass1 .error-message').show();
        } else {
            newPass1.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    },

    /**
     * Check if password confirmed right
     * @returns {boolean}
     */
    validatePasswordsMatch: function () {
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            newPass2 = this.$('input[name=new-password-2]'),
            newPass2Val = $.trim(newPass2.val()),
            validationMessages = [];

        // Check confirmation password
        if (newPass2Val) {
            if (newPass1Val !== newPass2Val) {
                validationMessages.push('passwords do not match');
            }
        } else {
            validationMessages.push('passwords do not match');
        }

        if (validationMessages.length > 0) {
            newPass2.addClass('error').siblings('input').addClass('error');
            this.$('.pass2.validation-message, .pass2 .validation-message, .pass2 .error-message').show();
        } else {
            newPass2.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    },

    /**
     * activate apply button on "change password" page
     */
    activateButtons: function () {
        this.$('.save-password-button').removeClass('disabled');
    },

    /**
     * Executes when we change the device password
     */
    applyPassword: function () {
        var self = this,
            currentPass = this.$('input[name=current-password]').val(),
            newPass1 = this.$('input[name=new-password-1]').val();

        this.$('.save-success, .save-error').hide();
        
        if (this.validatePasswordsMatch()) {
            this.showPageLoading("Applying changes...");
            $.when(swc.models.PasswordRecovery.setNewPassword(newPass1))
                .done(function(result){
                    // When no response, that means that everythins went fine, aka "Linux-style-error-handling" :-) 
                    if (result) {
                        self.stopPageLoading();
                        this.$('.info-messages .internal-error').show();
                    } else {
                        // Mark "change password" procedure as complete (finished)
                        sessionStorage.removeItem("changePassIncomplete");
                        
                        // NP replies immediately, but new password is not applied yet - wait for a while
                        setTimeout(function () {
                            // Now we have to automatically sign in
                            $.when(swc.models.Login.processLogin(swc.models.Login.adminName, newPass1))
                                .done(function() {
                                    // We only able to set password recovery after successfully signed it
                                    $.when(swc.models.PasswordRecovery.sync("update")).done(function () {
                                        // re-read status of password-recovery; otherwise will miss it after update
                                        swc.models.PasswordRecovery.sync("read");
                                    });
                                    // When everything done - move 
                                    swc.router.navigate(self._determineNextPage(), { trigger: true });
                                });
                        }, 1000);
                    }
                });
        }
    },

    /**
     * Update application locale based on dropdown value
     */
    setLocale: function(e, value) {
        $.when(swc.models.Locale.setLocale(value)).done(function() {
            swc.views.Login.renderComplete(true);
        });
    },

    /**
     * Determines to where redirect user after they successfully logged in - either overview or previous page
     * @private
     */
    _determineNextPage: function() {
        var previousPage = localStorage.getItem('previous-page'),
            location = 'overview';

        // Define page where user has to be navigated to:
        if (previousPage && _.indexOf(['login', 'remote-login'], previousPage) === -1) {
            location = previousPage;
        }
        
        // clear information about previous page 
        localStorage.removeItem('previous-page');
        
        return location;
    }

});
;// This is just to support correct routing implementation
swc.constructors.RemoteloginView = _.extend(swc.constructors.LoginView, {});;swc.constructors.NetworkDevicesView = swc.base.PageView.extend({

    className: 'network-device-list',

    events: {
        'expandable:delete .expandable-list': 'removeDevice',

        'click .wps-pairing:not(.disabled)': 'startWpsPairing',

        'click .customize-device': 'editDevice',

        'hover .expandable-list-item:not(.expanded) .block.device-name': 'highlightIcon'
    },

    models: [
        'NetworkDevices',
        'DHCPLeases',
        'PortForwarding',
        'FirewallStatus',
        'Schedulers'
    ],

    listenerEnabled: true,

    listenerPages: [
        'network-devices'
    ],
    
    highlightIcon: function(event){
        var $icon = $(event.target).closest('.device-name').find('.device.small');

        if (event.type === 'mouseenter') {
            $icon.addClass('selected');
        } else {
            $icon.removeClass('selected');
        }
    },

    setTemplateData: function() {
        var self = this,
            devices = swc.models.NetworkDevices.getDevicesList(),
            DHCPLeases = _.pluck(swc.models.DHCPLeases.getActiveLeases(), 'MACAddress');

        var updatedDevices = _.map(devices, function (originalDevice) {
            var aDevice = _.clone(originalDevice, true);
            
            if( _.contains(DHCPLeases, aDevice.mac)) {
                aDevice.address['static'] = true;
            }

            if (aDevice.addressObjects.IPv6.length > 0) {
                $.each(aDevice.addressObjects.IPv6, function(addressKey, value) {
                    aDevice.address.IPv6[addressKey] = swc.Utils.formatIPv6Address(value.ipAddress);
                });
            }
            aDevice['portForwarding'] = self.getPortForwardingInfo(aDevice.address.IPv4);
            aDevice['parentalControlStatus'] = self.getParentalControlStatus(aDevice.mac);
            
            return aDevice;
        });
        
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            devices: updatedDevices,
            IPv6Enabled: swc.models.FirewallStatus.get('state').Enable
        };
    },

    loadModels: function(){
        var deferred = new $.Deferred();

        // Check if current page has any models:
        if (!this.models.length) {
            return deferred.resolve();
        } else {
            var temporary = [];

            // Fill in array with models to be called before page render:
            $.each(this.models, function(key, value) {
                if (!swc.models[value]) {
                    swc.models[value] = new swc.constructors[value]();
                }

                temporary.push(
                    swc.models[value].fetch()
                );
            });

            temporary.push(swc.models.Schedulers.getDevicesSchedulers());
            // Wait till all models will be fetched and process callback:
            $.when.apply(null, temporary)
                .done(function() {
                    return deferred.resolve();
                })
                .fail(function() {
                    return deferred.reject();
                });
        }

        return deferred.promise();

    },

    renderComplete: function() {},

    getParentalControlStatus: function(mac) {
        var status = false,
            scheduler = swc.models.Schedulers.get(mac);

        if (scheduler) {
            status = scheduler.get('enable');
        }

        return status;
    },

    getPortForwardingInfo: function(ip) {
        var objects = swc.models.PortForwarding.where({"deviceIP": ip}),
            jsonData = _.map(objects, function(item) {
                return item.attributes;
            });

        return jsonData;
    },

    removeDevice: function(e, mac){
        var self = this,
            ruleItem = $('.expandable-list-item[data-key="' + mac + '"]');

        ruleItem.fadeOut(function(){
            ruleItem.remove();
        });

        swc.models.NetworkDevices.removeDevice(mac);
    },

    editDevice: function(e) {
        var self = this,
            element = $(e.target),
            type = element.data('type'),
            macAddress = element.data('macaddress'),
            device = swc.models.NetworkDevices.getDevice(macAddress);

        this.customizeDevice({
            device: device,
            type: type,

            onApply: function(options) {
                self.showPageLoading("Updating device information");

                $.when(swc.models.NetworkDevices.customizeDevice(options)).done(function() {
                    self.render();
                });
            }
        });
    },

    startWpsPairing: function() {
        // lazy mixin:
        _.extend(this, swc.constructors.WpsPairingMixin);
        this.startWpsPairing();
    }

});
;swc.constructors.NetworkSettingsDyndnsView = swc.base.TabView.extend({

    className: 'dyndns',

    models: [
        'DynDNS',
        'DynDNSProviderCollection'
    ],
    
    allowedMods: ['expert'],
    
    settingsFormTemplate: '',
    
    events: {
        'keyup input.password-original': 'updatePasswordsChange',
        'keyup input.password-copy': 'updatePasswordsChange',
        'swc-checkbox:change .swc-checkbox.show-password': 'setPasswordState',
        'swc-dropdown:change .swc-dropdown.provider-selection': 'changeService',
        'swc-checkbox:change .swc-checkbox.DynDNSEnable': 'setGlobalState'
    },
    
    validation: {
        'Service': 'DynDNSProvider:service',
        'hostname': 'DynDNSProvider:hostname',
        'username': 'DynDNSProvider:username',
        'password': 'DynDNSProvider:password'
    },

    setTemplateData: function() {
        this.templateData = {
            dyndnsStatus: swc.models.DynDNS.get('enable')
        };
    },
    
    initialize: function () {
        swc.base.TabView.prototype.initialize.apply(this, arguments);
        
        // Prepare template for the settings form:
        this.settingsFormTemplate = $.template("settingsForm",
            swc.Templates.get("network:settings:dyndns:service-settings-form").get('content'));
    },

    renderComplete: function() {
        var self = this;
        
        if (!swc.models.DynDNSServiceCollection) {
            swc.models.DynDNSServiceCollection = new swc.constructors.DynDNSServiceCollection();
        }
        
        $.when(swc.models.DynDNSServiceCollection.fetch())
            .done(function() {
                // Find currently active provider and set it as selected
                var provider = swc.models.DynDNSProviderCollection.findWhere({enable: true}),
                    defaultProvider = swc.models.DynDNSServiceCollection.at(0),
                    providerId = provider ? provider.get('service') : '';
                
                // According to requirements, when no providers configured yet - 
                // first element in option list should be selected 
                if (!providerId) {
                    providerId = defaultProvider ? defaultProvider.get('id') : '';
                }
                
                self.changeService(null, providerId);
                self.setProvidersData(providerId);
                self.showState();
            });
    },

    showState: function() {
        var state = swc.models.DynDNS.get('enable');

        this.$('.swc-dropdown, .swc-checkbox.show-password').toggleClass('disabled', !state);
        
        this.setPageState(state, {disabledBlockClass: "faded"});

        if (state === false) {
            this.showDisabledMessage({
                container: '.dynDnsOffMessage',
                className: 'above'
            });
            this.$('input').attr('disabled', 'disabled');
        } else {
            this.hideDisabledMessage();
            this.$('input').removeAttr('disabled');
        }
    },

    /**
     * Set active provider as selected in dropdown list
     * 
     * @param {String} providerId
     */
    setProvidersData: function(providerId) {
        var options = swc.models.DynDNSServiceCollection.formatProvidersOptions(),
            dropdown = this.$('.provider-selection');
        
        dropdown.data('options', options);
        dropdown.data('default-value', providerId);
        dropdown.trigger('swc-dropdown:swc-change', providerId);
    },

    /**
     * Show form with auth data for the selected service 
     * @param e
     * @param {String} value Provider to select
     */
    changeService: function(e, value) {
        moment.lang(swc.models.Locale.locale);

        var provider = swc.models.DynDNSProviderCollection.findWhere({service: value}),
            dnsProviderData;
        
        if (!_.isEmpty(provider)) {
            var lastUpdate = provider.get('last_update');

            if (lastUpdate && lastUpdate !== "0001-01-01T00:00:00Z") {
                lastUpdate = moment(lastUpdate).zone(lastUpdate).format("DD.MM.YYYY, HH:mm");
            } else {
                lastUpdate = '';
            }

            dnsProviderData = {
                service: provider.get('service').capitalize(),
                status: provider.get('status'),
                lastUpdate: lastUpdate
            };
        }

        // Render template with data
        var tmpl = $.tmpl(this.settingsFormTemplate, {
                service: provider ? provider.attributes : (new swc.constructors.DynDNSProvider()).attributes,
                localeString: getTranslationStringsjQuery,
                localeStrings: swc.models.Locale.getLocaleStrings(),
                dyndnsStatus: swc.models.DynDNS.get('enable'),
                dnsProviderData: dnsProviderData
            }),
            settingsFormContainer = this.$(".table.provider-data");
        
        // Render template
        settingsFormContainer.html(tmpl);
    },

    /**
     * Show textual representation of a password.
     * Uses addition hidden field to store clone of value been input into password field.
     * 
     * @param e
     * @param value
     */
    setPasswordState: function(e, value) {
        var providerSettingsFormContainer = this.$('.table.provider-data'),
            passwordOrigBox = providerSettingsFormContainer.find('input.password-original'),
            passwordCopyBox = providerSettingsFormContainer.find('input.password-copy');

        if (value) {
            passwordOrigBox.hide();
            passwordCopyBox.show();
        } else {
            passwordCopyBox.hide();
            passwordOrigBox.show();
        }
    },

    /**
     * Copies value from password field into hiddent text field char-by-char. 
     * @param e
     */
    updatePasswordsChange: function(e) {
        var providerSettingsFormContainer = this.$('.table.provider-data'),
            passwordOrigBox = providerSettingsFormContainer.find('input.password-original'),
            passwordCopyBox = providerSettingsFormContainer.find('input.password-copy');

        // Copy values from one to another and vice-versa
        if (passwordOrigBox.is(":visible")) {
            passwordCopyBox.val(passwordOrigBox.val());
        } else {
            passwordOrigBox.val(passwordCopyBox.val());
        }
    },

    setGlobalState: function (e, value) {
        swc.models.DynDNS.set('enable', value);
        this.showState();
    },
    
    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            pageData = {},
            dynDnsStatus = swc.models.DynDNS.get('enable');

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            var parameter = getParameter($(element));
            pageData[parameter['parameterName']] = parameter['parameterValue'];
        });
        
        // Fill in data for selected service provider
        var provider = new swc.constructors.DynDNSProvider({
            'service': pageData['Service'],
            'hostname': pageData['hostname'],
            'username': pageData['username'],
            'password': pageData['password'],
            'enable': true
        });
        
        /**
         * Add newly created provider
         * 
         * @private
         * 
         * @return Deferre.Promise
         */
        var addNewProvider = function() {
            // Add newly created provider 
            $.when(provider.sync("create"))
                .done(function (response) {
                    if (response.status === true) {
                        // Re-read collection of added hosts
                        swc.models.DynDNSProviderCollection.fetch();
                        deferred.resolve();
                    } else {
                        deferred.reject("Fill in all fields");
                    }
                })
                .fail(function (xhr, error, status) {
                    deferred.reject(status);
                });
        };
        
        // Update global DynDNS status & save new DynDNS provider marked as 'enabled'
        $.when(swc.models.DynDNS.sync("update"))
            .done(function (response) {
                // Do not re-add services if we deactivated DynDNS globally
                if (dynDnsStatus) {
                    // we actually always will have only one item in collection
                    var todo = [];

                    swc.models.DynDNSProviderCollection.forEach(function (aProvider) {
                        todo.push(aProvider.destroy());
                    });

                    $.when.apply(this, todo)
                        .done(function () {
                            addNewProvider();
                        })
                        .fail(function (xhr, error, status) {
                            deferred.reject();
                        });
                } else {
                    deferred.resolve();
                }
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});
;swc.constructors.NetworkSettingsIpv6firewallAddView = swc.base.TabView.extend({

    className: 'ipv6-firewall-rules-add',

    allowedMods: [ 'expert' ],

    events: {
        'swc-radio-buttons:change .swc-radio-buttons.service-mode': 'onRulesModeChange',
        'swc-radio-buttons:change .swc-radio-buttons.ports-mode': 'onPortsModeChange',
        'swc-radio-buttons:swc-change .swc-radio-buttons.ports-mode': 'onPortsModeChange',

        'swc-dropdown:change .swc-dropdown.policy-selection': 'onPolicyChange',
        'swc-dropdown:change .swc-dropdown.service-name-selection': 'onPredefinedRuleSelection'
    },

    models:[
        'FirewallPolicy',
        'FirewallRules'
    ],

    validation: {
        'RuleName': 'FirewallRules:RuleName',
        'RulePort': 'FirewallRules:RulePort',
        'PredefinedRuleName': 'FirewallRules:PredefinedRuleName'
    },

    setTemplateData: function() {
        this.templateData = {
            isAdding: true,
            predefinedRulesList: swc.models.FirewallRules.predefined,
            ruleType: "custom",
            ruleName: "",
            ruleProtocol: "6,17",
            rulePortsMode: "single",
            rulePorts: [ "" ],
            rulePolicy: "Drop_inbound"
        };
    },

    initialize: function() {
        this.template = $.template("pageContent", swc.Templates.get('network:settings:ipv6-firewall:rules-add').get('content'));
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    renderComplete: function() {
        this.setPredefinedRulesDropdown();
        this.resetFormValues();
    },

    /**
     * Reset rule adding / editing form to its default values
     *
     * @description:
     *
     * If values are passed:
     *
     *  Page will be filled in with values which are passed as arguments to the function.
     *
     * If values are not passed:
     *
     *  Page will be filled in with values which are set in <this.templateData>
     *
     * @param values {Object} same structure as <this.templateData>
     */
    resetFormValues: function(values) {
        var formValues = !_.isUndefined(values) ? values : this.templateData,
            $ruleNameInput = this.$('input[name="RuleName"]'),
            $rulePortFromInput = this.$('input[name="RulePort"].from'),
            $rulePortToInput = this.$('input[name="RulePort"].to'),
            $ruleTypeRadioGroup = this.$('.swc-radio-buttons.service-mode'),
            $rulePortRadioGroup = this.$('.swc-radio-buttons.ports-mode'),
            $ruleNameDropdown = this.$('.swc-dropdown.service-name-selection'),
            $ruleProtocolDropdown = this.$('.swc-dropdown.protocol-selection'),
            $rulePolicyDropdown = this.$('.swc-dropdown.policy-selection');

        // Update page dropdown values:
        this.setProtocolDropdown(formValues.ruleProtocol);
        this.setPolicyDropdown(formValues.rulePolicy);

        // Remove all previous validation messages:
        this.clearValidationMessages();

        // Reset rule name:
        $ruleNameInput.val(formValues.ruleName);

        // Reset rule protocol value:
        $ruleProtocolDropdown.trigger('swc-dropdown:swc-change', formValues.ruleProtocol);

        // Reset rule ports and rule ports mode:
        $rulePortFromInput.val(formValues.rulePorts[0]);
        $rulePortRadioGroup.trigger('swc-radio-buttons:swc-change', formValues.rulePortsMode);

        if (formValues.rulePortsMode === "range") {
            $rulePortToInput.val(formValues.rulePorts[1]);
        } else {
            $rulePortToInput.val("");
        }

        // Reset rule policy value:
        $rulePolicyDropdown.trigger('swc-dropdown:swc-change', formValues.rulePolicy);
    },

    /**
     * Handler for changing rule adding type:
     *
     * @param e {Object}
     * @param value {String}
     */
    onRulesModeChange: function(e, value) {
        var type = !_.isUndefined(value) ? value : this.templateData.ruleType;

        if (type === "predefined") {
            this.onPredefinedRuleSelection();
        } else {
            this.resetFormValues();
        }

        this.$('.rule-name-section').toggleClass("type-predefined", value === "predefined");

        this.setButtonsState();
    },

    /**
     * Handler for changing rule ports mode (single / range):
     *
     * @param e {Object}
     * @param value {String}
     */
    onPortsModeChange: function(e, value) {
        var type = !_.isUndefined(value) ? value : this.templateData.rulePortsMode;

        if (value !== "range") {
            this.$('input[name="RulePort"].to').val("");
        }

        this.$('.ports-values-section').toggleClass("range-type", value === "range");
    },

    /**
     * Handler for changing predefined rules dropdown:
     *
     * @param e {Object}
     * @param value {Value}
     */
    onPredefinedRuleSelection: function(e, value) {
        var dropdown = this.$('.swc-dropdown.service-name-selection'),
            ruleKey = dropdown.data('value'),
            ruleData = {};

        // Override dropdown value with new value:
        if (!_.isUndefined(value)) {
            ruleKey = value;
        }

        // Get rule data from list of prdefined rules:
        ruleData = _.findWhere(this.templateData.predefinedRulesList, { name: ruleKey });

        // Reset form values with predefined rule:
        this.resetFormValues({
            ruleType: "predefined",
            ruleName: ruleData.name,
            ruleProtocol: ruleData.protocol,
            rulePortsMode: ruleData.port.length === 1 ? "single" : "range",
            rulePorts: ruleData.port,
            rulePolicy: 'Drop_inbound'
        });
    },

    /**
     * Handler for changing policy mode dropdown:
     *
     * @param e {Object}
     * @param value {Value}
     */
    onPolicyChange: function(e, value) {
        this.pageValidation(true);
    },

    /**
     * Add options to protocol dropdown
     *
     * @param value {String} (optional)
     */
    setProtocolDropdown: function(value) {
        var dropdown = this.$('.swc-dropdown.protocol-selection'),
            dropdownValue = !_.isUndefined(value) ? value : this.templateData.ruleProtocol,
            options = [
                { name: getTranslationStrings("TCP/UDP"), value: "6,17" },
                { name: getTranslationStrings("TCP"),     value: "6"    },
                { name: getTranslationStrings("UDP"),     value: "17"   }
            ];

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', dropdownValue);
    },

    /**
     * Add options to policy dropdown
     *
     * @param value {String} (optional)
     */
    setPolicyDropdown: function(value) {
        var dropdown = this.$('.swc-dropdown.policy-selection'),
            dropdownValue = !_.isUndefined(value) ? value : this.templateData.rulePolicy,
            options = [
                { value: "Drop_inbound", name: getTranslationStrings("Block inbound") },
                { value: "Drop_outbound", name: getTranslationStrings("Block outbound") },
                { value: "Accept_inbound", name: getTranslationStrings("Allow inbound") },
                { value: "Accept_outbound", name: getTranslationStrings("Allow outbound") }
            ];

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', dropdownValue);
    },

    /**
     * Add options to predefined rules dropdown
     */
    setPredefinedRulesDropdown: function() {
        var rules = this.templateData.predefinedRulesList,
            dropdownValue = rules[0].name,
            dropdown = this.$('.swc-dropdown.service-name-selection'),
            options = [];

        // Create dropdown options object:
        _.each(rules, function(rule, key) {
            options.push({
                name: rule.name,
                value: rule.name
            });
        });

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', dropdownValue);
    },

    /**
     * Serialize all page data to JSON object
     *
     * @returns {Object}
     */
    serializePageData: function() {
        var jsonData = {},
            $ruleKeyInput = this.$('input[name="RuleKey"]'),
            $ruleNameInput = this.$('input[name="RuleName"]'),
            $rulePortFromInput = this.$('input[name="RulePort"].from'),
            $rulePortToInput = this.$('input[name="RulePort"].to'),
            $ruleTypeRadioGroup = this.$('.swc-radio-buttons.service-mode'),
            $rulePortRadioGroup = this.$('.swc-radio-buttons.ports-mode'),
            $ruleNameDropdown = this.$('.swc-dropdown.service-name-selection'),
            $ruleProtocolDropdown = this.$('.swc-dropdown.protocol-selection'),
            $rulePolicyDropdown = this.$('.swc-dropdown.policy-selection');

        // Handle edit / add mode
        if ($ruleTypeRadioGroup.data('value') === 'custom') {
            if ($ruleKeyInput.size()) {
                jsonData.id = $ruleKeyInput.val();
            } else {
                jsonData.id = $ruleNameInput.val();
            }

            jsonData.name = $ruleNameInput.val();
        } else {
            jsonData.id = $ruleNameDropdown.data('value');
            jsonData.name = $ruleNameDropdown.data('value');
        }

        // Protocol dropdownd handling:
        jsonData.protocol = $ruleProtocolDropdown.data('value');

        // Policy dropdownd handling:
        jsonData.policy = $rulePolicyDropdown.data('value').split('_')[0];
        jsonData.policyTarget = $rulePolicyDropdown.data('value').split('_')[1];

        // Add hash to rule id in adding mode:
        if (!_.isUndefined(this.templateData.isAdding)) {
            if (jsonData.policyTarget === 'inbound') {
                jsonData.id = swc.Utils.generateId() + '_inbound';
            } else {
                jsonData.id = swc.Utils.generateId() + '_outbound';
            }
        }

        // Add chain target to rule:
        if (jsonData.policyTarget === 'inbound') {
            jsonData.chain = 'Custom_V6In';
        } else {
            jsonData.chain = 'Custom_V6Out';
        }

        // Handle edit / add mode
        jsonData.status = !_.isUndefined(this.templateData.ruleState) ? this.templateData.ruleState : true;

        // Single / range port mode handling:
        if ($rulePortRadioGroup.data('value') === "single") {
            jsonData.port = [ $rulePortFromInput.val() ];
        } else {
            jsonData.port = [ $rulePortFromInput.val(), $rulePortToInput.val() ];
        }

        return jsonData;
    },

    /**
     * @override
     *
     * On this page it's needed to handle only "save" button state:
     *
     * @param e {Object}
     * @param toDisable {Boolean}
     */
    setButtonsState: function(e, toDisable) {
        var container = this.$('.buttons-container-message'),
            buttonSave = container.find('.button.save-changes'),
            allValuesDefault = this.pageCheckDefaultValues();

        buttonSave.toggleClass('disabled', toDisable || allValuesDefault);
    },

    /**
     * @override
     *
     * On this page cancel changes button should redirect user to other page:
     */
    cancelChanges: function() {
        swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
    },

    /**
     * @override
     *
     * On this page save changes button should redirect user to other page after saving complete:
     */
    save: function() {
        var ruleData = this.serializePageData(),
            deferred = new $.Deferred();


        $.when(swc.models.FirewallRules.createRule(ruleData))
            .done(function() {
                localStorage.setItem('firewall:change-rule', 'done');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            })
            .fail(function() {
                localStorage.setItem('firewall:change-rule', 'fail');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            });

        return deferred.promise();
    }
});
;swc.constructors.NetworkSettingsIpv6firewallEditView = swc.constructors.NetworkSettingsIpv6firewallAddView.extend({

    initialize: function() {
        this.template = $.template("pageContent", swc.Templates.get('network:settings:ipv6-firewall:rules-edit').get('content'));
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    setTemplateData: function() {
        var ruleID = localStorage.getItem('firewal:edit-ruleID'),
            rule = swc.models.FirewallRules.get(ruleID);

        this.rule = ruleID;

        if (!ruleID || !rule) {
            swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
        }

        this.templateData = {
            predefinedRulesList: swc.models.FirewallRules.predefined,
            ruleType: "custom",
            ruleKey: rule.get('id'),
            ruleState: rule.get('status'),
            ruleName: rule.get('name'),
            ruleProtocol: rule.get('protocol'),
            rulePortsMode: rule.get('port').length === 1 ? "single" : "range",
            rulePorts: rule.get('port'),
            rulePolicy: rule.get('policy'),
            ruleChain: rule.get('chain')
        };
    },

    /**
     * @override
     *
     * On this page save changes button should redirect user to other page after saving complete:
     */
    save: function() {
        var rulePrevious = swc.models.FirewallRules.findWhere({ id: this.rule }).toJSON(),
            ruleNew = this.serializePageData(),
            deferred = new $.Deferred();

        $.when(swc.models.FirewallRules.changeRule(rulePrevious, ruleNew))
            .done(function() {
                localStorage.setItem('firewall:change-rule', 'done');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            })
            .fail(function() {
                localStorage.setItem('firewall:change-rule', 'fail');
                swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
            });

        return deferred.promise();
    }
});
;swc.constructors.NetworkSettingsIpv6firewallCustomizeView = swc.base.TabView.extend({

    className: 'ipv6-firewall-rules-list',

    allowedMods: ['expert'],

    events: {
        'click .expandable-list .trash.process-delete:not(.disabled)': 'deleteRule',
        'click .expandable-list .pencil.process-edit:not(.disabled)': 'editRule',

        'swc-checkbox:change .swc-checkbox.enable-service': 'setRuleState'
    },

    models:[
        'FirewallPolicy',
        'FirewallRules'
    ],

    rulesToDelete: [],

    rulesToChangeState: {},

    setTemplateData: function() {
        var firewallRules = swc.models.FirewallRules.toJSON();

        this.templateData = {
            rules: firewallRules,
            rulesArrayLength: getObjectLength(firewallRules)
        };
    },

    initialize: function() {
        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get('network:settings:ipv6-firewall:rules-list').get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    renderComplete: function() {
        var policyOptions = swc.models.FirewallPolicy.formatPolicyOptions(),
            policyValue = swc.models.FirewallPolicy.getValue(),
            dropdownPolicy = this.$el.find('.swc-dropdown.policy-selection'),
            isRuleActionSuccess = localStorage.getItem('firewall:change-rule');

        // Display rule saving success or fail message:
        if (!_.isNull(isRuleActionSuccess)) {
            this.showSaveSuccess(isRuleActionSuccess === "done" ? 'success' : 'error', true);
            localStorage.removeItem('firewall:change-rule');
        }

        this.fillDropdown(dropdownPolicy, policyOptions, policyValue);
    },

    fillDropdown: function(dropdown, data, selected) {
        for (var defaultAction in data) {
            break;
        }

        dropdown.data('options', data);

        if (selected) {
            dropdown.data('default-value', selected);
            dropdown.trigger('swc-dropdown:swc-change', selected);
        } else {
            dropdown.data('default-value', defaultAction);
            dropdown.trigger('swc-dropdown:swc-change', defaultAction);
        }
    },

    deleteRule: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            ruleItem = this.$el.find('.expandable-list-item[data-key="' + ruleID + '"]'),
            storage = this.$el.find('input[name="rules-to-delete"]');

        this.rulesToDelete.push(ruleID);

        // The only way for now to handle deletion change on the page
        storage.val('action-happened');

        // Remove this from list of changed state rules (anyway it will be deleted)
        if (this.rulesToChangeState[ruleID]) {
            delete this.rulesToChangeState[ruleID];
        }

        // Remove item from the list
        ruleItem.remove();

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    setRuleState: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            storage = this.$el.find('input[name="rules-to-delete"]');

        // The only way for now to handle editing of custom change on the page
        if (value !== parameter.parameterData.defaultValue) {
            this.rulesToChangeState[ruleID] = {
                value: value
            };
        } else {
            if (this.rulesToChangeState[ruleID]) {
                delete this.rulesToChangeState[ruleID];
            }
        }
    },

    editRule: function(e, value) {
        var parameter = getParameter($(e.target));

        localStorage.setItem('firewal:edit-ruleID', parameter.parameterData.rule);

        swc.router.navigate('network/settings/ipv6-firewall/edit', { trigger: true });
    },

    /**
     * @override
     * @description:
     *
     *  Display message from editing / adding rules:
     */
    showSaveSuccess: function(type, isFromRulePage) {
        var messageNew = this.$('.buttons-container-message .save-' + (type || 'success'));

        // Hide previous messages:
        this.$('.buttons-container-message .save-error').hide();
        this.$('.buttons-container-message .save-success').hide();

        // Defined what message to show:
        if (!_.isUndefined(isFromRulePage)) {
            messageNew = messageNew.filter('.from-rule');
        } else {
            messageNew = messageNew.filter(':not(.from-rule)');
        }

        messageNew.show();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            deferredActions = [],
            pageData = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Create list of actions to be done:
        deferredActions = [
            swc.models.FirewallRules.updateRulesList(self.rulesToChangeState, self.rulesToDelete),
            swc.models.FirewallPolicy.setValue(pageData)
        ];

        $.when.apply(null, deferredActions)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});
;swc.constructors.NetworkSettingsIpv6firewallView = swc.base.TabView.extend({

    className: 'ipv6-firewall',

    allowedMods: ['expert'],

    events: {
        "click .button-customize:not(.disabled)": "customizeFirewall",
        "swc-radio-buttons:change .security-selection": "setCustomizeButtonState",
        "swc-checkbox:change .IPv6Enable" : "changeFirewallState"
    },

    models:[
        'FirewallStatus'
    ],

    validation:{
        "RuleName":"FirewallCustomRules:RuleName",
        "DestinationPortsRange": "FirewallCustomRules:DestinationPortsRange"
    },
    
    hasChanged: function() {
        return !this.pageCheckDefaultValues();
    },

    setTemplateData: function() {
        var firewallModel = swc.models.FirewallStatus,
            posibleLevels =  _.invert(firewallModel.possibleStatus);

        this.templateData = {
            IPv6Status: firewallModel.get("state").Enable,
            securityLevel: posibleLevels[firewallModel.get('status')]
        };
    },

    customizeFirewall: function() {
        if (!this.hasChanged()) {
            swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
        } else {
            $.when(this.save())
                .done(function() {
                    swc.router.navigate('network/settings/ipv6-firewall/customize', { skipUnsavedChanges: true });
                });
        }
    },

    setCustomizeButtonState: function(e, policyState) {
        this.$('.button-customize').toggleClass('disabled', policyState !== "custom");
    },

    changeFirewallState: function(e, value) {
        var selectedLevelRadio = this.$(".swc-radio-buttons .mode.active");
        
        swc.models.FirewallStatus.set('state', {"Enable": value});
        this.$('.security-selection').toggleClass('disabled', !value);
        
        if (!value || (value && selectedLevelRadio.data("value") !== "custom")) {
            this.$('.button-customize').addClass('disabled');
        } else if (value && selectedLevelRadio.data("value") === "custom"){
            this.$('.button-customize').removeClass('disabled');
        }
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            pageData = [],
            actionsToDo = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        actionsToDo = [
            swc.models.FirewallStatus.saveSettedLevel(pageData),
            swc.models.FirewallStatus.saveFirewallState(pageData)
        ];

        // Process save request:
        $.when.apply(null, actionsToDo)
            .done(function() {
                return deferred.resolve();
            })
            .fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});
;swc.constructors.NetworkSettingsIpsettingsView = swc.base.TabView.extend({

    className: 'ip-settings',

    models: [
        'NetworkDevices',
        'DHCPLeases'
    ],

    validation: {
        'Address': 'Network:validateIPAddress',
        'Netmask': 'Network:validateNetmask',
        'DHCPRange': 'Network:validateDHCPSettings',
        'DHCPLeaseIPAddress': 'DHCPLeases:validateIP',
        'DHCPLeaseNewDevice': 'DHCPLeases:validateNewDevice',
        'DMZIPAddress': 'Network:validateDMZ'
    },

    events: {
        'swc-checkbox:change .swc-checkbox.DHCPEnable': 'setDHCPState',
        'swc-checkbox:change .swc-checkbox.enable-dmz': 'setDMZState',
        'swc-dropdown:change .swc-dropdown.dhcplease-device-selection': 'selectDHCPLeaseDevice',
        'change input[name="Address"],input[name="DHCPRange"],input[name="Netmask"]': 'revalidateForm',
        'keyup input[name="Address"],input[name="Netmask"]': 'updateSubnetInfo',

        'expandable:edit .expandable-list.dhcp-leases-list': 'setEditLease',
        'expandable:delete .expandable-list.dhcp-leases-list': 'deleteDHCPLease'
    },

    setTemplateData: function() {
        var validation = swc.models.Network.validation,
            Address = swc.models.Network.get('ip-settings').get('LocalIPAddress'),
            Netmask = swc.models.Network.get('ip-settings').get('Netmask');

        this.templateData = {
            'Address': Address,
            'Netmask': Netmask,
            'DHCPMin': swc.models.Network.get('ip-settings').get('DHCPStart'),
            'DHCPMax': swc.models.Network.get('ip-settings').get('DHCPFinish'),
            'DHCPState': swc.models.Network.get('ip-settings').get('DHCPStatus'),
            'DHCPLeases': swc.models.DHCPLeases.getActiveLeases(),
            'AddressRange' : validation.getAllowedHostRange(validation.ipStringToDecimal(Address), validation.ipStringToDecimal(Netmask))
        };
    },

    revalidateForm: function(e) {
        var elem = $(e.currentTarget);

        if (!elem.hasClass('validation-error')) {
            this.pageValidation();
        }
    },

    renderComplete: function() {
        var self = this,
            ipAddressBox = this.$el.find('input[name="Address"]'),
            DHCPMinBox = this.$el.find('input[name="DHCPRange"].range-from'),
            DHCPMaxBox = this.$el.find('input[name="DHCPRange"].range-to');

        // Listener for IP Address field change
        ipAddressBox.on('validation-success', function() {
            self.updateDHCPSettings();
            self.pageValidation(DHCPMinBox, false);
            self.pageValidation(DHCPMaxBox, false);
        });

        this.setDevicesDropdown();
        this.setDMZData();

        $('input, textarea').placeholder();
    },

    pageCheckDefaultValues: function() {
        var validation = swc.base.PageView.prototype.pageCheckDefaultValues.apply(this, arguments);

        if (this.$('.expandable-list-item.deleted').length > 0) {
            return false;
        }

        return validation;
    },

    setDevicesDropdown: function() {
        var dropdown = this.$('.dhcplease-device-selection'),
            selectedDevices = swc.models.DHCPLeases.toJSON(),
            options = swc.models.NetworkDevices.getDeviceDropdownOptions({'filter': 'DHCPLeases'}),
            defaultDevice = options[0];

        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', defaultDevice);
    },

    /**
     * Event handler: is fired on changing device in the dropdown list
     *
     * @param e
     * @param value
     */
    selectDHCPLeaseDevice: function(e, value) {
        var $select = $(e.currentTarget),
            $item = $select.parents('.expandable-list-item'),
            $mac = $item.find('.lease-mac-address input'),
            $ip = $item.find('.lease-ip-address input'),
            device = swc.models.NetworkDevices.getDevice(value);

        $mac.val(value);

        if (device && device.address && device.status) {
            $ip.val(device.address.IPv4);
        } else {
            $ip.val('');
        }

        // Set editing flag to let view know that page changed:
        this.$('.edit-form-flag').val(value);

        // if it's an item for new lease then trigger its edit event
        if ($item.is('.new-dhcplease-form')) {
            this.$('.expandable-static-ip .expandable-list').trigger('expandable:edit', 'newItem');
        }

        this.setButtonsState();
    },

    /**
     * Close sibling items in the expandable list
     *
     * @param $item {jQuery element}
     */
    closeSiblingItems: function($item) {
        var self = this;

        $item.siblings('.expandable-list-item.mode-editing').each(function() {
            var dataKey = $(this).data('key');
            self.$('.expandable-list').trigger('expandable:swc-no-edit', dataKey);
        });
    },

    /**
     * Switch validation of elements in the sibling items
     * by adding/removing class 'skip-validation' to them
     *
     * if on === true then add validation (remove class 'skip-validation')
     * if on === false then remove validation (add class 'skip-validation')
     *
     * @param $item {jQuery element}
     * @param on {Boolean}
     */
    setValidationOnSiblingItems: function($item, on) {
        $item.siblings('.expandable-list-item').each(function() {
            $(this).find('input, .swc-dropdown').toggleClass('skip-validation', !on);
        });
    },

    /**
     * Switch validation of elements in the currently edit item
     * by adding/removing class 'skip-validation' on them
     *
     * if on === true then add validation (remove class 'skip-validation')
     * if on === false then remove validation (add class 'skip-validation')
     *
     * @param $item {jQuery element}
     * @param on {Boolean}
     */
    setValidationOnItem: function($item, on) {
        $item.find('input, .swc-dropdown').toggleClass('skip-validation', !on);
    },

    /**
     * Hide list item for adding new lease
     * and switch off validation on its elements
     */
    hideNewLeaseItem: function() {
        var $item = this.$('.new-dhcplease-form');

        $item.addClass('hidden');
        this.setValidationOnItem($item, false);
    },

    /**
     * Set enabled/disabled mode of sibling items by removing/adding
     * class 'disabled' to buttons with classes 'do-edit', 'do-delete'
     *
     * if on === true then enable sibling items (remove class 'disabled')
     * if on === false then disable sibling items (add class 'disabled')
     *
     * @param $item {jQuery element}
     * @param show {Boolean}
     */
    setEnabledModeForSiblingItems: function($item, on) {
        $item.siblings('.expandable-list-item').each(function() {
            $(this).find('.do-edit, .do-delete').toggleClass('disabled', !on);
        });
    },

    /**
     * Event handler: is fired on start edit static IP-address item
     *
     * @param e {Event}
     * @param value {String}
     */
    setEditLease: function(e, value) {
        var $item = $(e.currentTarget).find('[data-key="' + value + '"]');

        this.closeSiblingItems($item);
        this.setEnabledModeForSiblingItems($item, false);
        this.setValidationOnSiblingItems($item, false);
        this.setValidationOnItem($item, true);

        if (value !== 'newItem') {
            this.hideNewLeaseItem();
        }

        $item.find('.do-edit').addClass('disabled');

        // Set editing flag to let view know that page changed:
        this.$('.edit-form-flag').val(value);

        this.setButtonsState();
    },

    /**
     * Enable table with static IP addresses:
     *  - remove opacity from table
     *  - remove hover popup with info message above table
     */
    enableDHCPLeaseTable: function() {
        var dhcpTable = $(".dhcp-settings"),
            inputs = dhcpTable.find(".swc-input");

        _.each(inputs, function(input) {
            $(input).removeClass("skip-validation").removeClass("disabled").removeAttr("disabled", "disabled");
        });

        this.$('.dhcp-leases-list').removeClass('disabled');
    },

    /**
     * Disable table with static IP addresses:
     *  - add opacity to table
     *  - add hover popup with info message above table
     */
    disableDHCPLeaseTable: function() {
        var dhcpTable = $(".dhcp-settings"),
            inputs = dhcpTable.find(".swc-input");

        _.each(inputs, function(input) {
            $(input).addClass("skip-validation").addClass("disabled").attr("disabled", "disabled");
        });

        this.$('.dhcp-leases-list').addClass('disabled');
    },

    /**
     * Event handler: is fired on changing state of DHCP
     *
     * @param e {Event}
     * @param value {String}
     */
    setDHCPState: function(e, value) {
        if (value) {
            this.enableDHCPLeaseTable();
        } else {
            this.disableDHCPLeaseTable();
        }

        this.pageValidation(); //Revalidate DHCP and so on
    },

    /**
     * Event handler: is fired on delete static IP-address item
     *
     * @param e {Event}
     * @param value {String}
     */
    deleteDHCPLease: function(e, value){
        var $item = $(e.currentTarget).find('[data-key="' + value + '"]');

        this.setValidationOnItem($item, false);
        this.setEnabledModeForSiblingItems($item, true);

        $item.addClass('deleted').hide();

        this.setButtonsState();
    },

    setDMZState: function(e, value) {
        var DMZIPAddress = this.$('[data-name="DMZIPAddress"]');

        $(".dmz-device").toggleClass("disabled", !value);
        
        if (!value) {
            this.pageValidation(DMZIPAddress, false);
        }
    },

    setDMZData: function() {
        var options = swc.models.NetworkDevices.getDeviceDropdownOptions({'filter': 'status'}),
            deviceIP = swc.models.Network.getParameter('deviceIP', 'dmz'),
            selected = swc.models.NetworkDevices.getDeviceMac(deviceIP),
            dmzCheckbox = this.$el.find('.swc-checkbox.enable-dmz'),
            dmzDropDown = this.$el.find('.dmz-device');

        dmzDropDown.data('options', options);
        dmzDropDown.toggleClass("disabled", !deviceIP.length);

        if (!deviceIP.length) {
            dmzCheckbox.trigger('swc-checkbox:swc-change', false);

            dmzCheckbox.data("default-value", false);
            dmzDropDown.data("default-value", "");
        } else {
            dmzDropDown.data("default-value", selected);
            dmzCheckbox.data("default-value", true);

            dmzCheckbox.trigger('swc-checkbox:swc-change', true);
            dmzDropDown.trigger('swc-dropdown:swc-change', selected);
        }
    },

    //Change DHCP range subnet
    updateDHCPSettings: function() {
        var validation = swc.models.Network.validation,
            Address = this.$('input[name="Address"]').val(),
            Netmask = this.$('input[name="Netmask"]').val(),
            DHCPMin = this.$('input[name="DHCPRange"].range-from'),
            DHCPMax = this.$('input[name="DHCPRange"].range-to'),

            AddressDecimal = validation.ipStringToDecimal(Address),
            NetmaskDecimal = validation.ipStringToDecimal(Netmask);

        if (validation.validateNetmaskDecimal(AddressDecimal, NetmaskDecimal, false, false).status !== false) {
         
            var minVal = validation.replaceSubnet(DHCPMin.val(), Address, Netmask);
            var maxVal = validation.replaceSubnet(DHCPMax.val(), Address, Netmask);
            //Check that DHCPMin is less then DCHPMax
            var valsAreValid = (minVal !== false) && (maxVal !== false) &&
             (validation.ipStringToDecimal(minVal) < validation.ipStringToDecimal(maxVal));
            
            if (minVal && (!maxVal || valsAreValid)) {
                DHCPMin.val(minVal);
            }
            if (maxVal && (!minVal || valsAreValid)) {
                DHCPMax.val(maxVal);
            }
        }
    },

    //In case if subnet have changed, update, DHCP range, and hint for network range
    updateSubnetInfo: function() {
        var validation = swc.models.Network.validation,
            Address = validation.ipStringToDecimal(this.$('input[name="Address"]').val()),
            Netmask = validation.ipStringToDecimal(this.$('input[name="Netmask"]').val());

        if (validation.validateNetmaskDecimal(Address, Netmask, false, false).status !== false &&
            validation.validateIPAddressDecimal(Address, Netmask, false, false).status !== false) {
            
            
            var popoverData = this.$('.netmask-settings-info').data('popover-template-data');
            popoverData.subnetMask = validation.decimalToIpString(Netmask);
            popoverData.subnetRange = validation.getAllowedHostRange(Address, Netmask);
            this.$('.netmask-settings-info').data('popover-template-data', popoverData);
        }
        

        this.updateDHCPSettings();
    },


    getDHCPLeasesData: function () {
        var possibleElements = [
                '.swc-input', '.swc-checkbox', '.swc-extended', '.swc-radio-buttons', '.swc-dropdown'
            ],
            selector = possibleElements.join(','),
            pool = [];

        this.$('.expandable-static-ip .expandable-list-item')
            .filter('.mode-editing:not(.skip-validation), .edited:not(.skip-validation), .deleted, .new-dhcplease-form:visible:not(.skip-validation)').each(function () {
                var self = $(this),
                    item = self.find(selector).map(function () {
                        return getParameter($(this));
                    });
                if (self.is('.deleted')) {
                    item.deleted = true;
                }
                pool.push(item);
            });

        return pool;
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            deferred2 = new $.Deferred(),
            pageData = [],
            warningMessages = [],
            actionsToDo,
            elements = this.getElements(),
            DHCPLeasesData = this.getDHCPLeasesData();

        // Get elements name => value map
        $.each(elements, function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // warningMessages can be filled when IP setting are saved correctly already
        warningMessages = self.checkNetworkChangeWarnings(pageData);

        /*
         * if there are some warning messages then hide page loading modal window
         * and show information modal window
         */
        if (!_.isEmpty(warningMessages)) {
            self.stopPageLoading();
        }

        // Define what has to be done on save
        actionsToDo = [
            swc.models.Network.saveDMZSettings(pageData),
            swc.models.DHCPLeases.saveDHCPLeases(DHCPLeasesData)
        ];

        $.when.apply(null, actionsToDo)
            .done(function() {
                // IP settings are saved the last because we can't save anything if IP is changed: 
                $.when(swc.models.Network.saveIPSettings(pageData))
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }).fail(function() {
                deferred.reject();
            });

        function afterSave(rejected) {
            if (!_.isEmpty(warningMessages) && !rejected) {
                self.showWarningModal(deferred2, rejected, warningMessages[0]);
            } else {
                if (rejected) {
                    deferred2.reject();
                } else {
                    deferred2.resolve();
                }
            }
        }

        function afterFail() {
            afterSave(true);
        }
    
        deferred
            .done(afterSave)
            .fail(afterFail);

        return deferred2.promise();
    },

    /**
     * Get an array of warning messages if the net is changed/reduced so that some devices may need reconnection.
     * The only first message will be shown to user, that is why all messages are sorted by priority.
     * E.g. in case of editing "InternetBox IP address" and "Static IP address" only message about changing
     * "InternetBox IP address" should be shown
     *
     * @params data {Array} Array of form values
     * @return {Array} Warning messages
     */
    checkNetworkChangeWarnings: function(data) {
        var oldMask,
            newMask,
            warningMessages = [];

        function ipToDecimal(ip) {
            return _.reduce(ip.split('.'), function(m, n) { return m*256 + parseInt(n, 10); }) >>> 0;
        }

        _.each(data, function(element, key) {
            if (element.parameterName === 'Address') {
                if (element.parameterValue !== element.parameterData.defaultValue) {
                    warningMessages.push('1_ip');
                }
            }

            if (element.parameterName === 'Netmask') {
                oldMask = ipToDecimal(element.parameterData.defaultValue);
                newMask = ipToDecimal(element.parameterValue);

                if (oldMask < newMask) {
                    warningMessages.push('2_mask');
                }
            }

            if (element.parameterName === 'DHCPLeaseIPAddress') {
                if (element.parameterValue !== element.parameterData.defaultValue) {
                    warningMessages.push('3_lease_ip');
                }
            }
        });
        
        /*
         * only first message will be shown to user sort messages by priority
         * and all messages should sorted by priority
         */
        warningMessages.sort();

        return warningMessages;
    },

    showWarningModal: function (deferred, rejected, messageID) {
        var self = this,
            ip;

        SWCElements.modalWindow.show({
            templateID: 'network:settings:ip-settings:warning-modal',
            templateData: {
                messageID: messageID
            },
            className: 'network-warning-modal',

            onApply: function() {
                SWCElements.modalWindow.hide();

                // if we came by IP then we have to be redirected to the new IP:
                if (window.location.hostname.match(/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/)) {
                    self.showPageLoading('Loading page data..');
                    document.location.href = window.location.origin.replace(/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/,
                        self.$('input[name=Address]').val()) ;
                }

                deferred.resolve();
            }
        });
    }
});
;swc.constructors.NetworkSettingsView = swc.base.PageView.extend({

    className: 'network-settings',

    models: [
        'Network',
        'Wireless'
    ]
});;swc.constructors.NetworkSettingsPortforwardingAddView = swc.base.TabView.extend({

    className: 'port-forwarding-add',

    allowedMods: [
        'expert'
    ],

    models: [
        'PortForwarding',
        'NetworkDevices'
    ],

    validation: {
        'deviceIP': 'PortForwarding:deviceIP',
        'serviceName': 'PortForwarding:serviceName',
        'predefinedServiceName': 'PortForwarding:predefinedServiceName',
        'entryPort': 'PortForwarding:entryPort',
        'destinationPort': 'PortForwarding:destinationPort'
    },

    events: {
        'swc-radio-buttons:change .swc-radio-buttons.service-mode': 'setServiceAddingMode',
        'swc-radio-buttons:change .swc-radio-buttons.entry-mode': 'setEntryPortMode',
        'swc-radio-buttons:change .swc-radio-buttons.destination-mode': 'setDestinationPortMode',

        'keyup input[name="entryPort"].from': 'updateDestinationPorts',
        'keyup input[name="entryPort"].to': 'updateDestinationPorts',

        'swc-dropdown:change .swc-dropdown.service-name-selection': 'setPredefinedValues',
        'swc-dropdown:change .swc-dropdown.device-selection': 'postDeviceSelectionValidation'
    },

    setTemplateData: function() {
        this.templateData = {
            serviceMode: "custom", // Default option {'Create your own'}
            servicePred: "FTP",    // Default option {'Predefined rule: FTP'}
            name: "",
            port: {
                entry: [],
                destination: []
            },
            portMode: {
                entry: "single", // Default option {'Single'}
                destination: "single"  // Default option {'Single'}
            },
            device: "0.0.0.0",      // Default option {'Select a device'}
            protocol: "6,17"        // Default option {'TCP/UDP'}
        };
    },

    /**
     * @override on {'swc.BaseView.initialize()'} method
     *
     * Need to set new template in order to support /1/2/3/4/.../n/ lvls of views including.
     *
     * @returns {boolean}
     */
    initialize: function() {
        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get('network:settings:port-forwarding:rules-add').get('content'));

        // Extend global events:
        this.events = _.extend({}, swc.base.PageView.prototype.events, this.events);
    },

    /**
     * @override on {'swc.BaseView.pageCheckDefaultValues()'} method
     *
     * Need to return always true, becuase this page must not check for editing
     *
     * @returns {boolean}
     */
    pageCheckDefaultValues: function() {
        return true;
    },

    /**
     * Override from base class - never mark this page as changed.
     * FIXME: After implementation of 2-way binding we have to fix this method and check if any of model changed
     * 
     * Possible workarounds: remove and global hasChanged() will handle case,
     * but for that we need to FIXME: implement disabling/enabling of "Save" button. 
     * @returns {boolean}
     */
    hasChanged: function(){
        return false;
    },

    /**
     * @override
     *
     * @description
     *
     *  Need to keep buttons enabled all time
     *
     * @param e
     * @param toDisable
     */
    setButtonsState: function(e, toDisable) {
        var container = this.$('.buttons-container-message'),
            buttonSave = container.find('.button.save-changes'),
            buttonCancel = container.find('.button.cancel-changes');

        buttonSave.removeClass('disabled');
        buttonCancel.removeClass('disabled');
    },

    /**
     * @override on {'swc.BaseView.renderComplete()'} method
     *
     * Need to setup some values when page is ready to be rendered
     *
     * @returns {boolean}
     */
    renderComplete: function() {
        this.setDefaultValues();
    },

    /**
     * Get values from Ports inputs. Convert undefined values to 0
     *
     * @param type {String}
     * @returns {Array of Strings}
     */
    getPortsValuesFromView: function(type) {
        var inputEntryFrom = this.$('input[name="entryPort"].from'),
            inputEntryTo = this.$('input[name="entryPort"].to'),
            inputDestinationPortFrom = this.$('input[name="destinationPort"].from'),
            inputDestinationPortTo = this.$('input[name="destinationPort"].to'),
            portValues = {
                entry: [
                    !$.trim(inputEntryFrom.val()) ? "" : +inputEntryFrom.val(),
                    !$.trim(inputEntryTo.val()) ? "" : +inputEntryTo.val()
                ],
                destination: [
                    !$.trim(inputDestinationPortFrom.val()) ? "" : +inputDestinationPortFrom.val(),
                    !$.trim(inputDestinationPortTo.val()) ? "" : +inputDestinationPortTo.val()
                ]
            };

        return !_.isUndefined(portValues[type]) ? portValues[type] : [];
    },

    /**
     * Reset form elements to default values.
     *
     * @description
     *
     *      Default value for fields when adding rule are following:
     *
     *          Service - Create Your Own
     *          Entry Port - Single
     *          Protocol - TCP/UDP
     *          To Device - Choose a device
     *          Destination Port - Single
     *
     *      All input fields have to be empty
     */
    setDefaultValues: function() {
        this.setPredefinedRulesOptions();
        this.setAssignedDeviceOptions();
        this.setProtocolOptions();

        // Set service name field to default value:
        this.$('input[name="serviceName"]').val(this.templateData.name);

        // Set entry ports fields to default values:
        if (!_.isUndefined(this.templateData.port.entry[0])) {
            this.$('input[name="entryPort"].from').val(this.templateData.port.entry[0]);
        } else {
            this.$('input[name="entryPort"].from').val("");
        }

        if (!_.isUndefined(this.templateData.port.entry[1])) {
            this.templateData.portMode.entry = "range";

            this.$('input[name="entryPort"].to').val(this.templateData.port.entry[1]);
            this.$('.entry-port-values-section').addClass("range-type");
        } else {
            this.$('input[name="entryPort"].to').val("");
            this.$('.entry-port-values-section').removeClass("range-type");
            this.$('.swc-radio-buttons.destination-mode .mode[data-value="range"]').addClass('disabled');
        }

        // Set destination ports fields to default values:
        if (!_.isUndefined(this.templateData.port.destination[0])) {
            this.$('input[name="destinationPort"].from').val(this.templateData.port.destination[0]);
            this.$('.text-block-destination-from').text(this.templateData.port.destination[0]);
        } else {
            this.$('input[name="destinationPort"].from').val("");
            this.$('.text-block-destination-from').text("");
        }

        if (!_.isUndefined(this.templateData.port.destination[1])) {
            this.templateData.portMode.destination = "range";

            this.$('input[name="destinationPort"].to').val(this.templateData.port.destination[1]);
            this.$('.text-block-destination-to').text(this.templateData.port.destination[1]);
            this.$('.destination-port-values-section').addClass("range-type");
        } else {
            this.$('input[name="destinationPort"].to').val("");
            this.$('.text-block-destination-to').text("");
            this.$('.destination-port-values-section').removeClass("range-type");
        }

        // Reset radio buttons state to default
        this.$('.swc-radio-buttons.entry-mode')
            .trigger('swc-radio-buttons:swc-change', this.templateData.portMode.entry);

        this.$('.swc-radio-buttons.destination-mode')
            .trigger('swc-radio-buttons:swc-change', this.templateData.portMode.destination);

        // Reset dropdowns state to default
        this.$('.swc-dropdown.protocol-selection')
            .trigger('swc-dropdown:swc-change', this.templateData.protocol);

        this.$('.swc-dropdown.device-selection')
            .trigger('swc-dropdown:swc-change', this.templateData.device);

        // Remove all previous validation messages:
        this.clearValidationMessages();
    },

    /**
     * Handler for resetting fields to predefined rule values:
     *
     * @description
     *
     *      After selecting predefined options, all the fields and inputs in the page MUST be filled with port's values
     *
     * @param e {Object} Event
     * @param value {String}
     */
    setPredefinedValues: function(e, value) {
        var serviceName = !_.isUndefined(value) ? value : this.templateData.servicePred,
            service = swc.models.PortForwarding.predefinedServices[serviceName],
            servicePort = service.port.split('-'),
            entryRadioButtons = this.$('.swc-radio-buttons.entry-mode'),
            destinationRadioButtons = this.$('.swc-radio-buttons.destination-mode');

        // Update inputs:
        this.$('input[name="entryPort"].from').val(servicePort[0]);
        this.$('input[name="destinationPort"].from').val(servicePort[0]);
        this.$('.text-block-destination-from').text(servicePort[0]);

        if (!_.isUndefined(servicePort[1])) {
            this.$('.entry-port-values-section').addClass("range-type");
            this.$('.destination-port-values-section').addClass("range-type");

            this.$('input[name="entryPort"].to').val(servicePort[1]);
            this.$('input[name="destinationPort"].to').val(servicePort[1]);
            this.$('.text-block-destination-to').text(servicePort[1]);
        }

        // Set correct radio buttons position for entry ports:
        if (servicePort.length === 2) {
            entryRadioButtons.trigger('swc-radio-buttons:swc-change', "range");
            destinationRadioButtons.trigger('swc-radio-buttons:swc-change', "range");

            this.setEntryPortMode(null, "range");
            this.setDestinationPortMode(null, "range");
        } else {
            entryRadioButtons.trigger('swc-radio-buttons:swc-change', "single");
            destinationRadioButtons.trigger('swc-radio-buttons:swc-change', "single");

            this.setEntryPortMode(null, "single");
            this.setDestinationPortMode(null, "single");
        }

        // Update protocol:
        this.$('.swc-dropdown.protocol-selection').trigger('swc-dropdown:swc-change', service.protocol);

        // Remove all previous validation messages:
        this.clearValidationMessages();
    },

    /**
     * Handler for switching between Create your own / Predefined modes
     *
     * @descriptions
     *
     *      IF on add rule page the User will chose "Create Your Own" option THEN all field MUST have either default value
     *      (if any) or be empty, user MUST be able to change any field on the page
     *
     *      IF on add rule page the User will chose "Predefned Rule" option THEN in Service dropdown menu he MUST be able
     *      to select it from the list (see {'swc.collections.PortForwarding.defaultServices'}).
     *
     * @param e {Object} Event
     * @param value {String}
     */
    setServiceAddingMode: function(e, value) {
        var type = !_.isUndefined(value) ? value : this.templateData.serviceMode;

        if (type === "predefined") {
            this.setDefaultValues();
            this.setPredefinedValues();
        } else {
            this.setDefaultValues();
        }

        this.$('.rule-name-section').toggleClass("type-predefined", value === "predefined");
    },

    /**
     * Handler for switching between Single / Range modes for entry ports:
     *
     * @description
     *
     *      IF in Entry Port user will choose {'Single'} option THEN User MUST be able to select ONLY Single option in
     *      Destination Port, Range option MUST be disabled, the User MUST be able to edit port number
     *
     *      IF in Entry Port user will choose Range option THEN user MUST be able to select BOTH Single and Range option
     *      in Destination Port
     *
     *      IF in Entry Port user will choose Range option AND choose Single option in Destination Port THEN ports number
     *      from Entry Ports MUST be copied to Destination Port, the User MUST be able to edit this port number
     *
     *      IF in Entry Port user will choose Range option AND choose Range option in Destination Port THEN ports range
     *      from Entry Ports MUST be copied to Destination Port range, the User MUST NOT be able to edit this ports numbers
     *
     *      IF the User will enter port number in Entry port field with Single option chosen and after will switch to Range
     *      option THEN second field MUST be empty in order the User will be able to enter port number
     *
     * @param e {Object} Event
     * @param value {String}
     */
    setEntryPortMode: function(e, value) {
        var entryPorts = this.getPortsValuesFromView('entry'),
            inputEntryPortFrom = this.$('input[name="entryPort"].from'),
            inputEntryPortTo = this.$('input[name="entryPort"].to'),
            inputDestinationPortFrom = this.$('input[name="destinationPort"].from'),
            inputDestinationPortTo = this.$('input[name="destinationPort"].to'),
            spanDestinationFrom = this.$('.text-block-destination-from'),
            spanDestinationTo = this.$('.text-block-destination-to'),
            destinationRadioButtons = this.$('.swc-radio-buttons.destination-mode'),
            destinationValuesSection = this.$('.destination-port-values-section'),
            destinationRadioButtonsRangeMode = this.$('.swc-radio-buttons.destination-mode .mode[data-value="range"]');

        if (value === "range") {
            // Enable if was disabled range mode for destination ports:
            destinationRadioButtonsRangeMode.removeClass('disabled');
            destinationRadioButtons.trigger('swc-radio-buttons:swc-change', "range");
            destinationValuesSection.addClass("range-type");

            // When changed by user
            if (e) {
                // Copy entry port {'from'} and {'to'} to destination ports:
                inputDestinationPortFrom.val(entryPorts[0]);
                inputDestinationPortTo.val(entryPorts[1]);

                // Copy values to spans:
                spanDestinationFrom.text(entryPorts[0]);
                spanDestinationTo.text(entryPorts[1]);
            }

        } else {
            // Set range mode to single for destination ports:
            destinationRadioButtons.trigger('swc-radio-buttons:swc-change', "single");
            destinationRadioButtonsRangeMode.addClass('disabled');
            destinationValuesSection.removeClass("range-type");

            // Copy entry port {'from'} to destination port (when changed by user):
            if (e) {
                inputDestinationPortFrom.val(entryPorts[0]);

                // Blink field on update
                this.notifyPortsUpdate(inputDestinationPortFrom);
            }

            // Re-validate field to clear message from range ports:
            if (!_.isEmpty(inputEntryPortFrom.val())) {
                this.pageValidation(inputEntryPortFrom, false);
                this.pageValidation(inputEntryPortTo, false);
                this.pageValidation(inputDestinationPortFrom, false);
            }
        }

        this.$('.entry-port-values-section').toggleClass("range-type", value === "range");
    },

    /**
     * Handler for switching between Single / Range modes for destination ports:
     *
     * @description
     *
     *      There are no strict conditions for this handler, if user will select single - he will be able only to edit
     *      {'from'} destination port value. Either if he will select Range - he will be able to edit both.
     *
     * @param e {Object} Event
     * @param value {String}
     */
    setDestinationPortMode: function(e, value) {
        var entryPorts = this.getPortsValuesFromView('entry'),
            inputDestinationPortFrom = this.$('input[name="destinationPort"].from'),
            inputDestinationPortTo = this.$('input[name="destinationPort"].to'),
            spanDestinationFrom = this.$('.text-block-destination-from'),
            spanDestinationTo = this.$('.text-block-destination-to');

        if (value === "range") {

            // when changed by user
            if (e) {
                // Copy entry port {'from'} and {'to'} to destination ports:
                inputDestinationPortFrom.val(entryPorts[0]);
                inputDestinationPortTo.val(entryPorts[1]);

                // Copy values to spans:
                spanDestinationFrom.text(entryPorts[0]);
                spanDestinationTo.text(entryPorts[1]);
            }
        } else {

            // when changed by user
            if (e) {
                // Copy entry port {'from'} to destination ports:
                inputDestinationPortFrom.val(entryPorts[0]);

                // Blink field on update
                this.notifyPortsUpdate(inputDestinationPortFrom);
            }

            // Re-validate field to clear message from range ports:
            this.pageValidation(inputDestinationPortFrom, false);
        }

        this.$('.destination-port-values-section').toggleClass("range-type", value === "range");
    },

    /**
     * Handler for settings values for {'Select device'} dropdown
     *
     * @description
     *
     *      Default value: Select Device
     *
     *      MUST contain the list of currently connected and recently connected devices
     */
    setAssignedDeviceOptions: function() {
        var dropdown = this.$('.swc-dropdown.device-selection'),
            options = {
                "0.0.0.0": {
                    name: getTranslationStrings("Choose a device"),
                    value: "0.0.0.0",
                    isDefault: true
                }
            };

        // Define which devices to show in dropdown:
        _.each(swc.models.NetworkDevices.models, function(model, key) {
            var ipAddress = model.get('address')['IPv4'];

            // In this list can be devices which have IPv4 Address:
            if (!_.isEmpty(ipAddress) && !_.isUndefined(ipAddress)) {
                options[ipAddress] = {
                    name: model.get('name'),
                    value: ipAddress,
                    additionalLabel: ipAddress
                };
            }
        });

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.data('hide-default', true);
        dropdown.trigger('swc-dropdown:swc-change', this.templateData.device);
    },

    /**
     * Handler for settings values for {'Protocol'} dropdown
     *
     * @description
     *
     *      Default value: TCP/UDP
     *
     *      Values of Protocol dropdown menu
     *          - TCP/UDP
     *          - TCP
     *          - UDP
     */
    setProtocolOptions: function() {
        var dropdown = this.$('.swc-dropdown.protocol-selection'),
            options = [
                { name: getTranslationStrings("TCP/UDP"), value: "6,17" },
                { name: getTranslationStrings("TCP"),     value: "6"    },
                { name: getTranslationStrings("UDP"),     value: "17"   }
            ];

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', this.templateData.protocol);
    },

    /**
     * Handler for settings values for {'Predefined Rules'} dropdown
     *
     * @description
     *
     *      Default value: FTP
     *
     *      See list of rules in
     */
    setPredefinedRulesOptions: function() {
        var dropdown = this.$('.swc-dropdown.service-name-selection'),
            services = swc.models.PortForwarding.predefinedServices,
            options = [];

        // Go through each service and create options for dropdown
        _.each(services, function(service, key) {
            options.push({name: key, value: key});
        });

        // Set dropdown data:
        dropdown.data('options', options);
        dropdown.trigger('swc-dropdown:swc-change', this.templateData.servicePred);
    },

    /**
     * Handle for updating Destination ports, when Entry ports inputs are changing:
     *
     * @param e {Object}
     * @param value {String}
     */
    updateDestinationPorts: function(e) {
        var entryInput = $(e.target),
            entryPorts = this.getPortsValuesFromView('entry'),
            inputDestinationPortFrom = this.$('input[name="destinationPort"].from'),
            inputDestinationPortTo = this.$('input[name="destinationPort"].to'),
            spanDestinationFrom = this.$('.text-block-destination-from'),
            spanDestinationTo = this.$('.text-block-destination-to');

        // Blink field on update
        this.notifyPortsUpdate(inputDestinationPortFrom);

        // Update correct parts of inputs and text blocks
        if (entryInput.hasClass("from")) {
            inputDestinationPortFrom.val(entryPorts[0]);
            spanDestinationFrom.text(entryPorts[0]);
        } else {
            inputDestinationPortTo.val(entryPorts[1]);
            spanDestinationTo.text(entryPorts[1]);
        }

        this.pageValidation(inputDestinationPortFrom, false);
    },

    /**
     * Validate destionation ports after device has changed, because they are assigned to correct device
     */
    postDeviceSelectionValidation: function() {
        var inputDestinationPortFrom = this.$('input[name="destinationPort"].from'),
            inputDestinationPortTo = this.$('input[name="destinationPort"].to');

        if (!_.isEmpty(inputDestinationPortFrom.val())) {
            this.pageValidation(inputDestinationPortFrom, false);
            this.pageValidation(inputDestinationPortTo, false);
        }
    },

    /**
     * Notify that one of ports fields will be updated on the page
     * @param element
     */
    notifyPortsUpdate: function(element) {
        if (!_.isUndefined(element) && element.size()) {
            element.addClass('input-attention');

            setTimeout(function() {
                element.removeClass('input-attention');
            }, 250);
        }
    },

    /**
     * Update model which stores information about current rule before synching it with server
     * @returns {swc.constructors.PortForwardingRule}
     */
    updateRuleModel: function() {
        var self = this,
            ruleModel = _.isUndefined(this.model) ? new swc.constructors.PortForwardingRule() : this.model,
            data = {
                name: { elementName: "serviceName" },
                portsEntryMode: { elementName: "entry-ports-mode" },
                entryPortTo: { elementName: "entryPort", elementClass: "to" },
                entryPortFrom: { elementName: "entryPort", elementClass: "from" },
                protocol: { elementName: "protocol" },
                assignedDeviceIP: { elementName: "deviceIP" },
                portsDestinationMode: { elementName: "destination-ports-mode" },
                desinationPortTo: { elementName: "destinationPort", elementClass: "to" },
                desinationPortFrom: { elementName: "destinationPort", elementClass: "from" },
                predefinedMode: { elementName: "service-mode" },
                predefinedName: { elementName: "predefinedServiceName" }
            },
            elementsMap = [],
            ports = {
                entry: [],
                destination: []
            }, id, name, status;

        // Collect elements map:
        _.each(this.getElements(), function(element) {
            elementsMap.push(getParameter($(element)));
        });

        // Get data values
        data = swc.Utils.getDataToValidate(data, elementsMap);

        // Update rule model values:
        if (data.predefinedMode === "custom") {
            id = swc.Utils.generateId();
            name = data.name;
            status = true;
        } else {
            // This is a case when rule is editing (some elements are absent)
            id = _.isString(data.predefinedMode) ? swc.Utils.generateId() : ruleModel.get('id');
            name = _.isString(data.predefinedMode) ? data.predefinedName : data.name;
            status = _.isString(data.predefinedMode) ? true : ruleModel.get('status');
        }

        ruleModel.set('id', $.trim(id));
        ruleModel.set('name', $.trim(name));
        ruleModel.set('status', status);

        ruleModel.set('protocol', data.protocol);
        ruleModel.set('deviceIP', data.assignedDeviceIP);

        // destination port -> port on stargate device
        if (data.portsEntryMode === "range") {
            ports.entry = [ data.entryPortFrom, data.entryPortTo ];
        } else {
            ports.entry = [ data.entryPortFrom ];
        }

        // destination port -> port on assigned device
        if (data.portsDestinationMode === "range") {
            ports.destination = [ data.desinationPortFrom, data.desinationPortTo ];
        } else {
            ports.destination = [ data.desinationPortFrom ];
        }

        ruleModel.set('ports', ports);

        return ruleModel;
    },

    /**
     * Handler for saving page. Will trigger, when user will press "Save" button
     *
     * @description
     *
     *      After user will press "Save" button, page validation should trigger. If validation is success, rule has to
     *      be added to the NP, collection of rules has to be resynced and user has to be navigated to the Port Forwarding
     *      rules page, in order to see his rule.
     */
    save: function() {
        var updatedModel = this.updateRuleModel();

        // NP requires commit action after any changes done to rules:
        $.when(updatedModel.sync('create'), updatedModel.sync('commit'))
            .done(function() {
                swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
            })
            .fail(function() {
                // do nothing, maybe show some error message
            });
    },

    /**
     * @override on {'swc.BaseView.cancelChanges()'} method
     *
     * Need to navigate user to Rules List page when clicking cancel
     *
     * @returns {boolean}
     */
    cancelChanges: function() {
        swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
    }

});
;swc.constructors.NetworkSettingsPortforwardingEditView = swc.constructors.NetworkSettingsPortforwardingAddView.extend({

    className: 'port-forwarding-edit',

    events: {
        'swc-radio-buttons:change .swc-radio-buttons.entry-mode': 'setEntryPortMode',
        'swc-radio-buttons:change .swc-radio-buttons.destination-mode': 'setDestinationPortMode',

        'change input[name="entryPort"].from': 'updateDestinationPorts',
        'change input[name="entryPort"].to': 'updateDestinationPorts'
    },

    setTemplateData: function() {
        var rule = swc.models.PortForwarding.findWhere({ id: localStorage.getItem('port-forwarding:edit-ruleID') }),
            device, ports;

        // Rule is not existing. Impossible situation:
        if (_.isUndefined(rule)) {
            swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
            return;
        }

        // Catch current model for future work with it:
        this.model = rule;

        // Check if device with current IP exists in NP db
        device = swc.models.NetworkDevices.getDeviceByIP(rule.get('deviceIP'));

        this.templateData = {
            name: rule.get('name'),
            id: rule.get('id'),
            port: {
                entry: rule.get('ports').entry,
                destination: rule.get('ports').destination
            },
            portMode: {
                entry: rule.get('ports').entry.length === 2 ? "range" : "single",
                destination: rule.get('ports').destination.length === 2 ? "range" : "single"
            },
            device: !_.isUndefined(device) ? rule.get('deviceIP') : "0.0.0.0",
            protocol: rule.get('protocol')
        };
    },

    /**
     * @override on {'swc.BaseView.initialize()'} method
     *
     * Need to set new template in order to support /1/2/3/4/.../n/ lvls of views including.
     *
     * @returns {boolean}
     */
    initialize: function() {
        // Prepare template for current page:
        this.template = $.template("pageContent", swc.Templates.get('network:settings:port-forwarding:rules-edit').get('content'));

        // Extend global events:
        this.events = _.extend(
            swc.constructors.NetworkSettingsPortforwardingAddView.prototype.events,
            swc.base.PageView.prototype.events,
            this.events
        );
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            updatedModel = this.updateRuleModel();

        // NP requires commit action after any changes done to rules:
        $.when(updatedModel.sync('update'))
            .done(function() {
                swc.router.navigate('network/settings/port-forwarding', { skipUnsavedChanges: true });
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});
;swc.constructors.NetworkSettingsPortforwardingView = swc.base.TabView.extend({

    className: 'port-forwarding',

    allowedMods: [
        'expert'
    ],

    events: {
        'click .expandable-list .trash.process-delete:not(.disabled)': 'deleteRule',
        'click .expandable-list .pencil.process-edit:not(.disabled)': 'editRule',

        'swc-checkbox:change .swc-checkbox.upnp': 'setUPnPStatus',
        'swc-checkbox:change .swc-checkbox.enable-rule': 'setRuleStatus'
    },

    models: [
        'UPnP',
        'PortForwarding',
        'NetworkDevices'
    ],

    pageUrl: 'network/settings/port-forwarding',

    setTemplateData: function() {
        var rules = swc.models.PortForwarding.toJSON();

        // Get device name by ip from rule:
        _.each(rules, function(rule, key) {
            var device = swc.models.NetworkDevices.getDeviceByIP(rule.deviceIP);

            /**
             * NP returns IP address of Assigned Device. And there can be a situation that device IP was changed, or
             * device was not connected to the NP during last 10 days. So assigned IP for rule will refer to nowhere,
             * because such device will no longer exist in NP base.
             */
            if (!_.isUndefined(device)) {
                rule.deviceName = device.get('name');
            } else {
                rule.deviceName = "n/a";
            }
        });

        this.templateData = {
            upnpStatus: swc.models.UPnP.get('status'),
            rules: rules
        };
    },

    setUPnPStatus: function(e, upnpStatus) {
        swc.models.UPnP.set('status', upnpStatus);

        // Update buttons state to see, that upnp has been changed
        this.setButtonsState();
    },

    deleteRule: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            ruleItem = this.$('.expandable-list-item[data-key="' + ruleID + '"]'),
            model = swc.models.PortForwarding.findWhere({ id: ruleID });

        // Update model in the collection:
        swc.models.PortForwarding.remove(model);

        // Remove item from the list
        ruleItem.remove();

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    setRuleStatus: function(e, value) {
        var parameter = getParameter($(e.target)),
            ruleID = parameter.parameterData.rule.toString(),
            model = swc.models.PortForwarding.findWhere({ id: ruleID });

        // Update model in the collection:
        model.set('status', value);

        // Update buttons state to see, that rule have been deleted
        this.setButtonsState();
    },

    pageCheckDefaultValues: function() {

        // BAD BAD BAD FIXME :: fix this when we will have same handling in all views
        this.parentView.pageCheckDefaultValues = function() {
            return !swc.models.UPnP.hasChanged() && !swc.models.PortForwarding.hasChanged();
        };

        return !swc.models.UPnP.hasChanged() && !swc.models.PortForwarding.hasChanged();
    },

    editRule: function(e, value) {
        var parameter = getParameter($(e.target));

        // This is done to get Rule on edit page
        localStorage.setItem('port-forwarding:edit-ruleID', parameter.parameterData.rule);

        swc.router.navigate(this.pageUrl + '/edit', { trigger: true });
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            toDo = [
                swc.models.UPnP.sync('update')
            ],
            deletedRules = swc.models.PortForwarding.changedModels({ onlyDeleted: true  }),
            changedRules = swc.models.PortForwarding.changedModels({ onlyEdited: true  });

        _.each(deletedRules, function(model, key) {
            toDo.push(
                model.sync('delete'),
                model.sync('commit')
            );
        });

        _.each(changedRules, function(model, key) {
            toDo.push(
                model.sync('update'),
                model.sync('commit')
            );
        });

        $.when.apply(this, toDo)
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }

});;swc.constructors.OverviewView = swc.base.PageView.extend({

    className: 'overview',

    events: {
        'click .cloud-login-button': 'loginToCloudService',

        'click .customize-device': 'editDevice',
        'click .customize-dect': 'editDect',
        'click .usb-secure-remove': 'secureRemoveUSB',

        'click .js-go-to-cloud': 'navigateToCloudManagment',

        'swc-switcher:change .set-wifi-state': 'setWiFiState',
        'swc-switcher:change .set-dect-state': 'setDECTState',
        'swc-switcher:change .set-central-storage-state': 'setCentralStorageState'
    },

    listenerInterval: 10,

    listenerEnabled: true,

    listenerPages: [
        'overview'
    ],

    models: [
        'Schedulers', 'CentralStorage', 'СloudServicesStatus', 'CloudAccountCollection', 'CloudServices',
        'Telephony', 'Network', 'NetworkDevices', 'DHCPLeases',
        'FirewallStatus', 'InternetBackupStick'
    ],

    stripDeviceName: function(name, show_chars) {
        var correct = name,
            limit = show_chars || 18;

        if (correct.length > limit) {
            correct = correct.substr(0, 15) + '...';
        }

        return correct;
    },

    navigateToCloudManagment: function () {
        swc.router.navigate('storage/settings/cloud-backup/list', { trigger: false, skipUnsavedChanges: true});
    },

    setTemplateData: function() {
        var phones = swc.models.Telephony.getPhonesList(),
            phoneLines = swc.models.Telephony.get('voip') ?
                swc.models.Telephony.get('voip').where({'enable': 'Enabled'}) : [],
            models = swc.models.CloudAccountCollection.models,
            cloud = !_.isEmpty(models) ? models[0].getExtendedJSON() : '';

        this.templateData = {
            'dectStatus': swc.models.Telephony.get('dectStatus'),
            'voipStatus': swc.models.Telephony.get('voipStatus'),
            'wiredPhones': !_.isEmpty(phones.cord) ? phones.cord : [],
            'internetState': swc.models.Network.getParameter('ConnectionStatus', 'status'),
            'wiredState': true, // This value is hardcoded cause no posibility to check status
            'dectState': swc.models.Telephony.get('dectStatus'),
            'centralStorageState': swc.models.CentralStorage.getParameter("status", "status"),
            'IPv6Address': swc.models.Network.getParameter('IPv6Address',  'status'),
            'GlobalEnable': swc.models.Application.get('GlobalEnable'),
            'wifiState': swc.models.Wireless.getParameter("status", "status"),
            'wifiSchedulerState': swc.models.Schedulers.get('wifi').get('enable'),
            'cloudService': cloud
        };
    },

    renderComplete: function() {
        var self = this;

        // Set listener on Network State change:
        swc.models.Network.on('change', function() {
            self.updateInternetState();
            self.updateGatewayState();
        });

        // Set listener on Backup stick change:
        swc.models.InternetBackupStick.on('change', function() {
            self.updateInternetState();
            self.updateGatewayState();
            self.renderUSBDevices();
        });

        // Set Listener on Central Storage manager change:
        swc.models.CentralStorage.on('central-storage-update', function() {
            self.updateCentralStorageState();
            self.renderUSBDevices();
        });

        swc.models.CloudAccountCollection.on('change', function() {
            self.updateCloudState();
        });

        // Set Listener on WiFi manager change:
        swc.models.Wireless.on('change', function() {
            self.updateWirelessState();
        });

        // Set Listener on Telephony manager change:
        swc.models.Telephony.on('change', function() {
            self.updatePhonesState();
            self.renderDECTDevices();
        });

        // Set Listener on WAN Device manager change:
        swc.models.NetworkDevices.on('devices-loaded', function() {
            self.updateNetworkState();
            self.renderNetworkDevices();
        });

        // Set default states:
        this.updateInternetState();
        this.updateGatewayState();
        this.updateNetworkState();
        this.updateCloudState();
        this.updatePhonesState();
        this.updateCentralStorageState();
        this.updateWirelessState();

        // Render devices:
        this.renderNetworkDevices();
        this.renderUSBDevices();
        this.renderDECTDevices();
    },

    updateInternetState: function() {
        var connection = this.$el.find('.connection.internet'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.Network.getParameter('ConnectionStatus', 'status'),
                "LTEmodemStatus": swc.models.InternetBackupStick.get('isConnected'),
                "localIPAddress" : swc.models.Network.getParameter('LocalIPAddress',  'ip-settings'),
                "remoteIPAddress": swc.models.Network.getParameter('RemoteIPAddress', 'status'),
                "connectionType" : swc.models.Network.getParameter('ConnectionType',  'status'),
                "lastConnection" : swc.models.Network.getParameter('LastConnection',  'status'),
                "deviceName"     : swc.models.Network.getParameter('DeviceName',      'status')
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);
        connection.toggleClass('LTEmodemConnected', connectionData.LTEmodemStatus);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateGatewayState: function() {
        var connection = this.$el.find('.connection.gateway'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            IPv6Address = swc.models.Network.getParameter('IPv6Address',  'status'),
            connectionData = {
                "status": swc.models.Network.getParameter('ConnectionStatus', 'status'),
                "localIPAddress"  : swc.models.Network.getParameter('LocalIPAddress',  'ip-settings'),
                "remoteIPAddress" : swc.models.Network.getParameter('RemoteIPAddress', 'status'),
                "storageIPAddress": swc.models.Network.getParameter('StorageIPAddress', 'status'),
                "connectionType"  : swc.models.Network.getParameter('ConnectionType',  'status'),
                "lastConnection"  : swc.models.Network.getParameter('LastConnection',  'status'),
                'IPv6Address'     : IPv6Address,
                "deviceName"      : swc.models.Network.getParameter('DeviceName',      'status'),
                "GlobalEnable"   : swc.models.Application.get('GlobalEnable')
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateNetworkState: function() {
        var connection = this.$el.find('.connection.wired'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": true,
                "wiredDevicesCount": swc.models.NetworkDevices.countWiredConnectedDevices()
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateCloudState: function() {
        var connection = this.$el.find('.connection.cloud'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            elementData = connection.data('popover-template-data'),
            models = swc.models.CloudAccountCollection.models,
            cloud = !_.isEmpty(models) ? models[0].getExtendedJSON() : '',
            connectionData = {
                'status': !!cloud,
                "centralStorageStatus": swc.models.CentralStorage.getParameter("status", "status"),
                'internetStatus': swc.models.Network.getParameter('ConnectionStatus', 'status'),
                'cloudService': cloud
            },
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData),
            status = connectionData.cloudService.status,
            error = connectionData.cloudService.error,
            credentialsProblem = status === 'ERROR' && error === 'INVALID_CREDENTIALS',
            isError = (status === 'ERROR' && error === 'INVALID_CREDENTIALS') || status === 'STORAGE_DISCONNECTED',
            isWarning = status === 'ERROR' && error !== 'INVALID_CREDENTIALS';

        // Set visual connection updates
        if (!connectionData.cloudService.status) {
            connection.addClass('disconnected');
        } else {
            connection.removeClass('disconnected');
            connection.toggleClass('credentialsProblem', credentialsProblem);
            connection.toggleClass('complete', status === 'COMPLETE');
            connection.toggleClass('synching', status === 'IN_PROGRESS');
            connection.toggleClass('warning', status === 'ERROR');
            connection.toggleClass('error', status === 'STORAGE_DISCONNECTED');

            // Set current service to visible state:
            connection.find('.cloud-service').addClass('hidden');
            connection.find('.' + connectionData.cloudService.id + '-account').removeClass('hidden');
        }

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updatePhonesState: function() {
        var phones = swc.models.Telephony.getPhonesList(),
//            phoneLines = swc.models.Telephony.get('voip') ? swc.models.Telephony.get('voip').where({'enable': 'Enabled'}) : [],
            dectStatus = swc.models.Telephony.get('dectStatus'),
            voipStatus = swc.models.Telephony.get('voipStatus'),
            connection = this.$el.find('.connection.phones'),
            connectionPortOne = this.$el.find('.list.phones .static-phone-1'),
            connectionPortTwo = this.$el.find('.list.phones .static-phone-2'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "dectStatus": dectStatus,
                "voipStatus": voipStatus,
                "port-1": {
                    "status": voipStatus && (!_.isEmpty(phones.cord[0]) && _.isBoolean(phones.cord[0].isDisabled) && !phones.cord[0].isDisabled),
                    "number": 1,
                    "numbers":  {
                        "internal": !_.isEmpty(phones.cord[0]) ? phones.cord[0].internalNumber : '',
                        "external": !_.isEmpty(phones.cord[0]) ? phones.cord[0].externalNumber : ''
                    }
                },
                "port-2": {
                    "status": voipStatus && (!_.isEmpty(phones.cord[1]) && _.isBoolean(phones.cord[1].isDisabled) && !phones.cord[1].isDisabled),
                    "number": 2,
                    "numbers":  {
                        "internal": !_.isEmpty(phones.cord[1]) ? phones.cord[1].internalNumber : '',
                        "external": !_.isEmpty(phones.cord[1]) ? phones.cord[1].externalNumber : ''
                    }
                }
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.dectStatus);
        
        // Add class to mark connection as partially connected
        connection.toggleClass('partially', connectionData.voipStatus);

        // Set phone ports connection state:
        connectionPortOne.toggleClass('disconnected', !connectionData["port-1"].status);
        connectionPortTwo.toggleClass('disconnected', !connectionData["port-2"].status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsData(connectionPortOne, connectionData["port-1"]);
            this.updateConnectionsData(connectionPortTwo, connectionData["port-2"]);

            this.updateConnectionsPopover(connection);
            this.updateConnectionsPopover(connectionPortOne);
            this.updateConnectionsPopover(connectionPortTwo);
        }
    },

    updateCentralStorageState: function() {
        var connection = this.$el.find('.connection.usb'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.CentralStorage.getParameter("status", "status") && swc.models.Application.get('GlobalEnable'),
                "usbDevicesCount": swc.models.CentralStorage.getParameter("devices", "usb-devices").length,
                "mediaServerStatus": swc.models.CentralStorage.getParameter("mediaServerStatus", "status"),
                "GlobalEnable": swc.models.Application.get("GlobalEnable")
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateWirelessState: function() {
        var connection = this.$el.find('.connection.wifi'),
            connectionState = connection.hasClass('disconnected') ? false : true,
            connectionData = {
                "status": swc.models.Wireless.getParameter("status", "status") === "on",
                "wifiSchedulerState": swc.models.Schedulers.get('wifi').get('enable'),
                "wifiCombinedMode": swc.models.Wireless.getParameter("configurationMode", "status"),
                "wifi24GHzName":   swc.models.Wireless.getParameter("name", "2.4GHz"),
                "wifi24GHzStatus": swc.models.Wireless.getParameter("status", "2.4GHz"),
                "wifi5GHzName":    swc.models.Wireless.getParameter("name", "5GHz"),
                "wifi5GHzStatus":  swc.models.Wireless.getParameter("status", "5GHz"),
                "wifiGuestName":   swc.models.Wireless.getParameter("name", "Guest-2.4GHz"),
                "wifiGuestStatus": swc.models.Wireless.getParameter("status", "guestStatus")
            },
            elementData = connection.data('popover-template-data'),
            elementDataChanged = this.checkElementDataChanged(elementData, connectionData);

        // Set visual connection updates
        connection.toggleClass('disconnected', !connectionData.status);

        // Update popover information if something was changed to current element:
        if (elementDataChanged || connectionState !== connectionData.status) {
            this.updateConnectionsData(connection, connectionData);
            this.updateConnectionsPopover(connection);
        }
    },

    updateConnectionsPopover: function(connection) {
        if (connection.hasClass('selected')) {
            SWCElements.popovers.open(connection.find('.icon'));
        }
    },

    updateConnectionsData: function(element, connectionData) {
        var prefix = element.hasClass('disconnected') ? 'disconnected' : 'connected';

        element.data({
            "popover-template-id": "overview:popovers:" + element.data('type') + "-" + prefix,
            "popover-element": ".icon",
            "popover-placement": "left",
            "popover-holder": ".connection." + element.data("type"),
            "popover-container": ".current-page .overview",
            "popover-template-data": connectionData
        });
    },

    checkElementDataChanged: function(elementData, newData) {
        var elementDataChanged = false;

        if (!elementData) {
            elementDataChanged = true;
        } else {
            $.each(newData, function(key, value) {
                if (!typeof(elementData[key])) {
                    elementDataChanged = true;
                } else {
                    if (elementData[key] !== value) {
                        elementDataChanged = true;
                    }
                }
            });
        }

        return elementDataChanged;
    },

    renderNetworkDevices: function() {
        var NetworkDevices = swc.models.NetworkDevices.getConnectedDevices(),
            DHCPLeases = _.pluck(swc.models.DHCPLeases.getActiveLeases(), 'MACAddress'),
            template = swc.Templates.get("components:device").get('content'),
            disconnected = { "wired": 0, "wireless": 0 },
            activeDevicePhysAddress,
            self = this;

        // Fill in WAN Devices List:
        $.each(NetworkDevices, function(connectionType, devicesArray) {
            var list = self.$el.find('.devices-list .list.' + connectionType),
                selectedDevice = list.find('.device.has-popover.selected');

            // Check if any device has popover on it
            if (selectedDevice.size()) {
                activeDevicePhysAddress = selectedDevice.data('macaddress');
                SWCElements.popovers.closeAll();
            }

            // Remove old devices:
            list.find('.device').remove();

            if (!NetworkDevices[connectionType].length) {
                list.find('.no-devices').show();
            } else {
                list.find('.no-devices').hide();
            }
            
            // Render devices
            $.each(devicesArray, function(key, device) {
                var templatePrefix = device.status ? 'connected' : 'disconnected';

                // Only 10 not connected devices must be shown to the user:
                if (!device.status && disconnected[device.interfaceType] >= 10) {
                    return;
                }
                if( _.contains(DHCPLeases, device.mac)) {
                   device.address['static'] = true;
                }
                // Set correct length of device name:
                device.nameShort = self.stripDeviceName(device.name);
                device.IPv6Enabled = swc.models.FirewallStatus.get('state').Enable;

                // All IPv6 Addresses have to be displayed in short form:
                // Display only global IPv6 addresses on overview page if they are present. 
                // If only link scope address present, display link scope address
                if (device.addressObjects.IPv6.length) {
                    device.address.IPv6 = [];
                    $.each(device.addressObjects.IPv6, function(key, address) {
                        // Show only Global IPv6 address on Overview page
                        if (address.scope === "global") {
                            device.address.IPv6[key] = swc.Utils.formatIPv6Address(address.ipAddress);
                        }
                    });
                }
                
                // Append device to the list:
                list.append(
                    $.tmpl(template, {
                        device: device,

                        className: device.status ? 'connected' : 'disconnected',

                        popoverEnable: true,
                        popoverTemplateID: 'overview:popovers:device-' + templatePrefix,
                        popoverTemplateData: JSON.stringify(device),
                        popoverContainer: '.current-page .overview',

                        lastInRow: (key + 1) % 3 === 0 ? "last-in-row" : "" // Need to make a moving to new line in template
                    })
                );
            });

            // Reopen popover for selected device:
            if (activeDevicePhysAddress && activeDevicePhysAddress.length) {
                SWCElements.popovers.open(
                    $('.device.has-popover[data-macaddress="' + activeDevicePhysAddress + '"]').find('.icon')
                );
            }
        });
    },

    renderUSBDevices: function() {
        var usbDevices = !swc.models.Application.get('GlobalEnable') ? [] : swc.models.CentralStorage.getParameter("devices", "usb-devices"),
            template = swc.Templates.get("components:device-storage").get('content'),
            list = this.$el.find('.devices-list .list.usb'),
            selectedDevice = list.find('.device.has-popover.selected'),
            activeDeviceID = selectedDevice.size() ? selectedDevice.data('usbid') : 0,
            emergencyStick = swc.models.InternetBackupStick,
            supportedUsbDevices = _.keys(swc.settings.application.get('supportedUsbDevices'));

        // Check if any device has popover on it
        if (selectedDevice.size()) {
            SWCElements.popovers.closeAll();
        }

        // Remove old devices:
        list.find('.device').remove();

        // Check if devices exists:
        if (!usbDevices.length && !emergencyStick.get('isConnected')) {
            list.find('.no-devices').show();
        } else {
            list.find('.no-devices').hide();
        }

        // Check if emergency stick is active:
        if (emergencyStick.get('isConnected')) {
            var device = _.extend(emergencyStick.toJSON(), {
                cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled')
            });

            list.append(
                $.tmpl(swc.Templates.get("components:device-emergency").get('content'), {
                    device: device,

                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-emergency',
                    popoverTemplateData: JSON.stringify(_.extend(device, { cloudServicesState: false })),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        }

        // Append devices to the list:
        $.each(usbDevices, function(key, device) {
            var prefix = device.type === "usb-disk-undefined" ? "-unsupported" : "",
                deviceIsSupported = ($.inArray(device.type.toLowerCase(), supportedUsbDevices) !== -1);

            // Extend device object with new properties:
            device = _.extend(device, {
                cloudServicesState: swc.models.СloudServicesStatus.get('isEnabled')
            });

            list.append(
                $.tmpl(template, {
                    device: device,
                    deviceIsSupported: deviceIsSupported,
                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-storage' + prefix,
                    popoverTemplateData: JSON.stringify(device),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        });

        // Reopen popover for selected device:
        if (activeDeviceID) {
            SWCElements.popovers.open(
                $('.device.has-popover[data-usbid="' + activeDeviceID + '"]').find('.icon')
            );
        }
    },

    renderDECTDevices: function() {
        var dectDevices = swc.models.Telephony.get('phones').where({deviceType:'dect'}),
            template = swc.Templates.get("components:device-dect").get('content'),
            list = this.$el.find('.devices-list .dect-devices'),
            selectedDevice = list.find('.device.has-popover.selected'),
            activeDeviceID = selectedDevice.size() ? selectedDevice.data('dectid') : 0;

        // Check if any device has popover on it
        if (selectedDevice.size()) {
            SWCElements.popovers.closeAll();
        }

        // Remove old devices:
        list.find('.device').remove();

        // Check if devices exists and DECT is On:
        if (!dectDevices.length || !swc.models.Telephony.get('dectStatus')) {
            list.find('.no-devices').show();
            return;
        } else {
            list.find('.no-devices').hide();
        }

        // Append devices to the list:
        $.each(dectDevices, function(key, device) {
            var data = {
                id: device.get('id'),
                icon: 'dect',
                name: device.get('name'),
                line: device.get('line'),
                nameDisplay: device.get('name'), // discussed with Marcel, no need to make lowercase
                phoneNumber: device.get('externalNumber'),
                internalNumber: device.get('directoryNumber'),
                outgoingTrunkLine: device.get('outgoingTrunkLine')
            };

            list.append(
                $.tmpl(template, {
                    device: data,
                    popoverEnable: true,
                    popoverTemplateID: 'overview:popovers:device-dect',
                    popoverTemplateData: JSON.stringify(data),
                    popoverContainer: '.current-page .overview',
                    localeStrings: swc.models.Locale.getLocaleStrings(),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                })
            );
        });

        // Reopen popover for selected device:
        if (activeDeviceID) {
            SWCElements.popovers.open(
                $('.device.has-popover[data-dectid="' + activeDeviceID + '"]').find('.icon')
            );
        }
    },

    setWiFiState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating WiFi state");

            // Send requests to update wifi status on the device:
            $.when(
                    swc.models.Wireless.setGlobalStatus(state)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    setCentralStorageState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating Central Storage state");

            // Send requests to update Central Storage status on the device:
            $.when(
                    swc.models.CentralStorage.setGlobalStatus(state)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    setDECTState: function(e) {
        var self = this,
            switcher = $(e.target).hasClass('.swc-switcher') ? $(e.target) : $(e.target).closest('.swc-switcher'),
            state = switcher.hasClass('enable') ? true : false;

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Updating Phones and Dect state");

            // Update Telephony model Dect status:
            swc.models.Telephony.set('dectStatus', state);

            // Send requests to update Telephony status on the device:
            $.when(
                    swc.models.Telephony.setDectStatus()
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    editDevice: function(e) {
        var self = this,
            element = $(e.target),
            type = element.data('type'),
            macAddress = element.data('macaddress'),
            device = swc.models.NetworkDevices.getDevice(macAddress);

        this.customizeDevice({
            device: device,
            type: type,

            onApply: function(options) {
                self.showPageLoading("Updating device information");

                $.when(swc.models.NetworkDevices.customizeDevice(options)).done(function() {
                    $.when(swc.models.NetworkDevices.sync()).done(function() {
                        self.updateNetworkState();
                        self.renderNetworkDevices();
                        self.stopPageLoading();
                    });

                    SWCElements.popovers.open(
                        $('.device[data-macaddress="' + options.deviceMac + '"]').find('.icon')
                    );
                });
            }
        });
    },

    editDect: function(e) {
        var self = this,
            element = $(e.target),
            name = element.data('name'),
            line = element.data('line'),
            device = {
                type: 'dect',
                name: name,
                line: line
            };

        this.customizeDevice({
            device: device,
            type: 'dect',
            template: 'overview:modal-windows:customize-dect',

            onApply: function(options) {

                self.showPageLoading("Updating device information");

                swc.models.Telephony.get('phones').get(line).set({
                    'name': options.name,
                    'is_changed': true
                });

                $.when(swc.models.Telephony.phoneEdit()).done(function(){
                    $.when(swc.models.Telephony.getPhones()).done(function() {
                        self.renderDECTDevices();
                        self.stopPageLoading();
                    });

                    SWCElements.popovers.open(
                        $('.device.has-popover[data-dectid="' + line + '"]').find('.icon')
                    );
                });
            }
        });
    },

    secureRemoveUSB: function(e) {
        var self = this,
            button = $(e.target).hasClass('.button') ? $(e.target) : $(e.target).closest('.button'),
            id = button.data('id');

        // Set small delay on switcher change for more user-friendly behaviour
        setTimeout(function() {

            // Show saving page state:
            self.showPageLoading("Unmounting usb device");

            // Send requests to update Telephony status on the device:
            $.when(
                    swc.models.CentralStorage.removeUSBDevice(id)
                ).done(function() {
                    self.render();
                });
        }, 200);
    },

    loginToCloudService: function(e) {
        var self = this,
            button = $(e.target).hasClass('.button') ? $(e.target) : $(e.target).closest('.button'),
            service = button.hasClass('dropbox') ? 'dropbox' : 'googledrive';

        // Login to selected cloud service:
        swc.models.CloudServices.checkCredentials();
    }
});
;swc.constructors.ParentalView = swc.base.PageView.extend({

    className: 'parental-control',

    models: [
        'NetworkDevices',
        'Schedulers'
    ],

    events: {
        'swc-switcher:change .parental-activate': 'switchParental',
        'expandable:open .expandable-list': 'expandableOpen',
        'expandable:close .expandable-list': 'expandableClose',
        'hover .expandable-list-item:not(.expanded) .device-name': 'highlightIcon'
    },

    highlightIcon: function(event){
        var $icon = $(event.target).closest('.device-name').find('.device.small');

        if (event.type==='mouseenter') {
            $icon.addClass('selected');
        } else {
            $icon.removeClass('selected');
        }
    },

    expandableOpen: function(e, value) {
        this.openedItem = value;
    },

    expandableClose: function(e, value) {
        if (this.openedItem === value) {
            this.openedItem = "";
        }
    },

    save: function() {
        var self = this,
            deferred =  new $.Deferred();

        $.when(swc.models.Schedulers.setDevicesSchedulers())
            .done(function() {
                self.changedScheduler = false;
                deferred.resolve();
            }).fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    switchParental: function(e, value) {
        var element = $(e.target),
            self = this,
            deviceId = element.closest('.expandable-list-item').attr('data-key'),
            model = swc.models.Schedulers.get(deviceId);

        model.set('enable', !!value);
        
        this.showPageLoading("Saving page data..");
        
        $.when(swc.models.Schedulers.addSchedule(deviceId)).done(function() {
            self.changedScheduler = false;
            self.render();
        });
    },

    renderComplete: function() {
        var self = this;
        $.when(swc.models.Schedulers.getDevicesSchedulers()).done(function() {
            self.stopPageLoading();
            self.renderAfterComplete();
        });
    },

    renderAfterComplete: function() {
        var self = this;

        var expandableObj = {
            titleBlocks: {
                "device-name": {
                    translationString: "Device Name"
                },
                "parental-control": {
                    translationString: "Parental Control"
                }
            },

            itemsBlocks: {},

            locales: swc.models.Locale.getLocaleStrings('parental')

        };

        var ItemBlockConstructor = function(deviceName, icon, conType, key, isConnected) {
            this.isEditAble = false;
            this.isDeleteAble = false;
            this.hiddenPart = {
                templateID: "parental:expandable:hidden-part",
                templateValues: {}
            };

            this.blocks = {
                "visible-part": {
                    templateID: "parental:expandable:visible-part",
                    templateValues: {
                        deviceName: deviceName,
                        icon: icon,
                        conType: conType,
                        key: key,
                        isConnected: isConnected
                    }
                }
            };
        };

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(e) {
            self.changedScheduler = true;
            self.$('.save-changes, .cancel-changes').removeClass('disabled');
        });

        var key = 1,
            thirtyDays = 30*24*3600000,

            // Currently connected devices MUST be shown on the top of the list:
            // the devices with parental control settings activated first, then - not activated.
            // Recently connected devices MUST be shown below the currently connected devices:
            // the devices with parental control settings activated first, then - not activated.
            // model.get('active') - currently connected
            // model.get('enable') - parental control
            schedulers = swc.models.Schedulers
                .chain()
                .filter(function(model){
                    return !_.contains(['ap', 'wifi'], model.get('id'));
                })
                .sortBy(function(model){
                    return -( (model.get('active') ? 1 : 0) * 2 + (model.get('enable') ? 1 : 0) );
                })
                .value();

        _.each(schedulers, function(schedule) {
            var device = swc.models.NetworkDevices.where({'mac': schedule.get('id')})[0];

            if (key < 200 && device) {
                var deviceName = device.get('name'),
                    isActive = device.get('status'),
                    connectionType = device.get('interfaceType'),
                    icon = device.get('icon'),
                    mac = device.get('mac'),
                    isEnabled = schedule.get('enable') ? true : false,

                    // we use moment.js here for date conversion because IE sometimes cannot parse
                    // the format that is coming from the serverside
                    lastConnection = moment(device.get('lastConnection')).unix() * 1000,
                    now = new Date().getTime();

                if (isEnabled || now - lastConnection < thirtyDays) {
                    expandableObj.itemsBlocks[mac] =
                        new ItemBlockConstructor(deviceName, icon, connectionType, key, isActive);
                    key++;
                }
            }
        });


        this.$('.expandable-devices').html(
            self.generateExpandableList(expandableObj)
        );

        _.map(expandableObj.itemsBlocks, function(objItem, mac){
            var connected = objItem.blocks['visible-part'].templateValues.isConnected;
            self.$el.find(".expandable-list-item[data-key='"+mac+"']").addClass( connected ? "connected" : "disconnected" );
        });

        this.$('.expandable-devices .scheduler-container').each(function() {
            var container = $(this);
            var deviceId = container.closest('.expandable-list-item').attr('data-key');
            var deviceModel = swc.models.Schedulers.find(function(model) {
                return model.id === deviceId;
            });

            var isDisabled = !deviceModel.get('enable');

            container.closest('.expandable-list-item').find('.parental-activate')
                .trigger('swc-switcher:swc-change', !isDisabled);

            var template = new swc.constructors.SchedulerLiner({
                'isDisabled': isDisabled,
                'scaleWidth' : 432,
                'diapazones' : deviceModel.get('pixelSchedule'),
                'model': deviceModel,
                'schedulerType': 'device'
            });
            container.html(template.el);
        });

        if (!self.openedItem) {
            self.openedItem = this.$('.expandable-list-item').eq(0).attr('data-key');
        }

        this.$(".expandable-list").trigger('expandable:swc-open', self.openedItem);
    }
});
;swc.constructors.PowerView = swc.base.PageView.extend({

    className: 'power-settings',

    models: ['Wireless', 'Schedulers', 'Telephony', 'ApplicationPart'],

    events: {
        'click .power-settings-cancel:not(.disabled)': 'cancelSettings',
        'click .power-settings-apply:not(.disabled)': 'applySettings',
        'swc-checkbox:change .wifi .enable-service-schedule':'changeWifiScheduler',
        'swc-checkbox:change .storage .enable-service-schedule':'changeStorageScheduler',
        'swc-checkbox:change .enable-eco-mode':'enableEcoMode',
        'expandable:open .expandable-list': 'expandableOpen',
        'swc-switcher:change .swc-switcher.enable-wifi-service': 'changeWifiState',
        'swc-switcher:change .swc-switcher.enable-storage-service': 'changeAPState',
        'swc-switcher:change .swc-switcher.enable-dect-service': 'changeDectState'

    },

    changedScheduler: false,

    changeWifiScheduler: function(e, value){
        swc.models.Schedulers.get('wifi').set('enable', value);
        this.renderComplete();
        this.activateButtons();
    },

    changeStorageScheduler: function(e, value){
        swc.models.Schedulers.get('ap').set('enable', value);
        this.renderComplete();
        this.activateButtons();
    },

    enableEcoMode: function(e, value){
        swc.models.Telephony.set('dectEco', value);
        this.renderComplete();
        this.activateButtons();
    },

    changeWifiState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        // Send requests to update wifi status on the device:
        $.when(
                swc.models.Wireless.setGlobalStatus(value)
            ).done(function() {
                $.when(swc.models.Wireless.sync()).done(function() {
                    self.render();
                });
            });
    },

    changeAPState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        swc.models.ApplicationPart.set('serviceState', value);

        $.when(swc.models.ApplicationPart.setServiceState()).done(function() {
            self.render();
        });
    },

    changeDectState: function(e, value){
        var self = this;
        self.changedScheduler = false;
        // Show saving page state:
        this.showPageLoading(getTranslationStrings("Saving page data.."));

        swc.models.Telephony.set('dectStatus', value);

        $.when(swc.models.Telephony.setDectStatus()).done(function() {
            self.render();
        });

    },

    expandableOpen: function(e, value){
        this.openedItem = value;
    },

    cancelSettings: function(){
        this.changedScheduler = false;
        this.render();
    },

    activateButtons: function(){
        var self = this;
        if (this.changedScheduler || !this.pageCheckDefaultValues()) {
            this.$('.save-success').hide();
            this.$('.buttons-container-message a').removeClass('disabled');
        } else {
            this.$('.buttons-container-message a').addClass('disabled');
        }
    },

    applySettings: function(){
        var self = this, empty = swc.models.Schedulers.emptySchedulers, deferredsArray = [];
        self.changedScheduler = false;

        if (empty.length > 1) {
            self.bothModal();
        } else if (empty[0] === 'wifi') {
            self.wifiModal();
        } else if (empty[0] === 'ap') {
            self.storageModal();
        } else {
            self.showPageLoading(getTranslationStrings("Saving power settings.."));
            deferredsArray = [swc.models.Schedulers.addSchedule('wifi'), swc.models.Telephony.setDectEco()];
            if (swc.models.Application.get('GlobalEnable')) {
                deferredsArray.push(swc.models.Schedulers.addSchedule('ap'));
            }
            $.when.apply(this, deferredsArray).done(function(){
                self.showSuccessMessage = true;
                self.render();
            });
        }
    },

    wifiModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:wifi:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Schedulers.addSchedule('ap'), swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(){
                        self.render();
                    });
            }
        });
    },

    storageModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:ap:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Schedulers.addSchedule('wifi'), swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.models.ApplicationPart.set('serviceState', false);
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.ApplicationPart.setServiceState()
                    ).done(function(){
                        self.render();
                    });
            }
        });

    },

    bothModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:both:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                $.when(swc.models.Telephony.setDectEco()).done(function(){
                    self.render();
                });
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.models.ApplicationPart.set('serviceState', false);
                self.showPageLoading(getTranslationStrings('Saving page data..'));
                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Schedulers.addSchedule('ap'),
                        swc.models.Telephony.setDectEco(),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(){
                        // We should turn off AP after all
                        $.when(swc.models.ApplicationPart.setServiceState()).done(function(){
                            self.render();
                        });
                    });
            }
        });
    },

    setTemplateData: function(){
        var wifiState,
            apState,
            dectState,
            dectEcoState,
            wifiSchedulerModel,
            apSchedulerModel;


        wifiState = (swc.models.Wireless.getParameter("status", "status") === 'on');
        apState = swc.models.ApplicationPart.get('serviceState');

        wifiSchedulerModel = swc.models.Schedulers.get('wifi');
        apSchedulerModel = swc.models.Schedulers.get('ap');

        dectState = swc.models.Telephony.get('dectStatus');
        dectEcoState = swc.models.Telephony.get('dectEco');

        this.templateData = {
            wifiState: wifiState,
            wifiSchedule: wifiSchedulerModel.get('enable'),
            apState: apState,
            apSchedule: apSchedulerModel.get('enable'),
            dectActivated: dectState,
            dectEco: dectEcoState,
            GlobalEnable: swc.models.Application.get('GlobalEnable')
        };
    },

    renderComplete: function(){
        var self = this,
            wifiSchedulerModel,
            apSchedulerModel,
            wifiState,
            apState,
            dectState,
            dectEcoState,
            wifiStatusBlock,
            apStatusBlock,
            dectStatusBlock;

        this.setTemplateData();

        wifiState = (swc.models.Wireless.getParameter("status", "status") === 'on');
        apState = swc.models.ApplicationPart.get('serviceState');

        dectState = swc.models.Telephony.get('dectStatus');
        dectEcoState = swc.models.Telephony.get('dectEco');

        wifiSchedulerModel = swc.models.Schedulers.get('wifi');
        apSchedulerModel = swc.models.Schedulers.get('ap');

        wifiStatusBlock = this.$('.wifi-statuses');
        apStatusBlock = this.$('.ap-statuses');
        dectStatusBlock = this.$('.dect-statuses');

        $('.wifi-statuses, .dect-statuses, .ap-statuses').find('.text span').hide();
        $('.leaf').removeClass('disabled');

        if (wifiSchedulerModel.get('enable') && wifiState) {
            wifiStatusBlock.find('.text .activated-schedule').show();
        } else if (wifiState) {
            wifiStatusBlock.find('.leaf').addClass('disabled');
            wifiStatusBlock.find('.text .not-activated').show();
        } else {
            wifiStatusBlock.find('.text .activated-disable').show();
        }

        if (apSchedulerModel.get('enable') && apState) {
            apStatusBlock.find('.text .activated-schedule').show();
        } else if (apState) {
            apStatusBlock.find('.leaf').addClass('disabled');
            apStatusBlock.find('.text .not-activated').show();
        } else {
            apStatusBlock.find('.text .activated-disable').show();
        }

        if (dectEcoState && dectState) {
            dectStatusBlock.find('.text .activated-eco').show();
        } else if (dectState) {
            dectStatusBlock.find('.leaf').addClass('disabled');
            dectStatusBlock.find('.text .not-activated').show();
        } else {
            dectStatusBlock.find('.text .activated-disable').show();
        }

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(){
            self.changedScheduler = true;
            self.activateButtons();
        });

        var wifiBlock = this.$('.expandable-list-item.wifi'),
            storageBlock = this.$('.expandable-list-item.storage');

        var wifiScheduler = new swc.constructors.SchedulerLiner({
            isDisabled: !self.templateData.wifiSchedule,
            scaleWidth: 432,
            diapazones: wifiSchedulerModel.get('pixelSchedule'),
            model: wifiSchedulerModel,
            schedulerType: 'wifi'
        });

        var storageScheduler = new swc.constructors.SchedulerLiner({
            isDisabled: !self.templateData.apSchedule,
            scaleWidth: 432,
            diapazones: apSchedulerModel.get('pixelSchedule'),
            model: apSchedulerModel,
            schedulerType: 'storage'
        });

        wifiBlock.find('.scheduler-container').empty().append(wifiScheduler.el);
        storageBlock.find('.scheduler-container').empty().append(storageScheduler.el);

        if (!self.openedItem) {
            self.openedItem = this.$('.expandable-list-item').eq(0).attr('data-key');
        }

        this.$(".expandable-list").trigger('expandable:swc-open', self.openedItem);

        self.checkPermissions();

        if (this.showSuccessMessage) {
            this.showSuccessMessage = false;
            this.$('.save-success').show();
        }
    }

});
;swc.constructors.SystemDiagnosticsView = swc.base.PageView.extend({

    className: 'system-diagnostics',

    models: ['Network']

});
;swc.constructors.SystemDiagnosticsGatewayView = swc.base.TabView.extend({

    className: 'gateway',

    models: ['System', 'Network', 'FirewallStatus'],

    setTemplateData: function() {
        var systemData = swc.models.System.attributes,
            wanData = swc.models.Network.get('status').attributes;

        this.templateData = {
            'build': swc.settings.application.get('build'),
            'manufacturer': systemData.manufacturer,
            'serial': systemData.serialNumber,
            'model': systemData.model,
            'localIP': swc.models.Network.get('ip-settings').get('LocalIPAddress'),
            'localIPv6': swc.Utils.formatIPv6Address(wanData.IPv6Address),
            'storageIP': wanData.StorageIPAddress,
            'mac': wanData.MacAddress,
            'NPFirmware': systemData.NPVersion || '0.0.0',
            'APFirmware': systemData.APVersion || '0.0.0',
            'IPv6Status': swc.models.FirewallStatus.get('state').Enable,
            'GlobalEnable': swc.models.Application.get('GlobalEnable')
        };
    },

    renderComplete: function(){
        var self = this,
            element = $(this.el),
            systemData = swc.models.System.attributes;

            // generates object
            // d: { translation: "d0", value: 0 },
            // h: { translation: "h", value: 23 },
            // m: { translation: "h1", value: 1 }
            var upTime = _.object(_.map(systemData.upTime, function(value, key) {
                var item, translation;

                if (value === 0) {
                    translation = key + '0';
                } else if (value === 1) {
                    translation = key + '1';
                } else {
                    translation = key;
                }

                item = [
                    key, {
                        value: value,
                        translation: translation
                    }
                ];

                return item;
            }));

        element.find('.uptime').html($.tmpl(swc.Templates.get('system:diagnostics:upTimeTmpl').get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate,
            upTime: upTime
        }));
    }
});
;swc.constructors.GatewayPasswordModalView = Backbone.View.extend({
    className: 'modal gateway-password',

    tagName: 'div',

    hidden: false,

    events: {
        'click .logout': 'startLogout'
    },

    startLogout: function(){
        $(this.el).modal('hide');
        this.remove();
        swc.models.Login.processLogout({ action: 'user-logout' });
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:gateway:modal');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));
    }

});;swc.constructors.SystemDiagnosticsOverviewView = swc.base.TabView.extend({

    className: 'overview',

    events: {
        'click .export-log': 'exportLogs'
    },

    models: ['Network', 'System', 'DeviceMeasurements', 'DynDNS', 'DynDNSProviderCollection'],

    exportLogs: function(e){
        swc.models.System.getLogs();
    },

    setTemplateData: function(){
        var dnsProvider = swc.models.DynDNSProviderCollection.at(0),
            dnsProviderData;
        
        if (!_.isEmpty(dnsProvider)) {
            var lastUpdate = dnsProvider.get('last_update');

            if (lastUpdate && lastUpdate !== "0001-01-01T00:00:00Z") {
                lastUpdate = moment(lastUpdate).zone(lastUpdate).format("DD.MM.YYYY, HH:mm");
            } else {
                lastUpdate = '';
            }

            dnsProviderData = {
                service: dnsProvider.get('service').capitalize(),
                status: dnsProvider.get('status'),
                lastUpdate: lastUpdate
            };
        }
        
        this.templateData = {
            'netStatus': swc.models.Network.get('status').toJSON(),
            'GlobalEnable': swc.models.Application.get('GlobalEnable'),
            'dyndnsStatus': swc.models.DynDNS.get('enable'),
            'dnsProviderData': dnsProviderData
        };
        _.extend(
            this.templateData,
            swc.models.DeviceMeasurements.getParams()
        );
    }
});
;swc.constructors.SystemDisplayView = swc.base.PageView.extend({

    className: 'system-display',

    models: ['Screen'],

    events: {
        'swc-dropdown:change .time-selection': 'changeSettings',
        'swc-dropdown:change .language-selection': 'changeSettings',
        'swc-checkbox:change .show-wifi-password': 'changeSettings'
    },

    setTemplateData: function() {
        this.templateData = {
            time: swc.models.Screen.get('brightTime'),
            lang: swc.models.Screen.get('lang'),
            show: swc.models.Screen.get('showPass')
        };
    },

    activateButtons: function() {
        if (this.pageCheckDefaultValues()) {
            this.$('.buttons-container-message a').addClass('disabled');
        } else {
            this.$('.buttons-container-message a').removeClass('disabled');
        }
    },

    changeSettings: function() {
        var self = this;

        swc.models.Screen.set({
            'brightTime': this.$('.swc-dropdown.time-selection').data('value'),
            'lang': this.$('.swc-dropdown.language-selection').data('value'),
            'showPass': this.$('.swc-checkbox.show-wifi-password').data('value')
        });

        this.activateButtons();
    },

    save: function(e) {
        var deferred = new $.Deferred();

        $.when(swc.models.Screen.setParameters())
            .done(function() {
                deferred.resolve();
            })
            .fail(function () {
                deferred.reject();
            });

        return deferred.promise();
    },

    renderComplete: function() {
        var self = this,
            timeEl = this.$('.swc-dropdown.time-selection'),
            langEl = this.$('.swc-dropdown.language-selection'),
            showEl = this.$('.swc-checkbox.show-wifi-password');

        var localeSec = swc.models.Locale.getLocaleStrings("system").sec;

        timeEl.data('options', {
            '30': {
                'value': '30',
                'name': '30 '+localeSec
            },
            '60': {
                'value': '60',
                'name': '60 '+localeSec
            },
            '120': {
                'value': '120',
                'name': '120 '+localeSec
            }
        });

        langEl.data('options', {
            'DE': {
                'value': 'DE',
                'name': 'Deutsch'
            },
            'FR': {
                'value': 'FR',
                'name': 'Français'
            },
            'IT': {
                'value': 'IT',
                'name': 'Italiano'
            },
            'EN': {
                'value': 'EN',
                'name': 'English'
            }
        });

        timeEl.trigger('swc-dropdown:swc-change', swc.models.Screen.get('brightTime'));
        langEl.trigger('swc-dropdown:swc-change', swc.models.Screen.get('lang'));
        showEl.trigger('swc-checkbox:swc-change', swc.models.Screen.get('showPass'));
    }

});;swc.constructors.SystemSettingsResetView = swc.base.TabView.extend({

    className: 'reset',

    models: ['System', 'Telephony', 'apServiceState'],

    events: {
        'click .factory-reset':  'onFactoryReset',
        'click .save-config':    'onSaveConfig',
        'click .restore-config': 'onRestoreConfig'
    },
    
    preRender: function() {
        // We have to load model `apServiceLoadingState` only if AP is enabled
        if (swc.models.apServiceState.isEnabled()) {
            swc.models.apServiceLoadingState = new swc.constructors.apServiceLoadingState();
        }
    },

    /**
     * Handler when user clicks on backup button:
     *
     * @description:
     *
     *  When user clicks on backup button, he must be shown modal window, where he will choose backup option. If user will
     *  choose `backup to acs network` -> new RPC call will be invoked, else he will go through default procedure of backup
     */
    onSaveConfig: function(e) {
        var self = this;

        e.preventDefault();

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.showModalSaveConfig();
        });
    },

    /**
     * Show save config modal window
     *
     * @description: show modal window with switcher:
     *  - save configuration in the Swisscom Customer Center (backupPlace = acs)
     *  - Save configuration in the file locally on your computer (backupPlace = local)
     *
     * After pushing button "Apply" the save process starts
     *
     * @localParam backupPlace {String} Place where the configuration
     *             settings will be saved (local | acs)
     */
    showModalSaveConfig: function() {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:modal-windows:backup-settings',
            tempalteData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },
            className: 'backup-settings',

            onApply: function() {
                var backupPlace = $('.modalWindow.backup-settings').find('.backup-options').data('value');

                SWCElements.modalWindow.hide();
                self.processSaveConfig(backupPlace);
            }
        });
    },

    /**
     * Start process of data backup according to selected
     * place for saving configuration
     *
     * @param backupPlace {String} local | acs
     */
    processSaveConfig: function(backupPlace) {
        if (backupPlace === "local") {
            this.doBackupLocal();
        } else {
            this.doBackupAcs();
        }
    },

    /**
     * Handler when backup finishes
     *
     * @param status {Boolean} -> status of backup process (true - succes, false - fail)
     */
    onBackupComplete: function(status) {
        var messagesContainer = this.$('.buttons-container-message.save-config-message');

        // Remove loading window:
        swc.views.Application.stopPageLoading();

        // Display message about success / fail saving:
        if (status === true) {
            messagesContainer.find('.save-error').hide();
            messagesContainer.find('.save-success').show();
        } else {
            messagesContainer.find('.save-success').hide();
            messagesContainer.find('.save-error').show();
        }
    },

    /**
     * Create local backup file
     *
     * @returns {*}
     */
    doBackupLocal: function() {
        var self = this,
            deferred = new $.Deferred();

        // Create backup iframe and hide it by default:
        this.backupIframe = $.tmpl(swc.Templates.get('system:settings:backup:iframe').get('content'),
            { context: $.cookie(getDeviceID() + '/context') }
        );

        // Append it to body:
        $('body').append(this.backupIframe);

        // Display loading message:
        swc.views.Application.showPageLoading('Downloading Backup File');

        // Call RPC endpoint to create a backup file:
        $.when(swc.models.System.configBackup())
            .done(function() {
                self.onBackupComplete(true);
            })
            .fail(function() {
                self.onBackupComplete(false);
            });

        return deferred.promise();
    },

    /**
     * Save device settings to swisscom ACS network:
     */
    doBackupAcs: function() {
        var self = this;

        // Display loading message:
        swc.views.Application.showPageLoading('Downloading Backup File');

        // Call RPC endpoint to save settings to Swisscom ACS network:
        $.when(swc.models.System.configBackupACS())
            .done(function() {
                self.onBackupComplete(true);
            })
            .fail(function() {
                self.onBackupComplete(false);
            });
    },

    wrongFileModal: function() {
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:restore:modal:restore-wrongfile',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-restore',
            onCancel: function() {
                self.removeForm();
            }
        });
    },

    confirmModal: function() {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:restore:modal:restore-confirm',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                filename: self.fileName
            },
            onShow: function(){
                var modal = $('.modalWindow');
                modal.find('.apply-changes').on('click', function (e) {
                    SWCElements.modalWindow.hide();
                    self.processRestoreConfig();
                    self.form.submit();
                });


            },
            className: 'system-restore',
            onCancel: function() {
                self.removeForm();
            }
        });
    },

    processRestoreConfig: function() {
        var self = this;
        
        SWCElements.modalWindow.show({
            templateID: 'system:settings:restore:modal:restore-process',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-restore',
            onShow: function(){
                var element = $('.modalWindow'),
                    isSuccess = false,
                    restoreTime = swc.models.System.minExpectedRebootTime,
                    resetRuler;
                
                element.find('.ruler-block').html($.tmpl(swc.Templates.get('ruler').get('content'), {
                    'className': 'restore-ruler'
                }));
                
                // NOTE:
                // Don't try to move it into `var` initialization section,
                // because element will be present only if previous LOC executed 
                resetRuler = element.find('.restore-ruler');

                // NP throws custom event to document if upload was successful.
                // If we haven't received event for 2 minutes, or event was not successful, throw error
                $(document).off('sah:models:System:state');
                $(document).on('sah:models:System:state', function(e, options){
                    if(options === 'restore-success'){
                        isSuccess = true;
                    } else {
                        setTimeout(function(){
                            resetRuler.trigger('swc-ruler:finish');
                        }, 50);
                    }
                });

                var postRestoreCallback = function() {
                    self.removeForm();
                    // clean local storage with saved language
                    localStorage.removeItem('locale');
                    swc.models.System.doLogout();
                };

                resetRuler.on('swc-ruler:finish', function(){
                    if(isSuccess){
                        if (swc.models.apServiceState.isEnabled()) {
                            swc.models.System.whenApUp(postRestoreCallback);
                        } else {
                            swc.models.System.whenDeviceUp(postRestoreCallback);
                        }
                    } else {
                        SWCElements.modalWindow.hide();
                        self.errorModal();
                    }
                });

                setTimeout(function(){
                    resetRuler.trigger('swc-ruler:start', {time: restoreTime});
                }, 0);
            }
        });
    },

    errorModal: function() {
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:restore:modal:restore-error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-restore',
            onCancel: function() {
                self.removeForm();
            }
            /*
             onApply: function(){
             SWCElements.modalWindow.hide();
             self.confirmModal();
             }
             */
        });
    },

    removeForm: function(){
        if(this.restoreIframe){
            this.restoreIframe.remove();
        }
        if(this.saveIframe){
            this.saveIframe.remove();
        }
    },

    onRestoreConfig: function() {
        this.restoreConfig();
    },

    restoreConfig: function() {
        var self = this;

        this.restoreIframe = $.tmpl(swc.Templates.get('system:settings:restore:iframe').get('content'), {});
        this.form = $('#restore-form');

        this.restoreIframe.hide();
        $('body').append(this.restoreIframe);

        this.form.find('input[name="context"]').val($.cookie(getDeviceID() + '/context'));

        this.form.find('#config-restore').on('change', function(){
            var filePath = self.form.find('input[type=file]').val(), fileExtension;

            if(filePath.indexOf('\\') < 0){
                self.fileName = filePath;
            } else {
                self.fileName = filePath.slice(filePath.lastIndexOf("\\")+1, filePath.length);
            }

            fileExtension = self.fileName.slice(self.fileName.lastIndexOf(".")+1, self.fileName.length);

            if(self.fileName && fileExtension === 'cfg') {
                // before show modal window the session state should be checked
                swc.models.System.checkSessionState(function() {
                    self.confirmModal();
                });
            } else {
                self.wrongFileModal();
            }
        });
    },

    /**
     * Event handler: is fired on click button 'Reset to factory settings'
     *
     * @param e
     */
    onFactoryReset: function(e) {
        var self = this;

        e.preventDefault();

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.showModalFactoryReset();
        });
    },

    /**
     * Show factory reset modal window
     *
     * @description: show modal window with switcher
     *  - reset with saving DECT pairing
     *  - complete reset
     *
     *  After pushing button "Apply" this modal window closes and
     *  the modal window with progress bar appears. The reset process
     *  is started in background
     */
    showModalFactoryReset: function() {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:reset:modal',
            tempalteData: {
                localeStrings: swc.models.Locale.getLocaleStrings("system"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'reset-gateway',

            onApply: function() {
                var resetType = $('.modalWindow.reset-gateway').find('.reset-type').data('value'),
                    resetDect = resetType === 'with';

                SWCElements.modalWindow.hide();
                self.processFactoryReset(resetDect);
            }
        });
    },

    /**
     * Show modal window with progress bar and start reset device process.
     * When the device is up then modal window disappears
     *
     * @param resetDect
     */
    processFactoryReset: function(resetDect) {
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:reset-process:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings("system"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-restore',
            onShow: function(){
                var element = $('.modalWindow'),
                    resetTime = swc.models.System.minExpectedRebootTime,
                    resetRuler;

                element.find('.ruler-block').html($.tmpl(swc.Templates.get('ruler').get('content'), {
                    'className': 'reset-ruler'
                }));

                resetRuler = element.find('.reset-ruler');

                // hide modal window only when device is up
                swc.models.System.on('device:up', function () {
                    SWCElements.modalWindow.hide();
                });

                setTimeout(function(){
                    resetRuler.trigger('swc-ruler:start', {time: resetTime});
                }, 10);

                // if resetDect is true, we reset dect at first. Otherwise, start reset gateway immediately
                if(resetDect){
                    $.when(swc.models.Telephony.dectReset(), swc.models.Telephony.dectRemoveDects()).done(function(){
                        swc.models.System.resetGateway(resetTime);
                    });
                } else {
                    swc.models.System.resetGateway(resetTime);
                }
            }
        });
    }

});
;swc.constructors.SystemSettingsGatewayView = swc.base.TabView.extend({

    className: 'gateway',

    passwordChanged: false,

    models: ['System', 'PasswordRecovery'],

    events: {
        'swc-checkbox:change .show-current-password': 'showPassword',
        'swc-checkbox:change .enable-recovery': 'changeRecovery',
        'keyup input[class*=password]': 'passChanged',
        'change input[class*=password]': 'passChanged',
        'change input.new-password-1': 'validatePassword',
        'change input.new-password-2': 'validatePassword'
    },

    setTemplateData: function() {
        this.templateData = {
            recoveryEnable: swc.models.PasswordRecovery.get('recoveryEnable')
        };
    },

    changeRecovery: function(e, value) {
        var self = this;
        swc.models.PasswordRecovery.set('recoveryEnable', value);
        this.activateButtons();
    },

    passChanged: function() {
        var currentPass = this.$('input[name=current-password]').val(),
            newPass1 = this.$('input[name=new-password-1]').val(),
            newPass2 = this.$('input[name=new-password-2]').val();

        // If at least one of password fields are not empty, we will validate them
        this.passwordChanged = currentPass || newPass1 || newPass2;

        this.activateButtons();
    },

    /**
     * Save "recovery" status if it was changed
     */
    applyRecovery: function() {
        var self = this,
            deferred = new $.Deferred();

        function saveData() {
            $.when(swc.models.PasswordRecovery.sync("update"))
                .done(function() {
                    SWCElements.modalWindow.hide();
                    deferred.resolve();
                });
        }

        if (swc.models.PasswordRecovery.get('recoveryEnable')) {
            saveData();
        } else {
            SWCElements.modalWindow.show({
                templateID: 'system:settings:gateway:modal:set-recovery',
                templateData: {
                    localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                    localeString: getTranslationStringsjQuery,
                    formatDate: swc.models.Locale.formatDate
                },
                className: 'cloud-unchecked',
                
                onCancel: function() {
                    swc.models.PasswordRecovery.set('recoveryEnable', true);
                    deferred.reject();
                },
                
                onApply: function() {
                    saveData();
                }
            });
        }

        return deferred.promise();
    },

    /**
     * Change password
     */
    applyPassword: function() {
        var self = this,
            deferred = new $.Deferred(),
            currentPass = this.$('input[name=current-password]').val(),
            newPass1 = this.$('input[name=new-password-1]').val(),
            newPass2 = this.$('input[name=new-password-2]').val();
        
        this.$('.save-success, .save-error').hide();

        function changePassword() {
            $.when(swc.models.Login.changePassword(newPass1))
                .done(function(resp) {
                    if (!resp) {
                        deferred.reject();
                    } else {
                        deferred.resolve();
                    }
                })
                .fail(function() {
                    deferred.reject();
                });
        }

        if (self.validatePasswordsMatch()) {
            $.when(swc.models.System.checkPassword(currentPass))
                .done(function(resp) {
                    if (!resp) {
                        deferred.reject();
                    } else {
                        changePassword();
                    }
                })
                .fail(function() {
                    deferred.reject();
                });
        } else {
            deferred.reject();
        }

        return deferred.promise();
    },

    /**
     * if 'recovery' status was changed - at the first save recovery status, then save password
     */
    save: function() {
        var self = this,
            deferred = $.Deferred();

        swc.models.System.checkSessionState(function () {
            if (swc.models.PasswordRecovery.hasChanged() && self.passwordChanged) {
                $.when(self.applyRecovery())
                    .always(function () {
                        $.when(self.applyPassword())
                            .done(function() {
                                deferred.resolve();
                            })
                            .fail(function() {
                                deferred.reject();
                            });
                    });
            } else if (swc.models.PasswordRecovery.hasChanged()) {
                $.when(self.applyRecovery())
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            } else {
                $.when(self.applyPassword())
                    .done(function() {
                        deferred.resolve();
                    })
                    .fail(function() {
                        deferred.reject();
                    });
            }
        });

        return deferred.promise();
    },

    showPassword: function() {
        var self = this,
            visibleField = this.$('input[name=current-password]'),
            invisibleField = this.$('input[name=current-password-copy]'),
            visibleField1 = this.$('input[name=new-password-1]'),
            invisibleField1 = this.$('input[name=new-password-1-copy]'),
            visibleField2 = this.$('input[name=new-password-2]'),
            invisibleField2 = this.$('input[name=new-password-2-copy]');

        invisibleField.val(visibleField.val());
        invisibleField1.val(visibleField1.val());
        invisibleField2.val(visibleField2.val());

        visibleField.removeClass('current-password')
            .addClass('current-password-copy')
            .attr('name', 'current-password-copy');

        invisibleField.addClass('current-password')
            .removeClass('current-password-copy')
            .attr('name', 'current-password');

        visibleField1.removeClass('new-password-1')
            .addClass('new-password-1-copy')
            .attr('name', 'new-password-1-copy');

        invisibleField1.addClass('new-password-1')
            .removeClass('new-password-1-copy')
            .attr('name', 'new-password-1');

        visibleField2.removeClass('new-password-2')
            .addClass('new-password-2-copy')
            .attr('name', 'new-password-2-copy');

        invisibleField2.addClass('new-password-2')
            .removeClass('new-password-2-copy')
            .attr('name', 'new-password-2');

        self.delegateEvents();
    },

    activateButtons: function() {
        var self = this;

        if (this.pageCheckDefaultValues()) {
            this.$('.buttons-container-message a').addClass('disabled');
        } else {
            this.$('.buttons-container-message a').removeClass('disabled');
        }
    },

    /**
     * New password validation
     * @returns {boolean}
     */
    validatePassword: function() {
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            validationMessages = [];

        this.$('.validation-message').hide();
        this.$('input').removeClass('error valid');

        // Check initial password
        if (newPass1Val) {
            if (!window.validatePassword(newPass1Val)) {
                validationMessages.push('invalid password');
            }
        } else if (!newPass1Val) {
            validationMessages.push('invalid password');
        }

        if (validationMessages.length > 0) {
            newPass1.addClass('error').siblings('input').addClass('error');
            this.$('.pass1.validation-message, .pass1 .validation-message, .pass1 .error-message').show();
        } else {
            newPass1.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    },

    /**
     * Check if password confirmed right
     * @returns {boolean}
     */
    validatePasswordsMatch: function () {
        var self = this,
            newPass1 = this.$('input[name=new-password-1]'),
            newPass1Val = $.trim(newPass1.val()),
            newPass2 = this.$('input[name=new-password-2]'),
            newPass2Val = $.trim(newPass2.val()),
            validationMessages = [];

        // Check confirmation password
        if (newPass2Val) {
            if (newPass1Val !== newPass2Val) {
                validationMessages.push('passwords do not match');
            }
        } else {
            validationMessages.push('passwords do not match');
        }

        if (validationMessages.length > 0) {
            newPass2.addClass('error').siblings('input').addClass('error');
            this.$('.pass2.validation-message, .pass2 .validation-message, .pass2 .error-message').show();
        } else {
            newPass2.addClass('valid').siblings('input').addClass('valid');
        }

        return validationMessages.length === 0;
    }

});
;swc.constructors.RebootModalView = Backbone.View.extend({
    className: 'modal reboot-gateway',

    tagName: 'div',

    hidden: false,

    events: {
        'click .cancel-reboot': 'closeModal',
        'click .start-reboot': 'startReboot'
    },

    closeModal: function(){
        $(this.el).modal('hide');
    },

    startReboot: function(e){
        e.preventDefault();

        var rebootProcessModal = new swc.constructors.RebootProcessModalView();

        swc.models.Login.on('beforeLogout', rebootProcessModal.closeModal, rebootProcessModal);

        $(rebootProcessModal.el).on('hidden', function(){
            $(rebootProcessModal.el).remove();
        });

        this.closeModal();
        rebootProcessModal.$el.modal({backdrop: 'static',keyboard: false});
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:reboot:modal');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));
    }

});;swc.constructors.RebootProcessModalView = Backbone.View.extend({
    className: 'modal reboot-gateway',

    tagName: 'div',

    events: {
        'click .close-modal': 'closeModal'
    },

    initialize: function(){
        this.template = swc.Templates.get('system:settings:reboot-process:modal');
        this.rulerTemplate = swc.Templates.get('ruler');
        this.render();
    },

    closeModal: function(){
        $(this.el).modal('hide');
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.template.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("system"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));

        element.find('.ruler-block').html($.tmpl(self.rulerTemplate.get('content'), {
            'className': 'reboot-ruler'
        }));

        setTimeout(function(){
            element.find('.reboot-ruler').trigger('swc-ruler:start', {time: swc.models.System.minExpectedRebootTime});
        }, 0);

        swc.models.System.rebootGateway(swc.models.System.minExpectedRebootTime)
            .fail(function () {
                self.$('.progress-block').addClass('hidden');
                self.$('.error-message').removeClass('hidden');
            });
        swc.models.System.on('device:up', function () {
            self.$el.modal('hide');
        });

    }

});
;swc.constructors.SystemSettingsRebootView = swc.base.TabView.extend({

    className: 'reboot',

    models: ['System', 'apServiceState'],

    events: {
        'click .reboot-gateway': 'onProcessReboot'
    },

    preRender: function() {
        // We have to load model `apServiceLoadingState` only if AP is enabled
        if (swc.models.apServiceState.isEnabled()) {
            swc.models.apServiceLoadingState = new swc.constructors.apServiceLoadingState();
        }
    },

    onProcessReboot: function(e) {
        var self = this;

        e.preventDefault();

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.processReboot();
        });
    },

    processReboot: function(){
        var rebootModal = new swc.constructors.RebootModalView();

        swc.models.Login.on('beforeLogout', rebootModal.closeModal, rebootModal);

        $(rebootModal.el).on('hidden', function(){
            $(rebootModal.el).remove();
        });

        rebootModal.$el.modal({backdrop: 'static',keyboard: false});

    }

});
;swc.constructors.SystemSettingsView = swc.base.PageView.extend({

    className: 'system-settings'

});;swc.constructors.SystemSettingsFirmwareView = swc.base.TabView.extend({

    className: 'firmware',

    models: ['System', 'apServiceLoadingState'],

    allowedMods: ['expert'],
    
    fileExtension: null,

    events: {
        'click .upgrade-config:not(.disabled)': 'onUpgradeConfig',
        'click .upgrade-process:not(.disabled)': 'onUpgradeProcess'
    },

    setTemplateData: function(){
        var buildInfo = swc.settings.application.get('build');
        
        this.templateData = {
            GlobalEnable: swc.models.Application.get('GlobalEnable'),
            npVersion: swc.models.System.get('NPVersion') || '0.0.0',
            apVersion: swc.models.System.get('APVersion') || '0.0.0',
            uiVersion: buildInfo["StargateWebUI-dev build"] ? buildInfo["StargateWebUI-dev build"] : null
        };
    },

    wrongFileModal: function(){
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-wrongfile',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                GlobalEnable: swc.models.Application.get('GlobalEnable')
            },
            className: 'system-restore',
            onCancel: function() {
                self.clearForm();
            }
        });
    },

    processModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-process',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-upgrade',
            onShow: function(){
                var element = $('.modalWindow'),
                    // Upgrade time is not fixed value; we play with it from time to time
                    // in order to be consistent with progress bar in WebUI
                    // Current value is just temporary result of experiments
                    upgradeTime = swc.models.System.maxExpectedRebootTime + swc.models.System.minExpectedRebootTime,
                    resetRuler,
                    fileField,
                    fileType,
                    file,
                    formData;
                element.find('.ruler-block').html($.tmpl(swc.Templates.get('ruler').get('content'), {
                    'className': 'reset-ruler'
                }));

                resetRuler = element.find('.reset-ruler');

                fileField = self.form.find('input[type=file]');
                fileType = fileField.attr('name');
                file = fileField[0].files[0]; // file object

                formData = new FormData();

                // append the fileobject to the formdata
                // !! the filetype should be used as the name for the entry
                formData.append(fileType, file);

                // send the POST request to /webuiUpgrade
                $.when(swc.models.System.upgradeGateway(formData))
                    .done(function(){
                        // NP sends response immediately after file with firmware was uploaded,
                        // but after that actually upgrade starts, so let's wait for a while to not ping NP too early
                        setTimeout(function() {
                            var postUpgradeCallback = function() {
                                self.clearForm();
                                swc.models.System.doReset();
                            };

                            // Which checker to use depends actually of what we are upgrading: AP or NP (+ web.rui)
                            // We upgrade NP part, this leads to Device follow this states: Down -> Initializing -> Up
                            // Only when device is Up it has sense to reboot the device
                            if (self.fileExtension === "rui") {
                                swc.models.System.whenDeviceUp(postUpgradeCallback);
                            } else if (self.fileExtension === "acs") {
                                // In case if AP upgraded, device never goes down, so device=Up returned always
                                // and we should check if APController.get() returns "UP" for the Connection state
                                swc.models.System.whenApUp(postUpgradeCallback);
                            }
                        }, swc.models.System.minExpectedRebootTime);
                    })
                    .fail(function(){
                        resetRuler.trigger('swc-ruler:finish');
                        SWCElements.modalWindow.hide();
                        self.errorModal();
                    }
                );

                setTimeout(function(){
                    resetRuler.trigger('swc-ruler:start', {time: upgradeTime});
                }, 0);
            }
        });
    },

    errorModal: function(){
        var self = this;
        SWCElements.modalWindow.show({
            templateID: 'system:settings:upgrade:modal:upgrade-error',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'system-upgrade',
            onCancel: function() {
                self.clearForm();
            },
            onApply: function(){
                SWCElements.modalWindow.hide();
                self.confirmModal();
            }
        });
    },

    clearForm: function(){
        this.form[0].reset();
        this.$el.find('.file-name .no-file').show();
        this.$el.find('.file-name .file').hide();
    },

    onUpgradeConfig: function(){
        var self = this;

        this.form = $('#upgrade-form');

        this.form.find('#config-upgrade').off('change');
        this.form.find('#config-upgrade').on('change', function(){

            var filePath = self.form.find('input[type=file]').val();

            if(filePath.indexOf('\\') < 0){
                self.fileName = filePath;
            } else {
                self.fileName = filePath.slice(filePath.lastIndexOf("\\")+1, filePath.length);
            }
            
            // We need to save this reference to know later which call to use to check if upgrade finished
            self.fileExtension = self.fileName.slice(self.fileName.lastIndexOf(".") + 1, self.fileName.length);

            if(self.fileName){
                // file type can either be
                //   AP for application processor
                //   SOP for hgw SOP firmware
                if(self.fileExtension === 'rui'){
                    self.form.find('input[type=file]').attr('name', 'SOP');
                } else if(self.fileExtension === 'acs' && swc.models.Application.get('GlobalEnable')){
                    self.form.find('input[type=file]').attr('name', 'AP');
                } else {
                    self.wrongFileModal();
                    self.form.find('input[type=file]').val('').attr('name', 'file');
                }

                self.$el.find('.file-name .no-file').hide();
                self.$el.find('.file-name .file').html(self.fileName).show();
            } else {
                self.clearForm();
            }

            self.activateButton();
        });
    },

    onUpgradeProcess: function(e) {
        var self = this;

        // before show modal window the session state should be checked
        swc.models.System.checkSessionState(function() {
            self.processModal();
        });
    },

    activateButton: function(){
        if(this.form.find('input[type="file"]').val()){
            this.$el.find('.upgrade-process').removeClass('disabled');
        } else {
            this.$el.find('.upgrade-process').addClass('disabled');
        }
    },

    renderComplete: function(){
        if(swc.Utils.getIEVersion() > 1 && swc.Utils.getIEVersion() < 10){
            this.$el.find('.upgrade-config').addClass('disabled');
            $('#config-upgrade').remove();
        }
    }

});
;swc.constructors.TelephonyDectView = swc.base.PageView.extend({

    className: 'dect',

    models: [ 'Telephony', 'System' ],

    validation: {
        'pin': 'Telephony:dectPin'
    },

    events: {
        'swc-switcher:change .enable-dect': 'dectStatus',

        'swc-checkbox:change .show-pin-password': 'setPinState',
        'swc-checkbox:change .eco-status': 'ecoStatus',

        'keyup input.pin-original': 'onPinChange',
        'keyup input.pin-copy': 'onPinChange',

        'click .pair-dect': 'pairDect'
    },

    setTemplateData: function(){
        this.templateData = {
            dectStatus: swc.models.Telephony.get('dectStatus'),
            dectEco: swc.models.Telephony.get('dectEco'),
            pin: swc.models.Telephony.get('dectPIN')
        };
    },

    dectStatus: function(e, value){
        var self = this;

        this.showPageLoading('Updating DECT status');

        swc.models.Telephony.set('dectStatus', value);


        $.when(swc.models.Telephony.setDectStatus()).done(function(){
            self.render();
        });
    },

    ecoStatus: function(e, value){
        var element = $(this.el);

        swc.models.Telephony.set('dectEco', value);

        this.setButtonsState();
    },

    setPinState: function(e, value) {
        var pinOrigBox = $('input.pin-original'),
            pinCopyBox = $('input.pin-copy');

        if (value) {
            pinOrigBox.hide();
            pinCopyBox.show();
        } else {
            pinCopyBox.hide();
            pinOrigBox.show();
        }
    },

    onPinChange: function (e) {
        var parameters = getParameter($(e.target)),
            pinOrigBox = $('input.pin-original'),
            pinCopyBox = $('input.pin-copy');

        if ($.inArray('pin-original', parameters.parameterClasses) !== -1) {
            pinCopyBox.val(pinOrigBox.val());
        } else {
            pinOrigBox.val(pinCopyBox.val());
        }

        swc.models.Telephony.set('dectPIN', $(e.target).val());

        this.setButtonsState();
    },


    /*
    * First we check if the server is logged in. Just any AJAX call will do.
    */
    pairDect: function() {
        var self = this;
        swc.models.System.checkSessionState(function () {
            self._pairDect();
        });
    },

    _pairDect: function() {
        var self = this;

        if (!swc.models.Login.checkUserLogin()) {
            return false;
        }

        if((swc.models.Telephony.get('phones').length-2) < swc.models.Telephony.dectInternalNumbers.length){
            var pairingModal = new swc.constructors.DectPairingModalView();

            $(pairingModal.el).on('hidden', function(){
                $(pairingModal.el).remove();
                self.render();
            });

        } else {

            var modal = swc.Templates.get('telephony:device:pair:modal:manyDects').get('content'),
                div = $('<div/>', {'class':'modal'});

            div.html($.tmpl(modal, {
                localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            }));

            div.on('hidden', function(){
                div.remove();
            });

            div.modal();
        }
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred();

        $.when(swc.models.Telephony.setPin(), swc.models.Telephony.setDectEco())
            .done(function() {
                deferred.resolve();
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    }
});;swc.constructors.TelephonyPhonebookEditView = swc.base.PageView.extend({
    className: 'phonebook-new-contact',

    models: ['Phonebook'],

    validation: {
        'firstName':  'Phonebook:firstName',
        'lastName':   'Phonebook:lastName',
        'homeNumber': 'Phonebook:homeNumber',
        'cellNumber': 'Phonebook:cellNumber',
        'workNumber': 'Phonebook:workNumber'
    },

    events: {
        'keyup .contact-number': 'onChangeContact',
        'keyup .contact-name': 'onChangeContact'
    },

    phoneSet: ['HOME', 'CELL', 'WORK'],

    model: null,

    initialize: function() {
        swc.base.PageView.prototype.initialize.call(this, arguments);
        this.template = $.template("pageContent", swc.Templates.get('telephony:phonebook:new-number').get('content'));
    },

    /**
     * Event handler: is fired on changing value in the input field
     *
     * @description:
     *
     * this wrapper is used to defer validation check until all events will be triggered
     * this approach is similar to use setTimeout(func, 0)
     */
    onChangeContact: function() {
        _.defer(this.changeContact, this);
    },

    /**
     * Handle data during user input in the edit form of items in the phonebook
     *
     * @param e {Object} -> Event
     */
    changeContact: function(self) {
        var model = self.getContactModel(),
            elements = self.getElements(),
            elementParams = [];

        _.each(elements, function(element) {
            elementParams.push(getParameter($(element)));
        });

        model.set({'modified': !self.pageCheckDefaultValues()});

        // fill contact model by first, last names
        model.set({
            firstName: $.trim(_.where(elementParams, { parameterName: 'firstName' })[0].parameterValue),
            lastName: $.trim(_.where(elementParams, { parameterName: 'lastName' })[0].parameterValue)
        });

        // fill contact model by phone numbers
        _.each(self.phoneSet, function(phoneType) {
            var numberObj = _.where(model.get('telephoneNumbers'), { type: phoneType })[0],
                numberValue = $.trim(_.where(elementParams, { parameterName: phoneType.toLowerCase() + 'Number'})[0].parameterValue);

            if (!numberObj) {
                model.get('telephoneNumbers').push({
                    name: numberValue,
                    preferred: false,
                    type: phoneType
                });
            } else {
                numberObj.name = numberValue;
            }
        });
    },

    /**
     * Validation for form 'Add new contact' checks if the first or last name is empty
     *
     * @returns {boolean}
     */
    onSaveValidation: function() {
        var model = this.getContactModel(),
            fullName = model.get('firstName') + model.get('lastName'),
            emptyNumbers = _.where(model.get('telephoneNumbers'), { name: '' }),
            allNamesAreEmpty = _.isEmpty(fullName),
            allNumbersAreEmpty = (emptyNumbers.length === 3),
            validation = {};

        if (allNamesAreEmpty && allNumbersAreEmpty) {
            validation['allfields'] = {
                status: false,
                message: 'at least one field should be filled'
            };
            return validation;
        }

        if (allNamesAreEmpty) {
            validation['names'] = {
                status: false,
                message: 'at least one field should be filled'
            };
        }

        if (allNumbersAreEmpty) {
            validation['numbers'] = {
                status: false,
                message: 'at least one field should be filled'
            };
        }

        return validation;
    },

    /**
     * reset temporary data
     */
    resetContactModel: function() {
        this.model = null;
        sessionStorage.removeItem(swc.models.Phonebook.requestParamNameID);
    },

    onCancel: function() {
        this.resetContactModel();
        swc.router.navigate('telephony/phonebook');
    },

    save: function() {
        var self = this,
            model = this.getContactModel(),
            deferred = new $.Deferred(),
            onSaveErrors = this.onSaveValidation();

        if (_.isEmpty(onSaveErrors)) {
            $.when(model.save())
                .done(function() {
                    self.resetContactModel();
                    deferred.resolve();
                    swc.router.navigate('telephony/phonebook');
                });
        } else {
            deferred.reject(onSaveErrors);
        }

        return deferred.promise();
    },

    setButtonsState: function() {
        this.$('.button.save-changes').toggleClass('disabled', this.pageCheckDefaultValues());
    },

    /**
     * Show unsuccessfull page save result
     */
    showSaveSuccess: function(type, onSaveErrors) {
        var self = this;

        // if no error do nothing
        if (_.isEmpty(onSaveErrors)) {
            return;
        }

        this.clearValidationMessages();

        _.each(onSaveErrors, function(error, errorName) {
            var container = this.$('.validation-message[data-parameter-name="' + errorName + '"]');

            container.show();
            container.find('.error-message').hide();
            container.find('.error-message[data-error="' + error.message + '"]').show();
            self.highlightField(errorName);
        });
    },

    highlightField: function(errorName) {
        if (errorName === 'allfields') {
            this.$('.contact-name.validatable').addClass('validation-error');
            this.$('.contact-number.validatable:first').addClass('validation-error');
            this.$('.validation-message[data-parameter-name="allfields"]').show();
        }
        if (errorName === 'names') {
            this.$('.contact-name.validatable').addClass('validation-error');
            this.$('.validation-message[data-parameter-name="names"]').show();
        }
        if (errorName === 'numbers') {
            this.$('.contact-number.validatable:first').addClass('validation-error');
            this.$('.validation-message[data-parameter-name="numbers"]').show();
        }
    },

    /**
     * Set template data for output phone's types in the cycle
     */
    setTemplateData: function() {
        var model = this.getContactModel(),
            numbers = model.get('telephoneNumbers');

        // make object for editable number fields
        model.set('phoneNumbers', {
            'HOME': _.where(numbers, { type: 'HOME' })[0] ? _.where(numbers, { type: 'HOME' })[0].name : '',
            'CELL': _.where(numbers, { type: 'CELL' })[0] ? _.where(numbers, { type: 'CELL' })[0].name : '',
            'WORK': _.where(numbers, { type: 'WORK' })[0] ? _.where(numbers, { type: 'WORK' })[0].name : ''
        });

        this.templateData = {
            nameTypes: {
                'firstName': 'First Name',
                'lastName': 'Last Name'
            },
            phoneTypes: {
                'HOME': 'Home',
                'CELL': 'Mobile',
                'WORK': 'Office'
            },
            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
            localeString: getTranslationStringsjQuery,
            isNew: model.isNew(),
            contact: model
        };
    },

    getContactModel: function() {
        if (this.model === null) {
            var contactID;

            if (contactID = sessionStorage.getItem(swc.models.Phonebook.requestParamNameID)) {
                this.model = swc.models.Phonebook.get(contactID);
            } else {
                this.model = new swc.constructors.PhonebookContact();
            }
        }

        return this.model;
    }

});;swc.constructors.TelephonyPhonebookList = swc.base.PageView.extend({

    className: 'view-contacts',

    events : {
        'keyup .search-input': 'searchContacts',
        'click .new-contact': 'redirectToAddContact',

        'click .clear-contacts:not(.disabled)': 'clearAllModal',
        'click .do-delete': 'deleteContact',

        'expandable:edit .expandable-list': 'listEditMode'
    },

    searchKeyword: "",

    searchProcess: false,

    // A flag showing if there are some contacts prepared for deletion
    deletedContacts: false,

    initialize: function() {
        swc.base.PageView.prototype.initialize.call(this, arguments);
        this.template = $.template("pageContent", swc.Templates.get('telephony:phonebook:phonebook').get('content'));
    },

    /**
     * Event handler: is fired on start edit
     *
     * @param e
     * @param value
     */
    listEditMode: function(e, value) {
        sessionStorage.setItem(swc.models.Phonebook.requestParamNameID, value);
        swc.router.navigate('telephony/phonebook/edit');
    },

    redirectToAddContact: function() {
        sessionStorage.removeItem(swc.models.Phonebook.requestParamNameID);
        swc.router.navigate('telephony/phonebook/edit');
    },

    /**
     * Get actual collection of contacts.
     * The following contacts are thrown away from collection:
     *    - which are marked as deleted
     *    - which are not matched to the search keyword(both name and number are checked)
     *
     * @returns {Array}
     */
    filterContactsBySearch: function() {
        var self = this,
            collection = [];

        collection = swc.models.Phonebook.filter(function(model) {
            var response = false,
                numbers = model.get('telephoneNumbers');

            // make object for editable number fields
            model.set('numberFields', {
                'HOME': _.where(numbers, {'type': 'HOME'})[0] ? _.where(numbers, {'type': 'HOME'})[0].name : '',
                'CELL': _.where(numbers, {'type': 'CELL'})[0] ? _.where(numbers, {'type': 'CELL'})[0].name : '',
                'WORK': _.where(numbers, {'type': 'WORK'})[0] ? _.where(numbers, {'type': 'WORK'})[0].name : ''
            });

            if (model.get('deleted')) {
                self.deletedContacts = true;
                response = false;
            } else if (self.searchKeyword) {
                var searchKeywordLC = self.searchKeyword.toLowerCase();
                if (model.get('formattedName').toLowerCase().indexOf(searchKeywordLC) !== -1) {
                    response = true;
                }

                _.each(model.get('telephoneNumbers'), function(number) {
                    if (number.name.indexOf(searchKeywordLC) !== -1) {
                        response = true;
                    }
                });
            } else {
                response = true;
            }

            return response;
        });

        return collection;
    },

    /**
     * Event handler: is fired during user input in the search field
     *
     * @param e
     */
    searchContacts: function(e) {
        this.searchKeyword = $(e.target).val();
        this.searchProcess = true;
        this.render();
        this.searchProcess = false;
    },

    /**
     * Save all contacts.
     * The following flags influences on the actual action during saving
     *    modified { Boolean }
     *    deleted { Boolean }
     */
    save: function() {
        var self = this;

        $.when(swc.models.Phonebook.deleteAllContacts())
            .done(function() {
                swc.views.telephonyPhonebookView.showSuccessMessage = true;
                swc.views.telephonyPhonebookView.render();
            });
    },

    /**
     * Event handler: render page in the default state
     */
    onCancel: function() {
        swc.views.telephonyPhonebookView.render();
    },

    /**
     * Event handler: delete picked contact from model
     * Actually contact is not deleted but marked as deleted
     *
     * @param e {Object}
     */
    deleteContact: function(e) {
        var itemId = $(e.target).closest('.expandable-list-item').attr('data-key');
        swc.models.Phonebook.get(itemId).set({'deleted': true});
        this.deletedContacts = true;
        this.setButtonsState();
        this.render();
    },

    /**
     * Delete all contacts
     * Is used as a handler of the event clearAllModal
     */
    deleteAllContacts: function() {
        swc.models.Phonebook.each(function(model) {
            model.set({'deleted': true});
        });
        this.saveChanges();
        this.setElementsState();
    },

    /**
     * Event handler: show modal window with prompt to delete all contacts from phone book
     */
    clearAllModal: function() {
        var self = this,
            templateData = {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            };

        SWCElements.modalWindow.show({
            templateID: 'telephony:modal-windows:phonebook:clear-all',
            templateData: templateData,
            className: 'phonebook-clearall',
            onApply: function() {
                self.deleteAllContacts();
                SWCElements.modalWindow.hide();
            }
        });
    },

    checkModification: function() {
        return (!this.pageCheckDefaultValues() || this.deletedContacts);
    },

    /**
     * Enable save/cancel buttons
     */
    activateButtons: function(){
        this.$('.save-changes').removeClass('disabled');
        this.$('.cancel-changes').removeClass('disabled');
    },

    /**
     * Disable save/cancel buttons
     */
    deactivateButtons: function(){
        this.$('.save-changes').addClass('disabled');
        this.$('.cancel-changes').addClass('disabled');
    },

    /**
     * Enable search input
     */
    activateSearchElement: function(){
        this.$('.search-form div').removeClass('disabled');
        this.$('.search-form input').removeAttr('disabled');
    },

    /**
     * Disable search input
     */
    deactivateSearchElement: function() {
        this.$('.search-form div').addClass('disabled');
        this.$('.search-form input').attr('disabled', 'disabled');
    },

    /**
     * Set state(enable/disable) of buttons and search input
     */
    setElementsState: function() {
        // if there are some modification(edit, delete of some amount of contacts)
        // or phone book list is empty
        // then search input should be disabled
        if (this.checkModification() || !swc.models.Phonebook.length) {
            this.deactivateSearchElement();
        } else {
            this.activateSearchElement();
        }

        // if there are some modification(edit, delete of some amount of contacts)
        // then buttons save/cancel should be disabled
        if (this.checkModification()) {
            this.activateButtons();
        } else {
            this.deactivateButtons();
        }
    },

    setTemplateData: function() {
        var self = this;

        this.templateData = {
            phoneTypes: {
                'HOME': 'Home',
                'CELL': 'Mobile',
                'WORK': 'Office'
            },
            searchProcess: self.searchProcess,
            isModified: self.checkModification(),
            contacts: self.filterContactsBySearch()
        };
    },

    render: function() {
        var self = this;

        // Set template data:
        this.setTemplateData();

        $(this.el).html(
            $.tmpl(this.template, {
                localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate,
                data: self.templateData
            })
        );

        this.renderComplete();
    },

    renderComplete: function() {
        var searchInput;

        this.$('.search-input').val(this.searchKeyword);

        if (this.searchProcess) {
            searchInput = this.$('.search-input')[0];
            $(searchInput).focus();
            // put cursor at the end of the search input
            if (searchInput.setSelectionRange) {
                // ... then use it
                // (Doesn't work in IE)
                // Double the length because Opera is inconsistent about whether a carriage return is one character or two. Sigh.
                var len = $(searchInput).val().length * 2;
                searchInput.setSelectionRange(len, len);
            }
        }

        this.setElementsState();

        // due to overriding render method the
        // success message should be shown explicitly
        if (swc.views.telephonyPhonebookView.showSuccessMessage) {
            this.$('.buttons-container-message .save-success').show();
            swc.views.telephonyPhonebookView.showSuccessMessage = false;
        }
    }

});
;swc.constructors.TelephonyPhonebookView = swc.base.PageView.extend({

    className: 'phonebook',

    models: ['Phonebook'],

    /**
     * Due to overriding render method in the child view TelephonyPhonebookList
     * success message should be shown explicitly.
     *
     * This variable is used in the child view TelephonyPhonebookList
     * to determine if the success message should be shown after save.
     * This variable is declared here because the child view always has
     * new instance after rendering of this(parent) view
     *
     * @type {Boolean}
     */
    showSuccessMessage: false,

    renderComplete: function(){
        var view,
            element = $(this.el);

        swc.views.TelephonyPhonebookList = new swc.constructors.TelephonyPhonebookList();
        view = swc.views.TelephonyPhonebookList;

        element.find('.phonebook').html(view.el);
        view.render();
        view.delegateEvents();
    },

    /**
     * TODO: remove this custom solution when load/unload of views will be realized
     */
    beforeRouteChangeHook: function() {
        if (swc.views['telephonyPhonebookEditView']) {
            swc.views['telephonyPhonebookEditView'].resetContactModel();
        }
    }

});;swc.constructors.NoGroupsModal = Backbone.View.extend({
    className: 'modal',

    tagName: 'div',

    initialize: function(){
        this.pageTemplateID = "telephony";
        this.render();
    },

    render: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'telephony:modal-windows:no-groups',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'cloud-unchecked',
            
            onApply: function() {
                SWCElements.modalWindow.hide();
            }
        });

    }
});
;swc.constructors.DectPairingModalView = swc.base.PageView.extend({
    className: 'modal dect-pairing',

    tagName: 'div',

    hidden: false,

    events: {
        'click .close-modal': 'closeModal',
        'click .try-pairing': 'tryPairing',
        'hide': 'hideModal'
    },

    closeModal: function(){
        var self = this;
        $.when(swc.models.Telephony.stopPairing())
            .always(function(response) {
                swc.models.Login.off('beforeLogout', self.closeModal, self);
                self.hideModal();
                $(self.el).modal('hide');
            });
    },

    tryPairing: function(){
        this.render();
    },

    hideModal: function(){
        this.hidden = true;
    },

    initialize: function(){
        var self = this;
        this.pairingTemplate = swc.Templates.get('telephony:device:pair:modal:pairing');
        this.failTemplate = swc.Templates.get('telephony:device:pair:modal:failed');
        this.successTemplate = swc.Templates.get('telephony:device:pair:modal:complete');
        this.rulerTemplate = swc.Templates.get('ruler');
        this.render();
    },

    render: function(){
        var self = this, element = $(this.el);
        element.html($.tmpl(self.pairingTemplate.get('content'), {
            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
            localeString: getTranslationStringsjQuery,
            formatDate: swc.models.Locale.formatDate
        }));

        this.$el.modal({keyboard: false, backdrop: 'static'});

        var countDectPhones = function(){
                return swc.models.Telephony.get('phones').length-2;
            },
            dectPhonesCount = countDectPhones();

        element.find('.ruler-block').html($.tmpl(self.rulerTemplate.get('content'), {
            'className': 'pairing-ruler'
        }));

        swc.models.Login.on('beforeLogout', this.closeModal, this);

        $.when(swc.models.Telephony.startPairing()).done(function(response){

            var timeEnded = false,
                pairingTime = 120000,

                throwSuccess = function(){
                    element.html(
                        $.tmpl(self.successTemplate.get('content'), {
                            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                            localeString: getTranslationStringsjQuery,
                            formatDate: swc.models.Locale.formatDate
                        })
                    );
                },

                throwError = function(){
                    element.html(
                        $.tmpl(self.failTemplate.get('content'), {
                            localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                            localeString: getTranslationStringsjQuery,
                            formatDate: swc.models.Locale.formatDate
                        })
                    );
                },

                checkPaired = function(){
                    $.when(swc.models.Telephony.getPhones()).done(function(){
                        if(countDectPhones() > dectPhonesCount){
                            throwSuccess();
                        } else {
                            if(!timeEnded && !self.hidden){
                                setTimeout(function(){
                                    checkPaired();
                                }, 1000);
                            } else {
                                throwError();
                            }
                        }
                    });
                };

            element.find('.ruler-container').trigger('swc-ruler:start', {time: pairingTime});

            setTimeout(function(){
                timeEnded = true;
            }, pairingTime);

            checkPaired();
        });
    }
});
;swc.constructors.TelephonyDeviceView = swc.base.PageView.extend({

    className: 'dect-and-phones',

    models: ['Telephony', 'System'],

    validation: {
        'dect-name-editable':       'Telephony:dectName',
        'internal-number-editable': 'Telephony:internalNumber'
    },

    events: {
        'click .pair-dect': 'pairDect',
        'click .unpair-phone': 'unpairPhone',
        'click .ring-phone': 'ringPhone',

        'keyup .dect-name': 'renameDect',

        'swc-checkbox:change .incoming-line': 'changeIncomingNumber',

        'swc-dropdown:change .swc-dropdown.internal-number': 'changeInternalNumber',
        'swc-dropdown:change .swc-dropdown.external-number': 'changeExternalNumber',

        'expandable:edit .expandable-list': 'listEditMode',
        'expandable:no-edit .expandable-list': 'listDefaultMode'
    },

    /**
     * List of expandable blocks for different telephony types
     */
    phoneTypes: ['wired', 'dect'],

    /* Indicates validation status */
    isValid : true,

    /**
     * Set data to be passed to template
     */
    setTemplateData: function() {
        var phones = swc.models.Telephony.getPhonesList(),
            phoneLines = swc.models.Telephony.get('voip').where({'enable': 'Enabled'});

        this.templateData = {
            dectPhones: phones.dect,
            wiredPhones: phones.cord,
            manyVoips: phoneLines.length >= 2,
            dectStatus: swc.models.Telephony.get('dectStatus'),
            voipStatus: swc.models.Telephony.get('voipStatus')
        };

        this.wiredEditing = null;
        this.dectEditing = null;
    },

    /**
     * Redefine render complete function()
     */
    renderComplete: function() {
        var self = this;

        this.setTemplateData();
        this.getTemplateContent();
        this.displayPage();
        this.hideSingleIncomingNumbers();

        _.defer(this.fillDropDowns, this);

        if (self.wiredEditing) {
            this.$('.expandable-wired-phones .expandable-list').trigger('expandable:swc-edit', self.wiredEditing);
        }

        if (self.dectEditing) {
            this.$('.expandable-dect-phones .expandable-list').trigger('expandable:swc-edit', self.dectEditing);
        }

        if (this.showSuccessMessage) {
            this.$('.buttons-container-message .save-success').show();
            this.showSuccessMessage = false;
        }
    },

    /**
     * Reset view variables
     */
    emptyEditing: function() {
        this.dectEditing = "";
        this.wiredEditing = "";
    },

    /**
     * Event handler: is fired on click on the checkbox next to the incoming number
     *
     * @param e
     * @param value
     */
    changeIncomingNumber: function(e, value){
        var element = $(e.target).closest('.swc-checkbox'),
            line = element.data('line'),
            device = element.closest('.expandable-list-item').data('key'),
            deviceModel = swc.models.Telephony.get('phones').get(device),
            deviceOptions = JSON.stringify(deviceModel.get('incomingLines')),
            deviceOptionsClone = JSON.parse(deviceOptions);

        _.each(deviceOptionsClone, function(obj) {
            if (obj.line === line) {
                obj.value = value;
            }
        });

        deviceModel.set('incomingLines', deviceOptionsClone);

        this.setButtonsState();
    },

    /**
     * Show all DOM elements of telephone incoming/outgoing numbers
     * for edit mode of the expandable-list-item
     *
     * @param phoneID {Int} Phone model ID
     */
    showSingleIncomingNumbers: function(phoneID) {
        this.$('.expandable-list-item.' + phoneID + ' .outgoing-number .state-default').toggleClass('hidden', false);
        this.$('.expandable-list-item.' + phoneID + ' .incoming-number').toggleClass('hidden', false);
    },

    /**
     * Switch visibility for DOM elements of telephone incoming/outgoing numbers
     * for default mode of the expandable-list-item
     *
     * @description:
     * The only one number should be displaied
     * if outgoing number equals to incoming number
     */
    hideSingleIncomingNumbers: function() {
        var self = this,
            phonesList = swc.models.Telephony.getPhonesList(),
            phones = _.union(phonesList.dect, phonesList.cord);

        _.each(phones, function(phone) {
            var activeIncomingLines = _.where(phone.incomingLines, {'value': true}),
                activeIncoming = (activeIncomingLines.length > 0),
                singleNumber = (activeIncomingLines.length === 1) && (phone.externalNumber.toString() === activeIncomingLines[0].number.toString());

            self.$('.expandable-list-item.' + phone.id + ' .outgoing-number .left-part .state-default').toggleClass('hidden', singleNumber);
            self.$('.expandable-list-item.' + phone.id + ' .incoming-number .left-part .state-default').toggleClass('hidden', singleNumber );
            self.$('.expandable-list-item.' + phone.id + ' .incoming-number').toggleClass('hidden', !activeIncoming || singleNumber);

            /*
               if more than one incoming line are active
               then visibility for its DOM element values should
               be set according to its model values
            */
            if (activeIncoming && !singleNumber) {
                _.each(phone.incomingLines, function(phoneLine) {
                    self.$('.expandable-list-item.' + phone.id + ' .incoming-number .right-part .state-default.' + phoneLine.line).toggleClass('hidden', !phoneLine.value);
                });
            }
        });
    },

    /*
    * Start pairing process.
    * Before start the session should be checked(just any AJAX call will do)
    */
    pairDect: function() {
        var self = this;

        swc.models.System.checkSessionState(function () {
            self._pairDect();
        });
    },

    /**
     * Pairing process handler: if the amount of connected DECT phones less then allowable limit(4 devices)
     * then open modal window with progress bar and start the connection process themself
     * else open modal window with alert
     *
     * @private
     */
    _pairDect: function() {
        var self = this;

        if (((swc.models.Telephony.get('phones').length - 2) < swc.models.Telephony.dectInternalNumbers.length) &&
            (swc.models.Telephony.get('phones').where({ deviceType:'dect' }).length < 4)) {

            var pairingModal = new swc.constructors.DectPairingModalView();

            $(pairingModal.el).on('hidden', function(){
                $(pairingModal.el).remove();
                self.render();
            });
        } else {
            var modal = swc.Templates.get('telephony:device:pair:modal:manyDects').get('content'),
                div = $('<div/>', {'class':'modalWindow modal manyDects-modal'});

            div.html($.tmpl(modal, {
                localeStrings: swc.models.Locale.getLocaleStrings("telephony"),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            }));

            div.on('hidden', function(){
                div.remove();
            });

            div.find('.close-modal').on('click', function() {
                $('.manyDects-modal').modal('hide');
            });

            div.modal();
        }
    },

    /**
     * Unpair selected DECT phone
     *
     * @param e
     */
    unpairPhone: function(e) {
        var self = this,
            dataKey = $(e.target).closest('.expandable-list-item').attr('data-key');

        $.when(swc.models.Telephony.unpairDect(dataKey)).done(function() {
            self.render();
        });
    },

    /**
     * Make test call
     *
     * @param e
     */
    ringPhone: function(e) {
        var dataKey = $(e.target).closest('.expandable-list-item').attr('data-key');

        swc.models.Telephony.ringPhone(dataKey);
    },

    /**
     * Rename selected DECT phone
     *
     * @param e
     */
    renameDect: function(e) {
        var self = this,
            item = $(e.target).closest('.expandable-list-item'),
            dataKey = item.attr('data-key');

        // update the default element with current value
        item.find('.device-name .state-default .text').text(e.target.value);

        swc.models.Telephony.get('phones').get(dataKey).set({
            'name': e.target.value,
            'is_changed': true
        });
    },

    /**
     * Event handler: is fired on change of internal number
     *
     * @param e {Event}
     * @param value {String}
     */
    changeInternalNumber: function(e, value) {
        var element = $(e.target).closest('.expandable-list-item'),
            deviceId = element.attr('data-key');

        // update the default element with current value
        element.find('.default-internal').text(value);

        swc.models.Telephony.get('phones').get(deviceId).set({
            'directoryNumber': value,
            'is_changed': true
        }, { silent: true });

        // refresh phone numbers in the dropdown list
        _.defer(this.fillDropDowns, this);

        this.setButtonsState();
    },

    /**
     * Event handler: is fired on change of external number
     *
     * @param e {Event}
     * @param value {String}
     */
    changeExternalNumber: function(e, value) {
        var element = $(e.target).closest('.expandable-list-item'),
            deviceId = element.attr('data-key');

        // update the default element with current value
        element.find('.default-external').text(value);

        swc.models.Telephony.get('phones').get(deviceId).set({
            externalNumber: value,
            is_changed: true
        }, { silent: true });

        // refresh phone numbers in the dropdown list
        _.defer(this.fillDropDowns, this);

        this.setButtonsState();
    },

    /**
     * This method do the following actions:
     * - closes all sibling item in the current expandable list
     * (i.e. expandable list which contains editable item)
     * - closes all items in the sibling expandable lists
     *
     * @param item {jQquery element}
     * @param phoneType {String} dect | wired
     */
    closeSiblingItems: function(item, phoneType) {
        var self = this,
            restPhoneTypes = _.without(this.phoneTypes, phoneType);

        // Close edit mode of sibling tabs in the expandable list which contains editable item
        _.each(item.siblings('.expandable-list-item'), function(item) {
            var dataKey = $(item).data('key');
            self.$('.expandable-' + phoneType + '-phones .expandable-list').trigger('expandable:swc-no-edit', dataKey);
        });

        // Close edit mode of all tabs in the sibling expandable lists
        // (i.e. lists which don't contain editable item)
        _.each(restPhoneTypes, function(restPhoneType) {
            var expandableList = self.$('.expandable-' + restPhoneType + '-phones .expandable-list');

            _.each(expandableList.find('.expandable-list-item'), function(item) {
                var dataKey = $(item).data('key');
                expandableList.trigger('expandable:swc-no-edit', dataKey);
            });
        });
    },

    /**
     * Event handler: is fired on the end of edit of the list item
     *
     * @param e {Event}
     * @param value {String}
     */
    listDefaultMode: function(e, value) {
        var self = this,
            target = this.$('.expandable-list-item[class~="' + value + '"]'),
            validation = this.pageValidation(null, true);

        $.when(validation)
            .done(function() {
                self.revertItemFromEditMode($(target));
                self.hideSingleIncomingNumbers();
            })
            .fail(function() {
                target.addClass('mode-editing');
            });
    },

    /**
     * Event handler: is fired on the start of edit of the list item
     *
     * @param e {Event}
     * @param value {String}
     */
    listEditMode: function(e, value) {
        var self = this,
            target = this.$('.expandable-list-item[class~="' + value + '"]'),
            validation = this.pageValidation(null, true),
            targetList;

        // if some of the elements won't pass validation the opportunity
        // to change editable element should be interrupted
        $.when(validation)
            .done(function() {
                if (target.closest('.expandable-list').hasClass('dect')) {
                    targetList = 'dect';
                    self.dectEditing = value;
                } else {
                    targetList = 'wired';
                    self.wiredEditing = value;
                }

                self.setItemToEditMode(target);
                self.closeSiblingItems(target, targetList);
                self.showSingleIncomingNumbers(value);
            })
            .fail(function() {
                target.removeClass('mode-editing');
            });
    },

    /**
     * Add suffix '-editable' to elements and appropriate error blocks
     * which are located inside the jQuery element item
     *
     * This manipulation is required to have validation only for elements which
     * are edited at this moment
     *
     * @param item {jQuery element} e.g. $('.expandable-list-item[class~="' + value + '"]')
     */
    setItemToEditMode: function(item) {
        // add '-editable' to dect-name
        item.find('.dect-name').attr('name', 'dect-name-editable');
        item.find('.validation-message[data-parameter-name="dect-name"]').attr('data-parameter-name', 'dect-name-editable');
        // add '-editable' to internal-number
        item.find('.internal-number').attr('data-name', 'internal-number-editable');
        item.find('.internal-number').data('name', 'internal-number-editable');
        item.find('.validation-message[data-parameter-name="internal-number"]').attr('data-parameter-name', 'internal-number-editable');
    },

    /**
     * Remove suffix '-editable' from elements and appropriate error blocks
     * which are located inside the jQuery element item
     *
     * This manipulation is required to have validation only for elements which
     * are edited at this moment
     *
     * @param item {jQuery element} e.g. $('.expandable-list-item[class~="' + value + '"]')
     */
    revertItemFromEditMode: function(item) {
        // remove '-editable' from dect-name
        item.find('.dect-name').attr('name', 'dect-name');
        item.find('.validation-message[data-parameter-name="dect-name-editable"]').attr('data-parameter-name', 'dect-name');
        // remove '-editable' from internal-number
        item.find('.internal-number').attr('data-name', 'internal-number');
        item.find('.internal-number').data('name', 'internal-number');
        item.find('.validation-message[data-parameter-name="internal-number-editable"]').attr('data-parameter-name', 'internal-number');
    },

    /**
     * Fill dropdown menus with phone numbers
     */
    fillDropDowns: function(self) {
        var internalNumbersCopy,
            dectExternalNumbers = [],
            // Possible internal numbers for DECT phones
            dectInternalNumbers = _.clone(swc.models.Telephony.dectInternalNumbers),
            phones = swc.models.Telephony.get('phones'),
            phoneLines = swc.models.Telephony.get('voip').where({'enable': 'Enabled'}),
            usedInternalNumbers = _.map(phones.pluck('directoryNumber'), function(v) { return +v; }),
            // internal numbers which are not occupied by any DECT phone
            freeInternalNumbers = _.difference(dectInternalNumbers, usedInternalNumbers),

            numberDropdownConstructor = function(array) {
                var obj = {};
                _.each(array, function(number) {
                    obj[number] = {
                        'name': number,
                        'value': number
                    };
                });
                return obj;
            };

        _.each(phoneLines, function(model) {
            dectExternalNumbers.push(model.get('directoryNumber'));
        });

        phones.each(function(model) {
            // Reset current list of internal numbers up to free numbers
            internalNumbersCopy = _.clone(freeInternalNumbers);
            // Add currently used number to array
            internalNumbersCopy.push(parseInt(model.get('directoryNumber'), 10));
            internalNumbersCopy.sort();

            self.$('.swc-dropdown.internal-number[data-class="internal-number-' + model.id + '"]').data({
                "options": numberDropdownConstructor(internalNumbersCopy)
            })
            .trigger('swc-dropdown:swc-change', model.get('directoryNumber'));

            // if there is more than one external number
            if (dectExternalNumbers[1]) {
                self.$('.swc-dropdown.external-number[data-class="external-number-' + model.id + '"]').data({
                    "options": numberDropdownConstructor(dectExternalNumbers)
                })
                .trigger('swc-dropdown:swc-change', model.get('externalNumber'));
            }
        });
    },

    onCancel: function() {
        this.showSuccessMessage = false;
        this.emptyEditing();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred();

        // Before doing heavy edit operation, which even has a callback delayed for 2 seconds (see phoneEdit() method),
        // let's check if session is still valid.
        swc.models.System.checkSessionState(function(){
            self.$('.expandable-list-item .validation-message').hide();
            self.$('.swc-input').removeClass('validation-error');

            self.emptyEditing();
            self.showPageLoading("Saving page data..");
            
            $.when(swc.models.Telephony.phoneEdit())
                .done(function () {
                    self.showSuccessMessage = true;
                    deferred.resolve();
                })
                .fail(function () {
                    deferred.reject();
                });
        });

        return deferred.promise();
    }
});
;swc.constructors.TelephonyView = swc.base.PageView.extend({

    className: 'telephony'

});;swc.constructors.WifiGuestView = swc.base.PageView.extend({

    className: 'wifi-guest',

    models: [
        "Wireless"
    ],

    validation: {
        'ssid': 'Wireless:ssid',
        'password': 'Wireless:password'
    },

    events: {
        'swc-switcher:change .set-wifi-status': 'setWiFiState',

        'keyup input.password-original': 'updatePasswordsChange',
        'keyup input.password-copy': 'updatePasswordsChange',

        'swc-checkbox:change .swc-checkbox.show-password': 'setPasswordState',

        'swc-dropdown:change .swc-dropdown.encryption-selection': 'setEncryptionState'
    },

    setTemplateData: function() {
        var time = new Date(swc.models.Wireless.getParameter("time", "systemTime")).getTime(),
            timeout = swc.models.Wireless.getParameter("timeout", "guestTimer"),
            date = {
                hours: new Date(time + timeout * 1000).getHours(),
                minutes: new Date(time + timeout * 1000).getMinutes()
            };

        // Set template data:
        this.templateData = {
            "state": swc.models.Wireless.getParameter("status", "guestStatus"),
            "ssid": swc.models.Wireless.getParameter("name", "Guest-2.4GHz"),
            "password": swc.models.Wireless.getParameter("password", "Guest-2.4GHz"),
            "encryption": swc.models.Wireless.getParameter("encryption", "Guest-2.4GHz"),
            "encryptionOptions": swc.models.Wireless.formatEncryptionOptions("Guest-2.4GHz"),
            "deactivationOptions": swc.models.Wireless.formatDeactivationOptions(),
            "deactivationTimeout": timeout,
            "deactivationSelected": 0,
            "deactivationTime": ''
        };

        // Check hours value for consistensy
        if (date.hours < 10) {
            date.hours = "0" + date.hours;
        }

        // Check minutes value for consistensy
        if (date.minutes < 10) {
            date.minutes = "0" + date.minutes;
        }

        // Update deactivation time value:
        this.templateData["deactivationTime"] = date.hours + ':' + date.minutes;
    },

    renderComplete: function() {
        var self = this,
            encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection'),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        // Listener on Encryption dropdown change
        encryptionDropdown.on('validation-success', function() {

            // Validate visible password box:
            if (passwordOrigBox.css('display') !== 'none') {
                self.pageValidation(passwordOrigBox, false);
            } else {
                self.pageValidation(passwordCopyBox, false);
            }
        });

        // Set encryption data when page is loaded:
        this.setEncryptioData();

        // Set deactivation data when page is loaded:
        this.setDeactivationData();

        this.setShowPasswordState();
    },

    setShowPasswordState: function() {
        var encryption = this.templateData["encryption"],
            $passwordOrigBox = this.$('input.password-original'),
            $passwordCopyBox = this.$('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (encryption === 'None') {
           $showPasswordCheckbox
               .addClass('disabled')
               .trigger('swc-checkbox:swc-change', false);
        } else {
            this.setPasswordState(null, true);
        }
    },

    setEncryptioData: function() {
        var encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection');

        // Set dropdown data:
        encryptionDropdown.data('options', this.templateData["encryptionOptions"]);
        encryptionDropdown.trigger('swc-dropdown:swc-change', this.templateData["encryption"]);
        encryptionDropdown.data("default-value", this.templateData["encryption"]);

        // Update password boxes state:
        this.setEncryptionState(null, this.templateData["encryption"]);
    },

    setDeactivationData: function() {
        var dropDownDeactivation = this.$el.find('.swc-dropdown.deactivation-selection');

        // Calculate nearest value:
        if (this.templateData["deactivationTimeout"] > 0 && this.templateData["deactivationTimeout"] <= 21600) {
            this.templateData["deactivationSelected"] = 21600; // 6h
        }
        else if (this.templateData["deactivationTimeout"] > 21600 && this.templateData["deactivationTimeout"] <= 43200) {
            this.templateData["deactivationSelected"] = 43200; // 12h
        }
        else if (this.templateData["deactivationTimeout"] > 43200 && this.templateData["deactivationTimeout"] <= 86400) {
            this.templateData["deactivationSelected"] = 86400; // 24h
        }
        else {
            this.templateData["deactivationSelected"] = 0; // No auto disable
        }

        // Set dropdown data:
        dropDownDeactivation.data('options', this.templateData["deactivationOptions"]);
        dropDownDeactivation.data("default-value", this.templateData["deactivationSelected"]);
        dropDownDeactivation.trigger('swc-dropdown:swc-change', this.templateData["deactivationSelected"]);
    },

    setWiFiState: function(e, value) {
        var self = this,
            toDo = [];

        // Show page saving message
        this.showPageLoading("Updating Guest WiFi state");

        // Set activation timer on wifi activation:
        if (value) {
            toDo = [
                swc.models.Wireless.setGuestStatus(true),
                swc.models.Wireless.setGuestActivationTimer(6)
            ];
        } else {
            toDo.push(
                swc.models.Wireless.setGuestStatus(false)
            );
        }

        // Wait till all changes are completed
        $.when.apply(null, toDo).done(function() {
            $.when(swc.models.Wireless.sync()).done(function() {
                self.render();
            });
        });
    },

    setPasswordState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if (value) {
            passwordOrigBox.hide();
            passwordCopyBox.show();
        } else {
            passwordCopyBox.hide();
            passwordOrigBox.show();
        }
    },

    setEncryptionState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (value === "None") {
            passwordOrigBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
            passwordCopyBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
        } else {
            $showPasswordCheckbox.removeClass('disabled');
            passwordOrigBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
            passwordCopyBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
        }
    },

    updatePasswordsChange: function(e) {
        var parameters = getParameter($(e.target)),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if ($.inArray('password-original', parameters.parameterClasses) !== -1) {
            passwordCopyBox.val(passwordOrigBox.val());
        } else {
            passwordOrigBox.val(passwordCopyBox.val());
        }
    },

    save: function() {
        var deferred = new $.Deferred(),
            timerDropdown = this.$el.find('.swc-dropdown.deactivation-selection'),
            timerDropdownValue = getParameter(timerDropdown),
            toDo = [],
            pageData = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Check if timer has changed:
        if (parseInt(timerDropdown.data('value'), 10) !== parseInt(timerDropdown.data('default-value'), 10)) {
            toDo.push(
                swc.models.Wireless.setGuestActivationTimer((timerDropdownValue.parameterValue / 60) / 60)
            );
        }

        // Push saving state:
        toDo.push(swc.models.Wireless.saveSettingsGuest('2.4GHz', pageData));
        // toDo.push(swc.models.Wireless.saveSettingsGuest('5GHz', pageData)); // Removed due to SAH problems

        $.when.apply(null, toDo).done(function() {
            return deferred.resolve();
        }).fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});;swc.constructors.WifiSchedulerView = swc.base.PageView.extend({

    className: 'wifi-scheduler',

    models: ['Schedulers', 'Wireless'],


    events: {
        'swc-checkbox:change .enable-scheduler':'enableScheduler',
        'click .apply-wifi-schedule:not(.disabled)': 'applyScheduler',
        'click .cancel-wifi-schedule:not(.disabled)': 'cancelScheduler'
    },

    setTemplateData: function(){
        this.templateData = {
            schedulerState: swc.models.Schedulers.get('wifi').get('enable')
        };
    },

    enableScheduler: function(e, value){
        var schedulerState = value;

        swc.models.Schedulers.get('wifi').set('enable', schedulerState);

        this.renderComplete();
    },

    applyComplete: function(resp){
        var self = this;
        this.render();
        self.changedScheduler = false;
        setTimeout(function(){
            if(resp.status){
                self.$el.find('.buttons-container-message .save-success').show();
            } else {
                self.$el.find('.buttons-container-message .save-error').show();
            }
        }, 500);
    },

    emptyModal: function(){
        var self = this;

        SWCElements.modalWindow.show({
            templateID: 'power:wifi:modal',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings('power'),
                localeString: getTranslationStringsjQuery,
                formatDate: swc.models.Locale.formatDate
            },
            className: 'storage-schedule',
            onCancel: function() {
                self.changedScheduler = false;
                self.render();
            },
            onApply: function() {
                SWCElements.modalWindow.hide();
                self.showPageLoading('Saving page data..');

                $.when(
                        swc.models.Schedulers.addSchedule('wifi'),
                        swc.models.Wireless.setGlobalStatus(false)
                    ).done(function(resp1, resp2){
                        self.applyComplete(resp1);
                    });
            }
        });
    },

    applyScheduler: function(e){
        var self = this;
        if(swc.models.Schedulers.emptySchedulers[0] === 'wifi'){
            self.emptyModal();
        } else {
            $.when(swc.models.Schedulers.addSchedule('wifi')).done(function(resp){
                self.applyComplete(resp);
            });
        }
    },

    cancelScheduler: function(){
        this.changedScheduler = false;
        this.render();
    },

    changeButtonsState: function(){
        var element = $(this.el);
        if(this.pageCheckDefaultValues() && !this.changedScheduler){
            element.find('.buttons-container-message .button').addClass('disabled');
        } else {
            element.find('.buttons-container-message .button').removeClass('disabled');
        }
    },

    renderComplete: function(){
        var self = this;
        var element = $(this.el);

        this.changeButtonsState();

        swc.constructors.dispatcher.off('scheduler:change');
        swc.constructors.dispatcher.on('scheduler:change', function(e){
            self.changedScheduler = true;
            self.changeButtonsState();
        });

        var schedulerModel = swc.models.Schedulers.get('wifi');

        self.schedulerDiapazon = new swc.constructors.SchedulerLiner({
            isDisabled: !schedulerModel.get('enable'),
            scaleWidth: 432,
            diapazones: schedulerModel.get('pixelSchedule'),
            model: schedulerModel,
            schedulerType: 'wifi'
        });

        $(self.el).find('.scheduler-container').html(self.schedulerDiapazon.el);

        self.delegateEvents();
    }
});;;swc.constructors.WifiSettingsType24View = swc.base.TabView.extend({

    className: 'type-24',

    accessPointInterface: '2.4GHz',

    validation: {
        'ssid': 'Wireless:ssid',
        'password': 'Wireless:password'
    },

    events: {
        'keyup input.password-original': 'updatePasswordsChange',
        'keyup input.password-copy': 'updatePasswordsChange',

        'swc-checkbox:change .swc-checkbox.WiFiEnable': 'showStatusChangeWarning',
        'swc-checkbox:change .swc-checkbox.show-password': 'setPasswordState',

        'swc-dropdown:change .swc-dropdown.channel-selection': 'onChanelChange',
        'swc-dropdown:change .swc-dropdown.encryption-selection': 'setEncryptionState',

        'click .wps-pairing:not(.disabled)': 'startWpsPairing'
    },

    setTemplateData: function() {
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            wifiConfigurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
            status: swc.models.Wireless.getParameter("status", this.accessPointInterface),
            ssid: swc.models.Wireless.getParameter("name", this.accessPointInterface),
            password: swc.models.Wireless.getParameter("password", this.accessPointInterface),
            visibility: swc.models.Wireless.getParameter("visibility", this.accessPointInterface) ? "visible" : "hidden",
            encryption: swc.models.Wireless.getParameter("encryption", this.accessPointInterface),
            encryptionOptions: swc.models.Wireless.formatEncryptionOptions(this.accessPointInterface),
            channel: swc.models.Wireless.getParameter('channel', this.accessPointInterface),
            channelAutoEnable: swc.models.Wireless.getParameter('channelAutoEnable', this.accessPointInterface),
            channelOptions: swc.models.Wireless.formatChannelsOptions(this.accessPointInterface),
            operating: swc.models.Wireless.getParameter('operating', this.accessPointInterface),
            operatingOptions: swc.models.Wireless.formatOperatingOptions(this.accessPointInterface)
        };

        // For 5 GHz 36,40,44,48 will report 42, so 40 will be set
        if (this.templateData.channel === 42) {
            this.templateData.channel = 40;
        }

        // For 5 GHz 52,56,60,64 will report 58, so 52 will be set
        if (this.templateData.channel === 58) {
            this.templateData.channel = 52;
        }

        // For 5 GHz 100,104,108,112 will report 106, so 100 will be set
        if (this.templateData.channel === 106) {
            this.templateData.channel = 100;
        }
    },

    renderComplete: function() {
        var self = this,
            encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection'),
            passwordOrigBox = this.$el.find('input.password-original'),
            passwordCopyBox = this.$el.find('input.password-copy');

        this.setEncryptionData();
        this.setChannelData();
        this.setOperatingMode();
        this.setShowPasswordState();

        // Listener on Encryption dropdown change (Validate visible password box)
        encryptionDropdown.on('validation-success', function() {
            if (passwordOrigBox.css('display') !== 'none') {
                self.pageValidation(passwordOrigBox, false);
            } else {
                self.pageValidation(passwordCopyBox, false);
            }
        });
    },

    setShowPasswordState: function() {
        var encryption = this.templateData["encryption"],
            $passwordOrigBox = this.$('input.password-original'),
            $passwordCopyBox = this.$('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (encryption === 'None') {
           $showPasswordCheckbox
               .addClass('disabled')
               .trigger('swc-checkbox:swc-change', false);
        }
    },

    /**
     * Handler for channel changes
     *
     * @description:
     *
     *  When user changes channel, and one of watched values has selected -> user must be shown a confirmation dialog:
     *
     *  if user presses "apply" value has to be applied to the dropdown
     *  if user presses "cancel" value has to be reverted to previous one
     *
     * @param e
     * @param value
     */
    onChanelChange: function(e, value) {
        var self = this,
            dropdown = $(e.target),
            previousValue = dropdown.data("previous-value"),
            watchedValues = [ 116, 120, 124, 128 ];

        if (_.indexOf(watchedValues, value) !== -1) {
            SWCElements.modalWindow.show({
                templateID: 'wifi:settings:modal-windows:on-change-chanel',
                templateData: {},
                className: 'wifi-on-change-chanel',

                onCancel: function() {
                    dropdown.trigger('swc-dropdown:swc-change', previousValue);
                    self.setButtonsState();
                },

                onApply: function() {
                    SWCElements.modalWindow.hide();
                    self.setButtonsState();
                }
            });
        }
    },

    setEncryptionData: function() {
        var encryptionDropdown = this.$el.find('.swc-dropdown.encryption-selection');

        // Set dropdown data:
        encryptionDropdown.data('options', this.templateData["encryptionOptions"]);
        encryptionDropdown.trigger('swc-dropdown:swc-change', this.templateData["encryption"]);
        encryptionDropdown.data("default-value", this.templateData["encryption"]);

        // Update password boxes state:
        this.setEncryptionState(null, this.templateData["encryption"]);
    },

    setChannelData: function() {
        var dropDownChannel = this.$el.find('.swc-dropdown.channel-selection');

        // Update dropdown data
        dropDownChannel.data('options', this.templateData["channelOptions"]);

        if (this.templateData["channelAutoEnable"]) {
            dropDownChannel.data("default-value", "auto");
            dropDownChannel.trigger('swc-dropdown:swc-change', "auto");
        } else {
            dropDownChannel.data("default-value", this.templateData["channel"]);
            dropDownChannel.trigger('swc-dropdown:swc-change', this.templateData["channel"]);
        }
    },

    setOperatingMode: function() {
        var dropDownOperation = this.$el.find('.swc-dropdown.operating-mode-selection');

        // Update dropdown data
        dropDownOperation.data('options', this.templateData["operatingOptions"]);
        dropDownOperation.data("default-value", this.templateData["operating"]);
        dropDownOperation.trigger('swc-dropdown:swc-change', this.templateData["operating"]);
    },

    setPasswordState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if (value) {
            passwordOrigBox.hide();
            passwordCopyBox.show();
        } else {
            passwordCopyBox.hide();
            passwordOrigBox.show();
        }
    },

    setEncryptionState: function(e, value) {
        var passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy'),
            $showPasswordCheckbox = this.$('.swc-checkbox.show-password');

        if (value === "None") {
            passwordOrigBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
            passwordCopyBox.addClass("disabled").attr("disabled", "disabled").removeClass("validatable");
        } else {
            $showPasswordCheckbox.removeClass('disabled');
            passwordOrigBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
            passwordCopyBox.removeClass("disabled").removeAttr("disabled", "disabled").addClass("validatable");
        }
    },

    showStatusChangeWarning: function() {
        var self = this,
            checkBox = this.$el.find('.swc-checkbox.WiFiEnable'),
            parameter = getParameter(checkBox);

        if (!parameter.parameterValue) {
            SWCElements.modalWindow.show({
                templateID: 'wifi:settings:modal-windows:turn-' + self.accessPointInterface + '-off',
                templateData: {},
                className: 'wifi-ap-change-state-warning',
                onCancel: function() {
                    checkBox.trigger('swc-checkbox:swc-change', true);
                    self.setButtonsState();
                },

                onApply: function() {
                    SWCElements.modalWindow.hide();
                    self.setButtonsState();
                }
            });
        }
    },

    updatePasswordsChange: function(e) {
        var parameters = getParameter($(e.target)),
            passwordOrigBox = $('input.password-original'),
            passwordCopyBox = $('input.password-copy');

        if ($.inArray('password-original', parameters.parameterClasses) !== -1) {
            passwordCopyBox.val(passwordOrigBox.val());
        } else {
            passwordOrigBox.val(passwordCopyBox.val());
        }
    },

    startWpsPairing: function() {
        // lazy mixin:
        _.extend(this, swc.constructors.WpsPairingMixin);
        this.startWpsPairing();
    },

    save: function() {
        var self = this,
            deferred = new $.Deferred(),
            pageData = [],
            actionsToDo = [];

        // Get elements name => value map
        $.each(this.getElements(), function(key, element) {
            pageData.push(getParameter($(element)));
        });

        // Define what settings has to be saved:
        if (swc.models.Wireless.getParameter("configurationMode", "status")) {
            actionsToDo = [
                swc.models.Wireless.saveSettingsCombined('2.4GHz', pageData),
                swc.models.Wireless.saveSettingsCombined('5GHz', pageData)
            ];
        } else {
            actionsToDo = [
                swc.models.Wireless.saveSettings(self.accessPointInterface, pageData),
                swc.models.Wireless.setVAPStatus(self.accessPointInterface, pageData)
            ];
        }

        // Process save request:
        $.when.apply(null, actionsToDo).done(function() {
            $.when(swc.models.Wireless.sync()).done(function() {
                return deferred.resolve();
            }).fail(function() {
                    return deferred.reject();
                });
        }).fail(function() {
                return deferred.reject();
            });

        return deferred.promise();
    }
});;swc.constructors.WifiSettingsType5View = swc.constructors.WifiSettingsType24View.extend({

    className: 'type-5',

    accessPointInterface: '5GHz'
});
;swc.constructors.WifiSettingsView = swc.base.PageView.extend({

    className: 'wifi-settings',

    events: {
        'swc-switcher:change .enable-wifi-global': 'setWiFiGlobalState',
        'swc-dropdown:change .swc-dropdown.wifi-mode': 'updateWiFiGlobalMode'
    },

    models: [
        'Schedulers',
        'NetworkDevices'
    ],

    setTemplateData: function() {
        this.templateData = {
            wifiState: swc.models.Wireless.getParameter("status", "status"),
            wifiConfigurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
            wifiSchedulerState: swc.models.Schedulers.get('wifi').get('enable')
        };
    },

    renderComplete: function() {
        this.setWiFiGlobalMode();
    },

    setWiFiGlobalState: function(e, value) {
        // Show saving page state:
        this.showPageLoading("Updating WiFi state");

        // Send requests to update wifi status on the device:
        $.when(
                swc.models.Wireless.setGlobalStatus(value)
            ).done(function() {
                $.when(swc.models.Wireless.sync()).done(function() {
                    swc.router.navigate(Backbone.history.fragment);
                });
            });
    },

    setWiFiGlobalMode: function() {
        var dropDown = this.$el.find(".swc-dropdown.wifi-mode"),
            isEquals = swc.models.Wireless.isAccessPointsEquals('2.4GHz', '5GHz', ['name', 'password', 'encryption', 'visibility', 'status']),
            data = {
                configurationMode: swc.models.Wireless.getParameter("configurationMode", "status"),
                options: swc.models.Wireless.formatModeOptions()
            };

        // TR-069 Upgrade Regression fix (when mode is combined but APs not equals
        if (data.configurationMode && !isEquals) {
            this.resetWiFiGlobalMode('separate');
        } else {
            dropDown.data('options', data["options"]);
            dropDown.data('default-value', data["configurationMode"] ? 'combined' : 'separate');
            dropDown.trigger('swc-dropdown:swc-change', data["configurationMode"] ? 'combined' : 'separate');
        }
    },

    updateWiFiGlobalMode: function(e, value) {
        var parameter = getParameter($(e.target)),
            dropDown = this.$el.find(".swc-dropdown.wifi-mode"),
            isEquals = swc.models.Wireless.isAccessPointsEquals('2.4GHz', '5GHz', ['name', 'password', 'encryption']),
            encryption = swc.models.Wireless.getParameter("encryption", '5GHz'),
            self = this,
            data = {
                ssid: swc.models.Wireless.getParameter("name", '5GHz'),
                password: swc.models.Wireless.getParameter("password", '5GHz'),
                encryption: ""
            };

        // Pass encryption as localised string
        switch (encryption) {
        case 'None':
            data.encryption = getTranslationStrings("No encryption");
            break;
        case 'WPA2-Personal':
            data.encryption = getTranslationStrings("WPA2");
            break;
        case 'WPA-WPA2-Personal':
            data.encryption = getTranslationStrings("WPA/WPA2");
            break;
        }

        // Check if current switch selected to combined mode:
        if (parameter.parameterValue === "combined") {
            if (!isEquals) {
                SWCElements.modalWindow.show({
                    templateID: 'wifi:settings:modal-windows:set-combined-mode',
                    templateData: data,
                    className: 'wifi-global-change-mode',
                    onCancel: function() {
                        dropDown.trigger('swc-dropdown:swc-change', 'separate');
                    },
                    onApply: function() {
                        self.resetWiFiGlobalMode('combined');
                    }
                });
            } else {
                self.resetWiFiGlobalMode('combined');
            }
        } else {
            self.resetWiFiGlobalMode('separate');
        }
    },

    resetWiFiGlobalMode: function(mode) {
        var pages = Backbone.history.fragment.split('/'),
            toDo = [
                swc.models.Wireless.setGlobalConfigurationMode(mode === "combined")
            ];

        // Close current modal window:
        SWCElements.modalWindow.hide();

        // Show page loading message
        this.showPageLoading("Switching Wi-Fi to " + mode + " mode");

        // Switch to selected mode:
        if (mode === "combined") {
            toDo.push(swc.models.Wireless.switchToCombinedMode('2.4GHz'));
        }

        // Save changes to Configuration Mode
        $.when.apply(null, toDo).done(function() {
            swc.router.navigate(pages[0] + "/" + pages[1] + "/" + 'type-24', {skipUnsavedChanges: true});
        });
    }
});
;swc.constructors.WpsPairingMixin = {

    startWpsPairing: function() {
        var wirelessDevicesCount = swc.models.NetworkDevices.where({ interfaceType: 'wireless', status: true }).length,
            self = this;

        self.showPageLoading('Starting WPS Pairing...');

        // Request WPS pairing from NP:
        $.when(swc.models.Wireless.startWPSPairing())
            .done(function() {
                self.stopPageLoading();
                self.wpsPairingModal(wirelessDevicesCount);
            })
            .fail(function() {
                self.wpsPairingError();
            });
    },

    wpsPairingModal: function(wirelessDevicesCount) {
        var self = this,
            timeEnd = false;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:pairing',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onShow: function() {
                var element = $('.modalWindow'),
                    isSuccess = false,
                    pairingTime = 120000,
                    wpsRuler;

                // Insert progress ruller to the template:
                element.find('.ruler-block').html(
                    $.tmpl(swc.Templates.get('ruler').get('content'), {
                        'className': 'reset-ruler'
                    })
                );

                wpsRuler = element.find('.reset-ruler');

                function checkNewDevice() {
                    if (!timeEnd) {
                        $.when(swc.models.NetworkDevices.sync(true))
                            .done(function() {
                                var updatedWirelessDevicesCount = swc.models.NetworkDevices.where({ interfaceType: 'wireless', status: true }).length;

                                if (updatedWirelessDevicesCount > wirelessDevicesCount) {
                                    isSuccess = true;
                                    wpsRuler.trigger('swc-ruler:finish', true);
                                } else {
                                    setTimeout(checkNewDevice, 2000);
                                }
                            });
                    }
                }

                wpsRuler.on('swc-ruler:finish', function(status) {
                    timeEnd = true;

                    SWCElements.modalWindow.hide();

                    if (isSuccess) {
                        self.wpsPairingComplete();
                    } else {
                        self.wpsPairingError();
                    }
                });

                setTimeout(function() {
                    wpsRuler.trigger('swc-ruler:start', { time: pairingTime });
                    checkNewDevice();
                }, 10);
            },
            onCancel: function(){
                $.when(swc.models.Wireless.stopWPSPairing()).done(function() {
                    timeEnd = true;
                });
            }
        });
    },

    wpsPairingComplete: function() {
        var self = this;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:complete',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onApply: function() {
                SWCElements.modalWindow.hide();
                swc.router.navigate('network/devices', { trigger: true });
            }
        });
    },

    wpsPairingError: function() {
        var self = this;

        SWCElements.modalWindow.show({
            className: 'wps-pairing',
            templateID: 'wifi:wps:modal:failed',
            templateData: {
                localeStrings: swc.models.Locale.getLocaleStrings(self.pageTemplateID),
                localeString: getTranslationStringsjQuery
            },

            onApply: function() {
                SWCElements.modalWindow.hide();
                self.startWpsPairing();
            }
        });
    }
};
