declare
  vVoipApnsTypeId number;
  vVoipGcmTypeId number;
  vTypeId number;
  vRecipientId number;

  APNS constant varchar2(4) := 'APNS';
  GCM constant varchar2(3) := 'GCM';

  function getVoipTypeIdForPlatform(pPlatformName in varchar2) return number
  is
    vTypeId number;
    begin
      select t.id into vTypeId from NOTIFY_TYPE t, notify_platform p
      where t.platform_id=p.id and p.PLATFORM=pPlatformName and t.type='VOIP' and t.event_name='CALL';

      return vTypeId;
    end;

begin
  vVoipApnsTypeId := getVoipTypeIdForPlatform(APNS);
  vVoipGcmTypeId := getVoipTypeIdForPlatform(GCM);
  dbms_output.put_line('vVoipApnsTypeId='||vVoipApnsTypeId);
  dbms_output.put_line('vVoipGcmTypeId='||vVoipGcmTypeId);

  for rec in (select * from VOIP_NOTIFICATION_TOKEN)
  loop
    dbms_output.put_line('rec.type='||rec.type);
    if rec.type = APNS then
      vTypeId := vVoipApnsTypeId;
    elsif rec.type = GCM then
      vTypeId := vVoipGcmTypeId;
    else
      vTypeId := null;
    end if;
    dbms_output.put_line('vTypeId='||vTypeId);
    if vTypeId is not null then
      dbms_output.put_line('insert='||vTypeId);
      insert into notify_recipient(id, mac, recipient, notify_type_id)
      values(notify_recipient_seq.nextval, rec.mac, rec.token, vTypeId);
    end if;
  end loop;
  commit;
  exception when others then
  rollback;
  raise;
end;
/
