#!/bin/bash

source common.sh

cd `dirname $0`

REST_URL_ADDR=$(ifconfig $NETWORK_IF | awk 'match($0, /addr:([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)/, a) {print a[1]}')
REST_URL="$REST_URL_PROTOCOL:\/\/$REST_URL_ADDR:$REST_URL_PORT"
sed -i -e "s/GDConnection.restUrl=.*/GDConnection.restUrl=$REST_URL/g" settings.properties

mem=-Xmx6g
CommServerDirectory=/opt/remotenas/CommServer
jmx="
-Dcom.sun.management.jmxremote \
-Dcom.sun.management.jmxremote.port=9010 \
-Dcom.sun.management.jmxremote.local.only=true \
-Dcom.sun.management.jmxremote.authenticate=true \
-Dcom.sun.management.jmxremote.ssl=false \
-Dcom.sun.management.jmxremote.password.file=$CommServerDirectory/jmxremote.password \
-Dcom.sun.management.jmxremote.access.file=$CommServerDirectory/jmxremote.access \
"

export LD_LIBRARY_PATH="$JRE_PATH/lib/amd64/server:$JRE_PATH/lib/amd64/xawt:$JRE_PATH/lib/amd64"

CLASSPATH=

for a in `ls lib/*`; do
CLASSPATH=$CLASSPATH:$a
done;

java -Djava.net.preferIPv4Stack=true $jmx $mem $SNMP_OPTS -classpath $CLASSPATH -Dhttps.cipherSuites="TLS_RSA_WITH_AES_256_CBC_SHA" -Djava.library.path="./bin" com.vestiacom.gdserver.Main >> /var/opt/remotenas/logs/output.log 2>&1 &

echo $! > gdserver.pid
