<?xml version="1.0"?>
<!-- 
NAME
    kuview.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of md$_view_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    akrugli 09/07/06 - Column Map Views got rechristened as Editioning Views
    rapayne 06/07/06 - add support for editioning views.
    sdavids 11/02/05 - fix inconsistent stylesheet format 
    lbarton 08/06/03 - Bug 3056720: support long view text 
    htseng  12/18/02 - add EXPORT parameter
    htseng  08/02/02 - add grantee parse param
    htseng  07/29/02 - add more parse params
    htseng  08/07/02 - add condition to generate CONSTRAINT or not
    lbarton 05/06/02 - support subviews
    lbarton	10/25/01 - xdb support
    dgagne	07/16/01 - update for constraints on views
    lbarton	06/01/01 - remove oradb-style imports
    lbarton	11/10/00 - support long views
    lbarton	10/26/00 - fix sqlterminator bug
    gclaborn    10/30/00 - Add external imports; change name
    lbarton	07/24/00 - use uriref in import
    lbarton	07/03/00 - fix sqlterminator bug
    lbarton	06/02/00 - support parsing
    lbarton	05/15/00 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <xsl:import href="kutable.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="FORCE">1</xsl:param>
 <xsl:param name="CONSTRAINTS">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="VIEW_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">VIEW</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="$EXPORT=0">
   <xsl:text>OR REPLACE</xsl:text>
  </xsl:if>
  <xsl:if test="$FORCE=1"> FORCE</xsl:if>
  <!-- Editioning Views -->
  <xsl:if test="(PROPERTY mod 64)>=32"> EDITIONING</xsl:if>
  <xsl:text> VIEW </xsl:text>
  <xsl:apply-templates select="SCHEMA_OBJ"/>
  <xsl:choose>
   <xsl:when test="(PROPERTY mod 2)>=1">
    <!-- object view -->
    <xsl:text>OF </xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Schema" select="OWNER_NAME"/>
     <xsl:with-param name="Object" select="NAME"/>
    </xsl:call-template>
    <xsl:if test="NAME='XMLTYPE' and OWNER_NAME='SYS' and
	COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;  </xsl:text>
     </xsl:if>
     <xsl:apply-templates select="COL_LIST2/COL_LIST2_ITEM[NAME='SYS_NC_ROWINFO$']/OPQMD/SCHEMA_ELMT"/>
    </xsl:if>
    <xsl:if test="OIDTEXTLENGTH > 0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> WITH OBJECT IDENTIFIER (</xsl:text>
     <xsl:value-of select="OIDTEXT"/>
     <xsl:text>)</xsl:text>
    </xsl:if>
    <xsl:if test="UNDERTEXTLENGTH > 0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> </xsl:text>
     <xsl:value-of select="UNDERTEXT"/>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <!-- relational view -->
    <xsl:text>(</xsl:text>
    <xsl:apply-templates select="COL_LIST">
     <xsl:with-param name="ADT_type">INDEX</xsl:with-param>
     <xsl:with-param name="DoLF">0</xsl:with-param>
     <xsl:with-param name="DoHidden">1</xsl:with-param>
    </xsl:apply-templates>
    <xsl:if test="$CONSTRAINTS=1">
     <xsl:call-template name="GenTableConstraints">
      <xsl:with-param name="SchemaObjParent" select="current()"/>
      <xsl:with-param name="ListParent" select="current()"/>
      <xsl:with-param name="InColList">1</xsl:with-param>
      <xsl:with-param name="CommaNeeded">1</xsl:with-param>
      <xsl:with-param name="Property" select="PROPERTY"/>
     </xsl:call-template>
    </xsl:if>
    <xsl:text>)</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text> AS </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="TEXTVCNT">
    <xsl:for-each select="TEXTVCNT/TEXTVCNT_ITEM">
     <xsl:value-of select="."/>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="TEXT"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="(WITH_OPTION/FLAGS mod 16)>=8"/>
   <xsl:otherwise>
    <xsl:if test="string-length(WITH_OPTION/NAME)!=0">
     <xsl:text> CONSTRAINT "</xsl:text>
     <xsl:value-of select="WITH_OPTION/NAME"/>
     <xsl:text>"</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
