<?xml version="1.0"?>
<!-- 
 Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
NAME
    kutblspc.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_tablespace_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     11/20/08 - archive level compression
    tbhukya     03/23/09 - Bug 7699521: Tablespace with encryption, retention
    tbhukya     12/18/07 - Bug 6676420: add default compress clause
    mjangir     10/16/07 - bug 6472131: temporary ts of dictionary manage
    htseng      08/09/07 - bug 5738829
    lbarton     11/29/06 - fix IS_OMF test
    lbarton     02/20/06 - bug 4752442: BIGFILE 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    sdavidso    10/21/05 - generate group name for temporary tbs 
    sdavidso    08/23/05 - Allow OMF datafiles in tablespaces
    htseng      08/19/04 - bug 3794006: add alter command to resize tbs 
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    htseng      12/18/03 - bug 3324545: remove maxsize  UNLIMITED  
    lbarton     11/07/03 - Bug 3238141: SEGMENT_ATTRIBUTES param 
    htseng      04/04/03 - fix bug 2880535
    htseng  	02/05/03 - condition for generate read only 
    htseng 	01/28/03 - bug fix 2770880 read only tbs 
    lbarton	10/02/02 - add REUSE param
    htseng	08/02/02 - add grantee parse param
    htseng	07/29/02 - add more parse params
    lbarton     08/02/02 - transportable export
    lbarton	06/13/02 - define EXPORT param
    dgagne	11/05/01 - remove row movement from partitions and tablespace
    dgagne	10/12/01 - add compression to tablespace
    dgagne	09/24/01 - add support for force logging
    dgagne	08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne	05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="REUSE">0</xsl:param>
 <!-- these parameters are for storage clause only -->
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="PCTSPACE">100</xsl:param>
 <xsl:param name="VERSION">9999999999</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Templates -->
 <xsl:template match="TABLESPACE_T">
  <!-- *******************************************************************
Template: TABLESPACE_T - top-level template for tablespaces.
   Depending on the tablespace type this template calls
   DoUndoTS
   DoPermanentTS
   DoTemporaryTS
   Then if necessary it does ALTER TABLESPACE to resize the datafiles
******************************************************************** -->
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">TABLESPACE</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="CONTENTS = 0">
    <xsl:choose>
     <xsl:when test="(FLAGS mod 32) >= 16">
      <xsl:call-template name="DoUndoTS"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="DoPermanentTS"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="DoTemporaryTS"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
  <!-- resize tablespace -->
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
  <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
   <xsl:if test="(FSIZE != RESIZE) and RESIZE !=0">
    <xsl:call-template name="DoParse">
     <xsl:with-param name="Verb">ALTER</xsl:with-param>
     <xsl:with-param name="ObjectType">TABLESPACE</xsl:with-param>
     <xsl:with-param name="NameNode" select="NAME"/>
    </xsl:call-template>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text> ALTER DATABASE DATAFILE </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;  </xsl:text>
    </xsl:if>
    <xsl:text>'</xsl:text>
    <xsl:value-of select="FNAME"/>
    <xsl:text>' RESIZE </xsl:text>
    <xsl:value-of select="RESIZE*$BlkSize"/>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
     <!-- Terminate the SQL statement -->
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="DoPermanentTS">
  <!-- *******************************************************************
 Template: DoPermanentTS
     Output complete "Create Tablespace" statement for permanent
     tablespaces (not undo or temporary) 
     If necessary it subsequently does an ALTER TABLESPACE
     to set it READ ONLY.
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:text>TABLESPACE "</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>" DATAFILE </xsl:text>
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
  <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
   <xsl:call-template name="DoDataFile">
    <xsl:with-param name="BlkSize" select="$BlkSize"/>
   </xsl:call-template>
  </xsl:for-each>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="(DFLOGGING mod 2) = 0">
    <xsl:text> NOLOGGING</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> LOGGING</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="(DFLOGGING mod 4) >= 2">
   <xsl:text> FORCE LOGGING</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="STATUS = 1 or STATUS = 4">
    <xsl:text> ONLINE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> OFFLINE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="CONTENTS = 0">
    <xsl:text> PERMANENT BLOCKSIZE </xsl:text>
    <xsl:value-of select="$BlkSize"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> TEMPORARY</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:call-template name="ExtentManagement">
   <xsl:with-param name="BlkSize" select="$BlkSize"/>
  </xsl:call-template>
  <xsl:if test="$EXPORT =0 and STATUS =4">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">ALTER</xsl:with-param>
    <xsl:with-param name="ObjectType">TABLESPACE</xsl:with-param>
    <xsl:with-param name="NameNode" select="NAME"/>
   </xsl:call-template>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
    <!-- Terminate the SQL statement -->
   </xsl:if>
   <xsl:text>&#xa; </xsl:text>
   <xsl:text> ALTER TABLESPACE "</xsl:text>
   <xsl:value-of select="NAME"/>
   <xsl:text>" READ ONLY</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoCreateVerb">
  <!-- *******************************************************************
 Template: DoCreateVerb
     Output CREATE [BIGFILE]
******************************************************************** -->
  <xsl:text>CREATE </xsl:text>
  <xsl:if test="(FLAGS mod 512)>=256">BIGFILE </xsl:if>
 </xsl:template>
 <xsl:template name="DoUndoTS">
  <!-- *******************************************************************
 Template: DoUndoTS
     Output complete "Create Undo Tablespace" statement
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:text>UNDO TABLESPACE "</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>" DATAFILE </xsl:text>
  <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
  <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
   <xsl:call-template name="DoDataFile">
    <xsl:with-param name="BlkSize" select="$BlkSize"/>
   </xsl:call-template>
  </xsl:for-each>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> BLOCKSIZE </xsl:text>
  <xsl:value-of select="$BlkSize"/>
  <xsl:call-template name="ExtentManagement">
   <xsl:with-param name="BlkSize" select="$BlkSize"/>
   <xsl:with-param name="Undo">1</xsl:with-param>
  </xsl:call-template>
  <xsl:if test="(FLAGS mod 1024) >= 512">
   <xsl:text> RETENTION GUARANTEE </xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template name="DoTemporaryTS">
  <!-- *******************************************************************
 Template: DoTemporaryTS
     Output complete "Create Temporary Tablespace" statement
******************************************************************** -->
  <xsl:call-template name="DoCreateVerb"/>
  <xsl:choose>
   <xsl:when test="BITMAPPED = 0">
    <xsl:text> TABLESPACE "</xsl:text>
    <xsl:value-of select="NAME"/>
    <xsl:text>" DATAFILE </xsl:text>
    <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
    <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
     <xsl:call-template name="DoDataFile">
      <xsl:with-param name="BlkSize" select="$BlkSize"/>
     </xsl:call-template>
    </xsl:for-each>
    <xsl:if test="string-length(GROUPNAME)!=0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> TABLESPACE GROUP </xsl:text>
     <xsl:value-of select="GROUPNAME"/>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> EXTENT MANAGEMENT DICTIONARY TEMPORARY </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>TEMPORARY TABLESPACE "</xsl:text>
    <xsl:value-of select="NAME"/>
    <xsl:text>" TEMPFILE </xsl:text>
    <xsl:variable name="BlkSize" select="BLOCKSIZE"/>
    <xsl:for-each select="FILESPEC/FILESPEC_ITEM">
     <xsl:call-template name="DoDataFile">
      <xsl:with-param name="BlkSize" select="$BlkSize"/>
     </xsl:call-template>
    </xsl:for-each>
    <xsl:if test="string-length(GROUPNAME)!=0">
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa; </xsl:text>
     </xsl:if>
     <xsl:text> TABLESPACE GROUP </xsl:text>
     <xsl:value-of select="GROUPNAME"/>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> EXTENT MANAGEMENT LOCAL UNIFORM SIZE </xsl:text>
    <xsl:value-of select="DFLINIT * $BlkSize"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoDataFile">
  <xsl:param name="BlkSize"/>
  <!-- *******************************************************************
 Template: DoDataFile
     Output filespec and autoextend clause for tablespaces
******************************************************************** -->
  <xsl:if test="position()>1">
   <xsl:text>,</xsl:text>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <!-- IS_OMF is not necessarily in the document -->
  <xsl:choose>
   <xsl:when test="IS_OMF!=0"/>
   <xsl:otherwise>
    <xsl:text>'</xsl:text>
    <xsl:value-of select="FNAME"/>
    <xsl:text>' </xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>SIZE </xsl:text>
  <xsl:choose>
   <xsl:when test="string-length($PCTSPACE)!=0 and $PCTSPACE!=100">
    <xsl:value-of select="round(FSIZE*$BlkSize*$PCTSPACE*0.01)"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="FSIZE*$BlkSize"/>
   </xsl:otherwise>
  </xsl:choose>
  <!-- IS_OMF is not necessarily in the document -->
  <xsl:choose>
   <xsl:when test="IS_OMF!=0"/>
   <xsl:when test="$REUSE!=0">
    <xsl:text> REUSE </xsl:text>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="MAXEXTEND > 0">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> AUTOEXTEND ON NEXT </xsl:text>
   <xsl:value-of select="INC * $BlkSize"/>
   <xsl:text> MAXSIZE </xsl:text>
   <xsl:choose>
    <xsl:when test="(MAXEXTEND * $BlkSize) > 2147483647">
     <xsl:value-of select="floor((MAXEXTEND * $BlkSize) div 1048576)"/>
     <xsl:text>M</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="MAXEXTEND * $BlkSize"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
 </xsl:template>
 <xsl:template name="ExtentManagement">
  <!-- *******************************************************************
 Template: ExtentManagement
 Template for "Extent Management Clause"
******************************************************************** -->
  <xsl:param name="BlkSize"/>
  <xsl:param name="Undo">0</xsl:param>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa; </xsl:text>
  </xsl:if>
  <xsl:text> EXTENT MANAGEMENT</xsl:text>
  <xsl:choose>
   <xsl:when test="BITMAPPED = 0">
    <xsl:text> DICTIONARY</xsl:text>
    <xsl:if test="$SEGMENT_ATTRIBUTES=1">
     <xsl:text> DEFAULT </xsl:text>
     <xsl:call-template name="DoCompress"/>
     <xsl:call-template name="NamedStorage">
      <xsl:with-param name="BlkSize" select="$BlkSize"/>
      <xsl:with-param name="ObjType" select="'TABLESPACE'"/>
      <xsl:with-param name="Node" select="."/>
     </xsl:call-template>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> LOCAL</xsl:text>
    <xsl:choose>
     <xsl:when test="(FLAGS mod 2) = 1">
      <xsl:text> AUTOALLOCATE</xsl:text>
      <xsl:if test="$SEGMENT_ATTRIBUTES=1 and $VERSION>=1100000000 and $Undo=0">
       <xsl:if test="(FLAGS mod 65536) >= 32768">
        <xsl:text> ENCRYPTION</xsl:text>
       </xsl:if>
       <xsl:text> DEFAULT </xsl:text>
       <xsl:choose>
        <xsl:when test="(FLAGS mod 65536) >= 32768">
         <xsl:text>STORAGE(ENCRYPT)</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:call-template name="DoCompress"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:if>
     </xsl:when>
     <xsl:when test="(FLAGS mod 4) = 0">
      <xsl:if test="$SEGMENT_ATTRIBUTES=1">
       <xsl:text> USER</xsl:text>
       <xsl:text> DEFAULT </xsl:text>
       <xsl:call-template name="DoCompress"/>
       <xsl:call-template name="NamedStorage">
        <xsl:with-param name="BlkSize" select="$BlkSize"/>
        <xsl:with-param name="ObjType" select="'TABLESPACE'"/>
        <xsl:with-param name="Node" select="."/>
       </xsl:call-template>
       <xsl:text> MINIMUM EXTENT </xsl:text>
       <xsl:choose>
        <xsl:when test="string-length($PCTSPACE)!=0 and $PCTSPACE!=100">
         <xsl:value-of select="round(DFLMINLEN * $BlkSize*$PCTSPACE*0.01)"/>
        </xsl:when>
        <xsl:otherwise>
         <xsl:value-of select="DFLMINLEN * $BlkSize"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:if>
     </xsl:when>
     <xsl:when test="(FLAGS mod 4) = 2">
      <xsl:text> UNIFORM SIZE </xsl:text>
      <xsl:choose>
       <xsl:when test="string-length($PCTSPACE)!=0 and $PCTSPACE!=100">
        <xsl:value-of select="round(DFLINIT * $BlkSize*$PCTSPACE*0.01)"/>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="DFLINIT * $BlkSize"/>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:text> DEFAULT </xsl:text>
      <xsl:call-template name="DoCompress"/>
     </xsl:when>
    </xsl:choose>
    <xsl:if test="$Undo=0">
     <xsl:call-template name="SegmentSpaceManagement"/>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DoCompress">
  <!-- *******************************************************************
 Template: DoCompress: utility template to call DoTSCompress with
the correct parameter value
******************************************************************** -->
  <xsl:call-template name="DoTSCompress">
   <xsl:with-param name="Compress" select="FLAGS"/>
  </xsl:call-template>
 </xsl:template>
 <xsl:template name="SegmentSpaceManagement">
  <!-- *******************************************************************
 Template: SegmentSpaceManagement
 Template for "Segment Space Management clause" 
******************************************************************** -->
  <xsl:text> SEGMENT SPACE MANAGEMENT</xsl:text>
  <xsl:choose>
   <xsl:when test="((FLAGS mod 64) >= 32)">
    <xsl:text> AUTO</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> MANUAL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
