<?xml version="1.0"?>
<!--
 Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
NAME
    kususer.xsl
DESCRIPTION
    Convert mdapi USER_T document to USER document (SXML)

MODIFIED        MM/DD/YY
    abodge      07/06/12 - Bug 13371886: incorporate changes from 12805876 fix
    abodge      06/29/12 - Fix xmlns attribute problem
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscomm.xsl
    lbarton     01/08/07 - versioning
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng      11/04/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <!-- Templates -->
 <xsl:template match="USER_T">
  <!-- *******************************************************************
Template: USER_T - top-level template for USER.
  This template puts out
   - the opening USER element (with xmlns and version attributes)
   - NAME elements
******************************************************************** -->
  <xsl:element name="USER" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="NAME">
    <xsl:value-of select="NAME"/>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="PASSWORD='GLOBAL'">
     <xsl:element name="TYPE">GLOBAL</xsl:element>
    </xsl:when>
    <xsl:when test="PASSWORD='EXTERNAL'">
     <xsl:element name="TYPE">EXTERNAL</xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="TYPE">LOCAL</xsl:element>
     <!-- undocumented VALUE element required for reg tests -->
     <xsl:if test="$LRG!=0">
      <xsl:element name="VALUE">
       <xsl:choose>
        <xsl:when test="SPARE4_12 and $VERSION>=1200000000">
         <xsl:value-of select="SPARE4_12"/>
         <xsl:text>;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:if test="SPARE4 and $VERSION>=1100000000">
          <xsl:value-of select="SPARE4"/>
          <xsl:text>;</xsl:text>
         </xsl:if>
        </xsl:otherwise>
       </xsl:choose>
       <xsl:value-of select="PASSWORD"/>
      </xsl:element>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="EXT_USERNAME">
    <xsl:element name="EXTERNAL_NAME">
     <xsl:value-of select="EXT_USERNAME"/>
    </xsl:element>
   </xsl:if>
   <xsl:element name="DEFAULT_TABLESPACE">
    <xsl:value-of select="DATATS"/>
   </xsl:element>
   <xsl:if test="TEMPTS">
    <xsl:element name="TEMPORARY_TABLESPACE">
     <xsl:value-of select="TEMPTS"/>
    </xsl:element>
   </xsl:if>
   <xsl:if test="PROFNAME">
    <xsl:element name="PROFILE">
     <xsl:value-of select="PROFNAME"/>
    </xsl:element>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="ASTATUS_12 and $VERSION>=1200000000">
     <xsl:if test="ASTATUS_12 != 0">
      <xsl:if test="(ASTATUS_12 mod 4)> 0">
       <!-- KTSUCPEX =1 | KTSUCPEG =2  -->
       <xsl:element name="PASSWORD_EXPIRE">
      </xsl:element>
      </xsl:if>
      <xsl:if test="ASTATUS_12 >=4">
       <xsl:element name="ACCOUNT_LOCK">
        <xsl:text>Y</xsl:text>
       </xsl:element>
      </xsl:if>
     </xsl:if>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test="ASTATUS != 0">
      <xsl:if test="(ASTATUS mod 4)> 0">
       <!-- KTSUCPEX =1 | KTSUCPEG =2  -->
       <xsl:element name="PASSWORD_EXPIRE">
      </xsl:element>
      </xsl:if>
      <xsl:if test="ASTATUS >=4">
       <xsl:element name="ACCOUNT_LOCK">
        <xsl:text>Y</xsl:text>
       </xsl:element>
      </xsl:if>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
