<?xml version="1.0"?>
<!--
NAME
    kutrigd.xsl
DESCRIPTION
    Convert TRIGGER document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    abodge     09/22/09 - CONSOLIDATE STYLESHEETS: Multistatement support
    lbarton    01/02/07 - use kustrigc
    sdavidso   11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    lbarton    08/03/05 - 
    htseng     03/01/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kustrigc.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:template match="sxml:TRIGGER">
 <!-- *******************************************************************
Template: TRIGGER - top-level template for synonym.
  This template puts out
   - CREATE TRIGGER schema.name
******************************************************************** -->
  <xsl:call-template name="CreTrigger"/>
  <xsl:call-template name="DoTerminator"/>
  <xsl:apply-templates select="sxml:DISABLE"/>
 </xsl:template>
 <xsl:template match="sxml:DISABLE">
 <!-- *******************************************************************
Template: DISABLE
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$CM_MODE=1 and $PRS_DDL=1">
    <xsl:value-of select="$PRS_DELIM"/>
    <xsl:text>C</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>&#xa;</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>  ALTER TRIGGER </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select=".."/>
  </xsl:call-template>
  <xsl:text> DISABLE</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
