<?xml version="1.0"?>
<!--
NAME
    kusseq.xsl
DESCRIPTION
    Convert mdapi SEQUENCE_T document to SEQUENCE document (SXML)

MODIFIED        MM/DD/YY
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    htseng     12/09/04 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <!-- *******************************************************************
Template: SEQUENCE_T - top-level template for SEQUENCE.
  This template puts out
   - the opening SEQUENCE element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
 <xsl:template match="SEQUENCE_T">
  <xsl:element name="SEQUENCE" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   </xsl:element>
   <xsl:element name="START_WITH">
    <xsl:value-of select="HIGHWATER"/>
   </xsl:element>
   <xsl:element name="INCREMENT">
    <xsl:value-of select="INCRE"/>
   </xsl:element>
   <xsl:element name="MINVALUE">
    <xsl:value-of select="MINVALUE"/>
   </xsl:element>
   <xsl:element name="MAXVALUE">
    <xsl:value-of select="MAXVALUE"/>
   </xsl:element>
   <xsl:if test="CYCLE=1">
    <xsl:element name="CYCLE"/>
   </xsl:if>
   <xsl:element name="CACHE">
    <xsl:value-of select="CACHE"/>
   </xsl:element>
   <xsl:if test="SEQ_ORDER=1">
    <xsl:element name="ORDER"/>
   </xsl:if>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
