<?xml version="1.0"?>
<!--
NAME
    kusgnted.xsl
DESCRIPTION
    Grant to/revoke from grantees.

MODIFIED        MM/DD/YY
    abodge      05/22/12 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommc.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="GRANTS">1</xsl:param>
 <!-- Templates -->
 <xsl:template name="Grants">
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Grantee" select="''"/>
  <!-- *******************************************************************
Template: Grants
Current node: USER | ROLE
Parameters:
 ParentNode - Parent of *_GRANT_LIST
 Grantee - Name of User or Role
******************************************************************** -->
  <xsl:if test="$GRANTS!=0">
   <xsl:apply-templates select="$ParentNode/sxml:SYSTEM_PRIV_GRANT_LIST">
    <xsl:with-param name="Grantee" select="$Grantee"/>
   </xsl:apply-templates>
   <xsl:apply-templates select="$ParentNode/sxml:ROLE_GRANT_LIST">
    <xsl:with-param name="Grantee" select="$Grantee"/>
   </xsl:apply-templates>
   <xsl:apply-templates select="$ParentNode/sxml:OBJECT_PRIV_GRANT_LIST">
    <xsl:with-param name="Grantee" select="$Grantee"/>
   </xsl:apply-templates>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:SYSTEM_PRIV_GRANT_LIST">
  <xsl:param name="Grantee" select="''"/>
  <!-- *******************************************************************
Template: SYSTEM_PRIV_GRANT_LIST
Parameters:
 Grantee - Name of User or Role
******************************************************************** -->
  <xsl:for-each select="sxml:SYSTEM_PRIV_GRANT_LIST_ITEM">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>GRANT </xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text> TO "</xsl:text>
   <xsl:value-of select="$Grantee"/>
   <xsl:text>"</xsl:text>
   <xsl:call-template name="AdminOption">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="$SQLTERMINATOR=1">
    <!-- Terminate the SQL statement -->
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:ROLE_GRANT_LIST">
  <xsl:param name="Grantee" select="''"/>
  <!-- *******************************************************************
Template: ROLE_GRANT_LIST
Parameters:
 Grantee - Name of User or Role
******************************************************************** -->
  <xsl:for-each select="sxml:ROLE_GRANT_LIST_ITEM">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>GRANT "</xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:text>" TO "</xsl:text>
   <xsl:value-of select="$Grantee"/>
   <xsl:text>"</xsl:text>
   <xsl:call-template name="AdminOption">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <xsl:if test="$SQLTERMINATOR=1">
    <!-- Terminate the SQL statement -->
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template match="sxml:OBJECT_PRIV_GRANT_LIST">
  <xsl:param name="Grantee" select="''"/>
  <!-- *******************************************************************
Template: OBJECT_PRIV_GRANT_LIST
Parameters:
 Grantee - Name of User or Role
******************************************************************** -->
  <xsl:for-each select="sxml:OBJECT_PRIV_GRANT_LIST_ITEM">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
   <xsl:text>GRANT </xsl:text>
   <xsl:value-of select="sxml:NAME"/>
   <xsl:if test="sxml:COL_LIST">
    <xsl:text> </xsl:text>
    <xsl:call-template name="ColumnList">
     <xsl:with-param name="ColListNode" select="sxml:COL_LIST"/>
    </xsl:call-template>
   </xsl:if>
   <xsl:text> ON </xsl:text>
   <xsl:choose>
    <xsl:when test="sxml:ON_OBJECT/sxml:DIRECTORY">
     <xsl:text>DIRECTORY "</xsl:text>
     <xsl:value-of select="sxml:ON_OBJECT/sxml:DIRECTORY"/>
     <xsl:text>"</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="SchemaName">
      <xsl:with-param name="ParentNode" select="sxml:ON_OBJECT"/>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:text> TO "</xsl:text>
   <xsl:value-of select="$Grantee"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="sxml:HIERARCHY_OPTION">
    <xsl:text> WITH HIERARCHY OPTION</xsl:text>
   </xsl:if>
   <xsl:if test="sxml:GRANT_OPTION">
    <xsl:text> WITH GRANT OPTION</xsl:text>
   </xsl:if>
   <xsl:if test="$SQLTERMINATOR=1">
    <!-- Terminate the SQL statement -->
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AdminOption">
  <xsl:param name="ParentNode" select="''"/>
  <!-- *******************************************************************
Template: AdminOption
Current node: *_GRANT_LIST_ITEM
Parameters:
 ParentNode - Parent of ADMIN_OPTION
******************************************************************** -->
  <xsl:if test="$ParentNode/sxml:ADMIN_OPTION">
   <xsl:text> WITH ADMIN OPTION</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
