<?xml version="1.0"?>
<!--
NAME
    kusdblkd.xsl
DESCRIPTION
    Convert DBLINK document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    htseng      03/16/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <xsl:import href="kusindxd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: DBLINK - top-level template for tables.
  This template puts out
   - CREATE DATABASE LINK schema.name

******************************************************************** -->
 <xsl:template match="sxml:DB_LINK">
  <xsl:text>  CREATE </xsl:text>
  <xsl:if test="sxml:SHARED">
   <xsl:text>SHARED </xsl:text>
  </xsl:if>
  <xsl:if test="sxml:SCHEMA='PUBLIC'">
   <xsl:text>PUBLIC </xsl:text>
  </xsl:if>
  <xsl:text>DATABASE LINK "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;  </xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:TYPE='CURRENT_USER'">
    <xsl:text> CONNECT TO CURRENT_USER </xsl:text>
   </xsl:when>
   <xsl:when test="sxml:FIXED_USER">
    <xsl:text> CONNECT TO "</xsl:text>
    <xsl:value-of select="sxml:FIXED_USER/sxml:NAME"/>
    <xsl:text>"</xsl:text>
    <xsl:choose>
     <xsl:when test="sxml:FIXED_USER/sxml:VALUE">
      <xsl:text> IDENTIFIED BY VALUES '</xsl:text>
      <xsl:value-of select="sxml:FIXED_USER/sxml:VALUE"/>
      <xsl:text>'</xsl:text>
     </xsl:when>
     <xsl:when test="sxml:FIXED_USER/sxml:PASSWORD">
      <xsl:text> IDENTIFIED BY </xsl:text>
      <xsl:value-of select="sxml:FIXED_USER/sxml:PASSWORD"/>
     </xsl:when>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
  <xsl:if test="sxml:AUTHENTICATING_USER">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text> AUTHENTICATED BY "</xsl:text>
   <xsl:value-of select="sxml:AUTHENTICATING_USER/sxml:NAME"/>
   <xsl:text>"</xsl:text>
   <xsl:choose>
    <xsl:when test="sxml:AUTHENTICATING_USER/sxml:VALUE">
     <xsl:text> IDENTIFIED BY VALUES '</xsl:text>
     <xsl:value-of select="sxml:AUTHENTICATING_USER/sxml:VALUE"/>
     <xsl:text>'</xsl:text>
    </xsl:when>
    <xsl:when test="sxml:AUTHENTICATING_USER/sxml:PASSWORD">
     <xsl:text> IDENTIFIED BY </xsl:text>
     <xsl:value-of select="sxml:AUTHENTICATING_USER/sxml:PASSWORD"/>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="sxml:REMOTE_HOST">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;  </xsl:text>
   </xsl:if>
   <xsl:text> USING '</xsl:text>
   <xsl:value-of select="sxml:REMOTE_HOST"/>
   <xsl:text>' </xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
