<?xml version="1.0"?>
<!--
NAME
    kusctxd.xsl
DESCRIPTION
    Convert CONTEXT document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     08/10/05 - lbarton_mddiff
    htseng      03/21/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: CONTEXT - top-level template for tables.
  This template puts out
   - CREATE CONTEXT name

******************************************************************** -->
 <xsl:template match="sxml:CONTEXT">
  <xsl:text> CREATE OR REPLACE CONTEXT "</xsl:text>
  <xsl:value-of select="sxml:NAME"/>
  <xsl:text>" USING "</xsl:text>
  <xsl:value-of select="sxml:PACKAGE/sxml:SCHEMA"/>
  <xsl:text>"."</xsl:text>
  <xsl:value-of select="sxml:PACKAGE/sxml:NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:if test="sxml:INITIALIZED">
   <xsl:text>INITIALIZED </xsl:text>
   <xsl:value-of select="sxml:INITIALIZED"/>
  </xsl:if>
  <xsl:if test="sxml:ACCESSED">
   <xsl:text>ACCESSED </xsl:text>
   <xsl:value-of select="sxml:ACCESSED"/>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
