<?xml version="1.0"?>
<!-- 
NAME
    kurls.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_rls_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    sdavidso    04/24/09 - bug 8352552: quote identifiers for
                           DBMS_RLS.ADD_GROUPED_POLICY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    clei        10/13/03 - ALL_COLUMNS -> ALL_ROWS
    clei        08/18/03 - add security relevant column option
    clei        11/25/02 - add Index statement type
    clei        09/03/02 - add 10i policy api extension
    dgagne      08/27/02 - comment how commas are inserted for rls
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Template to recreate RLS_POLICY -->
 <xsl:template match="RLS_POLICY_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_RLS.ADD_GROUPED_POLICY</xsl:with-param>
   <xsl:with-param name="ObjectType">RLS_POLICY</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>BEGIN DBMS_RLS.ADD_GROUPED_POLICY('"</xsl:text>
  <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
  <xsl:text>"','"</xsl:text>
  <xsl:value-of select="BASE_OBJ/NAME"/>
  <xsl:text>"','"</xsl:text>
  <xsl:value-of select="GNAME"/>
  <xsl:text>"','"</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>"','"</xsl:text>
  <xsl:value-of select="PFSCHMA"/>
  <xsl:text>"','</xsl:text>
  <xsl:if test="PPNAME">
   <xsl:value-of select="PPNAME"/>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:value-of select="PFNAME"/>
  <xsl:text>','</xsl:text>
  <!--
      The stmt_type uses 5 bits, values 2048, 8, 4, 2, and 1. These represent
      INDEX,DELETE,UPDATE,INSERT AND SELECT. A comma is needed between any
      that are present. Only these 5 low bits are returned in stmt_type.
   -->
  <!-- If value 2048 is set, then add 'INDEX' -->
  <xsl:if test="STMT_TYPE >= 2048">
   <xsl:text>INDEX</xsl:text>
  </xsl:if>
  <!-- If bit 8 is set, first check to see if value 2048 was set. If it was also
       set, then 'INDEX' is already there, add in a comma first
  -->
  <xsl:if test="(STMT_TYPE mod 2048)>=8">
   <!-- need to add in DELETE? -->
   <xsl:if test="STMT_TYPE >=2048">
    <!-- need comma? -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>DELETE</xsl:text>
  </xsl:if>
  <!-- If bit 4 is set, first check to see if 2048 or 8 was set. If either one
       was set, then a keyword is there with no trailing comma, add in a comma
       first.
  -->
  <xsl:if test="(STMT_TYPE mod 8)>=4">
   <!-- need to add in UPDATE? -->
   <xsl:if test="STMT_TYPE >=8">
    <!-- need comma? -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>UPDATE</xsl:text>
  </xsl:if>
  <!-- If bit 2 is set, first check to see if 2048, 8 or 4 was set. If either
       one of them was set, then a keyword is there with no trailing comma, add
       in a comma first.
  -->
  <xsl:if test="(STMT_TYPE mod 4)>=2">
   <!-- need to add in INSERT? -->
   <xsl:if test="STMT_TYPE >=4">
    <!-- bit 8 or bit 4 set -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>INSERT</xsl:text>
  </xsl:if>
  <!-- If bit 1 is set, first check to see if bit 8, 4, or 2 was set. If either
       bit 8, 4, or 2 was set, then a keyword is there with no trailing comma,
       add in a comma first.
  -->
  <xsl:if test="(STMT_TYPE mod 2)=1">
   <!-- need to add in SELECT? -->
   <xsl:if test="STMT_TYPE >=2">
    <!-- bit 8 or bit 4 set -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>SELECT</xsl:text>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="CHECK_OPT = 1">
    <xsl:text>',TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>',FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="ENABLE_FLAG = 1">
    <xsl:text>,TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- static_policy will be ignored and overwritten by policy_type -->
  <xsl:text>,FALSE,</xsl:text>
  <xsl:value-of select="POLICY_TYPE"/>
  <!-- 4000 bytes predicate size limit when long_predicate is false -->
  <xsl:choose>
   <xsl:when test="LONG_PRED = 512">
    <xsl:text>,FALSE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,TRUE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- list of security relevant cols, ok to have empty str:
       will have something like '' (empty list) or '"COL1","COL2"'
  -->
  <xsl:text>,'</xsl:text>
  <xsl:for-each select="REL_COLS/REL_COLS_ITEM">
   <xsl:text>"</xsl:text>
   <xsl:value-of select="SEC_REL_COL"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
   </xsl:if>
  </xsl:for-each>
  <!-- security relevant cols option -->
  <xsl:choose>
   <xsl:when test="REL_COLS_OPT = 4096">
    <xsl:text>',dbms_rls.ALL_ROWS</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>',NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
 <!-- Template to recreate RLS_GROUP -->
 <xsl:template match="RLS_GROUP_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_RLS.CREATE_POLICY_GROUP</xsl:with-param>
   <xsl:with-param name="ObjectType">RLS_GROUP</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>BEGIN DBMS_RLS.CREATE_POLICY_GROUP('</xsl:text>
  <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="BASE_OBJ/NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>')</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
 <!-- Template to recreate RLS_CONTEXT -->
 <xsl:template match="RLS_CONTEXT_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_RLS.ADD_POLICY_CONTEXT</xsl:with-param>
   <xsl:with-param name="ObjectType">RLS_CONTEXT</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>BEGIN DBMS_RLS.ADD_POLICY_CONTEXT('</xsl:text>
  <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="BASE_OBJ/NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="ATTR"/>
  <xsl:text>')</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
