<?xml version="1.0"?>
<!-- 
NAME
    kuqueues.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_queues_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng   	03/04/02 - set up default value for EXPORT
    htseng  	01/11/02 - remove an extra '.'.
    htseng 	10/22/01 - change EXECUTE to BEGIN/END.
    htseng 	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	08/07/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="QUEUES_T">
  <xsl:if test="$EXPORT=0">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_AQADM.CREATE_QUEUE</xsl:with-param>
    <xsl:with-param name="ObjectType">AQ_QUEUE</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
    <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
    <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
   </xsl:call-template>
   <xsl:text> BEGIN DBMS_AQADM.CREATE_QUEUE(</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Queue_name          => '</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/OWNER_NAME"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="SCHEMA_OBJ/NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Queue_table         => '</xsl:text>
   <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
   <xsl:text>.</xsl:text>
   <xsl:value-of select="BASE_OBJ/NAME"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:text>Queue_type          =>  </xsl:text>
   <xsl:value-of select="USAGE"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;     </xsl:text>
   </xsl:if>
   <xsl:if test="USAGE!=1">
    <!-- if not exception queue -->
    <xsl:text>Max_retries         =>  </xsl:text>
    <xsl:value-of select="MAX_RETRIES"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>Retry_delay         =>  </xsl:text>
    <xsl:value-of select="RETRY_DELAY"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:if test="RETENTION!=0">
    <xsl:text>Retention_time      =>  </xsl:text>
    <xsl:value-of select="RETENTION"/>
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
   </xsl:if>
   <xsl:text>dependency_tracking =>  </xsl:text>
   <xsl:choose>
    <xsl:when test="PROPERTIES=1">
     <xsl:text>TRUE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>FALSE</xsl:text>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:if test="string-length(QUEUE_COMMENT)!=0">
    <xsl:text>,</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;     </xsl:text>
    </xsl:if>
    <xsl:text>comment             => '</xsl:text>
    <xsl:value-of select="QUEUE_COMMENT"/>
    <xsl:text>'</xsl:text>
   </xsl:if>
   <xsl:text>)</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text> END</xsl:text>
   <xsl:if test="$SQLTERMINATOR=1">
    <xsl:text>;</xsl:text>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=0 -->
  <xsl:if test="$EXPORT=1">
   <xsl:call-template name="DoParse">
    <xsl:with-param name="Verb">DBMS_AQ_IMP_INTERNAL.IMPORT_QUEUE</xsl:with-param>
    <xsl:with-param name="ObjectType">AQ_QUEUE</xsl:with-param>
    <xsl:with-param name="SchemaNode" select="SCHEMA_OBJ/OWNER_NAME"/>
    <xsl:with-param name="NameNode" select="SCHEMA_OBJ/NAME"/>
    <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
    <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
    <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
   </xsl:call-template>
   <xsl:if test="TFLAGS mod 16 >=8">
    <xsl:text> BEGIN </xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text>   SYS.DBMS_AQ_IMP_INTERNAL.IMPORT_QUEUE(</xsl:text>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa;</xsl:text>
    </xsl:if>
    <xsl:text>     HEXTORAW('</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/OID"/>
    <xsl:text>'), '</xsl:text>
    <xsl:value-of select="BASE_OBJ/NAME"/>
    <xsl:text>','</xsl:text>
    <xsl:value-of select="SCHEMA_OBJ/NAME"/>
    <xsl:text>',</xsl:text>
    <xsl:value-of select="USAGE"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="MAX_RETRIES"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="RETRY_DELAY"/>
    <xsl:text>,</xsl:text>
    <xsl:value-of select="PROPERTIES"/>
    <!-- xsl:value-of select="ENQUEUE_ENABLED"/ -->
    <xsl:text>,</xsl:text>
    <xsl:value-of select="RETENTION"/>
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="QUEUE_COMMENT"/>
    <xsl:text>')</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
    <xsl:if test="$PRETTY=1">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
    <xsl:text> END</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:if>
  <!-- $EXPORT=1 -->
 </xsl:template>
</xsl:stylesheet>
