<?xml version="1.0"?>
<!-- 
NAME
    kuprocac.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_post_table_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    dgagne      08/27/02 - add ; at end of command, use / as sqlterminator
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - ade more parse params
    htseng      07/16/02 - htseng_api_table_action
    htseng	06/25/02 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="POST_TABLE_T | PRE_TABLE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">SYS.DBMS</xsl:with-param>
   <xsl:with-param name="ObjectType">
    <xsl:choose>
     <xsl:when test="local-name(.)='PRE_TABLE_T'">PRE_TABLE_ACTION</xsl:when>
     <xsl:when test="local-name(.)='POST_TABLE_T'">POST_TABLE_ACTION</xsl:when>
     <xsl:otherwise>**NOT FOUND** </xsl:otherwise>
    </xsl:choose>
   </xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:apply-templates select="ACTION_STR"/>
 </xsl:template>
 <xsl:template match="ACTION_STR">
  <xsl:for-each select="ACTION_STR_ITEM">
   <xsl:if test="position()=1">
    <xsl:text>BEGIN </xsl:text>
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:value-of select="TEXT"/>
   <xsl:text>&#xa; </xsl:text>
   <xsl:if test="position()=last()">
    <xsl:text>END; </xsl:text>
    <xsl:call-template name="DoTerminator">
     <xsl:with-param name="Text"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
