<?xml version="1.0"?>
<!-- 
NAME
    kudblink.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_dblink_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    lbarton     01/18/07 - bug 5584945: restrict password access to
                           EXP_FULL_DATABASE
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    rvissapr    05/23/04 - add dblink encoding 
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts: -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <!-- Template to recreate DBLINKS -->
 <xsl:template match="DBLINK_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">DB_LINK</xsl:with-param>
   <xsl:with-param name="SchemaNode" select="OWNER_NAME"/>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <!-- Determine if SHARED or not -->
  <xsl:if test="FLAG = 1">
   <xsl:text>SHARED </xsl:text>
  </xsl:if>
  <!-- Determine if PUBLIC or not -->
  <xsl:if test="OWNER_NUM = 1">
   <xsl:text>PUBLIC </xsl:text>
  </xsl:if>
  <xsl:text>DATABASE LINK "</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>"</xsl:text>
  <xsl:if test="USERID">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:choose>
    <xsl:when test="USERID = 'CURRENT_USER'">
     <xsl:text>  CONNECT TO CURRENT_USER</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text>  CONNECT TO "</xsl:text>
     <xsl:value-of select="USERID"/>
     <xsl:choose>
      <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0 and PASSWORD">
       <xsl:text>" IDENTIFIED BY "</xsl:text>
       <xsl:value-of select="PASSWORD"/>
       <xsl:text>"</xsl:text>
      </xsl:when>
      <xsl:when test="PASSWORDX">
       <xsl:text>" IDENTIFIED BY VALUES '</xsl:text>
       <xsl:value-of select="PASSWORDX"/>
       <xsl:text>'</xsl:text>
      </xsl:when>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="AUTHUSR">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text>  AUTHENTICATED BY "</xsl:text>
   <xsl:value-of select="AUTHUSR"/>
   <xsl:choose>
    <xsl:when test="VERS_MAJOR=1 and VERS_MINOR=0 and AUTHPWD">
     <xsl:text>" IDENTIFIED BY "</xsl:text>
     <xsl:value-of select="AUTHPWD"/>
     <xsl:text>"</xsl:text>
    </xsl:when>
    <xsl:when test="AUTHPWDX">
     <xsl:text>" IDENTIFIED BY VALUES '</xsl:text>
     <xsl:value-of select="AUTHPWDX"/>
     <xsl:text>'</xsl:text>
    </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="HOST">
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa; </xsl:text>
   </xsl:if>
   <xsl:text>  USING '</xsl:text>
   <xsl:value-of select="HOST"/>
   <xsl:text>'</xsl:text>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
