<?xml version="1.0"?>
<!-- 
NAME
    kucoment.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_comment_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    mjangir     11/20/07 - bug 5607386: support emit schema option
    wesmith     02/17/06 - bug 4898580: comment on MV only if colno is null
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      05/13/04 - bug 3601775: operator and indextype support 
    lbarton     11/05/02 - add materialized view syntax
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/19/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="COMMENT_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">COMMENT</xsl:with-param>
   <xsl:with-param name="ObjectType">COMMENT</xsl:with-param>
  </xsl:call-template>
  <xsl:text> COMMENT ON</xsl:text>
  <xsl:choose>
   <xsl:when test="(PROPERTY mod 134217728)>=67108864 and 
                   string-length(COLNO) =0">
    <xsl:text> MATERIALIZED VIEW </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>
   <xsl:when test="BASE_OBJ/TYPE_NAME='INDEXTYPE'">
    <xsl:text> INDEXTYPE </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>
   <xsl:when test="BASE_OBJ/TYPE_NAME='OPERATOR'">
    <xsl:text> OPERATOR </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>
   <xsl:when test="string-length(COLNO) =0">
    <xsl:text> TABLE </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> COLUMN </xsl:text>
    <xsl:if test="$EMIT_SCHEMA=1">
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Object" select="BASE_OBJ/OWNER_NAME"/>
     </xsl:call-template>
     <xsl:text>.</xsl:text>
    </xsl:if> 
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="BASE_OBJ/NAME"/>
    </xsl:call-template>
    <xsl:text>.</xsl:text>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="COLNAME"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text> IS '</xsl:text>
  <xsl:value-of select="CMNT"/>
  <xsl:text>'</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
