<?xml version="1.0"?>
<!-- Copyright (c) 2001, 2009, Oracle and/or its affiliates. 
All rights reserved. -->
<!-- 
NAME
    kuaudit.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_audit_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    lbarton     03/20/09 - lrg 3751805: need nl in dummy audit
    lbarton     11/10/08 - ssonawan_bug-7295457: generate null pl/sql
                            if property=1
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	06/05/03 - bug 2992644 - need call DoParse for each AUDIT 
    htseng	08/02/02 - add grantee parse param
    htseng	07/25/02 - add BaseNameNode
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	06/26/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="AUDIT_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">AUDIT</xsl:with-param>
   <xsl:with-param name="ObjectType">AUDIT</xsl:with-param>
   <xsl:with-param name="NameNode" select="USER_NAME"/>
   <xsl:with-param name="Grantee" select="USER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="AUDIT_OPTION"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="PROPERTY=1">
    <!-- "Property=1 means the audit option (or system privilege) cannot
        be audited using regular AUDIT / NO AUDIT sql statements.
        It has to be audited using other means,
        like dedicated pl/sql api for instance."
        lrg 3751805: Replace 'Rem' with double-dash -->
    <xsl:text>-- 
-- </xsl:text>
    <xsl:value-of select="AUDIT_OPTION"/>
    <xsl:text>
--
BEGIN  NULL; END;</xsl:text>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>
/</xsl:text>
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:if test="SUCCESS!=0">
     <xsl:text> AUDIT </xsl:text>
     <xsl:value-of select="AUDIT_OPTION"/>
     <xsl:if test="USER_NUM!=1">
      <xsl:text> BY </xsl:text>
      <xsl:value-of select="USER_NAME"/>
     </xsl:if>
     <xsl:if test="SUCCESS=1">
      <xsl:text> BY SESSION</xsl:text>
     </xsl:if>
     <xsl:if test="SUCCESS=2">
      <xsl:text> BY ACCESS</xsl:text>
     </xsl:if>
     <xsl:if test="SUCCESS!=FAILURE">
      <xsl:text> WHENEVER SUCCESSFUL </xsl:text>
     </xsl:if>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
      <!-- Terminate the SQL statement -->
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:if>
    <xsl:if test="FAILURE!=0 and SUCCESS!=FAILURE">
     <xsl:text> AUDIT </xsl:text>
     <xsl:value-of select="AUDIT_OPTION"/>
     <xsl:if test="USER_NUM!=1">
      <xsl:text> BY </xsl:text>
      <xsl:value-of select="USER_NAME"/>
     </xsl:if>
     <xsl:if test="FAILURE=1">
      <xsl:text> BY SESSION  WHENEVER NOT SUCCESSFUL </xsl:text>
     </xsl:if>
     <xsl:if test="FAILURE=2">
      <xsl:text> BY ACCESS  WHENEVER NOT SUCCESSFUL </xsl:text>
     </xsl:if>
     <xsl:if test="$SQLTERMINATOR=1">
      <xsl:text>;</xsl:text>
      <!-- Terminate the SQL statement -->
     </xsl:if>
     <xsl:if test="$PRETTY=1">
      <xsl:text>&#xa;</xsl:text>
     </xsl:if>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
