<?xml version="1.0"?>
<!--
NAME
    kualter.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_constraint_t ADTs
NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    sdavidso    03/12/07 - bug 5900676: partitioning ref contstraint exists
    sdavidso    01/30/07 - fix constraint name parse item
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    lbarton     04/14/04 - Bug 3561663: fetch NOT NULL and check constr
    emagrath    06/06/03 - Correct index info for constraints
    htseng      01/07/03 - fix bug 2736436 
    lbarton     10/11/02 - new parse item: SYSTEM_GENERATED
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     08/02/02 - transportable export
    lbarton     06/21/02 - implement sqlterminator
    lbarton     06/13/02 - define EXPORT param
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      07/17/01 - creation for alter table/view add constraint
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kucolumn.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <xsl:import href="kuprtobj.xsl"/>
 <xsl:import href="kuidxwrk.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SIZE_BYTE_KEYWORD">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="PCTSPACE">100</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_SYSTEM_GENERATED">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:template match="CONSTRAINT_T |
                      REF_CONSTRAINT_T">
  <xsl:if test="$PRS_SYSTEM_GENERATED=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ASYSTEM_GENERATED</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>E</xsl:text>
   <xsl:if test="(FLAGS mod 16)>=8">Y</xsl:if>
   <xsl:value-of select="$PRS_DELIM"/>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">CONSTRAINT</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="not(FLAGS) or ((FLAGS mod 2048) &lt; 512) or EXPORT=0">
    <xsl:text>ALTER </xsl:text>
    <xsl:value-of select="BASE_OBJ/TYPE_NAME"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="BASE_OBJ"/>
    <xsl:for-each select="CON0">
     <xsl:text>MODIFY (</xsl:text>
     <xsl:call-template name="ColNameOrAttr">
      <xsl:with-param name="ColItem" select="../COL"/>
     </xsl:call-template>
     <xsl:call-template name="DoConstraint">
      <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
     </xsl:call-template>
     <xsl:text>)</xsl:text>
    </xsl:for-each>
    <xsl:for-each select="CON1 | CON2">
     <xsl:text>ADD</xsl:text>
     <xsl:call-template name="DoConstraint">
      <xsl:with-param name="TAB_CONSTRAINT">1</xsl:with-param>
     </xsl:call-template>
    </xsl:for-each>
    <xsl:if test="$SQLTERMINATOR=1">
     <xsl:text>;</xsl:text>
     <!-- Terminate the SQL statement -->
    </xsl:if>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>begin NULL; end;</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
