<?xml version="1.0" ?>
<!-- 
NAME
    knfcf2.xsl - replication Flavor Column Filtering script #2

DESCRIPTION
    XSLT stylesheet for filtering out columns that aren't in
    a given list from a table or index. This script is called after
    replfcf1.xsl to remove any constraints containing the tag
    <DELETE_FLAVOR_COLUMNS>.

NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    elu         05/01/01 - add support for partitions
    gclaborn    11/06/00 - Add no modify comment; change name
    elu 	08/14/00 - Created.
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- copy everything from the input file -->
<xsl:template match="@*|node()">
 <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<!-- fix up segment attribute values for partitioned tables, if the column -->
<!-- the partition is on is not included in the flavor -->

<xsl:template match="TABLE_T/PCT_FREE">
 <xsl:choose>
  <xsl:when test = "../PART_OBJ//DELETE_FLAVOR_COLUMN">
   <PCT_FREE>
   <xsl:value-of select="../PART_OBJ/PARTOBJ/DEFPCTFREE"/>
   </PCT_FREE>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:otherwise> 
 </xsl:choose>
</xsl:template>

<xsl:template match="TABLE_T/PCT_USED">
 <xsl:choose>
  <xsl:when test = "../PART_OBJ//DELETE_FLAVOR_COLUMN">
   <PCT_USED>
   <xsl:value-of select="../PART_OBJ/PARTOBJ/DEFPCTUSED"/>
   </PCT_USED>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:otherwise> 
 </xsl:choose>
</xsl:template>

<xsl:template match="TABLE_T/INITRANS">
 <xsl:choose>
  <xsl:when test = "../PART_OBJ//DELETE_FLAVOR_COLUMN">
   <INITRANS>
   <xsl:value-of select="../PART_OBJ/PARTOBJ/DEFINITRANS"/>
   </INITRANS>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:otherwise> 
 </xsl:choose>
</xsl:template>

<xsl:template match="TABLE_T/MAXTRANS">
 <xsl:choose>
  <xsl:when test = "../PART_OBJ//DELETE_FLAVOR_COLUMN">
   <MAXTRANS>
   <xsl:value-of select="../PART_OBJ/PARTOBJ/DEFMAXTRANS"/>
   </MAXTRANS>
  </xsl:when>
  <xsl:otherwise>
   <xsl:apply-templates select="@*|node()"/>
  </xsl:otherwise> 
 </xsl:choose>
</xsl:template>


<!-- filter out any partitions containing a column not in the list -->

<xsl:template match="TABLE_T/PART_OBJ
                            [PARTCOLS/PARTCOLS_ITEM/COL/DELETE_FLAVOR_COLUMN]">
</xsl:template>

<xsl:template match="TABLE_T/PART_OBJ
                      [SUBPARTCOLS/SUBPARTCOLS_ITEM/COL/DELETE_FLAVOR_COLUMN]">
</xsl:template>


<!-- filter out any constraints containing a column not in the list -->
<!-- refer to constraint.xsl for more information on constraints -->

<xsl:template match="TABLE_T/CON1_LIST/CON1_LIST_ITEM/IND
                           [COL_LIST/COL_LIST_ITEM/COL/DELETE_FLAVOR_COLUMN]"/>

<xsl:template match="TABLE_T/CON1_LIST/CON1_LIST_ITEM
                           [COL_LIST/COL_LIST_ITEM/COL/DELETE_FLAVOR_COLUMN]"/>

<xsl:template match="TABLE_T/CON2_LIST/CON2_LIST_ITEM
                   [SRC_COL_LIST/SRC_COL_LIST_ITEM/COL/DELETE_FLAVOR_COLUMN]"/>

</xsl:stylesheet>
