<?xml version="1.0" ?>
<!--
NAME
    cmkuclus.xsl
DESCRIPTION
    Convert mdapi CLUSTER_T document to CLUSTER document (editable XML)

MODIFIED    MM/DD/YY
    pkaliren    05/15/08 - Merge 11GC functionality
    lhan        08/22/04 - lhan_cm_0820
    lhan        08/20/04 - creation
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Top level imports -->
<xsl:import href="cmkucommon.xsl"/>
<xsl:import href="cmkucolumn.xsl"/>
<xsl:import href="cmkustorage.xsl"/>

<!-- Top level template for all objects -->
<xsl:template match="/">
 <xsl:apply-templates/>
</xsl:template>

<xsl:template match="RESULTSET | ROWSET">
  <xsl:for-each select="ROW">
    <xsl:apply-templates/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="CLUSTER_T">
<CLUSTER>

  <xsl:apply-templates select="SCHEMA_OBJ"/>

  <COL_LIST>
   <!-- exclude hidden columns                            - prop bit 0x000020
        (but do include hidden snapshot base table column - prop bit 0x100000
         and do include RLS hidden column                 - prop bit 0x800000)
     -->
     <xsl:for-each select="COL_LIST/COL_LIST_ITEM[(PROPERTY mod 64)&lt;32
                           or (PROPERTY mod 2097152)>=1048576
                           or (PROPERTY mod 8388608)>=4194304]">
       <COL_LIST_ITEM NAME="{NAME}"> 
        <NAME>
         <xsl:value-of select="NAME"/>
        </NAME>
        <xsl:apply-templates select="TYPE_NUM"/>
       </COL_LIST_ITEM>
     </xsl:for-each>
  </COL_LIST>

  <xsl:if test="SIZE_T >0">
   <xsl:element name="SIZE">
    <xsl:value-of select="SIZE_T"/>
   </xsl:element> 
  </xsl:if>

  <xsl:call-template name="DoTablespace">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:call-template name="DoPCT">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:call-template name="DoStorage">
    <xsl:with-param name="ParentNode" select="./STORAGE"/>
   <xsl:with-param name="BlkSize" select="BLOCKSIZE"/>
  </xsl:call-template>


  <xsl:if test="FLAGS mod 131072>=65536">    <!-- Single table 0x010000--> 
   <xsl:element name="SINGLE_TABLE"/>
  </xsl:if>

 <xsl:element name="HASH">
  <xsl:choose>
  <xsl:when test="FUNCTION=0 and HASHKEYS !=0">
   <xsl:value-of  select="COL_LIST/COL_LIST_ITEM/NAME"/>    
  </xsl:when>

  <xsl:when test="FUNCTION=2 and string-length(FUNCLEN)> 0">
    <xsl:choose>
     <xsl:when test="FUNCLEN>4000">
      <xsl:call-template name="Trim_string">
       <xsl:with-param name="String" select="FUNC_VCNT"/>
      </xsl:call-template> 
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="Trim_string">
       <xsl:with-param name="String" select="FUNCTXT"/>
      </xsl:call-template> 
     </xsl:otherwise>
    </xsl:choose>   	
  </xsl:when>
  </xsl:choose>
 </xsl:element> 

  <xsl:if test="HASHKEYS!=0">
   <xsl:element name="HASHKEYS">
    <xsl:value-of select="HASHKEYS"/>
   </xsl:element> 
  </xsl:if>

  <xsl:if test="FLAGS mod 16777216>=8388608">    <!-- ROWDEF 0x0800000 -->
   <xsl:element name="ROWDEPENDENCIES"/>
  </xsl:if>

  <xsl:call-template name="DoParallel">
    <xsl:with-param name="FlagsParent" select="."/>
  </xsl:call-template> 

</CLUSTER>
</xsl:template>


</xsl:stylesheet>


