  -- apply result for test
  v_apply_data := generateUniqueName;
  execSQL('CREATE TABLE '||v_apply_data||' <TABLE_PARALLEL_HINT> AS SELECT <PARALLEL_HINT> "'||v_caseid||'", PREDICTION(<MODEL_NAME_PARAM> USING *) pred FROM '||v_test_data);
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_apply_data, 'TABLE', NULL, 'Apply Data');

  -- test metric
  v_test_metric := generateUniqueName;
  execSQL('CREATE TABLE '||v_test_metric||' (METRIC_NAME VARCHAR2(30), METRIC_VARCHAR_VALUE VARCHAR2(128), METRIC_NUM_VALUE NUMBER)');
  recordOutput('<WORKFLOW_NODE_ID>', '<WORKFLOW_NODE_NAME>', '<WORKFLOW_NODE_TYPE>', '<BUILD_MODEL_ID>', '<MODEL_NAME_PARAM>', '<BUILD_MODEL_TYPE>', v_test_metric, 'TABLE', NULL, 'Test Metric');

  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', ''<MODEL_NAME_PARAM>'')');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', ''REGRESSION'')');
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''TARGET_ATTRIBUTE'', '''||v_target||''')');

  -- 1. Root Mean Square Error - Sqrt(Mean((x - x')^2))
  v_sql := '
  SELECT SQRT(AVG(POWER((A.pred - (B."'||v_target||'")), 2))) rmse
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
   WHERE A."'||v_caseid||'" = B."'||v_caseid||'"';
  EXECUTE IMMEDIATE v_sql INTO v_rms_error;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_RMS_ERROR'', '||NVL(v_rms_error, 0)||')');

  -- 2. Mean Absolute Error - Mean(|(x - x')|)
  v_sql := '
  SELECT AVG(ABS(A.pred - B."'||v_target||'")) mae
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
    WHERE A."'||v_caseid||'" = B."'||v_caseid||'"';
  EXECUTE IMMEDIATE v_sql INTO v_absolute_error;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ABSOLUTE_ERROR'', '||NVL(v_absolute_error, 0)||')');

  -- 3. Mean Actual Value
  v_sql := '
  SELECT AVG("'||v_target||'") as mean_actual_value
    FROM '||v_test_data;
  EXECUTE IMMEDIATE v_sql INTO v_mean_actual;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ACTUAL_VALUE'', '||NVL(v_mean_actual, 0)||')');

  -- 4. Mean Predicted Value
  v_sql := '
  SELECT
    AVG(PREDICTION(<MODEL_NAME_PARAM> using *)) as mean_predicted_value
  FROM '||v_test_data;
  EXECUTE IMMEDIATE v_sql INTO v_mean_predicted;
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_PREDICATED_VALUE'', '||NVL(v_mean_predicted, 0)||')');

  -- Overall predictive Confidence = 1 - ((Error of Predict)/(Error of naive model))
  v_sql := '
  WITH
  a as
  (SELECT SQRT(AVG(POWER((A.pred - (B."'||v_target||'")), 2))) rmse
    FROM '||v_apply_data||' A,
         '||v_test_data||' B
   WHERE A."'||v_caseid||'" = B."'||v_caseid||'")
  ,
  b as
  (SELECT SQRT(count(*)/(count(*)-1) * variance("'||v_target||'")) ne
    FROM '||v_test_data||')
  SELECT (1 - a.rmse / GREATEST(0.0001, b.ne)) * 100 FROM a, b';
  EXECUTE IMMEDIATE v_sql INTO v_predictive_conf;
  v_predictive_conf := GREATEST(0, v_predictive_conf); -- cap the value >= 0
  execSQL('INSERT INTO '||v_test_metric||' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''PREDICTIVE_CONFIDENCE'', '||NVL(v_predictive_conf, 0)||')');

<RESIDUAL_PLOT>