
EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('<WORKFLOW_NODE_NAME> node started: ' || SYSTIMESTAMP);
EXECUTE dbms_output.put_line('');

DECLARE
  v_data_view_name          VARCHAR2(30);
  v_explore_sampled_data    VARCHAR2(30);
  v_histogram_sampled_data  VARCHAR2(30);
  v_sql             CLOB;
  v_user_session    VARCHAR2(30) := SYS_CONTEXT ('USERENV', 'SESSION_USER');
  v_drop            VARCHAR2(30) := '&DROP_EXISTING_OBJECTS';

  TYPE  
    LSTMT_REC_TYPE                IS RECORD (
      lstmt                          dbms_sql.VARCHAR2A,
      lb                             BINARY_INTEGER DEFAULT 1,
      ub                             BINARY_INTEGER DEFAULT 0);

  v_columns         ODMR_OBJECT_NAMES := ODMR_OBJECT_NAMES();
  v_attributes      ODMR_OBJECT_NAMES := ODMR_OBJECT_NAMES();
  v_aliases         ODMR_OBJECT_NAMES := ODMR_OBJECT_NAMES();
  v_attrDataTypes   ODMR_OBJECT_NAMES := ODMR_OBJECT_NAMES();

  FUNCTION generateUniqueName RETURN VARCHAR2 IS
    v_uniqueName  VARCHAR2(30);
  BEGIN
    SELECT 'ODMR$'||TO_CHAR(SYSTIMESTAMP,'HH24_MI_SS_FF')||dbms_random.string(NULL, 7) INTO v_uniqueName FROM dual;
    RETURN v_uniqueName;
  END;

  FUNCTION getInputSource(p_nodeId VARCHAR2) RETURN VARCHAR2 IS
    v_output  VARCHAR2(30);
  BEGIN
    SELECT OUTPUT_NAME INTO v_output FROM "&WORKFLOW_OUTPUT" WHERE NODE_ID = p_nodeId AND COMMENTS = 'Output Data';
    RETURN v_output;
  END;

  PROCEDURE recordOutput(p_NODE_ID VARCHAR2, p_NODE_NAME VARCHAR2, p_NODE_TYPE VARCHAR2, 
                         p_MODEL_ID VARCHAR2, p_MODEL_NAME VARCHAR2, p_MODEL_TYPE VARCHAR2, 
                         p_OUTPUT_NAME VARCHAR2, p_OUTPUT_TYPE VARCHAR2, p_ADDITIONAL_INFO VARCHAR2, p_COMMENTS VARCHAR2) IS
  BEGIN
    INSERT INTO "&WORKFLOW_OUTPUT" VALUES (p_NODE_ID, p_NODE_NAME, p_NODE_TYPE, p_MODEL_ID, REPLACE(REPLACE(p_MODEL_NAME,'"',''), (v_user_session||'.'), ''), p_MODEL_TYPE, p_OUTPUT_NAME, p_OUTPUT_TYPE, p_ADDITIONAL_INFO, SYSTIMESTAMP, p_COMMENTS);
    COMMIT;
  END;

  PROCEDURE drop_view (view_name IN VARCHAR2) IS
    v_stmt            VARCHAR2(4000);
  BEGIN
    v_stmt := 'DROP VIEW '|| SYS.DBMS_ASSERT.ENQUOTE_NAME(view_name,FALSE);
    EXECUTE  IMMEDIATE v_stmt;
  EXCEPTION WHEN OTHERS THEN
   NULL;
  END;
  
  FUNCTION ls_clob(p_lstmt IN OUT NOCOPY LSTMT_REC_TYPE)
  RETURN CLOB
  IS
    v_clob   CLOB;
  BEGIN
    FOR i IN p_lstmt.lb..p_lstmt.ub LOOP
      v_clob := v_clob || p_lstmt.lstmt(i);
    END LOOP;
    RETURN v_clob;
  END;

  PROCEDURE ls_append( p_lstmt IN OUT NOCOPY LSTMT_REC_TYPE,
                       p_txt VARCHAR2) IS
  BEGIN
    p_lstmt.ub := p_lstmt.ub + 1;
    p_lstmt.lstmt(p_lstmt.ub) := p_txt;
  END;

  PROCEDURE execSQL(p_sql CLOB) IS
    curid         INTEGER;
    ignoreid      INTEGER;    
  BEGIN
    curid := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(curid, p_sql, DBMS_SQL.NATIVE);
    ignoreid := DBMS_SQL.EXECUTE(curid);
    DBMS_SQL.CLOSE_CURSOR(curid);
  EXCEPTION WHEN OTHERS THEN
    IF DBMS_SQL.IS_OPEN(curid) THEN
      DBMS_SQL.CLOSE_CURSOR(curid);
    END IF;
    RAISE;
  END;

  FUNCTION formatErrorStack(
    p_node_name IN VARCHAR2,
    p_sqlerr        IN VARCHAR2,
    p_error_stack   IN VARCHAR2 ) RETURN VARCHAR2
  IS
  BEGIN
    RETURN SUBSTR('Error in ' || p_node_name || ': ' || CHR(13) || CHR(10) || p_sqlerr || 
                   CHR(13) || CHR(10) || p_error_stack, 1, 4000);
  END;

BEGIN
  v_data_view_name := generateUniqueName;

  IF (v_drop = 'TRUE') THEN -- delete existing table? 
    BEGIN 
      v_sql := '<PURGE_SQL_EXPRESSION>'; 
      execSQL(v_sql); 
    EXCEPTION WHEN OTHERS THEN 
      NULL; 
    END; 
    
  END IF; 
  
<CREATE_TEMP_INPUT_VIEW_SQL_EXPRESSION>
<DROP_TEMP_INPUT_VIEW_SQL_EXPRESSION>
<SAMPLE_ALL_DATA_EXPRESSION>
<DROP_SAMPLE_SQL_EXPRESSION>
<SERVER_CALL_SQL_EXPRESSION>
<HISTOGRAM_SAMPLE_SQL_EXPRESSION>
<DROP_HISTOGRAM_SAMPLE_SQL_EXPRESSION>
<HISTOGRAM_API_SQL_EXPRESSION>
<TAG_DROP_EXPLORE_DATA_TABLE>

EXCEPTION WHEN OTHERS THEN
  RAISE_APPLICATION_ERROR(-20999, formatErrorStack('<WORKFLOW_NODE_NAME>', SQLERRM, DBMS_UTILITY.FORMAT_ERROR_BACKTRACE()));
END;
/
EXECUTE dbms_output.put_line('');
EXECUTE dbms_output.put_line('<WORKFLOW_NODE_NAME> node completed: ' || SYSTIMESTAMP);
EXECUTE dbms_output.put_line('');
