"procedureCall": [procedureCall) function | [procedureCall) procedure_call;

"queryBlock": [queryBlock) query_block;

"main QB" : \/queryBlock("queryBlock");  -- auxiliary predicate (which is not listed among recognized symbols)
"nested QB" : "queryBlock" - "main QB";  -- ditto

-- When extracting columns the main challenge is not to look inside nested subqueries, for example 
--
--SELECT
--  DEPARTMENT_ID,
-- (select ignore from T) as scalarSubquery
-- FROM EMP_DETAILS_VIEW
--
-- "columnSelect" lists [DEPARTMENT_ID, COUNT(*), (select ignore from T1 where 1=1)] but not "ignore"
-- Hence query in three steps
-- 1. "all columns" 
-- 2. "columns in nested QB"
-- 3. subtract one from the other (projected to the column of interest, first)
"all columns": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause < columnSelect
     & "main QB".queryBlock = select_clause^
;

"columns in nested QB": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause < columnSelect
     & "nested QB".queryBlock = select_clause^
;

"columnSelect": ([columnSelect]|"all columns") - ([columnSelect]|"columns in nested QB")
;

"all tables": [tableFrom) table_reference
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "main QB".queryBlock = from_clause^
;

"tables in nested QB": [tableFrom) table_reference
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "nested QB".queryBlock = from_clause^
;

"tableFrom":  ([tableFrom]|"all tables") - ([tableFrom]|"tables in nested QB")
;

"all predicates": predicateWhere^ = where_clause
      & [where_clause) where_clause
      & [predicateWhere) condition
      & "main QB".queryBlock = where_clause^
;

"predicates in nested QB": predicateWhere^ = where_clause
      & [where_clause) where_clause
      & [predicateWhere) condition
      & "nested QB".queryBlock = where_clause^
;


"predicateWhere": ([predicateWhere]|"all predicates") - ([predicateWhere]|"predicates in nested QB")
;

"expr in orderBy": [order_by_clause) order_by_clause 
	  & order_by_clause < orderBy
	  &  [orderBy) expr
;
"orderBy": \/orderBy("expr in orderBy")  -- e.g. order by 1+2 --<-- don't want returning nested 1 and 2 
;

