/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.view;

import javax.ide.spi.ProviderNotFoundException;
import javax.ide.Service;

/**
 * The GUIUtilities provide access to the {@link IDEDialogs}, a
 * {@link WaitCursor} and a {@link ProgressMonitor} objects that extension
 * writers use for * time consuming tasks.<p>
 *
 * @see javax.ide.Service
 */
public abstract class GUIUtilities
  extends Service
{

  /**
   * Get the {@link IDEDialogs} that can be used to show standard IDE
   * dialogs.
   * @return the {@link IDEDialogs}.
   */
  public abstract IDEDialogs getIDEDialogs();

  /**
   * Get a wait cursor indicating that a time consuming operation is
   * in progress.
   *
   * @return a {@link WaitCursor}.
   */
  public abstract WaitCursor getWaitCursor();

  /**
   * Get a progress monitor to show that a time consuming operation is
   * in progress.
   *
   * @return a {@link ProgressMonitor}.
   */
  public abstract ProgressMonitor getProgressMonitor();

  /**
   * Get the GUIUtilities service for this IDE.
   *
   * @return gui utilities for this ide.
   */
  public static GUIUtilities getGUIUtilities()
  {
    try
    {
      return (GUIUtilities) getService(GUIUtilities.class);
    }
    catch (ProviderNotFoundException lnfe)
    {
      lnfe.printStackTrace();
      throw new IllegalStateException("No gui utilities");
    }
  }

}

