/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.spi;

import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;

/**
 * IDE listener information gathered from processing an extension manifest.
 */
public final class IDEListenerHook extends ExtensionHook
{
  public static final ElementName ELEMENT = new ElementName( 
    MANIFEST_XMLNS, "ide-listener-hook" );
  private static final ElementName IDE_LISTENERS = new ElementName(
    MANIFEST_XMLNS, "ide-listeners" );
  private static final ElementName IDE_LISTENER = new ElementName(
    MANIFEST_XMLNS, "ide-listener" );

  private ElementVisitor _listenersVisitor = new ListenersVisitor();
  private ElementVisitor _listenerVisitor = new ListenerVisitor();

  private Collection _listeners = new ArrayList();

  /**
   * Get the list of {@link javax.ide.IDEListener}s {@link MetaClass}es 
   * declared in the extension manifest.
   *
   * @return An array of ide listeners {@link MetaClass}es. If none available
   * return a zero length array.
   */
  public Collection getListeners()
  {
    return _listeners;
  }

  public void start( ElementStartContext context )
  {
    context.registerChildVisitor( IDE_LISTENERS, _listenersVisitor );
  }  
  
  private class ListenersVisitor extends ElementVisitor
  {
    public void start( ElementStartContext context )
    {
      context.registerChildVisitor( IDE_LISTENER, _listenerVisitor );
    }
  }
  
  private class ListenerVisitor extends MetaClassVisitor
  {
    public void metaClass( ElementContext context, MetaClass mc )
    {
      _listeners.add( mc );
    }
  }
}
