/*
 * @(#)VariableT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for field variables (and enum constant variables),
 * local variables, and parameters. <p/>
 *
 * @author Andy Yu
 * */
public interface VariableT
  extends Tree, HasModifiersT, HasNameT
{
  // ----------------------------------------------------------------------

  static final VariableT[] EMPTY_ARRAY = new VariableT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * Gets the initializer, null if none.
   *
   * @return This variable's initializer. Null if none was declared.
   */
  public ExpressionT getInitializer();

  /**
   * Unlinks the current initializer, if any, and links the input
   * element.
   *
   * @throws IllegalStateException if the input element is already linked.
   */
  public void setInitializer( ExpressionT expr );


  // ----------------------------------------------------------------------

  /**
   * Gets the owning variable declaration, null if this is a formal
   * parameter.
   *
   * @return The owning variable declaration. <p/>
   * <pre>
   * Field variables (SRC_FIELD_VARIABLE) return SrcFieldDeclaration's.
   * Formal parameters (SRC_FORMAL_PARAMETER) return null.
   * Local variables (SRC_LOCAL_VARIABLE) return SrcLocalsDeclaration's.
   * </pre>
   */
  public VariableDeclT getOwningDeclaration();


  // ----------------------------------------------------------------------
   
  /**
   * Gets the type reference for this element.
   *
   * @return This element's type reference.
   */
  public TypeReferenceT getType();


  /**
   * Unlinks the current source type and links the input element.
   * 
   * @param type The new type reference.
   *
   * @throws IllegalStateException if the input type is already linked.
   */
  public void setType( TypeReferenceT type );

}
