/*
 * @(#)TypeReferenceT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * A type reference.
 *
 * @author Andy Yu
 */
public interface TypeReferenceT
  extends Tree, HasNameT
{
  // ----------------------------------------------------------------------

  static final TypeReferenceT[] EMPTY_ARRAY = new TypeReferenceT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * True if this is a primitive type (including "void"). Array types
   * of primitives return false.
   */
  public boolean isPrimitive();


  // ----------------------------------------------------------------------

  /**
   * Gets the list of type arguments.
   *
   * @return The array of type arguments.  <p/>
   *
   * List of TypeArgumentTs.
   */
  public List getTypeArguments();


  // ----------------------------------------------------------------------

  /**
   * True if this is an array type reference.
   *
   * @return True if getArrayDimension() > 0.
   */
  public boolean isArray();

  /**
   * Gets the array dimension. Implicitly includes an array dimension
   * increment of 1 IF this is the type of a variable-length argument.
   *
   * @return 0 means not an array.
   */
  public int getArrayDimension();


  // ----------------------------------------------------------------------

}

