/*
 * @(#)NameT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A name, simple or qualified. <p/>
 *
 * In certain cases, it may contain non-identifier characters. For
 * example, in an import declaration, the name will include the
 * trailing ".*". <p/>
 *
 * @author Andy Yu
 * */
public interface NameT
  extends Tree
{
  // ----------------------------------------------------------------------

  static final NameT[] EMPTY_ARRAY = new NameT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * Replaces the current text with the input raw text.
   */
  public void setText( String text );

  /**
   * Gets the String value of this name. The name "getValue" is
   * inherited from the previous parser version. The "value" is not
   * always the same as the "text". For example, if the text is an
   * identifier including unicode characters, the value will have a
   * translated text whereas the text is the raw text.
   *
   * @return The string value associated with this name symbol.
   */
  public String getValue();

  /**
   * Replaces the current value with the input value.
   */
  public void setValue( String value );


  // ----------------------------------------------------------------------
}
