/*
 * @(#)MethodT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * A method or constructor declaration. <p/>
 *
 * @author Andy Yu
 * */
public interface MethodT
  extends MemberT, HasNameT
{
  // ----------------------------------------------------------------------

  static final MethodT[] EMPTY_ARRAY = new MethodT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * True if this is a constructor. Equivalent to asking
   * getTreeKind() == TREE_CONSTRUCTOR_D.
   *
   * @return True if this is a constructor. False otherwise.
   */
  public boolean isConstructor();

  /**
   * Tests if this method is modified by ACC_VARARGS.
   *
   * @return True if this is a variable arguments method. False otherwise.
   */
  public boolean isVarargs();

  /**
   * Gets the ordered list of type parameters declared on this class.
   * Remember, type parameters are not inherited by subclasses (and
   * subinterfaces). <p/>
   * 
   * For classes, syntax is "javadoc mods class name <ty_params> {}".
   *
   * @return The list of type parameters. <p/>
   *
   * List of TypeParameterTs.
   */
  public List getTypeParameters();

  /**
   * Gets the source return type.
   *
   * @return The TypeReferenceT for the return type of this method. Null if
   * this is a constructor.
   */
  public TypeReferenceT getReturnType();

  /**
   * Attempts to set the return type of this method.
   *
   * @throws UnsupportedOperationException if this is a constructor.
   */
  public void setReturnType( TypeReferenceT type );

  /**
   * Gets the ordered list of parameters.
   *
   * @return The list of formal parameters. Does not include the synthetic
   * "this$0" parameter where applicable. <p/>
   *
   * List of FormalParameterTs.
   */
  public List getParameters();

  /**
   * Gets the ordered list of exception types.
   *
   * @return The list of declared thrown exception types. Always non-null.
   * Will have an element for each exception type that is declared, even
   * if it is a RuntimeException subclass or if it cannot be legally
   * resolved. <p/>
   *
   * List of TypeReferenceTs.
   */
  public List getExceptions();


  // ----------------------------------------------------------------------

  /**
   * Gets the formal parameter list object.
   *
   * @return The formal parameter list belonging not this method (or
   * constructor) declaration. Always non-null. If there is no formal
   * parameter list, then a synthetic one is returned. Note: It is a compile
   * error if there is no formal parameter list.
   */
  public FormalParameterListT getFormalParameterList();

  /**
   * Gets the throws clause object.
   *
   * @return The throws clause belonging to this method (or constructor)
   * declaration. Always non-null. If there is no throws clause, then a
   * synthetic one is returned.
   */
  public ThrowsT getThrowsClause();


  // ----------------------------------------------------------------------
}
