/*
 * @(#)MemberT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for elements that may be a member of a type
 * declaration. <p/>
 *
 * @author Andy Yu
 * */
public interface MemberT
  extends Tree, HasModifiersT
{
  // ----------------------------------------------------------------------

  static final MemberT[] EMPTY_ARRAY = new MemberT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * Gets the enclosing class.
   *
   * @return the class enclosing this member.
   */
  public ClassT getDeclaringClass();


  // ----------------------------------------------------------------------

  /**
   * Gets the javadoc comment symbol.
   *
   * @return The DocCommentT associated with this symbol.
   */
  public DocCommentT getDocComment();

  /**
   * Attempts to set the javadoc comment symbol.
   *
   * @param comment The new comment element.
   */
  public void setDocComment( DocCommentT comment );


  // ----------------------------------------------------------------------
  
  /**
   * Gets the declared code block, null if none.
   *
   * @return The code block associated with this element. Null if none.
   */
  public BlockT getBlock();


  /**
   * Attempts to set the code block associated with this element.
   */
  public void setBlock( BlockT block );

}
