/*
 * @(#)HasNameT.java
 */

package javax.ide.model.java.source.tree;

/**
 * Common supertype for elements have have a NameT. <p/>
 *
 * @author Andy Yu
 */
public interface HasNameT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the name symbol.
   *
   * @return The NameSymbol associated with this object. Null if none.
   */
  public NameT getNameElement();

  /**
   * Unlinks the current name and links the input element.
   *
   * @throws IllegalStateException if the input element is already linked.
   */
  public void setNameElement( NameT name );

  /**
   * Gets the name string from the name element. Convenience.
   *
   * @return The name string associated with this object. Always
   * non-null. If no name is found, the empty string is returned.
   */
  public String getName();

  /**
   * Sets the name string on the name element to be the input
   * name. Convenience.
   */
  public void setName( String name );

  // ----------------------------------------------------------------------
}
