/*
 * @(#)FormalParameterListT.java
 */

package javax.ide.model.java.source.tree;

import java.util.List;

/**
 * A formal parameter list. May be a child of a method/constructor
 * declaration or a catch clause. <p/>
 *
 * @author Andy Yu
 * */
public interface FormalParameterListT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the list of source parameters.
   *
   * @return The array of VariableTs for all the parameters in its
   * formal parameter list. May be zero-length. Includes the synthetic
   * "this$0" parameter where applicable. Returns a collection of
   * VariableT's. <p/>
   *
   * List of FormalParameterTs.
   */
  public List getParameters();


  // ----------------------------------------------------------------------
}
