/*
 * @(#)FileT.java
 */

package javax.ide.model.java.source.tree;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ide.model.java.JavaModel;
import javax.ide.model.java.source.TreeFactory;
import javax.ide.model.java.source.TreeTransaction;

/**
 * The root of a source file, also called a compilation unit.  From
 * the root, a client may retrieve the package declaration, the import
 * declarations, and all top-level type declarations. <p/>
 *
 * @author Andy Yu
 * */
public interface FileT
  extends Tree
{
  // ----------------------------------------------------------------------

  /**
   * Gets the package declaration.
   *
   * @return The package symbol. Null if none.
   */
  public PackageT getPackage();

  /**
   * Gets the package name, empty if none.
   *
   * @return The name of the package declaration. An empty string, if none.
   */
  public String getPackageName();

  /**
   * Attempts to set the package declaration.
   */
  public void setPackage( PackageT packageD );

  /**
   * Attempts to set the name of the package declaration.
   */
  public void setPackageName( String packageName );

  /**
   * Gets the list of import declarations.
   *
   * @return The array of import symbols. Returns a collection of
   * ImportT's. <p/>
   *
   * List of ImportTs.
   */
  public List getImports();

  /**
   * Gets the set of import strings.
   *
   * @return The set (of String's) of fully qualified import names. If
   * you add a String value that does not already exist in the set,
   * then an import will be generated for that value. If you add a
   * String value that already does exist in the set, it will be
   * ignored. <p/>
   *
   * Set of Strings.
   */
  public Set getImportNames();

  /**
   * Gets the list of top-level source classes.
   *
   * @return The array of class symbols. Returns a collection of ClassT's. <p/>
   *
   * List of ClassTs.
   */
  public List getClasses();

  /**
   * Gets the matching top-level source class.
   *
   * @return The matching class symbol. Null if none.
   */
  public ClassT getClass( String name );

  /**
   * @return a Tree for the sql context. Null if none.
   */
  //public SourceName getSqlContext();

  /**
   * Gets the primary class. Here, "primary class" means the class
   * that bears the same name as the compilation unit (file). If no
   * class is defined with the same name as the compilation unit, then
   * no class will be returned. If the compilation unit has no name,
   * then the first class is returned. <p/>
   *
   * The term "primary class" is not actually used in any reference I
   * tried: JLS, JPL, or Effective Java. It does see some usage on the
   * web. The term "main class" could be confused with the run-time
   * class whose "main(...)" method is being run.
   *
   * @return The primary class defined by this source file. Null if
   * none.
   */
  public ClassT getPrimaryClass();


  // ----------------------------------------------------------------------

  /**
   * Traverses the entire parse tree, calling
   * <code>setProperty(key, null)</code> on each element.
   */
  public void clearAllProperties( String key );


  // ----------------------------------------------------------------------

  /**
   * Gets the factory to create Tree objects in this FileT.
   *
   * @return The factory used to create Tree objects in this FileT.
   */
  public TreeFactory getFactory();

  /**
   * Gets the URI of this file, null if none.
   *
   * @return The URI of this file, null if none.
   */
  public URI getURI();

  /**
   * Gets the owning JavaModel.
   *
   * @return The owning JavaModel.
   */
  public JavaModel getOwningModel();

  /**
   * Begins a single-tree transaction.
   *
   * @return The transaction object.
   */
  public TreeTransaction beginTransaction();

  /**
   * Gets the in-progress single-tree transaction, null if none. <p/>
   *
   * @return The in-progress single-tree transaction, null if none.
   */
  public TreeTransaction getTransaction();


  // ----------------------------------------------------------------------
}
