/*
 * @(#)FieldDeclT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A field (or enum constant) declaration. <p/>
 *
 * @author Andy Yu
 * */
public interface FieldDeclT
  extends MemberT, VariableDeclT
{
  // ----------------------------------------------------------------------

  static final FieldDeclT[] EMPTY_ARRAY =
    new FieldDeclT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * True if this is public.
   *
   * @return True if element is modified with "final".
   */
  public boolean isPublic();

  /**
   * True if this is protected.
   *
   * @return True if element is modified with "protected".
   */
  public boolean isProtected();

  /**
   * True if this is private.
   *
   * @return True if element is modified with "private".
   */
  public boolean isPrivate();

  /**
   * True if this is static.
   *
   * @return True if element is modified with "static".
   */
  public boolean isStatic();

  /**
   * True if this is abstract.
   *
   * @return True if element is modified with "abstract".
   */
  public boolean isAbstract();


  // ----------------------------------------------------------------------
}
