/*
 * @(#)CatchClauseT.java
 */

package javax.ide.model.java.source.tree;

/**
 * A catch clause of a try statement. JLS3 14.20. <p/>
 *
 * @author Andy Yu
 * */
public interface CatchClauseT
  extends CompoundStatementT
{
  // ----------------------------------------------------------------------

  public static CatchClauseT[] EMPTY_ARRAY = new CatchClauseT[ 0 ];


  // ----------------------------------------------------------------------

  /**
   * A catch clause declares one variable, the caught exception.
   */
  public FormalParameterT getCatchVariable();

  /**
   * @return The owning try statement. Null if none (i.e. deformed tree).
   */
  public TryStatementT getOwningTry();


  // ----------------------------------------------------------------------
}
