/*
 * @(#)MethodD.java
 */

package javax.ide.model.java.declaration;

/**
 * Represents a method or annotation element. <p/>
 *
 * An annotation element MUST be a MethodD because annotation types
 * may be extended/implemented where an annotation element will be
 * treated like an ordinary interface method. <p/>
 *
 * @author Andy Yu
 */
public interface MethodD
  extends ExecutableD, HasNameD, HasTypeD
{
  // ----------------------------------------------------------------------

  /**
   * True if this is an annotation element.
   *
   * @return True if this is an annotation element.
   */
  public boolean isAnnotationElement();
  
  /**
   * True if this is modified with "synchronized".
   *
   * @return True if this is modified with "synchronized".
   */
  public boolean isSynchronized();

  /**
   * True if marked as a bridge method.
   *
   * @return True if marked as a bridge method.
   */
  public boolean isBridge();

  /**
   * True if this is modified with "native".
   *
   * @return True if this is modified with "native".
   */
  public boolean isNative();

  /**
   * True if this is modified with "abstract".
   *
   * @return True if this is modified with "abstract".
   */
  public boolean isAbstract();

  /**
   * True if this is modified with "strictfp".
   *
   * @return True if this is modified with "strictfp".
   */
  public boolean isStrictfp();


  // ----------------------------------------------------------------------

  /**
   * Gets the default value, null if this is not an annotation
   * element. <p/>
   *
   * @return An object representing the default value:
   *
   * <ul>
   *
   * <li> A value of a primitive type gets returned as an instance of its
   *      appropriate wrapper class (e.g. Integer).
   *
   * <li> A String value gets returned as a String instance.
   *
   * <li> A class reference gets returned as a TypeM instance.
   *
   * <li> An annotation gets returned as an AnnotationM instance.
   *
   * <li> An array gets returned as a Collection<Object>, one element
   *      for each value.
   *
   * </ul>
   *
   */
  public Object getDefaultValue();

  /**
   * Gets the return type.
   *
   * @return The type declaration for the return type of this method.
   */
  public TypeD getReturnType();
}
