/*
 * @(#)AnnotationD.java
 */

package javax.ide.model.java.declaration;

import java.util.Map;

/**
 * Represents an annotation (not to be confused with an annotation type).
 *
 * @author Andy Yu
 */
public interface AnnotationD
  extends Declaration
{
  // ----------------------------------------------------------------------

  /**
   * Gets the annotation type of this annotation.
   *
   * @return The type declaration for the annotation type of this annotation.
   */
  public TypeD getAnnotationType();

  /**
   * Gets the element-value pairs for this annotation. <p/>
   *
   * @see MethodD#getDefaultValue()
   *
   * @return The map of element-value pairs for this annotation. There
   * will be an entry for each declared annotation member. A null
   * value is not legal in the java language, however a null value may
   * be returned here and such would indicate a compile error. <p/>
   *
   * Map keys are String. Map values are Object.
   */
  public Map getElements();
}
