/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.model;
import javax.ide.util.IconDescription;

/**
 * Display information about a JSR-198 element. This class allows custom
 * Elements (extension-provided subclasses of Element, Document, TextDocument or 
 * XMLDocument) to configure the way they appear in the IDE.<p>
 * 
 * Any methods on this class may return null. If they do, IDEs will display
 * the element in whatever the "default" way is for nodes of this type.<p>
 * 
 * This implementation returns <tt>null</tt> from all methods.
 */
public class ElementDisplayInfo 
{
  /**
   * Get the label for the specified element.
   * 
   * @param element the element to get the label for.
   * @return the label for the element. 
   */
  public String getLabel( Element element )
  {
    return null;
  }
  
  /**
   * Get the icon for the specified element.
   * 
   * @param element the element to get the icon for.
   * @return the icon for the element. 
   */
  public IconDescription getIcon( Element element )
  {
    return null;
  }
  
  /**
   * Get the tooltip for the specified element.
   * 
   * @param element the element to get the tooltip for.
   * @return the tooltip for the element.
   */
  public String getToolTip( Element element )
  {
    return null;
  }
  
  /**
   * Get the long label for the element.
   * 
   * @param element the element to get the long label for.
   * @return the long label for the element.
   */
  public String getLongLabel( Element element )
  {
    return null;
  }
}
