/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.menu.spi;

import javax.ide.extension.ElementVisitor;
import java.util.logging.Level;
import javax.ide.extension.ElementStartContext;

abstract class PositionableVisitor extends ElementVisitor
{
  private final String _idAttribute;

  protected PositionableVisitor( String idAttribute )
  {
    _idAttribute = idAttribute;
  }

  protected PositionableVisitor()
  {
    this( "id" );
  }

  public final void start( ElementStartContext context )
  {
    String id = context.getAttributeValue( _idAttribute );
    if ( id == null || (id = id.trim()).length() == 0 )
    {
      log(context, Level.SEVERE, "Missing required attribute '" + _idAttribute + "'");
      return;
    }

    Float weight = null;
    final String val = context.getAttributeValue( "weight" );
    if ( val != null )
    {
      weight = Float.valueOf(val);
    }

    String before = context.getAttributeValue( "before" );
    if ( before != null )
    {
      if ( weight != null )
      {
        log( context, Level.SEVERE, "Attributes 'weight', 'before' and 'after' are mutually exclusive." );
        return;
      }
      before = before.trim();
    }

    String after = context.getAttributeValue( "after" );
    if ( after != null )
    {
      if ( weight != null )
      {
        log( context, Level.SEVERE, "Attributes 'weight', 'before' and 'after' are mutually exclusive." );
        return;
      }
      if ( before != null )
      {
        log( context, Level.SEVERE, "Cannot have both 'before' and 'after'" );
        return;
      }
      after = after.trim();
    }

    positionable( context, id, before, after, weight );
  }

  protected abstract void positionable( ElementStartContext context, String id,
    String before, String after, Float weight );

}
