/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.log.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.util.MetaClass;

/**
 * Log page information gathered from processing the <b>log-hook</b>
 * section of an extension manifest. The information recorded 
 * here describes a new wizard and is generally given to the 
 * {@link javax.ide.log.LogManager} for registration.<p>
 */
public class LogHook extends ExtensionHook
{
  public static final ElementName ELEMENT = 
    new ElementName( MANIFEST_XMLNS, "log-hook" );
    
  private static final ElementName LOG_PAGES = 
    new ElementName( MANIFEST_XMLNS, "log-pages" );
  private static final ElementName LOG_PAGE = 
    new ElementName( MANIFEST_XMLNS, "log-page" );
    
  private ElementVisitor _logPagesVisitor = new LogPagesVisitor();
  private ElementVisitor _logPageVisitor = new LogPageVisitor();

  private Collection _logPages = new ArrayList();
  
  public Collection getLogPages()
  {
    return Collections.unmodifiableCollection( _logPages );
  }
    
  public void start( ElementStartContext context )
  {
    context.registerChildVisitor( LOG_PAGES, _logPagesVisitor );
  }
  
  private class LogPagesVisitor extends ElementVisitor
  {
    public void start( ElementStartContext context )
    {
      context.registerChildVisitor( LOG_PAGE, _logPageVisitor );
    }
  }
  
  private class LogPageVisitor extends ElementVisitor
  {
    public void start( ElementStartContext context )
    {
      String pageClass = context.getAttributeValue( "log-page-class" );
      if ( pageClass == null )
      {
        log( context, Level.SEVERE, "Missing attribute 'log-page-class'" );
      }
      else
      {
        MetaClass pageMetaClass = new MetaClass( 
          (ClassLoader) context.getScopeData().get( ExtensionVisitor.KEY_CLASSLOADER ),
          pageClass
        );
        
        _logPages.add( pageMetaClass );
      }
    }
  }

}
