package javax.ide.extension.spi;


import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.Version;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;

import org.xml.sax.InputSource;

public class MinimalExtensionParser
{
  
  public static void  loadMinimal( 
    MinimalExtensionVisitor visitor,
    DefaultElementContext initialContext,
    Collection<ExtensionSource> extensionSources, 
    List<ExtensionSource> failedSources)
  {
    PullManifestParser minimalParser = new PullManifestParser( initialContext );

    minimalParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, visitor);

    for ( Iterator i = extensionSources.iterator(); i.hasNext(); )
    {
      ExtensionSource source = (ExtensionSource) i.next();
      minimalParser.getContext().getScopeData().put( ExtensionVisitor.KEY_EXTENSION_SOURCE,  source );
      InputStream inputStream = null;
      try
      { 
        inputStream = source.getInputStream();
      
        minimalParser.parse( inputStream, source.getManifestURI().toString() );
        
        DefaultExtension defaultExtension = (DefaultExtension) minimalParser.getContext().getScopeData().get(
          ExtensionHook.KEY_EXTENSION
        );
      }
      catch ( ParserConfigurationException pce )
      {
        throw new IllegalStateException( "JAXP is misconfigured", pce );
      }
      catch ( XMLStreamException saxe )
      {
        minimalParser.getContext().getLogger().log(
          Level.SEVERE,
          "Failed to process extension source: "+saxe.getLocalizedMessage(),
          new LocationImpl( source.getManifestURI().toString() )
        );
        failedSources.add( source );
      }
      catch ( FileNotFoundException fnf )
      {
        fnf.printStackTrace();
        minimalParser.getContext().getLogger().log(
          Level.SEVERE,
          source.getName()+" does not contain an extension manifest.",
          new LocationImpl( source.getManifestURI().toString() )
        );        
      }
      catch ( IOException ioe )
      {
        minimalParser.getContext().getLogger().log(
          Level.SEVERE,
          "Failed to process extension source "+ source.getName()+": "+ioe.getLocalizedMessage(),
          new LocationImpl( source.getManifestURI().toString() )
        );
        failedSources.add( source );
      }
      finally
      {
        try
        {
          if ( inputStream != null )
            inputStream.close();
        }
        catch ( IOException ioe )
        {
          minimalParser.getContext().getLogger().log( 
            Level.SEVERE, 
            "Exception closing stream",
            ioe
          );
        }
      }
    }
  }

  private MinimalExtensionParser()
  {
  }
}
