package javax.ide.extension;

import java.util.ArrayList;

public class OnDemandElementVisitor extends ElementVisitor
{
  private ArrayList<OnDemandElementVisitorListener> _regListeners;

  public OnDemandElementVisitor()
  {
    super();
  }

  @Override
  public final void start(ElementStartContext context)
  {
    String extId = context.getExtension().getID();
    notifyRegListeners(extId, true);

    super.start(context);
    startImpl(context);
  }

  @Override
  public final void end(ElementEndContext context)
  {
    super.end(context);
    endImpl(context);

    String extId = context.getExtension().getID();
    notifyRegListeners(extId, false);
  }

  protected void startImpl(ElementStartContext context)
  {
  }

  protected void endImpl(ElementEndContext context)
  {
  }

  public final synchronized void addRegListener(OnDemandElementVisitorListener listener)
  {
    if (listener != null)
    {
      if (_regListeners == null)
      {
        _regListeners = new ArrayList<OnDemandElementVisitorListener>(5);
      }
      _regListeners.add(listener);
    }
  }

  public final synchronized void removeRegListener(OnDemandElementVisitorListener listener)
  {
    if (_regListeners != null && listener != null)
    {
      _regListeners.remove(listener);
    }
  }

  private void notifyRegListeners(String extensionId, boolean isStarting)
  {
    java.util.List list;
    synchronized (this)
    {
      if (_regListeners == null)
      {
        return;
      }
      list = (java.util.List) _regListeners.clone();
    }
    int size = list.size();
    for (int i = 0; i < size; i++)
    {
      OnDemandElementVisitorListener listener = (OnDemandElementVisitorListener) list.get(i);
      if (isStarting)
      {
        listener.starting(extensionId);
      }
      else
      {
        listener.ended(extensionId);
      }
    }
  }
}
