/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension;
import java.util.logging.Level;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.util.IconDescription;

/**
 * Use IconVisitor for processing an XML element in the manifest that provides
 * an icon.
 */
public abstract class IconVisitor extends ElementVisitor
{
  private I18NStringVisitor _delegate = new I18NStringVisitor()
  {
    protected final void string( ElementContext context, String string )
    {
      // NO-OP
    }
  };
  
  public void start( ElementStartContext context )
  {
    _delegate.start( context );
  }
  
  public void end( ElementEndContext context )
  {
    String rskey = (String) context.getScopeData().get( 
      I18NStringVisitor.KEY_RSKEY );

    if ( rskey == null || rskey.trim().length() == 0 )
    {
      String text = context.getText();
      if ( text == null || ( text = text.trim()).length() == 0 )
      {
        log( context, Level.WARNING, 
          "Must provide an icon path or resource key."
        );
      }
      IconDescription id = IconDescription.createPathInstance(
        (ClassLoader) context.getScopeData().get( ExtensionVisitor.KEY_CLASSLOADER ),
        text
      );
      icon( context, id );
    }
    else
    {
      IconDescription id = IconDescription.createResourceInstance(
        (ClassLoader) context.getScopeData().get( ExtensionVisitor.KEY_CLASSLOADER ),
        (String) context.getScopeData().get( ExtensionHook.KEY_RSBUNDLE_CLASS ),
        rskey
      );
      icon( context, id );
    }
  }

  /**
   * Called when an icon is encountered. 
   * 
   * @param context the processing context.
   * @param icon the icon.
   */
  protected abstract void icon( ElementContext context, IconDescription icon );

}
