/* $Header: jdev/src/javaxide/src/javax/ide/extension/HookProcessingUtils.java /main/1 2014/06/19 10:15:36 svassile Exp $ */

/* Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.*/

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    svassile    06/04/14 - Creation
 */

/**
 *  @version $Header: jdev/src/javaxide/src/javax/ide/extension/HookProcessingUtils.java /main/1 2014/06/19 10:15:36 svassile Exp $
 *  @author  svassile
 *  @since   release specific (what release of product did this appear in)
 */

package javax.ide.extension;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;


public class HookProcessingUtils
{
  private HookProcessingUtils() {}
  
  public static URL resolvedValue2URL(String resolvedValue) throws MalformedURLException {
    if ( resolvedValue.startsWith( "uri:" ) )     // NOTRANS
    {
      final String path = resolvedValue.substring( 4 );
      final URI uri = URIFactory.newURI( path );
      if ( uri != null )
      {
        VirtualFileSystem vfs = VirtualFileSystem.getVirtualFileSystem();
        return vfs.toURL( uri );
      }
    }
    return null;
  }
}
