package javax.ide.extension;

/**
 * New version of <tt>ElementVisitorFactory</tt>. This new implementation
 * has an overloaded version of getElementVisitor() that takes an 
 * <tt>ElementContext</tt> corresponding to the parent element.<p>
 * 
 * If an <tt>ElementVisitorFactory</tt> is registered with 
 * ElementContext#registerVisitorFactory(ElementVisitorFactory) and also 
 * implements ElementVisitorFactory2, then the {@link #getVisitor(ElementContext,ElementName)}
 * will be used in preference to {@link ElementVisitorFactory#getVisitor(ElementName)}.
 * 
 * @since 2.0
 */
public interface ElementVisitorFactory2 extends ElementVisitorFactory
{
  /**
   * Returns <tt>true</tt> if this visitor factory supports descending 
   * through all children of the element for which it was registered. The
   * default behavior for all ElementVisitorFactory instances in JSR-198
   * was to descend. For backwards compatibility, any ElementVisitorFactory
   * that is not an ElementVisitorFactory2 behaves as if this method
   * returns <tt>true</tt>.
   * 
   * @return <tt>true</tt> if this factory should be used to handle all 
   *    elements in the scope of the element it was registered for.
   */
  public boolean isDescending();

  /**
   * Get a suitable visitor for the specified element name.
   * 
   * @param context the current context.
   * @param name a qualified element name.
   * @return a visitor suitable for this element, or null.
   * @throws UnrecognizedElementException if the factory does not 
   *    recognize the element and this should be raised as an error.
   */
  public ElementVisitor getVisitor( ElementContext context, 
    ElementName name ) throws UnrecognizedElementException;
}
