/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.editor.spi;

/**
 * Record of information identifying an editor class that can open documents
 * of a particular class.
 */
public final class MappingInfo 
{
  private String _editorClass;
  private boolean  _preferred;

  /**
   * Constructor.
   */
  public MappingInfo( String editorClass, boolean isPreferred ) 
  {
    _editorClass = editorClass;
    _preferred = isPreferred;
  }

  /**
   * Get the editor class.
   * 
   * @return The editor class.
   */
  public String getEditorClass()
  {
    return _editorClass;
  }


  /**
   * Get whether this editor class is the preferred editor for a given 
   * document type. How this is interpreted is IDE specific.
   * 
   * @return true if this editor is the preferred editor type for a particular
   *    document.
   */
  public boolean isPreferred()
  {
    return _preferred;
  }
}
