REM Copyright (c) 2012, Oracle and/or its affiliates. 
REM All rights reserved. 

create or replace package db2_sql_fingerprinter as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob);

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2);

end;
/

create or replace package body db2_sql_fingerprinter as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob) as
  language java
  name 'oracle.dbtools.babelfish.db2.DB2SQLTranslator.translateSQL(oracle.sql.CLOB,oracle.sql.CLOB[])';

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2) as
  language java
  name 'oracle.dbtools.babelfish.db2.DB2SQLTranslator.translateError(int,int[],java.lang.String[])';

end;
/
EXIT
