/*
 * Tree nodes indented one level up (in relation to narrowest node that surrounds it) 
 */
isolatedNodes:  
/*
--| [node) select_clause | [node) from_clause | [node) where_clause | [node) group_by_clause 
--| [node) having_clause | [node) hierarchical_query_clause 
--| [node) order_by_clause 
*/
  [node) query_partition_clause
| [node) select_term 
| [node) name_list & [node^) into_list
| [node) table_reference 
| [node) "inner_cross_join_clause"
| [node) col_properties 
| [node) update_set_clause
| [node) update_set_clause_expr
| [node) expression_list  & ![node) grouping_expression_list
| [node) basic_decl_item
| [node) inline_constraint & ![node) inline_constraint[14,67)
--| [node) out_of_line_constraint=col_properties
| [node) inline_ref_constraint
| [node) references_clause 
| [node) references_clause[28,59)
| [node) column_properties & ! [node^) column_properties --?++5 & ! [node^) relational_table
| [node) nested_table_col_properties  & ![node)column_properties#  --  nested_table_col_properties->column_properties#->column_properties 
| [node) table_properties  & ![node) column_properties          --?or relational_table  extra ident for ++1222  
                                                                -- &! [node) nested_table_col_properties
| [node) using_index_clause 
| [node) table_index_clause 
| [node) create_index_statement & ![node^) sql_statement
| [node) file_specification
| [node) database_logging_clauses[24,42) 
| [node) database_logging_clauses
| [node) tablespace_clauses 
| [node) default_tablespace
| [node) storage_clause 
| [node) pdb_storage_clause
| [node) create_database[15,196)# 
| [node) datafile_tempfile_spec 
| [node) tablespace_datafile_clauses 
| [node) autoextend_clause 
| [node) enable_pluggable_database 
| [node) file_name_convert
| [node) physical_properties 
| [node) external_data_properties 
| [node) record_format 
| [node) fields_def
| [node) source_file_name_convert 
| [node) XMLType_storage 
| [node) tempfile_reuse_clause
| [node) XML_attributes_clause 
| [node) xmlelement & ![node^) select_term  
| [node) xmlelement[41,54)
| [node) XML_table_column 
| [node) xmltable_options
| [node) keystore_management_clauses 
| [node) export_keys[58,84) 
| [node) key_management_clauses 
| [node) merge_into_new_keystore[35,47)
| [node) user_aux
--| [node) table_index_clause 
| [node) index_properties & [node^) table_index_clause
| [node) range_values_clause 
--| [node) ',' & [node^) on_comp_partitioned_table[68,117)# 
| [node) list_partitions[30,49)#
| [node) adt_field
| [node) model_column_clauses 
| [node) cell_reference_options 
| [node) model_rules_clause 
| [node) model_rules_clause[3,76)
/*| [node) model_rules_clause[114,157) <-- inserts break before , */
| [node) ',' & [node+1) cell_assignment
/*| [node) cell_assignment ++808 <-- inserts break before = */
| [node) single_column_for_loop
| [node) row_pattern_partition_by 
| [node) row_pattern_order_by 
| [node) row_pattern_measures 
| [node) row_pattern_measure_column 
| [node) row_pattern_definition 
| [node) row_pattern_rows_per_match 
| [node) row_pattern_skip_to
| [node) binding_clause
| [node) logfile_clause
| [node) new_values_clause 
| [node) "mv_log_details"
| [node) create_mv_refresh 
| [node) create_mv_refresh[12,238)# 
| [node) parallel_clause 
| [node) build_clause
| [node) level_clause 
| [node) hierarchy_clause 
| [node) dimension_join_clause 
| [node) attribute_clause 
| [node) hierarchy_clause[14,29)#
| [node) privilege_audit_clause 
| [node) system_privilege 
| [node) standard_actions 
| [node) role_audit_clause
| [node) security_clauses
| [node) cluster_range_partitions 
| [node) create_cluster[49,121)#
| [node) alter_method_spec 
| [node) subprogram_spec 
| [node) dependent_handling_clause 
| [node) original_method_body_specification
| [node) resource_parameters 
| [node) password_parameters
| [node) sql_statement 
| [node) stmt 
| [node) pivot_clause 
| [node) pivot_for_clause 
| [node) pivot_in_clause
| [node) error_logging_clause
| [node) case_expression
| [node) dblink_authentication 
| [node) "db link auth" 
| [node) json_table 
| [node) JSON_value_column 
| [node) JSON_columns_clause 
| [node)  JSON_column_definition
| [node) mining_attribute_clause & [node+2 < node) 
| [node) pls_expr & [node^) case_expr_alt 
| [node) pls_expr & [node-1) ',' & [node^^+10 < node^^)
| [node) pls_expr & [node^) paren_expr_list & [node^+10 < node^)
/*| [node) pls_expr  &  [node-1) 'WHEN'
| [node) pls_expr  &  [node-1) 'THEN'
| [node) pls_expr  &  [node-1) 'AND'*/
| [node) group_by_col
| [node) select_term  &  [node^) select_list   
-- | [node) "aliased_expr"  &  [node^) select_list  <----- redundant due to    select_term:  "aliased_expr";
| [node) '*'  &  [node) select_list 
| [node) subquery  & [node-1) 'AS'   -- sql_statement+create_view
| [node) subquery  
          &  ![node^) sql_statement 
          &  ![node^) stmt 
          &  ![node^) unlabeled_nonblock_stmt  
          &  ![node^) table_properties --or relational_table?
          &  ![node^) single_table_insert
| [node) condition  &  [node-1) '('
--??? | [node) condition  &  [node-1) 'WHEN'  ?????
--??? | [node) condition  &  [node-1) 'BY'    ????
| [node) condition  &  [node^) hierarchical_query_clause & ![node) compound_condition
| [node) condition  &  [node^) where_clause & ![node) compound_condition
| [node) condition  &  [node^) having_clause & ![node) compound_condition
| [node) condition  &  [node^) on_using_condition & ![node) compound_condition
--| [node) condition  &  ([node-1) 'AND' | [node+1) 'AND')   -- <->
| [node) condition  &  [node^)  compound_condition & ![node) compound_condition
--extra level before ELSE: | [node) searched_case_expression  &  [node-1) 'CASE'
--extra level before ELSE: | [node) case_stmt_alt  &  [node-1) 'CASE'
| [node) expr  &  [node^) simple_case_expression
| [node) rel  &  [node-1) 'WHEN'
| [node) condition  &  [node-1) 'WHEN'
| [node) expr  &  [node-1) 'WHEN'
| [node) expr  &  [node-1) 'THEN'
| [node) expr  &  [node-1) 'ELSE'
| [node) expr  &  [node^) xmlelement[58,78)
-- | [node) expr  &  [node^) XML_attributes_clause  <--- captures column but have to grap alias as well:
| [node) case_expr_alt
| [node) ELSE_expr_opt
| [node) subprg_body & ![node^) create_plsql & ![node^) original_method_body_specification  --&  ! [node^) create    ++683(684?)
--| [node) function  &  ! [node^) create  &  ! [node^) select_term      ***refuted: SELECT id, LPAD(' ',2*(LEVEL-1))||operation operation, options,
| [node) type_constructor_expression &  ! [node^) create
--| [node) prm_spec_unconstrained_type & ! [node-1) 'RETURN'    ***refuted: CREATE FUNCTION ret_warehouse_typ(x warehouse_typ)   ; there is prm_spec anyway
| [node) object_privilege & [node+1) 'ON'
| [node) 'ALL' & [node+1) 'ON'
| [node) 'FOR' & [node^) explain_plan
| [node) 'INTO' & [node^) call_statement
| [node) is_or_as & [node^) subprg_body & [node+1) 'BEGIN'
--better formatting?: | [node) insert_into_clause | [node) values_clause | [node) returning_clause
| [node) insert_into_clause & ![node^) single_table_insert & ![node^) multi_table_insert[12,24)#
| [node) conditional_insert_clause
| [node) values_clause & ([node^) conditional_insert_clause[58,99)# | [node^) conditional_insert_clause)
| [node) conditional_insert_clause[58,99)#
| [node) windowing_clause /*can be up 2 levels: & [node^) analytic_clause*/
| [node) order_by_clause & ([node^) analytic_function | [node^) analytic_clause | [node^^) analytic_clause) --<-- not to ident order by in the main query block
| [node) 'PARTITION' & [node^) on_comp_partitioned_table[68,117)# 
| [node) field
| [node) java_call_specification
| [node) array_ty_def
| [node) excptn_handler
| [node) using_clause_opt
| [node) dml_event_clause
--dubious benefit: | [node) instead_of_dml_trigger
| [node) referencing_clause
| [node) ref_cls
| [node) rowOpt
| [node) table_stmt -- for compound trigger
--dubious benefit: | [node) action & ![node^) action 
| [node) when_condition
| [node) bitmap_join_index_clause
| [node) comparison_condition & [node^) bitmap_join_index_clause
| [node) local_partitioned_index
| [node) segment_attributes_clause & ![node^) segment_attributes_clause
| [node) xmlforest[29,52)#
| [node) XMLSchema_spec
| [node) LOB_storage_clause
| [node) LOB_storage_parameters#
| [node) assoc_arg
| [node) subpartition_template
| [node) subpartition_template[24,31)
| [node) index_subpartition_clause[69,119)# 
| [node) object_properties & ![node^) object_properties
| [node) ',' & [node^) object_properties
| [node) alias_in_out_constraints
| [node) object_view_clause
| [node) search_clause
| [node) cycle_clause
| [node) 'UPDATE' & [node-1) 'THEN'
| [node) merge_update_clause[36,56)#
| [node) et_field_spk
| [node) record_format2
;


ancestorDescendant:
ancestor < node & ![node^) "(x,y,z)" & (
   [node) "ord_by_1desc"  &  [ancestor) order_by_clause & ![ancestor) analytic_clause 
                                                        & ![ancestor^) analytic_clause 
                                                        & ![ancestor^^) analytic_clause  
 -- group_by_col: | [node) column  &  [ancestor) group_by_clause  
 | [node) column  &  [ancestor) insert_into_clause
 | [node) column  &  [ancestor) attribute_clause                  & ![node^) compound_expression
 | [node) column  &  [ancestor) dimension_join_clause             & ![node^) compound_expression
 | [node) column  &  [ancestor) extended_attribute_clause         & ![node^) compound_expression
 | [node) column  &  [ancestor) table_index_clause                & ![node^) compound_expression
 | [node) column  &  [ancestor) range_partitions 
 | [node) column  &  [ancestor) range_values_clause 
 | [node) expr    &  [ancestor) "(x,y,z)"    -- this is actually negative condition on closest ancestor
 | [node) expr    &  [ancestor) par_expr_list   & ![node^) compound_expression --++758 
                  &  [ancestor+3 < ancestor)    & ![node-1) '='
 --| [node) expr    &  [ancestor) function_expression  --this condition is for closest ancestor: & [ancestor+10 < ancestor) 
                                                       --(if nested functions then length condition doesn't work)
 --                 &  ![ancestor)analytic_function
 | [node) prm_spec &  [ancestor) fml_part  --& [ancestor+10 < ancestor)
 | [node) identifier  &  [ancestor) colmapped_query_name &  [node-1) ','
);

closestAncestor: /\ancestor(ancestorDescendant|[ancestor node])
;

/**
    The ancestor (table_index_clause) has lengthy addendum (index_properties) 
    which demolishes ancestor criteria based on ancestor's length 
    [4,43)   create_index_statement[5661,5668)  table_index_clause
      [4,5)   identifier
      [5,6)   '('
      [6,7)   column  expr  identifier  index_expr  simple_expression
      [7,8)   ')'
      [8,43)   global_partitioned_index  index_properties  index_properties#
        [8,9)   'GLOBAL'
        [9,43)   global_partitioned_index[14093,14098)  range_partitions
          [9,10)   'PARTITION'
          [10,11)   'BY'
          [11,12)   'RANGE'
          [12,13)   '('
          [13,14)   column  identifier
    investigate first and last node in descendants list 
*/
firstDescendant: \\node(closestAncestor)
;
lastDescendant: //node(closestAncestor)
;

-- Descendant nodes list with constraint onto how close the first and last descendant are allowed to be
-- It is a disjoint union
descendantNodes:  closestAncestor.ancestor=firstDescendant.ancestor 
                & closestAncestor.ancestor=lastDescendant.ancestor 
                & ( ![closestAncestor.ancestor) "(x,y,z)" | [closestAncestor.ancestor+20 < closestAncestor.ancestor) & ![closestAncestor.node^) compound_expression)
& (
    [firstDescendant.node+5 < lastDescendant.node) 
  & closestAncestor.node = closestAncestor.node  -- keep this attribute in disjunction (which represents implication: [closestAncestor.node) expr => firstDescendant.node+5 < lastDescendant.node) 
| 
    ![closestAncestor.node) expr
  & ![closestAncestor.node) column 
)
;  

selNodes: isolatedNodes |  descendantNodes
->
;

/* 
ancestors: selNodes;
descendants: selNodes;

hierarchy: ancestors.node < descendants.node
->;
*/

formattedNodes: selNodes
->
;

/*
 * Same idea as ancestorDependent, but want indent all descendants at
 * the same level
 */
/* 45 sec on 137023 tokens long f102.sql
precursorDescendant: 
ancestor < node & [ancestor+5 < ancestor) & (
    [node) compound_expression[25,44) & ?node = '||' & [ancestor) compound_expression
|   [node) binary_add_op & ?node = '||' & [ancestor) pls_expr   
|                          ?node = 'OR' & [ancestor) pls_expr   
);
split into alternatives:
*/
precursorDescendant1: 
ancestor < node & [ancestor+5 < ancestor) & 
    [node) compound_expression[25,44) & ?node = '||' & [ancestor) compound_expression
;
precursorDescendant2: 
ancestor < node & [ancestor+5 < ancestor) & [ancestor) pls_expr
&  [node) binary_add_op & (?node = '||'  |   ?node = 'OR' )   
;
precursorDescendant:  precursorDescendant1 | precursorDescendant2 
;


closestPrecursor: /\ancestor(precursorDescendant)
;

sameLevel:
    [closestPrecursor.ancestor+5 < closestPrecursor.ancestor) 
  & closestPrecursor.node=closestPrecursor.node  -- careful not to project away this attribute if disjunct
/*| 
    ![closestPrecursor.node) ...  
  & closestPrecursor.ancestor = closestPrecursor.ancestor */
->
;

"built-ins":
    [identifier) identifier 
  & [call) analytic_function
  & [call = [identifier
-- | [identifier) 'TO_CHAR' -- not in grammar
;
"ids": --node) <= [node + 1
   [identifier) identifier 
;
identifiers: "ids" - "built-ins"
-> 
;


paddedIdsInScope: (
  [id) identifier & [id+1) datatype & [scope) relational_properties
| [id) decl_id & ([id+1) prm_spec_unconstrained_type | [id+1) 'IN' | [id+1) 'OUT' ) & [scope) fml_part
| [id) decl_id & ([id+1) constrained_type | [id+1) object_d_rhs) & [scope) adt_definition
| [id) decl_id & ([id+1) constrained_type | [id+1) object_d_rhs) & [scope) decl_list
) & scope < id
->
;

sql_stmts: ([child) sql_query_or_dml_stmt | [child) open_cursor_reference_statement) & [node) stmt & child^=node
;

significant_statements: 
  [node) sql_statement
| [node) full_cursor_body
| [node) stmt & ![node^) loop_stmt & ([node^) seq_of_stmts | [node^) stmt_list_opt) & [node+20 < node)  
| [node) ',' & [node+1) method_specification 
| [node) original_method_body_specification
| [node) subprg_body & ![node^) create_plsql
| [node) basic_decl_item_list & [node+1) subprg_body
| [node) basic_decl_item & [node+20 < node)
;

extraLines: 
  significant_statements | sql_stmts
->
;

-- parenthesis which padding is subject to choice
notPaddedParenthesis:
ancestor < paren & (
 (   [ancestor) constraint  & [ancestor) paren_expr_list 
   | [ancestor) paren_expr_list & [ancestor^) function_call
   | [ancestor) function_expression
   | [ancestor) model_iterate_clause
   | [ancestor) datetime_literal
   | [ancestor) rollup_cube_clause
   | [ancestor) datatype  ) & ( [paren) '(' | [paren) ')' )
|
 (   [ancestor) model_clause  ) & ( [paren) '[' | [paren) ']' )
 )
->
;

