ALTER TABLE "UT_LOOKUP_DATATYPES" DROP CONSTRAINT "UT_LOOKUP_DATATYPES_UT_LO_FK1";
ALTER TABLE "UT_LOOKUP_DATATYPES" ADD CONSTRAINT "UT_LOOKUP_DATATYPES_UT_LO_FK1" FOREIGN KEY ("CAT_ID") REFERENCES "UT_LOOKUP_CATEGORIES" ("ID") ON DELETE CASCADE ENABLE;
   
ALTER TABLE "UT_LOOKUP_VALUES" DROP CONSTRAINT "UT_LOOKUP_VALUES_UT_LOOKU_FK1";
ALTER TABLE "UT_LOOKUP_VALUES" ADD CONSTRAINT "UT_LOOKUP_VALUES_UT_LOOKU_FK1" FOREIGN KEY ("DATA_ID") REFERENCES "UT_LOOKUP_DATATYPES" ("ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_SUITE_TEST" DROP CONSTRAINT "UT_SUITE_TEST_FK1";
ALTER TABLE "UT_SUITE_TEST" DROP CONSTRAINT "UT_SUITE_TEST_FK2";
ALTER TABLE "UT_SUITE_TEST" ADD CONSTRAINT "UT_SUITE_TEST_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_SUITE_TEST" ADD CONSTRAINT "UT_SUITE_TEST_FK2" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_SUITE_RESULTS" DROP CONSTRAINT "UT_SUITE_RESULTS_FK1";
ALTER TABLE "UT_SUITE_RESULTS" ADD CONSTRAINT "UT_SUITE_RESULTS_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_SUITE_TEST_RESULTS" DROP CONSTRAINT "UT_SUITE_TEST_RESULTS_FK1";
ALTER TABLE "UT_SUITE_TEST_RESULTS" DROP CONSTRAINT "UT_SUITE_TEST_RESULTS_FK2";
ALTER TABLE "UT_SUITE_TEST_RESULTS" ADD	CONSTRAINT "UT_SUITE_TEST_RESULTS_FK1" FOREIGN KEY ("UTSR_ID") REFERENCES "UT_SUITE_RESULTS" ("UTSR_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_SUITE_TEST_RESULTS" ADD CONSTRAINT "UT_SUITE_TEST_RESULTS_FK2" FOREIGN KEY ("UTR_ID") REFERENCES "UT_TEST_RESULTS" ("UTR_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_ARGUMENTS" DROP CONSTRAINT "UT_TEST_ARGUMENTS_FK";
ALTER TABLE "UT_TEST_ARGUMENTS" ADD CONSTRAINT "UT_TEST_ARGUMENTS_FK" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST" DROP CONSTRAINT "UT_TEST_LIB_STARTUPS_FK1";
ALTER TABLE "UT_TEST" DROP CONSTRAINT "UT_TEST_LIB_TEARDOWNS_FK1";
ALTER TABLE "UT_TEST" ADD CONSTRAINT "UT_TEST_LIB_STARTUPS_FK1" FOREIGN KEY ("LIB_STARTUP_ID") REFERENCES "UT_LIB_STARTUPS" ("LIB_STARTUP_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST" ADD CONSTRAINT "UT_TEST_LIB_TEARDOWNS_FK1" FOREIGN KEY ("LIB_TEARDOWN_ID") REFERENCES "UT_LIB_TEARDOWNS" ("LIB_TEARDOWN_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_IMPL" DROP CONSTRAINT "UT_TEST_IMPL_UT_TEST_FK1";
ALTER TABLE "UT_TEST_IMPL" DROP CONSTRAINT "UT_TEST_LIB_DYN_QUERIES_FK1";
ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_IMPL_UT_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_LIB_DYN_QUERIES_FK1" FOREIGN KEY ("LIB_DYN_QUERY_ID") REFERENCES "UT_LIB_DYN_QUERIES" ("LIB_DYN_QUERY_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_VALIDATIONS" DROP CONSTRAINT "UT_VALIDATIONS_TEST_IMPL_FK1";
ALTER TABLE "UT_VALIDATIONS" DROP CONSTRAINT "UT_VALIDATIONS_LIB_VALIDN_FK1";
ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_TEST_IMPL_FK1" FOREIGN KEY ("UTI_ID") REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON  DELETE CASCADE ENABLE;
ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_VALIDATION_ID") REFERENCES "UT_LIB_VALIDATIONS" ("LIB_VALIDATION_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" DROP CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK1";
ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" DROP CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK2";
ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" ADD CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK1" FOREIGN KEY ("ARG_ID") REFERENCES "UT_TEST_ARGUMENTS" ("ARG_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" ADD CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK2" FOREIGN KEY ("UTI_ID") REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK1";
ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK2";
ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK1" FOREIGN KEY ("UTI_ID") REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK2" FOREIGN KEY ("ARG_ID") REFERENCES "UT_TEST_ARGUMENTS" ("ARG_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_IMPL_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK1";
ALTER TABLE "UT_TEST_IMPL_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK2";
ALTER TABLE "UT_TEST_IMPL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK1" FOREIGN KEY ("UTI_ID") REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_IMPL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK2" FOREIGN KEY ("UTR_ID") REFERENCES "UT_TEST_RESULTS" ("UTR_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_COVERAGE_STATS" DROP CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK1";
ALTER TABLE "UT_TEST_COVERAGE_STATS" DROP CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK2";
ALTER TABLE "UT_TEST_COVERAGE_STATS" ADD CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK1" FOREIGN KEY ("UTI_ID")  REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_COVERAGE_STATS" ADD CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK2" FOREIGN KEY ("UTIR_ID") REFERENCES "UT_TEST_IMPL_RESULTS" ("UTIR_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_RESULTS" DROP CONSTRAINT "UT_TEST_RESULTS_UT_TEST_FK1";
ALTER TABLE "UT_TEST_RESULTS" ADD CONSTRAINT "UT_TEST_RESULTS_UT_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK1";
ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK2";
ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" DROP CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK3";
ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK1" FOREIGN KEY ("VAL_ID") REFERENCES "UT_VALIDATIONS" ("VALIDATION_ID") ON DELETE CASCADE ENABLE; 
ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK2" FOREIGN KEY ("UTI_ID") REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
ALTER TABLE "UT_TEST_IMPL_VAL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK3" FOREIGN KEY ("UTIR_ID") REFERENCES "UT_TEST_IMPL_RESULTS" ("UTIR_ID") ON DELETE CASCADE ENABLE;

CREATE TABLE "UT_STARTUPS"
  (
    "STARTUP_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UT_ID"        VARCHAR2(40) ,
    "UT_SID"        VARCHAR2(40) ,
    "INDEX_NO"      NUMBER(*,0) NOT NULL ENABLE,
    "STARTUP" CLOB,
    "LIB_STARTUP_ID" VARCHAR2(40),
    "CREATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    CONSTRAINT "UT_STARTUPS_PK" PRIMARY KEY ("STARTUP_ID") ENABLE,
    CONSTRAINT "UT_STARTUPS_CHECK" CHECK ("STARTUP" IS NULL  OR "LIB_STARTUP_ID" IS NULL) ENABLE,
    CONSTRAINT "UT_STARTUPS_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_STARTUPS_SUITE_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_STARTUPS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_STARTUP_ID") REFERENCES "UT_LIB_STARTUPS" ("LIB_STARTUP_ID") ON  DELETE CASCADE ENABLE
  ) ;
  
CREATE OR REPLACE TRIGGER "UT_STARTUPS_TRG" BEFORE
  INSERT ON UT_STARTUPS FOR EACH ROW 
  DECLARE
   BAD_DATA EXCEPTION;
   PRAGMA EXCEPTION_INIT(BAD_DATA, -20201);
  BEGIN 
IF (:NEW.UT_ID IS NULL AND :NEW.UT_SID IS NULL ) THEN
	RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.STARTUP_ID IS NULL OR :NEW.STARTUP_ID = '' ) THEN
  SELECT SYS_GUID() INTO :NEW.STARTUP_ID FROM DUAL;
END IF;
IF (:NEW.CREATED_ON IS NULL OR :NEW.CREATED_ON = '') THEN
  SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
END IF;
IF (:NEW.CREATED_BY IS NULL OR :NEW.CREATED_BY = '') THEN
  SELECT USER INTO :NEW.CREATED_BY FROM DUAL;
END IF;
IF (:NEW.UPDATED_ON IS NULL OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/
CREATE OR REPLACE TRIGGER "UT_STARTUPS_UP_TRG" BEFORE
  UPDATE ON UT_STARTUPS FOR EACH ROW BEGIN IF (:NEW.UPDATED_ON IS NULL
  OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/
--------------------------------------------------------
--  DDL for View ALL_UT_STARTUPS
--------------------------------------------------------

CREATE OR REPLACE VIEW "ALL_UT_STARTUPS" ( 
  "STARTUP_ID", 
  "UT_ID", 
  "UT_SID", 
  "INDEX_NO", 
  "STARTUP", 
  "LIB_STARTUP_ID", 
  "CREATED_ON", 
  "CREATED_BY" )
AS
  SELECT "STARTUP_ID",
    "UT_ID",
    "UT_SID",
    "INDEX_NO",
    "STARTUP",
    "LIB_STARTUP_ID",
    "CREATED_ON",
    "CREATED_BY"
  FROM ut_startups;
  
  COMMENT ON TABLE "ALL_UT_STARTUPS" IS
  'Unit Test - Startup Code Hooks';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."STARTUP_ID" IS
  'Startup Code Hook usage identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."UT_ID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."INDEX_NO" IS
  'Index within list of startups of Test';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."STARTUP" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."LIB_STARTUP_ID" IS
  'Library Startup Code Hook identifier when referencing library object';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."CREATED_BY" IS
  'Created by user';

CREATE TABLE "UT_TEARDOWNS"
  (
    "TEARDOWN_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UT_ID"        VARCHAR2(40),
    "UT_SID"        VARCHAR2(40),
    "INDEX_NO"      NUMBER(*,0) NOT NULL ENABLE,
    "TEARDOWN" CLOB,
    "LIB_TEARDOWN_ID" VARCHAR2(40),
    "CREATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    CONSTRAINT "UT_TEARDOWNS_PK" PRIMARY KEY ("TEARDOWN_ID") ENABLE,
    CONSTRAINT "UT_TEARDOWNS_CHECK" CHECK ("TEARDOWN" IS NULL  OR "LIB_TEARDOWN_ID" IS NULL) ENABLE,
    CONSTRAINT "UT_TEARDOWNS_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_TEARDOWNS_SUITE_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_TEARDOWNS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_TEARDOWN_ID") REFERENCES "UT_LIB_TEARDOWNS" ("LIB_TEARDOWN_ID") ON  DELETE CASCADE ENABLE
  ) ;
  
CREATE OR REPLACE TRIGGER "UT_TEARDOWNS_TRG" BEFORE
INSERT ON UT_TEARDOWNS FOR EACH ROW 
DECLARE
 BAD_DATA EXCEPTION;
 PRAGMA EXCEPTION_INIT(BAD_DATA, -20201);
BEGIN 
IF (:NEW.UT_ID IS NULL AND :NEW.UT_SID IS NULL ) THEN
	RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.TEARDOWN_ID IS NULL OR :NEW.TEARDOWN_ID = '') THEN
  SELECT SYS_GUID() INTO :NEW.TEARDOWN_ID FROM DUAL;
END IF;
IF (:NEW.CREATED_ON IS NULL OR :NEW.CREATED_ON = '') THEN
  SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
END IF;
IF (:NEW.CREATED_BY IS NULL OR :NEW.CREATED_BY = '') THEN
  SELECT USER INTO :NEW.CREATED_BY FROM DUAL;
END IF;
IF (:NEW.UPDATED_ON IS NULL OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

CREATE OR REPLACE TRIGGER "UT_TEARDOWNS_UP_TRG" BEFORE
  UPDATE ON UT_TEARDOWNS FOR EACH ROW 
BEGIN 
IF (:NEW.UPDATED_ON IS NULL
  OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

--------------------------------------------------------
--  DDL for View ALL_UT_TEARDOWNS
--------------------------------------------------------

CREATE OR REPLACE VIEW "ALL_UT_TEARDOWNS" ( 
  "TEARDOWN_ID", 
  "UT_ID", 
  "UT_SID", 
  "INDEX_NO", 
  "TEARDOWN", 
  "LIB_TEARDOWN_ID", 
  "CREATED_ON", 
  "CREATED_BY" )
AS
  SELECT "TEARDOWN_ID",
    "UT_ID",
    "UT_SID",
    "INDEX_NO",
    "TEARDOWN",
    "LIB_TEARDOWN_ID",
    "CREATED_ON",
    "CREATED_BY"
  FROM UT_TEARDOWNS;
  
  COMMENT ON TABLE "ALL_UT_TEARDOWNS" IS
  'Unit Test - Teardown Code Hooks';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."TEARDOWN_ID" IS
  'Teardown Code Hook usage identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."UT_ID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."INDEX_NO" IS
  'Index within list of teardowns of Test';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."TEARDOWN" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."LIB_TEARDOWN_ID" IS
  'Library Teardown Code Hook identifier when referencing library object';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."CREATED_BY" IS
  'Created by user';

INSERT INTO UT_STARTUPS
  (
    STARTUP_ID,
    UT_ID,
    UT_SID,
    INDEX_NO,
    STARTUP,
    LIB_STARTUP_ID,
    CREATED_ON,
    CREATED_BY,
    UPDATED_ON,
    UPDATED_BY
  )
   (select null,ut_id,NULL,0,startup,lib_startup_id,null,null,null,null from ut_test where startup is not null or lib_startup_id is not null);
   
INSERT INTO UT_TEARDOWNS
  (
    TEARDOWN_ID,
    UT_ID,
    UT_SID,
    INDEX_NO,
    TEARDOWN,
    LIB_TEARDOWN_ID,
    CREATED_ON,
    CREATED_BY,
    UPDATED_ON,
    UPDATED_BY
  )
   (select null,ut_id,NULL,0,teardown,lib_teardown_id,null,null,null,null from ut_test where teardown is not null or lib_teardown_id is not null);
   
 alter table
   ut_test
drop
   (STARTUP,LIB_STARTUP_ID,TEARDOWN,LIB_TEARDOWN_ID);

INSERT INTO UT_STARTUPS
  (
    STARTUP_ID,
    UT_ID,
    UT_SID,
    INDEX_NO,
    STARTUP,
    LIB_STARTUP_ID,
    CREATED_ON,
    CREATED_BY,
    UPDATED_ON,
    UPDATED_BY
  )
   (select null,NULL,UT_SID,0,startup,lib_startup_id,null,null,null,null from UT_SUITE where startup is not null or lib_startup_id is not null);

	"STARTUP" CLOB,
	"LIB_STARTUP_ID" VARCHAR2(40), 
   
INSERT INTO UT_TEARDOWNS
  (
    TEARDOWN_ID,
    UT_ID,
    UT_SID,
    INDEX_NO,
    TEARDOWN,
    LIB_TEARDOWN_ID,
    CREATED_ON,
    CREATED_BY,
    UPDATED_ON,
    UPDATED_BY
  )
   (select null,NULL,UT_SID,0,teardown,lib_teardown_id,null,null,null,null from UT_SUITE where teardown is not null or lib_teardown_id is not null);
   
 alter table
   UT_SUITE
drop
   (STARTUP,LIB_STARTUP_ID,TEARDOWN,LIB_TEARDOWN_ID);

---------------------------------------------------------
-- CHANGES RELATED TO NESTED SUITES
---------------------------------------------------------

alter table UT_SUITE_TEST drop constraint UT_SUITE_TEST_PK;

begin
    for c in (
            select c.constraint_name from user_cons_columns cc, user_constraints c 
            where 
              c.owner = user and cc.owner = user and 
              c.constraint_name = cc.constraint_name and
              c.table_name = 'UT_SUITE_TEST' and cc.table_name = 'UT_SUITE_TEST' and
              cc.column_name = 'UT_ID' and c.constraint_type = 'C')
    loop
        execute immediate 'alter table UT_SUITE_TEST drop constraint ' || c.constraint_name;
    end loop;
end;
/

alter table UT_SUITE_TEST rename to UT_SUITE_ITEMS;
alter table UT_SUITE_ITEMS add ("UT_NSID" VARCHAR2(40));
alter table UT_SUITE_ITEMS add	CONSTRAINT "UT_SUITE_ITEMS_UK" UNIQUE ("UT_SID", "UT_ID", "UT_NSID") ENABLE; 
alter table UT_SUITE_ITEMS add	CONSTRAINT "UT_SUITE_ITEMS_FK3" FOREIGN KEY ("UT_NSID")
	  REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE;

drop view ALL_UT_SUITE_TEST;

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE_ITEMS"
  (
    "UT_SID"
   ,"UT_ID"
   ,"UT_NSID"
   ,"RUN_START"
   ,"RUN_TEAR"
   ,"SEQUENCE"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "UT_SID" AS "UT_SID"
   ,"UT_ID" AS "UT_ID"
   ,"UT_NSID" AS "UT_NSID"
   ,"RUN_START" AS "RUN_START"
   ,"RUN_TEAR" AS "RUN_TEAR"
   ,"SEQUENCE" AS "SEQUENCE"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_SUITE_ITEMS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE_ITEMS" IS
  'Unit Test - Suite Items';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_SID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_NSID" IS
  'Nested Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."RUN_START" IS
  'Execute Startup Code Hook - Y or N';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."RUN_TEAR" IS
  'Execute Teardown Code Hook - Y or N';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."SEQUENCE" IS
  'Index within test list of Suite';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."CREATED_BY" IS
  'Created by user';

alter table UT_SUITE_TEST_RESULTS drop constraint UT_SUITE_TEST_RESULTS_PK;

begin
    for c in (
            select c.constraint_name from user_cons_columns cc, user_constraints c 
            where 
              c.owner = user and cc.owner = user and 
              c.constraint_name = cc.constraint_name and
              c.table_name = 'UT_SUITE_TEST_RESULTS' and cc.table_name = 'UT_SUITE_TEST_RESULTS' and
              cc.column_name = 'UTR_ID' and c.constraint_type = 'C')
    loop
        execute immediate 'alter table UT_SUITE_TEST_RESULTS drop constraint ' || c.constraint_name;
    end loop;
end;
/

alter table UT_SUITE_TEST_RESULTS rename to UT_SUITE_ITEM_RESULTS;
alter table UT_SUITE_ITEM_RESULTS add ("UTR_NSID" VARCHAR2(40));
alter table UT_SUITE_ITEM_RESULTS add ("SEQUENCE" NUMBER default 0 NOT NULL ENABLE);
alter table UT_SUITE_ITEM_RESULTS add	CONSTRAINT "UT_SUITE_ITEM_RESULTS_UK" UNIQUE ("UTSR_ID","UTR_ID", "UTR_NSID") ENABLE;
alter table UT_SUITE_ITEM_RESULTS add CONSTRAINT "UT_SUITE_ITEM_RESULTS_FK3" FOREIGN KEY ("UTR_NSID") 
    REFERENCES "UT_SUITE_RESULTS" ("UTSR_ID") ON DELETE CASCADE ENABLE;

drop view ALL_UT_SUITE_TEST_RESULTS;

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE_ITEM_RESULTS"
  (
    "UTSR_ID"
   ,"UTR_ID"
   ,"UTR_NSID"
  )
AS
  SELECT
    "UTSR_ID" AS "UTSR_ID"
   ,"UTR_ID" AS "UTR_ID"
   ,"UTR_NSID" AS "UTR_NSID"
  FROM
    "UT_SUITE_ITEM_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE_ITEM_RESULTS" IS
  'Unit Test - Item Results within a Suite';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTSR_ID" IS
  'Suite Result identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTR_ID" IS
  'Test Result identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTR_NSID" IS
  'Nested Suite Result identifier';


---------------------------------------------------------
-- Add in missing foreign keys
---------------------------------------------------------

  ALTER TABLE "UT_SUITE" ADD CONSTRAINT "UT_SUITE_LIB_STARTUPS_FK1" FOREIGN KEY ("LIB_STARTUP_ID")
	  REFERENCES "UT_LIB_STARTUPS" ("LIB_STARTUP_ID") ON DELETE CASCADE ENABLE;

  ALTER TABLE "UT_SUITE" ADD CONSTRAINT "UT_SUITE_LIB_TEARDOWNS_FK1" FOREIGN KEY ("LIB_TEARDOWN_ID")
	  REFERENCES "UT_LIB_TEARDOWNS" ("LIB_TEARDOWN_ID") ON DELETE CASCADE ENABLE;

---------------------------------------------------------
-- Add in missing indexes
---------------------------------------------------------

CREATE INDEX "UT_LOOKUP_DTS_CAT_ID_IX" ON "UT_LOOKUP_DATATYPES" ("CAT_ID");
CREATE INDEX "UT_LOOKUP_VALUES_UT_LOOKU_IX" ON "UT_LOOKUP_VALUES" ("DATA_ID");
CREATE INDEX "UT_SUITE_LIB_STARTUPS_IX" ON "UT_SUITE" ("LIB_STARTUP_ID");
CREATE INDEX "UT_SUITE_LIB_TEARDOWNS_IX" ON "UT_SUITE" ("LIB_TEARDOWN_ID");
CREATE INDEX "UT_SUITE_ITEMS_IX1" ON "UT_SUITE_ITEMS" ("UT_SID");
CREATE INDEX "UT_SUITE_ITEMS_IX2" ON "UT_SUITE_ITEMS" ("UT_NSID");
CREATE INDEX "UT_SUITE_ITEMS_IX3" ON "UT_SUITE_ITEMS" ("UT_ID");
CREATE INDEX "UT_SUITE_RESULTS_IX" ON "UT_SUITE_RESULTS" ("UT_SID");
CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK1" ON "UT_SUITE_ITEM_RESULTS" ("UTSR_ID");
CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK2" ON "UT_SUITE_ITEM_RESULTS" ("UTR_ID");
CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK3" ON "UT_SUITE_ITEM_RESULTS" ("UTR_NSID");
CREATE INDEX "UT_STARTUPS_TEST_IX" ON "UT_STARTUPS" ("UT_ID");
CREATE INDEX "UT_STARTUPS_SUITE_IX" ON "UT_STARTUPS" ("UT_SID");
CREATE INDEX "UT_STARTUPS_LIB_VALIDN_IX" ON "UT_STARTUPS" ("LIB_STARTUP_ID");
CREATE INDEX "UT_TEARDOWNS_TEST_IX" ON "UT_TEARDOWNS" ("UT_ID");
CREATE INDEX "UT_TEARDOWNS_SUITE_IX" ON "UT_TEARDOWNS" ("UT_SID");
CREATE INDEX "UT_TEARDOWNS_LIB_VALIDN_IX" ON "UT_TEARDOWNS" ("LIB_TEARDOWN_ID");
CREATE INDEX "UT_TEST_ARGUMENTS_IX" ON "UT_TEST_ARGUMENTS" ("UT_ID");
CREATE INDEX "UT_TEST_LIB_STARTUPS_IX" ON "UT_TEST" ("LIB_STARTUP_ID");
CREATE INDEX "UT_TEST_LIB_TEARDOWNS_IX" ON "UT_TEST" ("LIB_TEARDOWN_ID");
CREATE INDEX "UT_TEST_IMPL_UT_TEST_IX" ON "UT_TEST_IMPL" ("UT_ID");
CREATE INDEX "UT_TEST_LIB_DYN_QUERIES_IX" ON "UT_TEST_IMPL" ("LIB_DYN_QUERY_ID");
CREATE INDEX "UT_VALIDATIONS_TEST_IMPL_IX" ON "UT_VALIDATIONS" ("UTI_ID");
CREATE INDEX "UT_VALIDATIONS_LIB_VALIDN_IX" ON "UT_VALIDATIONS" ("LIB_VALIDATION_ID");
CREATE INDEX "UT_TEST_IMPL_ARGUMENTS_UT_IX1" ON "UT_TEST_IMPL_ARGUMENTS" ("ARG_ID");
CREATE INDEX "UT_TEST_IMPL_ARGUMENTS_UT_IX2" ON "UT_TEST_IMPL_ARGUMENTS" ("UTI_ID");
CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX1" ON "UT_TEST_IMPL_ARG_RESULTS" ("UTI_ID"); 
CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX2" ON "UT_TEST_IMPL_ARG_RESULTS" ("ARG_ID");
CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX3" ON "UT_TEST_IMPL_ARG_RESULTS" ("UTIR_ID");
CREATE INDEX "UT_TEST_IMPL_RESULTS_UT_T_IX1" ON "UT_TEST_IMPL_RESULTS" ("UTI_ID"); 
CREATE INDEX "UT_TEST_IMPL_RESULTS_UT_T_IX2" ON "UT_TEST_IMPL_RESULTS" ("UTR_ID");
CREATE INDEX "UT_TEST_COV_STATS_UT_T_IX1" ON "UT_TEST_COVERAGE_STATS" ("UTI_ID"); 
CREATE INDEX "UT_TEST_COV_STATS_UT_T_IX2" ON "UT_TEST_COVERAGE_STATS" ("UTIR_ID");
CREATE INDEX "UT_TEST_RESULTS_UT_TEST_IX1" ON "UT_TEST_RESULTS" ("UT_ID");
CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX1" ON UT_TEST_IMPL_VAL_RESULTS ("VAL_ID");
CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX2" ON UT_TEST_IMPL_VAL_RESULTS ("UTI_ID");
CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX3" ON UT_TEST_IMPL_VAL_RESULTS ("UTIR_ID");

---------------------------------------------------------
-- FINALLY UPDATE METADATA IF EVERYTHING RUNS
---------------------------------------------------------

UPDATE "UT_METADATA" SET VALUE = '20' WHERE NAME = 'VERSION';
COMMIT; 
