--------------------------------------------------------
--  File created - Monday-January-12-2009   
--------------------------------------------------------

--------------------------------------------------------
--  DDL for Table UT_LOOKUP_CATEGORIES
--------------------------------------------------------

 CREATE TABLE "UT_LOOKUP_CATEGORIES" 
   (    
    "ID" VARCHAR2(40) NOT NULL ENABLE, 
    "NAME" VARCHAR2(120), 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LOOKUP_CATEGORIES_PK" PRIMARY KEY ("ID") ENABLE, 
     CONSTRAINT "UT_LOOKUP_CATEGORIES_UK1" UNIQUE ("NAME") ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_LOOKUP_DATATYPES
--------------------------------------------------------

 CREATE TABLE "UT_LOOKUP_DATATYPES" 
   (    
    "ID" VARCHAR2(40) NOT NULL ENABLE, 
    "CAT_ID" VARCHAR2(40), 
    "TYPE_ID" NUMBER, 
    "TYPE_STRING" VARCHAR2(120), 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LOOKUP_DATATYPES_PK" PRIMARY KEY ("ID") ENABLE, 
     CONSTRAINT "UT_LOOKUP_DATATYPES_UK1" UNIQUE ("CAT_ID", "TYPE_STRING") ENABLE, 
     CONSTRAINT "UT_LOOKUP_DATATYPES_UT_LO_FK1" FOREIGN KEY ("CAT_ID") REFERENCES "UT_LOOKUP_CATEGORIES" ("ID") ON DELETE CASCADE ENABLE
   ) ;
   
CREATE INDEX "UT_LOOKUP_DTS_CAT_ID_IX" ON "UT_LOOKUP_DATATYPES" ("CAT_ID");

--------------------------------------------------------
--  DDL for Table UT_LOOKUP_VALUES
--------------------------------------------------------

  CREATE TABLE "UT_LOOKUP_VALUES" 
   (    
    "ID" VARCHAR2(40) NOT NULL ENABLE, 
    "DATA_ID" VARCHAR2(40), 
    "VALUE" CLOB, 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LOOKUP_VALUES_PK" PRIMARY KEY ("ID") ENABLE, 
     CONSTRAINT "UT_LOOKUP_VALUES_UT_LOOKU_FK1" FOREIGN KEY ("DATA_ID") REFERENCES "UT_LOOKUP_DATATYPES" ("ID") ON DELETE CASCADE ENABLE
   ) ;

CREATE INDEX "UT_LOOKUP_VALUES_UT_LOOKU_IX" ON "UT_LOOKUP_VALUES" ("DATA_ID");

--------------------------------------------------------
--  DDL for Table UT_METADATA
--------------------------------------------------------

  CREATE TABLE "UT_METADATA" 
   (    
    "NAME" VARCHAR2(120), 
    "VALUE" VARCHAR2(2000)
   ) ;
--------------------------------------------------------
--  DDL for Table UT_TEST
--------------------------------------------------------

  CREATE TABLE "UT_TEST" 
   (    
    "UT_ID" VARCHAR2(40), 
    "NAME" VARCHAR2(120), 
    "OBJECT_NAME" VARCHAR2(120), 
    "OBJECT_TYPE" VARCHAR2(120), 
    "OBJECT_OWNER" VARCHAR2(120), 
    "OBJECT_CALL" VARCHAR2(120), 
    "CONNECTION_NAME" VARCHAR2(120),
    "COVERAGE" NUMBER(1),
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_TEST_PK" PRIMARY KEY ("UT_ID") ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table UT_TEST_ARGUMENTS
--------------------------------------------------------

  CREATE TABLE "UT_TEST_ARGUMENTS" 
   (    
    "ARG_ID" VARCHAR2(40), 
    "UT_ID" VARCHAR2(40), 
    "OWNER" VARCHAR2(30), 
    "OBJECT_NAME" VARCHAR2(30), 
    "PACKAGE_NAME" VARCHAR2(30), 
    "OBJECT_ID" NUMBER, 
    "OVERLOAD" VARCHAR2(40), 
    "ARGUMENT_NAME" VARCHAR2(30), 
    "POSITION" NUMBER, 
    "SEQUENCE" NUMBER, 
    "DATA_LEVEL" NUMBER, 
    "DATA_TYPE" VARCHAR2(30), 
    "DEFAULT_LENGTH" NUMBER, 
    "IN_OUT" VARCHAR2(9), 
    "DATA_LENGTH" NUMBER, 
    "DATA_PRECISION" NUMBER, 
    "DATA_SCALE" NUMBER, 
    "RADIX" NUMBER, 
    "CHARACTER_SET_NAME" VARCHAR2(44), 
    "TYPE_OWNER" VARCHAR2(30), 
    "TYPE_NAME" VARCHAR2(30), 
    "TYPE_SUBNAME" VARCHAR2(30), 
    "TYPE_LINK" VARCHAR2(128), 
    "PLS_TYPE" VARCHAR2(30), 
    "CHAR_LENGTH" NUMBER, 
    "CHAR_USED" VARCHAR2(1),
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;
--------------------------------------------------------
--  DDL for Table UT_TEST_IMPL
--------------------------------------------------------

  CREATE TABLE "UT_TEST_IMPL" 
   (    
    "UTI_ID" VARCHAR2(40), 
    "UT_ID" VARCHAR2(40), 
    "NAME" VARCHAR2(120), 
    "EXPECTED_RETURN" VARCHAR2(20), 
    "EXPECTED_RETURN_ERROR" VARCHAR2(200), 
    "DYNAMIC_VALUE_QUERY" CLOB,
    "LIB_DYN_QUERY_ID" VARCHAR2(40),
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table UT_VALIDATIONS
--------------------------------------------------------

  CREATE TABLE "UT_VALIDATIONS" 
   (    
    "VALIDATION_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "UTI_ID" VARCHAR2(40) NOT NULL ENABLE,  
    "INDEX_NO" INTEGER NOT NULL ENABLE,
    "VALIDATION" CLOB, 
    "LIB_VALIDATION_ID" VARCHAR2(40),
    "APPLY_VALIDATION" NUMBER(1) DEFAULT 1 NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;
 
--------------------------------------------------------
--  DDL for Table UT_TEST_IMPL_ARGUMENTS
--------------------------------------------------------

  CREATE TABLE "UT_TEST_IMPL_ARGUMENTS" 
   (    
    "UTI_ID" VARCHAR2(40), 
    "ARG_ID" VARCHAR2(40), 
    "INPUT_VALUE" CLOB,
    "OUTPUT_VALUE" CLOB,
    "TEST_OUTVAL" NUMBER(1),
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_LIB_STARTUPS
--------------------------------------------------------

    CREATE TABLE "UT_LIB_STARTUPS"
    (
    "LIB_STARTUP_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "LIB_STARTUP_NAME" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_STARTUP_CLASS" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_STARTUP" CLOB NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LIB_STARTUPS_PK" PRIMARY KEY ("LIB_STARTUP_ID") ENABLE,
     CONSTRAINT "UT_LIB_STARTUPS_NAME" UNIQUE ("LIB_STARTUP_NAME") ENABLE
    );

--------------------------------------------------------
--  DDL for Table UT_LIB_TEARDOWNS
--------------------------------------------------------

    CREATE TABLE "UT_LIB_TEARDOWNS"
    (
    "LIB_TEARDOWN_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "LIB_TEARDOWN_NAME" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_TEARDOWN_CLASS" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_TEARDOWN" CLOB NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LIB_TEARDOWNS_PK" PRIMARY KEY ("LIB_TEARDOWN_ID") ENABLE,
     CONSTRAINT "UT_LIB_TEARDOWNS_NAME" UNIQUE ("LIB_TEARDOWN_NAME") ENABLE
    );

--------------------------------------------------------
--  DDL for Table UT_LIB_VALIDATIONS
--------------------------------------------------------

    CREATE TABLE "UT_LIB_VALIDATIONS"
    (
    "LIB_VALIDATION_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "LIB_VALIDATION_NAME" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_VALIDATION_CLASS" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_VALIDATION" CLOB NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LIB_VALIDATIONS_PK" PRIMARY KEY ("LIB_VALIDATION_ID") ENABLE,
     CONSTRAINT "UT_LIB_VALIDATIONS_NAME" UNIQUE ("LIB_VALIDATION_NAME") ENABLE
    );

--------------------------------------------------------
--  DDL for Table UT_LIB_DYN_QUERIES
--------------------------------------------------------

    CREATE TABLE "UT_LIB_DYN_QUERIES"
    (
    "LIB_DYN_QUERY_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "LIB_DYN_QUERY_NAME" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_DYN_QUERY_CLASS" VARCHAR2(120) NOT NULL ENABLE,
    "LIB_DYN_QUERY" CLOB NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_LIB_DYN_QUERIES_PK" PRIMARY KEY ("LIB_DYN_QUERY_ID") ENABLE,
     CONSTRAINT "UT_LIB_DYN_QUERIES_NAME" UNIQUE ("LIB_DYN_QUERY_NAME") ENABLE
    );

--------------------------------------------------------
--  DDL for Table UT_SUITE
--------------------------------------------------------

CREATE TABLE "UT_SUITE" 
   (    
    "UT_SID" VARCHAR2(40) NOT NULL ENABLE, 
    "COVERAGE" NUMBER(1),
    "NAME" VARCHAR2(120) NOT NULL ENABLE, 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_SUITE_PK" PRIMARY KEY ("UT_SID") ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_SUITE_ITEMS
--------------------------------------------------------

CREATE TABLE "UT_SUITE_ITEMS" 
   (    
    "UT_SID" VARCHAR2(40) NOT NULL ENABLE, 
    "UT_ID" VARCHAR2(40),
    "UT_NSID" VARCHAR2(40),
    "RUN_START" VARCHAR2(1) NOT NULL ENABLE, 
    "RUN_TEAR" VARCHAR2(1) NOT NULL ENABLE, 
    "SEQUENCE" NUMBER NOT NULL ENABLE, 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_SUITE_ITEMS_UK" UNIQUE ("UT_SID", "UT_ID", "UT_NSID") ENABLE, 
     CONSTRAINT "UT_SUITE_ITEMS_FK1" FOREIGN KEY ("UT_SID")
      REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE, 
     CONSTRAINT "UT_SUITE_ITEMS_FK2" FOREIGN KEY ("UT_ID")
      REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE,
     CONSTRAINT "UT_SUITE_ITEMS_FK3" FOREIGN KEY ("UT_NSID")
      REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE
   ) ;

CREATE INDEX "UT_SUITE_ITEMS_IX1" ON "UT_SUITE_ITEMS" ("UT_SID");
CREATE INDEX "UT_SUITE_ITEMS_IX2" ON "UT_SUITE_ITEMS" ("UT_NSID");
CREATE INDEX "UT_SUITE_ITEMS_IX3" ON "UT_SUITE_ITEMS" ("UT_ID");

--------------------------------------------------------
--  DDL for Table UT_TEST_IMPL_VAL_RESULTS
--------------------------------------------------------
  CREATE TABLE "UT_TEST_IMPL_VAL_RESULTS" 
   (
    "UTIVR_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "UTIR_ID" VARCHAR2(40), 
    "UTI_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "VAL_ID" VARCHAR2(40) NOT NULL ENABLE, 
    "VAL_TYPE" VARCHAR2(40) NOT NULL ENABLE, 
    "STATUS" VARCHAR2(20) NOT NULL ENABLE, 
    "MESSAGE" VARCHAR2(2000), 
    "VAL_START_TIME" VARCHAR2(20),
    "VAL_END_TIME" VARCHAR2(20),
    "VAL_DURATION" NUMBER,
    "RUN_DATE" TIMESTAMP,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_TEST_IMPL_VAL_RES_PK" PRIMARY KEY ("UTIVR_ID") ENABLE 
   ) ;

--------------------------------------------------------
--  DDL for Table UT_TEST_IMPL_ARG_RESULTS
--------------------------------------------------------
  CREATE TABLE "UT_TEST_IMPL_ARG_RESULTS" 
   (
    "UTIAR_ID" VARCHAR2(40), 
    "UTIR_ID" VARCHAR2(40), 
    "UTI_ID" VARCHAR2(40), 
    "ARG_ID" VARCHAR2(40),
    "NAME" VARCHAR2(120), 
    "STATUS" VARCHAR2(20), 
    "MESSAGE" VARCHAR2(2000), 
    "RUN_DATE" TIMESTAMP,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_TEST_IMPL_RESULTS
--------------------------------------------------------
  CREATE TABLE "UT_TEST_IMPL_RESULTS" 
   (
    "UTIR_ID" VARCHAR2(40), 
    "UTI_ID" VARCHAR2(40), 
    "UTR_ID" VARCHAR2(40), 
    "NAME" VARCHAR2(120), 
    "STATUS" VARCHAR2(20), 
    "MESSAGE" VARCHAR2(2000), 
    "START_TIME" VARCHAR2(20),
    "END_TIME" VARCHAR2(20),
    "DURATION" NUMBER,
    "STARTUP_STATUS" VARCHAR2(20), 
    "STARTUP_MESSAGE" VARCHAR2(2000), 
    "STARTUP_START_TIME" VARCHAR2(20),
    "STARTUP_END_TIME" VARCHAR2(20),
    "STARTUP_DURATION" NUMBER,
    "OP_CALL_STATUS" VARCHAR2(20), 
    "OP_CALL_MESSAGE" VARCHAR2(2000), 
    "OP_CALL_START_TIME" VARCHAR2(20),
    "OP_CALL_END_TIME" VARCHAR2(20),
    "OP_CALL_DURATION" NUMBER,
    "TEARDOWN_STATUS" VARCHAR2(20), 
    "TEARDOWN_MESSAGE" VARCHAR2(2000), 
    "TEARDOWN_START_TIME" VARCHAR2(20),
    "TEARDOWN_END_TIME" VARCHAR2(20),
    "TEARDOWN_DURATION" NUMBER,
    "RUN_DATE" TIMESTAMP,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_TEST_COVERAGE_STATS
--------------------------------------------------------
  CREATE TABLE "UT_TEST_COVERAGE_STATS" 
   (
    "UTC_ID" VARCHAR2(40), 
    "UTIR_ID" VARCHAR2(40), 
    "UTI_ID" VARCHAR2(40), 
    "UNIT_OWNER" VARCHAR2(30), 
    "UNIT_NAME" VARCHAR2(30), 
    "LINE" NUMBER,
    "TOTAL_OCCUR" NUMBER,
    "TOTAL_TIME" NUMBER,
    "TEXT" VARCHAR2(4000),
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_TEST_RESULTS
--------------------------------------------------------
  CREATE TABLE "UT_TEST_RESULTS" 
   (
    "UTR_ID" VARCHAR2(40),      
    "UT_ID" VARCHAR2(40), 
    "NAME" VARCHAR2(120), 
    "STATUS" VARCHAR2(20), 
    "MESSAGE" VARCHAR2(2000),
    "COVERAGE" NUMBER(1) NOT NULL,
    "TEST_USER_NAME" VARCHAR2(120),
    "CONNECTION_NAME" VARCHAR2(120),
    "RUN_DATE" TIMESTAMP,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_TEST_RESULTS_PK" PRIMARY KEY ("UTR_ID") ENABLE
   ) ;

--------------------------------------------------------
--  DDL for Table UT_SUITE_RESULTS
--------------------------------------------------------

  CREATE TABLE "UT_SUITE_RESULTS" 
   (
    "UTSR_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UT_SID" VARCHAR2(40) NOT NULL ENABLE, 
    "NAME" VARCHAR2(120) NOT NULL ENABLE, 
    "STATUS" VARCHAR2(20) NOT NULL ENABLE, 
    "MESSAGE" VARCHAR2(2000), 
    "STARTUP_STATUS" VARCHAR2(20), 
    "STARTUP_MESSAGE" VARCHAR2(2000), 
    "STARTUP_START_TIME" VARCHAR2(20),
    "STARTUP_END_TIME" VARCHAR2(20),
    "STARTUP_DURATION" NUMBER,
    "TEARDOWN_STATUS" VARCHAR2(20), 
    "TEARDOWN_MESSAGE" VARCHAR2(2000), 
    "TEARDOWN_START_TIME" VARCHAR2(20),
    "TEARDOWN_END_TIME" VARCHAR2(20),
    "TEARDOWN_DURATION" NUMBER,
    "COVERAGE" NUMBER(1) NOT NULL,
    "RUN_DATE" TIMESTAMP NOT NULL ENABLE,
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
     CONSTRAINT "UT_SUITE_RESULTS_PK" PRIMARY KEY ("UTSR_ID") ENABLE, 
     CONSTRAINT "UT_SUITE_RESULTS_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON DELETE CASCADE ENABLE 
   ) ;

CREATE INDEX "UT_SUITE_RESULTS_IX" ON "UT_SUITE_RESULTS" ("UT_SID");
   
--------------------------------------------------------
--  DDL for Table UT_SUITE_ITEM_RESULTS
--------------------------------------------------------

  CREATE TABLE "UT_SUITE_ITEM_RESULTS" 
   (
    "UTSR_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UTR_ID" VARCHAR2(40),
    "UTR_NSID" VARCHAR2(40),
    "SEQUENCE" NUMBER NOT NULL ENABLE, 
    "CREATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP NOT NULL ENABLE, 
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    CONSTRAINT "UT_SUITE_ITEM_RESULTS_UK" UNIQUE ("UTSR_ID","UTR_ID", "UTR_NSID") ENABLE, 
    CONSTRAINT "UT_SUITE_ITEM_RESULTS_FK1" FOREIGN KEY ("UTSR_ID") REFERENCES "UT_SUITE_RESULTS" ("UTSR_ID") ON DELETE CASCADE ENABLE, 
    CONSTRAINT "UT_SUITE_ITEM_RESULTS_FK2" FOREIGN KEY ("UTR_ID") REFERENCES "UT_TEST_RESULTS" ("UTR_ID") ON DELETE CASCADE ENABLE,
    CONSTRAINT "UT_SUITE_ITEM_RESULTS_FK3" FOREIGN KEY ("UTR_NSID") REFERENCES "UT_SUITE_RESULTS" ("UTSR_ID") ON DELETE CASCADE ENABLE 
   ) ;

CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK1" ON "UT_SUITE_ITEM_RESULTS" ("UTSR_ID");
CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK2" ON "UT_SUITE_ITEM_RESULTS" ("UTR_ID");
CREATE INDEX "UT_SUITE_ITEM_RESULTS_FK3" ON "UT_SUITE_ITEM_RESULTS" ("UTR_NSID");

--------------------------------------------------------
--  DDL for Table UT_STARTUPS
--------------------------------------------------------
CREATE TABLE "UT_STARTUPS"
  (
    "STARTUP_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UT_ID"        VARCHAR2(40) ,
    "UT_SID"        VARCHAR2(40) ,
    "INDEX_NO"      NUMBER(*,0) NOT NULL ENABLE,
    "STARTUP" CLOB,
    "LIB_STARTUP_ID" VARCHAR2(40),
    "CREATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    CONSTRAINT "UT_STARTUPS_PK" PRIMARY KEY ("STARTUP_ID") ENABLE,
    CONSTRAINT "UT_STARTUPS_CHECK" CHECK ("STARTUP" IS NULL  OR "LIB_STARTUP_ID" IS NULL) ENABLE,
    CONSTRAINT "UT_STARTUPS_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_STARTUPS_SUITE_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_STARTUPS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_STARTUP_ID") REFERENCES "UT_LIB_STARTUPS" ("LIB_STARTUP_ID") ON  DELETE CASCADE ENABLE
  ) ;

CREATE INDEX "UT_STARTUPS_TEST_IX" ON "UT_STARTUPS" ("UT_ID");
CREATE INDEX "UT_STARTUPS_SUITE_IX" ON "UT_STARTUPS" ("UT_SID");
CREATE INDEX "UT_STARTUPS_LIB_VALIDN_IX" ON "UT_STARTUPS" ("LIB_STARTUP_ID");
  
--------------------------------------------------------
--  DDL for Table UT_TEARDOWNS
--------------------------------------------------------
CREATE TABLE "UT_TEARDOWNS"
  (
    "TEARDOWN_ID" VARCHAR2(40) NOT NULL ENABLE,
    "UT_ID"        VARCHAR2(40),
    "UT_SID"        VARCHAR2(40),
    "INDEX_NO"      NUMBER(*,0) NOT NULL ENABLE,
    "TEARDOWN" CLOB,
    "LIB_TEARDOWN_ID" VARCHAR2(40),
    "CREATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "CREATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    "UPDATED_ON" TIMESTAMP (6) NOT NULL ENABLE,
    "UPDATED_BY" VARCHAR2(120) NOT NULL ENABLE,
    CONSTRAINT "UT_TEARDOWNS_PK" PRIMARY KEY ("TEARDOWN_ID") ENABLE,
    CONSTRAINT "UT_TEARDOWNS_CHECK" CHECK ("TEARDOWN" IS NULL  OR "LIB_TEARDOWN_ID" IS NULL) ENABLE,
    CONSTRAINT "UT_TEARDOWNS_TEST_FK1" FOREIGN KEY ("UT_ID") REFERENCES "UT_TEST" ("UT_ID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_TEARDOWNS_SUITE_FK1" FOREIGN KEY ("UT_SID") REFERENCES "UT_SUITE" ("UT_SID") ON  DELETE CASCADE ENABLE,
    CONSTRAINT "UT_TEARDOWNS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_TEARDOWN_ID") REFERENCES "UT_LIB_TEARDOWNS" ("LIB_TEARDOWN_ID") ON  DELETE CASCADE ENABLE
  ) ;

CREATE INDEX "UT_TEARDOWNS_TEST_IX" ON "UT_TEARDOWNS" ("UT_ID");
CREATE INDEX "UT_TEARDOWNS_SUITE_IX" ON "UT_TEARDOWNS" ("UT_SID");
CREATE INDEX "UT_TEARDOWNS_LIB_VALIDN_IX" ON "UT_TEARDOWNS" ("LIB_TEARDOWN_ID");
    
--------------------------------------------------------
--  Constraints for Table UT_TEST_ARGUMENTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("ARG_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("OWNER" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("OBJECT_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("POSITION" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("SEQUENCE" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" MODIFY ("DATA_LEVEL" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_ARGUMENTS" ADD CONSTRAINT "UT_TEST_ARGUMENTS_PK" PRIMARY KEY ("ARG_ID") ENABLE;

--------------------------------------------------------
--  Constraints for Table UT_TEST_IMPL_RESULTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("UTIR_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("UTI_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("UTR_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("STATUS" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" MODIFY ("RUN_DATE" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_RESULTS_PK" PRIMARY KEY ("UTIR_ID") ENABLE;


--------------------------------------------------------
--  Constraints for Table UT_TEST_COVERAGE_STATS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_COVERAGE_STATS" ADD CONSTRAINT "UT_TEST_COVERAGE_STATS_PK" PRIMARY KEY ("UTC_ID") ENABLE;

--------------------------------------------------------
--  Constraints for Table UT_TEST_RESULTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_RESULTS" MODIFY ("UTR_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_RESULTS" MODIFY ("UT_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_RESULTS" MODIFY ("NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_RESULTS" MODIFY ("STATUS" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_RESULTS" MODIFY ("RUN_DATE" NOT NULL ENABLE);
 
--------------------------------------------------------
--  Constraints for Table UT_TEST_IMPL
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL" MODIFY ("UT_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL" MODIFY ("NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_IMPL_PK" PRIMARY KEY ("UTI_ID") ENABLE;
 
  ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_IMPL_UK1" UNIQUE ("UT_ID", "NAME") ENABLE;

  ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_DYN_QUERY_CHECK" CHECK ("DYNAMIC_VALUE_QUERY" IS NULL OR "LIB_DYN_QUERY_ID" IS NULL);

--------------------------------------------------------
--  Constraints for Table UT_VALIDATIONS
--------------------------------------------------------

  ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_PK" PRIMARY KEY ("VALIDATION_ID") ENABLE;
 
  --ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_UK1" UNIQUE ("UTI_ID", "INDEX_NO") ENABLE;

  ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_CHECK" CHECK ("VALIDATION" IS NULL OR "LIB_VALIDATION_ID" IS NULL);


--------------------------------------------------------
--  Constraints for Table UT_METADATA
--------------------------------------------------------

  ALTER TABLE "UT_METADATA" MODIFY ("NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_METADATA" MODIFY ("VALUE" NOT NULL ENABLE);
 
  ALTER TABLE "UT_METADATA" ADD CONSTRAINT "UT_METADATA_PK" PRIMARY KEY ("NAME") ENABLE;
--------------------------------------------------------
--  Constraints for Table UT_TEST
--------------------------------------------------------

  ALTER TABLE "UT_TEST" MODIFY ("UT_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST" MODIFY ("NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST" MODIFY ("OBJECT_NAME" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST" MODIFY ("OBJECT_TYPE" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST" MODIFY ("OBJECT_OWNER" NOT NULL ENABLE);

  ALTER TABLE "UT_TEST" ADD CONSTRAINT "UT_TEST_UK1" UNIQUE ("NAME") ENABLE;
  
--------------------------------------------------------
--  Constraints for Table UT_TEST_IMPL_ARG_RESULTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" MODIFY ("UTIAR_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" MODIFY ("UTI_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" MODIFY ("ARG_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" MODIFY ("RUN_DATE" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" MODIFY ("STATUS" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS_PK" PRIMARY KEY ("UTIAR_ID") ENABLE;
--------------------------------------------------------
--  Constraints for Table UT_TEST_IMPL_ARGUMENTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" MODIFY ("UTI_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" MODIFY ("ARG_ID" NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" MODIFY ("TEST_OUTVAL" DEFAULT 1 NOT NULL ENABLE);
 
  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" ADD CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_PK" PRIMARY KEY ("UTI_ID", "ARG_ID") ENABLE;

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_ARGUMENTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_ARGUMENTS" ADD CONSTRAINT "UT_TEST_ARGUMENTS_FK" FOREIGN KEY ("UT_ID")
      REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_ARGUMENTS_IX" ON "UT_TEST_ARGUMENTS" ("UT_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST
--------------------------------------------------------

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_IMPL
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_IMPL_UT_TEST_FK1" FOREIGN KEY ("UT_ID")
      REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

  ALTER TABLE "UT_TEST_IMPL" ADD CONSTRAINT "UT_TEST_LIB_DYN_QUERIES_FK1" FOREIGN KEY ("LIB_DYN_QUERY_ID")
      REFERENCES "UT_LIB_DYN_QUERIES" ("LIB_DYN_QUERY_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_IMPL_UT_TEST_IX" ON "UT_TEST_IMPL" ("UT_ID");

CREATE INDEX "UT_TEST_LIB_DYN_QUERIES_IX" ON "UT_TEST_IMPL" ("LIB_DYN_QUERY_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_VALIDATIONS
--------------------------------------------------------

  ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_TEST_IMPL_FK1" FOREIGN KEY ("UTI_ID")
      REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;

  ALTER TABLE "UT_VALIDATIONS" ADD CONSTRAINT "UT_VALIDATIONS_LIB_VALIDN_FK1" FOREIGN KEY ("LIB_VALIDATION_ID")
      REFERENCES "UT_LIB_VALIDATIONS" ("LIB_VALIDATION_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_VALIDATIONS_TEST_IMPL_IX" ON "UT_VALIDATIONS" ("UTI_ID");

CREATE INDEX "UT_VALIDATIONS_LIB_VALIDN_IX" ON "UT_VALIDATIONS" ("LIB_VALIDATION_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_IMPL_ARGUMENTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" ADD CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK1" FOREIGN KEY ("ARG_ID")
      REFERENCES "UT_TEST_ARGUMENTS" ("ARG_ID") ON DELETE CASCADE ENABLE;
 
  ALTER TABLE "UT_TEST_IMPL_ARGUMENTS" ADD CONSTRAINT "UT_TEST_IMPL_ARGUMENTS_UT_FK2" FOREIGN KEY ("UTI_ID")
      REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_IMPL_ARGUMENTS_UT_IX1" ON "UT_TEST_IMPL_ARGUMENTS" ("ARG_ID");

CREATE INDEX "UT_TEST_IMPL_ARGUMENTS_UT_IX2" ON "UT_TEST_IMPL_ARGUMENTS" ("UTI_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_IMPL_ARG_RESULTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK1" FOREIGN KEY ("UTI_ID")
      REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
 
  ALTER TABLE "UT_TEST_IMPL_ARG_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_ARG_RESULTS__FK2" FOREIGN KEY ("ARG_ID")
      REFERENCES "UT_TEST_ARGUMENTS" ("ARG_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX1" ON "UT_TEST_IMPL_ARG_RESULTS" ("UTI_ID");
 
CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX2" ON "UT_TEST_IMPL_ARG_RESULTS" ("ARG_ID");

CREATE INDEX "UT_TEST_IMPL_ARG_RESULTS_IX3" ON "UT_TEST_IMPL_ARG_RESULTS" ("UTIR_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_IMPL_RESULTS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_IMPL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK1" FOREIGN KEY ("UTI_ID")
      REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
 
  ALTER TABLE "UT_TEST_IMPL_RESULTS" ADD CONSTRAINT "UT_TEST_IMPL_RESULTS_UT_T_FK2" FOREIGN KEY ("UTR_ID")
      REFERENCES "UT_TEST_RESULTS" ("UTR_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_IMPL_RESULTS_UT_T_IX1" ON "UT_TEST_IMPL_RESULTS" ("UTI_ID");
 
CREATE INDEX "UT_TEST_IMPL_RESULTS_UT_T_IX2" ON "UT_TEST_IMPL_RESULTS" ("UTR_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_COVERAGE_STATS
--------------------------------------------------------

  ALTER TABLE "UT_TEST_COVERAGE_STATS" ADD CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK1" FOREIGN KEY ("UTI_ID")
      REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
 
  ALTER TABLE "UT_TEST_COVERAGE_STATS" ADD CONSTRAINT "UT_TEST_COV_STATS_UT_T_FK2" FOREIGN KEY ("UTIR_ID")
      REFERENCES "UT_TEST_IMPL_RESULTS" ("UTIR_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_COV_STATS_UT_T_IX1" ON "UT_TEST_COVERAGE_STATS" ("UTI_ID");
 
CREATE INDEX "UT_TEST_COV_STATS_UT_T_IX2" ON "UT_TEST_COVERAGE_STATS" ("UTIR_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_RESULTS
--------------------------------------------------------
  ALTER TABLE "UT_TEST_RESULTS" ADD CONSTRAINT "UT_TEST_RESULTS_UT_TEST_FK1" FOREIGN KEY ("UT_ID")
      REFERENCES "UT_TEST" ("UT_ID") ON DELETE CASCADE ENABLE;

CREATE INDEX "UT_TEST_RESULTS_UT_TEST_IX1" ON "UT_TEST_RESULTS" ("UT_ID");

--------------------------------------------------------
--  Ref Constraints for Table UT_TEST_IMPL_VAL_RESULTS
--------------------------------------------------------
  ALTER TABLE UT_TEST_IMPL_VAL_RESULTS ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK1" FOREIGN KEY ("VAL_ID") 
    REFERENCES "UT_VALIDATIONS" ("VALIDATION_ID") ON DELETE CASCADE ENABLE; 
  ALTER TABLE UT_TEST_IMPL_VAL_RESULTS ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK2" FOREIGN KEY ("UTI_ID") 
    REFERENCES "UT_TEST_IMPL" ("UTI_ID") ON DELETE CASCADE ENABLE;
  ALTER TABLE UT_TEST_IMPL_VAL_RESULTS ADD CONSTRAINT "UT_TEST_IMPL_VAL_RES_FK3" FOREIGN KEY ("UTIR_ID") 
    REFERENCES "UT_TEST_IMPL_RESULTS" ("UTIR_ID") ON DELETE CASCADE ENABLE;
      
CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX1" ON UT_TEST_IMPL_VAL_RESULTS ("VAL_ID");

CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX2" ON UT_TEST_IMPL_VAL_RESULTS ("UTI_ID");

CREATE INDEX "UT_TEST_IMPL_VAL_RES_IX3" ON UT_TEST_IMPL_VAL_RESULTS ("UTIR_ID");

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_CATEGORIES_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_CAT_TRG" 
BEFORE INSERT ON UT_LOOKUP_CATEGORIES
FOR EACH ROW 
BEGIN
  if (:NEW.ID is null or :NEW.ID = '') then
      SELECT  SYS_GUID() INTO :NEW.ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LOOKUP_CAT_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_DATATYPES_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_DATA_TRG" 
BEFORE INSERT ON UT_LOOKUP_DATATYPES
FOR EACH ROW 
BEGIN
  if (:NEW.ID is null or :NEW.ID = '') then
      SELECT  SYS_GUID() INTO :NEW.ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LOOKUP_DATA_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_VALUES_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_VALUE_TRG" 
BEFORE INSERT ON UT_LOOKUP_VALUES
FOR EACH ROW 
BEGIN
  if (:NEW.ID is null or :NEW.ID = '') then
      SELECT  SYS_GUID() INTO :NEW.ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LOOKUP_VALUE_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_ARG_RESULTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_ARG_RESULTS_TRG" 
BEFORE INSERT ON UT_TEST_IMPL_ARG_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UTIAR_ID is null or :NEW.UTIAR_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTIAR_ID FROM DUAL;
  end if;
  if (:NEW.RUN_DATE is null or :NEW.RUN_DATE = '') then 
      SELECT Current_Timestamp INTO :NEW.RUN_DATE FROM DUAL;
  end if;
  if (:NEW.STATUS is null or :NEW.STATUS = '') then 
      :NEW.STATUS := 'RUNNING';
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_IMPL_ARG_RESULTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_RESULTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_RESULTS_TRG" 
BEFORE INSERT ON UT_TEST_IMPL_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UTIR_ID is null or :NEW.UTIR_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTIR_ID FROM DUAL;
  end if;
  if (:NEW.RUN_DATE is null or :NEW.RUN_DATE = '') then 
      SELECT Current_Timestamp INTO :NEW.RUN_DATE FROM DUAL;
  end if;
  if (:NEW.STATUS is null or :NEW.STATUS = '') then 
      :NEW.STATUS := 'RUNNING';
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_IMPL_RESULTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_COVERAGE_STATS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_COVERAGE_STATS_TRG" 
BEFORE INSERT ON UT_TEST_COVERAGE_STATS
FOR EACH ROW 
BEGIN
  if (:NEW.UTC_ID is null or :NEW.UTC_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTC_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_COVERAGE_STATS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_TRG" 
BEFORE INSERT ON UT_TEST_IMPL
FOR EACH ROW 
BEGIN
  if (:NEW.UTI_ID is null or :NEW.UTI_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.UTI_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_IMPL_TRG" ENABLE;


--------------------------------------------------------
--  DDL for Trigger UT_TEST_ARGUMENTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_ARGUMENTS_TRG" 
BEFORE INSERT ON UT_TEST_ARGUMENTS
FOR EACH ROW 
BEGIN
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_ARGUMENTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_ARGUMENTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_ARGUMENTS_TRG" 
BEFORE INSERT ON UT_TEST_IMPL_ARGUMENTS
FOR EACH ROW 
BEGIN
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_IMPL_ARGUMENTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_ITEM_RESULTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_SUITE_ITEM_RESULTS_TRG" 
BEFORE INSERT ON UT_SUITE_ITEM_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_SUITE_ITEM_RESULTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_VALIDATIONS
--------------------------------------------------------

CREATE OR REPLACE TRIGGER "UT_VALIDATIONS_TRG" 
BEFORE INSERT ON UT_VALIDATIONS
FOR EACH ROW 
BEGIN
  if (:NEW.VALIDATION_ID is null or :NEW.VALIDATION_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.VALIDATION_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_VALIDATIONS_TRG" ENABLE;


--------------------------------------------------------
--  DDL for Trigger UT_TEST_RESULTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_RESULTS_TRG" 
BEFORE INSERT ON UT_TEST_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UTR_ID is null or :NEW.UTR_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTR_ID FROM DUAL;
  end if;
  if (:NEW.RUN_DATE is null or :NEW.RUN_DATE = '') then 
      SELECT Current_Timestamp INTO :NEW.RUN_DATE FROM DUAL;
  end if;
  if (:NEW.STATUS is null or :NEW.STATUS = '') then 
      :NEW.STATUS := 'RUNNING';
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_RESULTS_TRG" ENABLE;
--------------------------------------------------------
--  DDL for Trigger UT_SUITE_RESULTS_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_SUITE_RESULTS_TRG" 
BEFORE INSERT ON UT_SUITE_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UTSR_ID is null or :NEW.UTSR_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTSR_ID FROM DUAL;
  end if;
  if (:NEW.RUN_DATE is null or :NEW.RUN_DATE = '') then 
      SELECT Current_Timestamp INTO :NEW.RUN_DATE FROM DUAL;
  end if;
  if (:NEW.STATUS is null or :NEW.STATUS = '') then 
      :NEW.STATUS := 'RUNNING';
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_SUITE_RESULTS_TRG" ENABLE;
--------------------------------------------------------
--  DDL for Trigger UT_TEST_TRG
--------------------------------------------------------

  CREATE OR REPLACE TRIGGER "UT_TEST_TRG" 
BEFORE INSERT ON UT_TEST
FOR EACH ROW 
BEGIN
  if (:NEW.UT_ID is null or :NEW.UT_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UT_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_SUITE_TRG" 
BEFORE INSERT ON UT_SUITE
FOR EACH ROW 
BEGIN
  if (:NEW.UT_SID is null or :NEW.UT_SID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UT_SID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_SUITE_TRG" ENABLE;
--------------------------------------------------------
--  DDL for Trigger UT_SUITE_ITEMS_TRG
--------------------------------------------------------
 CREATE OR REPLACE TRIGGER "UT_SUITE_ITEMS_TRG" 
BEFORE INSERT ON UT_SUITE_ITEMS
FOR EACH ROW 
BEGIN
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_SUITE_ITEMS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LIB_STARTUPS
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_LIB_STARTUPS" 
BEFORE INSERT ON UT_LIB_STARTUPS
FOR EACH ROW 
BEGIN
  if (:NEW.LIB_STARTUP_ID is null or :NEW.LIB_STARTUP_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.LIB_STARTUP_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LIB_STARTUPS" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LIB_TEARDOWNS
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_LIB_TEARDOWNS" 
BEFORE INSERT ON UT_LIB_TEARDOWNS
FOR EACH ROW 
BEGIN
  if (:NEW.LIB_TEARDOWN_ID is null or :NEW.LIB_TEARDOWN_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.LIB_TEARDOWN_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LIB_TEARDOWNS" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LIB_VALIDATIONS
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_LIB_VALIDATIONS" 
BEFORE INSERT ON UT_LIB_VALIDATIONS
FOR EACH ROW 
BEGIN
  if (:NEW.LIB_VALIDATION_ID is null or :NEW.LIB_VALIDATION_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.LIB_VALIDATION_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LIB_VALIDATIONS" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LIB_DYN_QUERIES
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_LIB_DYN_QUERIES" 
BEFORE INSERT ON UT_LIB_DYN_QUERIES
FOR EACH ROW 
BEGIN
  if (:NEW.LIB_DYN_QUERY_ID is null or :NEW.LIB_DYN_QUERY_ID = '') then
      SELECT  SYS_GUID() INTO :NEW.LIB_DYN_QUERY_ID FROM DUAL;
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_LIB_DYN_QUERIES" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_VAL_RESULTS_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_VAL_RESULTS_TRG" 
BEFORE INSERT ON UT_TEST_IMPL_VAL_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UTIVR_ID is null or :NEW.UTIVR_ID = '') then 
      SELECT  SYS_GUID() INTO :NEW.UTIVR_ID FROM DUAL;
  end if;
  if (:NEW.STATUS is null or :NEW.STATUS = '') then 
      :NEW.STATUS := 'RUNNING';
  end if;
  if (:NEW.CREATED_ON is null or :NEW.CREATED_ON = '') then
      SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
  end if;
  if (:NEW.CREATED_BY is null or :NEW.CREATED_BY = '') then
      SELECT user INTO :NEW.CREATED_BY FROM DUAL;
  end if;
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/
ALTER TRIGGER "UT_TEST_IMPL_VAL_RESULTS_TRG" ENABLE;

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_CAT_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_CAT_UP_TRG" 
BEFORE UPDATE ON UT_LOOKUP_CATEGORIES
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_DATATYPES_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_DATATYPES_UP_TRG" 
BEFORE UPDATE ON UT_LOOKUP_DATATYPES
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LOOKUP_VALUES_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LOOKUP_VALUES_UP_TRG" 
BEFORE UPDATE ON UT_LOOKUP_VALUES
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_ARG_RESULTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_ARG_RES_UP_TRG" 
BEFORE UPDATE ON UT_TEST_IMPL_ARG_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_RESULTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_RESULTS_UP_TRG" 
BEFORE UPDATE ON UT_TEST_IMPL_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_COVERAGE_STATS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_COVERAGE_STATS_UP_TRG" 
BEFORE UPDATE ON UT_TEST_COVERAGE_STATS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_UP_TRG" 
BEFORE UPDATE ON UT_TEST_IMPL
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_ARGUMENTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_ARGUMENTS_UP_TRG" 
BEFORE UPDATE ON UT_TEST_ARGUMENTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_ARGUMENTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_ARGUMENTS_UP_TRG" 
BEFORE UPDATE ON UT_TEST_IMPL_ARGUMENTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_ITEM_RESULTS_UP_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_SUITE_ITEM_RESULTS_UP_TRG" 
BEFORE UPDATE ON UT_SUITE_ITEM_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_VALIDATIONS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_VALIDATIONS_UP_TRG" 
BEFORE UPDATE ON UT_VALIDATIONS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_RESULTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_RESULTS_UP_TRG" 
BEFORE UPDATE ON UT_TEST_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_RESULTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_SUITE_RESULTS_UP_TRG" 
BEFORE UPDATE ON UT_SUITE_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_UP_TRG" 
BEFORE UPDATE ON UT_TEST
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_SUITE_UP_TRG" 
BEFORE UPDATE ON UT_SUITE
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_SUITE_ITEMS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_SUITE_ITEMS_UP_TRG" 
BEFORE UPDATE ON UT_SUITE_ITEMS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LIB_STARTUPS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LIB_STARTUPS_UP_TRG" 
BEFORE UPDATE ON UT_LIB_STARTUPS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LIB_TEARDOWNS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LIB_TEARDOWNS_UP_TRG" 
BEFORE UPDATE ON UT_LIB_TEARDOWNS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LIB_VALIDATIONS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LIB_VALIDATIONS_UP_TRG" 
BEFORE UPDATE ON UT_LIB_VALIDATIONS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_LIB_DYN_QUERIES_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_LIB_DYN_QUERIES_UP_TRG" 
BEFORE UPDATE ON UT_LIB_DYN_QUERIES
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEST_IMPL_VAL_RESULTS_UP_TRG
--------------------------------------------------------
  CREATE OR REPLACE TRIGGER "UT_TEST_IMPL_VAL_RES_UP_TRG" 
BEFORE UPDATE ON UT_TEST_IMPL_VAL_RESULTS
FOR EACH ROW 
BEGIN
  if (:NEW.UPDATED_ON is null or :NEW.UPDATED_ON = '') then
      SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
  end if;
  if (:NEW.UPDATED_BY is null or :NEW.UPDATED_BY = '') then
      SELECT user INTO :NEW.UPDATED_BY FROM DUAL;
  end if;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_STARTUPS_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_STARTUPS_TRG" BEFORE
  INSERT ON UT_STARTUPS FOR EACH ROW 
  DECLARE
   BAD_DATA EXCEPTION;
   PRAGMA EXCEPTION_INIT(BAD_DATA, -20201);
  BEGIN 
IF (:NEW.UT_ID IS NULL AND :NEW.UT_SID IS NULL ) THEN
    RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.UT_ID IS NOT NULL AND :NEW.UT_SID IS NOT NULL ) THEN
    RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.STARTUP_ID IS NULL OR :NEW.STARTUP_ID = '' ) THEN
  SELECT SYS_GUID() INTO :NEW.STARTUP_ID FROM DUAL;
END IF;
IF (:NEW.CREATED_ON IS NULL OR :NEW.CREATED_ON = '') THEN
  SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
END IF;
IF (:NEW.CREATED_BY IS NULL OR :NEW.CREATED_BY = '') THEN
  SELECT USER INTO :NEW.CREATED_BY FROM DUAL;
END IF;
IF (:NEW.UPDATED_ON IS NULL OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_STARTUPS_UP_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_STARTUPS_UP_TRG" BEFORE
  UPDATE ON UT_STARTUPS FOR EACH ROW BEGIN IF (:NEW.UPDATED_ON IS NULL
  OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEARDOWNS_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_TEARDOWNS_TRG" BEFORE
INSERT ON UT_TEARDOWNS FOR EACH ROW 
DECLARE
 BAD_DATA EXCEPTION;
 PRAGMA EXCEPTION_INIT(BAD_DATA, -20201);
BEGIN 
IF (:NEW.UT_ID IS NULL AND :NEW.UT_SID IS NULL ) THEN
    RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.UT_ID IS NOT NULL AND :NEW.UT_SID IS NOT NULL ) THEN
    RAISE_APPLICATION_ERROR(-20201, 'Invalid Insert');
END IF;
IF (:NEW.TEARDOWN_ID IS NULL OR :NEW.TEARDOWN_ID = '') THEN
  SELECT SYS_GUID() INTO :NEW.TEARDOWN_ID FROM DUAL;
END IF;
IF (:NEW.CREATED_ON IS NULL OR :NEW.CREATED_ON = '') THEN
  SELECT sysdate INTO :NEW.CREATED_ON FROM DUAL;
END IF;
IF (:NEW.CREATED_BY IS NULL OR :NEW.CREATED_BY = '') THEN
  SELECT USER INTO :NEW.CREATED_BY FROM DUAL;
END IF;
IF (:NEW.UPDATED_ON IS NULL OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

--------------------------------------------------------
--  DDL for Trigger UT_TEARDOWNS_UP_TRG
--------------------------------------------------------
CREATE OR REPLACE TRIGGER "UT_TEARDOWNS_UP_TRG" BEFORE
  UPDATE ON UT_TEARDOWNS FOR EACH ROW 
BEGIN 
IF (:NEW.UPDATED_ON IS NULL
  OR :NEW.UPDATED_ON = '') THEN
  SELECT sysdate INTO :NEW.UPDATED_ON FROM DUAL;
END IF;
IF (:NEW.UPDATED_BY IS NULL OR :NEW.UPDATED_BY = '') THEN
  SELECT USER INTO :NEW.UPDATED_BY FROM DUAL;
END IF;
END;
/

--------------------------------------------------------
--  DDL for Package UT_UTIL
--------------------------------------------------------

CREATE OR REPLACE PACKAGE "UT_UTIL" AS
  PROCEDURE COPY_TEST(OLD_UT_ID IN VARCHAR2, NEW_NAME VARCHAR2);
END "UT_UTIL";
/

create or replace
PACKAGE BODY "UT_UTIL" AS
  PROCEDURE COPY_TEST(OLD_UT_ID IN VARCHAR2, NEW_NAME VARCHAR2) AS
    TYPE mapTyp IS TABLE OF VARCHAR2(40) INDEX BY VARCHAR2(40);
    arg_map mapTyp;
    ut_map mapTyp;
    impl_map mapTyp;
  BEGIN
    for c in (select ut_id from ut_test where ut_id = old_ut_id) loop
      select sys_guid() into ut_map(c.ut_id) from dual;
    end loop;
    for c in (select arg_id from ut_test_arguments where ut_id = old_ut_id) loop
      select sys_guid() into arg_map(c.arg_id) from dual;
    end loop;
    for c in (select uti_id from ut_test_impl where ut_id = old_ut_id) loop
      select sys_guid() into impl_map(c.uti_id) from dual;
    end loop;
    insert into ut_test (SELECT ut_map(old_ut_id),  new_NAME,  OBJECT_NAME,  OBJECT_TYPE,  OBJECT_OWNER,  OBJECT_CALL,  CONNECTION_NAME, COVERAGE, null,  null,null,null FROM UT_TEST where ut_id = old_ut_id);
    for c in (SELECT ARG_ID,  ut_map(old_ut_id) ut_id,  OWNER,  OBJECT_NAME,  PACKAGE_NAME,  OBJECT_ID,  OVERLOAD,  ARGUMENT_NAME,  POSITION,  SEQUENCE,  DATA_LEVEL,  DATA_TYPE,
                                   DEFAULT_LENGTH,  IN_OUT,  DATA_LENGTH,  DATA_PRECISION,  DATA_SCALE,  RADIX,  CHARACTER_SET_NAME,  TYPE_OWNER,  TYPE_NAME,  TYPE_SUBNAME,  TYPE_LINK,
                                   PLS_TYPE,  CHAR_LENGTH,  CHAR_USED FROM UT_TEST_ARGUMENTS where ut_id = OLD_UT_ID) loop
             insert into ut_test_arguments values (arg_map(c.ARG_ID),  c.ut_id,  c.OWNER,  c.OBJECT_NAME,  c.PACKAGE_NAME,  c.OBJECT_ID,  c.OVERLOAD,  c.ARGUMENT_NAME,  c.POSITION,  c.SEQUENCE,  c.DATA_LEVEL,  c.DATA_TYPE,
             c.DEFAULT_LENGTH,  c.IN_OUT,  c.DATA_LENGTH,  c.DATA_PRECISION,  c.DATA_SCALE,  c.RADIX,  c.CHARACTER_SET_NAME,  c.TYPE_OWNER,  c.TYPE_NAME,  c.TYPE_SUBNAME,  c.TYPE_LINK,
             c.PLS_TYPE,  c.CHAR_LENGTH,  c.CHAR_USED,null,null,null,null);
    end loop;
    for s in (SELECT index_no, startup, lib_startup_id FROM ut_startups WHERE ut_id = old_ut_id) loop
        insert into ut_startups (ut_id, index_no, startup, lib_startup_id) values (ut_map(old_ut_id), s.index_no, s.startup, s.lib_startup_id);
    end loop;
    for t in (SELECT index_no, teardown, lib_teardown_id FROM ut_teardowns WHERE ut_id = old_ut_id) loop
        insert into ut_teardowns (ut_id, index_no, teardown, lib_teardown_id) values (ut_map(old_ut_id), t.index_no, t.teardown, t.lib_teardown_id);
    end loop;
    for c in (SELECT UTI_ID,  ut_map(old_ut_id) ut_id,  NAME,  EXPECTED_RETURN,  EXPECTED_RETURN_ERROR,  DYNAMIC_VALUE_QUERY, LIB_DYN_QUERY_ID, null CREATED_ON,  null CREATED_BY FROM UT_TEST_IMPL where ut_id = OLD_UT_ID) loop
      insert into UT_TEST_IMPL values (impl_map(c.UTI_ID), c.ut_id,  c.NAME,  c.EXPECTED_RETURN,  c.EXPECTED_RETURN_ERROR,  c.DYNAMIC_VALUE_QUERY, c.LIB_DYN_QUERY_ID, null,null,null,null);
      for x in (select UTI_ID, ARG_ID, INPUT_VALUE, OUTPUT_VALUE, TEST_OUTVAL FROM UT_TEST_IMPL_ARGUMENTS where uti_id = c.uti_id) loop
        insert into ut_test_impl_arguments (UTI_ID, ARG_ID, INPUT_VALUE, OUTPUT_VALUE, TEST_OUTVAL) values (impl_map(x.UTI_ID), arg_map(x.ARG_ID), x.INPUT_VALUE, x.OUTPUT_VALUE, x.TEST_OUTVAL);
      end loop;
      for x in (select UTI_ID, INDEX_NO, VALIDATION, LIB_VALIDATION_ID, APPLY_VALIDATION FROM UT_VALIDATIONS where uti_id = c.uti_id) loop
        insert into ut_validations (UTI_ID, INDEX_NO, VALIDATION, LIB_VALIDATION_ID, APPLY_VALIDATION) values (impl_map(x.UTI_ID), x.INDEX_NO, x.VALIDATION, x.LIB_VALIDATION_ID, x.APPLY_VALIDATION);
      end loop;
    end loop;
  END COPY_TEST;
END "UT_UTIL";
/

--------------------------------------------------------
--  DDL for View ALL_UT_LIB_STARTUPS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LIB_STARTUPS"
  (
    "LIB_STARTUP_ID"
   ,"LIB_STARTUP_NAME"
   ,"LIB_STARTUP_CLASS"
   ,"LIB_STARTUP"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "LIB_STARTUP_ID" AS "LIB_STARTUP_ID"
   ,"LIB_STARTUP_NAME" AS "LIB_STARTUP_NAME"
   ,"LIB_STARTUP_CLASS" AS "LIB_STARTUP_CLASS"
   ,"LIB_STARTUP" AS "LIB_STARTUP"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_LIB_STARTUPS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LIB_STARTUPS" IS
  'Unit Test - Startup Code Hook Library';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."LIB_STARTUP_ID" IS
  'Library Startup Code Hook identifier';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."LIB_STARTUP_NAME" IS
  'Code Hook name';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."LIB_STARTUP_CLASS" IS
  'Implementing Java class name';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."LIB_STARTUP" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_LIB_STARTUPS"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_LIB_TEARDOWNS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LIB_TEARDOWNS"
  (
    "LIB_TEARDOWN_ID"
   ,"LIB_TEARDOWN_NAME"
   ,"LIB_TEARDOWN_CLASS"
   ,"LIB_TEARDOWN"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "LIB_TEARDOWN_ID" AS "LIB_TEARDOWN_ID"
   ,"LIB_TEARDOWN_NAME" AS "LIB_TEARDOWN_NAME"
   ,"LIB_TEARDOWN_CLASS" AS "LIB_TEARDOWN_CLASS"
   ,"LIB_TEARDOWN" AS "LIB_TEARDOWN"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_LIB_TEARDOWNS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LIB_TEARDOWNS" IS
  'Unit Test - Teardown Code Hook Library';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."LIB_TEARDOWN_ID" IS
  'Library Teardown Code Hook identifier';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."LIB_TEARDOWN_NAME" IS
  'Code Hook name';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."LIB_TEARDOWN_CLASS" IS
  'Implementing Java class name';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."LIB_TEARDOWN" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_LIB_TEARDOWNS"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_LIB_VALIDATIONS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LIB_VALIDATIONS"
  (
    "LIB_VALIDATION_ID"
   ,"LIB_VALIDATION_NAME"
   ,"LIB_VALIDATION_CLASS"
   ,"LIB_VALIDATION"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "LIB_VALIDATION_ID" AS "LIB_VALIDATION_ID"
   ,"LIB_VALIDATION_NAME" AS "LIB_VALIDATION_NAME"
   ,"LIB_VALIDATION_CLASS" AS "LIB_VALIDATION_CLASS"
   ,"LIB_VALIDATION" AS "LIB_VALIDATION"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_LIB_VALIDATIONS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LIB_VALIDATIONS" IS
  'Unit Test - Validation Code Hook Library';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."LIB_VALIDATION_ID" IS
  'Library Validation Code Hook identifier';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."LIB_VALIDATION_NAME" IS
  'Code Hook name';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."LIB_VALIDATION_CLASS" IS
  'Implementing Java class name';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."LIB_VALIDATION" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_LIB_VALIDATIONS"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_LIB_DYN_QUERIES
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LIB_DYN_QUERIES"
  (
    "LIB_DYN_QUERY_ID"
   ,"LIB_DYN_QUERY_NAME"
   ,"LIB_DYN_QUERY"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "LIB_DYN_QUERY_ID" AS "LIB_DYN_QUERY_ID"
   ,"LIB_DYN_QUERY_NAME" AS "LIB_DYN_QUERY_NAME"
   ,"LIB_DYN_QUERY" AS "LIB_DYN_QUERY"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_LIB_DYN_QUERIES"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LIB_DYN_QUERIES" IS
  'Unit Test - Dynamic Value Query Code Hook Library';

COMMENT ON COLUMN "ALL_UT_LIB_DYN_QUERIES"."LIB_DYN_QUERY_ID" IS
  'Library Dynamic Value Query Code Hook identifier';

COMMENT ON COLUMN "ALL_UT_LIB_DYN_QUERIES"."LIB_DYN_QUERY_NAME" IS
  'Code Hook name';

COMMENT ON COLUMN "ALL_UT_LIB_DYN_QUERIES"."LIB_DYN_QUERY" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_LIB_DYN_QUERIES"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_LIB_DYN_QUERIES"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_LOOKUP_CATEGORIES
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LOOKUP_CATEGORIES"
  (
    "ID"
   ,"NAME"
  )
AS
  SELECT
    "ID" AS "ID"
   ,"NAME" AS "NAME"
  FROM
    "UT_LOOKUP_CATEGORIES"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LOOKUP_CATEGORIES" IS
  'Unit Test - Lookup Categories';

COMMENT ON COLUMN "ALL_UT_LOOKUP_CATEGORIES"."ID" IS
  'Lookup Category identifier';

COMMENT ON COLUMN "ALL_UT_LOOKUP_CATEGORIES"."NAME" IS
  'Category name';

--------------------------------------------------------
--  DDL for View ALL_UT_LOOKUP_DATATYPES
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LOOKUP_DATATYPES"
  (
    "ID"
   ,"CAT_ID"
   ,"TYPE_ID"
   ,"TYPE_STRING"
  )
AS
  SELECT
    "ID" AS "ID"
   ,"CAT_ID" AS "CAT_ID"
   ,"TYPE_ID" AS "TYPE_ID"
   ,"TYPE_STRING" AS "TYPE_STRING"
  FROM
    "UT_LOOKUP_DATATYPES"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LOOKUP_DATATYPES" IS
  'Unit Test - Lookup Datatypes';

COMMENT ON COLUMN "ALL_UT_LOOKUP_DATATYPES"."ID" IS
  'Lookup Datatype identifier';

COMMENT ON COLUMN "ALL_UT_LOOKUP_DATATYPES"."CAT_ID" IS
  'Lookup Category identifier';

COMMENT ON COLUMN "ALL_UT_LOOKUP_DATATYPES"."TYPE_ID" IS
  'Datatype SQL type code';

COMMENT ON COLUMN "ALL_UT_LOOKUP_DATATYPES"."TYPE_STRING" IS
  'Datatype type name';

--------------------------------------------------------
--  DDL for View ALL_UT_LOOKUP_VALUES
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_LOOKUP_VALUES"
  (
    "ID"
   ,"DATA_ID"
   ,"VALUE"
  )
AS
  SELECT
    "ID" AS "ID"
   ,"DATA_ID" AS "DATA_ID"
   ,"VALUE" AS "VALUE"
  FROM
    "UT_LOOKUP_VALUES"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_LOOKUP_VALUES" IS
  'Unit Test - Lookup Value';

COMMENT ON COLUMN "ALL_UT_LOOKUP_VALUES"."ID" IS
  'Lookup Value identifier';

COMMENT ON COLUMN "ALL_UT_LOOKUP_VALUES"."DATA_ID" IS
  'Datatype identifier';

COMMENT ON COLUMN "ALL_UT_LOOKUP_VALUES"."VALUE" IS
  'Value property XML';

--------------------------------------------------------
--  DDL for View ALL_UT_METADATA
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_METADATA"
  (
    "NAME"
   ,"VALUE"
  )
AS
  SELECT
    "NAME" AS "NAME"
   ,"VALUE" AS "VALUE"
  FROM
    "UT_METADATA"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_METADATA" IS
  'Unit Test - Metadata';

COMMENT ON COLUMN "ALL_UT_METADATA"."NAME" IS
  'Metadata name';

COMMENT ON COLUMN "ALL_UT_METADATA"."VALUE" IS
  'Metadata value';

--------------------------------------------------------
--  DDL for View ALL_UT_SUITE
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE"
  (
    "UT_SID"
   ,"COVERAGE"
   ,"NAME"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "UT_SID" AS "UT_SID"
   ,DECODE("COVERAGE", 0, 'N', 'Y') AS "COVERAGE"
   ,"NAME" AS "NAME"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_SUITE"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE" IS
  'Unit Test - Suite';

COMMENT ON COLUMN "ALL_UT_SUITE"."UT_SID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE"."COVERAGE" IS
  'Collect coverage statistics - Y or N';

COMMENT ON COLUMN "ALL_UT_SUITE"."NAME" IS
  'Suite name';

COMMENT ON COLUMN "ALL_UT_SUITE"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_SUITE"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_SUITE_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE_RESULTS"
  (
    "UTSR_ID"
   ,"UT_SID"
   ,"NAME"
   ,"STATUS"
   ,"MESSAGE"
   ,"STARTUP_STATUS"
   ,"STARTUP_MESSAGE"
   ,"STARTUP_START_TIME"
   ,"STARTUP_END_TIME"
   ,"STARTUP_DURATION"
   ,"TEARDOWN_STATUS"
   ,"TEARDOWN_MESSAGE"
   ,"TEARDOWN_START_TIME"
   ,"TEARDOWN_END_TIME"
   ,"TEARDOWN_DURATION"
   ,"RUN_DATE"
  )
AS
  SELECT
    "UTSR_ID" AS "UTSR_ID"
   ,"UT_SID" AS "UT_SID"
   ,"NAME" AS "NAME"
   ,"STATUS" AS "STATUS"
   ,"MESSAGE" AS "MESSAGE"
   ,"STARTUP_STATUS" AS "STARTUP_STATUS"
   ,"STARTUP_MESSAGE" AS "STARTUP_MESSAGE"
   ,"STARTUP_START_TIME" AS "STARTUP_START_TIME"
   ,"STARTUP_END_TIME" AS "STARTUP_END_TIME"
   ,"STARTUP_DURATION" AS "STARTUP_DURATION"
   ,"TEARDOWN_STATUS" AS "TEARDOWN_STATUS"
   ,"TEARDOWN_MESSAGE" AS "TEARDOWN_MESSAGE"
   ,"TEARDOWN_START_TIME" AS "TEARDOWN_START_TIME"
   ,"TEARDOWN_END_TIME" AS "TEARDOWN_END_TIME"
   ,"TEARDOWN_DURATION" AS "TEARDOWN_DURATION"
   ,"RUN_DATE" AS "RUN_DATE"
  FROM
    "UT_SUITE_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE_RESULTS" IS
  'Unit Test - Suite Results';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."UTSR_ID" IS
  'Suite Result identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."UT_SID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."NAME" IS
  'Result name';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STATUS" IS
  'Result status';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."MESSAGE" IS
  'Result message, if any';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STARTUP_STATUS" IS
  'Startup status';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STARTUP_MESSAGE" IS
  'Startup message, if any';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STARTUP_START_TIME" IS
  'Start time of suite startup in formated text';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STARTUP_END_TIME" IS
  'End time of suite startup in formated text';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."STARTUP_DURATION" IS
  'Duration of suite startup in milliseconds';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."TEARDOWN_STATUS" IS
  'Teardown status';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."TEARDOWN_MESSAGE" IS
  'Teardown message, if any';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."TEARDOWN_START_TIME" IS
  'Start time of suite teardown in formated text';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."TEARDOWN_END_TIME" IS
  'End time of suite teardown in formated text';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."TEARDOWN_DURATION" IS
  'Duration of suite teardown in milliseconds';

COMMENT ON COLUMN "ALL_UT_SUITE_RESULTS"."RUN_DATE" IS
  'Suite run timestamp';

--------------------------------------------------------
--  DDL for View ALL_UT_SUITE_ITEMS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE_ITEMS"
  (
    "UT_SID"
   ,"UT_ID"
   ,"UT_NSID"
   ,"RUN_START"
   ,"RUN_TEAR"
   ,"SEQUENCE"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "UT_SID" AS "UT_SID"
   ,"UT_ID" AS "UT_ID"
   ,"UT_NSID" AS "UT_NSID"
   ,"RUN_START" AS "RUN_START"
   ,"RUN_TEAR" AS "RUN_TEAR"
   ,"SEQUENCE" AS "SEQUENCE"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_SUITE_ITEMS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE_ITEMS" IS
  'Unit Test - Suite Items';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_SID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."UT_NSID" IS
  'Nested Suite identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."RUN_START" IS
  'Execute Startup Code Hook - Y or N';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."RUN_TEAR" IS
  'Execute Teardown Code Hook - Y or N';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."SEQUENCE" IS
  'Index within test list of Suite';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEMS"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_SUITE_ITEM_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_SUITE_ITEM_RESULTS"
  (
    "UTSR_ID"
   ,"UTR_ID"
   ,"UTR_NSID"
  )
AS
  SELECT
    "UTSR_ID" AS "UTSR_ID"
   ,"UTR_ID" AS "UTR_ID"
   ,"UTR_NSID" AS "UTR_NSID"
  FROM
    "UT_SUITE_ITEM_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_SUITE_ITEM_RESULTS" IS
  'Unit Test - Item Results within a Suite';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTSR_ID" IS
  'Suite Result identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTR_ID" IS
  'Test Result identifier';

COMMENT ON COLUMN "ALL_UT_SUITE_ITEM_RESULTS"."UTR_NSID" IS
  'Nested Suite Result identifier';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST"
  (
    "UT_ID"
   ,"NAME"
   ,"OBJECT_NAME"
   ,"OBJECT_TYPE"
   ,"OBJECT_OWNER"
   ,"OBJECT_CALL"
   ,"CONNECTION_NAME"
   ,"COVERAGE"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "UT_ID" AS "UT_ID"
   ,"NAME" AS "NAME"
   ,"OBJECT_NAME" AS "OBJECT_NAME"
   ,"OBJECT_TYPE" AS "OBJECT_TYPE"
   ,"OBJECT_OWNER" AS "OBJECT_OWNER"
   ,"OBJECT_CALL" AS "OBJECT_CALL"
   ,"CONNECTION_NAME" AS "CONNECTION_NAME"
   ,DECODE("COVERAGE", 0, 'N', 'Y') AS "COVERAGE"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_TEST"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST" IS
  'Unit Test - Tests';

COMMENT ON COLUMN "ALL_UT_TEST"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEST"."NAME" IS
  'Test name';

COMMENT ON COLUMN "ALL_UT_TEST"."OBJECT_NAME" IS
  'Database object name';

COMMENT ON COLUMN "ALL_UT_TEST"."OBJECT_TYPE" IS
  'Database object type';

COMMENT ON COLUMN "ALL_UT_TEST"."OBJECT_OWNER" IS
  'Database object owner';

COMMENT ON COLUMN "ALL_UT_TEST"."OBJECT_CALL" IS
  'Database object callable interface';

COMMENT ON COLUMN "ALL_UT_TEST"."CONNECTION_NAME" IS
  'Name of connection used to import test';

COMMENT ON COLUMN "ALL_UT_TEST"."COVERAGE" IS
  'Collect coverage statistics - Y or N';

COMMENT ON COLUMN "ALL_UT_TEST"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_TEST"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_ARGUMENTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_ARGUMENTS"
  (
    "ARG_ID"
   ,"UT_ID"
   ,"OWNER"
   ,"OBJECT_NAME"
   ,"PACKAGE_NAME"
   ,"OBJECT_ID"
   ,"OVERLOAD"
   ,"ARGUMENT_NAME"
   ,"POSITION"
   ,"SEQUENCE"
   ,"DATA_LEVEL"
   ,"DATA_TYPE"
   ,"DEFAULT_LENGTH"
   ,"IN_OUT"
   ,"DATA_LENGTH"
   ,"DATA_PRECISION"
   ,"DATA_SCALE"
   ,"RADIX"
   ,"CHARACTER_SET_NAME"
   ,"TYPE_OWNER"
   ,"TYPE_NAME"
   ,"TYPE_SUBNAME"
   ,"TYPE_LINK"
   ,"PLS_TYPE"
   ,"CHAR_LENGTH"
   ,"CHAR_USED"
  )
AS
  SELECT
    "ARG_ID" AS "ARG_ID"
   ,"UT_ID" AS "UT_ID"
   ,"OWNER" AS "OWNER"
   ,"OBJECT_NAME" AS "OBJECT_NAME"
   ,"PACKAGE_NAME" AS "PACKAGE_NAME"
   ,"OBJECT_ID" AS "OBJECT_ID"
   ,"OVERLOAD" AS "OVERLOAD"
   ,"ARGUMENT_NAME" AS "ARGUMENT_NAME"
   ,"POSITION" AS "POSITION"
   ,"SEQUENCE" AS "SEQUENCE"
   ,"DATA_LEVEL" AS "DATA_LEVEL"
   ,"DATA_TYPE" AS "DATA_TYPE"
   ,"DEFAULT_LENGTH" AS "DEFAULT_LENGTH"
   ,"IN_OUT" AS "IN_OUT"
   ,"DATA_LENGTH" AS "DATA_LENGTH"
   ,"DATA_PRECISION" AS "DATA_PRECISION"
   ,"DATA_SCALE" AS "DATA_SCALE"
   ,"RADIX" AS "RADIX"
   ,"CHARACTER_SET_NAME" AS "CHARACTER_SET_NAME"
   ,"TYPE_OWNER" AS "TYPE_OWNER"
   ,"TYPE_NAME" AS "TYPE_NAME"
   ,"TYPE_SUBNAME" AS "TYPE_SUBNAME"
   ,"TYPE_LINK" AS "TYPE_LINK"
   ,"PLS_TYPE" AS "PLS_TYPE"
   ,"CHAR_LENGTH" AS "CHAR_LENGTH"
   ,"CHAR_USED" AS "CHAR_USED"
  FROM
    "UT_TEST_ARGUMENTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_ARGUMENTS" IS
  'Unit Test - Test Arguments imported from ALL_ARGUMENTS view';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."ARG_ID" IS
  'Test Argument identifier';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."OWNER" IS
  'Username of the owner of the object';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."OBJECT_NAME" IS
  'Procedure or function name';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."PACKAGE_NAME" IS
  'Package name';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."OBJECT_ID" IS
  'Object number of the object';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."OVERLOAD" IS
  'Overload unique identifier';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."ARGUMENT_NAME" IS
  'Argument name';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."POSITION" IS
  'Position in argument list, or null for function return value';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."SEQUENCE" IS
  'Argument sequence, including all nesting levels';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DATA_LEVEL" IS
  'Nesting depth of argument for composite types';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DATA_TYPE" IS
  'Datatype of the argument';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DEFAULT_LENGTH" IS
  'Length of default value for the argument';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."IN_OUT" IS
  'Argument direction (IN, OUT, or IN/OUT)';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DATA_LENGTH" IS
  'Length of default value for the argument';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DATA_PRECISION" IS
  'Length: decimal digits (NUMBER) or binary digits (FLOAT)';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."DATA_SCALE" IS
  'Digits to right of decimal point in a number';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."RADIX" IS
  'Argument radix for a number';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."CHARACTER_SET_NAME" IS
  'Character set name for the argument';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."TYPE_OWNER" IS
  'Owner name for the argument type in case of object types';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."TYPE_NAME" IS
  'Object name for the argument type in case of object types';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."TYPE_SUBNAME" IS
  'Subordinate object name for the argument type in case of object types';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."TYPE_LINK" IS
  'Database link name for the argument type in case of object types';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."PLS_TYPE" IS
  'PL/SQL type name for numeric arguments';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."CHAR_LENGTH" IS
  'Character limit for string datatypes';

COMMENT ON COLUMN "ALL_UT_TEST_ARGUMENTS"."CHAR_USED" IS
  'Is the byte limit (B) or char limit (C) official for this string?';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_COVERAGE_STATS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_COVERAGE_STATS"
  (
    "UTC_ID"
   ,"UTIR_ID"
   ,"UTI_ID"
   ,"UNIT_OWNER"
   ,"UNIT_NAME"
   ,"LINE"
   ,"TOTAL_OCCUR"
   ,"TOTAL_TIME"
   ,"TEXT"
  )
AS
  SELECT
    "UTC_ID" AS "UTC_ID"
   ,"UTIR_ID" AS "UTIR_ID"
   ,"UTI_ID" AS "UTI_ID"
   ,"UNIT_OWNER" AS "UNIT_OWNER"
   ,"UNIT_NAME" AS "UNIT_NAME"
   ,"LINE" AS "LINE"
   ,"TOTAL_OCCUR" AS "TOTAL_OCCUR"
   ,"TOTAL_TIME" AS "TOTAL_TIME"
   ,"TEXT" AS "TEXT"
  FROM
    "UT_TEST_COVERAGE_STATS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_COVERAGE_STATS" IS
  'Unit Test - Coverage Statistics';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."UTC_ID" IS
  'Coverage Statistics identifier';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."UTIR_ID" IS
  'Test Implementation Results identifier';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."UNIT_OWNER" IS
  'Owner of callable database object';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."UNIT_NAME" IS
  'Name of callable database object';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."LINE" IS
  'Line number of executed code';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."TOTAL_OCCUR" IS
  'Number of time line of code executed';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."TOTAL_TIME" IS
  'Accumulated time elasped time line of code executed in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_COVERAGE_STATS"."TEXT" IS
  'Text of executed line';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_IMPL
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_IMPL"
  (
    "UTI_ID"
   ,"UT_ID"
   ,"NAME"
   ,"EXPECTED_RETURN"
   ,"EXPECTED_RETURN_ERROR"
   ,"DYNAMIC_VALUE_QUERY"
   ,"LIB_DYN_QUERY_ID"
   ,"CREATED_ON"
   ,"CREATED_BY"
  )
AS
  SELECT
    "UTI_ID" AS "UTI_ID"
   ,"UT_ID" AS "UT_ID"
   ,"NAME" AS "NAME"
   ,"EXPECTED_RETURN" AS "EXPECTED_RETURN"
   ,"EXPECTED_RETURN_ERROR" AS "EXPECTED_RETURN_ERROR"
   ,"DYNAMIC_VALUE_QUERY" AS "DYNAMIC_VALUE_QUERY"
   ,"LIB_DYN_QUERY_ID" AS "LIB_DYN_QUERY_ID"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
  FROM
    "UT_TEST_IMPL"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_IMPL" IS
  'Unit Test - Test Implementations';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."NAME" IS
  'Implementation name';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."EXPECTED_RETURN" IS
  'Expected returned status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."EXPECTED_RETURN_ERROR" IS
  'Expected returned error message ';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."DYNAMIC_VALUE_QUERY" IS
  'Dynamic query used to populate test argument values';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_IMPL_ARGUMENTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_IMPL_ARGUMENTS"
  (
    "UTI_ID"
   ,"ARG_ID"
   ,"INPUT_VALUE"
   ,"OUTPUT_VALUE"
   ,"TEST_OUTVAL"
  )
AS
  SELECT
    "UTI_ID" AS "UTI_ID"
   ,"ARG_ID" AS "ARG_ID"
   ,"INPUT_VALUE" AS "INPUT_VALUE"
   ,"OUTPUT_VALUE" AS "OUTPUT_VALUE"
   ,DECODE("TEST_OUTVAL", 0, 'N', 'Y') AS "TEST_OUTVAL"
  FROM
    "UT_TEST_IMPL_ARGUMENTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_IMPL_ARGUMENTS" IS
  'Unit Test - Test Implementation Arguments';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARGUMENTS"."UTI_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARGUMENTS"."ARG_ID" IS
  'Test Argument identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARGUMENTS"."INPUT_VALUE" IS
  'Input parameter value property XML';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARGUMENTS"."OUTPUT_VALUE" IS
  'Expected output parameter value property XML';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARGUMENTS"."TEST_OUTVAL" IS
  'Test output value - Y or N';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_IMPL_ARG_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_IMPL_ARG_RESULTS"
  (
    "UTIAR_ID"
   ,"UTIR_ID"
   ,"UTI_ID"
   ,"ARG_ID"
   ,"NAME"
   ,"STATUS"
   ,"MESSAGE"
   ,"RUN_DATE"
  )
AS
  SELECT
    "UTIAR_ID" AS "UTIAR_ID"
   ,"UTIR_ID" AS "UTIR_ID"
   ,"UTI_ID" AS "UTI_ID"
   ,"ARG_ID" AS "ARG_ID"
   ,"NAME" AS "NAME"
   ,"STATUS" AS "STATUS"
   ,"MESSAGE" AS "MESSAGE"
   ,"RUN_DATE" AS "RUN_DATE"
  FROM
    "UT_TEST_IMPL_ARG_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_IMPL_ARG_RESULTS" IS
  'Unit Test - Test Implementation Argument Results';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."UTIAR_ID" IS
  'Test Implementation Argument Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."UTIR_ID" IS
  'Test Implementation Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."ARG_ID" IS
  'Test Argument identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."NAME" IS
  'Result name';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."STATUS" IS
  'Result status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."MESSAGE" IS
  'Result message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_ARG_RESULTS"."RUN_DATE" IS
  'Test run timestamp';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_IMPL_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_IMPL_RESULTS"
  (
    "UTIR_ID"
   ,"UTI_ID"
   ,"UTR_ID"
   ,"NAME"
   ,"STATUS"
   ,"MESSAGE"
   ,"START_TIME"
   ,"END_TIME"
   ,"DURATION"
   ,"STARTUP_STATUS"
   ,"STARTUP_MESSAGE"
   ,"STARTUP_START_TIME"
   ,"STARTUP_END_TIME"
   ,"STARTUP_DURATION"
   ,"OP_CALL_STATUS"
   ,"OP_CALL_MESSAGE"
   ,"OP_CALL_START_TIME"
   ,"OP_CALL_END_TIME"
   ,"OP_CALL_DURATION"
   ,"TEARDOWN_STATUS"
   ,"TEARDOWN_MESSAGE"
   ,"TEARDOWN_START_TIME"
   ,"TEARDOWN_END_TIME"
   ,"TEARDOWN_DURATION"
   ,"RUN_DATE"
  )
AS
  SELECT
    "UTIR_ID" AS "UTIR_ID"
   ,"UTI_ID" AS "UTI_ID"
   ,"UTR_ID" AS "UTR_ID"
   ,"NAME" AS "NAME"
   ,"STATUS" AS "STATUS"
   ,"MESSAGE" AS "MESSAGE"
   ,"START_TIME" AS "START_TIME"
   ,"END_TIME" AS "END_TIME"
   ,"DURATION" AS "DURATION"
   ,"STARTUP_STATUS" AS "STARTUP_STATUS"
   ,"STARTUP_MESSAGE" AS "STARTUP_MESSAGE"
   ,"STARTUP_START_TIME" AS "STARTUP_START_TIME"
   ,"STARTUP_END_TIME" AS "STARTUP_END_TIME"
   ,"STARTUP_DURATION" AS "STARTUP_DURATION"
   ,"OP_CALL_STATUS" AS "OP_CALL_STATUS"
   ,"OP_CALL_MESSAGE" AS "OP_CALL_MESSAGE"
   ,"OP_CALL_START_TIME" AS "OP_CALL_START_TIME"
   ,"OP_CALL_END_TIME" AS "OP_CALL_END_TIME"
   ,"OP_CALL_DURATION" AS "OP_CALL_DURATION"
   ,"TEARDOWN_STATUS" AS "TEARDOWN_STATUS"
   ,"TEARDOWN_MESSAGE" AS "TEARDOWN_MESSAGE"
   ,"TEARDOWN_START_TIME" AS "TEARDOWN_START_TIME"
   ,"TEARDOWN_END_TIME" AS "TEARDOWN_END_TIME"
   ,"TEARDOWN_DURATION" AS "TEARDOWN_DURATION"
   ,"RUN_DATE" AS "RUN_DATE"
  FROM
    "UT_TEST_IMPL_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_IMPL_RESULTS" IS
  'Unit Test - Test Implementation Results';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."UTIR_ID" IS
  'Test Implementation Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."UTR_ID" IS
  'Test Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."NAME" IS
  'Result name';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STATUS" IS
  'Result status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."MESSAGE" IS
  'Result message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."START_TIME" IS
  'Start time of test run in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."END_TIME" IS
  'End time of test run in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."DURATION" IS
  'Duration of test run in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STARTUP_STATUS" IS
  'Startup status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STARTUP_MESSAGE" IS
  'Startup message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STARTUP_START_TIME" IS
  'Start time of test run startup in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STARTUP_END_TIME" IS
  'End time of test run startup in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."STARTUP_DURATION" IS
  'Duration of test run startup in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."OP_CALL_STATUS" IS
  'Operation call status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."OP_CALL_MESSAGE" IS
  'Operation call message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."OP_CALL_START_TIME" IS
  'Start time of test run operation call in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."OP_CALL_END_TIME" IS
  'End time of test run operation call in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."OP_CALL_DURATION" IS
  'Duration of test run operation call in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."TEARDOWN_STATUS" IS
  'Teardown status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."TEARDOWN_MESSAGE" IS
  'Teardown message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."TEARDOWN_START_TIME" IS
  'Start time of test run teardown in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."TEARDOWN_END_TIME" IS
  'End time of test run teardown in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."TEARDOWN_DURATION" IS
  'Duration of test run teardown in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_RESULTS"."RUN_DATE" IS
  'Test run timestamp';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_IMPL_VAL_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_IMPL_VAL_RESULTS"
  (
    "UTIVR_ID"
   ,"UTIR_ID"
   ,"UTI_ID"
   ,"VAL_ID"
   ,"VAL_TYPE"
   ,"STATUS"
   ,"MESSAGE"
   ,"VAL_START_TIME"
   ,"VAL_END_TIME"
   ,"VAL_DURATION"
   ,"RUN_DATE"
  )
AS
  SELECT
    "UTIVR_ID" AS "UTIVR_ID"
   ,"UTIR_ID" AS "UTIR_ID"
   ,"UTI_ID" AS "UTI_ID"
   ,"VAL_ID" AS "VAL_ID"
   ,"VAL_TYPE" AS "VAL_TYPE"
   ,"STATUS" AS "STATUS"
   ,"MESSAGE" AS "MESSAGE"
   ,"VAL_START_TIME" AS "VAL_START_TIME"
   ,"VAL_END_TIME" AS "VAL_END_TIME"
   ,"VAL_DURATION" AS "VAL_DURATION"
   ,"RUN_DATE" AS "RUN_DATE"
  FROM
    "UT_TEST_IMPL_VAL_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_IMPL_VAL_RESULTS" IS
  'Unit Test - Test Implementation Validation Results';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."UTIVR_ID" IS
  'Test Implementation Validation Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."UTIR_ID" IS
  'Test Implementation Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."VAL_ID" IS
  'Validation identifier';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."VAL_TYPE" IS
  'Validation type';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."STATUS" IS
  'Validation status';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."MESSAGE" IS
  'Validation message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."VAL_START_TIME" IS
  'Start time of test run validation in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."VAL_END_TIME" IS
  'End time of test run validation in formated text';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."VAL_DURATION" IS
  'Duration of test run validation in milliseconds';

COMMENT ON COLUMN "ALL_UT_TEST_IMPL_VAL_RESULTS"."RUN_DATE" IS
  'Test run timestamp';

--------------------------------------------------------
--  DDL for View ALL_UT_TEST_RESULTS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_TEST_RESULTS"
  (
    "UTR_ID"
   ,"UT_ID"
   ,"NAME"
   ,"STATUS"
   ,"MESSAGE"
   ,"RUN_DATE"
  )
AS
  SELECT
    "UTR_ID" AS "UTR_ID"
   ,"UT_ID" AS "UT_ID"
   ,"NAME" AS "NAME"
   ,"STATUS" AS "STATUS"
   ,"MESSAGE" AS "MESSAGE"
   ,"RUN_DATE" AS "RUN_DATE"
  FROM
    "UT_TEST_RESULTS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_TEST_RESULTS" IS
  'Unit Test - Test Results';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."UTR_ID" IS
  'Test Result identifier';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."NAME" IS
  'Result name';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."STATUS" IS
  'Result status';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."MESSAGE" IS
  'Result message, if any';

COMMENT ON COLUMN "ALL_UT_TEST_RESULTS"."RUN_DATE" IS
  'Test run timestamp';

--------------------------------------------------------
--  DDL for View ALL_UT_VALIDATIONS
--------------------------------------------------------

CREATE OR REPLACE FORCE VIEW "ALL_UT_VALIDATIONS"
  (
    "VALIDATION_ID"
   ,"UTI_ID"
   ,"INDEX_NO"
   ,"VALIDATION"
   ,"LIB_VALIDATION_ID"
   ,"CREATED_ON"
   ,"CREATED_BY"
   ,"APPLY_VALIDATION"
  )
AS
  SELECT
    "VALIDATION_ID" AS "VALIDATION_ID"
   ,"UTI_ID" AS "UTI_ID"
   ,"INDEX_NO" AS "INDEX_NO"
   ,"VALIDATION" AS "VALIDATION"
   ,"LIB_VALIDATION_ID" AS "LIB_VALIDATION_ID"
   ,"CREATED_ON" AS "CREATED_ON"
   ,"CREATED_BY" AS "CREATED_BY"
   ,DECODE("APPLY_VALIDATION", 0, 'N', 'Y') AS "APPLY_VALIDATION"
  FROM
    "UT_VALIDATIONS"
  WITH READ ONLY;

COMMENT ON TABLE "ALL_UT_VALIDATIONS" IS
  'Unit Test - Validation Code Hooks';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."VALIDATION_ID" IS
  'Validation Code Hook usage identifier';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."UTI_ID" IS
  'Test Implementation identifier';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."INDEX_NO" IS
  'Index within list of validations of Test Implementation';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."VALIDATION" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."LIB_VALIDATION_ID" IS
  'Library Validation Code Hook identifier when referencing library object';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."CREATED_BY" IS
  'Created by user';

COMMENT ON COLUMN "ALL_UT_VALIDATIONS"."APPLY_VALIDATION" IS
  'Apply validation during test run - Y or N';

--------------------------------------------------------
--  DDL for View ALL_UT_STARTUPS
--------------------------------------------------------

CREATE OR REPLACE VIEW "ALL_UT_STARTUPS" ( 
  "STARTUP_ID", 
  "UT_ID", 
  "UT_SID", 
  "INDEX_NO", 
  "STARTUP", 
  "LIB_STARTUP_ID", 
  "CREATED_ON", 
  "CREATED_BY" )
AS
  SELECT "STARTUP_ID",
    "UT_ID",
    "UT_SID",
    "INDEX_NO",
    "STARTUP",
    "LIB_STARTUP_ID",
    "CREATED_ON",
    "CREATED_BY"
  FROM ut_startups;
  
  COMMENT ON TABLE "ALL_UT_STARTUPS" IS
  'Unit Test - Startup Code Hooks';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."STARTUP_ID" IS
  'Startup Code Hook usage identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."UT_ID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."INDEX_NO" IS
  'Index within list of startups of Test';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."STARTUP" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."LIB_STARTUP_ID" IS
  'Library Startup Code Hook identifier when referencing library object';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_STARTUPS"."CREATED_BY" IS
  'Created by user';

--------------------------------------------------------
--  DDL for View ALL_UT_TEARDOWNS
--------------------------------------------------------

CREATE OR REPLACE VIEW "ALL_UT_TEARDOWNS" ( 
  "TEARDOWN_ID", 
  "UT_ID", 
  "UT_SID", 
  "INDEX_NO", 
  "TEARDOWN", 
  "LIB_TEARDOWN_ID", 
  "CREATED_ON", 
  "CREATED_BY" )
AS
  SELECT "TEARDOWN_ID",
    "UT_ID",
    "UT_SID",
    "INDEX_NO",
    "TEARDOWN",
    "LIB_TEARDOWN_ID",
    "CREATED_ON",
    "CREATED_BY"
  FROM UT_TEARDOWNS;
  
  COMMENT ON TABLE "ALL_UT_TEARDOWNS" IS
  'Unit Test - Teardown Code Hooks';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."TEARDOWN_ID" IS
  'Teardown Code Hook usage identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."UT_ID" IS
  'Test identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."UT_ID" IS
  'Suite identifier';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."INDEX_NO" IS
  'Index within list of teardowns of Test';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."TEARDOWN" IS
  'Code Hook property XML';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."LIB_TEARDOWN_ID" IS
  'Library Teardown Code Hook identifier when referencing library object';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."CREATED_ON" IS
  'Creation timestamp';

COMMENT ON COLUMN "ALL_UT_TEARDOWNS"."CREATED_BY" IS
  'Created by user';
  
---------------------------------------------------
--   DATA FOR TABLE UT_METADATA
--   FILTER = none used
---------------------------------------------------
REM INSERTING into UT_METADATA
Insert into UT_METADATA (NAME,VALUE) values ('VERSION','20');
commit;
---------------------------------------------------
--   DATA FOR TABLE UT_LOOKUP_CATEGORIES
---------------------------------------------------
Insert into UT_LOOKUP_CATEGORIES (ID,NAME) values ('AAbcAAbc123123abab','DEFAULT');
commit;
---------------------------------------------------
--   END DATA FOR TABLE UT_METADATA
---------------------------------------------------
  

